---
Title: "Tutorials"
weight: 30
description: "Entry page for the Octopus tutorials"
menu: "top"
---

Here you will find a collection of tutorials covering a wide range of topics, from the basics of performing calculations with {{<octopus>}} to more advanced features. Several series of linked tutorials are proposed to guide you on how to perform certain types of calculations. These tutorials do not by any means cover all the things that {{<octopus>}} can do for you, but hopefully they cover the most common options. You can find more information in the {{< manual "" "online Manual" >}}.

If you have never used {{<octopus>}} before, then you should start with the {{<octopus>}} basics series of tutorials.

A complete list of all available tutorials can be found here. The tutorials are also organized by categories that you can browse in case you are interested in some specific type of system, feature, or calculation mode.

## Main tutorial series

* {{< tutorial "Basics" "Octopus Basics" >}} - getting started with {{< octopus >}}.
* {{< tutorial "Response" "Optical Response" >}} - how to calculate several types of optical response with different methods.
* {{< tutorial "Periodic Systems" "Periodic systems" >}} - periodic boundary conditions, band structures, etc.
* {{< tutorial "Model" "Model systems" >}} - working with model systems, like quantum dots or quantum wells.
* {{< tutorial "HPC" "High Performance Computing" >}} - periodic boundary conditions, band structures, etc.
* {{< tutorial "Maxwell" "Maxwell Propagation" >}} - numerical electrodynamics.
* {{< tutorial "CECAM_2024" "CECAM school 2024" >}} - new tutorials on light matter coupling

## Difficulty level

{{< tutorial-list "difficulties" >}}

## Theory level

{{< tutorial-list "theories" >}}

## Calculation mode

{{< tutorial-list "calculation_modes" >}}

## System type

{{< tutorial-list "system_types" >}}

## Species type

{{< tutorial-list "species_types" >}}

## Feature

{{< tutorial-list "features" >}}

## Utility

{{< tutorial-list "utilities" >}}
