set xlabel "Energy (eV)"
set ylabel "Strength Function (1/eV)"
set t postscript enhanced color font "Monospace-Bold,25" landscape size 11,8.5
set output "Triplet_casida_td_CH4.eps"
set key top left

set rmargin 4.5
set lmargin 10.5
set tmargin 3.2
set bmargin 5.5

set yrange [0:]
set xrange [0:20]
set ytics 0.5
set mxtics 5
set mytics 5

plot "cross_section_vector" u 1:($8-$9) w l lw 2 t "time-propagation", "spectrum.casida-triplets" u 1:5 w l lw 2 t "Casida"
