# syntax=docker/dockerfile:1.7
FROM debian:bookworm-slim AS build

RUN DEBIAN_FRONTEND=noninteractive apt-get -y update \
  && apt-get -y install \
  build-essential \
  ca-certificates \
  cmake \
  g++ \
  gcc \
  gfortran \
  git \
  libatlas-base-dev \
  libblas-dev \
  libboost-dev \
  libcgal-dev \
  libelpa-dev \
  libetsf-io-dev \
  libfftw3-dev \
  libgmp-dev \
  libgsl-dev \
  liblapack-dev \
  libmetis-dev \
  libmpfr-dev \
  libnetcdff-dev \
  libnlopt-dev \
  libopenmpi-dev \
  libscalapack-mpi-dev \
  libyaml-dev \
  ninja-build \
  pkgconf \
  wget \
  && rm -rf /var/lib/apt/lists/*

RUN wget --quiet https://developer.download.nvidia.com/compute/cuda/repos/debian12/x86_64/cuda-keyring_1.1-1_all.deb \
  && dpkg -i cuda-keyring_1.1-1_all.deb \
  && rm cuda-keyring_1.1-1_all.deb

RUN DEBIAN_FRONTEND=noninteractive apt-get -y update \
  && apt-get -y install cuda-12-8 \
  && rm -rf /var/lib/apt/lists/*

RUN sed -iE 's@${_IMPORT_PREFIX}/lib/@${_IMPORT_PREFIX}/lib/${CMAKE_LIBRARY_ARCHITECTURE}/@g' /usr/lib/cmake/scalapack-2.2.1.openmpi/scalapack-targets-none.cmake

WORKDIR /opt/octopus
COPY . .

RUN cmake --preset default --install-prefix /app -DOCTOPUS_OpenMP=On -DOCTOPUS_MPI=On -DOCTOPUS_APP_TESTS=Off -DOCTOPUS_CUDA=On -DOCTOPUS_ScaLAPACK=On
RUN cmake --build ./cmake-build-release
RUN cmake --install ./cmake-build-release


FROM debian:bookworm-slim AS deploy-base

RUN DEBIAN_FRONTEND=noninteractive apt-get -y update \
  && apt-get -y install --no-install-recommends --no-install-suggests \
  ca-certificates \
  libatlas3-base \
  libblas3 \
  libelpa19 \
  libfftw3-bin \
  libgmp10 \
  libgsl27 \
  liblapack3 \
  libmetis5 \
  libmpfr6 \
  libnetcdff7 \
  libnlopt0 \
  libscalapack-openmpi2.2 \
  wget \
  && rm -rf /var/lib/apt/lists/*

RUN wget --quiet https://developer.download.nvidia.com/compute/cuda/repos/debian12/x86_64/cuda-keyring_1.1-1_all.deb \
  && dpkg -i cuda-keyring_1.1-1_all.deb \
  && rm cuda-keyring_1.1-1_all.deb

RUN DEBIAN_FRONTEND=noninteractive apt-get -y update \
  && apt-get -y install \
  cuda-runtime-12-8 \
  cuda-compat-12-8 \
  cuda-nvtx-12-8 \
  && rm -rf /var/lib/apt/lists/*

COPY --from=build /app /app

# allow root execution of mpirun
ENV OMPI_ALLOW_RUN_AS_ROOT=1 OMPI_ALLOW_RUN_AS_ROOT_CONFIRM=1
# https://github.com/open-mpi/ompi/issues/4948
ENV OMPI_MCA_btl_vader_single_copy_mechanism=none
# set number of OpenMP threads to 1 by default
ENV OMP_NUM_THREADS=1

ENV PATH="/app/bin:$PATH"


FROM deploy-base AS test-deployment
RUN octopus --version
RUN octopus --config

# No tests can be executed because no GPU is available on the build machine

FROM deploy-base AS deploy
WORKDIR /io
CMD ["octopus"]

