!! Copyright (C) 2009 X. Andrade
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!

#include "global.h"
#include "io_binary.h"

module io_csv_oct_m
  use debug_oct_m
  use global_oct_m
  use iso_c_binding
  use string_oct_m

  implicit none

  private

  public ::        &
    dread_csv,     &
    io_csv_get_info


  interface
    subroutine read_csv(np, f, output_type, ierr, fname) bind(C)
      use iso_c_binding
      implicit none
      integer(c_int64_t),     intent(in)  :: np
      type(c_ptr),            value       :: f
      integer(C_INT),         intent(in)  :: output_type
      integer(C_INT),         intent(out) :: ierr
      character(kind=c_char), intent(in)  :: fname(*)
    end subroutine read_csv

    subroutine get_info_csv(dims, ierr, filename) bind(C)
      use iso_c_binding
      implicit none
      type(c_ptr),            value         :: dims
      integer(C_INT),         intent(out)   :: ierr
      character(kind=c_char), intent(in)    :: filename(*)
    end subroutine get_info_csv

  end interface

contains

  subroutine dread_csv(fname, np, ff, ierr)
    character(len=*),     intent(in)    :: fname
    integer(c_int64_t),   intent(in)    :: np
    real(real64), target, intent(out)   :: ff(:)
    integer,              intent(out)   :: ierr

    PUSH_SUB(dread_csv)

    call read_csv(np, c_loc(ff(1)), TYPE_DOUBLE, ierr, string_f_to_c(fname))

    POP_SUB(dread_csv)
  end subroutine dread_csv

  subroutine io_csv_get_info(fname, dims, ierr)
    character(len=*),           intent(in)    :: fname
    integer(c_int64_t), target, intent(out)   :: dims(:)
    integer,                    intent(out)   :: ierr

    PUSH_SUB(io_csv_get_info)

    call get_info_csv(c_loc(dims(1)), ierr, string_f_to_c(fname))

    POP_SUB(io_csv_get_info)
  end subroutine io_csv_get_info

end module io_csv_oct_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
