!! Copyright (C) 2023 M. Oliveira
!!
!! This Source Code Form is subject to the terms of the Mozilla Public
!! License, v. 2.0. If a copy of the MPL was not distributed with this
!! file, You can obtain one at https://mozilla.org/MPL/2.0/.
!!

#include "global.h"

!> This module defines the abstract interfact for algorithm factories
module algorithm_factory_oct_m
  use algorithm_oct_m
  use interaction_partner_oct_m
  implicit none

  private
  public ::                        &
    algorithm_factory_t

  !> @brief Abstract class for the algorithm factories
  !!
  !! The abstract algorithm factory defines the abstract interface for the algorithm factories and needs
  !! to be specialized for actual use.
  !
  type, abstract :: algorithm_factory_t
  contains
    procedure(algorithm_factory_create),        deferred :: create        !< create a general algorithm
    procedure(algorithm_factory_create_static), deferred :: create_static !< create a static algorithm
  end type algorithm_factory_t

  abstract interface
    function algorithm_factory_create(this, system) result(algorithm)
      import :: algorithm_factory_t
      import interaction_partner_t
      import algorithm_t
      class(algorithm_factory_t),   intent(in)          :: this
      class(interaction_partner_t), intent(in),  target :: system
      class(algorithm_t),           pointer             :: algorithm
    end function algorithm_factory_create

    function algorithm_factory_create_static(this, system) result(algorithm)
      import :: algorithm_factory_t
      import interaction_partner_t
      import algorithm_t
      class(algorithm_factory_t),   intent(in)          :: this
      class(interaction_partner_t), intent(in),  target :: system
      class(algorithm_t),           pointer             :: algorithm
    end function algorithm_factory_create_static
  end interface

end module algorithm_factory_oct_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
