!! Copyright (C) 2023 M. Oliveira
!!
!! This Source Code Form is subject to the terms of the Mozilla Public
!! License, v. 2.0. If a copy of the MPL was not distributed with this
!! file, You can obtain one at https://mozilla.org/MPL/2.0/.
!!

module interaction_surrogate_oct_m
  implicit none

  private
  public ::                &
    interaction_surrogate_t

  !> @brief surrogate interaction class to avoid circular dependencies between
  !> modules.
  !!
  !! This class is used only for the purpose of avoiding circular dependencies
  !! between the interaction_partner_oct_m and interaction_oct_m modules.
  !! Without this surrogate, several methods of interaction_partner_t would have
  !! to take an instance of interaction_t as argument, and therefore
  !! interaction_partner_oct_m would need to use interaction_oct_m. On the other
  !! hand, interaction_t has a pointer to an instance of interaction_partner_t,
  !! so interaction_partner_oct_m would need to use interaction_oct_m.
  !!
  !! NB: This class should only ever be used when strickly necessary. Currently
  !! that is only in the deferred methods of interaction_partner_t that require
  !! an interaction.
  type, abstract :: interaction_surrogate_t
  end type interaction_surrogate_t

end module interaction_surrogate_oct_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
