!! Copyright (C) 2022 N. Tancogne-Dejean
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!

#include "global.h"

module vtau_mixer_oct_m
  use debug_oct_m
  use global_oct_m
  use hamiltonian_elec_oct_m
  use ks_potential_oct_m
  use messages_oct_m
  use mix_oct_m
  use namespace_oct_m
  use profiling_oct_m
  use types_oct_m
  use xc_oct_m

  implicit none

  private

  public ::                     &
    vtau_mixer_t,              &
    vtau_mixer_init_auxmixer,  &
    vtau_mixer_clear,          &
    vtau_mixer_end,            &
    vtau_mixer_set_vout,       &
    vtau_mixer_set_vin,        &
    vtau_mixer_get_vnew

  type vtau_mixer_t
    private
    logical :: apply = .false.

    type(mixfield_t)  :: field
  end type vtau_mixer_t

contains

  ! ---------------------------------------------------------
  subroutine vtau_mixer_init_auxmixer(namespace, mixer, smix, hm, np, nspin)
    type(namespace_t),     intent(in)    :: namespace
    type(vtau_mixer_t),    intent(inout) :: mixer
    type(mix_t),           intent(inout) :: smix
    type(hamiltonian_elec_t), intent(in) :: hm
    integer,               intent(in)    :: np
    integer,               intent(in)    :: nspin

    PUSH_SUB(vtau_mixer_init_auxmixer)

    if (family_is_mgga_with_exc(hm%xc) .and. hm%theory_level == GENERALIZED_KOHN_SHAM_DFT) then

      mixer%apply = .true.

      call mixfield_init(smix, mixer%field, np, nspin, mix_d3(smix), TYPE_FLOAT)
      call mixfield_clear(mix_scheme(smix), mixer%field)
      call mix_add_auxmixfield(namespace, smix, mixer%field)

    end if

    POP_SUB(vtau_mixer_init_auxmixer)
  end subroutine vtau_mixer_init_auxmixer

  ! ---------------------------------------------------------
  subroutine vtau_mixer_clear(mixer, smix)
    type(vtau_mixer_t), intent(inout) :: mixer
    type(mix_t),         intent(inout)   :: smix

    if (.not. mixer%apply) return
    PUSH_SUB(vtau_mixer_clear)

    call mixfield_clear(mix_scheme(smix), mixer%field)

    POP_SUB(vtau_mixer_clear)
  end subroutine vtau_mixer_clear

  ! ---------------------------------------------------------
  subroutine vtau_mixer_end(mixer, smix)
    type(vtau_mixer_t), intent(inout) :: mixer
    type(mix_t),         intent(inout) :: smix

    if (.not. mixer%apply) return
    PUSH_SUB(vtau_mixer_end)

    call mixfield_end(smix, mixer%field)

    POP_SUB(vtau_mixer_end)
  end subroutine vtau_mixer_end

  ! ---------------------------------------------------------
  subroutine vtau_mixer_set_vout(mixer, hm)
    type(vtau_mixer_t),       intent(inout) :: mixer
    type(hamiltonian_elec_t), intent(in)    :: hm

    if (.not. mixer%apply) return
    PUSH_SUB(vtau_mixer_set_vout)

    call vtau_set_vout(mixer%field, hm%ks_pot)

    POP_SUB(vtau_mixer_set_vout)
  end subroutine vtau_mixer_set_vout

  ! ---------------------------------------------------------
  subroutine vtau_mixer_set_vin(mixer, hm)
    type(vtau_mixer_t),       intent(inout) :: mixer
    type(hamiltonian_elec_t), intent(in)    :: hm

    if (.not. mixer%apply) return
    PUSH_SUB(vtau_mixer_set_vin)

    call vtau_set_vin(mixer%field, hm%ks_pot)

    POP_SUB(vtau_mixer_set_vin)
  end subroutine vtau_mixer_set_vin

  ! ---------------------------------------------------------
  subroutine vtau_mixer_get_vnew(mixer, hm)
    type(vtau_mixer_t),       intent(in)    :: mixer
    type(hamiltonian_elec_t), intent(inout) :: hm

    if (.not. mixer%apply) return
    PUSH_SUB(vtau_mixer_get_vnew)

    call vtau_get_vnew(mixer%field, hm%ks_pot)

    POP_SUB(vtau_mixer_get_vnew)
  end subroutine vtau_mixer_get_vnew


end module vtau_mixer_oct_m
