!! Copyright (C) 2023 F. Troisi
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!

#include "global.h"

module elec_matrix_elements_oct_m
  use batch_oct_m
  use boundaries_oct_m
  use debug_oct_m
  use derivatives_oct_m
  use electron_space_oct_m
  use exchange_operator_oct_m
  use fourier_space_oct_m
  use global_oct_m
  use grid_oct_m
  use hamiltonian_elec_oct_m
  use hamiltonian_elec_base_oct_m
  use ions_oct_m
  use, intrinsic :: iso_fortran_env
  use kpoints_oct_m
  use ks_potential_oct_m
  use lda_u_oct_m
  use loct_math_oct_m
  use mesh_oct_m
  use mesh_batch_oct_m
  use mesh_function_oct_m
  use messages_oct_m
  use mpi_oct_m
  use mpi_lib_oct_m
  use namespace_oct_m
  use phase_oct_m
  use physics_op_oct_m
  use poisson_oct_m
  use profiling_oct_m
  use projector_oct_m
  use scissor_oct_m
  use singularity_oct_m
  use space_oct_m
  use states_abst_oct_m
  use states_elec_dim_oct_m
  use states_elec_oct_m
  use wfs_elec_oct_m
  use xc_oct_m

  implicit none

  private

  public :: elec_momentum_me,         &
    elec_angular_momentum_me, &
    dipole_me,                &
    ks_multipoles_3d,         &
    ks_multipoles_2d,         &
    ks_multipoles_1d,         &
    one_body_me,              &
    two_body_me

  interface dipole_me
    procedure :: delec_dipole_me, zelec_dipole_me
  end interface dipole_me

  interface ks_multipoles_1d
    procedure :: delec_ks_multipoles_1d_me, zelec_ks_multipoles_1d_me
  end interface ks_multipoles_1d

  interface ks_multipoles_2d
    procedure :: delec_ks_multipoles_2d_me, zelec_ks_multipoles_2d_me
  end interface ks_multipoles_2d

  interface ks_multipoles_3d
    procedure :: delec_ks_multipoles_3d_me, zelec_ks_multipoles_3d_me
  end interface ks_multipoles_3d

  interface one_body_me
    procedure :: delec_one_body_me, zelec_one_body_me
  end interface one_body_me

  interface two_body_me
    procedure :: delec_two_body_me, zelec_two_body_me
  end interface two_body_me

contains

  ! -----------------------------------------------------------------------------
  subroutine elec_momentum_me(gr, st, space, kpoints, momentum)
    type(grid_t),                  intent(in)  :: gr
    type(states_elec_t),           intent(in)  :: st
    type(space_t),                 intent(in)  :: space
    type(kpoints_t),               intent(in)  :: kpoints
    real(real64),                  intent(out) :: momentum(:,:,:)

    PUSH_SUB(elec_momentum_me)

    if (states_are_real(st)) then
      call delec_momentum_me(gr, st, space, kpoints, momentum)
    else
      call zelec_momentum_me(gr, st, space, kpoints, momentum)
    end if

    POP_SUB(elec_momentum_me)
  end subroutine elec_momentum_me

  ! -----------------------------------------------------------------------------
  subroutine elec_angular_momentum_me(gr, st, space, ll, l2)
    type(grid_t),                          intent(in)  :: gr
    type(states_elec_t),                   intent(in)  :: st
    type(space_t),                         intent(in)  :: space
    real(real64), contiguous,              intent(out) :: ll(:, :, :) !< (st%nst, st%nik, 1 or 3)
    real(real64), contiguous,    optional, intent(out) :: l2(:, :)    !< (st%nst, st%nik)

    PUSH_SUB(elec_angular_momentum_me)

    if (states_are_real(st)) then
      call delec_angular_momentum_me(gr, st, space, ll, l2)
    else
      call zelec_angular_momentum_me(gr, st, space, ll, l2)
    end if

    POP_SUB(elec_angular_momentum_me)
  end subroutine elec_angular_momentum_me

#include "undef.F90"
#include "complex.F90"
#include "elec_matrix_elements_inc.F90"

#include "undef.F90"
#include "real.F90"
#include "elec_matrix_elements_inc.F90"

end module elec_matrix_elements_oct_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
