!! Copyright (C) 2019 M. Oliveira
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!

!--------------------------------------------------------------
!> @brief initialize a wfs_elec_t object with given memory
!!
!! wrapper to batch_oct_m::X(batch_init_with_memory_3)
!
subroutine X(wfs_elec_init_with_memory_3)(this, dim, st_start, st_end, psi, ik)
  type(wfs_elec_t),           intent(out)   :: this     !< the wfs_elec_t object
  integer,                    intent(in)    :: dim      !< spinor dimensions
  integer,                    intent(in)    :: st_start !< start index for states
  integer,                    intent(in)    :: st_end   !< end index for states
  integer,                    intent(in)    :: ik       !< k point index
  R_TYPE, target, contiguous, intent(inout) :: psi(:, :, st_start:) !< states to use for the object

  PUSH_SUB(X(wfs_elec_init_with_memory_3))

  this%ik = ik
  this%has_phase = .false.
  call batch_init(this%batch_t, dim,  st_start, st_end, psi)

  POP_SUB(X(wfs_elec_init_with_memory_3))
end subroutine X(wfs_elec_init_with_memory_3)

!--------------------------------------------------------------
!> @brief initialize a wfs_elec_t object with given memory
!!
!! wrapper to batch_oct_m::X(batch_init_with_memory_2)
!
subroutine X(wfs_elec_init_with_memory_2)(this, dim, st_start, st_end, psi, ik)
  type(wfs_elec_t),           intent(out)   :: this      !< the wfs_elec_t object
  integer,                    intent(in)    :: dim       !< spinor dimensions
  integer,                    intent(in)    :: st_start  !< start index for states
  integer,                    intent(in)    :: st_end    !< end index for states
  integer,                    intent(in)    :: ik        !< k point index
  R_TYPE, target, contiguous, intent(inout) :: psi(:, :) !< states to use for the object

  PUSH_SUB(X(wfs_elec_init_with_memory_2))

  ASSERT(ubound(psi,dim=2) == dim)

  this%ik = ik
  this%has_phase = .false.
  call batch_init(this%batch_t, dim,  st_start, st_end, psi)

  POP_SUB(X(wfs_elec_init_with_memory_2))
end subroutine X(wfs_elec_init_with_memory_2)

!--------------------------------------------------------------
!> @brief initialize an empty wfs_elec_t object
!!
!! wrapper to batch_oct_m::batch_init
!
subroutine X(wfs_elec_init)(this, dim, st_start, st_end, np, ik, special, packed)
  type(wfs_elec_t),  intent(inout) :: this       !< the wfs_elec_t object
  integer,           intent(in)    :: dim        !< spinor dimensions
  integer,           intent(in)    :: st_start   !< start index for states
  integer,           intent(in)    :: st_end     !< end index for states
  integer,           intent(in)    :: np         !< number of points
  integer,           intent(in)    :: ik         !< k point index
  logical, optional, intent(in)    :: special    !< optional flag; If .true., the allocation will be handled in C (to use pinned memory for GPUs)
  logical, optional, intent(in)    :: packed     !< optional flag whether to pack the batch

  PUSH_SUB(X(wfs_elec_init))

  this%ik = ik
  this%has_phase = .false.
  call X(batch_init)(this, dim, st_start, st_end, np, special, packed)

  POP_SUB(X(wfs_elec_init))
end subroutine X(wfs_elec_init)

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
