/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_2d_prhg07.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;

  double t101, t105, t108, t110, t111, t113, t114, t115;
  double t116, t117, t118, t119, t120, t128, t133, t135;
  double t138, t139, t140, t141, t144, t145, t146, t147;
  double t148, t151, t152, t156, tv2rho20, t162, t163, t164;
  double t165, t166, t169, t171, t173, t177, t178, t179;
  double t182, t183, t184, t185, t188, t189, t190, t191;
  double t195, tv2rhosigma0, t200, t201, t204, t206, t209, t210;
  double t213, t214, t217, t218, t222, tv2rholapl0, t227, t228;
  double t232, t234, t237, t238, t241, t242, t245, t246;
  double t250, tv2rhotau0, t253, t255, t258, t260, t262, t263;
  double t264, t267, t270, t274, tv2sigma20, t276, t279, t280;
  double t283, t284, t287, t288, t292, tv2sigmalapl0, t294, t297;
  double t298, t301, t304, t308, tv2sigmatau0, t310, t312, t315;
  double t316, t319, t322, t326, tv2lapl20, t328, t331, t332;
  double t335, t336, t339, t340, t344, tv2lapltau0, t346, t348;
  double t351, t352, t355, t358, t362, tv2tau20;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t101 = t16 / t17 / rho[0];
  t105 = t15 * t45;
  t108 = 0.1e1 / t38;
  t110 = -t108 * t49 + t39;
  t111 = t59 * t59;
  t113 = t36 * t36;
  t114 = t37 * t37;
  t115 = 0.1e1 / t114;
  t116 = t113 * t115;
  t117 = t33 * t33;
  t118 = 0.1e1 / t117;
  t119 = t116 * t118;
  t120 = t110 * t111 * t119;
  t128 = 0.1e1 / t53 / rho[0];
  t133 = my_piecewise3(t32, (0.3e1 * lapl[0] * t54 + 0.3e1 * t128 * sigma[0] - 0.12e2 * t54 * tau[0]) * t30, 0);
  t135 = t49 * t133 * t64;
  t138 = t49 * t111;
  t139 = t36 * t115;
  t140 = t139 * t118;
  t141 = t138 * t140;
  t144 = t114 * t37;
  t145 = 0.1e1 / t144;
  t146 = t113 * t145;
  t147 = t146 * t118;
  t148 = t138 * t147;
  t151 = t62 * t118;
  t152 = t138 * t151;
  t156 = my_piecewise3(t3, 0, t15 * t101 * t39 / 0.32e2 - t105 * t65 / 0.16e2 - t48 * t120 / 0.32e2 - t48 * t135 / 0.16e2 - t48 * t141 / 0.16e2 + t48 * t148 / 0.16e2 + t48 * t152 / 0.16e2);
  tv2rho20 = 0.2e1 * rho[0] * t156 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t162 = t15 * t18 * t110;
  t163 = t59 * t113;
  t164 = t115 * t118;
  t165 = t164 * t74;
  t166 = t163 * t165;
  t169 = t54 * t30;
  t171 = my_piecewise3(t32, -0.3e1 / 0.4e1 * t169, 0);
  t173 = t49 * t171 * t64;
  t177 = t15 * t18 * t49;
  t178 = t74 * t59;
  t179 = t178 * t140;
  t182 = t74 * t113;
  t183 = t145 * t118;
  t184 = t183 * t59;
  t185 = t182 * t184;
  t188 = t74 * t36;
  t189 = t61 * t118;
  t190 = t189 * t59;
  t191 = t188 * t190;
  t195 = my_piecewise3(t3, 0, -t105 * t76 / 0.32e2 - t162 * t166 / 0.32e2 - t48 * t173 / 0.16e2 - t177 * t179 / 0.16e2 + t177 * t185 / 0.16e2 + t177 * t191 / 0.16e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t195 + 0.2e1 * t79;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t200 = t164 * t83;
  t201 = t163 * t200;
  t204 = my_piecewise3(t32, -t72, 0);
  t206 = t49 * t204 * t64;
  t209 = t83 * t59;
  t210 = t209 * t140;
  t213 = t83 * t113;
  t214 = t213 * t184;
  t217 = t83 * t36;
  t218 = t217 * t190;
  t222 = my_piecewise3(t3, 0, -t105 * t85 / 0.32e2 - t162 * t201 / 0.32e2 - t48 * t206 / 0.16e2 - t177 * t210 / 0.16e2 + t177 * t214 / 0.16e2 + t177 * t218 / 0.16e2);
  tv2rholapl0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t88;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t227 = t164 * t91;
  t228 = t163 * t227;
  t232 = my_piecewise3(t32, 0.4e1 * t72, 0);
  t234 = t49 * t232 * t64;
  t237 = t91 * t59;
  t238 = t237 * t140;
  t241 = t91 * t113;
  t242 = t241 * t184;
  t245 = t91 * t36;
  t246 = t245 * t190;
  t250 = my_piecewise3(t3, 0, -t105 * t93 / 0.32e2 - t162 * t228 / 0.32e2 - t48 * t234 / 0.16e2 - t177 * t238 / 0.16e2 + t177 * t242 / 0.16e2 + t177 * t246 / 0.16e2);
  tv2rhotau0 = 0.2e1 * rho[0] * t250 + 0.2e1 * t96;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t253 = t74 * t74;
  t255 = t110 * t253 * t119;
  t258 = my_piecewise3(t32, 0, 0);
  t260 = t49 * t258 * t64;
  t262 = t48 * t260 / 0.16e2;
  t263 = t49 * t253;
  t264 = t263 * t140;
  t267 = t263 * t147;
  t270 = t263 * t151;
  t274 = my_piecewise3(t3, 0, -t48 * t255 / 0.32e2 - t262 - t48 * t264 / 0.16e2 + t48 * t267 / 0.16e2 + t48 * t270 / 0.16e2);
  tv2sigma20 = 0.2e1 * rho[0] * t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t276 = t182 * t200;
  t279 = t83 * t74;
  t280 = t279 * t140;
  t283 = t183 * t74;
  t284 = t213 * t283;
  t287 = t189 * t74;
  t288 = t217 * t287;
  t292 = my_piecewise3(t3, 0, -t162 * t276 / 0.32e2 - t262 - t177 * t280 / 0.16e2 + t177 * t284 / 0.16e2 + t177 * t288 / 0.16e2);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t292;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t294 = t182 * t227;
  t297 = t91 * t74;
  t298 = t297 * t140;
  t301 = t241 * t283;
  t304 = t245 * t287;
  t308 = my_piecewise3(t3, 0, -t162 * t294 / 0.32e2 - t262 - t177 * t298 / 0.16e2 + t177 * t301 / 0.16e2 + t177 * t304 / 0.16e2);
  tv2sigmatau0 = 0.2e1 * rho[0] * t308;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t310 = t83 * t83;
  t312 = t110 * t310 * t119;
  t315 = t49 * t310;
  t316 = t315 * t140;
  t319 = t315 * t147;
  t322 = t315 * t151;
  t326 = my_piecewise3(t3, 0, -t48 * t312 / 0.32e2 - t262 - t48 * t316 / 0.16e2 + t48 * t319 / 0.16e2 + t48 * t322 / 0.16e2);
  tv2lapl20 = 0.2e1 * rho[0] * t326;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t328 = t213 * t227;
  t331 = t91 * t83;
  t332 = t331 * t140;
  t335 = t183 * t83;
  t336 = t241 * t335;
  t339 = t189 * t83;
  t340 = t245 * t339;
  t344 = my_piecewise3(t3, 0, -t162 * t328 / 0.32e2 - t262 - t177 * t332 / 0.16e2 + t177 * t336 / 0.16e2 + t177 * t340 / 0.16e2);
  tv2lapltau0 = 0.2e1 * rho[0] * t344;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t346 = t91 * t91;
  t348 = t110 * t346 * t119;
  t351 = t49 * t346;
  t352 = t351 * t140;
  t355 = t351 * t147;
  t358 = t351 * t151;
  t362 = my_piecewise3(t3, 0, -t48 * t348 / 0.32e2 - t262 - t48 * t352 / 0.16e2 + t48 * t355 / 0.16e2 + t48 * t358 / 0.16e2);
  tv2tau20 = 0.2e1 * rho[0] * t362;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;

  double t101, t105, t108, t110, t111, t113, t114, t115;
  double t116, t117, t118, t119, t120, t128, t133, t135;
  double t138, t139, t140, t141, t144, t145, t146, t147;
  double t148, t151, t152, t156, tv2rho20, t162, t163, t164;
  double t165, t166, t169, t171, t173, t177, t178, t179;
  double t182, t183, t184, t185, t188, t189, t190, t191;
  double t195, tv2rhosigma0, t200, t201, t204, t206, t209, t210;
  double t213, t214, t217, t218, t222, tv2rholapl0, t227, t228;
  double t232, t234, t237, t238, t241, t242, t245, t246;
  double t250, tv2rhotau0, t253, t255, t258, t260, t262, t263;
  double t264, t267, t270, t274, tv2sigma20, t276, t279, t280;
  double t283, t284, t287, t288, t292, tv2sigmalapl0, t294, t297;
  double t298, t301, t304, t308, tv2sigmatau0, t310, t312, t315;
  double t316, t319, t322, t326, tv2lapl20, t328, t331, t332;
  double t335, t336, t339, t340, t344, tv2lapltau0, t346, t348;
  double t351, t352, t355, t358, t362, tv2tau20;

  double t367, t373, t374, t376, t377, t378, t381, t382;
  double t383, t384, t385, t386, t389, t390, t393, t394;
  double t395, t396, t400, t401, t402, t403, t406, t409;
  double t410, t416, t419, t420, t421, t425, t428, t429;
  double t432, t433, t434, t437, t441, t443, t451, t456;
  double t458, t461, t471, t474, t475, t476, t479, t481;
  double tv3rho30, t489, t491, t493, t496, t497, t498, t499;
  double t502, t503, t504, t505, t509, t513, t516, t517;
  double t522, t523, t528, t529, t530, t533, t534, t535;
  double t536, t539, t542, t543, t546, t547, t550, t551;
  double t557, t561, t564, t567, t568, t571, t572, t575;
  double t578, t579, t580, t581, t584, t586, tv3rho2sigma0, t590;
  double t591, t594, t595, t598, t599, t602, t603, t606;
  double t607, t615, t617, t623, t628, t629, t632, t633;
  double t636, t641, t644, t645, t648, t651, t652, t655;
  double t656, t659, t668, t671, t673, tv3rho2lapl0, t678, t686;
  double t689, t690, t693, t694, t697, t698, t703, t704;
  double t709, t710, t713, t716, t717, t718, t721, t726;
  double t729, t732, t737, t740, t741, t744, t745, t753;
  double t755, t758, t760, tv3rho2tau0, t763, t764, t765, t766;
  double t768, t771, t772, t773, t776, t777, t778, t781;
  double t782, t785, t788, t789, t790, t791, t792, t793;
  double t796, t797, t798, t801, t802, t805, t806, t807;
  double t808, t809, t810, t811, t812, t813, t814, t815;
  double t818, t821, t826, t827, t836, t840, t843, t845;
  double tv3rhosigma20, t848, t849, t852, t853, t854, t855, t858;
  double t859, t860, t861, t864, t865, t872, t875, t876;
  double t879, t880, t883, t886, t889, t894, t897, t898;
  double t905, t906, t909, t910, t915, t916, t919, t920;
  double t923, t925, tv3rhosigmalapl0, t928, t929, t930, t933, t936;
  double t937, t940, t941, t944, t945, t950, t951, t954;
  double t957, t958, t963, t966, t969, t972, t975, t976;
  double t977, t980, t981, t984, t987, t998, t1000, tv3rhosigmatau0;
  double t1003, t1004, t1007, t1008, t1011, t1012, t1015, t1018;
  double t1023, t1024, t1027, t1028, t1031, t1036, t1037, t1040;
  double t1045, t1046, t1053, t1057, t1060, t1062, tv3rholapl20, t1065;
  double t1066, t1069, t1070, t1073, t1074, t1077, t1081, t1084;
  double t1085, t1088, t1089, t1094, t1097, t1100, t1103, t1106;
  double t1109, t1110, t1113, t1114, t1115, t1118, t1121, t1134;
  double t1136, tv3rholapltau0, t1140, t1143, t1144, t1147, t1148, t1153;
  double t1156, t1162, t1165, t1172, t1175, t1176, t1177, t1182;
  double t1183, t1186, t1189, t1193, t1196, t1198, tv3rhotau20, t1201;
  double t1202, t1203, t1204, t1205, t1206, t1209, t1212, t1215;
  double t1216, t1217, t1218, t1219, t1222, t1223, t1224, t1225;
  double t1226, t1229, t1232, t1235, t1236, t1237, t1238, t1241;
  double t1244, t1246, t1249, t1251, t1254, t1255, tv3sigma30, t1257;
  double t1258, t1259, t1260, t1261, t1262, t1263, t1264, t1265;
  double t1266, t1267, t1268, t1270, t1273, t1274, t1275, t1276;
  double t1277, t1278, t1279, t1280, t1281, t1284, t1287, t1288;
  double t1291, t1292, t1295, t1300, t1303, t1306, t1307, t1310;
  double t1311, tv3sigma2lapl0, t1313, t1314, t1315, t1316, t1317, t1318;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1332, t1335, t1338, t1341, t1344, t1347, t1352;
  double t1355, t1356, tv3sigma2tau0, t1359, t1362, t1365, t1366, t1369;
  double t1372, t1375, t1376, t1377, t1378, t1379, t1380, t1381;
  double t1382, t1383, t1388, t1391, t1394, t1395, t1398, t1399;
  double t1400, tv3sigmalapl20, t1404, t1405, t1406, t1409, t1410, t1413;
  double t1414, t1417, t1420, t1421, t1424, t1429, t1432, t1435;
  double t1437, tv3sigmalapltau0, t1440, t1443, t1446, t1449, t1452, t1455;
  double t1456, t1457, t1458, t1459, t1460, t1463, t1466, t1469;
  double t1474, t1475, tv3sigmatau20, t1477, t1479, t1482, t1484, t1487;
  double t1488, t1489, t1492, t1493, t1496, t1499, t1502, t1503;
  double t1504, t1505, t1506, t1509, t1512, t1515, t1518, t1521;
  double t1522, tv3lapl30, t1525, t1528, t1529, t1532, t1533, t1536;
  double t1539, t1542, t1543, t1548, t1551, t1554, t1555, t1558;
  double t1559, tv3lapl2tau0, t1562, t1565, t1569, t1572, t1575, t1578;
  double t1579, t1584, t1587, t1591, t1594, t1595, tv3lapltau20, t1597;
  double t1598, t1599, t1602, t1605, t1606, t1609, t1612, t1614;
  double t1617, t1619, t1622, t1623, t1624, t1625, t1626, t1629;
  double t1632, t1635, t1638, t1641, t1642, tv3tau30;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t101 = t16 / t17 / rho[0];
  t105 = t15 * t45;
  t108 = 0.1e1 / t38;
  t110 = -t108 * t49 + t39;
  t111 = t59 * t59;
  t113 = t36 * t36;
  t114 = t37 * t37;
  t115 = 0.1e1 / t114;
  t116 = t113 * t115;
  t117 = t33 * t33;
  t118 = 0.1e1 / t117;
  t119 = t116 * t118;
  t120 = t110 * t111 * t119;
  t128 = 0.1e1 / t53 / rho[0];
  t133 = my_piecewise3(t32, (0.3e1 * lapl[0] * t54 + 0.3e1 * t128 * sigma[0] - 0.12e2 * t54 * tau[0]) * t30, 0);
  t135 = t49 * t133 * t64;
  t138 = t49 * t111;
  t139 = t36 * t115;
  t140 = t139 * t118;
  t141 = t138 * t140;
  t144 = t114 * t37;
  t145 = 0.1e1 / t144;
  t146 = t113 * t145;
  t147 = t146 * t118;
  t148 = t138 * t147;
  t151 = t62 * t118;
  t152 = t138 * t151;
  t156 = my_piecewise3(t3, 0, t15 * t101 * t39 / 0.32e2 - t105 * t65 / 0.16e2 - t48 * t120 / 0.32e2 - t48 * t135 / 0.16e2 - t48 * t141 / 0.16e2 + t48 * t148 / 0.16e2 + t48 * t152 / 0.16e2);
  tv2rho20 = 0.2e1 * rho[0] * t156 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t162 = t15 * t18 * t110;
  t163 = t59 * t113;
  t164 = t115 * t118;
  t165 = t164 * t74;
  t166 = t163 * t165;
  t169 = t54 * t30;
  t171 = my_piecewise3(t32, -0.3e1 / 0.4e1 * t169, 0);
  t173 = t49 * t171 * t64;
  t177 = t15 * t18 * t49;
  t178 = t74 * t59;
  t179 = t178 * t140;
  t182 = t74 * t113;
  t183 = t145 * t118;
  t184 = t183 * t59;
  t185 = t182 * t184;
  t188 = t74 * t36;
  t189 = t61 * t118;
  t190 = t189 * t59;
  t191 = t188 * t190;
  t195 = my_piecewise3(t3, 0, -t105 * t76 / 0.32e2 - t162 * t166 / 0.32e2 - t48 * t173 / 0.16e2 - t177 * t179 / 0.16e2 + t177 * t185 / 0.16e2 + t177 * t191 / 0.16e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t195 + 0.2e1 * t79;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t200 = t164 * t83;
  t201 = t163 * t200;
  t204 = my_piecewise3(t32, -t72, 0);
  t206 = t49 * t204 * t64;
  t209 = t83 * t59;
  t210 = t209 * t140;
  t213 = t83 * t113;
  t214 = t213 * t184;
  t217 = t83 * t36;
  t218 = t217 * t190;
  t222 = my_piecewise3(t3, 0, -t105 * t85 / 0.32e2 - t162 * t201 / 0.32e2 - t48 * t206 / 0.16e2 - t177 * t210 / 0.16e2 + t177 * t214 / 0.16e2 + t177 * t218 / 0.16e2);
  tv2rholapl0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t88;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t227 = t164 * t91;
  t228 = t163 * t227;
  t232 = my_piecewise3(t32, 0.4e1 * t72, 0);
  t234 = t49 * t232 * t64;
  t237 = t91 * t59;
  t238 = t237 * t140;
  t241 = t91 * t113;
  t242 = t241 * t184;
  t245 = t91 * t36;
  t246 = t245 * t190;
  t250 = my_piecewise3(t3, 0, -t105 * t93 / 0.32e2 - t162 * t228 / 0.32e2 - t48 * t234 / 0.16e2 - t177 * t238 / 0.16e2 + t177 * t242 / 0.16e2 + t177 * t246 / 0.16e2);
  tv2rhotau0 = 0.2e1 * rho[0] * t250 + 0.2e1 * t96;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t253 = t74 * t74;
  t255 = t110 * t253 * t119;
  t258 = my_piecewise3(t32, 0, 0);
  t260 = t49 * t258 * t64;
  t262 = t48 * t260 / 0.16e2;
  t263 = t49 * t253;
  t264 = t263 * t140;
  t267 = t263 * t147;
  t270 = t263 * t151;
  t274 = my_piecewise3(t3, 0, -t48 * t255 / 0.32e2 - t262 - t48 * t264 / 0.16e2 + t48 * t267 / 0.16e2 + t48 * t270 / 0.16e2);
  tv2sigma20 = 0.2e1 * rho[0] * t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t276 = t182 * t200;
  t279 = t83 * t74;
  t280 = t279 * t140;
  t283 = t183 * t74;
  t284 = t213 * t283;
  t287 = t189 * t74;
  t288 = t217 * t287;
  t292 = my_piecewise3(t3, 0, -t162 * t276 / 0.32e2 - t262 - t177 * t280 / 0.16e2 + t177 * t284 / 0.16e2 + t177 * t288 / 0.16e2);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t292;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t294 = t182 * t227;
  t297 = t91 * t74;
  t298 = t297 * t140;
  t301 = t241 * t283;
  t304 = t245 * t287;
  t308 = my_piecewise3(t3, 0, -t162 * t294 / 0.32e2 - t262 - t177 * t298 / 0.16e2 + t177 * t301 / 0.16e2 + t177 * t304 / 0.16e2);
  tv2sigmatau0 = 0.2e1 * rho[0] * t308;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t310 = t83 * t83;
  t312 = t110 * t310 * t119;
  t315 = t49 * t310;
  t316 = t315 * t140;
  t319 = t315 * t147;
  t322 = t315 * t151;
  t326 = my_piecewise3(t3, 0, -t48 * t312 / 0.32e2 - t262 - t48 * t316 / 0.16e2 + t48 * t319 / 0.16e2 + t48 * t322 / 0.16e2);
  tv2lapl20 = 0.2e1 * rho[0] * t326;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t328 = t213 * t227;
  t331 = t91 * t83;
  t332 = t331 * t140;
  t335 = t183 * t83;
  t336 = t241 * t335;
  t339 = t189 * t83;
  t340 = t245 * t339;
  t344 = my_piecewise3(t3, 0, -t162 * t328 / 0.32e2 - t262 - t177 * t332 / 0.16e2 + t177 * t336 / 0.16e2 + t177 * t340 / 0.16e2);
  tv2lapltau0 = 0.2e1 * rho[0] * t344;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t346 = t91 * t91;
  t348 = t110 * t346 * t119;
  t351 = t49 * t346;
  t352 = t351 * t140;
  t355 = t351 * t147;
  t358 = t351 * t151;
  t362 = my_piecewise3(t3, 0, -t48 * t348 / 0.32e2 - t262 - t48 * t352 / 0.16e2 + t48 * t355 / 0.16e2 + t48 * t358 / 0.16e2);
  tv2tau20 = 0.2e1 * rho[0] * t362;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t367 = t16 / t17 / t19;
  t373 = t111 * t59;
  t374 = t110 * t373;
  t376 = 0.1e1 / t117 / t33;
  t377 = t146 * t376;
  t378 = t374 * t377;
  t381 = t113 * t36;
  t382 = t114 * t114;
  t383 = 0.1e1 / t382;
  t384 = t381 * t383;
  t385 = t384 * t376;
  t386 = t374 * t385;
  t389 = t133 * t113;
  t390 = t389 * t184;
  t393 = t49 * t373;
  t394 = t113 * t383;
  t395 = t394 * t376;
  t396 = t393 * t395;
  t400 = 0.1e1 / t382 / t37;
  t401 = t381 * t400;
  t402 = t401 * t376;
  t403 = t393 * t402;
  t406 = t393 * t377;
  t409 = t62 * t376;
  t410 = t393 * t409;
  t416 = t163 * t164 * t133;
  t419 = -0.3e1 / 0.64e2 * t15 * t367 * t39 + 0.3e1 / 0.32e2 * t105 * t148 - 0.3e1 / 0.32e2 * t48 * t378 + 0.3e1 / 0.32e2 * t48 * t386 + 0.3e1 / 0.16e2 * t177 * t390 + t48 * t396 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t403 - 0.3e1 / 0.16e2 * t48 * t406 - t48 * t410 / 0.8e1 + 0.3e1 / 0.32e2 * t105 * t152 - 0.3e1 / 0.32e2 * t162 * t416;
  t420 = t116 * t376;
  t421 = t374 * t420;
  t425 = t133 * t36 * t190;
  t428 = t139 * t376;
  t429 = t393 * t428;
  t432 = t38 * t38;
  t433 = 0.1e1 / t432;
  t434 = t433 * t49;
  t437 = t108 * t110;
  t441 = t434 * t59 * t64 / 0.2e1 - t437 * t59 * t64 / 0.2e1 + t65 / 0.2e1;
  t443 = t441 * t111 * t119;
  t451 = 0.1e1 / t53 / t19;
  t456 = my_piecewise3(t32, (-0.12e2 * lapl[0] * t128 + 0.48e2 * tau[0] * t128 - 0.15e2 * sigma[0] * t451) * t30, 0);
  t458 = t49 * t456 * t64;
  t461 = t15 * t101;
  t471 = t133 * t59 * t140;
  t474 = t36 * t145;
  t475 = t474 * t376;
  t476 = t393 * t475;
  t479 = 0.3e1 / 0.32e2 * t48 * t421 + 0.3e1 / 0.16e2 * t177 * t425 + 0.3e1 / 0.16e2 * t48 * t429 - t48 * t443 / 0.32e2 - t48 * t458 / 0.16e2 + 0.3e1 / 0.64e2 * t461 * t65 - 0.3e1 / 0.32e2 * t105 * t135 - 0.3e1 / 0.64e2 * t105 * t120 - 0.3e1 / 0.32e2 * t105 * t141 - 0.3e1 / 0.16e2 * t177 * t471 - t48 * t476 / 0.16e2;
  t481 = my_piecewise3(t3, 0, t419 + t479);
  tv3rho30 = 0.2e1 * rho[0] * t481 + 0.6e1 * t156;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t489 = t128 * t30;
  t491 = my_piecewise3(t32, 0.3e1 * t489, 0);
  t493 = t49 * t491 * t64;
  t496 = t111 * t113;
  t497 = t145 * t376;
  t498 = t497 * t74;
  t499 = t496 * t498;
  t502 = t111 * t381;
  t503 = t383 * t376;
  t504 = t503 * t74;
  t505 = t502 * t504;
  t509 = t15 * t45 * t49;
  t513 = t171 * t59 * t140;
  t516 = t74 * t111;
  t517 = t516 * t475;
  t522 = t171 * t113;
  t523 = t522 * t184;
  t528 = t61 * t376;
  t529 = t528 * t111;
  t530 = t188 * t529;
  t533 = t461 * t76 / 0.64e2 - t105 * t173 / 0.16e2 - t48 * t493 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t499 + 0.3e1 / 0.32e2 * t162 * t505 - t509 * t179 / 0.16e2 - t177 * t513 / 0.8e1 - t177 * t517 / 0.16e2 + t509 * t185 / 0.16e2 + t177 * t523 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t499 - t177 * t530 / 0.8e1;
  t534 = t115 * t376;
  t535 = t534 * t74;
  t536 = t496 * t535;
  t539 = t516 * t428;
  t542 = t74 * t133;
  t543 = t542 * t140;
  t546 = t183 * t133;
  t547 = t182 * t546;
  t550 = t189 * t133;
  t551 = t188 * t550;
  t557 = t15 * t45 * t110;
  t561 = t15 * t18 * t441;
  t564 = t389 * t165;
  t567 = t164 * t171;
  t568 = t163 * t567;
  t571 = t171 * t36;
  t572 = t571 * t190;
  t575 = t516 * t395;
  t578 = t74 * t381;
  t579 = t400 * t376;
  t580 = t579 * t111;
  t581 = t578 * t580;
  t584 = 0.3e1 / 0.32e2 * t162 * t536 + 0.3e1 / 0.16e2 * t177 * t539 - t177 * t543 / 0.16e2 + t177 * t547 / 0.16e2 + t177 * t551 / 0.16e2 + t509 * t191 / 0.16e2 - t557 * t166 / 0.32e2 - t561 * t166 / 0.32e2 - t162 * t564 / 0.32e2 - t162 * t568 / 0.16e2 + t177 * t572 / 0.8e1 + t177 * t575 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t581;
  t586 = my_piecewise3(t3, 0, t533 + t584);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t586 + 0.4e1 * t195;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t590 = t164 * t204;
  t591 = t163 * t590;
  t594 = t497 * t83;
  t595 = t496 * t594;
  t598 = t503 * t83;
  t599 = t502 * t598;
  t602 = t83 * t111;
  t603 = t602 * t395;
  t606 = t83 * t381;
  t607 = t606 * t580;
  t615 = my_piecewise3(t32, 0.3e1 * t169, 0);
  t617 = t49 * t615 * t64;
  t623 = t204 * t59 * t140;
  t628 = t204 * t113;
  t629 = t628 * t184;
  t632 = -t162 * t591 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t595 + 0.3e1 / 0.32e2 * t162 * t599 + t177 * t603 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t607 + t461 * t85 / 0.64e2 - t105 * t206 / 0.16e2 - t48 * t617 / 0.16e2 - t509 * t210 / 0.16e2 - t177 * t623 / 0.8e1 + t509 * t214 / 0.16e2 + t177 * t629 / 0.8e1;
  t633 = t602 * t475;
  t636 = t602 * t428;
  t641 = t217 * t529;
  t644 = t534 * t83;
  t645 = t496 * t644;
  t648 = t217 * t550;
  t651 = t204 * t36;
  t652 = t651 * t190;
  t655 = t83 * t133;
  t656 = t655 * t140;
  t659 = t213 * t546;
  t668 = t389 * t200;
  t671 = -t177 * t633 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t636 - 0.3e1 / 0.16e2 * t177 * t595 - t177 * t641 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t645 + t177 * t648 / 0.16e2 + t177 * t652 / 0.8e1 - t177 * t656 / 0.16e2 + t177 * t659 / 0.16e2 + t509 * t218 / 0.16e2 - t557 * t201 / 0.32e2 - t561 * t201 / 0.32e2 - t162 * t668 / 0.32e2;
  t673 = my_piecewise3(t3, 0, t632 + t671);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t673 + 0.4e1 * t222;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t678 = t91 * t133 * t140;
  t686 = t496 * t497 * t91;
  t689 = t503 * t91;
  t690 = t502 * t689;
  t693 = t91 * t111;
  t694 = t693 * t395;
  t697 = t91 * t381;
  t698 = t697 * t580;
  t703 = t232 * t59;
  t704 = t703 * t140;
  t709 = t232 * t113;
  t710 = t709 * t184;
  t713 = t693 * t475;
  t716 = -t177 * t678 / 0.16e2 + t509 * t246 / 0.16e2 - t557 * t228 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t686 + 0.3e1 / 0.32e2 * t162 * t690 + t177 * t694 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t698 - t509 * t238 / 0.16e2 - t177 * t704 / 0.8e1 + t509 * t242 / 0.16e2 + t177 * t710 / 0.8e1 - t177 * t713 / 0.16e2;
  t717 = t534 * t91;
  t718 = t496 * t717;
  t721 = t693 * t428;
  t726 = t245 * t529;
  t729 = t241 * t546;
  t732 = t245 * t550;
  t737 = t389 * t227;
  t740 = t164 * t232;
  t741 = t163 * t740;
  t744 = t232 * t36;
  t745 = t744 * t190;
  t753 = my_piecewise3(t32, -0.12e2 * t169, 0);
  t755 = t49 * t753 * t64;
  t758 = 0.3e1 / 0.32e2 * t162 * t718 + 0.3e1 / 0.16e2 * t177 * t721 - 0.3e1 / 0.16e2 * t177 * t686 - t177 * t726 / 0.8e1 + t177 * t729 / 0.16e2 + t177 * t732 / 0.16e2 - t561 * t228 / 0.32e2 - t162 * t737 / 0.32e2 - t162 * t741 / 0.16e2 + t177 * t745 / 0.8e1 + t461 * t93 / 0.64e2 - t105 * t234 / 0.16e2 - t48 * t755 / 0.16e2;
  t760 = my_piecewise3(t3, 0, t716 + t758);
  tv3rho2tau0 = 0.2e1 * rho[0] * t760 + 0.4e1 * t250;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t763 = t258 * t59;
  t764 = t763 * t140;
  t765 = t177 * t764;
  t766 = t765 / 0.16e2;
  t768 = t253 * t59 * t475;
  t771 = t253 * t113;
  t772 = t503 * t59;
  t773 = t771 * t772;
  t776 = t253 * t381;
  t777 = t579 * t59;
  t778 = t776 * t777;
  t781 = t497 * t59;
  t782 = t771 * t781;
  t785 = t776 * t772;
  t788 = t258 * t113;
  t789 = t788 * t184;
  t790 = t177 * t789;
  t791 = t790 / 0.16e2;
  t792 = t189 * t171;
  t793 = t188 * t792;
  t796 = t253 * t36;
  t797 = t528 * t59;
  t798 = t796 * t797;
  t801 = t534 * t59;
  t802 = t771 * t801;
  t805 = t105 * t260;
  t806 = t805 / 0.32e2;
  t807 = t258 * t36;
  t808 = t807 * t190;
  t809 = t177 * t808;
  t810 = t809 / 0.16e2;
  t811 = -t766 - t177 * t768 / 0.16e2 + t177 * t773 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t778 - 0.3e1 / 0.32e2 * t162 * t782 + 0.3e1 / 0.32e2 * t162 * t785 + t791 + t177 * t793 / 0.8e1 - t177 * t798 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t802 - t806 + t810;
  t812 = t164 * t258;
  t813 = t163 * t812;
  t814 = t162 * t813;
  t815 = t814 / 0.32e2;
  t818 = t188 * t567;
  t821 = t796 * t801;
  t826 = t183 * t171;
  t827 = t182 * t826;
  t836 = t182 * t567;
  t840 = t441 * t253 * t119;
  t843 = -t815 - t105 * t264 / 0.32e2 - t177 * t818 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t821 + t105 * t267 / 0.32e2 + t177 * t827 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t782 + t105 * t270 / 0.32e2 - t105 * t255 / 0.64e2 - t162 * t836 / 0.16e2 - t48 * t840 / 0.32e2 - t262;
  t845 = my_piecewise3(t3, 0, t811 + t843);
  tv3rhosigma20 = 0.2e1 * rho[0] * t845 + 0.2e1 * t274;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t848 = t279 * t113;
  t849 = t848 * t772;
  t852 = t606 * t400;
  t853 = t376 * t74;
  t854 = t853 * t59;
  t855 = t852 * t854;
  t858 = t182 * t145;
  t859 = t376 * t83;
  t860 = t859 * t59;
  t861 = t858 * t860;
  t864 = t578 * t383;
  t865 = t864 * t860;
  t872 = t217 * t792;
  t875 = t204 * t74;
  t876 = t875 * t140;
  t879 = t83 * t171;
  t880 = t879 * t140;
  t883 = t628 * t283;
  t886 = t213 * t826;
  t889 = t651 * t287;
  t894 = t522 * t200;
  t897 = t177 * t849 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t855 - 0.3e1 / 0.32e2 * t162 * t861 + 0.3e1 / 0.32e2 * t162 * t865 - t509 * t280 / 0.32e2 + t509 * t284 / 0.32e2 + t177 * t872 / 0.16e2 - t177 * t876 / 0.16e2 - t177 * t880 / 0.16e2 + t177 * t883 / 0.16e2 + t177 * t886 / 0.16e2 + t177 * t889 / 0.16e2 - t561 * t276 / 0.32e2 - t162 * t894 / 0.32e2;
  t898 = t182 * t590;
  t905 = t182 * t115;
  t906 = t905 * t860;
  t909 = t279 * t36;
  t910 = t909 * t801;
  t915 = t279 * t59;
  t916 = t915 * t475;
  t919 = t217 * t61;
  t920 = t919 * t854;
  t923 = -t162 * t898 / 0.32e2 - t815 + t509 * t288 / 0.32e2 - t557 * t276 / 0.64e2 - t766 + t791 + t810 - t806 + 0.3e1 / 0.32e2 * t162 * t906 + 0.3e1 / 0.16e2 * t177 * t910 - 0.3e1 / 0.16e2 * t177 * t861 - t177 * t916 / 0.16e2 - t177 * t920 / 0.8e1 - t262;
  t925 = my_piecewise3(t3, 0, t897 + t923);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t925 + 0.2e1 * t292;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t928 = t376 * t91;
  t929 = t928 * t59;
  t930 = t858 * t929;
  t933 = t864 * t929;
  t936 = t297 * t113;
  t937 = t936 * t772;
  t940 = t697 * t400;
  t941 = t940 * t854;
  t944 = t297 * t59;
  t945 = t944 * t475;
  t950 = t245 * t61;
  t951 = t950 * t854;
  t954 = t905 * t929;
  t957 = t297 * t36;
  t958 = t957 * t801;
  t963 = t744 * t287;
  t966 = t245 * t792;
  t969 = t522 * t227;
  t972 = t182 * t740;
  t975 = -0.3e1 / 0.32e2 * t162 * t930 + 0.3e1 / 0.32e2 * t162 * t933 + t177 * t937 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t941 - t177 * t945 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t930 - t177 * t951 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t954 + 0.3e1 / 0.16e2 * t177 * t958 - t509 * t298 / 0.32e2 + t177 * t963 / 0.16e2 + t177 * t966 / 0.16e2 - t162 * t969 / 0.32e2 - t162 * t972 / 0.32e2;
  t976 = t232 * t74;
  t977 = t976 * t140;
  t980 = t91 * t171;
  t981 = t980 * t140;
  t984 = t709 * t283;
  t987 = t241 * t826;
  t998 = -t177 * t977 / 0.16e2 - t177 * t981 / 0.16e2 + t177 * t984 / 0.16e2 + t177 * t987 / 0.16e2 - t561 * t294 / 0.32e2 + t509 * t301 / 0.32e2 + t509 * t304 / 0.32e2 - t557 * t294 / 0.64e2 - t815 - t766 + t791 + t810 - t806 - t262;
  t1000 = my_piecewise3(t3, 0, t975 + t998);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1000 + 0.2e1 * t308;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1003 = t310 * t59;
  t1004 = t1003 * t475;
  t1007 = t310 * t113;
  t1008 = t1007 * t772;
  t1011 = t310 * t381;
  t1012 = t1011 * t777;
  t1015 = t1007 * t781;
  t1018 = t1011 * t772;
  t1023 = t189 * t204;
  t1024 = t217 * t1023;
  t1027 = t310 * t36;
  t1028 = t1027 * t797;
  t1031 = t1007 * t801;
  t1036 = -t177 * t1004 / 0.16e2 - t766 + t177 * t1008 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1012 - 0.3e1 / 0.32e2 * t162 * t1015 + 0.3e1 / 0.32e2 * t162 * t1018 + t791 + t105 * t322 / 0.32e2 + t177 * t1024 / 0.8e1 - t177 * t1028 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1031 - t105 * t316 / 0.32e2;
  t1037 = t217 * t590;
  t1040 = t1027 * t801;
  t1045 = t183 * t204;
  t1046 = t213 * t1045;
  t1053 = t213 * t590;
  t1057 = t441 * t310 * t119;
  t1060 = -t177 * t1037 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1040 + t105 * t319 / 0.32e2 + t177 * t1046 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1015 - t105 * t312 / 0.64e2 - t162 * t1053 / 0.16e2 - t806 + t810 - t815 - t48 * t1057 / 0.32e2 - t262;
  t1062 = my_piecewise3(t3, 0, t1036 + t1060);
  tv3rholapl20 = 0.2e1 * rho[0] * t1062 + 0.2e1 * t326;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  t1065 = t213 * t145;
  t1066 = t1065 * t929;
  t1069 = t606 * t383;
  t1070 = t1069 * t929;
  t1073 = t331 * t113;
  t1074 = t1073 * t772;
  t1077 = t940 * t860;
  t1081 = t331 * t59 * t475;
  t1084 = t213 * t115;
  t1085 = t1084 * t929;
  t1088 = t331 * t36;
  t1089 = t1088 * t801;
  t1094 = t950 * t860;
  t1097 = t744 * t339;
  t1100 = t245 * t1023;
  t1103 = t628 * t227;
  t1106 = t213 * t740;
  t1109 = t232 * t83;
  t1110 = t1109 * t140;
  t1113 = -0.3e1 / 0.32e2 * t162 * t1066 + 0.3e1 / 0.32e2 * t162 * t1070 + t177 * t1074 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1077 - t177 * t1081 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1085 + 0.3e1 / 0.16e2 * t177 * t1089 - 0.3e1 / 0.16e2 * t177 * t1066 - t177 * t1094 / 0.8e1 + t177 * t1097 / 0.16e2 + t177 * t1100 / 0.16e2 - t162 * t1103 / 0.32e2 - t162 * t1106 / 0.32e2 - t177 * t1110 / 0.16e2;
  t1114 = t91 * t204;
  t1115 = t1114 * t140;
  t1118 = t709 * t335;
  t1121 = t241 * t1045;
  t1134 = -t177 * t1115 / 0.16e2 + t177 * t1118 / 0.16e2 + t177 * t1121 / 0.16e2 - t557 * t328 / 0.64e2 - t509 * t332 / 0.32e2 + t509 * t336 / 0.32e2 + t509 * t340 / 0.32e2 - t561 * t328 / 0.32e2 - t815 - t766 + t791 + t810 - t806 - t262;
  t1136 = my_piecewise3(t3, 0, t1113 + t1134);
  tv3rholapltau0 = 0.2e1 * rho[0] * t1136 + 0.2e1 * t344;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1140 = t245 * t189 * t232;
  t1143 = t346 * t36;
  t1144 = t1143 * t797;
  t1147 = t346 * t113;
  t1148 = t1147 * t801;
  t1153 = t245 * t740;
  t1156 = t1143 * t801;
  t1162 = t241 * t183 * t232;
  t1165 = t1147 * t781;
  t1172 = t241 * t740;
  t1175 = t177 * t1140 / 0.8e1 - t177 * t1144 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1148 - t105 * t352 / 0.32e2 - t177 * t1153 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1156 + t105 * t355 / 0.32e2 + t177 * t1162 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1165 + t105 * t358 / 0.32e2 - t105 * t348 / 0.64e2 - t162 * t1172 / 0.16e2;
  t1176 = t346 * t59;
  t1177 = t1176 * t475;
  t1182 = t346 * t381;
  t1183 = t1182 * t772;
  t1186 = t1147 * t772;
  t1189 = t1182 * t777;
  t1193 = t441 * t346 * t119;
  t1196 = -t177 * t1177 / 0.16e2 - t766 - 0.3e1 / 0.32e2 * t162 * t1165 + 0.3e1 / 0.32e2 * t162 * t1183 + t177 * t1186 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1189 + t791 - t806 + t810 - t815 - t48 * t1193 / 0.32e2 - t262;
  t1198 = my_piecewise3(t3, 0, t1175 + t1196);
  tv3rhotau20 = 0.2e1 * rho[0] * t1198 + 0.2e1 * t362;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1201 = t807 * t287;
  t1202 = t177 * t1201;
  t1203 = 0.3e1 / 0.16e2 * t1202;
  t1204 = t253 * t74;
  t1205 = t49 * t1204;
  t1206 = t1205 * t428;
  t1209 = t1205 * t377;
  t1212 = t1205 * t409;
  t1215 = t182 * t812;
  t1216 = t162 * t1215;
  t1217 = 0.3e1 / 0.32e2 * t1216;
  t1218 = t110 * t1204;
  t1219 = t1218 * t420;
  t1222 = t258 * t74;
  t1223 = t1222 * t140;
  t1224 = t177 * t1223;
  t1225 = 0.3e1 / 0.16e2 * t1224;
  t1226 = t1205 * t475;
  t1229 = t1218 * t377;
  t1232 = t1218 * t385;
  t1235 = t788 * t283;
  t1236 = t177 * t1235;
  t1237 = 0.3e1 / 0.16e2 * t1236;
  t1238 = t1205 * t395;
  t1241 = t1205 * t402;
  t1244 = t434 * t74;
  t1246 = t437 * t74;
  t1249 = t1244 * t64 / 0.2e1 - t1246 * t64 / 0.2e1 + t76 / 0.2e1;
  t1251 = t1249 * t253 * t119;
  t1254 = t1203 + 0.3e1 / 0.16e2 * t48 * t1206 - 0.3e1 / 0.16e2 * t48 * t1209 - t48 * t1212 / 0.8e1 - t1217 + 0.3e1 / 0.32e2 * t48 * t1219 - t1225 - t48 * t1226 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1229 + 0.3e1 / 0.32e2 * t48 * t1232 + t1237 + t48 * t1238 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1241 - t48 * t1251 / 0.32e2 - t262;
  t1255 = my_piecewise3(t3, 0, t1254);
  tv3sigma30 = 0.2e1 * rho[0] * t1255;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1257 = t83 * t258;
  t1258 = t1257 * t140;
  t1259 = t177 * t1258;
  t1260 = t1259 / 0.16e2;
  t1261 = t183 * t258;
  t1262 = t213 * t1261;
  t1263 = t177 * t1262;
  t1264 = t1263 / 0.16e2;
  t1265 = t189 * t258;
  t1266 = t217 * t1265;
  t1267 = t177 * t1266;
  t1268 = t1267 / 0.16e2;
  t1270 = t15 * t18 * t1249;
  t1273 = t788 * t200;
  t1274 = t162 * t1273;
  t1275 = t1274 / 0.32e2;
  t1276 = t1202 / 0.8e1;
  t1277 = t1216 / 0.16e2;
  t1278 = t1224 / 0.8e1;
  t1279 = t1236 / 0.8e1;
  t1280 = t83 * t253;
  t1281 = t1280 * t475;
  t1284 = t1280 * t428;
  t1287 = t497 * t253;
  t1288 = t213 * t1287;
  t1291 = t528 * t253;
  t1292 = t217 * t1291;
  t1295 = t771 * t644;
  t1300 = t776 * t598;
  t1303 = t1280 * t395;
  t1306 = t579 * t253;
  t1307 = t606 * t1306;
  t1310 = -t1260 + t1264 + t1268 - t1270 * t276 / 0.32e2 - t1275 + t1276 - t1277 - t1278 + t1279 - t177 * t1281 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t1284 - 0.3e1 / 0.16e2 * t177 * t1288 - t177 * t1292 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1295 - 0.3e1 / 0.32e2 * t162 * t1288 + 0.3e1 / 0.32e2 * t162 * t1300 + t177 * t1303 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1307 - t262;
  t1311 = my_piecewise3(t3, 0, t1310);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1311;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1313 = t241 * t1261;
  t1314 = t177 * t1313;
  t1315 = t1314 / 0.16e2;
  t1316 = t245 * t1265;
  t1317 = t177 * t1316;
  t1318 = t1317 / 0.16e2;
  t1321 = t788 * t227;
  t1322 = t162 * t1321;
  t1323 = t1322 / 0.32e2;
  t1324 = t91 * t258;
  t1325 = t1324 * t140;
  t1326 = t177 * t1325;
  t1327 = t1326 / 0.16e2;
  t1328 = t91 * t253;
  t1329 = t1328 * t475;
  t1332 = t771 * t717;
  t1335 = t1328 * t428;
  t1338 = t241 * t1287;
  t1341 = t245 * t1291;
  t1344 = t1328 * t395;
  t1347 = t697 * t1306;
  t1352 = t776 * t689;
  t1355 = t1315 + t1318 - t1270 * t294 / 0.32e2 - t1323 - t1327 + t1276 - t1277 - t1278 + t1279 - t177 * t1329 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1332 + 0.3e1 / 0.16e2 * t177 * t1335 - 0.3e1 / 0.16e2 * t177 * t1338 - t177 * t1341 / 0.8e1 + t177 * t1344 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1347 - 0.3e1 / 0.32e2 * t162 * t1338 + 0.3e1 / 0.32e2 * t162 * t1352 - t262;
  t1356 = my_piecewise3(t3, 0, t1355);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1356;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1359 = t1249 * t310 * t119;
  t1362 = t1007 * t498;
  t1365 = t528 * t74;
  t1366 = t1027 * t1365;
  t1369 = t1007 * t535;
  t1372 = t1027 * t535;
  t1375 = t1259 / 0.8e1;
  t1376 = t1263 / 0.8e1;
  t1377 = t1267 / 0.8e1;
  t1378 = t1274 / 0.16e2;
  t1379 = t1202 / 0.16e2;
  t1380 = t1216 / 0.32e2;
  t1381 = t1224 / 0.16e2;
  t1382 = t310 * t74;
  t1383 = t1382 * t475;
  t1388 = t1011 * t504;
  t1391 = t1007 * t504;
  t1394 = t579 * t74;
  t1395 = t1011 * t1394;
  t1398 = t1236 / 0.16e2;
  t1399 = -t48 * t1359 / 0.32e2 - 0.3e1 / 0.16e2 * t177 * t1362 - t177 * t1366 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1369 + 0.3e1 / 0.16e2 * t177 * t1372 - t1375 + t1376 + t1377 - t1378 + t1379 - t1380 - t1381 - t177 * t1383 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t1362 + 0.3e1 / 0.32e2 * t162 * t1388 + t177 * t1391 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1395 + t1398 - t262;
  t1400 = my_piecewise3(t3, 0, t1399);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1400;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  t1404 = -t1270 * t328 / 0.32e2 + t1315 + t1318 - t1323 - t1327 - t1260 + t1264 + t1268 - t1275 + t1379 - t1380;
  t1405 = t331 * t74;
  t1406 = t1405 * t475;
  t1409 = t859 * t74;
  t1410 = t950 * t1409;
  t1413 = t928 * t74;
  t1414 = t1084 * t1413;
  t1417 = t1088 * t535;
  t1420 = t241 * t145;
  t1421 = t1420 * t1409;
  t1424 = t940 * t1409;
  t1429 = t1069 * t1413;
  t1432 = t1073 * t504;
  t1435 = -t1381 - t177 * t1406 / 0.16e2 + t1398 - t177 * t1410 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1414 + 0.3e1 / 0.16e2 * t177 * t1417 - 0.3e1 / 0.16e2 * t177 * t1421 - 0.3e1 / 0.16e2 * t177 * t1424 - 0.3e1 / 0.32e2 * t162 * t1421 + 0.3e1 / 0.32e2 * t162 * t1429 + t177 * t1432 / 0.4e1 - t262;
  t1437 = my_piecewise3(t3, 0, t1404 + t1435);
  tv3sigmalapltau0 = 0.2e1 * rho[0] * t1437;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1440 = t1249 * t346 * t119;
  t1443 = t1143 * t535;
  t1446 = t1147 * t498;
  t1449 = t1143 * t1365;
  t1452 = t1147 * t535;
  t1455 = t1314 / 0.8e1;
  t1456 = t1317 / 0.8e1;
  t1457 = t1322 / 0.16e2;
  t1458 = t1326 / 0.8e1;
  t1459 = t346 * t74;
  t1460 = t1459 * t475;
  t1463 = t1182 * t504;
  t1466 = t1147 * t504;
  t1469 = t1182 * t1394;
  t1474 = -t48 * t1440 / 0.32e2 + 0.3e1 / 0.16e2 * t177 * t1443 - 0.3e1 / 0.16e2 * t177 * t1446 - t177 * t1449 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1452 + t1455 + t1456 - t1457 - t1458 + t1379 - t1380 - t177 * t1460 / 0.16e2 - t1381 + 0.3e1 / 0.32e2 * t162 * t1463 + t177 * t1466 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1469 - 0.3e1 / 0.32e2 * t162 * t1446 + t1398 - t262;
  t1475 = my_piecewise3(t3, 0, t1474);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1475;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1477 = t434 * t83;
  t1479 = t437 * t83;
  t1482 = t1477 * t64 / 0.2e1 - t1479 * t64 / 0.2e1 + t85 / 0.2e1;
  t1484 = t1482 * t310 * t119;
  t1487 = t310 * t83;
  t1488 = t49 * t1487;
  t1489 = t1488 * t409;
  t1492 = t110 * t1487;
  t1493 = t1492 * t420;
  t1496 = t1488 * t428;
  t1499 = t1488 * t377;
  t1502 = 0.3e1 / 0.16e2 * t1259;
  t1503 = 0.3e1 / 0.16e2 * t1263;
  t1504 = 0.3e1 / 0.16e2 * t1267;
  t1505 = 0.3e1 / 0.32e2 * t1274;
  t1506 = t1488 * t475;
  t1509 = t1492 * t377;
  t1512 = t1492 * t385;
  t1515 = t1488 * t395;
  t1518 = t1488 * t402;
  t1521 = -t48 * t1484 / 0.32e2 - t48 * t1489 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1493 + 0.3e1 / 0.16e2 * t48 * t1496 - 0.3e1 / 0.16e2 * t48 * t1499 - t1502 + t1503 + t1504 - t1505 - t48 * t1506 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1509 + 0.3e1 / 0.32e2 * t48 * t1512 + t48 * t1515 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1518 - t262;
  t1522 = my_piecewise3(t3, 0, t1521);
  tv3lapl30 = 0.2e1 * rho[0] * t1522;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  t1525 = t15 * t18 * t1482;
  t1528 = t91 * t310;
  t1529 = t1528 * t475;
  t1532 = t528 * t310;
  t1533 = t245 * t1532;
  t1536 = t1007 * t717;
  t1539 = t1528 * t428;
  t1542 = t497 * t310;
  t1543 = t241 * t1542;
  t1548 = t1011 * t689;
  t1551 = t1528 * t395;
  t1554 = t579 * t310;
  t1555 = t697 * t1554;
  t1558 = -t1525 * t328 / 0.32e2 + t1315 + t1318 - t1323 - t1327 - t1375 + t1376 + t1377 - t1378 - t177 * t1529 / 0.16e2 - t177 * t1533 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1536 + 0.3e1 / 0.16e2 * t177 * t1539 - 0.3e1 / 0.16e2 * t177 * t1543 - 0.3e1 / 0.32e2 * t162 * t1543 + 0.3e1 / 0.32e2 * t162 * t1548 + t177 * t1551 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1555 - t262;
  t1559 = my_piecewise3(t3, 0, t1558);
  tv3lapl2tau0 = 0.2e1 * rho[0] * t1559;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  t1562 = t1482 * t346 * t119;
  t1565 = t1147 * t594;
  t1569 = t1143 * t528 * t83;
  t1572 = t1147 * t644;
  t1575 = t1143 * t644;
  t1578 = t346 * t83;
  t1579 = t1578 * t475;
  t1584 = t1182 * t598;
  t1587 = t1147 * t598;
  t1591 = t1182 * t579 * t83;
  t1594 = -t48 * t1562 / 0.32e2 - 0.3e1 / 0.16e2 * t177 * t1565 - t177 * t1569 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1572 + 0.3e1 / 0.16e2 * t177 * t1575 + t1455 + t1456 - t1457 - t1458 - t1260 + t1264 + t1268 - t1275 - t177 * t1579 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t1565 + 0.3e1 / 0.32e2 * t162 * t1584 + t177 * t1587 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1591 - t262;
  t1595 = my_piecewise3(t3, 0, t1594);
  tv3lapltau20 = 0.2e1 * rho[0] * t1595;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1597 = t346 * t91;
  t1598 = t49 * t1597;
  t1599 = t1598 * t377;
  t1602 = t1598 * t409;
  t1605 = t110 * t1597;
  t1606 = t1605 * t420;
  t1609 = t1598 * t428;
  t1612 = t434 * t91;
  t1614 = t437 * t91;
  t1617 = t1612 * t64 / 0.2e1 - t1614 * t64 / 0.2e1 + t93 / 0.2e1;
  t1619 = t1617 * t346 * t119;
  t1622 = 0.3e1 / 0.16e2 * t1314;
  t1623 = 0.3e1 / 0.16e2 * t1317;
  t1624 = 0.3e1 / 0.32e2 * t1322;
  t1625 = 0.3e1 / 0.16e2 * t1326;
  t1626 = t1598 * t475;
  t1629 = t1605 * t377;
  t1632 = t1605 * t385;
  t1635 = t1598 * t395;
  t1638 = t1598 * t402;
  t1641 = -0.3e1 / 0.16e2 * t48 * t1599 - t48 * t1602 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1606 + 0.3e1 / 0.16e2 * t48 * t1609 - t48 * t1619 / 0.32e2 + t1622 + t1623 - t1624 - t1625 - t48 * t1626 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1629 + 0.3e1 / 0.32e2 * t48 * t1632 + t48 * t1635 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1638 - t262;
  t1642 = my_piecewise3(t3, 0, t1641);
  tv3tau30 = 0.2e1 * rho[0] * t1642;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;

  double t101, t105, t108, t110, t111, t113, t114, t115;
  double t116, t117, t118, t119, t120, t128, t133, t135;
  double t138, t139, t140, t141, t144, t145, t146, t147;
  double t148, t151, t152, t156, tv2rho20, t162, t163, t164;
  double t165, t166, t169, t171, t173, t177, t178, t179;
  double t182, t183, t184, t185, t188, t189, t190, t191;
  double t195, tv2rhosigma0, t200, t201, t204, t206, t209, t210;
  double t213, t214, t217, t218, t222, tv2rholapl0, t227, t228;
  double t232, t234, t237, t238, t241, t242, t245, t246;
  double t250, tv2rhotau0, t253, t255, t258, t260, t262, t263;
  double t264, t267, t270, t274, tv2sigma20, t276, t279, t280;
  double t283, t284, t287, t288, t292, tv2sigmalapl0, t294, t297;
  double t298, t301, t304, t308, tv2sigmatau0, t310, t312, t315;
  double t316, t319, t322, t326, tv2lapl20, t328, t331, t332;
  double t335, t336, t339, t340, t344, tv2lapltau0, t346, t348;
  double t351, t352, t355, t358, t362, tv2tau20;

  double t367, t373, t374, t376, t377, t378, t381, t382;
  double t383, t384, t385, t386, t389, t390, t393, t394;
  double t395, t396, t400, t401, t402, t403, t406, t409;
  double t410, t416, t419, t420, t421, t425, t428, t429;
  double t432, t433, t434, t437, t441, t443, t451, t456;
  double t458, t461, t471, t474, t475, t476, t479, t481;
  double tv3rho30, t489, t491, t493, t496, t497, t498, t499;
  double t502, t503, t504, t505, t509, t513, t516, t517;
  double t522, t523, t528, t529, t530, t533, t534, t535;
  double t536, t539, t542, t543, t546, t547, t550, t551;
  double t557, t561, t564, t567, t568, t571, t572, t575;
  double t578, t579, t580, t581, t584, t586, tv3rho2sigma0, t590;
  double t591, t594, t595, t598, t599, t602, t603, t606;
  double t607, t615, t617, t623, t628, t629, t632, t633;
  double t636, t641, t644, t645, t648, t651, t652, t655;
  double t656, t659, t668, t671, t673, tv3rho2lapl0, t678, t686;
  double t689, t690, t693, t694, t697, t698, t703, t704;
  double t709, t710, t713, t716, t717, t718, t721, t726;
  double t729, t732, t737, t740, t741, t744, t745, t753;
  double t755, t758, t760, tv3rho2tau0, t763, t764, t765, t766;
  double t768, t771, t772, t773, t776, t777, t778, t781;
  double t782, t785, t788, t789, t790, t791, t792, t793;
  double t796, t797, t798, t801, t802, t805, t806, t807;
  double t808, t809, t810, t811, t812, t813, t814, t815;
  double t818, t821, t826, t827, t836, t840, t843, t845;
  double tv3rhosigma20, t848, t849, t852, t853, t854, t855, t858;
  double t859, t860, t861, t864, t865, t872, t875, t876;
  double t879, t880, t883, t886, t889, t894, t897, t898;
  double t905, t906, t909, t910, t915, t916, t919, t920;
  double t923, t925, tv3rhosigmalapl0, t928, t929, t930, t933, t936;
  double t937, t940, t941, t944, t945, t950, t951, t954;
  double t957, t958, t963, t966, t969, t972, t975, t976;
  double t977, t980, t981, t984, t987, t998, t1000, tv3rhosigmatau0;
  double t1003, t1004, t1007, t1008, t1011, t1012, t1015, t1018;
  double t1023, t1024, t1027, t1028, t1031, t1036, t1037, t1040;
  double t1045, t1046, t1053, t1057, t1060, t1062, tv3rholapl20, t1065;
  double t1066, t1069, t1070, t1073, t1074, t1077, t1081, t1084;
  double t1085, t1088, t1089, t1094, t1097, t1100, t1103, t1106;
  double t1109, t1110, t1113, t1114, t1115, t1118, t1121, t1134;
  double t1136, tv3rholapltau0, t1140, t1143, t1144, t1147, t1148, t1153;
  double t1156, t1162, t1165, t1172, t1175, t1176, t1177, t1182;
  double t1183, t1186, t1189, t1193, t1196, t1198, tv3rhotau20, t1201;
  double t1202, t1203, t1204, t1205, t1206, t1209, t1212, t1215;
  double t1216, t1217, t1218, t1219, t1222, t1223, t1224, t1225;
  double t1226, t1229, t1232, t1235, t1236, t1237, t1238, t1241;
  double t1244, t1246, t1249, t1251, t1254, t1255, tv3sigma30, t1257;
  double t1258, t1259, t1260, t1261, t1262, t1263, t1264, t1265;
  double t1266, t1267, t1268, t1270, t1273, t1274, t1275, t1276;
  double t1277, t1278, t1279, t1280, t1281, t1284, t1287, t1288;
  double t1291, t1292, t1295, t1300, t1303, t1306, t1307, t1310;
  double t1311, tv3sigma2lapl0, t1313, t1314, t1315, t1316, t1317, t1318;
  double t1321, t1322, t1323, t1324, t1325, t1326, t1327, t1328;
  double t1329, t1332, t1335, t1338, t1341, t1344, t1347, t1352;
  double t1355, t1356, tv3sigma2tau0, t1359, t1362, t1365, t1366, t1369;
  double t1372, t1375, t1376, t1377, t1378, t1379, t1380, t1381;
  double t1382, t1383, t1388, t1391, t1394, t1395, t1398, t1399;
  double t1400, tv3sigmalapl20, t1404, t1405, t1406, t1409, t1410, t1413;
  double t1414, t1417, t1420, t1421, t1424, t1429, t1432, t1435;
  double t1437, tv3sigmalapltau0, t1440, t1443, t1446, t1449, t1452, t1455;
  double t1456, t1457, t1458, t1459, t1460, t1463, t1466, t1469;
  double t1474, t1475, tv3sigmatau20, t1477, t1479, t1482, t1484, t1487;
  double t1488, t1489, t1492, t1493, t1496, t1499, t1502, t1503;
  double t1504, t1505, t1506, t1509, t1512, t1515, t1518, t1521;
  double t1522, tv3lapl30, t1525, t1528, t1529, t1532, t1533, t1536;
  double t1539, t1542, t1543, t1548, t1551, t1554, t1555, t1558;
  double t1559, tv3lapl2tau0, t1562, t1565, t1569, t1572, t1575, t1578;
  double t1579, t1584, t1587, t1591, t1594, t1595, tv3lapltau20, t1597;
  double t1598, t1599, t1602, t1605, t1606, t1609, t1612, t1614;
  double t1617, t1619, t1622, t1623, t1624, t1625, t1626, t1629;
  double t1632, t1635, t1638, t1641, t1642, tv3tau30;

  double t1651, t1657, t1661, t1662, t1686, t1694, t1698, t1704;
  double t1712, t1713, t1714, t1715, t1716, t1720, t1722, t1724;
  double t1728, t1730, t1735, t1740, t1742, t1746, t1750, t1761;
  double t1765, t1772, t1779, t1786, t1793, t1808, t1817, t1819;
  double t1825, t1829, t1840, t1846, t1855, t1863, t1864, t1868;
  double t1869, t1885, t1910, t1913, tv4rho40, t1921, t1923, t1927;
  double t1930, t1931, t1935, t1939, t1940, t1949, t1950, t1954;
  double t1958, t1960, t1963, t1965, t1968, t1969, t1970, t1971;
  double t1977, t1982, t1989, t1992, t2000, t2004, t2005, t2006;
  double t2021, t2022, t2048, t2063, t2064, t2074, t2087, t2094;
  double t2101, t2106, t2108, t2115, t2123, t2129, t2136, t2140;
  double t2141, t2153, t2154, t2155, t2169, t2174, t2177, tv4rho3sigma0;
  double t2181, t2192, t2196, t2197, t2213, t2217, t2221, t2228;
  double t2236, t2237, t2242, t2248, t2255, t2263, t2279, t2296;
  double t2298, t2313, t2319, t2329, t2337, t2353, t2360, t2364;
  double t2396, t2407, t2410, tv4rho3lapl0, t2414, t2422, t2425, t2429;
  double t2444, t2445, t2450, t2454, t2459, t2462, t2469, t2473;
  double t2477, t2480, t2494, t2515, t2531, t2537, t2540, t2562;
  double t2569, t2583, t2598, t2602, t2633, t2640, t2643, tv4rho3tau0;
  double t2648, t2649, t2657, t2670, t2677, t2678, t2681, t2684;
  double t2685, t2686, t2690, t2694, t2695, t2699, t2702, t2707;
  double t2713, t2714, t2719, t2720, t2723, t2730, t2733, t2741;
  double t2753, t2754, t2755, t2758, t2759, t2766, t2767, t2768;
  double t2770, t2782, t2786, t2787, t2796, t2800, t2802, t2805;
  double t2816, t2826, t2827, t2829, t2832, t2833, t2836, t2839;
  double t2848, t2856, t2865, t2872, t2873, t2874, t2875, t2876;
  double t2877, t2878, t2882, t2884, t2909, t2910, t2914, tv4rho2sigma20;
  double t2918, t2919, t2920, t2927, t2931, t2935, t2940, t2941;
  double t2945, t2962, t2969, t2970, t3002, t3003, t3011, t3026;
  double t3037, t3038, t3041, t3042, t3053, t3060, t3092, t3131;
  double t3159, t3171, t3172, t3176, tv4rho2sigmalapl0, t3180, t3188, t3194;
  double t3198, t3199, t3200, t3214, t3221, t3228, t3238, t3239;
  double t3242, t3245, t3268, t3293, t3294, t3309, t3317, t3332;
  double t3350, t3385, t3424, t3430, t3434, tv4rho2sigmatau0, t3441, t3449;
  double t3453, t3462, t3466, t3472, t3478, t3479, t3485, t3491;
  double t3503, t3504, t3507, t3509, t3518, t3524, t3539, t3552;
  double t3559, t3573, t3599, t3600, t3604, t3605, t3606, t3632;
  double t3636, tv4rho2lapl20, t3640, t3645, t3664, t3683, t3684, t3690;
  double t3695, t3699, t3705, t3709, t3716, t3723, t3730, t3762;
  double t3766, t3802, t3838, t3873, t3881, t3885, tv4rho2lapltau0, t3892;
  double t3901, t3906, t3916, t3922, t3923, t3926, t3951, t3960;
  double t3973, t3986, t3987, t4018, t4021, t4046, t4050, t4057;
  double t4064, t4078, t4082, tv4rho2tau20, t4087, t4091, t4095, t4099;
  double t4103, t4105, t4106, t4108, t4110, t4111, t4112, t4114;
  double t4116, t4118, t4122, t4123, t4124, t4127, t4128, t4129;
  double t4137, t4138, t4145, t4149, t4153, t4154, t4159, t4162;
  double t4171, t4173, t4180, t4182, t4184, t4191, t4195, t4203;
  double t4205, t4208, t4215, t4218, t4223, t4228, t4253, t4255;
  double t4269, t4270, t4273, t4274, t4275, t4281, t4282, t4285;
  double t4288, t4303, t4308, t4326, t4329, tv4rhosigma30, t4334, t4335;
  double t4336, t4337, t4346, t4350, t4354, t4357, t4362, t4364;
  double t4365, t4367, t4368, t4373, t4374, t4376, t4377, t4378;
  double t4379, t4380, t4381, t4382, t4383, t4387, t4388, t4400;
  double t4401, t4406, t4410, t4411, t4413, t4414, t4415, t4418;
  double t4419, t4448, t4453, t4454, t4455, t4456, t4457, t4458;
  double t4459, t4460, t4461, t4464, t4465, t4474, t4487, t4488;
  double t4490, t4493, t4494, t4495, t4496, t4497, t4498, t4506;
  double t4507, t4515, t4528, t4529, t4531, t4532, t4534, t4535;
  double t4537, t4544, t4546, t4547, t4554, t4555, t4556, t4557;
  double t4558, t4559, t4560, t4561, t4562, t4563, t4564, t4568;
  double tv4rhosigma2lapl0, t4571, t4576, t4577, t4584, t4587, t4598, t4599;
  double t4601, t4602, t4607, t4608, t4609, t4610, t4612, t4613;
  double t4614, t4616, t4617, t4620, t4624, t4631, t4637, t4648;
  double t4649, t4650, t4653, t4654, t4676, t4681, t4682, t4685;
  double t4686, t4691, t4695, t4696, t4698, t4699, t4704, t4721;
  double t4722, t4723, t4724, t4725, t4726, t4727, t4728, t4734;
  double t4735, t4747, t4759, t4760, t4762, t4763, t4766, t4767;
  double t4771, t4780, t4781, t4785, tv4rhosigma2tau0, t4788, t4789, t4802;
  double t4810, t4814, t4821, t4822, t4833, t4851, t4863, t4874;
  double t4876, t4877, t4878, t4879, t4880, t4881, t4882, t4883;
  double t4884, t4885, t4886, t4887, t4888, t4889, t4890, t4891;
  double t4892, t4893, t4894, t4899, t4914, t4945, t4958, t4959;
  double t4960, t4961, t4962, t4963, t4964, t4965, t4966, t4968;
  double t4969, t4970, t4971, t4972, t4973, t4974, t4975, t4976;
  double t4977, t4984, t4985, t4989, tv4rhosigmalapl20, t5018, t5033, t5037;
  double t5069, t5072, t5086, t5110, t5111, t5122, t5123, t5125;
  double t5131, t5160, t5165, t5181, t5183, t5184, t5188, tv4rhosigmalapltau0;
  double t5191, t5195, t5199, t5203, t5204, t5213, t5214, t5221;
  double t5225, t5233, t5234, t5235, t5238, t5239, t5247, t5264;
  double t5271, t5278, t5280, t5281, t5282, t5283, t5284, t5285;
  double t5286, t5287, t5288, t5289, t5306, t5316, t5339, t5353;
  double t5354, t5355, t5356, t5357, t5358, t5359, t5360, t5361;
  double t5363, t5370, t5371, t5375, tv4rhosigmatau20, t5387, t5397, t5398;
  double t5401, t5407, t5414, t5422, t5430, t5434, t5438, t5448;
  double t5455, t5461, t5468, t5498, t5507, t5520, t5523, t5526;
  double t5529, t5530, t5554, t5562, t5565, tv4rholapl30, t5571, t5576;
  double t5577, t5589, t5600, t5607, t5622, t5626, t5631, t5642;
  double t5645, t5652, t5656, t5669, t5677, t5695, t5709, t5724;
  double t5726, t5727, t5731, tv4rholapl2tau0, t5734, t5741, t5755, t5783;
  double t5797, t5806, t5807, t5812, t5815, t5818, t5819, t5829;
  double t5833, t5843, t5850, t5863, t5886, t5890, tv4rholapltau20, t5900;
  double t5904, t5908, t5909, t5912, t5915, t5919, t5932, t5933;
  double t5955, t5960, t5968, t5972, t5983, t6016, t6025, t6041;
  double t6044, t6047, t6051, t6075, t6080, t6083, tv4rhotau30, t6086;
  double t6088, t6090, t6093, t6096, t6098, t6099, t6101, t6104;
  double t6107, t6110, t6113, t6115, t6116, t6120, t6133, t6134;
  double t6137, t6138, t6148, t6152, t6155, t6185, t6187, t6199;
  double t6200, t6207, t6213, t6214, t6221, t6236, t6238, tv4sigma40;
  double t6240, t6244, t6247, t6248, t6266, t6273, t6276, t6277;
  double t6278, t6279, t6293, t6297, t6303, t6304, t6305, t6306;
  double t6307, t6309, t6310, t6311, t6312, t6313, t6314, t6317;
  double t6318, t6320, t6321, t6323, t6324, t6326, t6327, t6328;
  double t6329, t6330, t6332, t6333, t6335, t6336, t6337, t6338;
  double t6340, t6341, t6342, t6345, tv4sigma3lapl0, t6352, t6356, t6362;
  double t6365, t6383, t6388, t6389, t6404, t6406, t6408, t6409;
  double t6411, t6412, t6413, t6414, t6415, t6417, t6418, t6421;
  double t6422, t6424, t6425, t6427, t6428, t6430, t6431, t6432;
  double t6433, t6434, t6437, tv4sigma3tau0, t6443, t6459, t6466, t6467;
  double t6473, t6474, t6480, t6484, t6485, t6486, t6488, t6489;
  double t6490, t6492, t6493, t6496, t6497, t6500, t6501, t6502;
  double t6505, t6510, t6511, t6513, t6514, t6517, t6518, t6522;
  double t6524, t6525, t6527, t6528, t6529, t6531, t6532, t6533;
  double t6534, t6535, t6536, t6537, t6538, t6543, t6552, t6555;
  double tv4sigma2lapl20, t6559, t6562, t6565, t6575, t6579, t6587, t6601;
  double t6614, t6617, t6619, t6623, t6624, t6627, t6630, t6632;
  double t6635, t6641, t6643, t6644, t6645, t6646, t6647, t6648;
  double t6649, t6650, t6651, t6652, t6653, t6654, t6655, t6656;
  double t6657, t6658, t6659, t6660, t6661, t6662, t6665, tv4sigma2lapltau0;
  double t6670, t6673, t6676, t6688, t6691, t6692, t6693, t6694;
  double t6699, t6700, t6705, t6706, t6712, t6729, t6730, t6732;
  double t6733, t6735, t6736, t6738, t6739, t6742, t6743, t6747;
  double t6748, t6750, t6756, t6765, t6768, tv4sigma2tau20, t6770, t6776;
  double t6779, t6780, t6794, t6809, t6810, t6820, t6824, t6828;
  double t6829, t6830, t6831, t6832, t6833, t6834, t6835, t6836;
  double t6838, t6840, t6848, t6860, t6863, t6866, t6869, t6881;
  double t6889, t6890, t6893, tv4sigmalapl30, t6905, t6907, t6917, t6930;
  double t6938, t6941, t6962, t6964, t6965, t6966, t6967, t6968;
  double t6969, t6970, t6971, t6972, t6973, t6983, t6986, tv4sigmalapl2tau0;
  double t7000, t7006, t7007, t7017, t7029, t7034, t7054, t7056;
  double t7066, t7069, tv4sigmalapltau20, t7078, t7090, t7095, t7100, t7101;
  double t7106, t7116, t7126, t7127, t7128, t7129, t7130, t7131;
  double t7132, t7133, t7134, t7136, t7138, t7173, t7181, t7182;
  double t7185, tv4sigmatau30, t7197, t7204, t7205, t7215, t7232, t7239;
  double t7243, t7250, t7258, t7296, t7298, tv4lapl40, t7301, t7309;
  double t7323, t7340, t7342, t7362, t7364, t7365, t7366, t7367;
  double t7368, t7369, t7370, t7371, t7372, t7373, t7374, t7377;
  double tv4lapl3tau0, t7391, t7395, t7404, t7410, t7423, t7436, t7442;
  double t7451, t7454, tv4lapl2tau20, t7463, t7472, t7477, t7496, t7501;
  double t7512, t7530, t7533, t7536, t7548, t7553, t7563, t7564;
  double t7567, tv4lapltau30, t7579, t7580, t7590, t7609, t7625, t7651;
  double t7662, t7669, t7678, t7680, tv4tau40;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t101 = t16 / t17 / rho[0];
  t105 = t15 * t45;
  t108 = 0.1e1 / t38;
  t110 = -t108 * t49 + t39;
  t111 = t59 * t59;
  t113 = t36 * t36;
  t114 = t37 * t37;
  t115 = 0.1e1 / t114;
  t116 = t113 * t115;
  t117 = t33 * t33;
  t118 = 0.1e1 / t117;
  t119 = t116 * t118;
  t120 = t110 * t111 * t119;
  t128 = 0.1e1 / t53 / rho[0];
  t133 = my_piecewise3(t32, (0.3e1 * lapl[0] * t54 + 0.3e1 * t128 * sigma[0] - 0.12e2 * t54 * tau[0]) * t30, 0);
  t135 = t49 * t133 * t64;
  t138 = t49 * t111;
  t139 = t36 * t115;
  t140 = t139 * t118;
  t141 = t138 * t140;
  t144 = t114 * t37;
  t145 = 0.1e1 / t144;
  t146 = t113 * t145;
  t147 = t146 * t118;
  t148 = t138 * t147;
  t151 = t62 * t118;
  t152 = t138 * t151;
  t156 = my_piecewise3(t3, 0, t15 * t101 * t39 / 0.32e2 - t105 * t65 / 0.16e2 - t48 * t120 / 0.32e2 - t48 * t135 / 0.16e2 - t48 * t141 / 0.16e2 + t48 * t148 / 0.16e2 + t48 * t152 / 0.16e2);
  tv2rho20 = 0.2e1 * rho[0] * t156 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t162 = t15 * t18 * t110;
  t163 = t59 * t113;
  t164 = t115 * t118;
  t165 = t164 * t74;
  t166 = t163 * t165;
  t169 = t54 * t30;
  t171 = my_piecewise3(t32, -0.3e1 / 0.4e1 * t169, 0);
  t173 = t49 * t171 * t64;
  t177 = t15 * t18 * t49;
  t178 = t74 * t59;
  t179 = t178 * t140;
  t182 = t74 * t113;
  t183 = t145 * t118;
  t184 = t183 * t59;
  t185 = t182 * t184;
  t188 = t74 * t36;
  t189 = t61 * t118;
  t190 = t189 * t59;
  t191 = t188 * t190;
  t195 = my_piecewise3(t3, 0, -t105 * t76 / 0.32e2 - t162 * t166 / 0.32e2 - t48 * t173 / 0.16e2 - t177 * t179 / 0.16e2 + t177 * t185 / 0.16e2 + t177 * t191 / 0.16e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t195 + 0.2e1 * t79;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t200 = t164 * t83;
  t201 = t163 * t200;
  t204 = my_piecewise3(t32, -t72, 0);
  t206 = t49 * t204 * t64;
  t209 = t83 * t59;
  t210 = t209 * t140;
  t213 = t83 * t113;
  t214 = t213 * t184;
  t217 = t83 * t36;
  t218 = t217 * t190;
  t222 = my_piecewise3(t3, 0, -t105 * t85 / 0.32e2 - t162 * t201 / 0.32e2 - t48 * t206 / 0.16e2 - t177 * t210 / 0.16e2 + t177 * t214 / 0.16e2 + t177 * t218 / 0.16e2);
  tv2rholapl0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t88;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t227 = t164 * t91;
  t228 = t163 * t227;
  t232 = my_piecewise3(t32, 0.4e1 * t72, 0);
  t234 = t49 * t232 * t64;
  t237 = t91 * t59;
  t238 = t237 * t140;
  t241 = t91 * t113;
  t242 = t241 * t184;
  t245 = t91 * t36;
  t246 = t245 * t190;
  t250 = my_piecewise3(t3, 0, -t105 * t93 / 0.32e2 - t162 * t228 / 0.32e2 - t48 * t234 / 0.16e2 - t177 * t238 / 0.16e2 + t177 * t242 / 0.16e2 + t177 * t246 / 0.16e2);
  tv2rhotau0 = 0.2e1 * rho[0] * t250 + 0.2e1 * t96;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t253 = t74 * t74;
  t255 = t110 * t253 * t119;
  t258 = my_piecewise3(t32, 0, 0);
  t260 = t49 * t258 * t64;
  t262 = t48 * t260 / 0.16e2;
  t263 = t49 * t253;
  t264 = t263 * t140;
  t267 = t263 * t147;
  t270 = t263 * t151;
  t274 = my_piecewise3(t3, 0, -t48 * t255 / 0.32e2 - t262 - t48 * t264 / 0.16e2 + t48 * t267 / 0.16e2 + t48 * t270 / 0.16e2);
  tv2sigma20 = 0.2e1 * rho[0] * t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t276 = t182 * t200;
  t279 = t83 * t74;
  t280 = t279 * t140;
  t283 = t183 * t74;
  t284 = t213 * t283;
  t287 = t189 * t74;
  t288 = t217 * t287;
  t292 = my_piecewise3(t3, 0, -t162 * t276 / 0.32e2 - t262 - t177 * t280 / 0.16e2 + t177 * t284 / 0.16e2 + t177 * t288 / 0.16e2);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t292;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t294 = t182 * t227;
  t297 = t91 * t74;
  t298 = t297 * t140;
  t301 = t241 * t283;
  t304 = t245 * t287;
  t308 = my_piecewise3(t3, 0, -t162 * t294 / 0.32e2 - t262 - t177 * t298 / 0.16e2 + t177 * t301 / 0.16e2 + t177 * t304 / 0.16e2);
  tv2sigmatau0 = 0.2e1 * rho[0] * t308;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t310 = t83 * t83;
  t312 = t110 * t310 * t119;
  t315 = t49 * t310;
  t316 = t315 * t140;
  t319 = t315 * t147;
  t322 = t315 * t151;
  t326 = my_piecewise3(t3, 0, -t48 * t312 / 0.32e2 - t262 - t48 * t316 / 0.16e2 + t48 * t319 / 0.16e2 + t48 * t322 / 0.16e2);
  tv2lapl20 = 0.2e1 * rho[0] * t326;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t328 = t213 * t227;
  t331 = t91 * t83;
  t332 = t331 * t140;
  t335 = t183 * t83;
  t336 = t241 * t335;
  t339 = t189 * t83;
  t340 = t245 * t339;
  t344 = my_piecewise3(t3, 0, -t162 * t328 / 0.32e2 - t262 - t177 * t332 / 0.16e2 + t177 * t336 / 0.16e2 + t177 * t340 / 0.16e2);
  tv2lapltau0 = 0.2e1 * rho[0] * t344;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t346 = t91 * t91;
  t348 = t110 * t346 * t119;
  t351 = t49 * t346;
  t352 = t351 * t140;
  t355 = t351 * t147;
  t358 = t351 * t151;
  t362 = my_piecewise3(t3, 0, -t48 * t348 / 0.32e2 - t262 - t48 * t352 / 0.16e2 + t48 * t355 / 0.16e2 + t48 * t358 / 0.16e2);
  tv2tau20 = 0.2e1 * rho[0] * t362;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t367 = t16 / t17 / t19;
  t373 = t111 * t59;
  t374 = t110 * t373;
  t376 = 0.1e1 / t117 / t33;
  t377 = t146 * t376;
  t378 = t374 * t377;
  t381 = t113 * t36;
  t382 = t114 * t114;
  t383 = 0.1e1 / t382;
  t384 = t381 * t383;
  t385 = t384 * t376;
  t386 = t374 * t385;
  t389 = t133 * t113;
  t390 = t389 * t184;
  t393 = t49 * t373;
  t394 = t113 * t383;
  t395 = t394 * t376;
  t396 = t393 * t395;
  t400 = 0.1e1 / t382 / t37;
  t401 = t381 * t400;
  t402 = t401 * t376;
  t403 = t393 * t402;
  t406 = t393 * t377;
  t409 = t62 * t376;
  t410 = t393 * t409;
  t416 = t163 * t164 * t133;
  t419 = -0.3e1 / 0.64e2 * t15 * t367 * t39 + 0.3e1 / 0.32e2 * t105 * t148 - 0.3e1 / 0.32e2 * t48 * t378 + 0.3e1 / 0.32e2 * t48 * t386 + 0.3e1 / 0.16e2 * t177 * t390 + t48 * t396 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t403 - 0.3e1 / 0.16e2 * t48 * t406 - t48 * t410 / 0.8e1 + 0.3e1 / 0.32e2 * t105 * t152 - 0.3e1 / 0.32e2 * t162 * t416;
  t420 = t116 * t376;
  t421 = t374 * t420;
  t425 = t133 * t36 * t190;
  t428 = t139 * t376;
  t429 = t393 * t428;
  t432 = t38 * t38;
  t433 = 0.1e1 / t432;
  t434 = t433 * t49;
  t437 = t108 * t110;
  t441 = t434 * t59 * t64 / 0.2e1 - t437 * t59 * t64 / 0.2e1 + t65 / 0.2e1;
  t443 = t441 * t111 * t119;
  t451 = 0.1e1 / t53 / t19;
  t456 = my_piecewise3(t32, (-0.12e2 * lapl[0] * t128 + 0.48e2 * tau[0] * t128 - 0.15e2 * sigma[0] * t451) * t30, 0);
  t458 = t49 * t456 * t64;
  t461 = t15 * t101;
  t471 = t133 * t59 * t140;
  t474 = t36 * t145;
  t475 = t474 * t376;
  t476 = t393 * t475;
  t479 = 0.3e1 / 0.32e2 * t48 * t421 + 0.3e1 / 0.16e2 * t177 * t425 + 0.3e1 / 0.16e2 * t48 * t429 - t48 * t443 / 0.32e2 - t48 * t458 / 0.16e2 + 0.3e1 / 0.64e2 * t461 * t65 - 0.3e1 / 0.32e2 * t105 * t135 - 0.3e1 / 0.64e2 * t105 * t120 - 0.3e1 / 0.32e2 * t105 * t141 - 0.3e1 / 0.16e2 * t177 * t471 - t48 * t476 / 0.16e2;
  t481 = my_piecewise3(t3, 0, t419 + t479);
  tv3rho30 = 0.2e1 * rho[0] * t481 + 0.6e1 * t156;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t489 = t128 * t30;
  t491 = my_piecewise3(t32, 0.3e1 * t489, 0);
  t493 = t49 * t491 * t64;
  t496 = t111 * t113;
  t497 = t145 * t376;
  t498 = t497 * t74;
  t499 = t496 * t498;
  t502 = t111 * t381;
  t503 = t383 * t376;
  t504 = t503 * t74;
  t505 = t502 * t504;
  t509 = t15 * t45 * t49;
  t513 = t171 * t59 * t140;
  t516 = t74 * t111;
  t517 = t516 * t475;
  t522 = t171 * t113;
  t523 = t522 * t184;
  t528 = t61 * t376;
  t529 = t528 * t111;
  t530 = t188 * t529;
  t533 = t461 * t76 / 0.64e2 - t105 * t173 / 0.16e2 - t48 * t493 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t499 + 0.3e1 / 0.32e2 * t162 * t505 - t509 * t179 / 0.16e2 - t177 * t513 / 0.8e1 - t177 * t517 / 0.16e2 + t509 * t185 / 0.16e2 + t177 * t523 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t499 - t177 * t530 / 0.8e1;
  t534 = t115 * t376;
  t535 = t534 * t74;
  t536 = t496 * t535;
  t539 = t516 * t428;
  t542 = t74 * t133;
  t543 = t542 * t140;
  t546 = t183 * t133;
  t547 = t182 * t546;
  t550 = t189 * t133;
  t551 = t188 * t550;
  t557 = t15 * t45 * t110;
  t561 = t15 * t18 * t441;
  t564 = t389 * t165;
  t567 = t164 * t171;
  t568 = t163 * t567;
  t571 = t171 * t36;
  t572 = t571 * t190;
  t575 = t516 * t395;
  t578 = t74 * t381;
  t579 = t400 * t376;
  t580 = t579 * t111;
  t581 = t578 * t580;
  t584 = 0.3e1 / 0.32e2 * t162 * t536 + 0.3e1 / 0.16e2 * t177 * t539 - t177 * t543 / 0.16e2 + t177 * t547 / 0.16e2 + t177 * t551 / 0.16e2 + t509 * t191 / 0.16e2 - t557 * t166 / 0.32e2 - t561 * t166 / 0.32e2 - t162 * t564 / 0.32e2 - t162 * t568 / 0.16e2 + t177 * t572 / 0.8e1 + t177 * t575 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t581;
  t586 = my_piecewise3(t3, 0, t533 + t584);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t586 + 0.4e1 * t195;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t590 = t164 * t204;
  t591 = t163 * t590;
  t594 = t497 * t83;
  t595 = t496 * t594;
  t598 = t503 * t83;
  t599 = t502 * t598;
  t602 = t83 * t111;
  t603 = t602 * t395;
  t606 = t83 * t381;
  t607 = t606 * t580;
  t615 = my_piecewise3(t32, 0.3e1 * t169, 0);
  t617 = t49 * t615 * t64;
  t623 = t204 * t59 * t140;
  t628 = t204 * t113;
  t629 = t628 * t184;
  t632 = -t162 * t591 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t595 + 0.3e1 / 0.32e2 * t162 * t599 + t177 * t603 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t607 + t461 * t85 / 0.64e2 - t105 * t206 / 0.16e2 - t48 * t617 / 0.16e2 - t509 * t210 / 0.16e2 - t177 * t623 / 0.8e1 + t509 * t214 / 0.16e2 + t177 * t629 / 0.8e1;
  t633 = t602 * t475;
  t636 = t602 * t428;
  t641 = t217 * t529;
  t644 = t534 * t83;
  t645 = t496 * t644;
  t648 = t217 * t550;
  t651 = t204 * t36;
  t652 = t651 * t190;
  t655 = t83 * t133;
  t656 = t655 * t140;
  t659 = t213 * t546;
  t668 = t389 * t200;
  t671 = -t177 * t633 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t636 - 0.3e1 / 0.16e2 * t177 * t595 - t177 * t641 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t645 + t177 * t648 / 0.16e2 + t177 * t652 / 0.8e1 - t177 * t656 / 0.16e2 + t177 * t659 / 0.16e2 + t509 * t218 / 0.16e2 - t557 * t201 / 0.32e2 - t561 * t201 / 0.32e2 - t162 * t668 / 0.32e2;
  t673 = my_piecewise3(t3, 0, t632 + t671);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t673 + 0.4e1 * t222;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t678 = t91 * t133 * t140;
  t686 = t496 * t497 * t91;
  t689 = t503 * t91;
  t690 = t502 * t689;
  t693 = t91 * t111;
  t694 = t693 * t395;
  t697 = t91 * t381;
  t698 = t697 * t580;
  t703 = t232 * t59;
  t704 = t703 * t140;
  t709 = t232 * t113;
  t710 = t709 * t184;
  t713 = t693 * t475;
  t716 = -t177 * t678 / 0.16e2 + t509 * t246 / 0.16e2 - t557 * t228 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t686 + 0.3e1 / 0.32e2 * t162 * t690 + t177 * t694 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t698 - t509 * t238 / 0.16e2 - t177 * t704 / 0.8e1 + t509 * t242 / 0.16e2 + t177 * t710 / 0.8e1 - t177 * t713 / 0.16e2;
  t717 = t534 * t91;
  t718 = t496 * t717;
  t721 = t693 * t428;
  t726 = t245 * t529;
  t729 = t241 * t546;
  t732 = t245 * t550;
  t737 = t389 * t227;
  t740 = t164 * t232;
  t741 = t163 * t740;
  t744 = t232 * t36;
  t745 = t744 * t190;
  t753 = my_piecewise3(t32, -0.12e2 * t169, 0);
  t755 = t49 * t753 * t64;
  t758 = 0.3e1 / 0.32e2 * t162 * t718 + 0.3e1 / 0.16e2 * t177 * t721 - 0.3e1 / 0.16e2 * t177 * t686 - t177 * t726 / 0.8e1 + t177 * t729 / 0.16e2 + t177 * t732 / 0.16e2 - t561 * t228 / 0.32e2 - t162 * t737 / 0.32e2 - t162 * t741 / 0.16e2 + t177 * t745 / 0.8e1 + t461 * t93 / 0.64e2 - t105 * t234 / 0.16e2 - t48 * t755 / 0.16e2;
  t760 = my_piecewise3(t3, 0, t716 + t758);
  tv3rho2tau0 = 0.2e1 * rho[0] * t760 + 0.4e1 * t250;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t763 = t258 * t59;
  t764 = t763 * t140;
  t765 = t177 * t764;
  t766 = t765 / 0.16e2;
  t768 = t253 * t59 * t475;
  t771 = t253 * t113;
  t772 = t503 * t59;
  t773 = t771 * t772;
  t776 = t253 * t381;
  t777 = t579 * t59;
  t778 = t776 * t777;
  t781 = t497 * t59;
  t782 = t771 * t781;
  t785 = t776 * t772;
  t788 = t258 * t113;
  t789 = t788 * t184;
  t790 = t177 * t789;
  t791 = t790 / 0.16e2;
  t792 = t189 * t171;
  t793 = t188 * t792;
  t796 = t253 * t36;
  t797 = t528 * t59;
  t798 = t796 * t797;
  t801 = t534 * t59;
  t802 = t771 * t801;
  t805 = t105 * t260;
  t806 = t805 / 0.32e2;
  t807 = t258 * t36;
  t808 = t807 * t190;
  t809 = t177 * t808;
  t810 = t809 / 0.16e2;
  t811 = -t766 - t177 * t768 / 0.16e2 + t177 * t773 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t778 - 0.3e1 / 0.32e2 * t162 * t782 + 0.3e1 / 0.32e2 * t162 * t785 + t791 + t177 * t793 / 0.8e1 - t177 * t798 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t802 - t806 + t810;
  t812 = t164 * t258;
  t813 = t163 * t812;
  t814 = t162 * t813;
  t815 = t814 / 0.32e2;
  t818 = t188 * t567;
  t821 = t796 * t801;
  t826 = t183 * t171;
  t827 = t182 * t826;
  t836 = t182 * t567;
  t840 = t441 * t253 * t119;
  t843 = -t815 - t105 * t264 / 0.32e2 - t177 * t818 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t821 + t105 * t267 / 0.32e2 + t177 * t827 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t782 + t105 * t270 / 0.32e2 - t105 * t255 / 0.64e2 - t162 * t836 / 0.16e2 - t48 * t840 / 0.32e2 - t262;
  t845 = my_piecewise3(t3, 0, t811 + t843);
  tv3rhosigma20 = 0.2e1 * rho[0] * t845 + 0.2e1 * t274;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t848 = t279 * t113;
  t849 = t848 * t772;
  t852 = t606 * t400;
  t853 = t376 * t74;
  t854 = t853 * t59;
  t855 = t852 * t854;
  t858 = t182 * t145;
  t859 = t376 * t83;
  t860 = t859 * t59;
  t861 = t858 * t860;
  t864 = t578 * t383;
  t865 = t864 * t860;
  t872 = t217 * t792;
  t875 = t204 * t74;
  t876 = t875 * t140;
  t879 = t83 * t171;
  t880 = t879 * t140;
  t883 = t628 * t283;
  t886 = t213 * t826;
  t889 = t651 * t287;
  t894 = t522 * t200;
  t897 = t177 * t849 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t855 - 0.3e1 / 0.32e2 * t162 * t861 + 0.3e1 / 0.32e2 * t162 * t865 - t509 * t280 / 0.32e2 + t509 * t284 / 0.32e2 + t177 * t872 / 0.16e2 - t177 * t876 / 0.16e2 - t177 * t880 / 0.16e2 + t177 * t883 / 0.16e2 + t177 * t886 / 0.16e2 + t177 * t889 / 0.16e2 - t561 * t276 / 0.32e2 - t162 * t894 / 0.32e2;
  t898 = t182 * t590;
  t905 = t182 * t115;
  t906 = t905 * t860;
  t909 = t279 * t36;
  t910 = t909 * t801;
  t915 = t279 * t59;
  t916 = t915 * t475;
  t919 = t217 * t61;
  t920 = t919 * t854;
  t923 = -t162 * t898 / 0.32e2 - t815 + t509 * t288 / 0.32e2 - t557 * t276 / 0.64e2 - t766 + t791 + t810 - t806 + 0.3e1 / 0.32e2 * t162 * t906 + 0.3e1 / 0.16e2 * t177 * t910 - 0.3e1 / 0.16e2 * t177 * t861 - t177 * t916 / 0.16e2 - t177 * t920 / 0.8e1 - t262;
  t925 = my_piecewise3(t3, 0, t897 + t923);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t925 + 0.2e1 * t292;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t928 = t376 * t91;
  t929 = t928 * t59;
  t930 = t858 * t929;
  t933 = t864 * t929;
  t936 = t297 * t113;
  t937 = t936 * t772;
  t940 = t697 * t400;
  t941 = t940 * t854;
  t944 = t297 * t59;
  t945 = t944 * t475;
  t950 = t245 * t61;
  t951 = t950 * t854;
  t954 = t905 * t929;
  t957 = t297 * t36;
  t958 = t957 * t801;
  t963 = t744 * t287;
  t966 = t245 * t792;
  t969 = t522 * t227;
  t972 = t182 * t740;
  t975 = -0.3e1 / 0.32e2 * t162 * t930 + 0.3e1 / 0.32e2 * t162 * t933 + t177 * t937 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t941 - t177 * t945 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t930 - t177 * t951 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t954 + 0.3e1 / 0.16e2 * t177 * t958 - t509 * t298 / 0.32e2 + t177 * t963 / 0.16e2 + t177 * t966 / 0.16e2 - t162 * t969 / 0.32e2 - t162 * t972 / 0.32e2;
  t976 = t232 * t74;
  t977 = t976 * t140;
  t980 = t91 * t171;
  t981 = t980 * t140;
  t984 = t709 * t283;
  t987 = t241 * t826;
  t998 = -t177 * t977 / 0.16e2 - t177 * t981 / 0.16e2 + t177 * t984 / 0.16e2 + t177 * t987 / 0.16e2 - t561 * t294 / 0.32e2 + t509 * t301 / 0.32e2 + t509 * t304 / 0.32e2 - t557 * t294 / 0.64e2 - t815 - t766 + t791 + t810 - t806 - t262;
  t1000 = my_piecewise3(t3, 0, t975 + t998);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1000 + 0.2e1 * t308;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1003 = t310 * t59;
  t1004 = t1003 * t475;
  t1007 = t310 * t113;
  t1008 = t1007 * t772;
  t1011 = t310 * t381;
  t1012 = t1011 * t777;
  t1015 = t1007 * t781;
  t1018 = t1011 * t772;
  t1023 = t189 * t204;
  t1024 = t217 * t1023;
  t1027 = t310 * t36;
  t1028 = t1027 * t797;
  t1031 = t1007 * t801;
  t1036 = -t177 * t1004 / 0.16e2 - t766 + t177 * t1008 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1012 - 0.3e1 / 0.32e2 * t162 * t1015 + 0.3e1 / 0.32e2 * t162 * t1018 + t791 + t105 * t322 / 0.32e2 + t177 * t1024 / 0.8e1 - t177 * t1028 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1031 - t105 * t316 / 0.32e2;
  t1037 = t217 * t590;
  t1040 = t1027 * t801;
  t1045 = t183 * t204;
  t1046 = t213 * t1045;
  t1053 = t213 * t590;
  t1057 = t441 * t310 * t119;
  t1060 = -t177 * t1037 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1040 + t105 * t319 / 0.32e2 + t177 * t1046 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1015 - t105 * t312 / 0.64e2 - t162 * t1053 / 0.16e2 - t806 + t810 - t815 - t48 * t1057 / 0.32e2 - t262;
  t1062 = my_piecewise3(t3, 0, t1036 + t1060);
  tv3rholapl20 = 0.2e1 * rho[0] * t1062 + 0.2e1 * t326;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  t1065 = t213 * t145;
  t1066 = t1065 * t929;
  t1069 = t606 * t383;
  t1070 = t1069 * t929;
  t1073 = t331 * t113;
  t1074 = t1073 * t772;
  t1077 = t940 * t860;
  t1081 = t331 * t59 * t475;
  t1084 = t213 * t115;
  t1085 = t1084 * t929;
  t1088 = t331 * t36;
  t1089 = t1088 * t801;
  t1094 = t950 * t860;
  t1097 = t744 * t339;
  t1100 = t245 * t1023;
  t1103 = t628 * t227;
  t1106 = t213 * t740;
  t1109 = t232 * t83;
  t1110 = t1109 * t140;
  t1113 = -0.3e1 / 0.32e2 * t162 * t1066 + 0.3e1 / 0.32e2 * t162 * t1070 + t177 * t1074 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1077 - t177 * t1081 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1085 + 0.3e1 / 0.16e2 * t177 * t1089 - 0.3e1 / 0.16e2 * t177 * t1066 - t177 * t1094 / 0.8e1 + t177 * t1097 / 0.16e2 + t177 * t1100 / 0.16e2 - t162 * t1103 / 0.32e2 - t162 * t1106 / 0.32e2 - t177 * t1110 / 0.16e2;
  t1114 = t91 * t204;
  t1115 = t1114 * t140;
  t1118 = t709 * t335;
  t1121 = t241 * t1045;
  t1134 = -t177 * t1115 / 0.16e2 + t177 * t1118 / 0.16e2 + t177 * t1121 / 0.16e2 - t557 * t328 / 0.64e2 - t509 * t332 / 0.32e2 + t509 * t336 / 0.32e2 + t509 * t340 / 0.32e2 - t561 * t328 / 0.32e2 - t815 - t766 + t791 + t810 - t806 - t262;
  t1136 = my_piecewise3(t3, 0, t1113 + t1134);
  tv3rholapltau0 = 0.2e1 * rho[0] * t1136 + 0.2e1 * t344;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1140 = t245 * t189 * t232;
  t1143 = t346 * t36;
  t1144 = t1143 * t797;
  t1147 = t346 * t113;
  t1148 = t1147 * t801;
  t1153 = t245 * t740;
  t1156 = t1143 * t801;
  t1162 = t241 * t183 * t232;
  t1165 = t1147 * t781;
  t1172 = t241 * t740;
  t1175 = t177 * t1140 / 0.8e1 - t177 * t1144 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1148 - t105 * t352 / 0.32e2 - t177 * t1153 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1156 + t105 * t355 / 0.32e2 + t177 * t1162 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1165 + t105 * t358 / 0.32e2 - t105 * t348 / 0.64e2 - t162 * t1172 / 0.16e2;
  t1176 = t346 * t59;
  t1177 = t1176 * t475;
  t1182 = t346 * t381;
  t1183 = t1182 * t772;
  t1186 = t1147 * t772;
  t1189 = t1182 * t777;
  t1193 = t441 * t346 * t119;
  t1196 = -t177 * t1177 / 0.16e2 - t766 - 0.3e1 / 0.32e2 * t162 * t1165 + 0.3e1 / 0.32e2 * t162 * t1183 + t177 * t1186 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1189 + t791 - t806 + t810 - t815 - t48 * t1193 / 0.32e2 - t262;
  t1198 = my_piecewise3(t3, 0, t1175 + t1196);
  tv3rhotau20 = 0.2e1 * rho[0] * t1198 + 0.2e1 * t362;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1201 = t807 * t287;
  t1202 = t177 * t1201;
  t1203 = 0.3e1 / 0.16e2 * t1202;
  t1204 = t253 * t74;
  t1205 = t49 * t1204;
  t1206 = t1205 * t428;
  t1209 = t1205 * t377;
  t1212 = t1205 * t409;
  t1215 = t182 * t812;
  t1216 = t162 * t1215;
  t1217 = 0.3e1 / 0.32e2 * t1216;
  t1218 = t110 * t1204;
  t1219 = t1218 * t420;
  t1222 = t258 * t74;
  t1223 = t1222 * t140;
  t1224 = t177 * t1223;
  t1225 = 0.3e1 / 0.16e2 * t1224;
  t1226 = t1205 * t475;
  t1229 = t1218 * t377;
  t1232 = t1218 * t385;
  t1235 = t788 * t283;
  t1236 = t177 * t1235;
  t1237 = 0.3e1 / 0.16e2 * t1236;
  t1238 = t1205 * t395;
  t1241 = t1205 * t402;
  t1244 = t434 * t74;
  t1246 = t437 * t74;
  t1249 = t1244 * t64 / 0.2e1 - t1246 * t64 / 0.2e1 + t76 / 0.2e1;
  t1251 = t1249 * t253 * t119;
  t1254 = t1203 + 0.3e1 / 0.16e2 * t48 * t1206 - 0.3e1 / 0.16e2 * t48 * t1209 - t48 * t1212 / 0.8e1 - t1217 + 0.3e1 / 0.32e2 * t48 * t1219 - t1225 - t48 * t1226 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1229 + 0.3e1 / 0.32e2 * t48 * t1232 + t1237 + t48 * t1238 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1241 - t48 * t1251 / 0.32e2 - t262;
  t1255 = my_piecewise3(t3, 0, t1254);
  tv3sigma30 = 0.2e1 * rho[0] * t1255;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1257 = t83 * t258;
  t1258 = t1257 * t140;
  t1259 = t177 * t1258;
  t1260 = t1259 / 0.16e2;
  t1261 = t183 * t258;
  t1262 = t213 * t1261;
  t1263 = t177 * t1262;
  t1264 = t1263 / 0.16e2;
  t1265 = t189 * t258;
  t1266 = t217 * t1265;
  t1267 = t177 * t1266;
  t1268 = t1267 / 0.16e2;
  t1270 = t15 * t18 * t1249;
  t1273 = t788 * t200;
  t1274 = t162 * t1273;
  t1275 = t1274 / 0.32e2;
  t1276 = t1202 / 0.8e1;
  t1277 = t1216 / 0.16e2;
  t1278 = t1224 / 0.8e1;
  t1279 = t1236 / 0.8e1;
  t1280 = t83 * t253;
  t1281 = t1280 * t475;
  t1284 = t1280 * t428;
  t1287 = t497 * t253;
  t1288 = t213 * t1287;
  t1291 = t528 * t253;
  t1292 = t217 * t1291;
  t1295 = t771 * t644;
  t1300 = t776 * t598;
  t1303 = t1280 * t395;
  t1306 = t579 * t253;
  t1307 = t606 * t1306;
  t1310 = -t1260 + t1264 + t1268 - t1270 * t276 / 0.32e2 - t1275 + t1276 - t1277 - t1278 + t1279 - t177 * t1281 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t1284 - 0.3e1 / 0.16e2 * t177 * t1288 - t177 * t1292 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1295 - 0.3e1 / 0.32e2 * t162 * t1288 + 0.3e1 / 0.32e2 * t162 * t1300 + t177 * t1303 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1307 - t262;
  t1311 = my_piecewise3(t3, 0, t1310);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1311;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1313 = t241 * t1261;
  t1314 = t177 * t1313;
  t1315 = t1314 / 0.16e2;
  t1316 = t245 * t1265;
  t1317 = t177 * t1316;
  t1318 = t1317 / 0.16e2;
  t1321 = t788 * t227;
  t1322 = t162 * t1321;
  t1323 = t1322 / 0.32e2;
  t1324 = t91 * t258;
  t1325 = t1324 * t140;
  t1326 = t177 * t1325;
  t1327 = t1326 / 0.16e2;
  t1328 = t91 * t253;
  t1329 = t1328 * t475;
  t1332 = t771 * t717;
  t1335 = t1328 * t428;
  t1338 = t241 * t1287;
  t1341 = t245 * t1291;
  t1344 = t1328 * t395;
  t1347 = t697 * t1306;
  t1352 = t776 * t689;
  t1355 = t1315 + t1318 - t1270 * t294 / 0.32e2 - t1323 - t1327 + t1276 - t1277 - t1278 + t1279 - t177 * t1329 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1332 + 0.3e1 / 0.16e2 * t177 * t1335 - 0.3e1 / 0.16e2 * t177 * t1338 - t177 * t1341 / 0.8e1 + t177 * t1344 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1347 - 0.3e1 / 0.32e2 * t162 * t1338 + 0.3e1 / 0.32e2 * t162 * t1352 - t262;
  t1356 = my_piecewise3(t3, 0, t1355);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1356;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1359 = t1249 * t310 * t119;
  t1362 = t1007 * t498;
  t1365 = t528 * t74;
  t1366 = t1027 * t1365;
  t1369 = t1007 * t535;
  t1372 = t1027 * t535;
  t1375 = t1259 / 0.8e1;
  t1376 = t1263 / 0.8e1;
  t1377 = t1267 / 0.8e1;
  t1378 = t1274 / 0.16e2;
  t1379 = t1202 / 0.16e2;
  t1380 = t1216 / 0.32e2;
  t1381 = t1224 / 0.16e2;
  t1382 = t310 * t74;
  t1383 = t1382 * t475;
  t1388 = t1011 * t504;
  t1391 = t1007 * t504;
  t1394 = t579 * t74;
  t1395 = t1011 * t1394;
  t1398 = t1236 / 0.16e2;
  t1399 = -t48 * t1359 / 0.32e2 - 0.3e1 / 0.16e2 * t177 * t1362 - t177 * t1366 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1369 + 0.3e1 / 0.16e2 * t177 * t1372 - t1375 + t1376 + t1377 - t1378 + t1379 - t1380 - t1381 - t177 * t1383 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t1362 + 0.3e1 / 0.32e2 * t162 * t1388 + t177 * t1391 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1395 + t1398 - t262;
  t1400 = my_piecewise3(t3, 0, t1399);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1400;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  t1404 = -t1270 * t328 / 0.32e2 + t1315 + t1318 - t1323 - t1327 - t1260 + t1264 + t1268 - t1275 + t1379 - t1380;
  t1405 = t331 * t74;
  t1406 = t1405 * t475;
  t1409 = t859 * t74;
  t1410 = t950 * t1409;
  t1413 = t928 * t74;
  t1414 = t1084 * t1413;
  t1417 = t1088 * t535;
  t1420 = t241 * t145;
  t1421 = t1420 * t1409;
  t1424 = t940 * t1409;
  t1429 = t1069 * t1413;
  t1432 = t1073 * t504;
  t1435 = -t1381 - t177 * t1406 / 0.16e2 + t1398 - t177 * t1410 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1414 + 0.3e1 / 0.16e2 * t177 * t1417 - 0.3e1 / 0.16e2 * t177 * t1421 - 0.3e1 / 0.16e2 * t177 * t1424 - 0.3e1 / 0.32e2 * t162 * t1421 + 0.3e1 / 0.32e2 * t162 * t1429 + t177 * t1432 / 0.4e1 - t262;
  t1437 = my_piecewise3(t3, 0, t1404 + t1435);
  tv3sigmalapltau0 = 0.2e1 * rho[0] * t1437;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1440 = t1249 * t346 * t119;
  t1443 = t1143 * t535;
  t1446 = t1147 * t498;
  t1449 = t1143 * t1365;
  t1452 = t1147 * t535;
  t1455 = t1314 / 0.8e1;
  t1456 = t1317 / 0.8e1;
  t1457 = t1322 / 0.16e2;
  t1458 = t1326 / 0.8e1;
  t1459 = t346 * t74;
  t1460 = t1459 * t475;
  t1463 = t1182 * t504;
  t1466 = t1147 * t504;
  t1469 = t1182 * t1394;
  t1474 = -t48 * t1440 / 0.32e2 + 0.3e1 / 0.16e2 * t177 * t1443 - 0.3e1 / 0.16e2 * t177 * t1446 - t177 * t1449 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1452 + t1455 + t1456 - t1457 - t1458 + t1379 - t1380 - t177 * t1460 / 0.16e2 - t1381 + 0.3e1 / 0.32e2 * t162 * t1463 + t177 * t1466 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1469 - 0.3e1 / 0.32e2 * t162 * t1446 + t1398 - t262;
  t1475 = my_piecewise3(t3, 0, t1474);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1475;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1477 = t434 * t83;
  t1479 = t437 * t83;
  t1482 = t1477 * t64 / 0.2e1 - t1479 * t64 / 0.2e1 + t85 / 0.2e1;
  t1484 = t1482 * t310 * t119;
  t1487 = t310 * t83;
  t1488 = t49 * t1487;
  t1489 = t1488 * t409;
  t1492 = t110 * t1487;
  t1493 = t1492 * t420;
  t1496 = t1488 * t428;
  t1499 = t1488 * t377;
  t1502 = 0.3e1 / 0.16e2 * t1259;
  t1503 = 0.3e1 / 0.16e2 * t1263;
  t1504 = 0.3e1 / 0.16e2 * t1267;
  t1505 = 0.3e1 / 0.32e2 * t1274;
  t1506 = t1488 * t475;
  t1509 = t1492 * t377;
  t1512 = t1492 * t385;
  t1515 = t1488 * t395;
  t1518 = t1488 * t402;
  t1521 = -t48 * t1484 / 0.32e2 - t48 * t1489 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1493 + 0.3e1 / 0.16e2 * t48 * t1496 - 0.3e1 / 0.16e2 * t48 * t1499 - t1502 + t1503 + t1504 - t1505 - t48 * t1506 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1509 + 0.3e1 / 0.32e2 * t48 * t1512 + t48 * t1515 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1518 - t262;
  t1522 = my_piecewise3(t3, 0, t1521);
  tv3lapl30 = 0.2e1 * rho[0] * t1522;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  t1525 = t15 * t18 * t1482;
  t1528 = t91 * t310;
  t1529 = t1528 * t475;
  t1532 = t528 * t310;
  t1533 = t245 * t1532;
  t1536 = t1007 * t717;
  t1539 = t1528 * t428;
  t1542 = t497 * t310;
  t1543 = t241 * t1542;
  t1548 = t1011 * t689;
  t1551 = t1528 * t395;
  t1554 = t579 * t310;
  t1555 = t697 * t1554;
  t1558 = -t1525 * t328 / 0.32e2 + t1315 + t1318 - t1323 - t1327 - t1375 + t1376 + t1377 - t1378 - t177 * t1529 / 0.16e2 - t177 * t1533 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1536 + 0.3e1 / 0.16e2 * t177 * t1539 - 0.3e1 / 0.16e2 * t177 * t1543 - 0.3e1 / 0.32e2 * t162 * t1543 + 0.3e1 / 0.32e2 * t162 * t1548 + t177 * t1551 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1555 - t262;
  t1559 = my_piecewise3(t3, 0, t1558);
  tv3lapl2tau0 = 0.2e1 * rho[0] * t1559;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  t1562 = t1482 * t346 * t119;
  t1565 = t1147 * t594;
  t1569 = t1143 * t528 * t83;
  t1572 = t1147 * t644;
  t1575 = t1143 * t644;
  t1578 = t346 * t83;
  t1579 = t1578 * t475;
  t1584 = t1182 * t598;
  t1587 = t1147 * t598;
  t1591 = t1182 * t579 * t83;
  t1594 = -t48 * t1562 / 0.32e2 - 0.3e1 / 0.16e2 * t177 * t1565 - t177 * t1569 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1572 + 0.3e1 / 0.16e2 * t177 * t1575 + t1455 + t1456 - t1457 - t1458 - t1260 + t1264 + t1268 - t1275 - t177 * t1579 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t1565 + 0.3e1 / 0.32e2 * t162 * t1584 + t177 * t1587 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1591 - t262;
  t1595 = my_piecewise3(t3, 0, t1594);
  tv3lapltau20 = 0.2e1 * rho[0] * t1595;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1597 = t346 * t91;
  t1598 = t49 * t1597;
  t1599 = t1598 * t377;
  t1602 = t1598 * t409;
  t1605 = t110 * t1597;
  t1606 = t1605 * t420;
  t1609 = t1598 * t428;
  t1612 = t434 * t91;
  t1614 = t437 * t91;
  t1617 = t1612 * t64 / 0.2e1 - t1614 * t64 / 0.2e1 + t93 / 0.2e1;
  t1619 = t1617 * t346 * t119;
  t1622 = 0.3e1 / 0.16e2 * t1314;
  t1623 = 0.3e1 / 0.16e2 * t1317;
  t1624 = 0.3e1 / 0.32e2 * t1322;
  t1625 = 0.3e1 / 0.16e2 * t1326;
  t1626 = t1598 * t475;
  t1629 = t1605 * t377;
  t1632 = t1605 * t385;
  t1635 = t1598 * t395;
  t1638 = t1598 * t402;
  t1641 = -0.3e1 / 0.16e2 * t48 * t1599 - t48 * t1602 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1606 + 0.3e1 / 0.16e2 * t48 * t1609 - t48 * t1619 / 0.32e2 + t1622 + t1623 - t1624 - t1625 - t48 * t1626 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1629 + 0.3e1 / 0.32e2 * t48 * t1632 + t48 * t1635 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1638 - t262;
  t1642 = my_piecewise3(t3, 0, t1641);
  tv3tau30 = 0.2e1 * rho[0] * t1642;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1651 = t133 * t111;
  t1657 = t534 * t133;
  t1661 = t497 * t111;
  t1662 = t389 * t1661;
  t1686 = t456 * t113;
  t1694 = t503 * t133;
  t1698 = 0.15e2 / 0.128e3 * t15 * t16 / t17 / t25 * t39 + 0.9e1 / 0.8e1 * t177 * t1651 * t428 - 0.3e1 / 0.16e2 * t557 * t416 + 0.9e1 / 0.16e2 * t162 * t496 * t1657 - 0.9e1 / 0.8e1 * t177 * t1662 + 0.3e1 / 0.2e1 * t177 * t389 * t503 * t111 - 0.9e1 / 0.8e1 * t177 * t133 * t381 * t580 - t177 * t456 * t59 * t140 / 0.4e1 - 0.3e1 / 0.8e1 * t509 * t471 - 0.3e1 / 0.8e1 * t177 * t1651 * t475 - t162 * t163 * t164 * t456 / 0.8e1 + t177 * t1686 * t184 / 0.4e1 + 0.3e1 / 0.8e1 * t509 * t390 - 0.9e1 / 0.16e2 * t162 * t1662 + 0.9e1 / 0.16e2 * t162 * t502 * t1694;
  t1704 = t528 * t133;
  t1712 = t111 * t111;
  t1713 = t110 * t1712;
  t1714 = t117 * t117;
  t1715 = 0.1e1 / t1714;
  t1716 = t401 * t1715;
  t1720 = t113 * t113;
  t1722 = 0.1e1 / t382 / t114;
  t1724 = t1720 * t1722 * t1715;
  t1728 = t49 * t1712;
  t1730 = t113 * t400 * t1715;
  t1735 = t381 * t1722 * t1715;
  t1740 = 0.1e1 / t382 / t144;
  t1742 = t1720 * t1740 * t1715;
  t1746 = t146 * t1715;
  t1750 = t384 * t1715;
  t1761 = 0.1e1 / t432 / t38 * t49;
  t1765 = t433 * t110;
  t1772 = t434 * t111;
  t1779 = t108 * t441;
  t1786 = t437 * t111;
  t1793 = t120 / 0.4e1 + t135 / 0.2e1 + t141 / 0.2e1 - t148 / 0.2e1 - t152 / 0.2e1 - t1761 * t111 * t119 / 0.2e1 + t1765 * t111 * t119 / 0.2e1 + t434 * t133 * t64 / 0.2e1 + t1772 * t140 / 0.2e1 - t1772 * t147 / 0.2e1 - t1772 * t151 / 0.2e1 - t1779 * t59 * t64 / 0.2e1 - t437 * t133 * t64 / 0.2e1 - t1786 * t140 / 0.2e1 + t1786 * t147 / 0.2e1 + t1786 * t151 / 0.2e1;
  t1808 = my_piecewise3(t32, (0.6e2 * lapl[0] * t451 - 0.24e3 * tau[0] * t451 + 0.9e2 * sigma[0] / t53 / t25) * t30, 0);
  t1817 = t177 * t456 * t36 * t190 / 0.4e1 - 0.3e1 / 0.4e1 * t177 * t111 * t36 * t1704 + 0.3e1 / 0.8e1 * t509 * t425 - 0.5e1 / 0.32e2 * t561 * t416 + 0.11e2 / 0.16e2 * t48 * t1713 * t1716 - 0.15e2 / 0.32e2 * t48 * t1713 * t1724 + 0.11e2 / 0.16e2 * t48 * t1728 * t1730 - 0.25e2 / 0.16e2 * t48 * t1728 * t1735 + 0.15e2 / 0.16e2 * t48 * t1728 * t1742 + 0.9e1 / 0.16e2 * t48 * t1713 * t1746 - 0.9e1 / 0.16e2 * t48 * t1713 * t1750 - t48 * t1793 * t111 * t119 / 0.32e2 - t48 * t49 * t1808 * t64 / 0.16e2 + 0.3e1 / 0.32e2 * t461 * t135 + 0.3e1 / 0.64e2 * t461 * t120;
  t1819 = t116 * t1715;
  t1825 = t441 * t373;
  t1829 = t15 * t367;
  t1840 = t139 * t1715;
  t1846 = t474 * t1715;
  t1855 = t36 * t383 * t1715;
  t1863 = -0.11e2 / 0.32e2 * t48 * t1713 * t1819 + 0.3e1 / 0.16e2 * t105 * t421 + 0.5e1 / 0.32e2 * t48 * t1825 * t420 - 0.3e1 / 0.32e2 * t1829 * t65 + 0.3e1 / 0.16e2 * t105 * t386 - 0.5e1 / 0.32e2 * t48 * t1825 * t377 + 0.5e1 / 0.32e2 * t48 * t1825 * t385 - 0.11e2 / 0.16e2 * t48 * t1728 * t1840 + 0.3e1 / 0.8e1 * t105 * t429 + 0.3e1 / 0.8e1 * t48 * t1728 * t1846 + 0.3e1 / 0.32e2 * t461 * t141 - t105 * t476 / 0.8e1 - t48 * t1728 * t1855 / 0.16e2 + t105 * t396 / 0.2e1 - 0.3e1 / 0.8e1 * t105 * t403;
  t1864 = t394 * t1715;
  t1868 = t133 * t133;
  t1869 = t49 * t1868;
  t1885 = t62 * t1715;
  t1910 = -0.7e1 / 0.32e2 * t48 * t1713 * t1864 - 0.3e1 / 0.16e2 * t48 * t1869 * t140 - t105 * t458 / 0.8e1 + 0.3e1 / 0.16e2 * t48 * t1869 * t151 - t105 * t443 / 0.16e2 + 0.11e2 / 0.16e2 * t48 * t1728 * t1746 - t105 * t410 / 0.4e1 + 0.3e1 / 0.8e1 * t48 * t1728 * t1885 - 0.3e1 / 0.32e2 * t461 * t152 - 0.3e1 / 0.32e2 * t48 * t110 * t1868 * t119 + 0.3e1 / 0.16e2 * t48 * t1869 * t147 - 0.3e1 / 0.2e1 * t48 * t1728 * t1864 + 0.9e1 / 0.8e1 * t48 * t1728 * t1716 - 0.3e1 / 0.32e2 * t461 * t148 - 0.3e1 / 0.8e1 * t105 * t406 - 0.3e1 / 0.16e2 * t105 * t378;
  t1913 = my_piecewise3(t3, 0, t1698 + t1817 + t1863 + t1910);
  tv4rho40 = 0.2e1 * rho[0] * t1913 + 0.8e1 * t481;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1921 = t578 * t400;
  t1923 = t376 * t133 * t59;
  t1927 = t858 * t1923;
  t1930 = t178 * t36;
  t1931 = t497 * t133;
  t1935 = t188 * t61;
  t1939 = t163 * t115;
  t1940 = t853 * t133;
  t1949 = t59 * t381;
  t1950 = t1949 * t383;
  t1954 = t171 * t381;
  t1958 = t383 * t1715;
  t1960 = t182 * t1958 * t373;
  t1963 = t400 * t1715;
  t1965 = t578 * t1963 * t373;
  t1968 = t373 * t113;
  t1969 = t145 * t1715;
  t1970 = t1969 * t74;
  t1971 = t1968 * t1970;
  t1977 = t15 * t101 * t49;
  t1982 = t522 * t1661;
  t1989 = 0.3e1 / 0.4e1 * t177 * t542 * t113 * t772 - 0.9e1 / 0.16e2 * t177 * t1921 * t1923 - 0.9e1 / 0.16e2 * t177 * t1927 - 0.3e1 / 0.16e2 * t177 * t1930 * t1931 - 0.3e1 / 0.8e1 * t177 * t1935 * t1923 + 0.9e1 / 0.32e2 * t162 * t1939 * t1940 + 0.9e1 / 0.16e2 * t177 * t1930 * t1657 - 0.9e1 / 0.32e2 * t162 * t1927 + 0.9e1 / 0.32e2 * t162 * t1950 * t1940 - 0.9e1 / 0.16e2 * t177 * t1954 * t580 - 0.3e1 / 0.2e1 * t177 * t1960 + 0.9e1 / 0.8e1 * t177 * t1965 + 0.9e1 / 0.16e2 * t162 * t1971 + 0.3e1 / 0.8e1 * t509 * t575 - 0.3e1 / 0.64e2 * t1977 * t185 - 0.9e1 / 0.32e2 * t509 * t499 - 0.9e1 / 0.16e2 * t177 * t1982 + 0.11e2 / 0.16e2 * t177 * t1971 + 0.3e1 / 0.64e2 * t1977 * t179;
  t1992 = t171 * t111;
  t2000 = t74 * t373;
  t2004 = t74 * t1720;
  t2005 = t1740 * t1715;
  t2006 = t2005 * t373;
  t2021 = t115 * t1715;
  t2022 = t2021 * t74;
  t2048 = 0.9e1 / 0.32e2 * t509 * t539 + 0.9e1 / 0.16e2 * t177 * t1992 * t428 - 0.5e1 / 0.32e2 * t561 * t499 + 0.5e1 / 0.32e2 * t561 * t505 - 0.25e2 / 0.16e2 * t177 * t2000 * t1735 + 0.15e2 / 0.16e2 * t177 * t2004 * t2006 + 0.3e1 / 0.4e1 * t177 * t1992 * t395 + 0.11e2 / 0.16e2 * t177 * t2000 * t1730 - 0.9e1 / 0.32e2 * t509 * t581 - 0.3e1 / 0.8e1 * t177 * t571 * t529 - 0.11e2 / 0.32e2 * t162 * t1968 * t2022 - 0.3e1 / 0.32e2 * t509 * t543 - 0.9e1 / 0.64e2 * t557 * t499 - 0.3e1 / 0.16e2 * t177 * t491 * t59 * t140 - 0.3e1 / 0.16e2 * t177 * t171 * t133 * t140 - 0.9e1 / 0.32e2 * t162 * t1982 - 0.7e1 / 0.32e2 * t162 * t1960 + 0.3e1 / 0.16e2 * t509 * t523 + 0.3e1 / 0.32e2 * t509 * t547 - 0.3e1 / 0.16e2 * t509 * t513;
  t2063 = t61 * t1715;
  t2064 = t2063 * t373;
  t2074 = t15 * t18 * t1793;
  t2087 = t164 * t491;
  t2094 = t189 * t456;
  t2101 = t15 * t101 * t110;
  t2106 = -0.3e1 / 0.32e2 * t509 * t517 - 0.3e1 / 0.16e2 * t177 * t1992 * t475 - t177 * t2000 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t2000 * t1840 - 0.3e1 / 0.16e2 * t509 * t530 + 0.3e1 / 0.8e1 * t177 * t188 * t2064 + 0.9e1 / 0.64e2 * t557 * t536 + 0.3e1 / 0.8e1 * t177 * t2000 * t1846 - t2074 * t166 / 0.32e2 - t561 * t564 / 0.16e2 - 0.3e1 / 0.32e2 * t561 * t568 - t162 * t1686 * t165 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t389 * t567 - 0.3e1 / 0.32e2 * t162 * t163 * t2087 + 0.3e1 / 0.16e2 * t177 * t571 * t550 + t177 * t188 * t2094 / 0.16e2 - 0.3e1 / 0.64e2 * t1977 * t191 + 0.3e1 / 0.128e3 * t2101 * t166 + 0.3e1 / 0.16e2 * t509 * t572;
  t2108 = t15 * t45 * t441;
  t2115 = t534 * t171;
  t2123 = t183 * t456;
  t2129 = t491 * t113;
  t2136 = t503 * t171;
  t2140 = t373 * t381;
  t2141 = t1958 * t74;
  t2153 = t373 * t1720;
  t2154 = t1722 * t1715;
  t2155 = t2154 * t74;
  t2169 = my_piecewise3(t32, -0.15e2 * t451 * t30, 0);
  t2174 = -0.3e1 / 0.64e2 * t2108 * t166 - 0.3e1 / 0.64e2 * t557 * t564 + 0.5e1 / 0.32e2 * t561 * t536 + 0.9e1 / 0.32e2 * t162 * t496 * t2115 - t177 * t74 * t456 * t140 / 0.16e2 + t177 * t182 * t2123 / 0.16e2 + 0.9e1 / 0.64e2 * t557 * t505 + 0.3e1 / 0.16e2 * t177 * t2129 * t184 + 0.3e1 / 0.16e2 * t177 * t522 * t546 + 0.9e1 / 0.32e2 * t162 * t502 * t2136 - 0.9e1 / 0.16e2 * t162 * t2140 * t2141 + 0.3e1 / 0.32e2 * t509 * t551 + 0.3e1 / 0.16e2 * t177 * t491 * t36 * t190 + 0.11e2 / 0.16e2 * t162 * t1965 - 0.15e2 / 0.32e2 * t162 * t2153 * t2155 - 0.3e1 / 0.32e2 * t557 * t568 - 0.3e1 / 0.128e3 * t1829 * t76 + 0.3e1 / 0.64e2 * t461 * t173 - 0.3e1 / 0.32e2 * t105 * t493 - t48 * t49 * t2169 * t64 / 0.16e2;
  t2177 = my_piecewise3(t3, 0, t1989 + t2048 + t2106 + t2174);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2177 + 0.6e1 * t586;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2181 = t209 * t36;
  t2192 = t859 * t133;
  t2196 = t163 * t145;
  t2197 = t2196 * t2192;
  t2213 = t204 * t111;
  t2217 = t83 * t373;
  t2221 = t2154 * t83;
  t2228 = t83 * t1720;
  t2236 = t1963 * t83;
  t2237 = t2140 * t2236;
  t2242 = -0.3e1 / 0.16e2 * t177 * t2181 * t1931 + 0.3e1 / 0.4e1 * t177 * t655 * t113 * t772 - 0.9e1 / 0.16e2 * t177 * t852 * t1923 + 0.9e1 / 0.32e2 * t162 * t1950 * t2192 - 0.9e1 / 0.32e2 * t162 * t2197 + 0.9e1 / 0.16e2 * t177 * t2181 * t1657 - 0.9e1 / 0.16e2 * t177 * t2197 - 0.3e1 / 0.8e1 * t177 * t919 * t1923 + 0.9e1 / 0.32e2 * t162 * t1939 * t2192 - 0.3e1 / 0.32e2 * t509 * t633 - 0.3e1 / 0.16e2 * t177 * t2213 * t475 - t177 * t2217 * t1855 / 0.16e2 - 0.15e2 / 0.32e2 * t162 * t2153 * t2221 - 0.25e2 / 0.16e2 * t177 * t2217 * t1735 + 0.15e2 / 0.16e2 * t177 * t2228 * t2006 - 0.5e1 / 0.32e2 * t561 * t595 + 0.5e1 / 0.32e2 * t561 * t599 + 0.11e2 / 0.16e2 * t162 * t2237 + 0.3e1 / 0.8e1 * t509 * t603;
  t2248 = t204 * t381;
  t2255 = t2217 * t1864;
  t2263 = t503 * t204;
  t2279 = t213 * t1969 * t373;
  t2296 = 0.3e1 / 0.4e1 * t177 * t2213 * t395 - 0.9e1 / 0.32e2 * t509 * t607 - 0.9e1 / 0.16e2 * t177 * t2248 * t580 + 0.11e2 / 0.16e2 * t177 * t2217 * t1730 - 0.3e1 / 0.2e1 * t177 * t2255 + 0.9e1 / 0.8e1 * t177 * t2237 + 0.3e1 / 0.16e2 * t177 * t628 * t546 + 0.9e1 / 0.32e2 * t162 * t502 * t2263 - 0.3e1 / 0.16e2 * t509 * t623 - 0.3e1 / 0.32e2 * t509 * t656 + 0.3e1 / 0.32e2 * t509 * t648 + 0.3e1 / 0.16e2 * t509 * t652 - 0.11e2 / 0.16e2 * t177 * t2217 * t1840 + 0.11e2 / 0.16e2 * t177 * t2279 - 0.3e1 / 0.16e2 * t509 * t641 + 0.3e1 / 0.8e1 * t177 * t217 * t2064 + 0.9e1 / 0.64e2 * t557 * t645 + 0.9e1 / 0.16e2 * t177 * t2213 * t428 - 0.3e1 / 0.64e2 * t1977 * t214 - 0.9e1 / 0.32e2 * t509 * t595;
  t2298 = t628 * t1661;
  t2313 = t2021 * t83;
  t2319 = t534 * t204;
  t2329 = t615 * t36;
  t2337 = t1958 * t83;
  t2353 = -0.9e1 / 0.16e2 * t177 * t2298 + 0.3e1 / 0.8e1 * t177 * t2217 * t1846 + 0.3e1 / 0.64e2 * t1977 * t210 + 0.9e1 / 0.32e2 * t509 * t636 + 0.3e1 / 0.128e3 * t2101 * t201 - 0.3e1 / 0.8e1 * t177 * t651 * t529 - 0.11e2 / 0.32e2 * t162 * t1968 * t2313 + 0.5e1 / 0.32e2 * t561 * t645 + 0.9e1 / 0.32e2 * t162 * t496 * t2319 + 0.3e1 / 0.16e2 * t177 * t651 * t550 + t177 * t217 * t2094 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t2329 * t190 - 0.7e1 / 0.32e2 * t162 * t2255 + 0.9e1 / 0.16e2 * t162 * t2279 - 0.9e1 / 0.16e2 * t162 * t2140 * t2337 - 0.9e1 / 0.64e2 * t557 * t595 - 0.3e1 / 0.16e2 * t177 * t615 * t59 * t140 - 0.3e1 / 0.16e2 * t177 * t204 * t133 * t140 - 0.9e1 / 0.32e2 * t162 * t2298;
  t2360 = t615 * t113;
  t2364 = t164 * t615;
  t2396 = my_piecewise3(t32, -0.12e2 * t489, 0);
  t2407 = 0.3e1 / 0.16e2 * t509 * t629 + 0.3e1 / 0.32e2 * t509 * t659 + 0.9e1 / 0.64e2 * t557 * t599 + 0.3e1 / 0.16e2 * t177 * t2360 * t184 - 0.3e1 / 0.32e2 * t162 * t163 * t2364 - 0.3e1 / 0.64e2 * t2108 * t201 - 0.3e1 / 0.64e2 * t557 * t668 - 0.3e1 / 0.32e2 * t557 * t591 - t2074 * t201 / 0.32e2 - t561 * t668 / 0.16e2 - 0.3e1 / 0.32e2 * t561 * t591 - t162 * t1686 * t200 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t389 * t590 - t177 * t83 * t456 * t140 / 0.16e2 + t177 * t213 * t2123 / 0.16e2 - 0.3e1 / 0.64e2 * t1977 * t218 - t48 * t49 * t2396 * t64 / 0.16e2 + 0.3e1 / 0.64e2 * t461 * t206 - 0.3e1 / 0.32e2 * t105 * t617 - 0.3e1 / 0.128e3 * t1829 * t85;
  t2410 = my_piecewise3(t3, 0, t2242 + t2296 + t2353 + t2407);
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2410 + 0.6e1 * t673;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2414 = t241 * t383;
  t2422 = t389 * t145 * t929;
  t2425 = t237 * t36;
  t2429 = t928 * t133;
  t2444 = t1969 * t91;
  t2445 = t1968 * t2444;
  t2450 = t232 * t111;
  t2454 = t91 * t373;
  t2459 = t2140 * t1963 * t91;
  t2462 = t2154 * t91;
  t2469 = t91 * t1720;
  t2473 = t1958 * t91;
  t2477 = t2454 * t1864;
  t2480 = 0.3e1 / 0.4e1 * t177 * t2414 * t1923 - 0.9e1 / 0.16e2 * t177 * t940 * t1923 - 0.9e1 / 0.32e2 * t162 * t2422 - 0.3e1 / 0.16e2 * t177 * t2425 * t1931 + 0.9e1 / 0.32e2 * t162 * t1939 * t2429 + 0.9e1 / 0.16e2 * t177 * t2425 * t1657 - 0.9e1 / 0.16e2 * t177 * t2422 - 0.3e1 / 0.8e1 * t177 * t950 * t1923 + 0.9e1 / 0.32e2 * t162 * t1950 * t2429 + 0.9e1 / 0.16e2 * t162 * t2445 - 0.3e1 / 0.32e2 * t509 * t713 - 0.3e1 / 0.16e2 * t177 * t2450 * t475 - t177 * t2454 * t1855 / 0.16e2 + 0.11e2 / 0.16e2 * t162 * t2459 - 0.15e2 / 0.32e2 * t162 * t2153 * t2462 - 0.25e2 / 0.16e2 * t177 * t2454 * t1735 + 0.15e2 / 0.16e2 * t177 * t2469 * t2006 - 0.9e1 / 0.16e2 * t162 * t2140 * t2473 - 0.3e1 / 0.2e1 * t177 * t2477;
  t2494 = t232 * t381;
  t2515 = t2021 * t91;
  t2531 = 0.9e1 / 0.8e1 * t177 * t2459 - 0.5e1 / 0.32e2 * t561 * t686 + 0.5e1 / 0.32e2 * t561 * t690 + 0.3e1 / 0.8e1 * t509 * t694 + 0.3e1 / 0.4e1 * t177 * t2450 * t395 - 0.9e1 / 0.32e2 * t509 * t698 - 0.9e1 / 0.16e2 * t177 * t2494 * t580 + 0.11e2 / 0.16e2 * t177 * t2454 * t1730 + 0.3e1 / 0.16e2 * t509 * t745 - 0.3e1 / 0.16e2 * t509 * t726 + 0.3e1 / 0.8e1 * t177 * t245 * t2064 + 0.3e1 / 0.32e2 * t509 * t732 + 0.3e1 / 0.8e1 * t177 * t2454 * t1846 + 0.9e1 / 0.64e2 * t557 * t718 - 0.11e2 / 0.32e2 * t162 * t1968 * t2515 - 0.11e2 / 0.16e2 * t177 * t2454 * t1840 + 0.11e2 / 0.16e2 * t177 * t2445 + 0.3e1 / 0.64e2 * t1977 * t238 + 0.9e1 / 0.32e2 * t509 * t721 + 0.9e1 / 0.16e2 * t177 * t2450 * t428;
  t2537 = t709 * t1661;
  t2540 = t534 * t232;
  t2562 = t753 * t113;
  t2569 = t503 * t232;
  t2583 = -0.3e1 / 0.64e2 * t1977 * t242 - 0.9e1 / 0.32e2 * t509 * t686 - 0.9e1 / 0.16e2 * t177 * t2537 + 0.9e1 / 0.32e2 * t162 * t496 * t2540 - 0.9e1 / 0.64e2 * t557 * t686 - 0.3e1 / 0.16e2 * t177 * t753 * t59 * t140 - 0.3e1 / 0.16e2 * t177 * t232 * t133 * t140 - 0.9e1 / 0.32e2 * t162 * t2537 + 0.3e1 / 0.16e2 * t509 * t710 + 0.3e1 / 0.32e2 * t509 * t729 + 0.9e1 / 0.64e2 * t557 * t690 + 0.3e1 / 0.16e2 * t177 * t2562 * t184 + 0.3e1 / 0.16e2 * t177 * t709 * t546 + 0.9e1 / 0.32e2 * t162 * t502 * t2569 - 0.3e1 / 0.16e2 * t509 * t704 - 0.3e1 / 0.32e2 * t509 * t678 - 0.3e1 / 0.64e2 * t2108 * t228 - 0.3e1 / 0.64e2 * t557 * t737 - 0.3e1 / 0.32e2 * t557 * t741;
  t2598 = t164 * t753;
  t2602 = t753 * t36;
  t2633 = my_piecewise3(t32, 0.48e2 * t489, 0);
  t2640 = -0.3e1 / 0.64e2 * t1977 * t246 + 0.3e1 / 0.128e3 * t2101 * t228 - t561 * t737 / 0.16e2 - 0.3e1 / 0.32e2 * t561 * t741 - t162 * t1686 * t227 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t389 * t740 - 0.3e1 / 0.32e2 * t162 * t163 * t2598 + 0.3e1 / 0.16e2 * t177 * t2602 * t190 - 0.3e1 / 0.8e1 * t177 * t744 * t529 + t177 * t241 * t2123 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t744 * t550 + t177 * t245 * t2094 / 0.16e2 - t2074 * t228 / 0.32e2 - 0.7e1 / 0.32e2 * t162 * t2477 + 0.5e1 / 0.32e2 * t561 * t718 - t177 * t91 * t456 * t140 / 0.16e2 + 0.3e1 / 0.64e2 * t461 * t234 - 0.3e1 / 0.32e2 * t105 * t755 - t48 * t49 * t2633 * t64 / 0.16e2 - 0.3e1 / 0.128e3 * t1829 * t93;
  t2643 = my_piecewise3(t3, 0, t2480 + t2531 + t2583 + t2640);
  tv4rho3tau0 = 0.2e1 * rho[0] * t2643 + 0.6e1 * t760;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2648 = t376 * t171 * t59;
  t2649 = t858 * t2648;
  t2657 = t497 * t171;
  t2670 = t853 * t171;
  t2677 = t1969 * t111;
  t2678 = t771 * t2677;
  t2681 = t258 * t111;
  t2684 = t177 * t2681 * t395 / 0.4e1;
  t2685 = -0.3e1 / 0.4e1 * t177 * t2649 - 0.3e1 / 0.4e1 * t177 * t1921 * t2648 - 0.3e1 / 0.8e1 * t162 * t2649 - t177 * t1930 * t2657 / 0.4e1 + 0.3e1 / 0.4e1 * t177 * t1930 * t2115 + 0.3e1 / 0.8e1 * t162 * t864 * t2648 - t177 * t1935 * t2648 / 0.2e1 + 0.3e1 / 0.8e1 * t162 * t1939 * t2670 + t177 * t182 * t383 * t2648 + 0.11e2 / 0.16e2 * t177 * t2678 + t2684;
  t2686 = t253 * t111;
  t2690 = t2154 * t111;
  t2694 = t253 * t1720;
  t2695 = t2005 * t111;
  t2699 = t258 * t381;
  t2702 = 0.3e1 / 0.16e2 * t177 * t2699 * t580;
  t2707 = t2063 * t111;
  t2713 = t1958 * t111;
  t2714 = t771 * t2713;
  t2719 = t1963 * t111;
  t2720 = t776 * t2719;
  t2723 = 0.11e2 / 0.16e2 * t177 * t2686 * t1730 - 0.25e2 / 0.16e2 * t177 * t776 * t2690 + 0.15e2 / 0.16e2 * t177 * t2694 * t2695 - t2702 + t509 * t793 / 0.8e1 - t509 * t798 / 0.8e1 + 0.3e1 / 0.8e1 * t177 * t796 * t2707 + t509 * t773 / 0.4e1 - 0.3e1 / 0.2e1 * t177 * t2714 - 0.3e1 / 0.16e2 * t509 * t778 + 0.9e1 / 0.8e1 * t177 * t2720;
  t2730 = t509 * t764 / 0.16e2;
  t2733 = 0.3e1 / 0.16e2 * t177 * t2681 * t428;
  t2741 = t177 * t2681 * t475 / 0.16e2;
  t2753 = t177 * t788 * t546 / 0.16e2;
  t2754 = -0.3e1 / 0.32e2 * t557 * t782 + 0.9e1 / 0.16e2 * t162 * t2678 - t2730 + t2733 - t509 * t768 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t2686 * t1846 - t2741 - t177 * t2686 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t2686 * t1840 + 0.3e1 / 0.32e2 * t162 * t776 * t1694 + t2753;
  t2755 = t503 * t258;
  t2758 = 0.3e1 / 0.32e2 * t162 * t502 * t2755;
  t2759 = t189 * t491;
  t2766 = t177 * t258 * t133 * t140 / 0.16e2;
  t2767 = t497 * t258;
  t2768 = t496 * t2767;
  t2770 = 0.3e1 / 0.32e2 * t162 * t2768;
  t2782 = t579 * t133;
  t2786 = t111 * t1720;
  t2787 = t2154 * t253;
  t2796 = t2758 + t177 * t188 * t2759 / 0.8e1 - t2766 - t2770 - t177 * t253 * t133 * t475 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t2714 + t177 * t771 * t1694 / 0.4e1 + 0.11e2 / 0.16e2 * t162 * t2720 - 0.3e1 / 0.16e2 * t177 * t776 * t2782 - 0.15e2 / 0.32e2 * t162 * t2786 * t2787 + 0.3e1 / 0.32e2 * t557 * t785 - 0.9e1 / 0.16e2 * t162 * t776 * t2713;
  t2800 = t509 * t789 / 0.16e2;
  t2802 = 0.3e1 / 0.16e2 * t177 * t2768;
  t2805 = t162 * t389 * t812 / 0.32e2;
  t2816 = t2021 * t253;
  t2826 = t509 * t808 / 0.16e2;
  t2827 = t2800 - t2802 - t2805 - t509 * t818 / 0.8e1 + 0.3e1 / 0.16e2 * t509 * t821 - t177 * t188 * t2087 / 0.8e1 - t177 * t796 * t1704 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t496 * t2816 + 0.5e1 / 0.32e2 * t561 * t802 + 0.3e1 / 0.32e2 * t162 * t771 * t1657 + t2826;
  t2829 = t557 * t813 / 0.32e2;
  t2832 = t177 * t807 * t550 / 0.16e2;
  t2833 = t534 * t258;
  t2836 = 0.3e1 / 0.32e2 * t162 * t496 * t2833;
  t2839 = t771 * t1931;
  t2848 = t177 * t807 * t529 / 0.8e1;
  t2856 = -t2829 + t2832 + t2836 - 0.5e1 / 0.32e2 * t561 * t782 - 0.3e1 / 0.32e2 * t162 * t2839 + 0.5e1 / 0.32e2 * t561 * t785 + 0.3e1 / 0.32e2 * t557 * t802 - t2848 - t557 * t836 / 0.16e2 - t561 * t836 / 0.8e1 - t162 * t182 * t2087 / 0.16e2;
  t2865 = t183 * t491;
  t2872 = t561 * t813 / 0.32e2;
  t2873 = t814 / 0.16e2;
  t2874 = t765 / 0.8e1;
  t2875 = t790 / 0.8e1;
  t2876 = t809 / 0.8e1;
  t2877 = t171 * t171;
  t2878 = t49 * t2877;
  t2882 = 0.3e1 / 0.16e2 * t177 * t796 * t1657 + t509 * t827 / 0.8e1 - 0.3e1 / 0.16e2 * t509 * t782 + t177 * t182 * t2865 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t2839 - t2872 - t2873 - t2874 + t2875 + t2876 - t48 * t2878 * t140 / 0.8e1;
  t2884 = t461 * t260 / 0.64e2;
  t2909 = t805 / 0.16e2;
  t2910 = t2884 + t48 * t2878 * t151 / 0.8e1 - t105 * t840 / 0.32e2 - t48 * t1793 * t253 * t119 / 0.32e2 - t461 * t270 / 0.64e2 + t461 * t255 / 0.128e3 - t48 * t110 * t2877 * t119 / 0.16e2 - t461 * t267 / 0.64e2 + t48 * t2878 * t147 / 0.8e1 + t461 * t264 / 0.64e2 - t2909 - t262;
  t2914 = my_piecewise3(t3, 0, t2685 + t2723 + t2754 + t2796 + t2827 + t2856 + t2882 + t2910);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2914 + 0.4e1 * t845;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2918 = t1715 * t74;
  t2919 = t2918 * t111;
  t2920 = t852 * t2919;
  t2927 = t2228 * t1740;
  t2931 = t279 * t111;
  t2935 = t1065 * t2919;
  t2940 = t1715 * t83;
  t2941 = t2940 * t111;
  t2945 = t848 * t2713;
  t2962 = 0.9e1 / 0.8e1 * t177 * t2920 - 0.25e2 / 0.16e2 * t177 * t279 * t381 * t2690 + 0.15e2 / 0.16e2 * t177 * t2927 * t2919 + 0.11e2 / 0.16e2 * t177 * t2931 * t1730 + 0.11e2 / 0.16e2 * t177 * t2935 + 0.9e1 / 0.16e2 * t162 * t2935 - 0.9e1 / 0.16e2 * t162 * t864 * t2941 - 0.3e1 / 0.2e1 * t177 * t2945 + 0.3e1 / 0.8e1 * t177 * t919 * t2919 - t509 * t916 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t2931 * t1846 + 0.3e1 / 0.16e2 * t509 * t910 - t177 * t879 * t59 * t475 / 0.8e1;
  t2969 = t376 * t204;
  t2970 = t2969 * t59;
  t3002 = t496 * t115;
  t3003 = t2940 * t74;
  t3011 = -t177 * t279 * t133 * t475 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t2945 + 0.3e1 / 0.16e2 * t162 * t905 * t2970 + 0.3e1 / 0.32e2 * t162 * t905 * t2192 + 0.3e1 / 0.8e1 * t177 * t875 * t36 * t801 + 0.3e1 / 0.8e1 * t177 * t879 * t36 * t801 + 0.3e1 / 0.16e2 * t177 * t909 * t1657 - t509 * t920 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t906 - t177 * t651 * t61 * t854 / 0.4e1 - t177 * t919 * t2648 / 0.4e1 - t177 * t919 * t1940 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t3002 * t3003 - t177 * t875 * t59 * t475 / 0.8e1;
  t3026 = t858 * t2192;
  t3037 = t2969 * t74;
  t3038 = t2196 * t3037;
  t3041 = t859 * t171;
  t3042 = t2196 * t3041;
  t3053 = -0.3e1 / 0.16e2 * t509 * t855 + t177 * t875 * t113 * t772 / 0.2e1 - 0.3e1 / 0.16e2 * t177 * t852 * t1940 - 0.15e2 / 0.32e2 * t162 * t2786 * t1722 * t3003 - 0.3e1 / 0.32e2 * t162 * t3026 + 0.3e1 / 0.32e2 * t162 * t864 * t2192 + t177 * t848 * t1694 / 0.4e1 + 0.11e2 / 0.16e2 * t162 * t2920 - 0.3e1 / 0.16e2 * t162 * t3038 - 0.3e1 / 0.16e2 * t162 * t3042 + 0.3e1 / 0.16e2 * t162 * t1950 * t3037 + 0.3e1 / 0.16e2 * t162 * t1950 * t3041 - 0.3e1 / 0.8e1 * t177 * t3038;
  t3060 = t522 * t115;
  t3092 = -0.3e1 / 0.8e1 * t177 * t3042 - 0.3e1 / 0.16e2 * t177 * t3026 + 0.5e1 / 0.32e2 * t561 * t906 + 0.3e1 / 0.16e2 * t162 * t3060 * t860 + t177 * t879 * t113 * t772 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t2248 * t400 * t854 - 0.3e1 / 0.8e1 * t177 * t852 * t2648 - 0.5e1 / 0.32e2 * t561 * t861 + 0.5e1 / 0.32e2 * t561 * t865 - t177 * t2931 * t1855 / 0.16e2 - 0.3e1 / 0.16e2 * t509 * t861 - 0.11e2 / 0.16e2 * t177 * t602 * t36 * t2022 - 0.3e1 / 0.32e2 * t557 * t861 + 0.3e1 / 0.32e2 * t557 * t865;
  t3131 = t509 * t849 / 0.4e1 - t2108 * t276 / 0.32e2 - t557 * t894 / 0.32e2 - t557 * t898 / 0.32e2 - t561 * t894 / 0.16e2 - t561 * t898 / 0.16e2 - t162 * t2129 * t200 / 0.32e2 - t162 * t522 * t590 / 0.16e2 - t177 * t615 * t74 * t140 / 0.16e2 - t177 * t204 * t171 * t140 / 0.8e1 - t177 * t83 * t491 * t140 / 0.16e2 + t177 * t2360 * t283 / 0.16e2 + t177 * t628 * t826 / 0.8e1;
  t3159 = t177 * t213 * t2865 / 0.16e2 - t509 * t876 / 0.16e2 - t509 * t880 / 0.16e2 + t509 * t883 / 0.16e2 + t509 * t886 / 0.16e2 + t177 * t651 * t792 / 0.8e1 + t177 * t217 * t2759 / 0.16e2 + t509 * t889 / 0.16e2 + t509 * t872 / 0.16e2 + t2684 - t2702 + t1977 * t280 / 0.64e2 - t1977 * t284 / 0.64e2 - t1977 * t288 / 0.64e2;
  t3171 = t2101 * t276 / 0.128e3 - t162 * t182 * t2364 / 0.32e2 + t177 * t2329 * t287 / 0.16e2 - t2074 * t276 / 0.32e2 - t2730 + t2733 - t2741 + t2753 + t2758 - t2766 - t2770 + t2800 - t2802;
  t3172 = -t2805 + t2826 - t2829 + t2832 + t2836 - t2848 - t2872 - t2873 - t2874 + t2875 + t2876 + t2884 - t2909 - t262;
  t3176 = my_piecewise3(t3, 0, t2962 + t3011 + t3053 + t3092 + t3131 + t3159 + t3171 + t3172);
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t3176 + 0.4e1 * t925;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t3180 = t1420 * t2919;
  t3188 = t297 * t111;
  t3194 = t2469 * t1740;
  t3198 = t1715 * t91;
  t3199 = t3198 * t111;
  t3200 = t1921 * t3199;
  t3214 = t2414 * t2919;
  t3221 = 0.11e2 / 0.16e2 * t177 * t3180 + 0.3e1 / 0.8e1 * t177 * t950 * t2919 - t509 * t945 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t3188 * t1846 + 0.3e1 / 0.16e2 * t509 * t958 + 0.15e2 / 0.16e2 * t177 * t3194 * t2919 + 0.11e2 / 0.16e2 * t162 * t3200 - 0.15e2 / 0.32e2 * t162 * t2004 * t1722 * t3199 - 0.25e2 / 0.16e2 * t177 * t297 * t381 * t2690 + 0.11e2 / 0.16e2 * t177 * t3188 * t1730 - 0.3e1 / 0.2e1 * t177 * t3214 + 0.9e1 / 0.8e1 * t177 * t3200 + 0.9e1 / 0.16e2 * t162 * t3180;
  t3228 = t3198 * t74;
  t3238 = t709 * t145;
  t3239 = t3238 * t854;
  t3242 = t1420 * t2648;
  t3245 = t1420 * t1940;
  t3268 = -t177 * t950 * t2648 / 0.4e1 - t177 * t950 * t1940 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t3002 * t3228 - 0.7e1 / 0.32e2 * t162 * t3214 - 0.3e1 / 0.16e2 * t509 * t930 + 0.3e1 / 0.32e2 * t557 * t933 - 0.3e1 / 0.8e1 * t177 * t3239 - 0.3e1 / 0.8e1 * t177 * t3242 - 0.3e1 / 0.16e2 * t177 * t3245 - 0.9e1 / 0.16e2 * t162 * t502 * t383 * t3228 - t177 * t976 * t59 * t475 / 0.8e1 - t177 * t980 * t59 * t475 / 0.8e1 - t177 * t297 * t133 * t475 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t693 * t36 * t2022;
  t3293 = t376 * t232;
  t3294 = t3293 * t59;
  t3309 = -0.3e1 / 0.32e2 * t557 * t930 - 0.3e1 / 0.16e2 * t162 * t3242 + 0.3e1 / 0.16e2 * t162 * t1954 * t383 * t929 - 0.3e1 / 0.16e2 * t162 * t3239 - 0.3e1 / 0.32e2 * t162 * t3245 + 0.3e1 / 0.32e2 * t162 * t864 * t2429 + t177 * t936 * t1694 / 0.4e1 + 0.5e1 / 0.32e2 * t561 * t954 + 0.3e1 / 0.16e2 * t162 * t3060 * t929 + 0.3e1 / 0.16e2 * t162 * t905 * t3294 + 0.3e1 / 0.32e2 * t162 * t905 * t2429 + 0.3e1 / 0.8e1 * t177 * t976 * t36 * t801 + 0.3e1 / 0.8e1 * t177 * t980 * t36 * t801;
  t3317 = t744 * t61;
  t3332 = t2494 * t400;
  t3350 = 0.3e1 / 0.16e2 * t177 * t957 * t1657 - t509 * t951 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t954 - t177 * t3317 * t854 / 0.4e1 + 0.3e1 / 0.16e2 * t162 * t864 * t3294 + t177 * t976 * t113 * t772 / 0.2e1 + t177 * t980 * t113 * t772 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t3332 * t854 - 0.3e1 / 0.8e1 * t177 * t940 * t2648 - 0.5e1 / 0.32e2 * t561 * t930 + 0.5e1 / 0.32e2 * t561 * t933 - t177 * t3188 * t1855 / 0.16e2 + t509 * t937 / 0.4e1 - 0.3e1 / 0.16e2 * t509 * t941;
  t3385 = -0.3e1 / 0.16e2 * t177 * t940 * t1940 - t509 * t977 / 0.16e2 - t509 * t981 / 0.16e2 + t177 * t2602 * t287 / 0.16e2 + t177 * t744 * t792 / 0.8e1 + t509 * t984 / 0.16e2 + t509 * t987 / 0.16e2 + t1977 * t298 / 0.64e2 - t1977 * t304 / 0.64e2 + t2101 * t294 / 0.128e3 - t1977 * t301 / 0.64e2 - t177 * t91 * t491 * t140 / 0.16e2 + t177 * t2562 * t283 / 0.16e2;
  t3424 = t177 * t709 * t826 / 0.8e1 + t177 * t241 * t2865 / 0.16e2 - t2074 * t294 / 0.32e2 + t177 * t245 * t2759 / 0.16e2 - t561 * t969 / 0.16e2 - t162 * t2129 * t227 / 0.32e2 - t162 * t522 * t740 / 0.16e2 - t561 * t972 / 0.16e2 - t162 * t182 * t2598 / 0.32e2 - t177 * t753 * t74 * t140 / 0.16e2 - t177 * t232 * t171 * t140 / 0.8e1 + t509 * t963 / 0.16e2 + t509 * t966 / 0.16e2 - t2108 * t294 / 0.32e2;
  t3430 = -t557 * t969 / 0.32e2 - t557 * t972 / 0.32e2 + t2684 - t2702 - t2730 + t2733 - t2741 + t2753 + t2758 - t2766 - t2770 + t2800 - t2802;
  t3434 = my_piecewise3(t3, 0, t3221 + t3268 + t3309 + t3350 + t3385 + t3424 + t3430 + t3172);
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t3434 + 0.4e1 * t1000;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t3441 = t1065 * t2970;
  t3449 = t497 * t204;
  t3453 = t213 * t383;
  t3462 = t859 * t204;
  t3466 = t310 * t111;
  t3472 = 0.3e1 / 0.4e1 * t177 * t2181 * t2319 - 0.3e1 / 0.4e1 * t177 * t3441 - 0.3e1 / 0.8e1 * t162 * t3441 + 0.3e1 / 0.8e1 * t162 * t1069 * t2970 - t177 * t2181 * t3449 / 0.4e1 + t177 * t3453 * t2970 - 0.3e1 / 0.4e1 * t177 * t852 * t2970 - t177 * t919 * t2970 / 0.2e1 + 0.3e1 / 0.8e1 * t162 * t1939 * t3462 - t177 * t3466 * t1855 / 0.16e2 - 0.3e1 / 0.16e2 * t509 * t1015;
  t3478 = t1963 * t310;
  t3479 = t502 * t3478;
  t3485 = t2154 * t310;
  t3491 = t1007 * t1931;
  t3503 = t1958 * t310;
  t3504 = t496 * t3503;
  t3507 = -0.11e2 / 0.16e2 * t177 * t3466 * t1840 + 0.3e1 / 0.16e2 * t509 * t1040 + 0.11e2 / 0.16e2 * t162 * t3479 - 0.3e1 / 0.16e2 * t177 * t1011 * t2782 - 0.15e2 / 0.32e2 * t162 * t2786 * t3485 - 0.5e1 / 0.32e2 * t561 * t1015 - 0.3e1 / 0.32e2 * t162 * t3491 + 0.5e1 / 0.32e2 * t561 * t1018 + 0.3e1 / 0.32e2 * t162 * t1011 * t1694 - t177 * t310 * t133 * t475 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t3504;
  t3509 = t1007 * t2677;
  t3518 = t310 * t1720;
  t3524 = t183 * t615;
  t3539 = 0.11e2 / 0.16e2 * t177 * t3509 + 0.11e2 / 0.16e2 * t177 * t3466 * t1730 - 0.25e2 / 0.16e2 * t177 * t1011 * t2690 + 0.15e2 / 0.16e2 * t177 * t3518 * t2695 + t509 * t1046 / 0.8e1 + t177 * t213 * t3524 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t3491 - t557 * t1053 / 0.16e2 + 0.5e1 / 0.32e2 * t561 * t1031 + 0.3e1 / 0.32e2 * t162 * t1007 * t1657 - t509 * t1037 / 0.8e1;
  t3552 = t189 * t615;
  t3559 = t2021 * t310;
  t3573 = -t177 * t217 * t2364 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1027 * t1657 + t509 * t1024 / 0.8e1 - t509 * t1028 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t1031 + t177 * t217 * t3552 / 0.8e1 - t177 * t1027 * t1704 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t496 * t3559 + t177 * t1007 * t1694 / 0.4e1 + 0.3e1 / 0.8e1 * t177 * t1027 * t2707 + 0.9e1 / 0.8e1 * t177 * t3479 - 0.3e1 / 0.32e2 * t557 * t1015;
  t3599 = 0.9e1 / 0.16e2 * t162 * t3509 + 0.3e1 / 0.32e2 * t557 * t1018 - 0.9e1 / 0.16e2 * t162 * t1011 * t2713 - t509 * t1004 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t3466 * t1846 + t509 * t1008 / 0.4e1 - 0.3e1 / 0.2e1 * t177 * t3504 - 0.3e1 / 0.16e2 * t509 * t1012 - t561 * t1053 / 0.8e1 - t162 * t213 * t2364 / 0.16e2 + t2684;
  t3600 = -t2702 - t2730 + t2733 - t2741 + t2753 + t2758 - t2766 - t2770 + t2800 - t2802 - t2805;
  t3604 = t2826 - t2829 + t2832 + t2836 - t2848 - t2872 - t2873 - t2874 + t2875 + t2876 - t461 * t322 / 0.64e2;
  t3605 = t204 * t204;
  t3606 = t49 * t3605;
  t3632 = t48 * t3606 * t151 / 0.8e1 - t48 * t1793 * t310 * t119 / 0.32e2 - t105 * t1057 / 0.32e2 + t2884 - t48 * t110 * t3605 * t119 / 0.16e2 - t461 * t319 / 0.64e2 + t48 * t3606 * t147 / 0.8e1 + t461 * t312 / 0.128e3 + t461 * t316 / 0.64e2 - t48 * t3606 * t140 / 0.8e1 - t2909 - t262;
  t3636 = my_piecewise3(t3, 0, t3472 + t3507 + t3539 + t3573 + t3599 + t3600 + t3604 + t3632);
  tv4rho2lapl20 = 0.2e1 * rho[0] * t3636 + 0.4e1 * t1062;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  t3640 = t1073 * t2713;
  t3645 = t331 * t111;
  t3664 = t940 * t2941;
  t3683 = -0.3e1 / 0.2e1 * t177 * t3640 - t509 * t1081 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t3645 * t1846 + 0.3e1 / 0.8e1 * t177 * t703 * t36 * t644 + 0.3e1 / 0.8e1 * t177 * t2425 * t2319 - t177 * t1109 * t59 * t475 / 0.8e1 - t177 * t1114 * t59 * t475 / 0.8e1 + 0.9e1 / 0.8e1 * t177 * t3664 + 0.11e2 / 0.16e2 * t162 * t3664 - 0.15e2 / 0.32e2 * t162 * t2228 * t1722 * t3199 - 0.25e2 / 0.16e2 * t177 * t331 * t381 * t2690 + 0.15e2 / 0.16e2 * t177 * t3194 * t2941 + 0.11e2 / 0.16e2 * t177 * t3645 * t1730;
  t3684 = t1065 * t3199;
  t3690 = t1420 * t2970;
  t3695 = t2248 * t383;
  t3699 = t1065 * t3294;
  t3705 = t1109 * t113;
  t3709 = t1114 * t113;
  t3716 = t3293 * t83;
  t3723 = t928 * t204;
  t3730 = 0.9e1 / 0.16e2 * t162 * t3684 - 0.9e1 / 0.16e2 * t162 * t1069 * t3199 - 0.3e1 / 0.8e1 * t177 * t3690 - 0.3e1 / 0.16e2 * t162 * t3690 + 0.3e1 / 0.16e2 * t162 * t3695 * t929 - 0.3e1 / 0.16e2 * t162 * t3699 + 0.3e1 / 0.16e2 * t162 * t1069 * t3294 + t177 * t3705 * t772 / 0.2e1 + t177 * t3709 * t772 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t3332 * t860 + 0.3e1 / 0.16e2 * t162 * t1939 * t3716 - t177 * t950 * t2970 / 0.4e1 + 0.3e1 / 0.16e2 * t162 * t1939 * t3723 - 0.3e1 / 0.8e1 * t177 * t940 * t2970;
  t3762 = -t177 * t3645 * t1855 / 0.16e2 - 0.3e1 / 0.32e2 * t557 * t1066 + 0.3e1 / 0.32e2 * t557 * t1070 + t509 * t1074 / 0.4e1 - 0.3e1 / 0.16e2 * t509 * t1077 - 0.5e1 / 0.32e2 * t561 * t1066 + 0.5e1 / 0.32e2 * t561 * t1070 - 0.3e1 / 0.8e1 * t177 * t3699 - t177 * t331 * t133 * t475 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t3640 + 0.3e1 / 0.32e2 * t557 * t1085 + 0.5e1 / 0.32e2 * t561 * t1085 - t177 * t3317 * t860 / 0.4e1;
  t3766 = t1065 * t2429;
  t3802 = -0.3e1 / 0.16e2 * t177 * t940 * t2192 - 0.3e1 / 0.32e2 * t162 * t3766 + 0.3e1 / 0.32e2 * t162 * t1069 * t2429 + t177 * t1073 * t1694 / 0.4e1 - t177 * t950 * t2192 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t3766 - t509 * t1094 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1084 * t2429 + 0.3e1 / 0.16e2 * t509 * t1089 + 0.3e1 / 0.16e2 * t177 * t1088 * t1657 - 0.3e1 / 0.16e2 * t509 * t1066 + 0.3e1 / 0.8e1 * t177 * t950 * t2941 - 0.11e2 / 0.32e2 * t162 * t1084 * t3199 - 0.11e2 / 0.16e2 * t177 * t1088 * t2021 * t111;
  t3838 = 0.11e2 / 0.16e2 * t177 * t3684 - t557 * t1103 / 0.32e2 - t557 * t1106 / 0.32e2 - t509 * t1110 / 0.16e2 - t509 * t1115 / 0.16e2 + t509 * t1097 / 0.16e2 + t509 * t1100 / 0.16e2 - t162 * t2360 * t227 / 0.32e2 - t162 * t628 * t740 / 0.16e2 - t561 * t1106 / 0.16e2 - t162 * t213 * t2598 / 0.32e2 - t177 * t753 * t83 * t140 / 0.16e2 - t177 * t232 * t204 * t140 / 0.8e1;
  t3873 = -t177 * t91 * t615 * t140 / 0.16e2 + t177 * t2602 * t339 / 0.16e2 + t177 * t744 * t1023 / 0.8e1 + t177 * t245 * t3552 / 0.16e2 - t561 * t1103 / 0.16e2 - t1977 * t340 / 0.64e2 + t1977 * t332 / 0.64e2 - t1977 * t336 / 0.64e2 + t2101 * t328 / 0.128e3 + t509 * t1118 / 0.16e2 + t509 * t1121 / 0.16e2 - t2074 * t328 / 0.32e2 - t2108 * t328 / 0.32e2 + t177 * t2562 * t335 / 0.16e2;
  t3881 = t177 * t709 * t1045 / 0.8e1 + t177 * t241 * t3524 / 0.16e2 + t2684 - t2702 - t2730 + t2733 - t2741 + t2753 + t2758 - t2766 - t2770 + t2800 - t2802;
  t3885 = my_piecewise3(t3, 0, t3683 + t3730 + t3762 + t3802 + t3838 + t3873 + t3881 + t3172);
  tv4rho2lapltau0 = 0.2e1 * rho[0] * t3885 + 0.4e1 * t1136;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t3892 = t497 * t232;
  t3901 = t1420 * t3294;
  t3906 = t928 * t232;
  t3916 = t346 * t111;
  t3922 = 0.3e1 / 0.4e1 * t177 * t2425 * t2540 - t177 * t2425 * t3892 / 0.4e1 + t177 * t2414 * t3294 - 0.3e1 / 0.4e1 * t177 * t940 * t3294 - 0.3e1 / 0.4e1 * t177 * t3901 - 0.3e1 / 0.8e1 * t162 * t3901 + 0.3e1 / 0.8e1 * t162 * t1950 * t3906 - t177 * t950 * t3294 / 0.2e1 + 0.3e1 / 0.8e1 * t162 * t1939 * t3906 + 0.3e1 / 0.8e1 * t177 * t3916 * t1846 - 0.3e1 / 0.16e2 * t509 * t1189;
  t3923 = t1182 * t2719;
  t3926 = t1147 * t2677;
  t3951 = 0.11e2 / 0.16e2 * t162 * t3923 + 0.11e2 / 0.16e2 * t177 * t3926 + 0.9e1 / 0.16e2 * t162 * t3926 - t177 * t3916 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t3916 * t1840 + t509 * t1186 / 0.4e1 - t509 * t1153 / 0.8e1 + 0.3e1 / 0.16e2 * t509 * t1156 - 0.3e1 / 0.32e2 * t557 * t1165 - t177 * t245 * t2598 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1143 * t1657;
  t3960 = t2021 * t346;
  t3973 = t346 * t1720;
  t3986 = t177 * t245 * t189 * t753 / 0.8e1 - t177 * t1143 * t1704 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t496 * t3960 + t509 * t1140 / 0.8e1 - t509 * t1144 / 0.8e1 + 0.3e1 / 0.8e1 * t177 * t1143 * t2707 + 0.3e1 / 0.32e2 * t557 * t1148 - 0.15e2 / 0.32e2 * t162 * t3973 * t2690 - 0.25e2 / 0.16e2 * t177 * t1182 * t2690 + 0.15e2 / 0.16e2 * t177 * t3973 * t2695 - 0.9e1 / 0.16e2 * t162 * t1182 * t2713;
  t3987 = t1147 * t2713;
  t4018 = -0.3e1 / 0.2e1 * t177 * t3987 + 0.9e1 / 0.8e1 * t177 * t3923 + 0.11e2 / 0.16e2 * t177 * t3916 * t1730 - t557 * t1172 / 0.16e2 - t561 * t1172 / 0.8e1 - t162 * t241 * t2598 / 0.16e2 - t177 * t346 * t133 * t475 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t3987 + t509 * t1162 / 0.8e1 - 0.3e1 / 0.16e2 * t509 * t1165 + 0.3e1 / 0.32e2 * t557 * t1183 + t177 * t241 * t183 * t753 / 0.8e1;
  t4021 = t1147 * t1931;
  t4046 = -0.3e1 / 0.16e2 * t177 * t4021 + 0.5e1 / 0.32e2 * t561 * t1148 + 0.3e1 / 0.32e2 * t162 * t1147 * t1657 - t509 * t1177 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t1182 * t2782 - 0.5e1 / 0.32e2 * t561 * t1165 - 0.3e1 / 0.32e2 * t162 * t4021 + 0.5e1 / 0.32e2 * t561 * t1183 + 0.3e1 / 0.32e2 * t162 * t1182 * t1694 + t177 * t1147 * t1694 / 0.4e1 + t2684;
  t4050 = t2826 - t2829 + t2832 + t2836 - t2848 - t2872 - t2873 - t2874 + t2875 + t2876 - t105 * t1193 / 0.32e2;
  t4057 = t232 * t232;
  t4064 = t49 * t4057;
  t4078 = -t48 * t1793 * t346 * t119 / 0.32e2 + t461 * t348 / 0.128e3 - t48 * t110 * t4057 * t119 / 0.16e2 - t461 * t355 / 0.64e2 + t48 * t4064 * t147 / 0.8e1 - t461 * t358 / 0.64e2 + t461 * t352 / 0.64e2 - t48 * t4064 * t140 / 0.8e1 + t48 * t4064 * t151 / 0.8e1 + t2884 - t2909 - t262;
  t4082 = my_piecewise3(t3, 0, t3922 + t3951 + t3986 + t4018 + t4046 + t3600 + t4050 + t4078);
  tv4rho2tau20 = 0.2e1 * rho[0] * t4082 + 0.4e1 * t1198;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t4087 = t177 * t1222 * t59 * t475;
  t4091 = t177 * t1222 * t113 * t772;
  t4095 = t177 * t2699 * t400 * t854;
  t4099 = t177 * t763 * t36 * t535;
  t4103 = t177 * t807 * t61 * t854;
  t4105 = t376 * t258;
  t4106 = t4105 * t74;
  t4108 = t162 * t1939 * t4106;
  t4110 = t788 * t145;
  t4111 = t4110 * t854;
  t4112 = t177 * t4111;
  t4114 = t162 * t4111;
  t4116 = t4105 * t59;
  t4118 = t162 * t864 * t4116;
  t4122 = t1204 * t113;
  t4123 = t1958 * t59;
  t4124 = t4122 * t4123;
  t4127 = t1204 * t381;
  t4128 = t1963 * t59;
  t4129 = t4127 * t4128;
  t4137 = t1204 * t1720;
  t4138 = t2154 * t59;
  t4145 = t2005 * t59;
  t4149 = -0.3e1 / 0.16e2 * t4087 + 0.3e1 / 0.4e1 * t4091 - 0.9e1 / 0.16e2 * t4095 + 0.9e1 / 0.16e2 * t4099 - 0.3e1 / 0.8e1 * t4103 + 0.9e1 / 0.32e2 * t4108 - 0.9e1 / 0.16e2 * t4112 - 0.9e1 / 0.32e2 * t4114 + 0.9e1 / 0.32e2 * t4118 + t1270 * t785 / 0.16e2 - 0.3e1 / 0.2e1 * t177 * t4124 + 0.9e1 / 0.8e1 * t177 * t4129 + 0.11e2 / 0.16e2 * t177 * t4122 * t4128 + 0.11e2 / 0.16e2 * t162 * t4129 - 0.15e2 / 0.32e2 * t162 * t4137 * t4138 - 0.25e2 / 0.16e2 * t177 * t4127 * t4138 + 0.15e2 / 0.16e2 * t177 * t4137 * t4145;
  t4153 = t1204 * t36;
  t4154 = t2021 * t59;
  t4159 = t163 * t1969 * t1204;
  t4162 = t771 * t2657;
  t4171 = t509 * t1201;
  t4173 = t557 * t1215;
  t4180 = t509 * t1223;
  t4182 = t509 * t1235;
  t4184 = t1204 * t59;
  t4191 = t528 * t171;
  t4195 = t2063 * t59;
  t4203 = t561 * t1215;
  t4205 = 0.9e1 / 0.16e2 * t177 * t796 * t2115 - 0.11e2 / 0.16e2 * t177 * t4153 * t4154 + 0.9e1 / 0.16e2 * t162 * t4159 - 0.9e1 / 0.16e2 * t177 * t4162 + 0.11e2 / 0.16e2 * t177 * t4159 - 0.9e1 / 0.16e2 * t162 * t1949 * t1958 * t1204 + 0.3e1 / 0.32e2 * t4171 - 0.3e1 / 0.64e2 * t4173 - t1270 * t782 / 0.16e2 + 0.9e1 / 0.32e2 * t162 * t776 * t2136 - 0.3e1 / 0.32e2 * t4180 + 0.3e1 / 0.32e2 * t4182 + 0.3e1 / 0.8e1 * t177 * t4184 * t1846 - t177 * t4184 * t1855 / 0.16e2 - 0.3e1 / 0.8e1 * t177 * t796 * t4191 + 0.3e1 / 0.8e1 * t177 * t4153 * t4195 - 0.11e2 / 0.32e2 * t162 * t163 * t2021 * t1204 - 0.3e1 / 0.32e2 * t4203;
  t4208 = t162 * t522 * t812;
  t4215 = t177 * t258 * t171 * t140;
  t4218 = t177 * t807 * t792;
  t4223 = t177 * t788 * t826;
  t4228 = t579 * t171;
  t4253 = -0.3e1 / 0.32e2 * t4208 + 0.9e1 / 0.32e2 * t162 * t771 * t2115 - 0.3e1 / 0.16e2 * t4215 + 0.3e1 / 0.16e2 * t4218 + t1270 * t802 / 0.16e2 + 0.3e1 / 0.16e2 * t4223 + 0.3e1 / 0.4e1 * t177 * t771 * t2136 - 0.9e1 / 0.16e2 * t177 * t776 * t4228 - t1270 * t836 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t796 * t2657 - 0.7e1 / 0.32e2 * t162 * t4124 - 0.9e1 / 0.32e2 * t162 * t4162 + t105 * t1238 / 0.8e1 - 0.3e1 / 0.32e2 * t105 * t1241 - t105 * t1251 / 0.64e2 - t105 * t1226 / 0.32e2 - 0.3e1 / 0.64e2 * t105 * t1229 + 0.3e1 / 0.64e2 * t105 * t1232;
  t4255 = t110 * t59 * t113;
  t4269 = t118 * t59;
  t4270 = t116 * t4269;
  t4273 = t1765 * t59;
  t4274 = t118 * t74;
  t4275 = t116 * t4274;
  t4281 = t59 * t36;
  t4282 = t4281 * t164;
  t4285 = t146 * t4269;
  t4288 = t62 * t4269;
  t4303 = t4255 * t165 / 0.4e1 + t173 / 0.2e1 + t75 * t59 * t140 / 0.2e1 - t75 * t113 * t184 / 0.2e1 - t75 * t36 * t190 / 0.2e1 - t1761 * t74 * t4270 / 0.2e1 + t4273 * t4275 / 0.2e1 + t434 * t171 * t64 / 0.2e1 + t1244 * t4282 / 0.2e1 - t1244 * t4285 / 0.2e1 - t1244 * t4288 / 0.2e1 - t1779 * t74 * t64 / 0.2e1 - t437 * t171 * t64 / 0.2e1 - t1246 * t4282 / 0.2e1 + t1246 * t4285 / 0.2e1 + t1246 * t4288 / 0.2e1;
  t4308 = t441 * t1204;
  t4326 = -t48 * t4303 * t253 * t119 / 0.32e2 + 0.3e1 / 0.32e2 * t48 * t4308 * t420 - 0.3e1 / 0.32e2 * t48 * t4308 * t377 + 0.3e1 / 0.32e2 * t48 * t4308 * t385 + 0.3e1 / 0.64e2 * t105 * t1219 + 0.3e1 / 0.32e2 * t105 * t1206 - 0.3e1 / 0.32e2 * t105 * t1209 - t105 * t1212 / 0.16e2 + t1203 - t1217 - t1225 + t1237 - t815 - t766 + t791 + t810 - t806 - t262;
  t4329 = my_piecewise3(t3, 0, t4149 + t4205 + t4253 + t4326);
  tv4rhosigma30 = 0.2e1 * rho[0] * t4329 + 0.2e1 * t1255;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t4334 = t177 * t1257 * t59 * t475;
  t4335 = t4334 / 0.16e2;
  t4336 = t2694 * t1722;
  t4337 = t2940 * t59;
  t4346 = t1715 * t253 * t59;
  t4350 = t1280 * t113;
  t4354 = t4350 * t4123;
  t4357 = t852 * t4346;
  t4362 = t1257 * t113;
  t4364 = t177 * t4362 * t772;
  t4365 = t4364 / 0.4e1;
  t4367 = t177 * t852 * t4116;
  t4368 = 0.3e1 / 0.16e2 * t4367;
  t4373 = -t4335 - 0.15e2 / 0.32e2 * t162 * t4336 * t4337 - 0.25e2 / 0.16e2 * t177 * t1280 * t381 * t4138 + 0.15e2 / 0.16e2 * t177 * t2927 * t4346 + 0.11e2 / 0.16e2 * t177 * t4350 * t4128 - 0.3e1 / 0.2e1 * t177 * t4354 + 0.9e1 / 0.8e1 * t177 * t4357 + 0.11e2 / 0.16e2 * t162 * t4357 + t4365 - t4368 - t1270 * t861 / 0.16e2 + t1270 * t865 / 0.16e2;
  t4374 = t1257 * t36;
  t4376 = t177 * t4374 * t801;
  t4377 = 0.3e1 / 0.16e2 * t4376;
  t4378 = t859 * t258;
  t4379 = t2196 * t4378;
  t4380 = t162 * t4379;
  t4381 = 0.3e1 / 0.32e2 * t4380;
  t4382 = t177 * t4379;
  t4383 = 0.3e1 / 0.16e2 * t4382;
  t4387 = t1280 * t36;
  t4388 = t1969 * t59;
  t4400 = t2940 * t253;
  t4401 = t2196 * t4400;
  t4406 = t1065 * t2670;
  t4410 = t162 * t1950 * t4378;
  t4411 = 0.3e1 / 0.32e2 * t4410;
  t4413 = t177 * t919 * t4116;
  t4414 = t4413 / 0.8e1;
  t4415 = t4377 - t4381 - t4383 - t177 * t909 * t2657 / 0.8e1 + 0.3e1 / 0.8e1 * t177 * t4387 * t4388 - 0.7e1 / 0.32e2 * t162 * t4354 + 0.3e1 / 0.8e1 * t177 * t909 * t2115 - 0.11e2 / 0.16e2 * t177 * t4387 * t4154 + 0.9e1 / 0.16e2 * t162 * t4401 + 0.11e2 / 0.16e2 * t177 * t4401 - 0.3e1 / 0.8e1 * t177 * t4406 + t4411 - t4414;
  t4418 = t162 * t1939 * t4378;
  t4419 = 0.3e1 / 0.32e2 * t4418;
  t4448 = t4087 / 0.8e1;
  t4453 = t4419 + t1270 * t906 / 0.16e2 + 0.3e1 / 0.16e2 * t162 * t864 * t3041 + t177 * t848 * t2136 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t852 * t2670 - 0.9e1 / 0.16e2 * t162 * t1950 * t4400 + 0.3e1 / 0.8e1 * t177 * t919 * t4346 - t177 * t919 * t2670 / 0.4e1 - 0.11e2 / 0.32e2 * t162 * t1939 * t4400 + 0.3e1 / 0.16e2 * t162 * t905 * t3041 - 0.3e1 / 0.16e2 * t162 * t4406 - t4448 - t177 * t1280 * t59 * t1855 / 0.16e2;
  t4454 = t4091 / 0.2e1;
  t4455 = 0.3e1 / 0.8e1 * t4095;
  t4456 = 0.3e1 / 0.8e1 * t4099;
  t4457 = t4103 / 0.4e1;
  t4458 = 0.3e1 / 0.16e2 * t4108;
  t4459 = 0.3e1 / 0.8e1 * t4112;
  t4460 = 0.3e1 / 0.16e2 * t4114;
  t4461 = 0.3e1 / 0.16e2 * t4118;
  t4464 = t177 * t204 * t258 * t140;
  t4465 = t4464 / 0.16e2;
  t4474 = t4454 - t4455 + t4456 - t4457 + t4458 - t4459 - t4460 + t4461 - t4465 + t509 * t1303 / 0.8e1 - 0.3e1 / 0.32e2 * t509 * t1307 - t509 * t1292 / 0.16e2 + 0.3e1 / 0.64e2 * t557 * t1295;
  t4487 = t509 * t1266;
  t4488 = t4487 / 0.32e2;
  t4490 = t15 * t45 * t1249;
  t4493 = t557 * t1273;
  t4494 = t4493 / 0.64e2;
  t4495 = t509 * t1258;
  t4496 = t4495 / 0.32e2;
  t4497 = t509 * t1262;
  t4498 = t4497 / 0.32e2;
  t4506 = -0.3e1 / 0.64e2 * t557 * t1288 + 0.3e1 / 0.64e2 * t557 * t1300 - t509 * t1281 / 0.32e2 + 0.3e1 / 0.32e2 * t509 * t1284 - 0.3e1 / 0.32e2 * t509 * t1288 + t4488 - t4490 * t276 / 0.64e2 - t4494 - t4496 + t4498 + 0.3e1 / 0.32e2 * t561 * t1295 + 0.3e1 / 0.32e2 * t162 * t771 * t2319 - 0.3e1 / 0.32e2 * t561 * t1288;
  t4507 = t771 * t3449;
  t4515 = t204 * t253;
  t4528 = t162 * t788 * t590;
  t4529 = t4528 / 0.32e2;
  t4531 = t177 * t628 * t1261;
  t4532 = t4531 / 0.16e2;
  t4534 = t177 * t651 * t1265;
  t4535 = t4534 / 0.16e2;
  t4537 = t15 * t18 * t4303;
  t4544 = -0.3e1 / 0.32e2 * t162 * t4507 + 0.3e1 / 0.32e2 * t561 * t1300 + 0.3e1 / 0.32e2 * t162 * t776 * t2263 + t177 * t4515 * t395 / 0.4e1 - t177 * t4515 * t475 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t4515 * t428 - 0.3e1 / 0.16e2 * t177 * t4507 - t4529 + t4532 + t4535 - t4537 * t276 / 0.32e2 - t1270 * t894 / 0.32e2 - t1270 * t898 / 0.32e2;
  t4546 = t561 * t1273;
  t4547 = t4546 / 0.32e2;
  t4554 = t4171 / 0.16e2;
  t4555 = t4173 / 0.32e2;
  t4556 = t4180 / 0.16e2;
  t4557 = t4182 / 0.16e2;
  t4558 = t4203 / 0.16e2;
  t4559 = t4208 / 0.16e2;
  t4560 = t4215 / 0.8e1;
  t4561 = t4218 / 0.8e1;
  t4562 = t4223 / 0.8e1;
  t4563 = -t4547 - 0.3e1 / 0.16e2 * t177 * t2248 * t1306 - t177 * t651 * t1291 / 0.8e1 + t4554 - t4555 - t4556 + t4557 - t4558 - t4559 - t4560 + t4561 + t4562 + t1276;
  t4564 = -t1277 - t1278 + t1279 - t1260 + t1264 + t1268 - t1275 - t815 - t766 + t791 + t810 - t806 - t262;
  t4568 = my_piecewise3(t3, 0, t4373 + t4415 + t4453 + t4474 + t4506 + t4544 + t4563 + t4564);
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t4568 + 0.2e1 * t1311;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t4571 = t1328 * t113;
  t4576 = t3198 * t59;
  t4577 = t771 * t145 * t4576;
  t4584 = t4571 * t4123;
  t4587 = t940 * t4346;
  t4598 = t177 * t2414 * t4116;
  t4599 = t4598 / 0.4e1;
  t4601 = t177 * t940 * t4116;
  t4602 = 0.3e1 / 0.16e2 * t4601;
  t4607 = t4110 * t929;
  t4608 = t162 * t4607;
  t4609 = 0.3e1 / 0.32e2 * t4608;
  t4610 = 0.11e2 / 0.16e2 * t177 * t4571 * t4128 + 0.9e1 / 0.16e2 * t162 * t4577 - 0.9e1 / 0.16e2 * t162 * t776 * t383 * t4576 - 0.3e1 / 0.2e1 * t177 * t4584 + 0.9e1 / 0.8e1 * t177 * t4587 - 0.25e2 / 0.16e2 * t177 * t1328 * t381 * t4138 + 0.15e2 / 0.16e2 * t177 * t3194 * t4346 + t4599 - t4602 - t1270 * t930 / 0.16e2 + t1270 * t933 / 0.16e2 - t4609;
  t4612 = t177 * t950 * t4116;
  t4613 = t4612 / 0.8e1;
  t4614 = t928 * t258;
  t4616 = t162 * t1939 * t4614;
  t4617 = 0.3e1 / 0.32e2 * t4616;
  t4620 = t928 * t171;
  t4624 = t771 * t115;
  t4631 = t1328 * t36;
  t4637 = t1420 * t2670;
  t4648 = t177 * t4607;
  t4649 = 0.3e1 / 0.16e2 * t4648;
  t4650 = -t4613 + t4617 + t1270 * t954 / 0.16e2 + 0.3e1 / 0.16e2 * t162 * t905 * t4620 - 0.11e2 / 0.32e2 * t162 * t4624 * t4576 + 0.3e1 / 0.8e1 * t177 * t957 * t2115 - 0.11e2 / 0.16e2 * t177 * t4631 * t4154 + 0.11e2 / 0.16e2 * t177 * t4577 - 0.3e1 / 0.8e1 * t177 * t4637 - t177 * t957 * t2657 / 0.8e1 + 0.3e1 / 0.8e1 * t177 * t4631 * t4388 - 0.7e1 / 0.32e2 * t162 * t4584 - t4649;
  t4653 = t162 * t1950 * t4614;
  t4654 = 0.3e1 / 0.32e2 * t4653;
  t4676 = t3198 * t253;
  t4681 = t177 * t2425 * t2833;
  t4682 = 0.3e1 / 0.16e2 * t4681;
  t4685 = t177 * t1324 * t59 * t475;
  t4686 = t4685 / 0.16e2;
  t4691 = t4654 - 0.3e1 / 0.16e2 * t162 * t4637 + 0.3e1 / 0.16e2 * t162 * t864 * t4620 + 0.3e1 / 0.8e1 * t177 * t950 * t4346 - t177 * t950 * t2670 / 0.4e1 + t177 * t936 * t2136 / 0.2e1 + 0.11e2 / 0.16e2 * t162 * t4587 - 0.3e1 / 0.8e1 * t177 * t940 * t2670 - 0.15e2 / 0.32e2 * t162 * t59 * t1720 * t1722 * t4676 + t4682 - t4686 - t177 * t1328 * t59 * t1855 / 0.16e2 - t4448;
  t4695 = t177 * t709 * t1261;
  t4696 = t4695 / 0.16e2;
  t4698 = t177 * t744 * t1265;
  t4699 = t4698 / 0.16e2;
  t4704 = t4454 - t4455 + t4456 - t4457 + t4458 - t4459 - t4460 + t4461 - t4490 * t294 / 0.64e2 + t4696 + t4699 + 0.3e1 / 0.64e2 * t557 * t1352 + t509 * t1344 / 0.8e1;
  t4721 = t557 * t1321;
  t4722 = t4721 / 0.64e2;
  t4723 = t509 * t1325;
  t4724 = t4723 / 0.32e2;
  t4725 = t509 * t1313;
  t4726 = t4725 / 0.32e2;
  t4727 = t509 * t1316;
  t4728 = t4727 / 0.32e2;
  t4734 = -0.3e1 / 0.32e2 * t509 * t1347 - 0.3e1 / 0.64e2 * t557 * t1338 + 0.3e1 / 0.32e2 * t509 * t1335 - 0.3e1 / 0.32e2 * t509 * t1338 - t509 * t1341 / 0.16e2 - t509 * t1329 / 0.32e2 + 0.3e1 / 0.64e2 * t557 * t1332 - t4722 - t4724 + t4726 + t4728 + 0.3e1 / 0.32e2 * t561 * t1352 + 0.3e1 / 0.32e2 * t162 * t776 * t2569;
  t4735 = t232 * t253;
  t4747 = t709 * t1287;
  t4759 = t561 * t1321;
  t4760 = t4759 / 0.32e2;
  t4762 = t162 * t788 * t740;
  t4763 = t4762 / 0.32e2;
  t4766 = t177 * t232 * t258 * t140;
  t4767 = t4766 / 0.16e2;
  t4771 = -t177 * t4735 * t475 / 0.16e2 + 0.3e1 / 0.32e2 * t561 * t1332 + 0.3e1 / 0.32e2 * t162 * t771 * t2540 + 0.3e1 / 0.16e2 * t177 * t4735 * t428 - 0.3e1 / 0.16e2 * t177 * t4747 - t177 * t744 * t1291 / 0.8e1 - t4537 * t294 / 0.32e2 - t1270 * t969 / 0.32e2 - t1270 * t972 / 0.32e2 - t4760 - t4763 - t4767 + t177 * t4735 * t395 / 0.4e1;
  t4780 = -0.3e1 / 0.16e2 * t177 * t2494 * t1306 - 0.3e1 / 0.32e2 * t561 * t1338 - 0.3e1 / 0.32e2 * t162 * t4747 + t4554 - t4555 - t4556 + t4557 - t4558 - t4559 - t4560 + t4561 + t4562 - t1327;
  t4781 = t1315 + t1318 - t1323 + t1276 - t1277 - t1278 + t1279 - t815 - t766 + t791 + t810 - t806 - t262;
  t4785 = my_piecewise3(t3, 0, t4610 + t4650 + t4691 + t4704 + t4734 + t4771 + t4780 + t4781);
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t4785 + 0.2e1 * t1356;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t4788 = t3518 * t1722;
  t4789 = t2918 * t59;
  t4802 = t1007 * t145 * t4789;
  t4810 = t1011 * t400 * t4789;
  t4814 = t1007 * t383 * t4789;
  t4821 = t1715 * t310;
  t4822 = t4821 * t74;
  t4833 = -0.15e2 / 0.32e2 * t162 * t4788 * t4789 - 0.25e2 / 0.16e2 * t177 * t1011 * t1722 * t4789 + 0.15e2 / 0.16e2 * t177 * t3518 * t1740 * t4789 + 0.9e1 / 0.16e2 * t162 * t4802 + 0.11e2 / 0.16e2 * t177 * t1382 * t113 * t4128 + 0.11e2 / 0.16e2 * t162 * t4810 - 0.3e1 / 0.2e1 * t177 * t4814 + 0.9e1 / 0.8e1 * t177 * t4810 + 0.11e2 / 0.16e2 * t177 * t4802 - 0.9e1 / 0.16e2 * t162 * t1950 * t4822 - t177 * t919 * t3037 / 0.4e1 + 0.3e1 / 0.8e1 * t177 * t1027 * t61 * t4789;
  t4851 = t1065 * t3037;
  t4863 = t1003 * t36;
  t4874 = -0.11e2 / 0.32e2 * t162 * t1939 * t4822 + 0.3e1 / 0.16e2 * t162 * t1084 * t3037 + t177 * t3453 * t3037 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t852 * t3037 - t177 * t909 * t3449 / 0.8e1 - 0.7e1 / 0.32e2 * t162 * t4814 - 0.3e1 / 0.16e2 * t162 * t4851 + 0.3e1 / 0.16e2 * t162 * t1069 * t3037 + 0.3e1 / 0.8e1 * t177 * t217 * t115 * t3037 - 0.3e1 / 0.8e1 * t177 * t4851 + 0.3e1 / 0.8e1 * t177 * t4863 * t1970 - t177 * t1382 * t59 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t4863 * t2022;
  t4876 = t4334 / 0.8e1;
  t4877 = t4364 / 0.2e1;
  t4878 = 0.3e1 / 0.8e1 * t4367;
  t4879 = 0.3e1 / 0.8e1 * t4376;
  t4880 = 0.3e1 / 0.16e2 * t4380;
  t4881 = 0.3e1 / 0.8e1 * t4382;
  t4882 = 0.3e1 / 0.16e2 * t4410;
  t4883 = t4413 / 0.4e1;
  t4884 = 0.3e1 / 0.16e2 * t4418;
  t4885 = t4087 / 0.16e2;
  t4886 = t4091 / 0.4e1;
  t4887 = 0.3e1 / 0.16e2 * t4095;
  t4888 = 0.3e1 / 0.16e2 * t4099;
  t4889 = -t4876 + t4877 - t4878 + t4879 - t4880 - t4881 + t4882 - t4883 + t4884 - t4885 + t4886 - t4887 + t4888;
  t4890 = t4103 / 0.8e1;
  t4891 = 0.3e1 / 0.32e2 * t4108;
  t4892 = 0.3e1 / 0.16e2 * t4112;
  t4893 = 0.3e1 / 0.32e2 * t4114;
  t4894 = 0.3e1 / 0.32e2 * t4118;
  t4899 = t1007 * t2657;
  t4914 = -t4890 + t4891 - t4892 - t4893 + t4894 - t1270 * t1053 / 0.16e2 + t1270 * t1031 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t4899 - t177 * t1027 * t4191 / 0.8e1 + 0.3e1 / 0.32e2 * t561 * t1369 + 0.3e1 / 0.32e2 * t162 * t1007 * t2115 - t1270 * t1015 / 0.16e2 + t1270 * t1018 / 0.16e2;
  t4945 = t509 * t1391 / 0.8e1 - 0.3e1 / 0.32e2 * t509 * t1395 - t509 * t1383 / 0.32e2 - 0.3e1 / 0.64e2 * t557 * t1362 + 0.3e1 / 0.64e2 * t557 * t1388 + 0.3e1 / 0.32e2 * t509 * t1372 - 0.3e1 / 0.32e2 * t509 * t1362 - t509 * t1366 / 0.16e2 + 0.3e1 / 0.64e2 * t557 * t1369 + t177 * t1007 * t2136 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1011 * t4228 - t177 * t310 * t171 * t475 / 0.16e2;
  t4958 = t4464 / 0.8e1;
  t4959 = t4487 / 0.16e2;
  t4960 = t4493 / 0.32e2;
  t4961 = t4495 / 0.16e2;
  t4962 = t4497 / 0.16e2;
  t4963 = t4528 / 0.16e2;
  t4964 = t4531 / 0.8e1;
  t4965 = t4534 / 0.8e1;
  t4966 = -0.3e1 / 0.32e2 * t561 * t1362 - 0.3e1 / 0.32e2 * t162 * t4899 + 0.3e1 / 0.32e2 * t561 * t1388 + 0.3e1 / 0.32e2 * t162 * t1011 * t2136 + 0.3e1 / 0.16e2 * t177 * t1027 * t2115 - t4958 + t4959 - t4960 - t4961 + t4962 - t4963 + t4964 + t4965;
  t4968 = t4546 / 0.16e2;
  t4969 = t4171 / 0.32e2;
  t4970 = t4173 / 0.64e2;
  t4971 = t4180 / 0.32e2;
  t4972 = t4182 / 0.32e2;
  t4973 = t4203 / 0.32e2;
  t4974 = t4208 / 0.32e2;
  t4975 = t4215 / 0.16e2;
  t4976 = t4218 / 0.16e2;
  t4977 = t4223 / 0.16e2;
  t4984 = -t4968 + t4969 - t4970 - t4971 + t4972 - t4973 - t4974 - t4975 + t4976 + t4977 - t105 * t1359 / 0.64e2 - t48 * t4303 * t310 * t119 / 0.32e2 + t1379;
  t4985 = -t1380 - t1381 + t1398 - t1375 + t1376 + t1377 - t1378 - t815 - t766 + t791 + t810 - t806 - t262;
  t4989 = my_piecewise3(t3, 0, t4833 + t4874 + t4889 + t4914 + t4945 + t4966 + t4984 + t4985);
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t4989 + 0.2e1 * t1400;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  t5018 = t3293 * t74;
  t5033 = -t1270 * t1066 / 0.16e2 + t1270 * t1070 / 0.16e2 - 0.3e1 / 0.32e2 * t509 * t1424 - 0.3e1 / 0.64e2 * t557 * t1421 + 0.3e1 / 0.64e2 * t557 * t1429 + t509 * t1432 / 0.8e1 + 0.3e1 / 0.64e2 * t557 * t1414 + 0.3e1 / 0.32e2 * t509 * t1417 - 0.3e1 / 0.32e2 * t509 * t1421 - t509 * t1406 / 0.32e2 - t509 * t1410 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t628 * t115 * t1413 + 0.3e1 / 0.32e2 * t162 * t1084 * t5018 + 0.3e1 / 0.32e2 * t162 * t1084 * t4620 + 0.3e1 / 0.16e2 * t177 * t1109 * t36 * t535 + 0.3e1 / 0.16e2 * t177 * t1114 * t36 * t535;
  t5037 = t3238 * t1409;
  t5069 = t1420 * t3037;
  t5072 = t1420 * t3041;
  t5086 = 0.3e1 / 0.16e2 * t177 * t1088 * t2115 - 0.3e1 / 0.16e2 * t177 * t5037 - t177 * t1109 * t74 * t475 / 0.16e2 - t177 * t1114 * t74 * t475 / 0.16e2 - t177 * t331 * t171 * t475 / 0.16e2 - t177 * t3317 * t1409 / 0.8e1 + t1270 * t1085 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1069 * t4620 + t177 * t3705 * t504 / 0.4e1 + t177 * t3709 * t504 / 0.4e1 + t177 * t1073 * t2136 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t5069 - 0.3e1 / 0.16e2 * t177 * t5072 - 0.3e1 / 0.16e2 * t177 * t3332 * t1409 - 0.3e1 / 0.16e2 * t177 * t940 * t3037 - 0.3e1 / 0.16e2 * t177 * t940 * t3041 - 0.3e1 / 0.32e2 * t561 * t1421;
  t5110 = -0.3e1 / 0.32e2 * t162 * t5069 - 0.3e1 / 0.32e2 * t162 * t5037 - 0.3e1 / 0.32e2 * t162 * t5072 + 0.3e1 / 0.32e2 * t561 * t1429 + 0.3e1 / 0.32e2 * t162 * t3695 * t1413 + 0.3e1 / 0.32e2 * t162 * t1069 * t5018 - t177 * t950 * t3037 / 0.8e1 - t177 * t950 * t3041 / 0.8e1 + 0.3e1 / 0.32e2 * t561 * t1414 + t4599 - t4602 - t4609 - t4613 + t4617 - t4649 + t4654 - t4335;
  t5111 = t4682 - t4686 + t4365 - t4368 + t4377 - t4381 - t4383 + t4411 - t4414 + t4419 - t4885 + t4886 - t4887 + t4888 - t4890 + t4891 - t4892;
  t5122 = t15 * t16;
  t5123 = t17 * t110;
  t5125 = t5122 * t5123 * t83;
  t5131 = t5122 * t17 * t49 * t91;
  t5160 = -t4893 + t4894 - t4490 * t328 / 0.64e2 - t4537 * t328 / 0.32e2 - t1270 * t1103 / 0.32e2 - t1270 * t1106 / 0.32e2 + 0.11e2 / 0.16e2 * t5125 * t1716 * t944 + 0.11e2 / 0.16e2 * t5131 * t848 * t4128 + 0.11e2 / 0.16e2 * t5131 * t1746 * t915 + 0.9e1 / 0.16e2 * t5125 * t1746 * t944 - 0.9e1 / 0.16e2 * t5125 * t1750 * t944 - 0.3e1 / 0.2e1 * t5131 * t3453 * t4789 - t5131 * t915 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t5131 * t4281 * t115 * t3003 + 0.9e1 / 0.8e1 * t5131 * t1716 * t915 - 0.25e2 / 0.16e2 * t5131 * t1735 * t915;
  t5165 = t5122 * t5123 * t59;
  t5181 = 0.15e2 / 0.16e2 * t5131 * t1742 * t915 - 0.15e2 / 0.32e2 * t5165 * t1724 * t1405 - 0.11e2 / 0.32e2 * t5165 * t1819 * t1405 + 0.3e1 / 0.8e1 * t5131 * t909 * t4388 - 0.7e1 / 0.32e2 * t5165 * t1864 * t1405 + 0.3e1 / 0.8e1 * t5131 * t1885 * t915 + t4696 + t4699 - t4722 - t4724 + t4726 + t4728 - t4760 - t4763 - t4767 - t4465 + t4488;
  t5183 = -t4494 - t4496 + t4498 - t4529 + t4532 + t4535 - t4547 + t4969 - t4970 - t4971 + t4972 - t4973 - t4974 - t4975 + t4976 + t4977 - t1327;
  t5184 = t1315 + t1318 - t1323 + t1379 - t1380 - t1381 + t1398 - t1260 + t1264 + t1268 - t1275 - t815 - t766 + t791 + t810 - t806 - t262;
  t5188 = my_piecewise3(t3, 0, t5033 + t5086 + t5110 + t5111 + t5160 + t5181 + t5183 + t5184);
  tv4rhosigmalapltau0 = 0.2e1 * rho[0] * t5188 + 0.2e1 * t1437;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t5191 = t3973 * t1722;
  t5195 = t1182 * t1722;
  t5199 = t3973 * t1740;
  t5203 = t1182 * t400;
  t5204 = t5203 * t4789;
  t5213 = t1147 * t383;
  t5214 = t5213 * t4789;
  t5221 = t241 * t115;
  t5225 = t245 * t115;
  t5233 = t1715 * t346;
  t5234 = t5233 * t74;
  t5235 = t2196 * t5234;
  t5238 = -0.15e2 / 0.32e2 * t162 * t5191 * t4789 - 0.25e2 / 0.16e2 * t177 * t5195 * t4789 + 0.15e2 / 0.16e2 * t177 * t5199 * t4789 + 0.9e1 / 0.8e1 * t177 * t5204 + 0.11e2 / 0.16e2 * t177 * t1459 * t113 * t4128 + 0.11e2 / 0.16e2 * t162 * t5204 - 0.3e1 / 0.2e1 * t177 * t5214 - t177 * t1459 * t59 * t1855 / 0.16e2 + 0.3e1 / 0.16e2 * t162 * t5221 * t5018 + 0.3e1 / 0.8e1 * t177 * t5225 * t5018 - 0.11e2 / 0.16e2 * t177 * t1143 * t115 * t4789 + 0.9e1 / 0.16e2 * t162 * t5235;
  t5239 = t1420 * t5018;
  t5247 = t1176 * t36;
  t5264 = t697 * t383;
  t5271 = t1143 * t61;
  t5278 = -0.3e1 / 0.8e1 * t177 * t5239 + 0.11e2 / 0.16e2 * t177 * t5235 - 0.9e1 / 0.16e2 * t162 * t1950 * t5234 + 0.3e1 / 0.8e1 * t177 * t5247 * t1970 + t177 * t2414 * t5018 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t940 * t5018 - 0.3e1 / 0.16e2 * t162 * t5239 - t177 * t957 * t3892 / 0.8e1 - 0.7e1 / 0.32e2 * t162 * t5214 + 0.3e1 / 0.16e2 * t162 * t5264 * t5018 - t177 * t950 * t5018 / 0.4e1 + 0.3e1 / 0.8e1 * t177 * t5271 * t4789 - 0.11e2 / 0.32e2 * t162 * t1939 * t5234;
  t5280 = t4598 / 0.2e1;
  t5281 = 0.3e1 / 0.8e1 * t4601;
  t5282 = 0.3e1 / 0.16e2 * t4608;
  t5283 = t4612 / 0.4e1;
  t5284 = 0.3e1 / 0.16e2 * t4616;
  t5285 = 0.3e1 / 0.8e1 * t4648;
  t5286 = 0.3e1 / 0.16e2 * t4653;
  t5287 = 0.3e1 / 0.8e1 * t4681;
  t5288 = t4685 / 0.8e1;
  t5289 = t5280 - t5281 - t5282 - t5283 + t5284 - t5285 + t5286 + t5287 - t5288 - t4885 + t4886 - t4887 + t4888;
  t5306 = -t4890 + t4891 - t4892 - t4893 + t4894 - t1270 * t1165 / 0.16e2 + t1270 * t1183 / 0.16e2 - 0.3e1 / 0.32e2 * t509 * t1469 - 0.3e1 / 0.64e2 * t557 * t1446 - t509 * t1460 / 0.32e2 + 0.3e1 / 0.64e2 * t557 * t1463 + 0.3e1 / 0.64e2 * t557 * t1452 + 0.3e1 / 0.32e2 * t509 * t1443;
  t5316 = t1147 * t2657;
  t5339 = -0.3e1 / 0.32e2 * t509 * t1446 - t509 * t1449 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t1143 * t2115 - 0.3e1 / 0.16e2 * t177 * t5316 - t177 * t1143 * t4191 / 0.8e1 + 0.3e1 / 0.32e2 * t561 * t1452 + 0.3e1 / 0.32e2 * t162 * t1147 * t2115 - t1270 * t1172 / 0.16e2 + t1270 * t1148 / 0.16e2 + 0.3e1 / 0.32e2 * t561 * t1463 + 0.3e1 / 0.32e2 * t162 * t1182 * t2136 + t177 * t1147 * t2136 / 0.4e1;
  t5353 = t4695 / 0.8e1;
  t5354 = t4698 / 0.8e1;
  t5355 = t4721 / 0.32e2;
  t5356 = t4723 / 0.16e2;
  t5357 = t4725 / 0.16e2;
  t5358 = t4727 / 0.16e2;
  t5359 = t4759 / 0.16e2;
  t5360 = t4762 / 0.16e2;
  t5361 = -0.3e1 / 0.16e2 * t177 * t1182 * t4228 - 0.3e1 / 0.32e2 * t561 * t1446 - 0.3e1 / 0.32e2 * t162 * t5316 - t177 * t346 * t171 * t475 / 0.16e2 + t509 * t1466 / 0.8e1 + t5353 + t5354 - t5355 - t5356 + t5357 + t5358 - t5359 - t5360;
  t5363 = t4766 / 0.8e1;
  t5370 = -t5363 + t4969 - t4970 - t4971 + t4972 - t4973 - t4974 - t4975 + t4976 + t4977 - t48 * t4303 * t346 * t119 / 0.32e2 - t105 * t1440 / 0.64e2 - t1458;
  t5371 = t1455 + t1456 - t1457 + t1379 - t1380 - t1381 + t1398 - t815 - t766 + t791 + t810 - t806 - t262;
  t5375 = my_piecewise3(t3, 0, t5238 + t5278 + t5289 + t5306 + t5339 + t5361 + t5370 + t5371);
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t5375 + 0.2e1 * t1475;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t5387 = t1487 * t59;
  t5397 = t1487 * t381;
  t5398 = t5397 * t4128;
  t5401 = t1487 * t113;
  t5407 = t1487 * t1720;
  t5414 = -0.3e1 / 0.16e2 * t4334 + 0.3e1 / 0.4e1 * t4364 - 0.9e1 / 0.16e2 * t4367 + 0.9e1 / 0.16e2 * t4376 - 0.9e1 / 0.32e2 * t4380 - 0.9e1 / 0.16e2 * t4382 + 0.9e1 / 0.32e2 * t4410 - 0.3e1 / 0.8e1 * t4413 + 0.9e1 / 0.32e2 * t4418 - 0.11e2 / 0.16e2 * t177 * t5387 * t1840 + 0.3e1 / 0.8e1 * t177 * t5387 * t1846 - t177 * t5387 * t1855 / 0.16e2 + 0.9e1 / 0.8e1 * t177 * t5398 + 0.11e2 / 0.16e2 * t177 * t5401 * t4128 + 0.11e2 / 0.16e2 * t162 * t5398 - 0.15e2 / 0.32e2 * t162 * t5407 * t4138 - 0.25e2 / 0.16e2 * t177 * t5397 * t4138;
  t5422 = t5401 * t4388;
  t5430 = t528 * t204;
  t5434 = t1487 * t36;
  t5438 = t2021 * t1487;
  t5448 = t1007 * t3449;
  t5455 = t5401 * t4123;
  t5461 = t579 * t204;
  t5468 = 0.15e2 / 0.16e2 * t177 * t5407 * t4145 - t1525 * t1015 / 0.16e2 + t1525 * t1018 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t5422 + 0.9e1 / 0.16e2 * t162 * t5422 - 0.9e1 / 0.16e2 * t162 * t5397 * t4123 - 0.3e1 / 0.8e1 * t177 * t1027 * t5430 + 0.3e1 / 0.8e1 * t177 * t5434 * t4195 - 0.11e2 / 0.32e2 * t162 * t163 * t5438 + 0.9e1 / 0.32e2 * t162 * t1007 * t2319 + 0.9e1 / 0.16e2 * t177 * t1027 * t2319 - 0.9e1 / 0.16e2 * t177 * t5448 - t1525 * t1053 / 0.16e2 + t1525 * t1031 / 0.16e2 - 0.3e1 / 0.2e1 * t177 * t5455 + 0.3e1 / 0.4e1 * t177 * t1007 * t2263 - 0.9e1 / 0.16e2 * t177 * t1011 * t5461 - 0.3e1 / 0.16e2 * t177 * t1027 * t3449;
  t5498 = -0.7e1 / 0.32e2 * t162 * t5455 - 0.9e1 / 0.32e2 * t162 * t5448 + 0.9e1 / 0.32e2 * t162 * t1011 * t2263 - 0.3e1 / 0.16e2 * t4464 + 0.3e1 / 0.32e2 * t4487 - 0.3e1 / 0.64e2 * t4493 - 0.3e1 / 0.32e2 * t4495 + 0.3e1 / 0.32e2 * t4497 - 0.3e1 / 0.32e2 * t4528 + 0.3e1 / 0.16e2 * t4531 + 0.3e1 / 0.16e2 * t4534 - 0.3e1 / 0.32e2 * t4546 + t105 * t1515 / 0.8e1 - 0.3e1 / 0.32e2 * t105 * t1518 - t105 * t1506 / 0.32e2 - 0.3e1 / 0.64e2 * t105 * t1509 + 0.3e1 / 0.64e2 * t105 * t1512 - t105 * t1489 / 0.16e2;
  t5507 = t441 * t1487;
  t5520 = t84 * t113;
  t5523 = t84 * t36;
  t5526 = t1761 * t83;
  t5529 = t118 * t83;
  t5530 = t116 * t5529;
  t5554 = t4255 * t200 / 0.4e1 + t206 / 0.2e1 + t84 * t59 * t140 / 0.2e1 - t5520 * t184 / 0.2e1 - t5523 * t190 / 0.2e1 - t5526 * t4270 / 0.2e1 + t4273 * t5530 / 0.2e1 + t434 * t204 * t64 / 0.2e1 + t1477 * t4282 / 0.2e1 - t1477 * t4285 / 0.2e1 - t1477 * t4288 / 0.2e1 - t1779 * t83 * t64 / 0.2e1 - t437 * t204 * t64 / 0.2e1 - t1479 * t4282 / 0.2e1 + t1479 * t4285 / 0.2e1 + t1479 * t4288 / 0.2e1;
  t5562 = 0.3e1 / 0.64e2 * t105 * t1493 + 0.3e1 / 0.32e2 * t105 * t1496 - 0.3e1 / 0.32e2 * t105 * t1499 - t105 * t1484 / 0.64e2 - 0.3e1 / 0.32e2 * t48 * t5507 * t377 + 0.3e1 / 0.32e2 * t48 * t5507 * t385 - t48 * t5554 * t310 * t119 / 0.32e2 + 0.3e1 / 0.32e2 * t48 * t5507 * t420 - t1502 + t1503 + t1504 - t1505 - t815 - t766 + t791 + t810 - t806 - t262;
  t5565 = my_piecewise3(t3, 0, t5414 + t5468 + t5498 + t5562);
  tv4rholapl30 = 0.2e1 * rho[0] * t5565 + 0.2e1 * t1522;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  t5571 = t1528 * t36;
  t5576 = t3198 * t310;
  t5577 = t163 * t383 * t5576;
  t5589 = t1420 * t3462;
  t5600 = t4821 * t59;
  t5607 = -t177 * t1088 * t3449 / 0.8e1 + 0.3e1 / 0.8e1 * t177 * t5571 * t4388 - 0.7e1 / 0.32e2 * t162 * t5577 + t1525 * t1085 / 0.16e2 - t177 * t1528 * t59 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t2425 * t3559 - 0.3e1 / 0.8e1 * t177 * t5589 - 0.3e1 / 0.16e2 * t162 * t5589 + 0.3e1 / 0.16e2 * t162 * t1069 * t3723 + t177 * t1073 * t2263 / 0.2e1 + 0.3e1 / 0.8e1 * t177 * t950 * t5600 - t177 * t950 * t3462 / 0.4e1;
  t5622 = t1528 * t113;
  t5626 = t1420 * t5600;
  t5631 = t1011 * t383;
  t5642 = t940 * t5600;
  t5645 = -0.11e2 / 0.32e2 * t162 * t1939 * t5576 + 0.3e1 / 0.16e2 * t162 * t1084 * t3723 + 0.3e1 / 0.8e1 * t177 * t1088 * t2319 + 0.15e2 / 0.16e2 * t177 * t3194 * t5600 + t1525 * t1070 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t5622 * t4128 + 0.11e2 / 0.16e2 * t177 * t5626 + 0.9e1 / 0.16e2 * t162 * t5626 - 0.9e1 / 0.16e2 * t162 * t5631 * t4576 - t1525 * t1066 / 0.16e2 - 0.3e1 / 0.8e1 * t177 * t940 * t3462 - 0.3e1 / 0.2e1 * t177 * t5577 + 0.9e1 / 0.8e1 * t177 * t5642;
  t5652 = t1528 * t381;
  t5656 = 0.11e2 / 0.16e2 * t162 * t5642 - 0.15e2 / 0.32e2 * t162 * t4788 * t4576 - 0.25e2 / 0.16e2 * t177 * t5652 * t4138 + t4599 - t4602 - t4609 - t4613 + t4617 - t4649 + t4654 - t4876 + t4682 - t4686;
  t5669 = t4877 - t4878 + t4879 - t4880 - t4881 + t4882 - t4883 + t4884 + 0.3e1 / 0.64e2 * t557 * t1536 + 0.3e1 / 0.32e2 * t509 * t1539 - 0.3e1 / 0.32e2 * t509 * t1543 - t509 * t1529 / 0.32e2 - t15 * t45 * t1482 * t328 / 0.64e2;
  t5677 = t232 * t310;
  t5695 = t709 * t1542;
  t5709 = 0.3e1 / 0.32e2 * t561 * t1548 + 0.3e1 / 0.32e2 * t162 * t1011 * t2569 + t177 * t5677 * t395 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t2494 * t1554 - t177 * t744 * t1532 / 0.8e1 + 0.3e1 / 0.32e2 * t561 * t1536 + 0.3e1 / 0.32e2 * t162 * t1007 * t2540 + 0.3e1 / 0.16e2 * t177 * t5677 * t428 - 0.3e1 / 0.16e2 * t177 * t5695 - t177 * t5677 * t475 / 0.16e2 - t15 * t18 * t5554 * t328 / 0.32e2 - t1525 * t1103 / 0.32e2 - t1525 * t1106 / 0.32e2;
  t5724 = -0.3e1 / 0.64e2 * t557 * t1543 + 0.3e1 / 0.64e2 * t557 * t1548 + t509 * t1551 / 0.8e1 - t509 * t1533 / 0.16e2 - 0.3e1 / 0.32e2 * t509 * t1555 - 0.3e1 / 0.32e2 * t561 * t1543 - 0.3e1 / 0.32e2 * t162 * t5695 + t4696 + t4699 - t4722 - t4724 + t4726 + t4728;
  t5726 = -t4760 - t4763 - t4767 - t4958 + t4959 - t4960 - t4961 + t4962 - t4963 + t4964 + t4965 - t4968 - t1327;
  t5727 = t1315 + t1318 - t1323 - t1375 + t1376 + t1377 - t1378 - t815 - t766 + t791 + t810 - t806 - t262;
  t5731 = my_piecewise3(t3, 0, t5607 + t5645 + t5656 + t5669 + t5709 + t5724 + t5726 + t5727);
  tv4rholapl2tau0 = 0.2e1 * rho[0] * t5731 + 0.2e1 * t1559;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  t5734 = t5280 - t5281 - t5282 - t5283 + t5284 - t5285 + t5286 - t4335 + t5287 - t5288 + t4365 - t4368;
  t5741 = t1147 * t3449;
  t5755 = t4377 - t4381 - t4383 + t4411 - t4414 + t4419 + 0.3e1 / 0.32e2 * t162 * t1182 * t2263 + t177 * t1147 * t2263 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t5741 - t177 * t1143 * t5430 / 0.8e1 + 0.3e1 / 0.32e2 * t561 * t1572 + 0.3e1 / 0.32e2 * t162 * t1147 * t2319 + 0.3e1 / 0.16e2 * t177 * t1143 * t2319;
  t5783 = -t1525 * t1172 / 0.16e2 + t1525 * t1148 / 0.16e2 + 0.3e1 / 0.64e2 * t557 * t1584 + t509 * t1587 / 0.8e1 - 0.3e1 / 0.32e2 * t509 * t1591 - t509 * t1579 / 0.32e2 - 0.3e1 / 0.64e2 * t557 * t1565 + 0.3e1 / 0.32e2 * t509 * t1575 - 0.3e1 / 0.32e2 * t509 * t1565 - t509 * t1569 / 0.16e2 + 0.3e1 / 0.64e2 * t557 * t1572 - t1525 * t1165 / 0.16e2 + t1525 * t1183 / 0.16e2;
  t5797 = -0.3e1 / 0.16e2 * t177 * t1182 * t5461 - t177 * t346 * t204 * t475 / 0.16e2 - 0.3e1 / 0.32e2 * t561 * t1565 - 0.3e1 / 0.32e2 * t162 * t5741 + 0.3e1 / 0.32e2 * t561 * t1584 + t5353 + t5354 - t5355 - t5356 + t5357 + t5358 - t5359 - t5360;
  t5806 = -t5363 - t4465 + t4488 - t4494 - t4496 + t4498 - t4529 + t4532 + t4535 - t4547 - t48 * t5554 * t346 * t119 / 0.32e2 - t105 * t1562 / 0.64e2;
  t5807 = -t1458 + t1455 + t1456 - t1457 - t1260 + t1264 + t1268 - t1275 - t815 - t766 + t791 + t810 - t806;
  t5812 = t5213 * t4337;
  t5815 = t5203 * t4337;
  t5818 = t1147 * t145;
  t5819 = t5818 * t4337;
  t5829 = t1969 * t83;
  t5833 = t1420 * t3716;
  t5843 = t5233 * t83;
  t5850 = -0.25e2 / 0.16e2 * t177 * t5195 * t4337 - 0.3e1 / 0.2e1 * t177 * t5812 + 0.9e1 / 0.8e1 * t177 * t5815 + 0.9e1 / 0.16e2 * t162 * t5819 - t177 * t1578 * t59 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t5247 * t2313 + 0.3e1 / 0.8e1 * t177 * t5247 * t5829 - 0.3e1 / 0.16e2 * t162 * t5833 + 0.3e1 / 0.8e1 * t177 * t5225 * t3716 - 0.3e1 / 0.8e1 * t177 * t5833 + 0.11e2 / 0.16e2 * t177 * t5819 - 0.9e1 / 0.16e2 * t162 * t1950 * t5843 - t177 * t950 * t3716 / 0.4e1;
  t5863 = t1578 * t113;
  t5886 = 0.3e1 / 0.8e1 * t177 * t5271 * t4337 - 0.11e2 / 0.32e2 * t162 * t1939 * t5843 + 0.3e1 / 0.16e2 * t162 * t5221 * t3716 + 0.15e2 / 0.16e2 * t177 * t5199 * t4337 + 0.11e2 / 0.16e2 * t177 * t5863 * t4128 + 0.11e2 / 0.16e2 * t162 * t5815 - 0.15e2 / 0.32e2 * t162 * t5191 * t4337 + 0.3e1 / 0.16e2 * t162 * t5264 * t3716 + t177 * t2414 * t3716 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t940 * t3716 - t177 * t1088 * t3892 / 0.8e1 - 0.7e1 / 0.32e2 * t162 * t5812 - t262;
  t5890 = my_piecewise3(t3, 0, t5734 + t5755 + t5783 + t5797 + t5806 + t5807 + t5850 + t5886);
  tv4rholapltau20 = 0.2e1 * rho[0] * t5890 + 0.2e1 * t1595;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t5900 = t1597 * t381;
  t5904 = t1597 * t1720;
  t5908 = t1597 * t113;
  t5909 = t5908 * t4123;
  t5912 = t5900 * t4128;
  t5915 = t5908 * t4388;
  t5919 = t15 * t18 * t1617;
  t5932 = 0.3e1 / 0.4e1 * t4598 - 0.9e1 / 0.16e2 * t4601 - 0.9e1 / 0.32e2 * t4608 - 0.3e1 / 0.8e1 * t4612 + 0.9e1 / 0.32e2 * t4616 - 0.9e1 / 0.16e2 * t4648 + 0.9e1 / 0.32e2 * t4653 - 0.25e2 / 0.16e2 * t177 * t5900 * t4138 + 0.15e2 / 0.16e2 * t177 * t5904 * t4145 - 0.3e1 / 0.2e1 * t177 * t5909 + 0.9e1 / 0.8e1 * t177 * t5912 + 0.9e1 / 0.16e2 * t162 * t5915 - t5919 * t1165 / 0.16e2 + t5919 * t1183 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t5908 * t4128 + 0.11e2 / 0.16e2 * t162 * t5912 - 0.15e2 / 0.32e2 * t162 * t5904 * t4138;
  t5933 = t1597 * t59;
  t5955 = t1147 * t3892;
  t5960 = t1958 * t1597;
  t5968 = t1597 * t36;
  t5972 = t2021 * t1597;
  t5983 = -0.11e2 / 0.16e2 * t177 * t5933 * t1840 + 0.3e1 / 0.8e1 * t177 * t5933 * t1846 - t177 * t5933 * t1855 / 0.16e2 + 0.9e1 / 0.16e2 * t4681 - 0.3e1 / 0.16e2 * t4685 - 0.3e1 / 0.16e2 * t177 * t1143 * t3892 + 0.9e1 / 0.16e2 * t177 * t1143 * t2540 - t5919 * t1172 / 0.16e2 + t5919 * t1148 / 0.16e2 - 0.9e1 / 0.16e2 * t177 * t5955 + 0.11e2 / 0.16e2 * t177 * t5915 - 0.9e1 / 0.16e2 * t162 * t1949 * t5960 - 0.3e1 / 0.8e1 * t177 * t1143 * t528 * t232 + 0.3e1 / 0.8e1 * t177 * t5968 * t4195 - 0.11e2 / 0.32e2 * t162 * t163 * t5972 + 0.9e1 / 0.32e2 * t162 * t1147 * t2540 - 0.7e1 / 0.32e2 * t162 * t5909 - 0.9e1 / 0.32e2 * t162 * t5955;
  t6016 = 0.9e1 / 0.32e2 * t162 * t1182 * t2569 + 0.3e1 / 0.4e1 * t177 * t1147 * t2569 - 0.9e1 / 0.16e2 * t177 * t1182 * t579 * t232 + 0.3e1 / 0.16e2 * t4695 + 0.3e1 / 0.16e2 * t4698 - 0.3e1 / 0.64e2 * t4721 - 0.3e1 / 0.32e2 * t4723 + 0.3e1 / 0.32e2 * t4725 + 0.3e1 / 0.32e2 * t4727 - 0.3e1 / 0.32e2 * t4759 - 0.3e1 / 0.32e2 * t4762 - 0.3e1 / 0.16e2 * t4766 - 0.3e1 / 0.64e2 * t105 * t1629 + 0.3e1 / 0.64e2 * t105 * t1632 + t105 * t1635 / 0.8e1 - 0.3e1 / 0.32e2 * t105 * t1638 - t105 * t1626 / 0.32e2 + 0.3e1 / 0.32e2 * t105 * t1609;
  t6025 = t441 * t1597;
  t6041 = t92 * t113;
  t6044 = t92 * t36;
  t6047 = t1761 * t91;
  t6051 = t116 * t118 * t91;
  t6075 = t4255 * t227 / 0.4e1 + t234 / 0.2e1 + t92 * t59 * t140 / 0.2e1 - t6041 * t184 / 0.2e1 - t6044 * t190 / 0.2e1 - t6047 * t4270 / 0.2e1 + t4273 * t6051 / 0.2e1 + t434 * t232 * t64 / 0.2e1 + t1612 * t4282 / 0.2e1 - t1612 * t4285 / 0.2e1 - t1612 * t4288 / 0.2e1 - t1779 * t91 * t64 / 0.2e1 - t437 * t232 * t64 / 0.2e1 - t1614 * t4282 / 0.2e1 + t1614 * t4285 / 0.2e1 + t1614 * t4288 / 0.2e1;
  t6080 = -t105 * t1619 / 0.64e2 - 0.3e1 / 0.32e2 * t105 * t1599 - t105 * t1602 / 0.16e2 + 0.3e1 / 0.64e2 * t105 * t1606 - 0.3e1 / 0.32e2 * t48 * t6025 * t377 + 0.3e1 / 0.32e2 * t48 * t6025 * t385 + 0.3e1 / 0.32e2 * t48 * t6025 * t420 - t48 * t6075 * t346 * t119 / 0.32e2 - t1625 + t1622 + t1623 - t1624 - t815 - t766 + t791 + t810 - t806 - t262;
  t6083 = my_piecewise3(t3, 0, t5932 + t5983 + t6016 + t6080);
  tv4rhotau30 = 0.2e1 * rho[0] * t6083 + 0.2e1 * t1642;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t6086 = t258 * t253;
  t6088 = t177 * t6086 * t475;
  t6090 = t1270 * t1215;
  t6093 = t162 * t771 * t2833;
  t6096 = t177 * t807 * t1291;
  t6098 = t788 * t1287;
  t6099 = t177 * t6098;
  t6101 = t162 * t6098;
  t6104 = t162 * t776 * t2755;
  t6107 = t177 * t6086 * t395;
  t6110 = t177 * t2699 * t1306;
  t6113 = t177 * t6086 * t428;
  t6115 = t253 * t253;
  t6116 = t110 * t6115;
  t6120 = t1249 * t1204;
  t6133 = t258 * t258;
  t6134 = t49 * t6133;
  t6137 = 0.3e1 / 0.16e2 * t48 * t6134 * t140;
  t6138 = t49 * t6115;
  t6148 = -0.3e1 / 0.8e1 * t6088 - 0.5e1 / 0.32e2 * t6090 + 0.9e1 / 0.16e2 * t6093 - 0.3e1 / 0.4e1 * t6096 - 0.9e1 / 0.8e1 * t6099 - 0.9e1 / 0.16e2 * t6101 + 0.9e1 / 0.16e2 * t6104 + 0.3e1 / 0.2e1 * t6107 - 0.9e1 / 0.8e1 * t6110 + 0.9e1 / 0.8e1 * t6113 - 0.7e1 / 0.32e2 * t48 * t6116 * t1864 - 0.5e1 / 0.32e2 * t48 * t6120 * t377 + 0.5e1 / 0.32e2 * t48 * t6120 * t385 + 0.9e1 / 0.16e2 * t48 * t6116 * t1746 - 0.9e1 / 0.16e2 * t48 * t6116 * t1750 - t6137 - 0.11e2 / 0.16e2 * t48 * t6138 * t1840 + 0.11e2 / 0.16e2 * t48 * t6138 * t1746 + 0.3e1 / 0.8e1 * t48 * t6138 * t1885;
  t6152 = 0.3e1 / 0.32e2 * t48 * t110 * t6133 * t119;
  t6155 = 0.3e1 / 0.16e2 * t48 * t6134 * t151;
  t6185 = 0.3e1 / 0.16e2 * t48 * t6134 * t147;
  t6187 = t260 / 0.2e1;
  t6199 = t434 * t258 * t64 / 0.2e1;
  t6200 = t434 * t253;
  t6207 = t108 * t1249;
  t6213 = t437 * t258 * t64 / 0.2e1;
  t6214 = t437 * t253;
  t6221 = t255 / 0.4e1 + t6187 + t264 / 0.2e1 - t267 / 0.2e1 - t270 / 0.2e1 - t1761 * t253 * t119 / 0.2e1 + t1765 * t253 * t119 / 0.2e1 + t6199 + t6200 * t140 / 0.2e1 - t6200 * t147 / 0.2e1 - t6200 * t151 / 0.2e1 - t6207 * t74 * t64 / 0.2e1 - t6213 - t6214 * t140 / 0.2e1 + t6214 * t147 / 0.2e1 + t6214 * t151 / 0.2e1;
  t6236 = -t6152 + t6155 + 0.15e2 / 0.16e2 * t48 * t6138 * t1742 - 0.3e1 / 0.2e1 * t48 * t6138 * t1864 + 0.9e1 / 0.8e1 * t48 * t6138 * t1716 + 0.11e2 / 0.16e2 * t48 * t6138 * t1730 + 0.11e2 / 0.16e2 * t48 * t6116 * t1716 - 0.15e2 / 0.32e2 * t48 * t6116 * t1724 - 0.25e2 / 0.16e2 * t48 * t6138 * t1735 + 0.3e1 / 0.8e1 * t48 * t6138 * t1846 - t48 * t6138 * t1855 / 0.16e2 + t6185 - t48 * t6221 * t253 * t119 / 0.32e2 - 0.11e2 / 0.32e2 * t48 * t6116 * t1819 + 0.5e1 / 0.32e2 * t48 * t6120 * t420 + t1202 / 0.4e1 - t1216 / 0.8e1 - t1224 / 0.4e1 + t1236 / 0.4e1 - t262;
  t6238 = my_piecewise3(t3, 0, t6148 + t6236);
  tv4sigma40 = 0.2e1 * rho[0] * t6238;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t6240 = t83 * t1204;
  t6244 = t6240 * t1864;
  t6247 = t1963 * t1204;
  t6248 = t606 * t6247;
  t6266 = t4122 * t5829;
  t6273 = t15 * t18 * t6221;
  t6276 = t1270 * t1273;
  t6277 = t6276 / 0.16e2;
  t6278 = 0.11e2 / 0.16e2 * t177 * t6240 * t1730 - 0.3e1 / 0.2e1 * t177 * t6244 + 0.9e1 / 0.8e1 * t177 * t6248 + 0.11e2 / 0.16e2 * t162 * t6248 - 0.15e2 / 0.32e2 * t162 * t4137 * t2221 - 0.25e2 / 0.16e2 * t177 * t6240 * t1735 - 0.5e1 / 0.32e2 * t1270 * t1288 + 0.5e1 / 0.32e2 * t1270 * t1300 - t177 * t6240 * t1855 / 0.16e2 + 0.9e1 / 0.16e2 * t162 * t6266 - 0.9e1 / 0.16e2 * t162 * t4127 * t2337 - t6273 * t276 / 0.32e2 - t6277;
  t6279 = t2063 * t1204;
  t6293 = t2005 * t1204;
  t6297 = 0.3e1 / 0.16e2 * t6088;
  t6303 = 0.3e1 / 0.32e2 * t6090;
  t6304 = 0.9e1 / 0.32e2 * t6093;
  t6305 = 0.3e1 / 0.8e1 * t6096;
  t6306 = 0.9e1 / 0.16e2 * t6099;
  t6307 = 0.3e1 / 0.8e1 * t177 * t217 * t6279 + 0.3e1 / 0.8e1 * t177 * t6240 * t1846 - 0.11e2 / 0.16e2 * t177 * t6240 * t1840 + 0.11e2 / 0.16e2 * t177 * t6266 + 0.5e1 / 0.32e2 * t1270 * t1295 + 0.15e2 / 0.16e2 * t177 * t2228 * t6293 - t6297 - 0.11e2 / 0.32e2 * t162 * t4122 * t2313 - 0.7e1 / 0.32e2 * t162 * t6244 - t6303 + t6304 - t6305 - t6306;
  t6309 = 0.9e1 / 0.32e2 * t6101;
  t6310 = 0.9e1 / 0.32e2 * t6104;
  t6311 = 0.3e1 / 0.4e1 * t6107;
  t6312 = 0.9e1 / 0.16e2 * t6110;
  t6313 = 0.9e1 / 0.16e2 * t6113;
  t6314 = -t6309 + t6310 + t6311 - t6312 + t6313 - t6137 - t6152 + t6155 + t6185 + t1203 - t1217 - t1225 + t1237;
  t6317 = t177 * t1257 * t74 * t475;
  t6318 = 0.3e1 / 0.16e2 * t6317;
  t6320 = t177 * t919 * t4106;
  t6321 = 0.3e1 / 0.8e1 * t6320;
  t6323 = t162 * t905 * t4378;
  t6324 = 0.9e1 / 0.32e2 * t6323;
  t6326 = t177 * t4374 * t535;
  t6327 = 0.9e1 / 0.16e2 * t6326;
  t6328 = t858 * t4378;
  t6329 = t162 * t6328;
  t6330 = 0.9e1 / 0.32e2 * t6329;
  t6332 = t177 * t4362 * t504;
  t6333 = 0.3e1 / 0.4e1 * t6332;
  t6335 = t177 * t852 * t4106;
  t6336 = 0.9e1 / 0.16e2 * t6335;
  t6337 = t177 * t6328;
  t6338 = 0.9e1 / 0.16e2 * t6337;
  t6340 = t162 * t864 * t4378;
  t6341 = 0.9e1 / 0.32e2 * t6340;
  t6342 = -t1260 + t1264 + t1268 - t1275 - t6318 - t6321 + t6324 + t6327 - t6330 + t6333 - t6336 - t6338 + t6341 - t262;
  t6345 = my_piecewise3(t3, 0, t6278 + t6307 + t6314 + t6342);
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t6345;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t6352 = t91 * t1204;
  t6356 = t4122 * t2444;
  t6362 = t6352 * t1864;
  t6365 = t697 * t6247;
  t6383 = 0.5e1 / 0.32e2 * t1270 * t1332 + 0.15e2 / 0.16e2 * t177 * t2469 * t6293 + 0.11e2 / 0.16e2 * t177 * t6352 * t1730 + 0.9e1 / 0.16e2 * t162 * t6356 - 0.9e1 / 0.16e2 * t162 * t4127 * t2473 - 0.3e1 / 0.2e1 * t177 * t6362 + 0.9e1 / 0.8e1 * t177 * t6365 - 0.25e2 / 0.16e2 * t177 * t6352 * t1735 - 0.5e1 / 0.32e2 * t1270 * t1338 + 0.5e1 / 0.32e2 * t1270 * t1352 - t177 * t6352 * t1855 / 0.16e2 + 0.11e2 / 0.16e2 * t162 * t6365 - 0.15e2 / 0.32e2 * t162 * t4137 * t2462;
  t6388 = t1270 * t1321;
  t6389 = t6388 / 0.16e2;
  t6404 = -0.7e1 / 0.32e2 * t162 * t6362 - t6273 * t294 / 0.32e2 - t6389 + 0.11e2 / 0.16e2 * t177 * t6356 + 0.3e1 / 0.8e1 * t177 * t245 * t6279 + 0.3e1 / 0.8e1 * t177 * t6352 * t1846 - 0.11e2 / 0.32e2 * t162 * t4122 * t2515 - 0.11e2 / 0.16e2 * t177 * t6352 * t1840 - t6297 - t6303 + t6304 - t6305 - t6306;
  t6406 = -t6309 + t6310 + t6311 - t6312 + t6313 - t6137 - t6152 + t6155 + t6185 - t1327 + t1315 + t1318 - t1323;
  t6408 = t177 * t2414 * t4106;
  t6409 = 0.3e1 / 0.4e1 * t6408;
  t6411 = t177 * t940 * t4106;
  t6412 = 0.9e1 / 0.16e2 * t6411;
  t6413 = t4110 * t1413;
  t6414 = t162 * t6413;
  t6415 = 0.9e1 / 0.32e2 * t6414;
  t6417 = t177 * t957 * t2833;
  t6418 = 0.9e1 / 0.16e2 * t6417;
  t6421 = t177 * t1324 * t74 * t475;
  t6422 = 0.3e1 / 0.16e2 * t6421;
  t6424 = t162 * t864 * t4614;
  t6425 = 0.9e1 / 0.32e2 * t6424;
  t6427 = t177 * t950 * t4106;
  t6428 = 0.3e1 / 0.8e1 * t6427;
  t6430 = t162 * t905 * t4614;
  t6431 = 0.9e1 / 0.32e2 * t6430;
  t6432 = t177 * t6413;
  t6433 = 0.9e1 / 0.16e2 * t6432;
  t6434 = t1203 - t1217 - t1225 + t1237 + t6409 - t6412 - t6415 + t6418 - t6422 + t6425 - t6428 + t6431 - t6433 - t262;
  t6437 = my_piecewise3(t3, 0, t6383 + t6404 + t6406 + t6434);
  tv4sigma3tau0 = 0.2e1 * rho[0] * t6437;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t6443 = t310 * t253;
  t6459 = t2005 * t253;
  t6466 = t1963 * t253;
  t6467 = t1011 * t6466;
  t6473 = t1958 * t253;
  t6474 = t1007 * t6473;
  t6480 = t1007 * t1969 * t253;
  t6484 = t162 * t1011 * t2755;
  t6485 = 0.3e1 / 0.32e2 * t6484;
  t6486 = -0.5e1 / 0.32e2 * t1270 * t1362 + 0.5e1 / 0.32e2 * t1270 * t1388 - 0.11e2 / 0.16e2 * t177 * t6443 * t1840 + 0.3e1 / 0.8e1 * t177 * t6443 * t1846 - t177 * t6443 * t1855 / 0.16e2 - 0.11e2 / 0.32e2 * t162 * t771 * t3559 - 0.25e2 / 0.16e2 * t177 * t1011 * t2787 + 0.15e2 / 0.16e2 * t177 * t3518 * t6459 + 0.11e2 / 0.16e2 * t177 * t6443 * t1730 + 0.11e2 / 0.16e2 * t162 * t6467 - 0.15e2 / 0.32e2 * t162 * t3518 * t2787 - 0.3e1 / 0.2e1 * t177 * t6474 + 0.9e1 / 0.8e1 * t177 * t6467 + 0.9e1 / 0.16e2 * t162 * t6480 + t6485;
  t6488 = t177 * t1007 * t2755;
  t6489 = t6488 / 0.4e1;
  t6490 = t579 * t258;
  t6492 = t177 * t1011 * t6490;
  t6493 = 0.3e1 / 0.16e2 * t6492;
  t6496 = t177 * t310 * t258 * t475;
  t6497 = t6496 / 0.16e2;
  t6500 = t1007 * t2767;
  t6501 = t162 * t6500;
  t6502 = 0.3e1 / 0.32e2 * t6501;
  t6505 = t2063 * t253;
  t6510 = t162 * t1007 * t2833;
  t6511 = 0.3e1 / 0.32e2 * t6510;
  t6513 = t177 * t1027 * t2833;
  t6514 = 0.3e1 / 0.16e2 * t6513;
  t6517 = t177 * t6500;
  t6518 = 0.3e1 / 0.16e2 * t6517;
  t6522 = t528 * t258;
  t6524 = t177 * t1027 * t6522;
  t6525 = t6524 / 0.8e1;
  t6527 = t6088 / 0.16e2;
  t6528 = t6090 / 0.32e2;
  t6529 = t6489 - t6493 - t6497 - 0.7e1 / 0.32e2 * t162 * t6474 - t6502 + 0.11e2 / 0.16e2 * t177 * t6480 + 0.3e1 / 0.8e1 * t177 * t1027 * t6505 + t6511 + t6514 + 0.5e1 / 0.32e2 * t1270 * t1369 - t6518 - 0.9e1 / 0.16e2 * t162 * t776 * t3503 - t6525 - t6276 / 0.8e1 - t6527 - t6528;
  t6531 = 0.3e1 / 0.32e2 * t6093;
  t6532 = t6096 / 0.8e1;
  t6533 = 0.3e1 / 0.16e2 * t6099;
  t6534 = 0.3e1 / 0.32e2 * t6101;
  t6535 = 0.3e1 / 0.32e2 * t6104;
  t6536 = t6107 / 0.4e1;
  t6537 = 0.3e1 / 0.16e2 * t6110;
  t6538 = 0.3e1 / 0.16e2 * t6113;
  t6543 = t6531 - t6532 - t6533 - t6534 + t6535 + t6536 - t6537 + t6538 - t48 * t6221 * t310 * t119 / 0.32e2 - t6137 - t6152 + t6155 + t6185 + t1276 - t1277;
  t6552 = -t1278 + t1279 - t1375 + t1376 + t1377 - t1378 - t6317 / 0.4e1 - t6320 / 0.2e1 + 0.3e1 / 0.8e1 * t6323 + 0.3e1 / 0.4e1 * t6326 - 0.3e1 / 0.8e1 * t6329 + t6332 - 0.3e1 / 0.4e1 * t6335 - 0.3e1 / 0.4e1 * t6337 + 0.3e1 / 0.8e1 * t6340 - t262;
  t6555 = my_piecewise3(t3, 0, t6486 + t6529 + t6543 + t6552);
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t6555;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  t6559 = t1073 * t6473;
  t6562 = t940 * t4400;
  t6565 = -t6273 * t328 / 0.32e2 - t6389 - t6277 - t6527 - t6528 + t6531 - t6532 - t6533 - t6534 + t6535 + t6536 - t6537 + t6538 - t6137 - t6152 + t6155 + t6185 - 0.3e1 / 0.2e1 * t177 * t6559 + 0.9e1 / 0.8e1 * t177 * t6562;
  t6575 = t331 * t253;
  t6579 = t1420 * t4400;
  t6587 = -0.25e2 / 0.16e2 * t177 * t697 * t1722 * t4400 + 0.15e2 / 0.16e2 * t177 * t3194 * t4400 + 0.11e2 / 0.16e2 * t162 * t6562 + 0.11e2 / 0.16e2 * t177 * t6575 * t1730 + 0.11e2 / 0.16e2 * t177 * t6579 + 0.9e1 / 0.16e2 * t162 * t6579 - 0.9e1 / 0.16e2 * t162 * t1069 * t4676 - t1327 + t1315 + t1318 - t1323 + t1276 - t1277 - t1278 + t1279 - t1260 + t1264 + t1268 - t1275;
  t6601 = t177 * t331 * t258 * t475;
  t6614 = t177 * t1073 * t2755;
  t6617 = t177 * t940 * t4378;
  t6619 = t3198 * t83;
  t6623 = t1065 * t4614;
  t6624 = t162 * t6623;
  t6627 = t162 * t1069 * t4614;
  t6630 = t177 * t1088 * t2833;
  t6632 = t177 * t6623;
  t6635 = t177 * t950 * t4378;
  t6641 = t162 * t1084 * t4614;
  t6643 = -t177 * t6575 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t4631 * t2313 - 0.5e1 / 0.32e2 * t1270 * t1421 + 0.5e1 / 0.32e2 * t1270 * t1429 - t6601 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t6559 + 0.5e1 / 0.32e2 * t1270 * t1414 + 0.3e1 / 0.8e1 * t177 * t6575 * t1846 + 0.3e1 / 0.8e1 * t177 * t950 * t4400 + t6614 / 0.4e1 - 0.3e1 / 0.16e2 * t6617 - 0.15e2 / 0.32e2 * t162 * t4336 * t6619 - 0.3e1 / 0.32e2 * t6624 + 0.3e1 / 0.32e2 * t6627 + 0.3e1 / 0.16e2 * t6630 - 0.3e1 / 0.16e2 * t6632 - t6635 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t4624 * t6619 + 0.3e1 / 0.32e2 * t6641;
  t6644 = t6408 / 0.2e1;
  t6645 = 0.3e1 / 0.8e1 * t6411;
  t6646 = 0.3e1 / 0.16e2 * t6414;
  t6647 = 0.3e1 / 0.8e1 * t6417;
  t6648 = t6421 / 0.8e1;
  t6649 = 0.3e1 / 0.16e2 * t6424;
  t6650 = t6427 / 0.4e1;
  t6651 = 0.3e1 / 0.16e2 * t6430;
  t6652 = 0.3e1 / 0.8e1 * t6432;
  t6653 = t6317 / 0.8e1;
  t6654 = t6320 / 0.4e1;
  t6655 = 0.3e1 / 0.16e2 * t6323;
  t6656 = 0.3e1 / 0.8e1 * t6326;
  t6657 = 0.3e1 / 0.16e2 * t6329;
  t6658 = t6332 / 0.2e1;
  t6659 = 0.3e1 / 0.8e1 * t6335;
  t6660 = 0.3e1 / 0.8e1 * t6337;
  t6661 = 0.3e1 / 0.16e2 * t6340;
  t6662 = t6644 - t6645 - t6646 + t6647 - t6648 + t6649 - t6650 + t6651 - t6652 - t6653 - t6654 + t6655 + t6656 - t6657 + t6658 - t6659 - t6660 + t6661 - t262;
  t6665 = my_piecewise3(t3, 0, t6565 + t6587 + t6643 + t6662);
  tv4sigma2lapltau0 = 0.2e1 * rho[0] * t6665;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t6670 = t1147 * t6473;
  t6673 = t1182 * t6466;
  t6676 = t346 * t253;
  t6688 = t771 * t1969 * t346;
  t6691 = t1147 * t2767;
  t6692 = t177 * t6691;
  t6693 = 0.3e1 / 0.16e2 * t6692;
  t6694 = t1958 * t346;
  t6699 = t177 * t1143 * t6522;
  t6700 = t6699 / 0.8e1;
  t6705 = t162 * t1147 * t2833;
  t6706 = 0.3e1 / 0.32e2 * t6705;
  t6712 = 0.15e2 / 0.16e2 * t177 * t3973 * t6459 - 0.3e1 / 0.2e1 * t177 * t6670 + 0.9e1 / 0.8e1 * t177 * t6673 - t177 * t6676 * t1855 / 0.16e2 - 0.5e1 / 0.32e2 * t1270 * t1446 + 0.5e1 / 0.32e2 * t1270 * t1463 + 0.3e1 / 0.8e1 * t177 * t6676 * t1846 + 0.9e1 / 0.16e2 * t162 * t6688 - t6693 - 0.9e1 / 0.16e2 * t162 * t776 * t6694 - t6700 - 0.11e2 / 0.32e2 * t162 * t771 * t3960 + t6706 + 0.5e1 / 0.32e2 * t1270 * t1452 - 0.11e2 / 0.16e2 * t177 * t1143 * t2816;
  t6729 = t162 * t6691;
  t6730 = 0.3e1 / 0.32e2 * t6729;
  t6732 = t162 * t1182 * t2755;
  t6733 = 0.3e1 / 0.32e2 * t6732;
  t6735 = t177 * t1147 * t2755;
  t6736 = t6735 / 0.4e1;
  t6738 = t177 * t1182 * t6490;
  t6739 = 0.3e1 / 0.16e2 * t6738;
  t6742 = t177 * t346 * t258 * t475;
  t6743 = t6742 / 0.16e2;
  t6747 = t177 * t1143 * t2833;
  t6748 = 0.3e1 / 0.16e2 * t6747;
  t6750 = 0.11e2 / 0.16e2 * t177 * t6688 + 0.3e1 / 0.8e1 * t177 * t1143 * t6505 + 0.11e2 / 0.16e2 * t177 * t6676 * t1730 + 0.11e2 / 0.16e2 * t162 * t6673 - 0.15e2 / 0.32e2 * t162 * t3973 * t2787 - 0.25e2 / 0.16e2 * t177 * t1182 * t2787 - t6730 + t6733 + t6736 - t6739 - t6743 - 0.7e1 / 0.32e2 * t162 * t6670 + t6748 - t6388 / 0.8e1 - t6527 - t6528;
  t6756 = t6531 - t6532 - t6533 - t6534 + t6535 + t6536 - t6537 + t6538 - t48 * t6221 * t346 * t119 / 0.32e2 - t6137 - t6152 + t6155 + t6185 - t1458 + t1455;
  t6765 = t1456 - t1457 + t1276 - t1277 - t1278 + t1279 + t6408 - 0.3e1 / 0.4e1 * t6411 - 0.3e1 / 0.8e1 * t6414 + 0.3e1 / 0.4e1 * t6417 - t6421 / 0.4e1 + 0.3e1 / 0.8e1 * t6424 - t6427 / 0.2e1 + 0.3e1 / 0.8e1 * t6430 - 0.3e1 / 0.4e1 * t6432 - t262;
  t6768 = my_piecewise3(t3, 0, t6712 + t6750 + t6756 + t6765);
  tv4sigma2tau20 = 0.2e1 * rho[0] * t6768;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t6770 = t5401 * t1970;
  t6776 = t5401 * t2141;
  t6779 = t1963 * t74;
  t6780 = t5397 * t6779;
  t6794 = t2005 * t74;
  t6809 = 0.9e1 / 0.16e2 * t162 * t6770 - 0.9e1 / 0.16e2 * t162 * t5397 * t2141 - 0.3e1 / 0.2e1 * t177 * t6776 + 0.9e1 / 0.8e1 * t177 * t6780 + 0.11e2 / 0.16e2 * t177 * t5401 * t6779 + 0.11e2 / 0.16e2 * t162 * t6780 - 0.15e2 / 0.32e2 * t162 * t5407 * t2155 - 0.25e2 / 0.16e2 * t177 * t5397 * t2155 + 0.15e2 / 0.16e2 * t177 * t5407 * t6794 - t1525 * t1362 / 0.16e2 + t1525 * t1388 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t6770 - 0.7e1 / 0.32e2 * t162 * t6776 - 0.11e2 / 0.32e2 * t162 * t182 * t5438;
  t6810 = t1487 * t74;
  t6820 = t1525 * t1273;
  t6824 = t2063 * t74;
  t6828 = 0.9e1 / 0.32e2 * t6484;
  t6829 = 0.3e1 / 0.4e1 * t6488;
  t6830 = 0.9e1 / 0.16e2 * t6492;
  t6831 = 0.3e1 / 0.16e2 * t6496;
  t6832 = 0.9e1 / 0.32e2 * t6501;
  t6833 = 0.9e1 / 0.32e2 * t6510;
  t6834 = 0.9e1 / 0.16e2 * t6513;
  t6835 = 0.9e1 / 0.16e2 * t6517;
  t6836 = -0.11e2 / 0.16e2 * t177 * t6810 * t1840 + 0.3e1 / 0.8e1 * t177 * t6810 * t1846 - t177 * t6810 * t1855 / 0.16e2 - t6820 / 0.16e2 + t1525 * t1369 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t5434 * t6824 + t6828 + t6829 - t6830 - t6831 - t6832 + t6833 + t6834 - t6835;
  t6838 = 0.3e1 / 0.8e1 * t6524;
  t6840 = t1249 * t1487;
  t6848 = t110 * t74 * t113;
  t6860 = t1765 * t74;
  t6863 = t188 * t164;
  t6866 = t146 * t4274;
  t6869 = t62 * t4274;
  t6881 = t6848 * t200 / 0.4e1 + t6187 + t84 * t74 * t140 / 0.2e1 - t5520 * t283 / 0.2e1 - t5523 * t287 / 0.2e1 - t5526 * t4275 / 0.2e1 + t6860 * t5530 / 0.2e1 + t6199 + t1477 * t6863 / 0.2e1 - t1477 * t6866 / 0.2e1 - t1477 * t6869 / 0.2e1 - t6207 * t83 * t64 / 0.2e1 - t6213 - t1479 * t6863 / 0.2e1 + t1479 * t6866 / 0.2e1 + t1479 * t6869 / 0.2e1;
  t6889 = -t6838 - 0.3e1 / 0.32e2 * t6276 - 0.3e1 / 0.32e2 * t48 * t6840 * t377 + 0.3e1 / 0.32e2 * t48 * t6840 * t385 - t48 * t6881 * t310 * t119 / 0.32e2 + 0.3e1 / 0.32e2 * t48 * t6840 * t420 - t6137 - t6152 + t6155 + t6185 + t1379 - t1380 - t1381 + t1398;
  t6890 = -t1502 + t1503 + t1504 - t1505 - t6318 - t6321 + t6324 + t6327 - t6330 + t6333 - t6336 - t6338 + t6341 - t262;
  t6893 = my_piecewise3(t3, 0, t6809 + t6836 + t6889 + t6890);
  tv4sigmalapl30 = 0.2e1 * rho[0] * t6893;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  t6905 = t1525 * t1321;
  t6907 = t6820 / 0.32e2;
  t6917 = -0.3e1 / 0.32e2 * t1270 * t1543 + 0.3e1 / 0.32e2 * t1270 * t1548 + 0.3e1 / 0.32e2 * t1270 * t1536 - t15 * t18 * t6881 * t328 / 0.32e2 - t6905 / 0.32e2 - t6907 + t6485 + t6489 - t6493 - t6497 - t6502 + t6511 + t6514 - t6518 - t6525 - t6388 / 0.32e2 - t6277 - 0.25e2 / 0.16e2 * t177 * t5652 * t2155 + 0.15e2 / 0.16e2 * t177 * t3194 * t4822 - t1525 * t1421 / 0.16e2;
  t6930 = t1420 * t4822;
  t6938 = t5622 * t2141;
  t6941 = t940 * t4822;
  t6962 = t1525 * t1429 / 0.16e2 - t177 * t1528 * t74 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t957 * t3559 - t6137 - t6152 + t6155 + t6185 + 0.11e2 / 0.16e2 * t177 * t5622 * t6779 + 0.11e2 / 0.16e2 * t177 * t6930 + 0.9e1 / 0.16e2 * t162 * t6930 - 0.9e1 / 0.16e2 * t162 * t5631 * t3228 - 0.3e1 / 0.2e1 * t177 * t6938 + 0.9e1 / 0.8e1 * t177 * t6941 + 0.11e2 / 0.16e2 * t162 * t6941 - 0.15e2 / 0.32e2 * t162 * t4788 * t3228 + 0.3e1 / 0.8e1 * t177 * t5571 * t1970 - 0.7e1 / 0.32e2 * t162 * t6938 + 0.3e1 / 0.8e1 * t177 * t950 * t4822 - 0.11e2 / 0.32e2 * t162 * t905 * t5576 + t1525 * t1414 / 0.16e2;
  t6964 = t6601 / 0.8e1;
  t6965 = t6614 / 0.2e1;
  t6966 = 0.3e1 / 0.8e1 * t6617;
  t6967 = 0.3e1 / 0.16e2 * t6624;
  t6968 = 0.3e1 / 0.16e2 * t6627;
  t6969 = 0.3e1 / 0.8e1 * t6630;
  t6970 = 0.3e1 / 0.8e1 * t6632;
  t6971 = t6635 / 0.4e1;
  t6972 = -t1327 + t1315 + t1318 - t1323 + t1379 - t1380 - t1381 + t1398 - t1375 + t1376 + t1377 - t1378 - t6964 + t6965 - t6966 - t6967 + t6968 + t6969 - t6970 - t6971;
  t6973 = 0.3e1 / 0.16e2 * t6641;
  t6983 = t6973 + t6408 / 0.4e1 - 0.3e1 / 0.16e2 * t6411 - 0.3e1 / 0.32e2 * t6414 + 0.3e1 / 0.16e2 * t6417 - t6421 / 0.16e2 + 0.3e1 / 0.32e2 * t6424 - t6427 / 0.8e1 + 0.3e1 / 0.32e2 * t6430 - 0.3e1 / 0.16e2 * t6432 - t6653 - t6654 + t6655 + t6656 - t6657 + t6658 - t6659 - t6660 + t6661 - t262;
  t6986 = my_piecewise3(t3, 0, t6917 + t6962 + t6972 + t6983);
  tv4sigmalapl2tau0 = 0.2e1 * rho[0] * t6986;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  t7000 = t6905 / 0.16e2;
  t7006 = -t1525 * t1446 / 0.16e2 + t1525 * t1463 / 0.16e2 - 0.3e1 / 0.32e2 * t1270 * t1565 + 0.3e1 / 0.32e2 * t1270 * t1584 + t1525 * t1452 / 0.16e2 + 0.3e1 / 0.32e2 * t1270 * t1572 - t7000 - t6693 - t6700 + t6706 - t6730 + t6733 + t6736 - t6739 - t6743 + t6748 - t6389 - t6276 / 0.32e2 - t177 * t1578 * t74 * t1855 / 0.16e2;
  t7007 = t1459 * t36;
  t7017 = t5203 * t3003;
  t7029 = t5213 * t3003;
  t7034 = t5818 * t3003;
  t7054 = -0.11e2 / 0.16e2 * t177 * t7007 * t2313 + 0.3e1 / 0.8e1 * t177 * t7007 * t5829 + 0.11e2 / 0.16e2 * t177 * t5863 * t6779 + 0.11e2 / 0.16e2 * t162 * t7017 - 0.15e2 / 0.32e2 * t162 * t5191 * t3003 - 0.25e2 / 0.16e2 * t177 * t5195 * t3003 + 0.15e2 / 0.16e2 * t177 * t5199 * t3003 - 0.3e1 / 0.2e1 * t177 * t7029 + 0.9e1 / 0.8e1 * t177 * t7017 + 0.9e1 / 0.16e2 * t162 * t7034 - 0.7e1 / 0.32e2 * t162 * t7029 - 0.11e2 / 0.32e2 * t162 * t905 * t5843 + 0.11e2 / 0.16e2 * t177 * t7034 - 0.9e1 / 0.16e2 * t162 * t864 * t5843 + 0.3e1 / 0.8e1 * t177 * t5271 * t3003 - t48 * t6881 * t346 * t119 / 0.32e2 - t6137 - t6152 + t6155 + t6185;
  t7056 = -t1458 + t1455 + t1456 - t1457 + t1379 - t1380 - t1381 + t1398 - t1260 + t1264 + t1268 - t1275 - t6964 + t6965 - t6966 - t6967 + t6968 + t6969 - t6970 - t6971;
  t7066 = t6973 + t6644 - t6645 - t6646 + t6647 - t6648 + t6649 - t6650 + t6651 - t6652 - t6317 / 0.16e2 - t6320 / 0.8e1 + 0.3e1 / 0.32e2 * t6323 + 0.3e1 / 0.16e2 * t6326 - 0.3e1 / 0.32e2 * t6329 + t6332 / 0.4e1 - 0.3e1 / 0.16e2 * t6335 - 0.3e1 / 0.16e2 * t6337 + 0.3e1 / 0.32e2 * t6340 - t262;
  t7069 = my_piecewise3(t3, 0, t7006 + t7054 + t7056 + t7066);
  tv4sigmalapltau20 = 0.2e1 * rho[0] * t7069;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t7078 = t5900 * t6779;
  t7090 = t5908 * t2141;
  t7095 = t5908 * t1970;
  t7100 = t5919 * t1321;
  t7101 = t7100 / 0.16e2;
  t7106 = -t5919 * t1446 / 0.16e2 + t5919 * t1463 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t5908 * t6779 + 0.11e2 / 0.16e2 * t162 * t7078 - 0.15e2 / 0.32e2 * t162 * t5904 * t2155 - 0.25e2 / 0.16e2 * t177 * t5900 * t2155 + 0.15e2 / 0.16e2 * t177 * t5904 * t6794 - 0.3e1 / 0.2e1 * t177 * t7090 + 0.9e1 / 0.8e1 * t177 * t7078 + 0.9e1 / 0.16e2 * t162 * t7095 - 0.7e1 / 0.32e2 * t162 * t7090 - t7101 + t5919 * t1452 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t7095;
  t7116 = t1597 * t74;
  t7126 = 0.9e1 / 0.16e2 * t6692;
  t7127 = 0.3e1 / 0.8e1 * t6699;
  t7128 = 0.9e1 / 0.32e2 * t6705;
  t7129 = 0.9e1 / 0.32e2 * t6729;
  t7130 = 0.9e1 / 0.32e2 * t6732;
  t7131 = 0.3e1 / 0.4e1 * t6735;
  t7132 = 0.9e1 / 0.16e2 * t6738;
  t7133 = 0.3e1 / 0.16e2 * t6742;
  t7134 = -0.9e1 / 0.16e2 * t162 * t578 * t5960 + 0.3e1 / 0.8e1 * t177 * t5968 * t6824 - 0.11e2 / 0.32e2 * t162 * t182 * t5972 + 0.3e1 / 0.8e1 * t177 * t7116 * t1846 - t177 * t7116 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t7116 * t1840 - t7126 - t7127 + t7128 - t7129 + t7130 + t7131 - t7132 - t7133;
  t7136 = 0.9e1 / 0.16e2 * t6747;
  t7138 = t1249 * t1597;
  t7173 = t6848 * t227 / 0.4e1 + t6187 + t92 * t74 * t140 / 0.2e1 - t6041 * t283 / 0.2e1 - t6044 * t287 / 0.2e1 - t6047 * t4275 / 0.2e1 + t6860 * t6051 / 0.2e1 + t6199 + t1612 * t6863 / 0.2e1 - t1612 * t6866 / 0.2e1 - t1612 * t6869 / 0.2e1 - t6207 * t91 * t64 / 0.2e1 - t6213 - t1614 * t6863 / 0.2e1 + t1614 * t6866 / 0.2e1 + t1614 * t6869 / 0.2e1;
  t7181 = t7136 - 0.3e1 / 0.32e2 * t6388 + 0.3e1 / 0.32e2 * t48 * t7138 * t385 + 0.3e1 / 0.32e2 * t48 * t7138 * t420 - t48 * t7173 * t346 * t119 / 0.32e2 - 0.3e1 / 0.32e2 * t48 * t7138 * t377 - t6137 - t6152 + t6155 + t6185 - t1625 + t1622 + t1623 - t1624;
  t7182 = t1379 - t1380 - t1381 + t1398 + t6409 - t6412 - t6415 + t6418 - t6422 + t6425 - t6428 + t6431 - t6433 - t262;
  t7185 = my_piecewise3(t3, 0, t7106 + t7134 + t7181 + t7182);
  tv4sigmatau30 = 0.2e1 * rho[0] * t7185;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t7197 = t1482 * t1487;
  t7204 = t310 * t310;
  t7205 = t49 * t7204;
  t7215 = t110 * t7204;
  t7232 = t434 * t310;
  t7239 = t108 * t1482;
  t7243 = t437 * t310;
  t7250 = t312 / 0.4e1 + t6187 + t316 / 0.2e1 - t319 / 0.2e1 - t322 / 0.2e1 - t1761 * t310 * t119 / 0.2e1 + t1765 * t310 * t119 / 0.2e1 + t6199 + t7232 * t140 / 0.2e1 - t7232 * t147 / 0.2e1 - t7232 * t151 / 0.2e1 - t7239 * t83 * t64 / 0.2e1 - t6213 - t7243 * t140 / 0.2e1 + t7243 * t147 / 0.2e1 + t7243 * t151 / 0.2e1;
  t7258 = -0.5e1 / 0.32e2 * t6820 + 0.9e1 / 0.16e2 * t6484 + 0.3e1 / 0.2e1 * t6488 - 0.9e1 / 0.8e1 * t6492 - 0.3e1 / 0.8e1 * t6496 - 0.9e1 / 0.16e2 * t6501 + 0.9e1 / 0.16e2 * t6510 + 0.9e1 / 0.8e1 * t6513 - 0.9e1 / 0.8e1 * t6517 - 0.3e1 / 0.4e1 * t6524 - 0.5e1 / 0.32e2 * t48 * t7197 * t377 + 0.5e1 / 0.32e2 * t48 * t7197 * t385 + 0.11e2 / 0.16e2 * t48 * t7205 * t1746 + 0.5e1 / 0.32e2 * t48 * t7197 * t420 + 0.3e1 / 0.8e1 * t48 * t7205 * t1885 - 0.11e2 / 0.32e2 * t48 * t7215 * t1819 - 0.7e1 / 0.32e2 * t48 * t7215 * t1864 - t48 * t7250 * t310 * t119 / 0.32e2 + 0.3e1 / 0.8e1 * t48 * t7205 * t1846;
  t7296 = -t48 * t7205 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t48 * t7205 * t1840 - 0.25e2 / 0.16e2 * t48 * t7205 * t1735 + 0.15e2 / 0.16e2 * t48 * t7205 * t1742 + 0.9e1 / 0.16e2 * t48 * t7215 * t1746 - 0.9e1 / 0.16e2 * t48 * t7215 * t1750 - 0.3e1 / 0.2e1 * t48 * t7205 * t1864 + 0.9e1 / 0.8e1 * t48 * t7205 * t1716 + 0.11e2 / 0.16e2 * t48 * t7205 * t1730 + 0.11e2 / 0.16e2 * t48 * t7215 * t1716 - 0.15e2 / 0.32e2 * t48 * t7215 * t1724 - t6137 - t6152 + t6155 + t6185 - t1259 / 0.4e1 + t1263 / 0.4e1 + t1267 / 0.4e1 - t1274 / 0.8e1 - t262;
  t7298 = my_piecewise3(t3, 0, t7258 + t7296);
  tv4lapl40 = 0.2e1 * rho[0] * t7298;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  t7301 = t697 * t1963 * t1487;
  t7309 = t91 * t1487;
  t7323 = t5401 * t2473;
  t7340 = 0.9e1 / 0.8e1 * t177 * t7301 + 0.11e2 / 0.16e2 * t162 * t7301 - 0.15e2 / 0.32e2 * t162 * t5407 * t2462 - 0.25e2 / 0.16e2 * t177 * t7309 * t1735 + 0.15e2 / 0.16e2 * t177 * t2469 * t2005 * t1487 - t177 * t7309 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t7309 * t1840 - 0.7e1 / 0.32e2 * t162 * t7323 - 0.11e2 / 0.32e2 * t162 * t5401 * t2515 - t15 * t18 * t7250 * t328 / 0.32e2 - 0.5e1 / 0.32e2 * t1525 * t1543 + 0.5e1 / 0.32e2 * t1525 * t1548 + 0.11e2 / 0.16e2 * t177 * t7309 * t1730;
  t7342 = t241 * t1969 * t1487;
  t7362 = 0.11e2 / 0.16e2 * t177 * t7342 + 0.9e1 / 0.16e2 * t162 * t7342 - 0.9e1 / 0.16e2 * t162 * t5397 * t2473 - 0.3e1 / 0.2e1 * t177 * t7323 + 0.3e1 / 0.8e1 * t177 * t7309 * t1846 + 0.3e1 / 0.8e1 * t177 * t245 * t2063 * t1487 + 0.5e1 / 0.32e2 * t1525 * t1536 - t7000 - 0.3e1 / 0.32e2 * t6820 + t6828 + t6829 - t6830 - t6831;
  t7364 = -t6832 + t6833 + t6834 - t6835 - t6838 - t6137 - t6152 + t6155 + t6185 - t1327 + t1315 + t1318 - t1323;
  t7365 = 0.3e1 / 0.16e2 * t6601;
  t7366 = 0.3e1 / 0.4e1 * t6614;
  t7367 = 0.9e1 / 0.16e2 * t6617;
  t7368 = 0.9e1 / 0.32e2 * t6624;
  t7369 = 0.9e1 / 0.32e2 * t6627;
  t7370 = 0.9e1 / 0.16e2 * t6630;
  t7371 = 0.9e1 / 0.16e2 * t6632;
  t7372 = 0.3e1 / 0.8e1 * t6635;
  t7373 = 0.9e1 / 0.32e2 * t6641;
  t7374 = -t1502 + t1503 + t1504 - t1505 - t7365 + t7366 - t7367 - t7368 + t7369 + t7370 - t7371 - t7372 + t7373 - t262;
  t7377 = my_piecewise3(t3, 0, t7340 + t7362 + t7364 + t7374);
  tv4lapl3tau0 = 0.2e1 * rho[0] * t7377;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  t7391 = t346 * t310;
  t7395 = t1182 * t3478;
  t7404 = t1147 * t3503;
  t7410 = t1147 * t1969 * t310;
  t7423 = -0.9e1 / 0.16e2 * t162 * t1011 * t6694 - 0.11e2 / 0.32e2 * t162 * t1007 * t3960 + 0.5e1 / 0.32e2 * t1525 * t1572 + 0.15e2 / 0.16e2 * t177 * t3973 * t2005 * t310 + 0.11e2 / 0.16e2 * t177 * t7391 * t1730 + 0.11e2 / 0.16e2 * t162 * t7395 - 0.15e2 / 0.32e2 * t162 * t3973 * t3485 - 0.25e2 / 0.16e2 * t177 * t1182 * t3485 - 0.3e1 / 0.2e1 * t177 * t7404 + 0.9e1 / 0.8e1 * t177 * t7395 + 0.9e1 / 0.16e2 * t162 * t7410 - 0.5e1 / 0.32e2 * t1525 * t1565 + 0.5e1 / 0.32e2 * t1525 * t1584 - 0.11e2 / 0.16e2 * t177 * t7391 * t1840 + 0.3e1 / 0.8e1 * t177 * t7391 * t1846;
  t7436 = -t177 * t7391 * t1855 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t1143 * t2063 * t310 + 0.11e2 / 0.16e2 * t177 * t7410 - 0.7e1 / 0.32e2 * t162 * t7404 - t6905 / 0.8e1 - t6907 - t6693 - t6700 + t6706 - t6730 + t6733 + t6736 - t6739 - t6743 + t6748 + t6485;
  t7442 = t6489 - t6493 - t6497 - t6502 + t6511 + t6514 - t6518 - t6525 - t48 * t7250 * t346 * t119 / 0.32e2 - t6137 - t6152 + t6155 + t6185 - t1458 + t1455;
  t7451 = t1456 - t1457 - t1375 + t1376 + t1377 - t1378 - t6601 / 0.4e1 + t6614 - 0.3e1 / 0.4e1 * t6617 - 0.3e1 / 0.8e1 * t6624 + 0.3e1 / 0.8e1 * t6627 + 0.3e1 / 0.4e1 * t6630 - 0.3e1 / 0.4e1 * t6632 - t6635 / 0.2e1 + 0.3e1 / 0.8e1 * t6641 - t262;
  t7454 = my_piecewise3(t3, 0, t7423 + t7436 + t7442 + t7451);
  tv4lapl2tau20 = 0.2e1 * rho[0] * t7454;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  t7463 = t5900 * t2236;
  t7472 = t5908 * t2337;
  t7477 = t5908 * t5829;
  t7496 = 0.15e2 / 0.16e2 * t177 * t5904 * t2005 * t83 + 0.11e2 / 0.16e2 * t177 * t5908 * t2236 + 0.11e2 / 0.16e2 * t162 * t7463 - 0.15e2 / 0.32e2 * t162 * t5904 * t2221 - 0.25e2 / 0.16e2 * t177 * t5900 * t2221 - 0.3e1 / 0.2e1 * t177 * t7472 + 0.9e1 / 0.8e1 * t177 * t7463 + 0.9e1 / 0.16e2 * t162 * t7477 - t5919 * t1565 / 0.16e2 + t5919 * t1584 / 0.16e2 - 0.9e1 / 0.16e2 * t162 * t606 * t5960 + 0.3e1 / 0.8e1 * t177 * t5968 * t2063 * t83 - 0.11e2 / 0.32e2 * t162 * t213 * t5972 + 0.11e2 / 0.16e2 * t177 * t7477;
  t7501 = t1597 * t83;
  t7512 = -0.7e1 / 0.32e2 * t162 * t7472 + t5919 * t1572 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t7501 * t1840 + 0.3e1 / 0.8e1 * t177 * t7501 * t1846 - t177 * t7501 * t1855 / 0.16e2 - t7101 - 0.3e1 / 0.32e2 * t6905 - t7126 - t7127 + t7128 - t7129 + t7130 + t7131 - t7132;
  t7530 = t217 * t164;
  t7533 = t146 * t5529;
  t7536 = t62 * t5529;
  t7548 = t110 * t83 * t113 * t227 / 0.4e1 + t6187 + t92 * t83 * t140 / 0.2e1 - t6041 * t335 / 0.2e1 - t6044 * t339 / 0.2e1 - t6047 * t5530 / 0.2e1 + t1765 * t83 * t6051 / 0.2e1 + t6199 + t1612 * t7530 / 0.2e1 - t1612 * t7533 / 0.2e1 - t1612 * t7536 / 0.2e1 - t7239 * t91 * t64 / 0.2e1 - t6213 - t1614 * t7530 / 0.2e1 + t1614 * t7533 / 0.2e1 + t1614 * t7536 / 0.2e1;
  t7553 = t1482 * t1597;
  t7563 = -t7133 + t7136 - t48 * t7548 * t346 * t119 / 0.32e2 - 0.3e1 / 0.32e2 * t48 * t7553 * t377 + 0.3e1 / 0.32e2 * t48 * t7553 * t385 + 0.3e1 / 0.32e2 * t48 * t7553 * t420 - t6137 - t6152 + t6155 + t6185 - t1625 + t1622 + t1623 - t1624;
  t7564 = -t1260 + t1264 + t1268 - t1275 - t7365 + t7366 - t7367 - t7368 + t7369 + t7370 - t7371 - t7372 + t7373 - t262;
  t7567 = my_piecewise3(t3, 0, t7496 + t7512 + t7563 + t7564);
  tv4lapltau30 = 0.2e1 * rho[0] * t7567;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t7579 = t346 * t346;
  t7580 = t110 * t7579;
  t7590 = t49 * t7579;
  t7609 = -0.5e1 / 0.32e2 * t7100 - 0.9e1 / 0.8e1 * t6692 - 0.3e1 / 0.4e1 * t6699 + 0.9e1 / 0.16e2 * t6705 - 0.9e1 / 0.16e2 * t6729 + 0.9e1 / 0.16e2 * t6732 + 0.3e1 / 0.2e1 * t6735 - 0.9e1 / 0.8e1 * t6738 - 0.3e1 / 0.8e1 * t6742 + 0.9e1 / 0.8e1 * t6747 - 0.7e1 / 0.32e2 * t48 * t7580 * t1864 - 0.9e1 / 0.16e2 * t48 * t7580 * t1750 - 0.11e2 / 0.32e2 * t48 * t7580 * t1819 - t48 * t7590 * t1855 / 0.16e2 - 0.11e2 / 0.16e2 * t48 * t7590 * t1840 + 0.3e1 / 0.8e1 * t48 * t7590 * t1846 + 0.3e1 / 0.8e1 * t48 * t7590 * t1885 + 0.11e2 / 0.16e2 * t48 * t7590 * t1746 - 0.15e2 / 0.32e2 * t48 * t7580 * t1724;
  t7625 = t1617 * t1597;
  t7651 = t434 * t346;
  t7662 = t437 * t346;
  t7669 = t348 / 0.4e1 + t6187 + t352 / 0.2e1 - t355 / 0.2e1 - t358 / 0.2e1 - t1761 * t346 * t119 / 0.2e1 + t1765 * t346 * t119 / 0.2e1 + t6199 + t7651 * t140 / 0.2e1 - t7651 * t147 / 0.2e1 - t7651 * t151 / 0.2e1 - t108 * t1617 * t91 * t64 / 0.2e1 - t6213 - t7662 * t140 / 0.2e1 + t7662 * t147 / 0.2e1 + t7662 * t151 / 0.2e1;
  t7678 = -0.25e2 / 0.16e2 * t48 * t7590 * t1735 + 0.15e2 / 0.16e2 * t48 * t7590 * t1742 - 0.3e1 / 0.2e1 * t48 * t7590 * t1864 + 0.9e1 / 0.8e1 * t48 * t7590 * t1716 + 0.9e1 / 0.16e2 * t48 * t7580 * t1746 - 0.5e1 / 0.32e2 * t48 * t7625 * t377 + 0.5e1 / 0.32e2 * t48 * t7625 * t385 + 0.11e2 / 0.16e2 * t48 * t7590 * t1730 + 0.11e2 / 0.16e2 * t48 * t7580 * t1716 + 0.5e1 / 0.32e2 * t48 * t7625 * t420 - t48 * t7669 * t346 * t119 / 0.32e2 - t6137 - t6152 + t6155 + t6185 - t1326 / 0.4e1 + t1314 / 0.4e1 + t1317 / 0.4e1 - t1322 / 0.8e1 - t262;
  t7680 = my_piecewise3(t3, 0, t7609 + t7678);
  tv4tau40 = 0.2e1 * rho[0] * t7680;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;

  double t227, t228, t231, t232, t233, t236, t240, t241;
  double t244, t246, t251, t252, t254, t255, t256, t258;
  double t260, t261, t263, t264, t265, t266, t267, t268;
  double t269, t270, t278, t283, t285, t288, t289, t290;
  double t291, t294, t295, t296, t297, t298, t301, t302;
  double t306, t307, t308, t311, t314, t318, t319, t322;
  double t324, t326, t328, tv2rho20, t331, t335, t339, t340;
  double t343, t345, t351, t352, t356, t360, t361, t364;
  double t367, t370, t371, t374, tv2rho21, t379, t384, t388;
  double t389, t394, t395, t400, t404, t405, t409, t413;
  double t415, t416, t418, t419, t420, t421, t422, t423;
  double t424, t425, t433, t438, t440, t443, t444, t445;
  double t446, t449, t450, t451, t452, t453, t456, t457;
  double t461, tv2rho22, t467, t468, t469, t470, t471, t472;
  double t473, t476, t478, t480, t483, t484, t485, t486;
  double t489, t490, t491, t492, t495, t496, t497, t498;
  double t502, tv2rhosigma0, tv2rhosigma1, t507, t509, tv2rhosigma2, t514, tv2rhosigma3;
  double tv2rhosigma4, t518, t519, t520, t521, t522, t523, t526;
  double t528, t530, t533, t534, t535, t536, t539, t540;
  double t541, t542, t545, t546, t547, t548, t552, tv2rhosigma5;
  double t557, t558, t559, t563, t565, t568, t569, t572;
  double t573, t576, t577, t581, tv2rholapl0, t586, t588, tv2rholapl1;
  double t593, tv2rholapl2, t597, t598, t602, t604, t607, t608;
  double t611, t612, t615, t616, t620, tv2rholapl3, t625, t626;
  double t627, t631, t633, t636, t637, t640, t641, t644;
  double t645, t649, tv2rhotau0, t654, t656, tv2rhotau1, t661, tv2rhotau2;
  double t665, t666, t670, t672, t675, t676, t679, t680;
  double t683, t684, t688, tv2rhotau3, t690, t692, t695, t697;
  double t699, t700, t701, t704, t707, t711, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t712, t714, t717, t719, t721;
  double t722, t723, t726, t729, t733, tv2sigma25, t734, t737;
  double t738, t741, t742, t745, t746, t750, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t751, t754, t755, t758, t759;
  double t762, t763, t767, tv2sigmalapl5, t768, t771, t772, t775;
  double t778, t782, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t783;
  double t786, t787, t790, t793, t797, tv2sigmatau5, t798, t800;
  double t803, t804, t807, t810, t814, tv2lapl20, tv2lapl21, t815;
  double t817, t820, t821, t824, t827, t831, tv2lapl22, t832;
  double t835, t836, t839, t840, t843, t844, t848, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t849, t852, t853, t856, t857, t860;
  double t861, t865, tv2lapltau3, t866, t868, t871, t872, t875;
  double t878, t882, tv2tau20, tv2tau21, t883, t885, t888, t889;
  double t892, t895, t899, tv2tau22;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t227 = 0.1e1 / t20;
  t228 = t87 * t87;
  t231 = t83 * t3;
  t232 = 0.1e1 / t231;
  t233 = t13 * t232;
  t236 = my_piecewise5(t7, 0, t11, 0, -0.2e1 * t84 + 0.2e1 * t233);
  t240 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t228 + 0.3e1 / 0.2e1 * t20 * t236);
  t241 = M_PI * t240;
  t244 = t91 * t96;
  t246 = t91 * t26;
  t251 = t24 / t25 / t3;
  t252 = t251 * t46;
  t254 = t23 * t252 / 0.32e2;
  t255 = t23 * t95;
  t256 = t255 * t117;
  t258 = 0.1e1 / t45;
  t260 = -t258 * t100 + t46;
  t261 = t111 * t111;
  t263 = t43 * t43;
  t264 = t44 * t44;
  t265 = 0.1e1 / t264;
  t266 = t263 * t265;
  t267 = t40 * t40;
  t268 = 0.1e1 / t267;
  t269 = t266 * t268;
  t270 = t260 * t261 * t269;
  t278 = 0.1e1 / t105 / rho[0];
  t283 = my_piecewise3(t39, (0.3e1 / 0.2e1 * lapl[0] * t106 - 0.6e1 * tau[0] * t106 + 0.3e1 / 0.2e1 * sigma[0] * t278) * t37, 0);
  t285 = t100 * t283 * t116;
  t288 = t100 * t261;
  t289 = t43 * t265;
  t290 = t289 * t268;
  t291 = t288 * t290;
  t294 = t264 * t44;
  t295 = 0.1e1 / t294;
  t296 = t263 * t295;
  t297 = t296 * t268;
  t298 = t288 * t297;
  t301 = t114 * t268;
  t302 = t288 * t301;
  t306 = my_piecewise3(t2, 0, -t241 * t47 / 0.8e1 - t244 / 0.8e1 - t246 * t117 / 0.8e1 + t254 - t256 / 0.16e2 - t99 * t270 / 0.32e2 - t99 * t285 / 0.16e2 - t99 * t291 / 0.16e2 + t99 * t298 / 0.16e2 + t99 * t302 / 0.16e2);
  t307 = 0.1e1 / t57;
  t308 = t124 * t124;
  t311 = t52 * t232;
  t314 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t84 + 0.2e1 * t311);
  t318 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t308 + 0.3e1 / 0.2e1 * t57 * t314);
  t319 = M_PI * t318;
  t322 = t128 * t131;
  t324 = t251 * t78;
  t326 = t60 * t324 / 0.32e2;
  t328 = my_piecewise3(t51, 0, -t319 * t79 / 0.8e1 - t322 / 0.8e1 + t326);
  tv2rho20 = 0.2e1 * t121 + 0.2e1 * t135 + t3 * (t306 + t328);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t331 = t227 * t139;
  t335 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t233);
  t339 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t331 * t87 + 0.3e1 / 0.2e1 * t20 * t335);
  t340 = M_PI * t339;
  t343 = t143 * t96;
  t345 = t143 * t26;
  t351 = my_piecewise3(t2, 0, -t340 * t47 / 0.8e1 - t343 / 0.16e2 - t345 * t117 / 0.16e2 - t244 / 0.16e2 + t254 - t256 / 0.32e2);
  t352 = t307 * t149;
  t356 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t311);
  t360 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t352 * t124 + 0.3e1 / 0.2e1 * t57 * t356);
  t361 = M_PI * t360;
  t364 = t153 * t131;
  t367 = t128 * t26;
  t370 = t60 * t95;
  t371 = t370 * t174;
  t374 = my_piecewise3(t51, 0, -t361 * t79 / 0.8e1 - t364 / 0.16e2 - t322 / 0.16e2 + t326 - t367 * t174 / 0.16e2 - t371 / 0.32e2);
  tv2rho21 = t121 + t135 + t147 + t178 + t3 * (t351 + t374);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t379 = t139 * t139;
  t384 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t84 + 0.2e1 * t233);
  t388 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t379 + 0.3e1 / 0.2e1 * t20 * t384);
  t389 = M_PI * t388;
  t394 = my_piecewise3(t2, 0, -t389 * t47 / 0.8e1 - t343 / 0.8e1 + t254);
  t395 = t149 * t149;
  t400 = my_piecewise5(t11, 0, t7, 0, -0.2e1 * t84 + 0.2e1 * t311);
  t404 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t395 + 0.3e1 / 0.2e1 * t57 * t400);
  t405 = M_PI * t404;
  t409 = t153 * t26;
  t413 = 0.1e1 / t77;
  t415 = -t413 * t157 + t78;
  t416 = t168 * t168;
  t418 = t75 * t75;
  t419 = t76 * t76;
  t420 = 0.1e1 / t419;
  t421 = t418 * t420;
  t422 = t73 * t73;
  t423 = 0.1e1 / t422;
  t424 = t421 * t423;
  t425 = t415 * t416 * t424;
  t433 = 0.1e1 / t162 / rho[1];
  t438 = my_piecewise3(t72, (0.3e1 / 0.2e1 * lapl[1] * t163 - 0.6e1 * tau[1] * t163 + 0.3e1 / 0.2e1 * sigma[2] * t433) * t37, 0);
  t440 = t157 * t438 * t173;
  t443 = t157 * t416;
  t444 = t75 * t420;
  t445 = t444 * t423;
  t446 = t443 * t445;
  t449 = t419 * t76;
  t450 = 0.1e1 / t449;
  t451 = t418 * t450;
  t452 = t451 * t423;
  t453 = t443 * t452;
  t456 = t171 * t423;
  t457 = t443 * t456;
  t461 = my_piecewise3(t51, 0, -t405 * t79 / 0.8e1 - t364 / 0.8e1 - t409 * t174 / 0.8e1 + t326 - t371 / 0.16e2 - t156 * t425 / 0.32e2 - t156 * t440 / 0.16e2 - t156 * t446 / 0.16e2 + t156 * t453 / 0.16e2 + t156 * t457 / 0.16e2);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t178 + t3 * (t394 + t461);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t467 = t255 * t185 / 0.32e2;
  t468 = t26 * t260;
  t469 = t23 * t468;
  t470 = t111 * t263;
  t471 = t265 * t268;
  t472 = t471 * t183;
  t473 = t470 * t472;
  t476 = t106 * t37;
  t478 = my_piecewise3(t39, -0.3e1 / 0.8e1 * t476, 0);
  t480 = t100 * t478 * t116;
  t483 = t26 * t100;
  t484 = t23 * t483;
  t485 = t183 * t111;
  t486 = t485 * t290;
  t489 = t183 * t263;
  t490 = t295 * t268;
  t491 = t490 * t111;
  t492 = t489 * t491;
  t495 = t183 * t43;
  t496 = t113 * t268;
  t497 = t496 * t111;
  t498 = t495 * t497;
  t502 = my_piecewise3(t2, 0, -t246 * t185 / 0.16e2 - t467 - t469 * t473 / 0.32e2 - t99 * t480 / 0.16e2 - t484 * t486 / 0.16e2 + t484 * t492 / 0.16e2 + t484 * t498 / 0.16e2);
  tv2rhosigma0 = t3 * t502 + t188;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t507 = t370 * t193 / 0.32e2;
  t509 = my_piecewise3(t51, 0, -t367 * t193 / 0.16e2 - t507);
  tv2rhosigma2 = t3 * t509 + t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t514 = my_piecewise3(t2, 0, -t345 * t185 / 0.16e2 - t467);
  tv2rhosigma3 = t3 * t514 + t188;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t518 = t26 * t415;
  t519 = t60 * t518;
  t520 = t168 * t418;
  t521 = t420 * t423;
  t522 = t521 * t191;
  t523 = t520 * t522;
  t526 = t163 * t37;
  t528 = my_piecewise3(t72, -0.3e1 / 0.8e1 * t526, 0);
  t530 = t157 * t528 * t173;
  t533 = t26 * t157;
  t534 = t60 * t533;
  t535 = t191 * t168;
  t536 = t535 * t445;
  t539 = t191 * t418;
  t540 = t450 * t423;
  t541 = t540 * t168;
  t542 = t539 * t541;
  t545 = t191 * t75;
  t546 = t170 * t423;
  t547 = t546 * t168;
  t548 = t545 * t547;
  t552 = my_piecewise3(t51, 0, -t409 * t193 / 0.16e2 - t507 - t519 * t523 / 0.32e2 - t156 * t530 / 0.16e2 - t534 * t536 / 0.16e2 + t534 * t542 / 0.16e2 + t534 * t548 / 0.16e2);
  tv2rhosigma5 = t3 * t552 + t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t557 = t255 * t201 / 0.32e2;
  t558 = t471 * t199;
  t559 = t470 * t558;
  t563 = my_piecewise3(t39, -t181 / 0.2e1, 0);
  t565 = t100 * t563 * t116;
  t568 = t199 * t111;
  t569 = t568 * t290;
  t572 = t199 * t263;
  t573 = t572 * t491;
  t576 = t199 * t43;
  t577 = t576 * t497;
  t581 = my_piecewise3(t2, 0, -t246 * t201 / 0.16e2 - t557 - t469 * t559 / 0.32e2 - t99 * t565 / 0.16e2 - t484 * t569 / 0.16e2 + t484 * t573 / 0.16e2 + t484 * t577 / 0.16e2);
  tv2rholapl0 = t3 * t581 + t204;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t586 = t370 * t209 / 0.32e2;
  t588 = my_piecewise3(t51, 0, -t367 * t209 / 0.16e2 - t586);
  tv2rholapl1 = t3 * t588 + t212;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t593 = my_piecewise3(t2, 0, -t345 * t201 / 0.16e2 - t557);
  tv2rholapl2 = t3 * t593 + t204;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t597 = t521 * t207;
  t598 = t520 * t597;
  t602 = my_piecewise3(t72, -t189 / 0.2e1, 0);
  t604 = t157 * t602 * t173;
  t607 = t207 * t168;
  t608 = t607 * t445;
  t611 = t207 * t418;
  t612 = t611 * t541;
  t615 = t207 * t75;
  t616 = t615 * t547;
  t620 = my_piecewise3(t51, 0, -t409 * t209 / 0.16e2 - t586 - t519 * t598 / 0.32e2 - t156 * t604 / 0.16e2 - t534 * t608 / 0.16e2 + t534 * t612 / 0.16e2 + t534 * t616 / 0.16e2);
  tv2rholapl3 = t3 * t620 + t212;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t625 = t255 * t215 / 0.32e2;
  t626 = t471 * t213;
  t627 = t470 * t626;
  t631 = my_piecewise3(t39, 0.2e1 * t181, 0);
  t633 = t100 * t631 * t116;
  t636 = t213 * t111;
  t637 = t636 * t290;
  t640 = t213 * t263;
  t641 = t640 * t491;
  t644 = t213 * t43;
  t645 = t644 * t497;
  t649 = my_piecewise3(t2, 0, -t246 * t215 / 0.16e2 - t625 - t469 * t627 / 0.32e2 - t99 * t633 / 0.16e2 - t484 * t637 / 0.16e2 + t484 * t641 / 0.16e2 + t484 * t645 / 0.16e2);
  tv2rhotau0 = t3 * t649 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t654 = t370 * t221 / 0.32e2;
  t656 = my_piecewise3(t51, 0, -t367 * t221 / 0.16e2 - t654);
  tv2rhotau1 = t3 * t656 + t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t661 = my_piecewise3(t2, 0, -t345 * t215 / 0.16e2 - t625);
  tv2rhotau2 = t3 * t661 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t665 = t521 * t219;
  t666 = t520 * t665;
  t670 = my_piecewise3(t72, 0.2e1 * t189, 0);
  t672 = t157 * t670 * t173;
  t675 = t219 * t168;
  t676 = t675 * t445;
  t679 = t219 * t418;
  t680 = t679 * t541;
  t683 = t219 * t75;
  t684 = t683 * t547;
  t688 = my_piecewise3(t51, 0, -t409 * t221 / 0.16e2 - t654 - t519 * t666 / 0.32e2 - t156 * t672 / 0.16e2 - t534 * t676 / 0.16e2 + t534 * t680 / 0.16e2 + t534 * t684 / 0.16e2);
  tv2rhotau3 = t3 * t688 + t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t690 = t183 * t183;
  t692 = t260 * t690 * t269;
  t695 = my_piecewise3(t39, 0, 0);
  t697 = t100 * t695 * t116;
  t699 = t99 * t697 / 0.16e2;
  t700 = t100 * t690;
  t701 = t700 * t290;
  t704 = t700 * t297;
  t707 = t700 * t301;
  t711 = my_piecewise3(t2, 0, -t99 * t692 / 0.32e2 - t699 - t99 * t701 / 0.16e2 + t99 * t704 / 0.16e2 + t99 * t707 / 0.16e2);
  tv2sigma20 = t3 * t711;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t712 = t191 * t191;
  t714 = t415 * t712 * t424;
  t717 = my_piecewise3(t72, 0, 0);
  t719 = t157 * t717 * t173;
  t721 = t156 * t719 / 0.16e2;
  t722 = t157 * t712;
  t723 = t722 * t445;
  t726 = t722 * t452;
  t729 = t722 * t456;
  t733 = my_piecewise3(t51, 0, -t156 * t714 / 0.32e2 - t721 - t156 * t723 / 0.16e2 + t156 * t726 / 0.16e2 + t156 * t729 / 0.16e2);
  tv2sigma25 = t3 * t733;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t734 = t489 * t558;
  t737 = t199 * t183;
  t738 = t737 * t290;
  t741 = t490 * t183;
  t742 = t572 * t741;
  t745 = t496 * t183;
  t746 = t576 * t745;
  t750 = my_piecewise3(t2, 0, -t469 * t734 / 0.32e2 - t699 - t484 * t738 / 0.16e2 + t484 * t742 / 0.16e2 + t484 * t746 / 0.16e2);
  tv2sigmalapl0 = t3 * t750;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t751 = t539 * t597;
  t754 = t207 * t191;
  t755 = t754 * t445;
  t758 = t540 * t191;
  t759 = t611 * t758;
  t762 = t546 * t191;
  t763 = t615 * t762;
  t767 = my_piecewise3(t51, 0, -t519 * t751 / 0.32e2 - t721 - t534 * t755 / 0.16e2 + t534 * t759 / 0.16e2 + t534 * t763 / 0.16e2);
  tv2sigmalapl5 = t3 * t767;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t768 = t489 * t626;
  t771 = t213 * t183;
  t772 = t771 * t290;
  t775 = t640 * t741;
  t778 = t644 * t745;
  t782 = my_piecewise3(t2, 0, -t469 * t768 / 0.32e2 - t699 - t484 * t772 / 0.16e2 + t484 * t775 / 0.16e2 + t484 * t778 / 0.16e2);
  tv2sigmatau0 = t3 * t782;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t783 = t539 * t665;
  t786 = t219 * t191;
  t787 = t786 * t445;
  t790 = t679 * t758;
  t793 = t683 * t762;
  t797 = my_piecewise3(t51, 0, -t519 * t783 / 0.32e2 - t721 - t534 * t787 / 0.16e2 + t534 * t790 / 0.16e2 + t534 * t793 / 0.16e2);
  tv2sigmatau5 = t3 * t797;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t798 = t199 * t199;
  t800 = t260 * t798 * t269;
  t803 = t100 * t798;
  t804 = t803 * t290;
  t807 = t803 * t297;
  t810 = t803 * t301;
  t814 = my_piecewise3(t2, 0, -t99 * t800 / 0.32e2 - t699 - t99 * t804 / 0.16e2 + t99 * t807 / 0.16e2 + t99 * t810 / 0.16e2);
  tv2lapl20 = t3 * t814;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t815 = t207 * t207;
  t817 = t415 * t815 * t424;
  t820 = t157 * t815;
  t821 = t820 * t445;
  t824 = t820 * t452;
  t827 = t820 * t456;
  t831 = my_piecewise3(t51, 0, -t156 * t817 / 0.32e2 - t721 - t156 * t821 / 0.16e2 + t156 * t824 / 0.16e2 + t156 * t827 / 0.16e2);
  tv2lapl22 = t3 * t831;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t832 = t572 * t626;
  t835 = t213 * t199;
  t836 = t835 * t290;
  t839 = t490 * t199;
  t840 = t640 * t839;
  t843 = t496 * t199;
  t844 = t644 * t843;
  t848 = my_piecewise3(t2, 0, -t469 * t832 / 0.32e2 - t699 - t484 * t836 / 0.16e2 + t484 * t840 / 0.16e2 + t484 * t844 / 0.16e2);
  tv2lapltau0 = t3 * t848;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t849 = t611 * t665;
  t852 = t219 * t207;
  t853 = t852 * t445;
  t856 = t540 * t207;
  t857 = t679 * t856;
  t860 = t546 * t207;
  t861 = t683 * t860;
  t865 = my_piecewise3(t51, 0, -t519 * t849 / 0.32e2 - t721 - t534 * t853 / 0.16e2 + t534 * t857 / 0.16e2 + t534 * t861 / 0.16e2);
  tv2lapltau3 = t3 * t865;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t866 = t213 * t213;
  t868 = t260 * t866 * t269;
  t871 = t100 * t866;
  t872 = t871 * t290;
  t875 = t871 * t297;
  t878 = t871 * t301;
  t882 = my_piecewise3(t2, 0, -t99 * t868 / 0.32e2 - t699 - t99 * t872 / 0.16e2 + t99 * t875 / 0.16e2 + t99 * t878 / 0.16e2);
  tv2tau20 = t3 * t882;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t883 = t219 * t219;
  t885 = t415 * t883 * t424;
  t888 = t157 * t883;
  t889 = t888 * t445;
  t892 = t888 * t452;
  t895 = t888 * t456;
  t899 = my_piecewise3(t51, 0, -t156 * t885 / 0.32e2 - t721 - t156 * t889 / 0.16e2 + t156 * t892 / 0.16e2 + t156 * t895 / 0.16e2);
  tv2tau22 = t3 * t899;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;

  double t227, t228, t231, t232, t233, t236, t240, t241;
  double t244, t246, t251, t252, t254, t255, t256, t258;
  double t260, t261, t263, t264, t265, t266, t267, t268;
  double t269, t270, t278, t283, t285, t288, t289, t290;
  double t291, t294, t295, t296, t297, t298, t301, t302;
  double t306, t307, t308, t311, t314, t318, t319, t322;
  double t324, t326, t328, tv2rho20, t331, t335, t339, t340;
  double t343, t345, t351, t352, t356, t360, t361, t364;
  double t367, t370, t371, t374, tv2rho21, t379, t384, t388;
  double t389, t394, t395, t400, t404, t405, t409, t413;
  double t415, t416, t418, t419, t420, t421, t422, t423;
  double t424, t425, t433, t438, t440, t443, t444, t445;
  double t446, t449, t450, t451, t452, t453, t456, t457;
  double t461, tv2rho22, t467, t468, t469, t470, t471, t472;
  double t473, t476, t478, t480, t483, t484, t485, t486;
  double t489, t490, t491, t492, t495, t496, t497, t498;
  double t502, tv2rhosigma0, tv2rhosigma1, t507, t509, tv2rhosigma2, t514, tv2rhosigma3;
  double tv2rhosigma4, t518, t519, t520, t521, t522, t523, t526;
  double t528, t530, t533, t534, t535, t536, t539, t540;
  double t541, t542, t545, t546, t547, t548, t552, tv2rhosigma5;
  double t557, t558, t559, t563, t565, t568, t569, t572;
  double t573, t576, t577, t581, tv2rholapl0, t586, t588, tv2rholapl1;
  double t593, tv2rholapl2, t597, t598, t602, t604, t607, t608;
  double t611, t612, t615, t616, t620, tv2rholapl3, t625, t626;
  double t627, t631, t633, t636, t637, t640, t641, t644;
  double t645, t649, tv2rhotau0, t654, t656, tv2rhotau1, t661, tv2rhotau2;
  double t665, t666, t670, t672, t675, t676, t679, t680;
  double t683, t684, t688, tv2rhotau3, t690, t692, t695, t697;
  double t699, t700, t701, t704, t707, t711, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t712, t714, t717, t719, t721;
  double t722, t723, t726, t729, t733, tv2sigma25, t734, t737;
  double t738, t741, t742, t745, t746, t750, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t751, t754, t755, t758, t759;
  double t762, t763, t767, tv2sigmalapl5, t768, t771, t772, t775;
  double t778, t782, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t783;
  double t786, t787, t790, t793, t797, tv2sigmatau5, t798, t800;
  double t803, t804, t807, t810, t814, tv2lapl20, tv2lapl21, t815;
  double t817, t820, t821, t824, t827, t831, tv2lapl22, t832;
  double t835, t836, t839, t840, t843, t844, t848, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t849, t852, t853, t856, t857, t860;
  double t861, t865, tv2lapltau3, t866, t868, t871, t872, t875;
  double t878, t882, tv2tau20, tv2tau21, t883, t885, t888, t889;
  double t892, t895, t899, tv2tau22;

  double t902, t903, t906, t909, t910, t911, t914, t918;
  double t919, t924, t925, t927, t928, t930, t932, t933;
  double t934, t935, t936, t938, t939, t940, t943, t945;
  double t946, t947, t948, t953, t955, t956, t957, t960;
  double t961, t964, t965, t968, t969, t972, t977, t981;
  double t984, t985, t987, t989, t991, t992, t993, t996;
  double t1000, t1002, t1010, t1015, t1017, t1020, t1023, t1024;
  double t1028, t1030, t1031, t1032, t1035, t1036, t1037, t1041;
  double t1045, t1048, t1049, t1053, t1056, t1058, t1059, t1060;
  double t1063, t1066, t1069, t1073, t1074, t1077, t1079, t1081;
  double t1083, t1085, tv3rho30, t1088, t1089, t1093, t1096, t1101;
  double t1102, t1104, t1108, t1109, t1113, t1114, t1124, t1127;
  double t1129, t1138, t1139, t1140, t1143, t1148, t1150, t1154;
  double t1155, t1159, t1160, t1164, t1167, t1169, t1170, t1171;
  double t1174, tv3rho31, t1177, t1182, t1186, t1190, t1191, t1194;
  double t1196, t1203, t1204, t1209, t1213, t1217, t1218, t1221;
  double t1224, t1227, t1228, t1234, t1238, t1242, t1246, t1250;
  double t1252, t1253, tv3rho32, t1258, t1265, t1269, t1270, t1276;
  double t1279, t1286, t1290, t1291, t1298, t1302, t1306, t1309;
  double t1310, t1313, t1320, t1321, t1322, t1325, t1329, t1331;
  double t1339, t1344, t1346, t1349, t1356, t1357, t1358, t1360;
  double t1361, t1362, t1365, t1366, t1367, t1370, t1371, t1372;
  double t1373, t1374, t1375, t1378, t1379, t1380, t1384, t1385;
  double t1386, t1387, t1392, t1393, t1396, t1399, t1400, t1405;
  double t1406, t1409, t1411, tv3rho33, t1415, t1418, t1419, t1420;
  double t1422, t1425, t1430, t1432, t1434, t1436, t1440, t1445;
  double t1447, t1448, t1451, t1452, t1455, t1458, t1459, t1460;
  double t1463, t1464, t1465, t1468, t1469, t1470, t1471, t1472;
  double t1475, t1476, t1479, t1480, t1483, t1484, t1487, t1488;
  double t1493, t1496, t1498, t1499, t1500, t1502, t1503, t1506;
  double t1509, t1510, t1515, t1516, t1517, t1518, t1521, t1524;
  double t1525, t1526, t1527, t1530, t1532, tv3rho2sigma0, tv3rho2sigma1, t1537;
  double t1540, t1542, tv3rho2sigma2, t1546, t1548, t1553, t1566, t1567;
  double tv3rho2sigma3, tv3rho2sigma4, t1571, t1574, t1577, t1578, t1579, t1583;
  double t1585, t1588, t1589, t1590, t1594, t1598, t1600, t1601;
  double tv3rho2sigma5, t1608, tv3rho2sigma6, tv3rho2sigma7, t1611, t1613, t1615, t1622;
  double t1623, t1624, t1625, t1628, t1629, t1630, t1631, t1634;
  double t1635, t1638, t1639, t1640, t1641, t1650, t1651, t1654;
  double t1655, t1658, t1659, t1662, t1663, t1666, t1667, t1670;
  double t1671, t1674, t1675, t1678, t1681, t1685, t1692, t1693;
  double t1696, t1701, t1702, t1703, t1706, t1707, t1708, t1711;
  double t1714, t1716, tv3rho2sigma8, t1720, t1721, t1723, t1726, t1728;
  double t1735, t1736, t1739, t1740, t1743, t1744, t1747, t1750;
  double t1751, t1754, t1755, t1760, t1763, t1768, t1769, t1771;
  double t1772, t1775, t1776, t1779, t1784, t1787, t1788, t1791;
  double t1794, t1795, t1798, t1801, t1808, t1810, t1814, t1816;
  double tv3rho2lapl0, t1821, t1824, t1826, tv3rho2lapl1, t1830, t1848, t1849;
  double tv3rho2lapl2, t1853, t1858, t1862, t1866, t1870, t1874, t1876;
  double t1877, tv3rho2lapl3, t1884, tv3rho2lapl4, t1892, t1894, t1901, t1902;
  double t1907, t1908, t1911, t1912, t1915, t1916, t1919, t1922;
  double t1929, t1930, t1933, t1934, t1937, t1938, t1947, t1948;
  double t1951, t1954, t1955, t1958, t1961, t1964, t1965, t1970;
  double t1971, t1974, t1976, tv3rho2lapl5, t1979, t1980, t1983, t1986;
  double t1989, t1992, t1993, t1998, t1999, t2002, t2005, t2006;
  double t2009, t2010, t2013, t2014, t2017, t2018, t2021, t2028;
  double t2030, t2031, t2035, t2040, t2043, t2048, t2050, t2051;
  double t2054, t2057, t2062, t2065, t2067, t2070, t2073, t2075;
  double tv3rho2tau0, t2080, t2083, t2085, tv3rho2tau1, t2089, t2107, t2108;
  double tv3rho2tau2, t2112, t2117, t2121, t2125, t2129, t2133, t2135;
  double t2136, tv3rho2tau3, t2143, tv3rho2tau4, t2146, t2147, t2150, t2151;
  double t2155, t2158, t2159, t2162, t2165, t2166, t2169, t2178;
  double t2181, t2182, t2188, t2193, t2194, t2197, t2198, t2203;
  double t2209, t2212, t2213, t2216, t2217, t2228, t2230, t2233;
  double t2235, tv3rho2tau5, t2237, t2238, t2239, t2240, t2241, t2242;
  double t2243, t2246, t2247, t2248, t2251, t2252, t2253, t2254;
  double t2255, t2258, t2259, t2262, t2263, t2264, t2267, t2270;
  double t2271, t2274, t2275, t2276, t2277, t2278, t2279, t2280;
  double t2281, t2283, t2286, t2289, t2290, t2293, t2294, t2299;
  double t2300, t2308, t2310, t2312, t2313, t2314, t2316, t2320;
  double t2323, t2324, t2327, t2329, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23;
  double tv3rhosigma24, t2334, t2336, t2337, t2338, t2342, t2346, t2350;
  double t2352, tv3rhosigma25, t2357, t2365, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2367, t2368, t2369, t2370, t2371, t2372, t2373;
  double t2376, t2377, t2378, t2381, t2382, t2385, t2386, t2389;
  double t2390, t2391, t2394, t2397, t2398, t2401, t2402, t2403;
  double t2404, t2405, t2406, t2407, t2408, t2409, t2412, t2415;
  double t2416, t2419, t2420, t2421, t2422, t2423, t2425, t2430;
  double t2436, t2439, t2440, t2447, t2449, tv3rhosigma211, t2451, t2452;
  double t2455, t2456, t2457, t2458, t2461, t2462, t2465, t2466;
  double t2467, t2468, t2471, t2472, t2475, t2476, t2481, t2482;
  double t2485, t2486, t2490, t2493, t2500, t2503, t2504, t2508;
  double t2510, t2512, t2513, t2518, t2519, t2522, t2523, t2528;
  double t2531, t2534, t2536, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4;
  double t2541, t2545, t2549, t2553, t2555, tv3rhosigmalapl5, t2566, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2568, t2569, t2570, t2571;
  double t2574, t2575, t2578, t2579, t2582, t2583, t2584, t2585;
  double t2588, t2589, t2594, t2595, t2598, t2599, t2602, t2603;
  double t2610, t2613, t2616, t2619, t2622, t2625, t2626, t2629;
  double t2630, t2635, t2638, t2643, t2645, tv3rhosigmalapl11, t2647, t2648;
  double t2651, t2652, t2655, t2656, t2659, t2660, t2663, t2664;
  double t2665, t2668, t2669, t2674, t2677, t2678, t2681, t2686;
  double t2689, t2696, t2697, t2700, t2704, t2706, t2708, t2710;
  double t2713, t2714, t2717, t2718, t2723, t2726, t2728, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t2733, t2737, t2741, t2745;
  double t2747, tv3rhosigmatau5, t2758, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double t2760, t2761, t2762, t2765, t2766, t2769, t2772, t2775;
  double t2776, t2779, t2780, t2783, t2784, t2789, t2790, t2793;
  double t2794, t2799, t2802, t2807, t2810, t2811, t2818, t2821;
  double t2826, t2827, t2830, t2832, tv3rhosigmatau11, t2834, t2837, t2838;
  double t2841, t2842, t2845, t2846, t2849, t2850, t2853, t2856;
  double t2859, t2860, t2865, t2866, t2869, t2872, t2875, t2878;
  double t2880, t2882, t2884, t2888, t2898, t2899, t2901, tv3rholapl20;
  double tv3rholapl21, t2906, t2910, t2914, t2918, t2920, tv3rholapl22, t2931;
  double tv3rholapl23, tv3rholapl24, t2933, t2934, t2937, t2938, t2941, t2942;
  double t2945, t2948, t2951, t2954, t2955, t2958, t2959, t2964;
  double t2965, t2968, t2971, t2974, t2977, t2979, t2990, t2992;
  double tv3rholapl25, t2994, t2995, t2998, t2999, t3002, t3006, t3009;
  double t3012, t3013, t3018, t3021, t3022, t3025, t3030, t3033;
  double t3040, t3041, t3044, t3050, t3052, t3054, t3056, t3057;
  double t3058, t3061, t3062, t3067, t3070, t3072, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, t3077, t3081, t3085, t3089, t3091, tv3rholapltau3, t3102;
  double tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, t3105, t3108, t3109, t3112, t3113;
  double t3116, t3117, t3120, t3123, t3124, t3129, t3132, t3133;
  double t3136, t3137, t3140, t3141, t3146, t3149, t3154, t3155;
  double t3158, t3165, t3168, t3173, t3175, tv3rholapltau7, t3177, t3178;
  double t3181, t3182, t3185, t3186, t3189, t3192, t3196, t3199;
  double t3200, t3203, t3206, t3209, t3212, t3216, t3221, t3223;
  double t3225, t3227, t3229, t3235, t3242, t3244, tv3rhotau20, tv3rhotau21;
  double t3249, t3253, t3257, t3261, t3263, tv3rhotau22, t3274, tv3rhotau23;
  double tv3rhotau24, t3276, t3277, t3281, t3284, t3285, t3289, t3292;
  double t3293, t3296, t3299, t3302, t3303, t3308, t3311, t3314;
  double t3317, t3320, t3324, t3333, t3335, tv3rhotau25, t3337, t3338;
  double t3339, t3342, t3345, t3346, t3347, t3348, t3349, t3352;
  double t3353, t3354, t3355, t3358, t3360, t3363, t3365, t3368;
  double t3369, t3370, t3371, t3372, t3375, t3378, t3381, t3382;
  double t3383, t3384, t3387, t3390, t3391, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t3392, t3393;
  double t3394, t3397, t3400, t3401, t3402, t3403, t3404, t3407;
  double t3408, t3409, t3410, t3413, t3415, t3418, t3420, t3423;
  double t3424, t3425, t3426, t3427, t3430, t3433, t3436, t3437;
  double t3438, t3439, t3442, t3445, t3446, tv3sigma39, t3447, t3448;
  double t3449, t3450, t3451, t3452, t3453, t3454, t3455, t3456;
  double t3457, t3458, t3459, t3460, t3461, t3462, t3463, t3466;
  double t3467, t3468, t3469, t3472, t3473, t3476, t3477, t3480;
  double t3483, t3484, t3487, t3490, t3493, t3496, t3497, t3500;
  double t3501, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6;
  double tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3502, t3503, t3504, t3505;
  double t3506, t3507, t3508, t3509, t3510, t3511, t3512, t3513;
  double t3514, t3515, t3518, t3519, t3520, t3521, t3522, t3523;
  double t3526, t3527, t3530, t3531, t3534, t3535, t3538, t3539;
  double t3542, t3545, t3548, t3551, t3552, t3555, t3556, tv3sigma2lapl11;
  double t3557, t3558, t3559, t3560, t3561, t3562, t3565, t3566;
  double t3567, t3568, t3569, t3570, t3571, t3572, t3575, t3576;
  double t3579, t3582, t3585, t3590, t3593, t3596, t3599, t3600;
  double tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7;
  double tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t3601, t3602, t3603, t3606, t3607;
  double t3608, t3609, t3610, t3611, t3612, t3613, t3614, t3615;
  double t3616, t3619, t3620, t3623, t3626, t3629, t3634, t3637;
  double t3640, t3643, t3644, tv3sigma2tau11, t3645, t3648, t3649, t3652;
  double t3653, t3656, t3659, t3660, t3661, t3662, t3663, t3664;
  double t3666, t3669, t3670, t3673, t3676, t3679, t3682, t3683;
  double t3686, t3687, t3688, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24;
  double tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t3689, t3692, t3695, t3696, t3699;
  double t3702, t3703, t3704, t3705, t3706, t3707, t3709, t3712;
  double t3713, t3716, t3717, t3720, t3721, t3726, t3729, t3730;
  double t3731, tv3sigmalapl28, t3734, t3735, t3738, t3739, t3742, t3745;
  double t3746, t3749, t3750, t3753, t3756, t3759, t3764, t3766;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, t3769, t3770, t3771, t3774, t3775;
  double t3778, t3781, t3782, t3785, t3786, t3791, t3794, t3797;
  double t3800, t3802, tv3sigmalapltau11, t3803, t3806, t3809, t3812, t3815;
  double t3816, t3817, t3818, t3820, t3823, t3824, t3829, t3832;
  double t3835, t3838, t3839, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24;
  double tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t3840, t3843, t3846, t3849, t3852;
  double t3853, t3854, t3855, t3857, t3860, t3861, t3866, t3869;
  double t3872, t3875, t3876, tv3sigmatau28, t3877, t3879, t3882, t3884;
  double t3887, t3888, t3889, t3892, t3895, t3896, t3899, t3902;
  double t3903, t3904, t3905, t3906, t3909, t3912, t3915, t3918;
  double t3921, t3922, tv3lapl30, tv3lapl31, tv3lapl32, t3923, t3925, t3928;
  double t3930, t3933, t3934, t3935, t3938, t3941, t3942, t3945;
  double t3948, t3949, t3950, t3951, t3952, t3955, t3958, t3961;
  double t3964, t3967, t3968, tv3lapl33, t3969, t3970, t3973, t3974;
  double t3977, t3978, t3981, t3982, t3985, t3988, t3993, t3996;
  double t3999, t4000, t4003, t4004, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3;
  double tv3lapl2tau4, t4005, t4006, t4009, t4010, t4014, t4017, t4018;
  double t4021, t4024, t4029, t4032, t4035, t4036, t4039, t4040;
  double tv3lapl2tau5, t4042, t4045, t4048, t4052, t4055, t4058, t4059;
  double t4064, t4067, t4071, t4074, t4075, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, t4077, t4081, t4084, t4088, t4091, t4094;
  double t4095, t4100, t4103, t4107, t4110, t4111, tv3lapltau25, t4112;
  double t4114, t4117, t4119, t4122, t4123, t4124, t4127, t4130;
  double t4133, t4134, t4137, t4138, t4139, t4140, t4141, t4144;
  double t4147, t4150, t4153, t4156, t4157, tv3tau30, tv3tau31, tv3tau32;
  double t4158, t4160, t4163, t4165, t4168, t4169, t4170, t4173;
  double t4176, t4177, t4180, t4183, t4184, t4185, t4186, t4187;
  double t4190, t4193, t4196, t4199, t4202, t4203, tv3tau33;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t227 = 0.1e1 / t20;
  t228 = t87 * t87;
  t231 = t83 * t3;
  t232 = 0.1e1 / t231;
  t233 = t13 * t232;
  t236 = my_piecewise5(t7, 0, t11, 0, -0.2e1 * t84 + 0.2e1 * t233);
  t240 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t228 + 0.3e1 / 0.2e1 * t20 * t236);
  t241 = M_PI * t240;
  t244 = t91 * t96;
  t246 = t91 * t26;
  t251 = t24 / t25 / t3;
  t252 = t251 * t46;
  t254 = t23 * t252 / 0.32e2;
  t255 = t23 * t95;
  t256 = t255 * t117;
  t258 = 0.1e1 / t45;
  t260 = -t258 * t100 + t46;
  t261 = t111 * t111;
  t263 = t43 * t43;
  t264 = t44 * t44;
  t265 = 0.1e1 / t264;
  t266 = t263 * t265;
  t267 = t40 * t40;
  t268 = 0.1e1 / t267;
  t269 = t266 * t268;
  t270 = t260 * t261 * t269;
  t278 = 0.1e1 / t105 / rho[0];
  t283 = my_piecewise3(t39, (0.3e1 / 0.2e1 * lapl[0] * t106 - 0.6e1 * tau[0] * t106 + 0.3e1 / 0.2e1 * sigma[0] * t278) * t37, 0);
  t285 = t100 * t283 * t116;
  t288 = t100 * t261;
  t289 = t43 * t265;
  t290 = t289 * t268;
  t291 = t288 * t290;
  t294 = t264 * t44;
  t295 = 0.1e1 / t294;
  t296 = t263 * t295;
  t297 = t296 * t268;
  t298 = t288 * t297;
  t301 = t114 * t268;
  t302 = t288 * t301;
  t306 = my_piecewise3(t2, 0, -t241 * t47 / 0.8e1 - t244 / 0.8e1 - t246 * t117 / 0.8e1 + t254 - t256 / 0.16e2 - t99 * t270 / 0.32e2 - t99 * t285 / 0.16e2 - t99 * t291 / 0.16e2 + t99 * t298 / 0.16e2 + t99 * t302 / 0.16e2);
  t307 = 0.1e1 / t57;
  t308 = t124 * t124;
  t311 = t52 * t232;
  t314 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t84 + 0.2e1 * t311);
  t318 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t308 + 0.3e1 / 0.2e1 * t57 * t314);
  t319 = M_PI * t318;
  t322 = t128 * t131;
  t324 = t251 * t78;
  t326 = t60 * t324 / 0.32e2;
  t328 = my_piecewise3(t51, 0, -t319 * t79 / 0.8e1 - t322 / 0.8e1 + t326);
  tv2rho20 = 0.2e1 * t121 + 0.2e1 * t135 + t3 * (t306 + t328);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t331 = t227 * t139;
  t335 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t233);
  t339 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t331 * t87 + 0.3e1 / 0.2e1 * t20 * t335);
  t340 = M_PI * t339;
  t343 = t143 * t96;
  t345 = t143 * t26;
  t351 = my_piecewise3(t2, 0, -t340 * t47 / 0.8e1 - t343 / 0.16e2 - t345 * t117 / 0.16e2 - t244 / 0.16e2 + t254 - t256 / 0.32e2);
  t352 = t307 * t149;
  t356 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t311);
  t360 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t352 * t124 + 0.3e1 / 0.2e1 * t57 * t356);
  t361 = M_PI * t360;
  t364 = t153 * t131;
  t367 = t128 * t26;
  t370 = t60 * t95;
  t371 = t370 * t174;
  t374 = my_piecewise3(t51, 0, -t361 * t79 / 0.8e1 - t364 / 0.16e2 - t322 / 0.16e2 + t326 - t367 * t174 / 0.16e2 - t371 / 0.32e2);
  tv2rho21 = t121 + t135 + t147 + t178 + t3 * (t351 + t374);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t379 = t139 * t139;
  t384 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t84 + 0.2e1 * t233);
  t388 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t379 + 0.3e1 / 0.2e1 * t20 * t384);
  t389 = M_PI * t388;
  t394 = my_piecewise3(t2, 0, -t389 * t47 / 0.8e1 - t343 / 0.8e1 + t254);
  t395 = t149 * t149;
  t400 = my_piecewise5(t11, 0, t7, 0, -0.2e1 * t84 + 0.2e1 * t311);
  t404 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t395 + 0.3e1 / 0.2e1 * t57 * t400);
  t405 = M_PI * t404;
  t409 = t153 * t26;
  t413 = 0.1e1 / t77;
  t415 = -t413 * t157 + t78;
  t416 = t168 * t168;
  t418 = t75 * t75;
  t419 = t76 * t76;
  t420 = 0.1e1 / t419;
  t421 = t418 * t420;
  t422 = t73 * t73;
  t423 = 0.1e1 / t422;
  t424 = t421 * t423;
  t425 = t415 * t416 * t424;
  t433 = 0.1e1 / t162 / rho[1];
  t438 = my_piecewise3(t72, (0.3e1 / 0.2e1 * lapl[1] * t163 - 0.6e1 * tau[1] * t163 + 0.3e1 / 0.2e1 * sigma[2] * t433) * t37, 0);
  t440 = t157 * t438 * t173;
  t443 = t157 * t416;
  t444 = t75 * t420;
  t445 = t444 * t423;
  t446 = t443 * t445;
  t449 = t419 * t76;
  t450 = 0.1e1 / t449;
  t451 = t418 * t450;
  t452 = t451 * t423;
  t453 = t443 * t452;
  t456 = t171 * t423;
  t457 = t443 * t456;
  t461 = my_piecewise3(t51, 0, -t405 * t79 / 0.8e1 - t364 / 0.8e1 - t409 * t174 / 0.8e1 + t326 - t371 / 0.16e2 - t156 * t425 / 0.32e2 - t156 * t440 / 0.16e2 - t156 * t446 / 0.16e2 + t156 * t453 / 0.16e2 + t156 * t457 / 0.16e2);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t178 + t3 * (t394 + t461);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t467 = t255 * t185 / 0.32e2;
  t468 = t26 * t260;
  t469 = t23 * t468;
  t470 = t111 * t263;
  t471 = t265 * t268;
  t472 = t471 * t183;
  t473 = t470 * t472;
  t476 = t106 * t37;
  t478 = my_piecewise3(t39, -0.3e1 / 0.8e1 * t476, 0);
  t480 = t100 * t478 * t116;
  t483 = t26 * t100;
  t484 = t23 * t483;
  t485 = t183 * t111;
  t486 = t485 * t290;
  t489 = t183 * t263;
  t490 = t295 * t268;
  t491 = t490 * t111;
  t492 = t489 * t491;
  t495 = t183 * t43;
  t496 = t113 * t268;
  t497 = t496 * t111;
  t498 = t495 * t497;
  t502 = my_piecewise3(t2, 0, -t246 * t185 / 0.16e2 - t467 - t469 * t473 / 0.32e2 - t99 * t480 / 0.16e2 - t484 * t486 / 0.16e2 + t484 * t492 / 0.16e2 + t484 * t498 / 0.16e2);
  tv2rhosigma0 = t3 * t502 + t188;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t507 = t370 * t193 / 0.32e2;
  t509 = my_piecewise3(t51, 0, -t367 * t193 / 0.16e2 - t507);
  tv2rhosigma2 = t3 * t509 + t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t514 = my_piecewise3(t2, 0, -t345 * t185 / 0.16e2 - t467);
  tv2rhosigma3 = t3 * t514 + t188;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t518 = t26 * t415;
  t519 = t60 * t518;
  t520 = t168 * t418;
  t521 = t420 * t423;
  t522 = t521 * t191;
  t523 = t520 * t522;
  t526 = t163 * t37;
  t528 = my_piecewise3(t72, -0.3e1 / 0.8e1 * t526, 0);
  t530 = t157 * t528 * t173;
  t533 = t26 * t157;
  t534 = t60 * t533;
  t535 = t191 * t168;
  t536 = t535 * t445;
  t539 = t191 * t418;
  t540 = t450 * t423;
  t541 = t540 * t168;
  t542 = t539 * t541;
  t545 = t191 * t75;
  t546 = t170 * t423;
  t547 = t546 * t168;
  t548 = t545 * t547;
  t552 = my_piecewise3(t51, 0, -t409 * t193 / 0.16e2 - t507 - t519 * t523 / 0.32e2 - t156 * t530 / 0.16e2 - t534 * t536 / 0.16e2 + t534 * t542 / 0.16e2 + t534 * t548 / 0.16e2);
  tv2rhosigma5 = t3 * t552 + t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t557 = t255 * t201 / 0.32e2;
  t558 = t471 * t199;
  t559 = t470 * t558;
  t563 = my_piecewise3(t39, -t181 / 0.2e1, 0);
  t565 = t100 * t563 * t116;
  t568 = t199 * t111;
  t569 = t568 * t290;
  t572 = t199 * t263;
  t573 = t572 * t491;
  t576 = t199 * t43;
  t577 = t576 * t497;
  t581 = my_piecewise3(t2, 0, -t246 * t201 / 0.16e2 - t557 - t469 * t559 / 0.32e2 - t99 * t565 / 0.16e2 - t484 * t569 / 0.16e2 + t484 * t573 / 0.16e2 + t484 * t577 / 0.16e2);
  tv2rholapl0 = t3 * t581 + t204;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t586 = t370 * t209 / 0.32e2;
  t588 = my_piecewise3(t51, 0, -t367 * t209 / 0.16e2 - t586);
  tv2rholapl1 = t3 * t588 + t212;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t593 = my_piecewise3(t2, 0, -t345 * t201 / 0.16e2 - t557);
  tv2rholapl2 = t3 * t593 + t204;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t597 = t521 * t207;
  t598 = t520 * t597;
  t602 = my_piecewise3(t72, -t189 / 0.2e1, 0);
  t604 = t157 * t602 * t173;
  t607 = t207 * t168;
  t608 = t607 * t445;
  t611 = t207 * t418;
  t612 = t611 * t541;
  t615 = t207 * t75;
  t616 = t615 * t547;
  t620 = my_piecewise3(t51, 0, -t409 * t209 / 0.16e2 - t586 - t519 * t598 / 0.32e2 - t156 * t604 / 0.16e2 - t534 * t608 / 0.16e2 + t534 * t612 / 0.16e2 + t534 * t616 / 0.16e2);
  tv2rholapl3 = t3 * t620 + t212;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t625 = t255 * t215 / 0.32e2;
  t626 = t471 * t213;
  t627 = t470 * t626;
  t631 = my_piecewise3(t39, 0.2e1 * t181, 0);
  t633 = t100 * t631 * t116;
  t636 = t213 * t111;
  t637 = t636 * t290;
  t640 = t213 * t263;
  t641 = t640 * t491;
  t644 = t213 * t43;
  t645 = t644 * t497;
  t649 = my_piecewise3(t2, 0, -t246 * t215 / 0.16e2 - t625 - t469 * t627 / 0.32e2 - t99 * t633 / 0.16e2 - t484 * t637 / 0.16e2 + t484 * t641 / 0.16e2 + t484 * t645 / 0.16e2);
  tv2rhotau0 = t3 * t649 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t654 = t370 * t221 / 0.32e2;
  t656 = my_piecewise3(t51, 0, -t367 * t221 / 0.16e2 - t654);
  tv2rhotau1 = t3 * t656 + t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t661 = my_piecewise3(t2, 0, -t345 * t215 / 0.16e2 - t625);
  tv2rhotau2 = t3 * t661 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t665 = t521 * t219;
  t666 = t520 * t665;
  t670 = my_piecewise3(t72, 0.2e1 * t189, 0);
  t672 = t157 * t670 * t173;
  t675 = t219 * t168;
  t676 = t675 * t445;
  t679 = t219 * t418;
  t680 = t679 * t541;
  t683 = t219 * t75;
  t684 = t683 * t547;
  t688 = my_piecewise3(t51, 0, -t409 * t221 / 0.16e2 - t654 - t519 * t666 / 0.32e2 - t156 * t672 / 0.16e2 - t534 * t676 / 0.16e2 + t534 * t680 / 0.16e2 + t534 * t684 / 0.16e2);
  tv2rhotau3 = t3 * t688 + t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t690 = t183 * t183;
  t692 = t260 * t690 * t269;
  t695 = my_piecewise3(t39, 0, 0);
  t697 = t100 * t695 * t116;
  t699 = t99 * t697 / 0.16e2;
  t700 = t100 * t690;
  t701 = t700 * t290;
  t704 = t700 * t297;
  t707 = t700 * t301;
  t711 = my_piecewise3(t2, 0, -t99 * t692 / 0.32e2 - t699 - t99 * t701 / 0.16e2 + t99 * t704 / 0.16e2 + t99 * t707 / 0.16e2);
  tv2sigma20 = t3 * t711;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t712 = t191 * t191;
  t714 = t415 * t712 * t424;
  t717 = my_piecewise3(t72, 0, 0);
  t719 = t157 * t717 * t173;
  t721 = t156 * t719 / 0.16e2;
  t722 = t157 * t712;
  t723 = t722 * t445;
  t726 = t722 * t452;
  t729 = t722 * t456;
  t733 = my_piecewise3(t51, 0, -t156 * t714 / 0.32e2 - t721 - t156 * t723 / 0.16e2 + t156 * t726 / 0.16e2 + t156 * t729 / 0.16e2);
  tv2sigma25 = t3 * t733;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t734 = t489 * t558;
  t737 = t199 * t183;
  t738 = t737 * t290;
  t741 = t490 * t183;
  t742 = t572 * t741;
  t745 = t496 * t183;
  t746 = t576 * t745;
  t750 = my_piecewise3(t2, 0, -t469 * t734 / 0.32e2 - t699 - t484 * t738 / 0.16e2 + t484 * t742 / 0.16e2 + t484 * t746 / 0.16e2);
  tv2sigmalapl0 = t3 * t750;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t751 = t539 * t597;
  t754 = t207 * t191;
  t755 = t754 * t445;
  t758 = t540 * t191;
  t759 = t611 * t758;
  t762 = t546 * t191;
  t763 = t615 * t762;
  t767 = my_piecewise3(t51, 0, -t519 * t751 / 0.32e2 - t721 - t534 * t755 / 0.16e2 + t534 * t759 / 0.16e2 + t534 * t763 / 0.16e2);
  tv2sigmalapl5 = t3 * t767;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t768 = t489 * t626;
  t771 = t213 * t183;
  t772 = t771 * t290;
  t775 = t640 * t741;
  t778 = t644 * t745;
  t782 = my_piecewise3(t2, 0, -t469 * t768 / 0.32e2 - t699 - t484 * t772 / 0.16e2 + t484 * t775 / 0.16e2 + t484 * t778 / 0.16e2);
  tv2sigmatau0 = t3 * t782;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t783 = t539 * t665;
  t786 = t219 * t191;
  t787 = t786 * t445;
  t790 = t679 * t758;
  t793 = t683 * t762;
  t797 = my_piecewise3(t51, 0, -t519 * t783 / 0.32e2 - t721 - t534 * t787 / 0.16e2 + t534 * t790 / 0.16e2 + t534 * t793 / 0.16e2);
  tv2sigmatau5 = t3 * t797;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t798 = t199 * t199;
  t800 = t260 * t798 * t269;
  t803 = t100 * t798;
  t804 = t803 * t290;
  t807 = t803 * t297;
  t810 = t803 * t301;
  t814 = my_piecewise3(t2, 0, -t99 * t800 / 0.32e2 - t699 - t99 * t804 / 0.16e2 + t99 * t807 / 0.16e2 + t99 * t810 / 0.16e2);
  tv2lapl20 = t3 * t814;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t815 = t207 * t207;
  t817 = t415 * t815 * t424;
  t820 = t157 * t815;
  t821 = t820 * t445;
  t824 = t820 * t452;
  t827 = t820 * t456;
  t831 = my_piecewise3(t51, 0, -t156 * t817 / 0.32e2 - t721 - t156 * t821 / 0.16e2 + t156 * t824 / 0.16e2 + t156 * t827 / 0.16e2);
  tv2lapl22 = t3 * t831;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t832 = t572 * t626;
  t835 = t213 * t199;
  t836 = t835 * t290;
  t839 = t490 * t199;
  t840 = t640 * t839;
  t843 = t496 * t199;
  t844 = t644 * t843;
  t848 = my_piecewise3(t2, 0, -t469 * t832 / 0.32e2 - t699 - t484 * t836 / 0.16e2 + t484 * t840 / 0.16e2 + t484 * t844 / 0.16e2);
  tv2lapltau0 = t3 * t848;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t849 = t611 * t665;
  t852 = t219 * t207;
  t853 = t852 * t445;
  t856 = t540 * t207;
  t857 = t679 * t856;
  t860 = t546 * t207;
  t861 = t683 * t860;
  t865 = my_piecewise3(t51, 0, -t519 * t849 / 0.32e2 - t721 - t534 * t853 / 0.16e2 + t534 * t857 / 0.16e2 + t534 * t861 / 0.16e2);
  tv2lapltau3 = t3 * t865;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t866 = t213 * t213;
  t868 = t260 * t866 * t269;
  t871 = t100 * t866;
  t872 = t871 * t290;
  t875 = t871 * t297;
  t878 = t871 * t301;
  t882 = my_piecewise3(t2, 0, -t99 * t868 / 0.32e2 - t699 - t99 * t872 / 0.16e2 + t99 * t875 / 0.16e2 + t99 * t878 / 0.16e2);
  tv2tau20 = t3 * t882;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t883 = t219 * t219;
  t885 = t415 * t883 * t424;
  t888 = t157 * t883;
  t889 = t888 * t445;
  t892 = t888 * t452;
  t895 = t888 * t456;
  t899 = my_piecewise3(t51, 0, -t156 * t885 / 0.32e2 - t721 - t156 * t889 / 0.16e2 + t156 * t892 / 0.16e2 + t156 * t895 / 0.16e2);
  tv2tau22 = t3 * t899;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t902 = 0.1e1 / t21;
  t903 = t228 * t87;
  t906 = t227 * t87;
  t909 = t83 * t83;
  t910 = 0.1e1 / t909;
  t911 = t13 * t910;
  t914 = my_piecewise5(t7, 0, t11, 0, 0.6e1 * t232 - 0.6e1 * t911);
  t918 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t902 * t903 + 0.9e1 / 0.4e1 * t906 * t236 + 0.3e1 / 0.2e1 * t20 * t914);
  t919 = M_PI * t918;
  t924 = t24 / t25 / t83;
  t925 = t924 * t46;
  t927 = 0.3e1 / 0.64e2 * t23 * t925;
  t928 = t241 * t96;
  t930 = t91 * t252;
  t932 = t261 * t111;
  t933 = t100 * t932;
  t934 = t264 * t264;
  t935 = 0.1e1 / t934;
  t936 = t263 * t935;
  t938 = 0.1e1 / t267 / t40;
  t939 = t936 * t938;
  t940 = t933 * t939;
  t943 = t263 * t43;
  t945 = 0.1e1 / t934 / t44;
  t946 = t943 * t945;
  t947 = t946 * t938;
  t948 = t933 * t947;
  t953 = t255 * t298;
  t955 = t260 * t932;
  t956 = t296 * t938;
  t957 = t955 * t956;
  t960 = t114 * t938;
  t961 = t933 * t960;
  t964 = t266 * t938;
  t965 = t955 * t964;
  t968 = t289 * t938;
  t969 = t933 * t968;
  t972 = t933 * t956;
  t977 = t255 * t302;
  t981 = -t919 * t47 / 0.8e1 - t927 - 0.3e1 / 0.16e2 * t928 + 0.3e1 / 0.32e2 * t930 + t99 * t940 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t948 + 0.3e1 / 0.16e2 * t246 * t298 + 0.3e1 / 0.32e2 * t953 - 0.3e1 / 0.32e2 * t99 * t957 - t99 * t961 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t965 + 0.3e1 / 0.16e2 * t99 * t969 - 0.3e1 / 0.16e2 * t99 * t972 + 0.3e1 / 0.16e2 * t246 * t302 + 0.3e1 / 0.32e2 * t977 - 0.3e1 / 0.16e2 * t246 * t285;
  t984 = t23 * t251;
  t985 = t984 * t117;
  t987 = t255 * t285;
  t989 = t255 * t270;
  t991 = t45 * t45;
  t992 = 0.1e1 / t991;
  t993 = t992 * t100;
  t996 = t258 * t260;
  t1000 = t993 * t111 * t116 / 0.2e1 - t996 * t111 * t116 / 0.2e1 + t117 / 0.2e1;
  t1002 = t1000 * t261 * t269;
  t1010 = 0.1e1 / t105 / t27;
  t1015 = my_piecewise3(t39, (-0.6e1 * lapl[0] * t278 + 0.24e2 * tau[0] * t278 - 0.15e2 / 0.2e1 * sigma[0] * t1010) * t37, 0);
  t1017 = t100 * t1015 * t116;
  t1020 = t241 * t26;
  t1023 = t91 * t95;
  t1024 = t1023 * t117;
  t1028 = t255 * t291;
  t1030 = t43 * t295;
  t1031 = t1030 * t938;
  t1032 = t933 * t1031;
  t1035 = t943 * t935;
  t1036 = t1035 * t938;
  t1037 = t955 * t1036;
  t1041 = t470 * t471 * t283;
  t1045 = t283 * t111 * t290;
  t1048 = t283 * t263;
  t1049 = t1048 * t491;
  t1053 = t283 * t43 * t497;
  t1056 = -0.3e1 / 0.32e2 * t246 * t270 + 0.3e1 / 0.64e2 * t985 - 0.3e1 / 0.32e2 * t987 - 0.3e1 / 0.64e2 * t989 - t99 * t1002 / 0.32e2 - t99 * t1017 / 0.16e2 - 0.3e1 / 0.16e2 * t1020 * t117 - 0.3e1 / 0.16e2 * t1024 - 0.3e1 / 0.16e2 * t246 * t291 - 0.3e1 / 0.32e2 * t1028 - t99 * t1032 / 0.16e2 + 0.3e1 / 0.32e2 * t99 * t1037 - 0.3e1 / 0.32e2 * t469 * t1041 - 0.3e1 / 0.16e2 * t484 * t1045 + 0.3e1 / 0.16e2 * t484 * t1049 + 0.3e1 / 0.16e2 * t484 * t1053;
  t1058 = my_piecewise3(t2, 0, t981 + t1056);
  t1059 = 0.1e1 / t58;
  t1060 = t308 * t124;
  t1063 = t307 * t124;
  t1066 = t52 * t910;
  t1069 = my_piecewise5(t11, 0, t7, 0, -0.6e1 * t232 - 0.6e1 * t1066);
  t1073 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1060 + 0.9e1 / 0.4e1 * t1063 * t314 + 0.3e1 / 0.2e1 * t57 * t1069);
  t1074 = M_PI * t1073;
  t1077 = t319 * t131;
  t1079 = t128 * t324;
  t1081 = t924 * t78;
  t1083 = 0.3e1 / 0.64e2 * t60 * t1081;
  t1085 = my_piecewise3(t51, 0, -t1074 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t1077 + 0.3e1 / 0.32e2 * t1079 - t1083);
  tv3rho30 = 0.3e1 * t306 + 0.3e1 * t328 + t3 * (t1058 + t1085);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1088 = 0.2e1 * t351;
  t1089 = 0.2e1 * t374;
  t1093 = t902 * t139;
  t1096 = t227 * t335;
  t1101 = 0.2e1 * t232;
  t1102 = 0.6e1 * t911;
  t1104 = my_piecewise5(t7, 0, t11, 0, t1101 - t1102);
  t1108 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1093 * t228 + 0.3e1 / 0.2e1 * t1096 * t87 + 0.3e1 / 0.4e1 * t331 * t236 + 0.3e1 / 0.2e1 * t20 * t1104);
  t1109 = M_PI * t1108;
  t1113 = t340 * t96 / 0.8e1;
  t1114 = t143 * t252;
  t1124 = t340 * t26;
  t1127 = t143 * t95;
  t1129 = t1127 * t117 / 0.16e2;
  t1138 = -t1028 / 0.32e2 - t345 * t291 / 0.16e2 - t1109 * t47 / 0.8e1 - t1113 + t1114 / 0.32e2 - t927 - t928 / 0.16e2 + t930 / 0.16e2 + t345 * t298 / 0.16e2 + t953 / 0.32e2 + t345 * t302 / 0.16e2 + t977 / 0.32e2 - t1124 * t117 / 0.8e1 - t1129 - t345 * t285 / 0.16e2 - t345 * t270 / 0.32e2 + t985 / 0.32e2 - t987 / 0.32e2 - t989 / 0.64e2 - t1024 / 0.16e2;
  t1139 = my_piecewise3(t2, 0, t1138);
  t1140 = t1059 * t149;
  t1143 = t307 * t356;
  t1148 = 0.6e1 * t1066;
  t1150 = my_piecewise5(t11, 0, t7, 0, -t1101 - t1148);
  t1154 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1140 * t308 + 0.3e1 / 0.2e1 * t1143 * t124 + 0.3e1 / 0.4e1 * t352 * t314 + 0.3e1 / 0.2e1 * t57 * t1150);
  t1155 = M_PI * t1154;
  t1159 = t361 * t131 / 0.8e1;
  t1160 = t153 * t324;
  t1164 = t319 * t26;
  t1167 = t128 * t95;
  t1169 = t1167 * t174 / 0.16e2;
  t1170 = t60 * t251;
  t1171 = t1170 * t174;
  t1174 = my_piecewise3(t51, 0, -t1155 * t79 / 0.8e1 - t1159 + t1160 / 0.32e2 - t1077 / 0.16e2 + t1079 / 0.16e2 - t1083 - t1164 * t174 / 0.16e2 - t1169 + t1171 / 0.64e2);
  tv3rho31 = t306 + t328 + t1088 + t1089 + t3 * (t1139 + t1174);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1177 = t902 * t379;
  t1182 = t227 * t384;
  t1186 = my_piecewise5(t7, 0, t11, 0, -t1101 - t1102);
  t1190 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1177 * t87 + 0.3e1 / 0.2e1 * t331 * t335 + 0.3e1 / 0.4e1 * t1182 * t87 + 0.3e1 / 0.2e1 * t20 * t1186);
  t1191 = M_PI * t1190;
  t1194 = t389 * t96;
  t1196 = t389 * t26;
  t1203 = my_piecewise3(t2, 0, -t1191 * t47 / 0.8e1 - t1194 / 0.16e2 - t1196 * t117 / 0.16e2 - t1113 + t1114 / 0.16e2 - t1129 + t930 / 0.32e2 - t927 + t985 / 0.64e2);
  t1204 = t1059 * t395;
  t1209 = t307 * t400;
  t1213 = my_piecewise5(t11, 0, t7, 0, t1101 - t1148);
  t1217 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1204 * t124 + 0.3e1 / 0.2e1 * t352 * t356 + 0.3e1 / 0.4e1 * t1209 * t124 + 0.3e1 / 0.2e1 * t57 * t1213);
  t1218 = M_PI * t1217;
  t1221 = t405 * t131;
  t1224 = t361 * t26;
  t1227 = t153 * t95;
  t1228 = t1227 * t174;
  t1234 = t370 * t425;
  t1238 = t370 * t440;
  t1242 = t370 * t446;
  t1246 = t370 * t453;
  t1250 = t370 * t457;
  t1252 = -t1218 * t79 / 0.8e1 - t1221 / 0.16e2 - t1159 + t1160 / 0.16e2 - t1224 * t174 / 0.8e1 - t1228 / 0.16e2 + t1079 / 0.32e2 - t1083 - t1169 + t1171 / 0.32e2 - t367 * t425 / 0.32e2 - t1234 / 0.64e2 - t367 * t440 / 0.16e2 - t1238 / 0.32e2 - t367 * t446 / 0.16e2 - t1242 / 0.32e2 + t367 * t453 / 0.16e2 + t1246 / 0.32e2 + t367 * t457 / 0.16e2 + t1250 / 0.32e2;
  t1253 = my_piecewise3(t51, 0, t1252);
  tv3rho32 = t1088 + t1089 + t394 + t461 + t3 * (t1203 + t1253);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1258 = t379 * t139;
  t1265 = my_piecewise5(t7, 0, t11, 0, -0.6e1 * t232 - 0.6e1 * t911);
  t1269 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t902 * t1258 + 0.9e1 / 0.4e1 * t331 * t384 + 0.3e1 / 0.2e1 * t20 * t1265);
  t1270 = M_PI * t1269;
  t1276 = my_piecewise3(t2, 0, -t1270 * t47 / 0.8e1 - 0.3e1 / 0.16e2 * t1194 + 0.3e1 / 0.32e2 * t1114 - t927);
  t1279 = t395 * t149;
  t1286 = my_piecewise5(t11, 0, t7, 0, 0.6e1 * t232 - 0.6e1 * t1066);
  t1290 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1279 + 0.9e1 / 0.4e1 * t352 * t400 + 0.3e1 / 0.2e1 * t57 * t1286);
  t1291 = M_PI * t1290;
  t1298 = t520 * t521 * t438;
  t1302 = t438 * t75 * t547;
  t1306 = t438 * t168 * t445;
  t1309 = t438 * t418;
  t1310 = t1309 * t541;
  t1313 = t405 * t26;
  t1320 = t77 * t77;
  t1321 = 0.1e1 / t1320;
  t1322 = t1321 * t157;
  t1325 = t413 * t415;
  t1329 = t1322 * t168 * t173 / 0.2e1 - t1325 * t168 * t173 / 0.2e1 + t174 / 0.2e1;
  t1331 = t1329 * t416 * t424;
  t1339 = 0.1e1 / t162 / t61;
  t1344 = my_piecewise3(t72, (-0.6e1 * lapl[1] * t433 + 0.24e2 * tau[1] * t433 - 0.15e2 / 0.2e1 * sigma[2] * t1339) * t37, 0);
  t1346 = t157 * t1344 * t173;
  t1349 = -t1083 + 0.3e1 / 0.32e2 * t1160 - 0.3e1 / 0.16e2 * t1221 - t1291 * t79 / 0.8e1 + 0.3e1 / 0.64e2 * t1171 - 0.3e1 / 0.16e2 * t1228 - 0.3e1 / 0.64e2 * t1234 - 0.3e1 / 0.32e2 * t519 * t1298 + 0.3e1 / 0.16e2 * t534 * t1302 - 0.3e1 / 0.16e2 * t534 * t1306 + 0.3e1 / 0.16e2 * t534 * t1310 - 0.3e1 / 0.16e2 * t1313 * t174 - 0.3e1 / 0.16e2 * t409 * t440 - 0.3e1 / 0.32e2 * t409 * t425 - t156 * t1331 / 0.32e2 - t156 * t1346 / 0.16e2;
  t1356 = t416 * t168;
  t1357 = t157 * t1356;
  t1358 = t75 * t450;
  t1360 = 0.1e1 / t422 / t73;
  t1361 = t1358 * t1360;
  t1362 = t1357 * t1361;
  t1365 = t415 * t1356;
  t1366 = t451 * t1360;
  t1367 = t1365 * t1366;
  t1370 = t418 * t75;
  t1371 = t419 * t419;
  t1372 = 0.1e1 / t1371;
  t1373 = t1370 * t1372;
  t1374 = t1373 * t1360;
  t1375 = t1365 * t1374;
  t1378 = t418 * t1372;
  t1379 = t1378 * t1360;
  t1380 = t1357 * t1379;
  t1384 = 0.1e1 / t1371 / t76;
  t1385 = t1370 * t1384;
  t1386 = t1385 * t1360;
  t1387 = t1357 * t1386;
  t1392 = t444 * t1360;
  t1393 = t1357 * t1392;
  t1396 = t1357 * t1366;
  t1399 = t171 * t1360;
  t1400 = t1357 * t1399;
  t1405 = t421 * t1360;
  t1406 = t1365 * t1405;
  t1409 = -0.3e1 / 0.32e2 * t1238 - 0.3e1 / 0.32e2 * t1242 + 0.3e1 / 0.32e2 * t1246 + 0.3e1 / 0.32e2 * t1250 - 0.3e1 / 0.16e2 * t409 * t446 - t156 * t1362 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t1367 + 0.3e1 / 0.32e2 * t156 * t1375 + t156 * t1380 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t1387 + 0.3e1 / 0.16e2 * t409 * t453 + 0.3e1 / 0.16e2 * t156 * t1393 - 0.3e1 / 0.16e2 * t156 * t1396 - t156 * t1400 / 0.8e1 + 0.3e1 / 0.16e2 * t409 * t457 + 0.3e1 / 0.32e2 * t156 * t1406;
  t1411 = my_piecewise3(t51, 0, t1349 + t1409);
  tv3rho33 = 0.3e1 * t394 + 0.3e1 * t461 + t3 * (t1276 + t1411);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1415 = t91 * t483;
  t1418 = t95 * t100;
  t1419 = t23 * t1418;
  t1420 = t1419 * t486;
  t1422 = t1023 * t185;
  t1425 = t984 * t185 / 0.64e2;
  t1430 = t255 * t480;
  t1432 = t278 * t37;
  t1434 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t1432, 0);
  t1436 = t100 * t1434 * t116;
  t1440 = t478 * t111 * t290;
  t1445 = t1419 * t492;
  t1447 = t478 * t263;
  t1448 = t1447 * t491;
  t1451 = t183 * t261;
  t1452 = t1451 * t1031;
  t1455 = t1451 * t968;
  t1458 = t295 * t938;
  t1459 = t1458 * t261;
  t1460 = t489 * t1459;
  t1463 = t113 * t938;
  t1464 = t1463 * t261;
  t1465 = t495 * t1464;
  t1468 = -t1415 * t486 / 0.8e1 - t1420 / 0.16e2 - t1422 / 0.16e2 + t1425 - t1020 * t185 / 0.16e2 - t246 * t480 / 0.8e1 - t1430 / 0.16e2 - t99 * t1436 / 0.16e2 - t484 * t1440 / 0.8e1 + t1415 * t492 / 0.8e1 + t1445 / 0.16e2 + t484 * t1448 / 0.8e1 - t484 * t1452 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t1455 - 0.3e1 / 0.16e2 * t484 * t1460 - t484 * t1465 / 0.8e1;
  t1469 = t261 * t263;
  t1470 = t265 * t938;
  t1471 = t1470 * t183;
  t1472 = t1469 * t1471;
  t1475 = t496 * t283;
  t1476 = t495 * t1475;
  t1479 = t478 * t43;
  t1480 = t1479 * t497;
  t1483 = t183 * t283;
  t1484 = t1483 * t290;
  t1487 = t490 * t283;
  t1488 = t489 * t1487;
  t1493 = t91 * t468;
  t1496 = t1419 * t498;
  t1498 = t95 * t260;
  t1499 = t23 * t1498;
  t1500 = t1499 * t473;
  t1502 = t26 * t1000;
  t1503 = t23 * t1502;
  t1506 = t1048 * t472;
  t1509 = t471 * t478;
  t1510 = t470 * t1509;
  t1515 = t261 * t943;
  t1516 = t935 * t938;
  t1517 = t1516 * t183;
  t1518 = t1515 * t1517;
  t1521 = t1451 * t939;
  t1524 = t183 * t943;
  t1525 = t945 * t938;
  t1526 = t1525 * t261;
  t1527 = t1524 * t1526;
  t1530 = 0.3e1 / 0.32e2 * t469 * t1472 + t484 * t1476 / 0.16e2 + t484 * t1480 / 0.8e1 - t484 * t1484 / 0.16e2 + t484 * t1488 / 0.16e2 + t1415 * t498 / 0.8e1 - t1493 * t473 / 0.16e2 + t1496 / 0.16e2 - t1500 / 0.32e2 - t1503 * t473 / 0.32e2 - t469 * t1506 / 0.32e2 - t469 * t1510 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t1460 + 0.3e1 / 0.32e2 * t469 * t1518 + t484 * t1521 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1527;
  t1532 = my_piecewise3(t2, 0, t1468 + t1530);
  tv3rho2sigma0 = t3 * t1532 + 0.2e1 * t502;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1537 = t1167 * t193;
  t1540 = t1170 * t193 / 0.64e2;
  t1542 = my_piecewise3(t51, 0, -t1164 * t193 / 0.16e2 - t1537 / 0.16e2 + t1540);
  tv3rho2sigma2 = t3 * t1542 + 0.2e1 * t509;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1546 = t1127 * t185;
  t1548 = t143 * t468;
  t1553 = t143 * t483;
  t1566 = -t1124 * t185 / 0.16e2 - t1546 / 0.32e2 - t1548 * t473 / 0.32e2 - t345 * t480 / 0.16e2 - t1553 * t486 / 0.16e2 + t1553 * t492 / 0.16e2 + t1553 * t498 / 0.16e2 - t1422 / 0.32e2 + t1425 - t1500 / 0.64e2 - t1430 / 0.32e2 - t1420 / 0.32e2 + t1445 / 0.32e2 + t1496 / 0.32e2;
  t1567 = my_piecewise3(t2, 0, t1566);
  tv3rho2sigma3 = t3 * t1567 + t502 + t514;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1571 = t1227 * t193;
  t1574 = t128 * t518;
  t1577 = t95 * t415;
  t1578 = t60 * t1577;
  t1579 = t1578 * t523;
  t1583 = t370 * t530;
  t1585 = t128 * t533;
  t1588 = t95 * t157;
  t1589 = t60 * t1588;
  t1590 = t1589 * t536;
  t1594 = t1589 * t542;
  t1598 = t1589 * t548;
  t1600 = -t1224 * t193 / 0.16e2 - t1571 / 0.32e2 - t1537 / 0.32e2 + t1540 - t1574 * t523 / 0.32e2 - t1579 / 0.64e2 - t367 * t530 / 0.16e2 - t1583 / 0.32e2 - t1585 * t536 / 0.16e2 - t1590 / 0.32e2 + t1585 * t542 / 0.16e2 + t1594 / 0.32e2 + t1585 * t548 / 0.16e2 + t1598 / 0.32e2;
  t1601 = my_piecewise3(t51, 0, t1600);
  tv3rho2sigma5 = t3 * t1601 + t509 + t552;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1608 = my_piecewise3(t2, 0, -t1196 * t185 / 0.16e2 - t1546 / 0.16e2 + t1425);
  tv3rho2sigma6 = t3 * t1608 + 0.2e1 * t514;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1611 = t433 * t37;
  t1613 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t1611, 0);
  t1615 = t157 * t1613 * t173;
  t1622 = t416 * t418;
  t1623 = t450 * t1360;
  t1624 = t1623 * t191;
  t1625 = t1622 * t1624;
  t1628 = t416 * t1370;
  t1629 = t1372 * t1360;
  t1630 = t1629 * t191;
  t1631 = t1628 * t1630;
  t1634 = t191 * t416;
  t1635 = t1634 * t1379;
  t1638 = t191 * t1370;
  t1639 = t1384 * t1360;
  t1640 = t1639 * t416;
  t1641 = t1638 * t1640;
  t1650 = t546 * t438;
  t1651 = t545 * t1650;
  t1654 = t26 * t1329;
  t1655 = t60 * t1654;
  t1658 = -t156 * t1615 / 0.16e2 - t1313 * t193 / 0.16e2 - t409 * t530 / 0.8e1 - 0.3e1 / 0.32e2 * t519 * t1625 + 0.3e1 / 0.32e2 * t519 * t1631 + t534 * t1635 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1641 + t1540 - t1571 / 0.16e2 - t1583 / 0.16e2 - t1579 / 0.32e2 - t1590 / 0.16e2 + t1594 / 0.16e2 + t1598 / 0.16e2 + t534 * t1651 / 0.16e2 - t1655 * t523 / 0.32e2;
  t1659 = t1309 * t522;
  t1662 = t521 * t528;
  t1663 = t520 * t1662;
  t1666 = t528 * t75;
  t1667 = t1666 * t547;
  t1670 = t191 * t438;
  t1671 = t1670 * t445;
  t1674 = t540 * t438;
  t1675 = t539 * t1674;
  t1678 = t153 * t533;
  t1681 = t153 * t518;
  t1685 = t528 * t168 * t445;
  t1692 = t528 * t418;
  t1693 = t1692 * t541;
  t1696 = t1634 * t1361;
  t1701 = t170 * t1360;
  t1702 = t1701 * t416;
  t1703 = t545 * t1702;
  t1706 = t420 * t1360;
  t1707 = t1706 * t191;
  t1708 = t1622 * t1707;
  t1711 = t1634 * t1392;
  t1714 = -t519 * t1659 / 0.32e2 - t519 * t1663 / 0.16e2 + t534 * t1667 / 0.8e1 - t534 * t1671 / 0.16e2 + t534 * t1675 / 0.16e2 + t1678 * t548 / 0.8e1 - t1681 * t523 / 0.16e2 - t534 * t1685 / 0.8e1 - t1678 * t536 / 0.8e1 + t1678 * t542 / 0.8e1 + t534 * t1693 / 0.8e1 - t534 * t1696 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t1625 - t534 * t1703 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t1708 + 0.3e1 / 0.16e2 * t534 * t1711;
  t1716 = my_piecewise3(t51, 0, t1658 + t1714);
  tv3rho2sigma8 = t3 * t1716 + 0.2e1 * t552;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1720 = t984 * t201 / 0.64e2;
  t1721 = t1023 * t201;
  t1723 = t255 * t565;
  t1726 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t476, 0);
  t1728 = t100 * t1726 * t116;
  t1735 = t199 * t943;
  t1736 = t1735 * t1526;
  t1739 = t1458 * t199;
  t1740 = t1469 * t1739;
  t1743 = t1516 * t199;
  t1744 = t1515 * t1743;
  t1747 = t1048 * t558;
  t1750 = t471 * t563;
  t1751 = t470 * t1750;
  t1754 = t563 * t43;
  t1755 = t1754 * t497;
  t1760 = t1419 * t569;
  t1763 = t563 * t111 * t290;
  t1768 = t1720 - t1721 / 0.16e2 - t1723 / 0.16e2 - t99 * t1728 / 0.16e2 - t1020 * t201 / 0.16e2 - t246 * t565 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t1736 - 0.3e1 / 0.32e2 * t469 * t1740 + 0.3e1 / 0.32e2 * t469 * t1744 - t469 * t1747 / 0.32e2 - t469 * t1751 / 0.16e2 + t484 * t1755 / 0.8e1 - t1415 * t569 / 0.8e1 - t1760 / 0.16e2 - t484 * t1763 / 0.8e1 + t1415 * t573 / 0.8e1;
  t1769 = t1419 * t573;
  t1771 = t563 * t263;
  t1772 = t1771 * t491;
  t1775 = t199 * t261;
  t1776 = t1775 * t1031;
  t1779 = t1775 * t968;
  t1784 = t576 * t1464;
  t1787 = t1470 * t199;
  t1788 = t1469 * t1787;
  t1791 = t1775 * t939;
  t1794 = t199 * t283;
  t1795 = t1794 * t290;
  t1798 = t572 * t1487;
  t1801 = t576 * t1475;
  t1808 = t1419 * t577;
  t1810 = t1499 * t559;
  t1814 = t1769 / 0.16e2 + t484 * t1772 / 0.8e1 - t484 * t1776 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t1779 - 0.3e1 / 0.16e2 * t484 * t1740 - t484 * t1784 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1788 + t484 * t1791 / 0.4e1 - t484 * t1795 / 0.16e2 + t484 * t1798 / 0.16e2 + t484 * t1801 / 0.16e2 + t1415 * t577 / 0.8e1 - t1493 * t559 / 0.16e2 + t1808 / 0.16e2 - t1810 / 0.32e2 - t1503 * t559 / 0.32e2;
  t1816 = my_piecewise3(t2, 0, t1768 + t1814);
  tv3rho2lapl0 = t3 * t1816 + 0.2e1 * t581;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1821 = t1167 * t209;
  t1824 = t1170 * t209 / 0.64e2;
  t1826 = my_piecewise3(t51, 0, -t1164 * t209 / 0.16e2 - t1821 / 0.16e2 + t1824);
  tv3rho2lapl1 = t3 * t1826 + 0.2e1 * t588;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1830 = t1127 * t201;
  t1848 = -t1124 * t201 / 0.16e2 - t1830 / 0.32e2 - t1548 * t559 / 0.32e2 - t345 * t565 / 0.16e2 - t1553 * t569 / 0.16e2 + t1553 * t573 / 0.16e2 + t1553 * t577 / 0.16e2 - t1721 / 0.32e2 + t1720 - t1810 / 0.64e2 - t1723 / 0.32e2 - t1760 / 0.32e2 + t1769 / 0.32e2 + t1808 / 0.32e2;
  t1849 = my_piecewise3(t2, 0, t1848);
  tv3rho2lapl2 = t3 * t1849 + t581 + t593;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1853 = t1227 * t209;
  t1858 = t1578 * t598;
  t1862 = t370 * t604;
  t1866 = t1589 * t608;
  t1870 = t1589 * t612;
  t1874 = t1589 * t616;
  t1876 = -t1224 * t209 / 0.16e2 - t1853 / 0.32e2 - t1821 / 0.32e2 + t1824 - t1574 * t598 / 0.32e2 - t1858 / 0.64e2 - t367 * t604 / 0.16e2 - t1862 / 0.32e2 - t1585 * t608 / 0.16e2 - t1866 / 0.32e2 + t1585 * t612 / 0.16e2 + t1870 / 0.32e2 + t1585 * t616 / 0.16e2 + t1874 / 0.32e2;
  t1877 = my_piecewise3(t51, 0, t1876);
  tv3rho2lapl3 = t3 * t1877 + t588 + t620;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1884 = my_piecewise3(t2, 0, -t1196 * t201 / 0.16e2 - t1830 / 0.16e2 + t1720);
  tv3rho2lapl4 = t3 * t1884 + 0.2e1 * t593;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1892 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t526, 0);
  t1894 = t157 * t1892 * t173;
  t1901 = t602 * t168;
  t1902 = t1901 * t445;
  t1907 = t602 * t418;
  t1908 = t1907 * t541;
  t1911 = t207 * t416;
  t1912 = t1911 * t1361;
  t1915 = t207 * t438;
  t1916 = t1915 * t445;
  t1919 = t611 * t1674;
  t1922 = t615 * t1650;
  t1929 = -t1313 * t209 / 0.16e2 - t409 * t604 / 0.8e1 - t156 * t1894 / 0.16e2 - t1853 / 0.16e2 - t1862 / 0.16e2 + t1824 - t1678 * t608 / 0.8e1 - t534 * t1902 / 0.8e1 + t1678 * t612 / 0.8e1 + t534 * t1908 / 0.8e1 - t534 * t1912 / 0.16e2 - t534 * t1916 / 0.16e2 + t534 * t1919 / 0.16e2 + t534 * t1922 / 0.16e2 - t1681 * t598 / 0.16e2 - t1655 * t598 / 0.32e2;
  t1930 = t1309 * t597;
  t1933 = t521 * t602;
  t1934 = t520 * t1933;
  t1937 = t602 * t75;
  t1938 = t1937 * t547;
  t1947 = t1623 * t416;
  t1948 = t611 * t1947;
  t1951 = t615 * t1702;
  t1954 = t1706 * t207;
  t1955 = t1622 * t1954;
  t1958 = t1911 * t1392;
  t1961 = t1911 * t1379;
  t1964 = t207 * t1370;
  t1965 = t1964 * t1640;
  t1970 = t1629 * t207;
  t1971 = t1628 * t1970;
  t1974 = -t519 * t1930 / 0.32e2 - t519 * t1934 / 0.16e2 + t534 * t1938 / 0.8e1 + t1678 * t616 / 0.8e1 - t1858 / 0.32e2 - t1866 / 0.16e2 + t1870 / 0.16e2 + t1874 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t1948 - t534 * t1951 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t1955 + 0.3e1 / 0.16e2 * t534 * t1958 + t534 * t1961 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1965 - 0.3e1 / 0.32e2 * t519 * t1948 + 0.3e1 / 0.32e2 * t519 * t1971;
  t1976 = my_piecewise3(t51, 0, t1929 + t1974);
  tv3rho2lapl5 = t3 * t1976 + 0.2e1 * t620;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1979 = t213 * t261;
  t1980 = t1979 * t1031;
  t1983 = t1979 * t968;
  t1986 = t640 * t1459;
  t1989 = t644 * t1464;
  t1992 = t1470 * t213;
  t1993 = t1469 * t1992;
  t1998 = t1516 * t213;
  t1999 = t1515 * t1998;
  t2002 = t1979 * t939;
  t2005 = t213 * t943;
  t2006 = t2005 * t1526;
  t2009 = t471 * t631;
  t2010 = t470 * t2009;
  t2013 = t631 * t43;
  t2014 = t2013 * t497;
  t2017 = t213 * t283;
  t2018 = t2017 * t290;
  t2021 = t640 * t1487;
  t2028 = t1419 * t645;
  t2030 = -t484 * t1980 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t1983 - 0.3e1 / 0.16e2 * t484 * t1986 - t484 * t1989 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1993 - 0.3e1 / 0.32e2 * t469 * t1986 + 0.3e1 / 0.32e2 * t469 * t1999 + t484 * t2002 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2006 - t469 * t2010 / 0.16e2 + t484 * t2014 / 0.8e1 - t484 * t2018 / 0.16e2 + t484 * t2021 / 0.16e2 + t1415 * t645 / 0.8e1 - t1493 * t627 / 0.16e2 + t2028 / 0.16e2;
  t2031 = t1499 * t627;
  t2035 = t1048 * t626;
  t2040 = t1419 * t637;
  t2043 = t631 * t111 * t290;
  t2048 = t1419 * t641;
  t2050 = t631 * t263;
  t2051 = t2050 * t491;
  t2054 = t1023 * t215;
  t2057 = t984 * t215 / 0.64e2;
  t2062 = t255 * t633;
  t2065 = my_piecewise3(t39, -0.6e1 * t476, 0);
  t2067 = t100 * t2065 * t116;
  t2070 = t644 * t1475;
  t2073 = -t2031 / 0.32e2 - t1503 * t627 / 0.32e2 - t469 * t2035 / 0.32e2 - t1415 * t637 / 0.8e1 - t2040 / 0.16e2 - t484 * t2043 / 0.8e1 + t1415 * t641 / 0.8e1 + t2048 / 0.16e2 + t484 * t2051 / 0.8e1 - t2054 / 0.16e2 + t2057 - t1020 * t215 / 0.16e2 - t246 * t633 / 0.8e1 - t2062 / 0.16e2 - t99 * t2067 / 0.16e2 + t484 * t2070 / 0.16e2;
  t2075 = my_piecewise3(t2, 0, t2030 + t2073);
  tv3rho2tau0 = t3 * t2075 + 0.2e1 * t649;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2080 = t1167 * t221;
  t2083 = t1170 * t221 / 0.64e2;
  t2085 = my_piecewise3(t51, 0, -t1164 * t221 / 0.16e2 - t2080 / 0.16e2 + t2083);
  tv3rho2tau1 = t3 * t2085 + 0.2e1 * t656;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2089 = t1127 * t215;
  t2107 = -t1124 * t215 / 0.16e2 - t2089 / 0.32e2 - t1548 * t627 / 0.32e2 - t345 * t633 / 0.16e2 - t1553 * t637 / 0.16e2 + t1553 * t641 / 0.16e2 + t1553 * t645 / 0.16e2 - t2054 / 0.32e2 + t2057 - t2031 / 0.64e2 - t2062 / 0.32e2 - t2040 / 0.32e2 + t2048 / 0.32e2 + t2028 / 0.32e2;
  t2108 = my_piecewise3(t2, 0, t2107);
  tv3rho2tau2 = t3 * t2108 + t649 + t661;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2112 = t1227 * t221;
  t2117 = t1578 * t666;
  t2121 = t370 * t672;
  t2125 = t1589 * t676;
  t2129 = t1589 * t680;
  t2133 = t1589 * t684;
  t2135 = -t1224 * t221 / 0.16e2 - t2112 / 0.32e2 - t2080 / 0.32e2 + t2083 - t1574 * t666 / 0.32e2 - t2117 / 0.64e2 - t367 * t672 / 0.16e2 - t2121 / 0.32e2 - t1585 * t676 / 0.16e2 - t2125 / 0.32e2 + t1585 * t680 / 0.16e2 + t2129 / 0.32e2 + t1585 * t684 / 0.16e2 + t2133 / 0.32e2;
  t2136 = my_piecewise3(t51, 0, t2135);
  tv3rho2tau3 = t3 * t2136 + t656 + t688;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2143 = my_piecewise3(t2, 0, -t1196 * t215 / 0.16e2 - t2089 / 0.16e2 + t2057);
  tv3rho2tau4 = t3 * t2143 + 0.2e1 * t661;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2146 = t1706 * t219;
  t2147 = t1622 * t2146;
  t2150 = t219 * t416;
  t2151 = t2150 * t1392;
  t2155 = t1622 * t1623 * t219;
  t2158 = t1629 * t219;
  t2159 = t1628 * t2158;
  t2162 = t2150 * t1379;
  t2165 = t219 * t1370;
  t2166 = t2165 * t1640;
  t2169 = t679 * t1674;
  t2178 = t1309 * t665;
  t2181 = t521 * t670;
  t2182 = t520 * t2181;
  t2188 = t670 * t168 * t445;
  t2193 = t670 * t418;
  t2194 = t2193 * t541;
  t2197 = 0.3e1 / 0.32e2 * t519 * t2147 + 0.3e1 / 0.16e2 * t534 * t2151 - 0.3e1 / 0.32e2 * t519 * t2155 + 0.3e1 / 0.32e2 * t519 * t2159 + t534 * t2162 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2166 + t534 * t2169 / 0.16e2 + t1678 * t684 / 0.8e1 - t1681 * t666 / 0.16e2 - t1655 * t666 / 0.32e2 - t519 * t2178 / 0.32e2 - t519 * t2182 / 0.16e2 - t1678 * t676 / 0.8e1 - t534 * t2188 / 0.8e1 + t1678 * t680 / 0.8e1 + t534 * t2194 / 0.8e1;
  t2198 = t2150 * t1361;
  t2203 = t683 * t1702;
  t2209 = t683 * t1650;
  t2212 = t670 * t75;
  t2213 = t2212 * t547;
  t2216 = t219 * t438;
  t2217 = t2216 * t445;
  t2228 = my_piecewise3(t72, -0.6e1 * t526, 0);
  t2230 = t157 * t2228 * t173;
  t2233 = -t534 * t2198 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2155 - t534 * t2203 / 0.8e1 - t2125 / 0.16e2 + t2129 / 0.16e2 + t2133 / 0.16e2 + t534 * t2209 / 0.16e2 + t534 * t2213 / 0.8e1 - t534 * t2217 / 0.16e2 - t2117 / 0.32e2 - t1313 * t221 / 0.16e2 - t409 * t672 / 0.8e1 - t2112 / 0.16e2 - t2121 / 0.16e2 - t156 * t2230 / 0.16e2 + t2083;
  t2235 = my_piecewise3(t51, 0, t2197 + t2233);
  tv3rho2tau5 = t3 * t2235 + 0.2e1 * t688;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2237 = t695 * t111;
  t2238 = t2237 * t290;
  t2239 = t484 * t2238;
  t2240 = t2239 / 0.16e2;
  t2241 = t690 * t263;
  t2242 = t1458 * t111;
  t2243 = t2241 * t2242;
  t2246 = t690 * t943;
  t2247 = t1516 * t111;
  t2248 = t2246 * t2247;
  t2251 = t695 * t263;
  t2252 = t2251 * t491;
  t2253 = t484 * t2252;
  t2254 = t2253 / 0.16e2;
  t2255 = t2241 * t2247;
  t2258 = t1525 * t111;
  t2259 = t2246 * t2258;
  t2262 = t690 * t43;
  t2263 = t1463 * t111;
  t2264 = t2262 * t2263;
  t2267 = t489 * t1509;
  t2270 = t1470 * t111;
  t2271 = t2241 * t2270;
  t2274 = t695 * t43;
  t2275 = t2274 * t497;
  t2276 = t484 * t2275;
  t2277 = t2276 / 0.16e2;
  t2278 = t471 * t695;
  t2279 = t470 * t2278;
  t2280 = t469 * t2279;
  t2281 = t2280 / 0.32e2;
  t2283 = t690 * t111 * t1031;
  t2286 = t495 * t1509;
  t2289 = -t699 - t2240 - 0.3e1 / 0.32e2 * t469 * t2243 + 0.3e1 / 0.32e2 * t469 * t2248 + t2254 + t484 * t2255 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2259 - t484 * t2264 / 0.8e1 - t469 * t2267 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2271 + t2277 - t2281 - t484 * t2283 / 0.16e2 - t484 * t2286 / 0.8e1;
  t2290 = t2262 * t2270;
  t2293 = t490 * t478;
  t2294 = t489 * t2293;
  t2299 = t496 * t478;
  t2300 = t495 * t2299;
  t2308 = t255 * t704 / 0.32e2;
  t2310 = t255 * t707 / 0.32e2;
  t2312 = t255 * t692 / 0.64e2;
  t2313 = t255 * t697;
  t2314 = t2313 / 0.32e2;
  t2316 = t255 * t701 / 0.32e2;
  t2320 = t1000 * t690 * t269;
  t2323 = t246 * t697;
  t2324 = t2323 / 0.16e2;
  t2327 = 0.3e1 / 0.16e2 * t484 * t2290 + t484 * t2294 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t2243 + t484 * t2300 / 0.8e1 + t246 * t704 / 0.16e2 + t246 * t707 / 0.16e2 + t2308 + t2310 - t2312 - t2314 - t2316 - t246 * t692 / 0.32e2 - t99 * t2320 / 0.32e2 - t2324 - t246 * t701 / 0.16e2;
  t2329 = my_piecewise3(t2, 0, t2289 + t2327);
  tv3rhosigma20 = t3 * t2329 + t711;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2334 = t370 * t714 / 0.64e2;
  t2336 = t367 * t719 / 0.16e2;
  t2337 = t370 * t719;
  t2338 = t2337 / 0.32e2;
  t2342 = t370 * t723 / 0.32e2;
  t2346 = t370 * t726 / 0.32e2;
  t2350 = t370 * t729 / 0.32e2;
  t2352 = my_piecewise3(t51, 0, -t367 * t714 / 0.32e2 - t2334 - t2336 - t2338 - t367 * t723 / 0.16e2 - t2342 + t367 * t726 / 0.16e2 + t2346 + t367 * t729 / 0.16e2 + t2350);
  tv3rhosigma25 = t3 * t2352 + t733;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2357 = t345 * t697 / 0.16e2;
  t2365 = my_piecewise3(t2, 0, -t345 * t692 / 0.32e2 - t2312 - t2357 - t2314 - t345 * t701 / 0.16e2 - t2316 + t345 * t704 / 0.16e2 + t2308 + t345 * t707 / 0.16e2 + t2310);
  tv3rhosigma26 = t3 * t2365 + t711;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2367 = t717 * t418;
  t2368 = t2367 * t541;
  t2369 = t534 * t2368;
  t2370 = t2369 / 0.16e2;
  t2371 = t712 * t418;
  t2372 = t1629 * t168;
  t2373 = t2371 * t2372;
  t2376 = t712 * t1370;
  t2377 = t1639 * t168;
  t2378 = t2376 * t2377;
  t2381 = t1623 * t168;
  t2382 = t2371 * t2381;
  t2385 = t546 * t528;
  t2386 = t545 * t2385;
  t2389 = t712 * t75;
  t2390 = t1701 * t168;
  t2391 = t2389 * t2390;
  t2394 = t539 * t1662;
  t2397 = t1706 * t168;
  t2398 = t2371 * t2397;
  t2401 = t717 * t75;
  t2402 = t2401 * t547;
  t2403 = t534 * t2402;
  t2404 = t2403 / 0.16e2;
  t2405 = t521 * t717;
  t2406 = t520 * t2405;
  t2407 = t519 * t2406;
  t2408 = t2407 / 0.32e2;
  t2409 = t545 * t1662;
  t2412 = t2389 * t2397;
  t2415 = t540 * t528;
  t2416 = t539 * t2415;
  t2419 = -t721 + t2370 + t534 * t2373 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2378 - 0.3e1 / 0.16e2 * t534 * t2382 + t534 * t2386 / 0.8e1 - t534 * t2391 / 0.8e1 - t519 * t2394 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2398 + t2404 - t2408 - t534 * t2409 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2412 + t534 * t2416 / 0.8e1;
  t2420 = t717 * t168;
  t2421 = t2420 * t445;
  t2422 = t534 * t2421;
  t2423 = t2422 / 0.16e2;
  t2425 = t712 * t168 * t1361;
  t2430 = t2376 * t2372;
  t2436 = t1329 * t712 * t424;
  t2439 = t409 * t719;
  t2440 = t2439 / 0.16e2;
  t2447 = -t2423 - t534 * t2425 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2382 + 0.3e1 / 0.32e2 * t519 * t2430 - t409 * t714 / 0.32e2 - t156 * t2436 / 0.32e2 - t2440 - t409 * t723 / 0.16e2 + t409 * t726 / 0.16e2 + t2346 + t2350 + t409 * t729 / 0.16e2 - t2334 - t2338 - t2342;
  t2449 = my_piecewise3(t51, 0, t2419 + t2447);
  tv3rhosigma211 = t3 * t2449 + t733;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2451 = t737 * t111;
  t2452 = t2451 * t1031;
  t2455 = t572 * t295;
  t2456 = t938 * t183;
  t2457 = t2456 * t111;
  t2458 = t2455 * t2457;
  t2461 = t576 * t113;
  t2462 = t2461 * t2457;
  t2465 = t489 * t265;
  t2466 = t938 * t199;
  t2467 = t2466 * t111;
  t2468 = t2465 * t2467;
  t2471 = t737 * t43;
  t2472 = t2471 * t2270;
  t2475 = t1735 * t945;
  t2476 = t2475 * t2457;
  t2481 = t1524 * t935;
  t2482 = t2481 * t2467;
  t2485 = t737 * t263;
  t2486 = t2485 * t2247;
  t2490 = t1419 * t738 / 0.32e2;
  t2493 = t1754 * t745;
  t2500 = t1447 * t558;
  t2503 = -t484 * t2452 / 0.16e2 - 0.3e1 / 0.16e2 * t484 * t2458 - t484 * t2462 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2468 + 0.3e1 / 0.16e2 * t484 * t2472 - 0.3e1 / 0.16e2 * t484 * t2476 - 0.3e1 / 0.32e2 * t469 * t2458 + 0.3e1 / 0.32e2 * t469 * t2482 + t484 * t2486 / 0.4e1 - t699 - t2490 + t1415 * t746 / 0.16e2 + t484 * t2493 / 0.16e2 - t1493 * t734 / 0.32e2 - t1503 * t734 / 0.32e2 - t469 * t2500 / 0.32e2;
  t2504 = t489 * t1750;
  t2508 = t1419 * t742 / 0.32e2;
  t2510 = t1419 * t746 / 0.32e2;
  t2512 = t1499 * t734 / 0.64e2;
  t2513 = t576 * t2299;
  t2518 = t563 * t183;
  t2519 = t2518 * t290;
  t2522 = t199 * t478;
  t2523 = t2522 * t290;
  t2528 = t1771 * t741;
  t2531 = t572 * t2293;
  t2534 = -t469 * t2504 / 0.32e2 + t2508 + t2510 - t2512 + t484 * t2513 / 0.16e2 - t1415 * t738 / 0.16e2 - t484 * t2519 / 0.16e2 - t484 * t2523 / 0.16e2 + t1415 * t742 / 0.16e2 + t484 * t2528 / 0.16e2 + t484 * t2531 / 0.16e2 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t2536 = my_piecewise3(t2, 0, t2503 + t2534);
  tv3rhosigmalapl0 = t3 * t2536 + t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2541 = t1578 * t751 / 0.64e2;
  t2545 = t1589 * t755 / 0.32e2;
  t2549 = t1589 * t759 / 0.32e2;
  t2553 = t1589 * t763 / 0.32e2;
  t2555 = my_piecewise3(t51, 0, -t1574 * t751 / 0.32e2 - t2541 - t2336 - t2338 - t1585 * t755 / 0.16e2 - t2545 + t1585 * t759 / 0.16e2 + t2549 + t1585 * t763 / 0.16e2 + t2553);
  tv3rhosigmalapl5 = t3 * t2555 + t767;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2566 = my_piecewise3(t2, 0, -t1548 * t734 / 0.32e2 - t2512 - t2357 - t2314 - t1553 * t738 / 0.16e2 - t2490 + t1553 * t742 / 0.16e2 + t2508 + t1553 * t746 / 0.16e2 + t2510);
  tv3rhosigmalapl6 = t3 * t2566 + t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2568 = t539 * t450;
  t2569 = t1360 * t207;
  t2570 = t2569 * t168;
  t2571 = t2568 * t2570;
  t2574 = t1638 * t1372;
  t2575 = t2574 * t2570;
  t2578 = t754 * t418;
  t2579 = t2578 * t2372;
  t2582 = t1964 * t1384;
  t2583 = t1360 * t191;
  t2584 = t2583 * t168;
  t2585 = t2582 * t2584;
  t2588 = t754 * t168;
  t2589 = t2588 * t1361;
  t2594 = t615 * t170;
  t2595 = t2594 * t2584;
  t2598 = t539 * t420;
  t2599 = t2598 * t2570;
  t2602 = t754 * t75;
  t2603 = t2602 * t2397;
  t2610 = t1937 * t762;
  t2613 = t615 * t2385;
  t2616 = t1692 * t597;
  t2619 = t539 * t1933;
  t2622 = -0.3e1 / 0.32e2 * t519 * t2571 + 0.3e1 / 0.32e2 * t519 * t2575 + t534 * t2579 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2585 - t534 * t2589 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2571 - t534 * t2595 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2599 + 0.3e1 / 0.16e2 * t534 * t2603 - t721 - t1681 * t751 / 0.32e2 - t1655 * t751 / 0.32e2 + t534 * t2610 / 0.16e2 + t534 * t2613 / 0.16e2 - t519 * t2616 / 0.32e2 - t519 * t2619 / 0.32e2;
  t2625 = t602 * t191;
  t2626 = t2625 * t445;
  t2629 = t207 * t528;
  t2630 = t2629 * t445;
  t2635 = t1907 * t758;
  t2638 = t611 * t2415;
  t2643 = -t1678 * t755 / 0.16e2 - t534 * t2626 / 0.16e2 - t534 * t2630 / 0.16e2 + t1678 * t759 / 0.16e2 + t534 * t2635 / 0.16e2 + t534 * t2638 / 0.16e2 + t1678 * t763 / 0.16e2 - t2541 - t2545 + t2549 + t2553 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t2645 = my_piecewise3(t51, 0, t2622 + t2643);
  tv3rhosigmalapl11 = t3 * t2645 + t767;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2647 = t771 * t111;
  t2648 = t2647 * t1031;
  t2651 = t771 * t43;
  t2652 = t2651 * t2270;
  t2655 = t640 * t295;
  t2656 = t2655 * t2457;
  t2659 = t644 * t113;
  t2660 = t2659 * t2457;
  t2663 = t938 * t213;
  t2664 = t2663 * t111;
  t2665 = t2465 * t2664;
  t2668 = t2005 * t945;
  t2669 = t2668 * t2457;
  t2674 = t2481 * t2664;
  t2677 = t771 * t263;
  t2678 = t2677 * t2247;
  t2681 = t640 * t2293;
  t2686 = t2013 * t745;
  t2689 = t644 * t2299;
  t2696 = -t484 * t2648 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t2652 - 0.3e1 / 0.16e2 * t484 * t2656 - t484 * t2660 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2665 - 0.3e1 / 0.16e2 * t484 * t2669 - 0.3e1 / 0.32e2 * t469 * t2656 + 0.3e1 / 0.32e2 * t469 * t2674 + t484 * t2678 / 0.4e1 - t699 + t484 * t2681 / 0.16e2 + t1415 * t778 / 0.16e2 + t484 * t2686 / 0.16e2 + t484 * t2689 / 0.16e2 - t1493 * t768 / 0.32e2 - t1503 * t768 / 0.32e2;
  t2697 = t1447 * t626;
  t2700 = t489 * t2009;
  t2704 = t1419 * t772 / 0.32e2;
  t2706 = t1419 * t775 / 0.32e2;
  t2708 = t1419 * t778 / 0.32e2;
  t2710 = t1499 * t768 / 0.64e2;
  t2713 = t631 * t183;
  t2714 = t2713 * t290;
  t2717 = t213 * t478;
  t2718 = t2717 * t290;
  t2723 = t2050 * t741;
  t2726 = -t469 * t2697 / 0.32e2 - t469 * t2700 / 0.32e2 - t2704 + t2706 + t2708 - t2710 - t1415 * t772 / 0.16e2 - t484 * t2714 / 0.16e2 - t484 * t2718 / 0.16e2 + t1415 * t775 / 0.16e2 + t484 * t2723 / 0.16e2 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t2728 = my_piecewise3(t2, 0, t2696 + t2726);
  tv3rhosigmatau0 = t3 * t2728 + t782;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2733 = t1578 * t783 / 0.64e2;
  t2737 = t1589 * t787 / 0.32e2;
  t2741 = t1589 * t790 / 0.32e2;
  t2745 = t1589 * t793 / 0.32e2;
  t2747 = my_piecewise3(t51, 0, -t1574 * t783 / 0.32e2 - t2733 - t2336 - t2338 - t1585 * t787 / 0.16e2 - t2737 + t1585 * t790 / 0.16e2 + t2741 + t1585 * t793 / 0.16e2 + t2745);
  tv3rhosigmatau5 = t3 * t2747 + t797;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2758 = my_piecewise3(t2, 0, -t1548 * t768 / 0.32e2 - t2710 - t2357 - t2314 - t1553 * t772 / 0.16e2 - t2704 + t1553 * t775 / 0.16e2 + t2706 + t1553 * t778 / 0.16e2 + t2708);
  tv3rhosigmatau6 = t3 * t2758 + t782;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2760 = t1360 * t219;
  t2761 = t2760 * t168;
  t2762 = t2598 * t2761;
  t2765 = t786 * t75;
  t2766 = t2765 * t2397;
  t2769 = t2568 * t2761;
  t2772 = t2574 * t2761;
  t2775 = t786 * t418;
  t2776 = t2775 * t2372;
  t2779 = t2165 * t1384;
  t2780 = t2779 * t2584;
  t2783 = t786 * t168;
  t2784 = t2783 * t1361;
  t2789 = t683 * t170;
  t2790 = t2789 * t2584;
  t2793 = t219 * t528;
  t2794 = t2793 * t445;
  t2799 = t2193 * t758;
  t2802 = t679 * t2415;
  t2807 = t2212 * t762;
  t2810 = 0.3e1 / 0.32e2 * t519 * t2762 + 0.3e1 / 0.16e2 * t534 * t2766 - 0.3e1 / 0.32e2 * t519 * t2769 + 0.3e1 / 0.32e2 * t519 * t2772 + t534 * t2776 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2780 - t534 * t2784 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2769 - t534 * t2790 / 0.8e1 - t721 - t534 * t2794 / 0.16e2 + t1678 * t790 / 0.16e2 + t534 * t2799 / 0.16e2 + t534 * t2802 / 0.16e2 + t1678 * t793 / 0.16e2 + t534 * t2807 / 0.16e2;
  t2811 = t683 * t2385;
  t2818 = t1692 * t665;
  t2821 = t539 * t2181;
  t2826 = t670 * t191;
  t2827 = t2826 * t445;
  t2830 = t534 * t2811 / 0.16e2 - t1681 * t783 / 0.32e2 - t1655 * t783 / 0.32e2 - t519 * t2818 / 0.32e2 - t519 * t2821 / 0.32e2 - t2737 + t2741 + t2745 - t1678 * t787 / 0.16e2 - t534 * t2827 / 0.16e2 - t2733 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t2832 = my_piecewise3(t51, 0, t2810 + t2830);
  tv3rhosigmatau11 = t3 * t2832 + t797;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2834 = t576 * t1750;
  t2837 = t798 * t43;
  t2838 = t2837 * t2270;
  t2841 = t798 * t111;
  t2842 = t2841 * t1031;
  t2845 = t798 * t263;
  t2846 = t2845 * t2242;
  t2849 = t798 * t943;
  t2850 = t2849 * t2247;
  t2853 = t2845 * t2247;
  t2856 = t2849 * t2258;
  t2859 = t490 * t563;
  t2860 = t572 * t2859;
  t2865 = t496 * t563;
  t2866 = t576 * t2865;
  t2869 = t2837 * t2263;
  t2872 = t572 * t1750;
  t2875 = t2845 * t2270;
  t2878 = -t699 - t484 * t2834 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2838 - t484 * t2842 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t2846 + 0.3e1 / 0.32e2 * t469 * t2850 + t484 * t2853 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2856 + t484 * t2860 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t2846 + t484 * t2866 / 0.8e1 - t484 * t2869 / 0.8e1 - t469 * t2872 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2875;
  t2880 = t255 * t810 / 0.32e2;
  t2882 = t255 * t800 / 0.64e2;
  t2884 = t255 * t804 / 0.32e2;
  t2888 = t1000 * t798 * t269;
  t2898 = t255 * t807 / 0.32e2;
  t2899 = -t2240 + t2254 + t2277 - t2281 + t2880 - t2882 - t2884 - t246 * t800 / 0.32e2 - t99 * t2888 / 0.32e2 - t246 * t804 / 0.16e2 + t246 * t807 / 0.16e2 + t246 * t810 / 0.16e2 + t2898 - t2314 - t2324;
  t2901 = my_piecewise3(t2, 0, t2878 + t2899);
  tv3rholapl20 = t3 * t2901 + t814;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2906 = t370 * t817 / 0.64e2;
  t2910 = t370 * t821 / 0.32e2;
  t2914 = t370 * t824 / 0.32e2;
  t2918 = t370 * t827 / 0.32e2;
  t2920 = my_piecewise3(t51, 0, -t367 * t817 / 0.32e2 - t2906 - t2336 - t2338 - t367 * t821 / 0.16e2 - t2910 + t367 * t824 / 0.16e2 + t2914 + t367 * t827 / 0.16e2 + t2918);
  tv3rholapl22 = t3 * t2920 + t831;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2931 = my_piecewise3(t2, 0, -t345 * t800 / 0.32e2 - t2882 - t2357 - t2314 - t345 * t804 / 0.16e2 - t2884 + t345 * t807 / 0.16e2 + t2898 + t345 * t810 / 0.16e2 + t2880);
  tv3rholapl23 = t3 * t2931 + t814;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2933 = t815 * t168;
  t2934 = t2933 * t1361;
  t2937 = t815 * t418;
  t2938 = t2937 * t2381;
  t2941 = t815 * t1370;
  t2942 = t2941 * t2372;
  t2945 = t2937 * t2372;
  t2948 = t2941 * t2377;
  t2951 = t615 * t1933;
  t2954 = t815 * t75;
  t2955 = t2954 * t2397;
  t2958 = t540 * t602;
  t2959 = t611 * t2958;
  t2964 = t546 * t602;
  t2965 = t615 * t2964;
  t2968 = t2954 * t2390;
  t2971 = t611 * t1933;
  t2974 = t2937 * t2397;
  t2977 = -t721 - t534 * t2934 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2938 + 0.3e1 / 0.32e2 * t519 * t2942 + t534 * t2945 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2948 - t534 * t2951 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2955 + t534 * t2959 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t2938 + t534 * t2965 / 0.8e1 - t534 * t2968 / 0.8e1 - t519 * t2971 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2974;
  t2979 = t1329 * t815 * t424;
  t2990 = t2370 + t2404 - t2408 - t2423 - t156 * t2979 / 0.32e2 - t409 * t821 / 0.16e2 + t409 * t824 / 0.16e2 + t409 * t827 / 0.16e2 - t409 * t817 / 0.32e2 - t2906 - t2910 + t2914 + t2918 - t2440 - t2338;
  t2992 = my_piecewise3(t51, 0, t2977 + t2990);
  tv3rholapl25 = t3 * t2992 + t831;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  t2994 = t1735 * t935;
  t2995 = t2994 * t2664;
  t2998 = t835 * t263;
  t2999 = t2998 * t2247;
  t3002 = t2668 * t2467;
  t3006 = t835 * t111 * t1031;
  t3009 = t2455 * t2664;
  t3012 = t835 * t43;
  t3013 = t3012 * t2270;
  t3018 = t2659 * t2467;
  t3021 = t572 * t265;
  t3022 = t3021 * t2664;
  t3025 = t640 * t2859;
  t3030 = t2013 * t843;
  t3033 = t644 * t2865;
  t3040 = 0.3e1 / 0.32e2 * t469 * t2995 + t484 * t2999 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3002 - t484 * t3006 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3009 + 0.3e1 / 0.16e2 * t484 * t3013 - 0.3e1 / 0.16e2 * t484 * t3009 - t484 * t3018 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3022 - t699 + t484 * t3025 / 0.16e2 + t1415 * t844 / 0.16e2 + t484 * t3030 / 0.16e2 + t484 * t3033 / 0.16e2 - t1493 * t832 / 0.32e2 - t1503 * t832 / 0.32e2;
  t3041 = t1771 * t626;
  t3044 = t572 * t2009;
  t3050 = t1419 * t836 / 0.32e2;
  t3052 = t1419 * t840 / 0.32e2;
  t3054 = t1419 * t844 / 0.32e2;
  t3056 = t1499 * t832 / 0.64e2;
  t3057 = t631 * t199;
  t3058 = t3057 * t290;
  t3061 = t213 * t563;
  t3062 = t3061 * t290;
  t3067 = t2050 * t839;
  t3070 = -t469 * t3041 / 0.32e2 - t469 * t3044 / 0.32e2 - t1415 * t836 / 0.16e2 - t3050 + t3052 + t3054 - t3056 - t484 * t3058 / 0.16e2 - t484 * t3062 / 0.16e2 + t1415 * t840 / 0.16e2 + t484 * t3067 / 0.16e2 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t3072 = my_piecewise3(t2, 0, t3040 + t3070);
  tv3rholapltau0 = t3 * t3072 + t848;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  t3077 = t1578 * t849 / 0.64e2;
  t3081 = t1589 * t853 / 0.32e2;
  t3085 = t1589 * t857 / 0.32e2;
  t3089 = t1589 * t861 / 0.32e2;
  t3091 = my_piecewise3(t51, 0, -t1574 * t849 / 0.32e2 - t3077 - t2336 - t2338 - t1585 * t853 / 0.16e2 - t3081 + t1585 * t857 / 0.16e2 + t3085 + t1585 * t861 / 0.16e2 + t3089);
  tv3rholapltau3 = t3 * t3091 + t865;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  t3102 = my_piecewise3(t2, 0, -t1548 * t832 / 0.32e2 - t3056 - t2357 - t2314 - t1553 * t836 / 0.16e2 - t3050 + t1553 * t840 / 0.16e2 + t3052 + t1553 * t844 / 0.16e2 + t3054);
  tv3rholapltau4 = t3 * t3102 + t848;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  t3105 = t852 * t168 * t1361;
  t3108 = t611 * t450;
  t3109 = t3108 * t2761;
  t3112 = t1964 * t1372;
  t3113 = t3112 * t2761;
  t3116 = t852 * t418;
  t3117 = t3116 * t2372;
  t3120 = t2779 * t2570;
  t3123 = t852 * t75;
  t3124 = t3123 * t2397;
  t3129 = t2789 * t2570;
  t3132 = t611 * t420;
  t3133 = t3132 * t2761;
  t3136 = t670 * t207;
  t3137 = t3136 * t445;
  t3140 = t219 * t602;
  t3141 = t3140 * t445;
  t3146 = t2193 * t856;
  t3149 = t679 * t2958;
  t3154 = -t534 * t3105 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3109 + 0.3e1 / 0.32e2 * t519 * t3113 + t534 * t3117 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3120 + 0.3e1 / 0.16e2 * t534 * t3124 - 0.3e1 / 0.16e2 * t534 * t3109 - t534 * t3129 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3133 - t721 - t534 * t3137 / 0.16e2 - t534 * t3141 / 0.16e2 + t1678 * t857 / 0.16e2 + t534 * t3146 / 0.16e2 + t534 * t3149 / 0.16e2 + t1678 * t861 / 0.16e2;
  t3155 = t2212 * t860;
  t3158 = t683 * t2964;
  t3165 = t1907 * t665;
  t3168 = t611 * t2181;
  t3173 = t534 * t3155 / 0.16e2 + t534 * t3158 / 0.16e2 - t1681 * t849 / 0.32e2 - t1655 * t849 / 0.32e2 - t519 * t3165 / 0.32e2 - t519 * t3168 / 0.32e2 - t1678 * t853 / 0.16e2 - t3081 + t3085 + t3089 - t3077 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t3175 = my_piecewise3(t51, 0, t3154 + t3173);
  tv3rholapltau7 = t3 * t3175 + t865;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3177 = t866 * t111;
  t3178 = t3177 * t1031;
  t3181 = t866 * t263;
  t3182 = t3181 * t2242;
  t3185 = t866 * t943;
  t3186 = t3185 * t2247;
  t3189 = t3181 * t2247;
  t3192 = t3185 * t2258;
  t3196 = t644 * t496 * t631;
  t3199 = t866 * t43;
  t3200 = t3199 * t2263;
  t3203 = t640 * t2009;
  t3206 = t3181 * t2270;
  t3209 = t644 * t2009;
  t3212 = t3199 * t2270;
  t3216 = t640 * t490 * t631;
  t3221 = -t699 - t484 * t3178 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3182 + 0.3e1 / 0.32e2 * t469 * t3186 + t484 * t3189 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3192 + t484 * t3196 / 0.8e1 - t484 * t3200 / 0.8e1 - t469 * t3203 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3206 - t484 * t3209 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3212 + t484 * t3216 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t3182;
  t3223 = t255 * t878 / 0.32e2;
  t3225 = t255 * t872 / 0.32e2;
  t3227 = t255 * t875 / 0.32e2;
  t3229 = t255 * t868 / 0.64e2;
  t3235 = t1000 * t866 * t269;
  t3242 = -t2240 + t2254 + t2277 - t2281 + t3223 - t3225 + t3227 - t3229 + t246 * t878 / 0.16e2 - t246 * t868 / 0.32e2 - t99 * t3235 / 0.32e2 - t246 * t872 / 0.16e2 + t246 * t875 / 0.16e2 - t2314 - t2324;
  t3244 = my_piecewise3(t2, 0, t3221 + t3242);
  tv3rhotau20 = t3 * t3244 + t882;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3249 = t370 * t885 / 0.64e2;
  t3253 = t370 * t889 / 0.32e2;
  t3257 = t370 * t892 / 0.32e2;
  t3261 = t370 * t895 / 0.32e2;
  t3263 = my_piecewise3(t51, 0, -t367 * t885 / 0.32e2 - t3249 - t2336 - t2338 - t367 * t889 / 0.16e2 - t3253 + t367 * t892 / 0.16e2 + t3257 + t367 * t895 / 0.16e2 + t3261);
  tv3rhotau22 = t3 * t3263 + t899;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3274 = my_piecewise3(t2, 0, -t345 * t868 / 0.32e2 - t3229 - t2357 - t2314 - t345 * t872 / 0.16e2 - t3225 + t345 * t875 / 0.16e2 + t3227 + t345 * t878 / 0.16e2 + t3223);
  tv3rhotau23 = t3 * t3274 + t882;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3276 = t883 * t1370;
  t3277 = t3276 * t2377;
  t3281 = t679 * t540 * t670;
  t3284 = t883 * t418;
  t3285 = t3284 * t2381;
  t3289 = t683 * t546 * t670;
  t3292 = t883 * t75;
  t3293 = t3292 * t2390;
  t3296 = t679 * t2181;
  t3299 = t3284 * t2397;
  t3302 = t883 * t168;
  t3303 = t3302 * t1361;
  t3308 = t3276 * t2372;
  t3311 = t3284 * t2372;
  t3314 = t683 * t2181;
  t3317 = t3292 * t2397;
  t3320 = -t721 - 0.3e1 / 0.16e2 * t534 * t3277 + t534 * t3281 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t3285 + t534 * t3289 / 0.8e1 - t534 * t3293 / 0.8e1 - t519 * t3296 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t3299 - t534 * t3303 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3285 + 0.3e1 / 0.32e2 * t519 * t3308 + t534 * t3311 / 0.4e1 - t534 * t3314 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t3317;
  t3324 = t1329 * t883 * t424;
  t3333 = t2370 + t2404 - t2408 - t2423 + t3257 + t3261 - t409 * t885 / 0.32e2 - t156 * t3324 / 0.32e2 - t409 * t889 / 0.16e2 + t409 * t892 / 0.16e2 + t409 * t895 / 0.16e2 - t3249 - t3253 - t2440 - t2338;
  t3335 = my_piecewise3(t51, 0, t3320 + t3333);
  tv3rhotau25 = t3 * t3335 + t899;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3337 = t690 * t183;
  t3338 = t100 * t3337;
  t3339 = t3338 * t956;
  t3342 = t3338 * t960;
  t3345 = t489 * t2278;
  t3346 = t469 * t3345;
  t3347 = 0.3e1 / 0.32e2 * t3346;
  t3348 = t260 * t3337;
  t3349 = t3348 * t964;
  t3352 = t2274 * t745;
  t3353 = t484 * t3352;
  t3354 = 0.3e1 / 0.16e2 * t3353;
  t3355 = t3338 * t968;
  t3358 = t993 * t183;
  t3360 = t996 * t183;
  t3363 = t3358 * t116 / 0.2e1 - t3360 * t116 / 0.2e1 + t185 / 0.2e1;
  t3365 = t3363 * t690 * t269;
  t3368 = t695 * t183;
  t3369 = t3368 * t290;
  t3370 = t484 * t3369;
  t3371 = 0.3e1 / 0.16e2 * t3370;
  t3372 = t3338 * t1031;
  t3375 = t3348 * t956;
  t3378 = t3348 * t1036;
  t3381 = t2251 * t741;
  t3382 = t484 * t3381;
  t3383 = 0.3e1 / 0.16e2 * t3382;
  t3384 = t3338 * t939;
  t3387 = t3338 * t947;
  t3390 = -0.3e1 / 0.16e2 * t99 * t3339 - t99 * t3342 / 0.8e1 - t3347 + 0.3e1 / 0.32e2 * t99 * t3349 + t3354 + 0.3e1 / 0.16e2 * t99 * t3355 - t99 * t3365 / 0.32e2 - t3371 - t99 * t3372 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3375 + 0.3e1 / 0.32e2 * t99 * t3378 + t3383 + t99 * t3384 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3387 - t699;
  t3391 = my_piecewise3(t2, 0, t3390);
  tv3sigma30 = t3 * t3391;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3392 = t712 * t191;
  t3393 = t157 * t3392;
  t3394 = t3393 * t1366;
  t3397 = t3393 * t1399;
  t3400 = t539 * t2405;
  t3401 = t519 * t3400;
  t3402 = 0.3e1 / 0.32e2 * t3401;
  t3403 = t415 * t3392;
  t3404 = t3403 * t1405;
  t3407 = t2401 * t762;
  t3408 = t534 * t3407;
  t3409 = 0.3e1 / 0.16e2 * t3408;
  t3410 = t3393 * t1392;
  t3413 = t1322 * t191;
  t3415 = t1325 * t191;
  t3418 = t3413 * t173 / 0.2e1 - t3415 * t173 / 0.2e1 + t193 / 0.2e1;
  t3420 = t3418 * t712 * t424;
  t3423 = t717 * t191;
  t3424 = t3423 * t445;
  t3425 = t534 * t3424;
  t3426 = 0.3e1 / 0.16e2 * t3425;
  t3427 = t3393 * t1361;
  t3430 = t3403 * t1366;
  t3433 = t3403 * t1374;
  t3436 = t2367 * t758;
  t3437 = t534 * t3436;
  t3438 = 0.3e1 / 0.16e2 * t3437;
  t3439 = t3393 * t1379;
  t3442 = t3393 * t1386;
  t3445 = -0.3e1 / 0.16e2 * t156 * t3394 - t156 * t3397 / 0.8e1 - t3402 + 0.3e1 / 0.32e2 * t156 * t3404 + t3409 + 0.3e1 / 0.16e2 * t156 * t3410 - t156 * t3420 / 0.32e2 - t3426 - t156 * t3427 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3430 + 0.3e1 / 0.32e2 * t156 * t3433 + t3438 + t156 * t3439 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3442 - t721;
  t3446 = my_piecewise3(t51, 0, t3445);
  tv3sigma39 = t3 * t3446;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3447 = t496 * t695;
  t3448 = t576 * t3447;
  t3449 = t484 * t3448;
  t3450 = t3449 / 0.16e2;
  t3451 = t2251 * t558;
  t3452 = t469 * t3451;
  t3453 = t3452 / 0.32e2;
  t3454 = t199 * t695;
  t3455 = t3454 * t290;
  t3456 = t484 * t3455;
  t3457 = t3456 / 0.16e2;
  t3458 = t490 * t695;
  t3459 = t572 * t3458;
  t3460 = t484 * t3459;
  t3461 = t3460 / 0.16e2;
  t3462 = t26 * t3363;
  t3463 = t23 * t3462;
  t3466 = t3346 / 0.16e2;
  t3467 = t3353 / 0.8e1;
  t3468 = t199 * t690;
  t3469 = t3468 * t968;
  t3472 = t1458 * t690;
  t3473 = t572 * t3472;
  t3476 = t1463 * t690;
  t3477 = t576 * t3476;
  t3480 = t2241 * t1787;
  t3483 = t3370 / 0.8e1;
  t3484 = t3468 * t1031;
  t3487 = t3382 / 0.8e1;
  t3490 = t2246 * t1743;
  t3493 = t3468 * t939;
  t3496 = t1525 * t690;
  t3497 = t1735 * t3496;
  t3500 = t3450 - t3453 - t3457 + t3461 - t3463 * t734 / 0.32e2 - t3466 + t3467 + 0.3e1 / 0.16e2 * t484 * t3469 - 0.3e1 / 0.16e2 * t484 * t3473 - t484 * t3477 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3480 - t3483 - t484 * t3484 / 0.16e2 + t3487 - 0.3e1 / 0.32e2 * t469 * t3473 + 0.3e1 / 0.32e2 * t469 * t3490 + t484 * t3493 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3497 - t699;
  t3501 = my_piecewise3(t2, 0, t3500);
  tv3sigma2lapl0 = t3 * t3501;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3502 = t207 * t717;
  t3503 = t3502 * t445;
  t3504 = t534 * t3503;
  t3505 = t3504 / 0.16e2;
  t3506 = t540 * t717;
  t3507 = t611 * t3506;
  t3508 = t534 * t3507;
  t3509 = t3508 / 0.16e2;
  t3510 = t546 * t717;
  t3511 = t615 * t3510;
  t3512 = t534 * t3511;
  t3513 = t3512 / 0.16e2;
  t3514 = t26 * t3418;
  t3515 = t60 * t3514;
  t3518 = t2367 * t597;
  t3519 = t519 * t3518;
  t3520 = t3519 / 0.32e2;
  t3521 = t3401 / 0.16e2;
  t3522 = t3408 / 0.8e1;
  t3523 = t2371 * t1954;
  t3526 = t207 * t712;
  t3527 = t3526 * t1392;
  t3530 = t1623 * t712;
  t3531 = t611 * t3530;
  t3534 = t1701 * t712;
  t3535 = t615 * t3534;
  t3538 = t3425 / 0.8e1;
  t3539 = t3526 * t1361;
  t3542 = t3437 / 0.8e1;
  t3545 = t2376 * t1970;
  t3548 = t3526 * t1379;
  t3551 = t1639 * t712;
  t3552 = t1964 * t3551;
  t3555 = -t3505 + t3509 + t3513 - t3515 * t751 / 0.32e2 - t3520 - t3521 + t3522 + 0.3e1 / 0.32e2 * t519 * t3523 + 0.3e1 / 0.16e2 * t534 * t3527 - 0.3e1 / 0.16e2 * t534 * t3531 - t534 * t3535 / 0.8e1 - t3538 - t534 * t3539 / 0.16e2 + t3542 - 0.3e1 / 0.32e2 * t519 * t3531 + 0.3e1 / 0.32e2 * t519 * t3545 + t534 * t3548 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3552 - t721;
  t3556 = my_piecewise3(t51, 0, t3555);
  tv3sigma2lapl11 = t3 * t3556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3557 = t640 * t3458;
  t3558 = t484 * t3557;
  t3559 = t3558 / 0.16e2;
  t3560 = t644 * t3447;
  t3561 = t484 * t3560;
  t3562 = t3561 / 0.16e2;
  t3565 = t2251 * t626;
  t3566 = t469 * t3565;
  t3567 = t3566 / 0.32e2;
  t3568 = t213 * t695;
  t3569 = t3568 * t290;
  t3570 = t484 * t3569;
  t3571 = t3570 / 0.16e2;
  t3572 = t2241 * t1992;
  t3575 = t213 * t690;
  t3576 = t3575 * t968;
  t3579 = t640 * t3472;
  t3582 = t644 * t3476;
  t3585 = t3575 * t1031;
  t3590 = t2246 * t1998;
  t3593 = t3575 * t939;
  t3596 = t2005 * t3496;
  t3599 = t3559 + t3562 - t3463 * t768 / 0.32e2 - t3567 - t3571 - t3466 + t3467 + 0.3e1 / 0.32e2 * t469 * t3572 + 0.3e1 / 0.16e2 * t484 * t3576 - 0.3e1 / 0.16e2 * t484 * t3579 - t484 * t3582 / 0.8e1 - t3483 - t484 * t3585 / 0.16e2 + t3487 - 0.3e1 / 0.32e2 * t469 * t3579 + 0.3e1 / 0.32e2 * t469 * t3590 + t484 * t3593 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3596 - t699;
  t3600 = my_piecewise3(t2, 0, t3599);
  tv3sigma2tau0 = t3 * t3600;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3601 = t683 * t3510;
  t3602 = t534 * t3601;
  t3603 = t3602 / 0.16e2;
  t3606 = t2367 * t665;
  t3607 = t519 * t3606;
  t3608 = t3607 / 0.32e2;
  t3609 = t219 * t717;
  t3610 = t3609 * t445;
  t3611 = t534 * t3610;
  t3612 = t3611 / 0.16e2;
  t3613 = t679 * t3506;
  t3614 = t534 * t3613;
  t3615 = t3614 / 0.16e2;
  t3616 = t2371 * t2146;
  t3619 = t219 * t712;
  t3620 = t3619 * t1392;
  t3623 = t679 * t3530;
  t3626 = t683 * t3534;
  t3629 = t3619 * t1361;
  t3634 = t2376 * t2158;
  t3637 = t3619 * t1379;
  t3640 = t2165 * t3551;
  t3643 = t3603 - t3515 * t783 / 0.32e2 - t3608 - t3612 + t3615 - t3521 + t3522 + 0.3e1 / 0.32e2 * t519 * t3616 + 0.3e1 / 0.16e2 * t534 * t3620 - 0.3e1 / 0.16e2 * t534 * t3623 - t534 * t3626 / 0.8e1 - t3538 - t534 * t3629 / 0.16e2 + t3542 - 0.3e1 / 0.32e2 * t519 * t3623 + 0.3e1 / 0.32e2 * t519 * t3634 + t534 * t3637 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3640 - t721;
  t3644 = my_piecewise3(t51, 0, t3643);
  tv3sigma2tau11 = t3 * t3644;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3645 = t2837 * t1471;
  t3648 = t1458 * t183;
  t3649 = t2845 * t3648;
  t3652 = t1463 * t183;
  t3653 = t2837 * t3652;
  t3656 = t2845 * t1471;
  t3659 = t3449 / 0.8e1;
  t3660 = t3452 / 0.16e2;
  t3661 = t3456 / 0.8e1;
  t3662 = t3460 / 0.8e1;
  t3663 = t3346 / 0.32e2;
  t3664 = t3353 / 0.16e2;
  t3666 = t3363 * t798 * t269;
  t3669 = t798 * t183;
  t3670 = t3669 * t1031;
  t3673 = t3370 / 0.16e2;
  t3676 = t2849 * t1517;
  t3679 = t2845 * t1517;
  t3682 = t1525 * t183;
  t3683 = t2849 * t3682;
  t3686 = t3382 / 0.16e2;
  t3687 = 0.3e1 / 0.16e2 * t484 * t3645 - 0.3e1 / 0.16e2 * t484 * t3649 - t484 * t3653 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3656 + t3659 - t3660 - t3661 + t3662 - t3663 + t3664 - t99 * t3666 / 0.32e2 - t484 * t3670 / 0.16e2 - t3673 - 0.3e1 / 0.32e2 * t469 * t3649 + 0.3e1 / 0.32e2 * t469 * t3676 + t484 * t3679 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3683 + t3686 - t699;
  t3688 = my_piecewise3(t2, 0, t3687);
  tv3sigmalapl20 = t3 * t3688;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3689 = t2954 * t1707;
  t3692 = t2937 * t1624;
  t3695 = t1701 * t191;
  t3696 = t2954 * t3695;
  t3699 = t2937 * t1707;
  t3702 = t3504 / 0.8e1;
  t3703 = t3508 / 0.8e1;
  t3704 = t3512 / 0.8e1;
  t3705 = t3519 / 0.16e2;
  t3706 = t3401 / 0.32e2;
  t3707 = t3408 / 0.16e2;
  t3709 = t3418 * t815 * t424;
  t3712 = t815 * t191;
  t3713 = t3712 * t1361;
  t3716 = t3425 / 0.16e2;
  t3717 = t2937 * t1630;
  t3720 = t1639 * t191;
  t3721 = t2941 * t3720;
  t3726 = t2941 * t1630;
  t3729 = t3437 / 0.16e2;
  t3730 = 0.3e1 / 0.16e2 * t534 * t3689 - 0.3e1 / 0.16e2 * t534 * t3692 - t534 * t3696 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3699 - t3702 + t3703 + t3704 - t3705 - t3706 + t3707 - t156 * t3709 / 0.32e2 - t534 * t3713 / 0.16e2 - t3716 + t534 * t3717 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3721 - 0.3e1 / 0.32e2 * t519 * t3692 + 0.3e1 / 0.32e2 * t519 * t3726 + t3729 - t721;
  t3731 = my_piecewise3(t51, 0, t3730);
  tv3sigmalapl28 = t3 * t3731;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  t3734 = -t3463 * t832 / 0.32e2 + t3559 + t3562 - t3567 - t3571 + t3450 - t3453 - t3457 + t3461 - t3663 + t3664;
  t3735 = t3012 * t1471;
  t3738 = t2466 * t183;
  t3739 = t2655 * t3738;
  t3742 = t2659 * t3738;
  t3745 = t2663 * t183;
  t3746 = t3021 * t3745;
  t3749 = t835 * t183;
  t3750 = t3749 * t1031;
  t3753 = t2994 * t3745;
  t3756 = t2998 * t1517;
  t3759 = t2668 * t3738;
  t3764 = 0.3e1 / 0.16e2 * t484 * t3735 - 0.3e1 / 0.16e2 * t484 * t3739 - t484 * t3742 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3746 - t3673 - t484 * t3750 / 0.16e2 + t3686 + 0.3e1 / 0.32e2 * t469 * t3753 + t484 * t3756 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3759 - 0.3e1 / 0.32e2 * t469 * t3739 - t699;
  t3766 = my_piecewise3(t2, 0, t3734 + t3764);
  tv3sigmalapltau0 = t3 * t3766;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  t3769 = -t3515 * t849 / 0.32e2 + t3603 - t3608 - t3612 + t3615 - t3505 + t3509 + t3513 - t3520 - t3706 + t3707;
  t3770 = t2569 * t191;
  t3771 = t2789 * t3770;
  t3774 = t2760 * t191;
  t3775 = t3132 * t3774;
  t3778 = t3123 * t1707;
  t3781 = t679 * t450;
  t3782 = t3781 * t3770;
  t3785 = t852 * t191;
  t3786 = t3785 * t1361;
  t3791 = t3112 * t3774;
  t3794 = t3116 * t1630;
  t3797 = t2779 * t3770;
  t3800 = -t534 * t3771 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3775 + 0.3e1 / 0.16e2 * t534 * t3778 - 0.3e1 / 0.16e2 * t534 * t3782 - t3716 - t534 * t3786 / 0.16e2 + t3729 - 0.3e1 / 0.32e2 * t519 * t3782 + 0.3e1 / 0.32e2 * t519 * t3791 + t534 * t3794 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3797 - t721;
  t3802 = my_piecewise3(t51, 0, t3769 + t3800);
  tv3sigmalapltau11 = t3 * t3802;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3803 = t3199 * t3652;
  t3806 = t3199 * t1471;
  t3809 = t3181 * t3648;
  t3812 = t3181 * t1471;
  t3815 = t3558 / 0.8e1;
  t3816 = t3561 / 0.8e1;
  t3817 = t3566 / 0.16e2;
  t3818 = t3570 / 0.8e1;
  t3820 = t3363 * t866 * t269;
  t3823 = t866 * t183;
  t3824 = t3823 * t1031;
  t3829 = t3185 * t1517;
  t3832 = t3181 * t1517;
  t3835 = t3185 * t3682;
  t3838 = -t484 * t3803 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3806 - 0.3e1 / 0.16e2 * t484 * t3809 + 0.3e1 / 0.32e2 * t469 * t3812 + t3815 + t3816 - t3817 - t3818 - t3663 + t3664 - t99 * t3820 / 0.32e2 - t484 * t3824 / 0.16e2 - t3673 - 0.3e1 / 0.32e2 * t469 * t3809 + 0.3e1 / 0.32e2 * t469 * t3829 + t484 * t3832 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3835 + t3686 - t699;
  t3839 = my_piecewise3(t2, 0, t3838);
  tv3sigmatau20 = t3 * t3839;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3840 = t3292 * t1707;
  t3843 = t3284 * t1624;
  t3846 = t3292 * t3695;
  t3849 = t3284 * t1707;
  t3852 = t3602 / 0.8e1;
  t3853 = t3607 / 0.16e2;
  t3854 = t3611 / 0.8e1;
  t3855 = t3614 / 0.8e1;
  t3857 = t3418 * t883 * t424;
  t3860 = t883 * t191;
  t3861 = t3860 * t1361;
  t3866 = t3276 * t1630;
  t3869 = t3284 * t1630;
  t3872 = t3276 * t3720;
  t3875 = 0.3e1 / 0.16e2 * t534 * t3840 - 0.3e1 / 0.16e2 * t534 * t3843 - t534 * t3846 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3849 + t3852 - t3853 - t3854 + t3855 - t3706 + t3707 - t156 * t3857 / 0.32e2 - t534 * t3861 / 0.16e2 - t3716 - 0.3e1 / 0.32e2 * t519 * t3843 + 0.3e1 / 0.32e2 * t519 * t3866 + t534 * t3869 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3872 + t3729 - t721;
  t3876 = my_piecewise3(t51, 0, t3875);
  tv3sigmatau28 = t3 * t3876;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3877 = t993 * t199;
  t3879 = t996 * t199;
  t3882 = t3877 * t116 / 0.2e1 - t3879 * t116 / 0.2e1 + t201 / 0.2e1;
  t3884 = t3882 * t798 * t269;
  t3887 = t798 * t199;
  t3888 = t100 * t3887;
  t3889 = t3888 * t956;
  t3892 = t3888 * t960;
  t3895 = t260 * t3887;
  t3896 = t3895 * t964;
  t3899 = t3888 * t968;
  t3902 = 0.3e1 / 0.16e2 * t3449;
  t3903 = 0.3e1 / 0.32e2 * t3452;
  t3904 = 0.3e1 / 0.16e2 * t3456;
  t3905 = 0.3e1 / 0.16e2 * t3460;
  t3906 = t3888 * t1031;
  t3909 = t3895 * t956;
  t3912 = t3895 * t1036;
  t3915 = t3888 * t939;
  t3918 = t3888 * t947;
  t3921 = -t99 * t3884 / 0.32e2 - 0.3e1 / 0.16e2 * t99 * t3889 - t99 * t3892 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t3896 + 0.3e1 / 0.16e2 * t99 * t3899 + t3902 - t3903 - t3904 + t3905 - t99 * t3906 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3909 + 0.3e1 / 0.32e2 * t99 * t3912 + t99 * t3915 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3918 - t699;
  t3922 = my_piecewise3(t2, 0, t3921);
  tv3lapl30 = t3 * t3922;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3923 = t1322 * t207;
  t3925 = t1325 * t207;
  t3928 = t3923 * t173 / 0.2e1 - t3925 * t173 / 0.2e1 + t209 / 0.2e1;
  t3930 = t3928 * t815 * t424;
  t3933 = t815 * t207;
  t3934 = t157 * t3933;
  t3935 = t3934 * t1366;
  t3938 = t3934 * t1399;
  t3941 = t415 * t3933;
  t3942 = t3941 * t1405;
  t3945 = t3934 * t1392;
  t3948 = 0.3e1 / 0.16e2 * t3504;
  t3949 = 0.3e1 / 0.16e2 * t3508;
  t3950 = 0.3e1 / 0.16e2 * t3512;
  t3951 = 0.3e1 / 0.32e2 * t3519;
  t3952 = t3934 * t1361;
  t3955 = t3941 * t1366;
  t3958 = t3941 * t1374;
  t3961 = t3934 * t1379;
  t3964 = t3934 * t1386;
  t3967 = -t156 * t3930 / 0.32e2 - 0.3e1 / 0.16e2 * t156 * t3935 - t156 * t3938 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t3942 + 0.3e1 / 0.16e2 * t156 * t3945 - t3948 + t3949 + t3950 - t3951 - t156 * t3952 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3955 + 0.3e1 / 0.32e2 * t156 * t3958 + t156 * t3961 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3964 - t721;
  t3968 = my_piecewise3(t51, 0, t3967);
  tv3lapl33 = t3 * t3968;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  t3969 = t26 * t3882;
  t3970 = t23 * t3969;
  t3973 = t213 * t798;
  t3974 = t3973 * t968;
  t3977 = t1458 * t798;
  t3978 = t640 * t3977;
  t3981 = t1463 * t798;
  t3982 = t644 * t3981;
  t3985 = t2845 * t1992;
  t3988 = t3973 * t1031;
  t3993 = t2849 * t1998;
  t3996 = t3973 * t939;
  t3999 = t1525 * t798;
  t4000 = t2005 * t3999;
  t4003 = -t3970 * t832 / 0.32e2 + t3559 + t3562 - t3567 - t3571 + t3659 - t3660 - t3661 + t3662 + 0.3e1 / 0.16e2 * t484 * t3974 - 0.3e1 / 0.16e2 * t484 * t3978 - t484 * t3982 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3985 - t484 * t3988 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3978 + 0.3e1 / 0.32e2 * t469 * t3993 + t484 * t3996 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t4000 - t699;
  t4004 = my_piecewise3(t2, 0, t4003);
  tv3lapl2tau0 = t3 * t4004;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  t4005 = t26 * t3928;
  t4006 = t60 * t4005;
  t4009 = t219 * t815;
  t4010 = t4009 * t1392;
  t4014 = t679 * t1623 * t815;
  t4017 = t1701 * t815;
  t4018 = t683 * t4017;
  t4021 = t2937 * t2146;
  t4024 = t4009 * t1361;
  t4029 = t2941 * t2158;
  t4032 = t4009 * t1379;
  t4035 = t1639 * t815;
  t4036 = t2165 * t4035;
  t4039 = -t4006 * t849 / 0.32e2 + t3603 - t3608 - t3612 + t3615 - t3702 + t3703 + t3704 - t3705 + 0.3e1 / 0.16e2 * t534 * t4010 - 0.3e1 / 0.16e2 * t534 * t4014 - t534 * t4018 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t4021 - t534 * t4024 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4014 + 0.3e1 / 0.32e2 * t519 * t4029 + t534 * t4032 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4036 - t721;
  t4040 = my_piecewise3(t51, 0, t4039);
  tv3lapl2tau5 = t3 * t4040;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  t4042 = t3882 * t866 * t269;
  t4045 = t3199 * t1787;
  t4048 = t3181 * t1739;
  t4052 = t3199 * t1463 * t199;
  t4055 = t3181 * t1787;
  t4058 = t866 * t199;
  t4059 = t4058 * t1031;
  t4064 = t3185 * t1743;
  t4067 = t3181 * t1743;
  t4071 = t3185 * t1525 * t199;
  t4074 = -t99 * t4042 / 0.32e2 + 0.3e1 / 0.16e2 * t484 * t4045 - 0.3e1 / 0.16e2 * t484 * t4048 - t484 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t4055 + t3815 + t3816 - t3817 - t3818 + t3450 - t3453 - t3457 + t3461 - t484 * t4059 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t4048 + 0.3e1 / 0.32e2 * t469 * t4064 + t484 * t4067 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t4071 - t699;
  t4075 = my_piecewise3(t2, 0, t4074);
  tv3lapltau20 = t3 * t4075;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  t4077 = t3928 * t883 * t424;
  t4081 = t3292 * t1701 * t207;
  t4084 = t3292 * t1954;
  t4088 = t3284 * t1623 * t207;
  t4091 = t3284 * t1954;
  t4094 = t883 * t207;
  t4095 = t4094 * t1361;
  t4100 = t3276 * t1970;
  t4103 = t3284 * t1970;
  t4107 = t3276 * t1639 * t207;
  t4110 = -t156 * t4077 / 0.32e2 - t534 * t4081 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t4084 - 0.3e1 / 0.16e2 * t534 * t4088 + 0.3e1 / 0.32e2 * t519 * t4091 + t3852 - t3853 - t3854 + t3855 - t3505 + t3509 + t3513 - t3520 - t534 * t4095 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4088 + 0.3e1 / 0.32e2 * t519 * t4100 + t534 * t4103 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4107 - t721;
  t4111 = my_piecewise3(t51, 0, t4110);
  tv3lapltau25 = t3 * t4111;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4112 = t993 * t213;
  t4114 = t996 * t213;
  t4117 = t4112 * t116 / 0.2e1 - t4114 * t116 / 0.2e1 + t215 / 0.2e1;
  t4119 = t4117 * t866 * t269;
  t4122 = t866 * t213;
  t4123 = t100 * t4122;
  t4124 = t4123 * t968;
  t4127 = t4123 * t956;
  t4130 = t4123 * t960;
  t4133 = t260 * t4122;
  t4134 = t4133 * t964;
  t4137 = 0.3e1 / 0.16e2 * t3558;
  t4138 = 0.3e1 / 0.16e2 * t3561;
  t4139 = 0.3e1 / 0.32e2 * t3566;
  t4140 = 0.3e1 / 0.16e2 * t3570;
  t4141 = t4123 * t1031;
  t4144 = t4133 * t956;
  t4147 = t4133 * t1036;
  t4150 = t4123 * t939;
  t4153 = t4123 * t947;
  t4156 = -t99 * t4119 / 0.32e2 + 0.3e1 / 0.16e2 * t99 * t4124 - 0.3e1 / 0.16e2 * t99 * t4127 - t99 * t4130 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t4134 + t4137 + t4138 - t4139 - t4140 - t99 * t4141 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t4144 + 0.3e1 / 0.32e2 * t99 * t4147 + t99 * t4150 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t4153 - t699;
  t4157 = my_piecewise3(t2, 0, t4156);
  tv3tau30 = t3 * t4157;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4158 = t1322 * t219;
  t4160 = t1325 * t219;
  t4163 = t4158 * t173 / 0.2e1 - t4160 * t173 / 0.2e1 + t221 / 0.2e1;
  t4165 = t4163 * t883 * t424;
  t4168 = t883 * t219;
  t4169 = t157 * t4168;
  t4170 = t4169 * t1366;
  t4173 = t4169 * t1399;
  t4176 = t415 * t4168;
  t4177 = t4176 * t1405;
  t4180 = t4169 * t1392;
  t4183 = 0.3e1 / 0.16e2 * t3602;
  t4184 = 0.3e1 / 0.32e2 * t3607;
  t4185 = 0.3e1 / 0.16e2 * t3611;
  t4186 = 0.3e1 / 0.16e2 * t3614;
  t4187 = t4169 * t1361;
  t4190 = t4176 * t1366;
  t4193 = t4176 * t1374;
  t4196 = t4169 * t1379;
  t4199 = t4169 * t1386;
  t4202 = -t156 * t4165 / 0.32e2 - 0.3e1 / 0.16e2 * t156 * t4170 - t156 * t4173 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t4177 + 0.3e1 / 0.16e2 * t156 * t4180 + t4183 - t4184 - t4185 + t4186 - t156 * t4187 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t4190 + 0.3e1 / 0.32e2 * t156 * t4193 + t156 * t4196 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t4199 - t721;
  t4203 = my_piecewise3(t51, 0, t4202);
  tv3tau33 = t3 * t4203;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;

  double t227, t228, t231, t232, t233, t236, t240, t241;
  double t244, t246, t251, t252, t254, t255, t256, t258;
  double t260, t261, t263, t264, t265, t266, t267, t268;
  double t269, t270, t278, t283, t285, t288, t289, t290;
  double t291, t294, t295, t296, t297, t298, t301, t302;
  double t306, t307, t308, t311, t314, t318, t319, t322;
  double t324, t326, t328, tv2rho20, t331, t335, t339, t340;
  double t343, t345, t351, t352, t356, t360, t361, t364;
  double t367, t370, t371, t374, tv2rho21, t379, t384, t388;
  double t389, t394, t395, t400, t404, t405, t409, t413;
  double t415, t416, t418, t419, t420, t421, t422, t423;
  double t424, t425, t433, t438, t440, t443, t444, t445;
  double t446, t449, t450, t451, t452, t453, t456, t457;
  double t461, tv2rho22, t467, t468, t469, t470, t471, t472;
  double t473, t476, t478, t480, t483, t484, t485, t486;
  double t489, t490, t491, t492, t495, t496, t497, t498;
  double t502, tv2rhosigma0, tv2rhosigma1, t507, t509, tv2rhosigma2, t514, tv2rhosigma3;
  double tv2rhosigma4, t518, t519, t520, t521, t522, t523, t526;
  double t528, t530, t533, t534, t535, t536, t539, t540;
  double t541, t542, t545, t546, t547, t548, t552, tv2rhosigma5;
  double t557, t558, t559, t563, t565, t568, t569, t572;
  double t573, t576, t577, t581, tv2rholapl0, t586, t588, tv2rholapl1;
  double t593, tv2rholapl2, t597, t598, t602, t604, t607, t608;
  double t611, t612, t615, t616, t620, tv2rholapl3, t625, t626;
  double t627, t631, t633, t636, t637, t640, t641, t644;
  double t645, t649, tv2rhotau0, t654, t656, tv2rhotau1, t661, tv2rhotau2;
  double t665, t666, t670, t672, t675, t676, t679, t680;
  double t683, t684, t688, tv2rhotau3, t690, t692, t695, t697;
  double t699, t700, t701, t704, t707, t711, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t712, t714, t717, t719, t721;
  double t722, t723, t726, t729, t733, tv2sigma25, t734, t737;
  double t738, t741, t742, t745, t746, t750, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t751, t754, t755, t758, t759;
  double t762, t763, t767, tv2sigmalapl5, t768, t771, t772, t775;
  double t778, t782, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t783;
  double t786, t787, t790, t793, t797, tv2sigmatau5, t798, t800;
  double t803, t804, t807, t810, t814, tv2lapl20, tv2lapl21, t815;
  double t817, t820, t821, t824, t827, t831, tv2lapl22, t832;
  double t835, t836, t839, t840, t843, t844, t848, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t849, t852, t853, t856, t857, t860;
  double t861, t865, tv2lapltau3, t866, t868, t871, t872, t875;
  double t878, t882, tv2tau20, tv2tau21, t883, t885, t888, t889;
  double t892, t895, t899, tv2tau22;

  double t902, t903, t906, t909, t910, t911, t914, t918;
  double t919, t924, t925, t927, t928, t930, t932, t933;
  double t934, t935, t936, t938, t939, t940, t943, t945;
  double t946, t947, t948, t953, t955, t956, t957, t960;
  double t961, t964, t965, t968, t969, t972, t977, t981;
  double t984, t985, t987, t989, t991, t992, t993, t996;
  double t1000, t1002, t1010, t1015, t1017, t1020, t1023, t1024;
  double t1028, t1030, t1031, t1032, t1035, t1036, t1037, t1041;
  double t1045, t1048, t1049, t1053, t1056, t1058, t1059, t1060;
  double t1063, t1066, t1069, t1073, t1074, t1077, t1079, t1081;
  double t1083, t1085, tv3rho30, t1088, t1089, t1093, t1096, t1101;
  double t1102, t1104, t1108, t1109, t1113, t1114, t1124, t1127;
  double t1129, t1138, t1139, t1140, t1143, t1148, t1150, t1154;
  double t1155, t1159, t1160, t1164, t1167, t1169, t1170, t1171;
  double t1174, tv3rho31, t1177, t1182, t1186, t1190, t1191, t1194;
  double t1196, t1203, t1204, t1209, t1213, t1217, t1218, t1221;
  double t1224, t1227, t1228, t1234, t1238, t1242, t1246, t1250;
  double t1252, t1253, tv3rho32, t1258, t1265, t1269, t1270, t1276;
  double t1279, t1286, t1290, t1291, t1298, t1302, t1306, t1309;
  double t1310, t1313, t1320, t1321, t1322, t1325, t1329, t1331;
  double t1339, t1344, t1346, t1349, t1356, t1357, t1358, t1360;
  double t1361, t1362, t1365, t1366, t1367, t1370, t1371, t1372;
  double t1373, t1374, t1375, t1378, t1379, t1380, t1384, t1385;
  double t1386, t1387, t1392, t1393, t1396, t1399, t1400, t1405;
  double t1406, t1409, t1411, tv3rho33, t1415, t1418, t1419, t1420;
  double t1422, t1425, t1430, t1432, t1434, t1436, t1440, t1445;
  double t1447, t1448, t1451, t1452, t1455, t1458, t1459, t1460;
  double t1463, t1464, t1465, t1468, t1469, t1470, t1471, t1472;
  double t1475, t1476, t1479, t1480, t1483, t1484, t1487, t1488;
  double t1493, t1496, t1498, t1499, t1500, t1502, t1503, t1506;
  double t1509, t1510, t1515, t1516, t1517, t1518, t1521, t1524;
  double t1525, t1526, t1527, t1530, t1532, tv3rho2sigma0, tv3rho2sigma1, t1537;
  double t1540, t1542, tv3rho2sigma2, t1546, t1548, t1553, t1566, t1567;
  double tv3rho2sigma3, tv3rho2sigma4, t1571, t1574, t1577, t1578, t1579, t1583;
  double t1585, t1588, t1589, t1590, t1594, t1598, t1600, t1601;
  double tv3rho2sigma5, t1608, tv3rho2sigma6, tv3rho2sigma7, t1611, t1613, t1615, t1622;
  double t1623, t1624, t1625, t1628, t1629, t1630, t1631, t1634;
  double t1635, t1638, t1639, t1640, t1641, t1650, t1651, t1654;
  double t1655, t1658, t1659, t1662, t1663, t1666, t1667, t1670;
  double t1671, t1674, t1675, t1678, t1681, t1685, t1692, t1693;
  double t1696, t1701, t1702, t1703, t1706, t1707, t1708, t1711;
  double t1714, t1716, tv3rho2sigma8, t1720, t1721, t1723, t1726, t1728;
  double t1735, t1736, t1739, t1740, t1743, t1744, t1747, t1750;
  double t1751, t1754, t1755, t1760, t1763, t1768, t1769, t1771;
  double t1772, t1775, t1776, t1779, t1784, t1787, t1788, t1791;
  double t1794, t1795, t1798, t1801, t1808, t1810, t1814, t1816;
  double tv3rho2lapl0, t1821, t1824, t1826, tv3rho2lapl1, t1830, t1848, t1849;
  double tv3rho2lapl2, t1853, t1858, t1862, t1866, t1870, t1874, t1876;
  double t1877, tv3rho2lapl3, t1884, tv3rho2lapl4, t1892, t1894, t1901, t1902;
  double t1907, t1908, t1911, t1912, t1915, t1916, t1919, t1922;
  double t1929, t1930, t1933, t1934, t1937, t1938, t1947, t1948;
  double t1951, t1954, t1955, t1958, t1961, t1964, t1965, t1970;
  double t1971, t1974, t1976, tv3rho2lapl5, t1979, t1980, t1983, t1986;
  double t1989, t1992, t1993, t1998, t1999, t2002, t2005, t2006;
  double t2009, t2010, t2013, t2014, t2017, t2018, t2021, t2028;
  double t2030, t2031, t2035, t2040, t2043, t2048, t2050, t2051;
  double t2054, t2057, t2062, t2065, t2067, t2070, t2073, t2075;
  double tv3rho2tau0, t2080, t2083, t2085, tv3rho2tau1, t2089, t2107, t2108;
  double tv3rho2tau2, t2112, t2117, t2121, t2125, t2129, t2133, t2135;
  double t2136, tv3rho2tau3, t2143, tv3rho2tau4, t2146, t2147, t2150, t2151;
  double t2155, t2158, t2159, t2162, t2165, t2166, t2169, t2178;
  double t2181, t2182, t2188, t2193, t2194, t2197, t2198, t2203;
  double t2209, t2212, t2213, t2216, t2217, t2228, t2230, t2233;
  double t2235, tv3rho2tau5, t2237, t2238, t2239, t2240, t2241, t2242;
  double t2243, t2246, t2247, t2248, t2251, t2252, t2253, t2254;
  double t2255, t2258, t2259, t2262, t2263, t2264, t2267, t2270;
  double t2271, t2274, t2275, t2276, t2277, t2278, t2279, t2280;
  double t2281, t2283, t2286, t2289, t2290, t2293, t2294, t2299;
  double t2300, t2308, t2310, t2312, t2313, t2314, t2316, t2320;
  double t2323, t2324, t2327, t2329, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23;
  double tv3rhosigma24, t2334, t2336, t2337, t2338, t2342, t2346, t2350;
  double t2352, tv3rhosigma25, t2357, t2365, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2367, t2368, t2369, t2370, t2371, t2372, t2373;
  double t2376, t2377, t2378, t2381, t2382, t2385, t2386, t2389;
  double t2390, t2391, t2394, t2397, t2398, t2401, t2402, t2403;
  double t2404, t2405, t2406, t2407, t2408, t2409, t2412, t2415;
  double t2416, t2419, t2420, t2421, t2422, t2423, t2425, t2430;
  double t2436, t2439, t2440, t2447, t2449, tv3rhosigma211, t2451, t2452;
  double t2455, t2456, t2457, t2458, t2461, t2462, t2465, t2466;
  double t2467, t2468, t2471, t2472, t2475, t2476, t2481, t2482;
  double t2485, t2486, t2490, t2493, t2500, t2503, t2504, t2508;
  double t2510, t2512, t2513, t2518, t2519, t2522, t2523, t2528;
  double t2531, t2534, t2536, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4;
  double t2541, t2545, t2549, t2553, t2555, tv3rhosigmalapl5, t2566, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2568, t2569, t2570, t2571;
  double t2574, t2575, t2578, t2579, t2582, t2583, t2584, t2585;
  double t2588, t2589, t2594, t2595, t2598, t2599, t2602, t2603;
  double t2610, t2613, t2616, t2619, t2622, t2625, t2626, t2629;
  double t2630, t2635, t2638, t2643, t2645, tv3rhosigmalapl11, t2647, t2648;
  double t2651, t2652, t2655, t2656, t2659, t2660, t2663, t2664;
  double t2665, t2668, t2669, t2674, t2677, t2678, t2681, t2686;
  double t2689, t2696, t2697, t2700, t2704, t2706, t2708, t2710;
  double t2713, t2714, t2717, t2718, t2723, t2726, t2728, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t2733, t2737, t2741, t2745;
  double t2747, tv3rhosigmatau5, t2758, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10;
  double t2760, t2761, t2762, t2765, t2766, t2769, t2772, t2775;
  double t2776, t2779, t2780, t2783, t2784, t2789, t2790, t2793;
  double t2794, t2799, t2802, t2807, t2810, t2811, t2818, t2821;
  double t2826, t2827, t2830, t2832, tv3rhosigmatau11, t2834, t2837, t2838;
  double t2841, t2842, t2845, t2846, t2849, t2850, t2853, t2856;
  double t2859, t2860, t2865, t2866, t2869, t2872, t2875, t2878;
  double t2880, t2882, t2884, t2888, t2898, t2899, t2901, tv3rholapl20;
  double tv3rholapl21, t2906, t2910, t2914, t2918, t2920, tv3rholapl22, t2931;
  double tv3rholapl23, tv3rholapl24, t2933, t2934, t2937, t2938, t2941, t2942;
  double t2945, t2948, t2951, t2954, t2955, t2958, t2959, t2964;
  double t2965, t2968, t2971, t2974, t2977, t2979, t2990, t2992;
  double tv3rholapl25, t2994, t2995, t2998, t2999, t3002, t3006, t3009;
  double t3012, t3013, t3018, t3021, t3022, t3025, t3030, t3033;
  double t3040, t3041, t3044, t3050, t3052, t3054, t3056, t3057;
  double t3058, t3061, t3062, t3067, t3070, t3072, tv3rholapltau0, tv3rholapltau1;
  double tv3rholapltau2, t3077, t3081, t3085, t3089, t3091, tv3rholapltau3, t3102;
  double tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, t3105, t3108, t3109, t3112, t3113;
  double t3116, t3117, t3120, t3123, t3124, t3129, t3132, t3133;
  double t3136, t3137, t3140, t3141, t3146, t3149, t3154, t3155;
  double t3158, t3165, t3168, t3173, t3175, tv3rholapltau7, t3177, t3178;
  double t3181, t3182, t3185, t3186, t3189, t3192, t3196, t3199;
  double t3200, t3203, t3206, t3209, t3212, t3216, t3221, t3223;
  double t3225, t3227, t3229, t3235, t3242, t3244, tv3rhotau20, tv3rhotau21;
  double t3249, t3253, t3257, t3261, t3263, tv3rhotau22, t3274, tv3rhotau23;
  double tv3rhotau24, t3276, t3277, t3281, t3284, t3285, t3289, t3292;
  double t3293, t3296, t3299, t3302, t3303, t3308, t3311, t3314;
  double t3317, t3320, t3324, t3333, t3335, tv3rhotau25, t3337, t3338;
  double t3339, t3342, t3345, t3346, t3347, t3348, t3349, t3352;
  double t3353, t3354, t3355, t3358, t3360, t3363, t3365, t3368;
  double t3369, t3370, t3371, t3372, t3375, t3378, t3381, t3382;
  double t3383, t3384, t3387, t3390, t3391, tv3sigma30, tv3sigma31, tv3sigma32;
  double tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t3392, t3393;
  double t3394, t3397, t3400, t3401, t3402, t3403, t3404, t3407;
  double t3408, t3409, t3410, t3413, t3415, t3418, t3420, t3423;
  double t3424, t3425, t3426, t3427, t3430, t3433, t3436, t3437;
  double t3438, t3439, t3442, t3445, t3446, tv3sigma39, t3447, t3448;
  double t3449, t3450, t3451, t3452, t3453, t3454, t3455, t3456;
  double t3457, t3458, t3459, t3460, t3461, t3462, t3463, t3466;
  double t3467, t3468, t3469, t3472, t3473, t3476, t3477, t3480;
  double t3483, t3484, t3487, t3490, t3493, t3496, t3497, t3500;
  double t3501, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6;
  double tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3502, t3503, t3504, t3505;
  double t3506, t3507, t3508, t3509, t3510, t3511, t3512, t3513;
  double t3514, t3515, t3518, t3519, t3520, t3521, t3522, t3523;
  double t3526, t3527, t3530, t3531, t3534, t3535, t3538, t3539;
  double t3542, t3545, t3548, t3551, t3552, t3555, t3556, tv3sigma2lapl11;
  double t3557, t3558, t3559, t3560, t3561, t3562, t3565, t3566;
  double t3567, t3568, t3569, t3570, t3571, t3572, t3575, t3576;
  double t3579, t3582, t3585, t3590, t3593, t3596, t3599, t3600;
  double tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7;
  double tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t3601, t3602, t3603, t3606, t3607;
  double t3608, t3609, t3610, t3611, t3612, t3613, t3614, t3615;
  double t3616, t3619, t3620, t3623, t3626, t3629, t3634, t3637;
  double t3640, t3643, t3644, tv3sigma2tau11, t3645, t3648, t3649, t3652;
  double t3653, t3656, t3659, t3660, t3661, t3662, t3663, t3664;
  double t3666, t3669, t3670, t3673, t3676, t3679, t3682, t3683;
  double t3686, t3687, t3688, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24;
  double tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t3689, t3692, t3695, t3696, t3699;
  double t3702, t3703, t3704, t3705, t3706, t3707, t3709, t3712;
  double t3713, t3716, t3717, t3720, t3721, t3726, t3729, t3730;
  double t3731, tv3sigmalapl28, t3734, t3735, t3738, t3739, t3742, t3745;
  double t3746, t3749, t3750, t3753, t3756, t3759, t3764, t3766;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, t3769, t3770, t3771, t3774, t3775;
  double t3778, t3781, t3782, t3785, t3786, t3791, t3794, t3797;
  double t3800, t3802, tv3sigmalapltau11, t3803, t3806, t3809, t3812, t3815;
  double t3816, t3817, t3818, t3820, t3823, t3824, t3829, t3832;
  double t3835, t3838, t3839, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24;
  double tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t3840, t3843, t3846, t3849, t3852;
  double t3853, t3854, t3855, t3857, t3860, t3861, t3866, t3869;
  double t3872, t3875, t3876, tv3sigmatau28, t3877, t3879, t3882, t3884;
  double t3887, t3888, t3889, t3892, t3895, t3896, t3899, t3902;
  double t3903, t3904, t3905, t3906, t3909, t3912, t3915, t3918;
  double t3921, t3922, tv3lapl30, tv3lapl31, tv3lapl32, t3923, t3925, t3928;
  double t3930, t3933, t3934, t3935, t3938, t3941, t3942, t3945;
  double t3948, t3949, t3950, t3951, t3952, t3955, t3958, t3961;
  double t3964, t3967, t3968, tv3lapl33, t3969, t3970, t3973, t3974;
  double t3977, t3978, t3981, t3982, t3985, t3988, t3993, t3996;
  double t3999, t4000, t4003, t4004, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3;
  double tv3lapl2tau4, t4005, t4006, t4009, t4010, t4014, t4017, t4018;
  double t4021, t4024, t4029, t4032, t4035, t4036, t4039, t4040;
  double tv3lapl2tau5, t4042, t4045, t4048, t4052, t4055, t4058, t4059;
  double t4064, t4067, t4071, t4074, t4075, tv3lapltau20, tv3lapltau21, tv3lapltau22;
  double tv3lapltau23, tv3lapltau24, t4077, t4081, t4084, t4088, t4091, t4094;
  double t4095, t4100, t4103, t4107, t4110, t4111, tv3lapltau25, t4112;
  double t4114, t4117, t4119, t4122, t4123, t4124, t4127, t4130;
  double t4133, t4134, t4137, t4138, t4139, t4140, t4141, t4144;
  double t4147, t4150, t4153, t4156, t4157, tv3tau30, tv3tau31, tv3tau32;
  double t4158, t4160, t4163, t4165, t4168, t4169, t4170, t4173;
  double t4176, t4177, t4180, t4183, t4184, t4185, t4186, t4187;
  double t4190, t4193, t4196, t4199, t4202, t4203, tv3tau33;

  double t4206, t4217, t4219, t4221, t4224, t4229, t4237, t4239;
  double t4243, t4253, t4259, t4273, t4274, t4275, t4276, t4277;
  double t4281, t4283, t4286, t4287, t4289, t4290, t4292, t4293;
  double t4297, t4307, t4309, t4311, t4315, t4316, t4321, t4323;
  double t4327, t4329, t4331, t4335, t4340, t4343, t4347, t4352;
  double t4356, t4357, t4364, t4366, t4371, t4373, t4378, t4390;
  double t4392, t4394, t4395, t4397, t4415, t4419, t4428, t4432;
  double t4439, t4446, t4453, t4460, t4465, t4477, t4486, t4488;
  double t4490, t4492, t4497, t4499, t4503, t4508, t4510, t4514;
  double t4518, t4520, t4522, t4524, t4528, t4530, t4531, t4537;
  double t4543, t4544, t4547, t4551, t4555, t4559, t4562, t4563;
  double t4565, t4567, t4571, t4572, t4574, t4575, t4581, t4586;
  double t4589, t4593, t4597, t4599, t4601, t4605, t4607, tv4rho40;
  double t4640, t4647, t4650, t4651, t4653, t4654, t4655, t4662;
  double t4666, t4670, t4674, t4679, t4681, t4694, t4706, t4708;
  double t4709, t4710, t4728, t4729, t4731, t4735, t4739, t4742;
  double t4759, t4761, t4765, t4769, t4771, t4772, t4773, t4778;
  double t4781, t4782, t4784, t4785, t4786, t4787, t4788, t4790;
  double t4791, tv4rho41, t4802, t4805, t4806, t4822, t4835, t4848;
  double t4852, t4856, t4858, t4867, t4869, t4874, t4877, t4879;
  double t4881, t4883, t4885, t4887, t4889, t4891, t4893, t4894;
  double t4896, t4898, t4900, t4901, t4903, t4924, t4937, t4941;
  double t4945, t4947, t4951, t4953, tv4rho42, t4974, t4978, t4982;
  double t4984, t4993, t4994, t4995, t4997, t4999, t5003, t5011;
  double t5013, t5015, t5017, t5019, t5021, t5023, t5027, t5048;
  double t5050, t5051, t5053, t5055, t5057, t5059, t5061, t5063;
  double t5065, t5067, t5069, t5077, t5090, t5098, t5116, t5120;
  double t5128, t5131, tv4rho43, t5136, t5141, t5148, t5152, t5160;
  double t5161, t5165, t5169, t5172, t5182, t5188, t5198, t5209;
  double t5226, t5228, t5229, t5231, t5232, t5233, t5238, t5242;
  double t5243, t5247, t5249, t5251, t5256, t5261, t5263, t5270;
  double t5274, t5277, t5281, t5298, t5302, t5306, t5310, t5311;
  double t5318, t5324, t5348, t5352, t5359, t5366, t5373, t5380;
  double t5395, t5402, t5410, t5424, t5426, t5444, t5452, t5457;
  double t5464, t5468, t5475, t5479, tv4rho44, t5483, t5484, t5488;
  double t5493, t5494, t5496, t5498, t5501, t5505, t5506, t5510;
  double t5512, t5514, t5518, t5520, t5521, t5528, t5530, t5535;
  double t5536, t5537, t5540, t5545, t5549, t5550, t5551, t5552;
  double t5557, t5559, t5561, t5563, t5586, t5602, t5603, t5612;
  double t5613, t5621, t5627, t5629, t5631, t5633, t5642, t5648;
  double t5652, t5655, t5656, t5659, t5660, t5662, t5664, t5667;
  double t5670, t5674, t5676, t5677, t5681, t5684, t5685, t5692;
  double t5703, t5704, t5705, t5710, t5717, t5722, t5729, t5730;
  double t5731, t5739, t5740, t5752, t5756, t5761, t5763, t5767;
  double t5772, t5775, t5776, t5778, t5779, t5783, t5784, t5785;
  double t5793, t5795, t5799, t5803, t5804, t5812, t5816, t5820;
  double tv4rho3sigma0, tv4rho3sigma1, t5825, t5827, t5830, t5832, tv4rho3sigma2, t5834;
  double t5835, t5838, t5840, t5862, t5869, t5870, t5872, t5873;
  double t5886, t5890, t5898, t5917, t5928, t5929, t5932, t5939;
  double t5942, tv4rho3sigma3, tv4rho3sigma4, t5944, t5946, t5947, t5949, t5951;
  double t5952, t5955, t5956, t5959, t5960, t5962, t5964, t5965;
  double t5967, t5975, t5979, t5980, t5983, t5984, t5992, t5994;
  double tv4rho3sigma5, t5998, t6000, t6005, t6020, t6022, tv4rho3sigma6, tv4rho3sigma7;
  double t6024, t6026, t6028, t6030, t6032, t6033, t6035, t6037;
  double t6039, t6041, t6043, t6045, t6046, t6048, t6051, t6052;
  double t6054, t6056, t6058, t6060, t6061, t6063, t6073, t6076;
  double t6079, t6090, t6092, t6094, t6096, t6098, t6124, t6127;
  double t6129, t6131, t6142, t6145, tv4rho3sigma8, t6153, tv4rho3sigma9, tv4rho3sigma10;
  double t6158, t6159, t6162, t6174, t6180, t6184, t6192, t6195;
  double t6202, t6203, t6204, t6205, t6208, t6209, t6210, t6217;
  double t6218, t6219, t6230, t6237, t6238, t6239, t6244, t6246;
  double t6247, t6248, t6249, t6257, t6261, t6265, t6287, t6288;
  double t6289, t6297, t6303, t6312, t6320, t6329, t6334, t6359;
  double t6360, t6367, t6382, t6399, t6406, t6417, t6428, t6430;
  double t6434, t6440, t6444, t6445, t6449, t6453, tv4rho3sigma11, t6456;
  double t6458, t6460, t6464, t6466, t6468, t6474, t6475, t6478;
  double t6482, t6484, t6486, t6490, t6497, t6502, t6508, t6510;
  double t6516, t6524, t6526, t6533, t6535, t6542, t6563, t6573;
  double t6575, t6593, t6597, t6601, t6603, t6606, t6608, t6610;
  double t6612, t6614, t6616, t6635, t6640, t6651, t6660, t6662;
  double t6664, t6666, t6668, t6670, t6672, t6674, t6680, t6688;
  double t6698, t6699, t6701, t6706, t6711, t6716, t6718, t6720;
  double t6737, t6738, t6752, t6756, tv4rho3lapl0, t6761, t6763, t6766;
  double t6768, tv4rho3lapl1, t6770, t6776, t6784, t6801, t6813, t6815;
  double t6830, t6848, t6853, t6860, t6869, t6870, t6873, tv4rho3lapl2;
  double t6875, t6881, t6882, t6887, t6888, t6892, t6895, t6897;
  double t6900, t6901, t6904, t6906, t6907, t6915, t6917, tv4rho3lapl3;
  double t6921, t6941, t6943, tv4rho3lapl4, t6945, t6947, t6949, t6951;
  double t6953, t6955, t6957, t6959, t6961, t6963, t6965, t6967;
  double t6969, t6971, t6973, t6975, t6977, t6978, t6980, t7008;
  double t7010, t7012, t7014, t7016, t7038, t7047, t7049, t7051;
  double t7056, t7059, tv4rho3lapl5, t7067, tv4rho3lapl6, t7070, t7073, t7074;
  double t7085, t7086, t7089, t7093, t7103, t7107, t7113, t7128;
  double t7129, t7135, t7148, t7152, t7169, t7191, t7214, t7227;
  double t7232, t7236, t7242, t7248, t7261, t7276, t7298, t7299;
  double t7300, t7307, t7315, t7316, t7322, t7338, t7342, tv4rho3lapl7;
  double t7345, t7347, t7349, t7355, t7357, t7363, t7365, t7369;
  double t7376, t7378, t7384, t7387, t7392, t7399, t7403, t7405;
  double t7413, t7415, t7422, t7424, t7425, t7428, t7440, t7442;
  double t7444, t7446, t7450, t7452, t7456, t7458, t7464, t7470;
  double t7472, t7482, t7484, t7488, t7504, t7510, t7517, t7528;
  double t7529, t7535, t7539, t7543, t7545, t7547, t7562, t7568;
  double t7570, t7586, t7594, t7604, t7605, t7618, t7619, t7623;
  double t7626, t7631, t7633, t7635, t7641, t7645, tv4rho3tau0, t7650;
  double t7652, t7655, t7657, tv4rho3tau1, t7659, t7671, t7681, t7692;
  double t7710, t7712, t7719, t7737, t7752, t7753, t7758, t7759;
  double t7762, tv4rho3tau2, t7764, t7774, t7775, t7779, t7784, t7786;
  double t7789, t7790, t7793, t7794, t7797, t7798, t7801, t7804;
  double t7806, tv4rho3tau3, t7810, t7830, t7832, tv4rho3tau4, t7834, t7836;
  double t7838, t7840, t7842, t7844, t7846, t7848, t7854, t7856;
  double t7858, t7860, t7862, t7864, t7866, t7867, t7869, t7871;
  double t7873, t7875, t7877, t7879, t7881, t7899, t7927, t7936;
  double t7938, t7940, t7945, t7948, tv4rho3tau5, t7956, tv4rho3tau6, t7965;
  double t7969, t7989, t7994, t7997, t8008, t8015, t8018, t8029;
  double t8030, t8033, t8037, t8067, t8074, t8075, t8079, t8094;
  double t8095, t8109, t8113, t8123, t8126, t8148, t8152, t8158;
  double t8185, t8201, t8209, t8223, t8227, tv4rho3tau7, t8230, t8232;
  double t8234, t8236, t8237, t8238, t8241, t8250, t8251, t8254;
  double t8255, t8259, t8262, t8266, t8267, t8271, t8272, t8277;
  double t8279, t8281, t8282, t8285, t8286, t8289, t8294, t8295;
  double t8297, t8298, t8304, t8307, t8316, t8319, t8332, t8335;
  double t8337, t8339, t8343, t8346, t8350, t8351, t8353, t8355;
  double t8368, t8370, t8382, t8383, t8384, t8385, t8386, t8390;
  double t8393, t8394, t8397, t8399, t8401, t8402, t8409, t8413;
  double t8420, t8427, t8433, t8436, t8445, t8448, t8451, t8455;
  double t8459, t8462, t8469, t8470, t8481, t8490, t8492, t8493;
  double t8498, t8499, t8503, t8514, t8519, t8521, t8522, t8524;
  double t8525, t8527, t8529, t8534, t8543, t8544, t8545, t8546;
  double t8547, t8548, t8549, t8550, t8554, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, t8559, t8562, t8564, t8565, t8566, t8568;
  double t8571, t8574, t8577, t8580, t8583, t8586, t8587, t8588;
  double tv4rho2sigma25, t8591, t8595, t8611, t8613, t8618, t8628, t8630;
  double t8637, t8640, t8641, t8655, t8656, t8658, t8660, t8662;
  double t8663, t8665, t8666, t8672, t8673, t8676, tv4rho2sigma26, tv4rho2sigma27;
  double tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t8678, t8680, t8681, t8682, t8684;
  double t8686, t8687, t8688, t8690, t8692, t8693, t8694, t8695;
  double t8696, t8698, t8700, t8702, t8704, t8706, t8707, t8715;
  double t8717, t8724, t8736, t8737, t8740, t8746, t8752, t8761;
  double t8763, t8765, t8767, t8768, t8770, t8771, t8772, t8778;
  double t8779, t8782, tv4rho2sigma211, t8789, t8790, t8800, t8801, tv4rho2sigma212;
  double tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t8811, t8812, t8829, t8835;
  double t8837, t8839, t8840, t8843, t8844, t8845, t8846, t8849;
  double t8850, t8853, t8856, t8857, t8868, t8878, t8886, t8887;
  double t8894, t8895, t8899, t8902, t8906, t8910, t8911, t8916;
  double t8919, t8923, t8932, t8934, t8935, t8949, t8954, t8964;
  double t8974, t8979, t8980, t8983, t8986, t8987, t8990, t8997;
  double t9014, t9018, t9019, t9024, t9025, t9027, t9030, t9033;
  double t9034, t9041, t9045, t9046, t9075, t9078, t9081, t9083;
  double t9084, t9085, t9086, t9087, t9088, t9089, t9093, tv4rho2sigma217;
  double t9096, t9097, t9098, t9099, t9102, t9103, t9104, t9108;
  double t9112, t9117, t9119, t9133, t9137, t9138, t9146, t9148;
  double t9150, t9155, t9168, t9184, t9195, t9196, t9204, t9207;
  double t9218, t9232, t9234, t9250, t9264, t9265, t9269, t9277;
  double t9281, t9283, t9288, t9307, t9330, t9332, t9334, t9336;
  double t9338, t9340, t9342, t9349, t9382, t9384, t9386, t9388;
  double t9389, t9391, t9393, t9395, t9397, t9399, t9401, t9403;
  double t9404, t9408, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, t9413;
  double t9416, t9419, t9422, t9425, t9428, t9431, t9434, t9435;
  double t9436, tv4rho2sigmalapl5, t9463, t9490, t9492, t9494, t9496, t9498;
  double t9512, t9516, t9519, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10;
  double t9521, t9523, t9525, t9527, t9529, t9531, t9533, t9535;
  double t9537, t9553, t9558, t9560, t9562, t9564, t9566, t9568;
  double t9570, t9572, t9574, t9588, t9604, t9606, t9608, t9610;
  double t9615, t9617, t9620, tv4rho2sigmalapl11, t9635, t9636, tv4rho2sigmalapl12, tv4rho2sigmalapl13;
  double tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t9651, t9652, t9653, t9657, t9661;
  double t9662, t9665, t9668, t9669, t9670, t9675, t9692, t9693;
  double t9696, t9697, t9712, t9725, t9726, t9748, t9749, t9756;
  double t9777, t9789, t9799, t9805, t9811, t9838, t9886, t9914;
  double t9917, t9918, t9922, tv4rho2sigmalapl17, t9925, t9929, t9930, t9931;
  double t9934, t9938, t9947, t9949, t9953, t9974, t9984, t9987;
  double t9994, t9995, t9998, t9999, t10003, t10006, t10028, t10051;
  double t10053, t10055, t10057, t10074, t10075, t10085, t10089, t10104;
  double t10106, t10126, t10145, t10147, t10149, t10151, t10153, t10155;
  double t10157, t10159, t10161, t10163, t10168, t10209, t10211, t10212;
  double t10215, t10217, t10218, t10220, t10222, t10224, t10228, tv4rho2sigmatau0;
  double tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, t10233, t10236, t10239, t10242;
  double t10245, t10248, t10251, t10254, t10255, t10256, tv4rho2sigmatau5, t10283;
  double t10312, t10314, t10316, t10318, t10320, t10332, t10336, t10339;
  double tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, t10345, t10347, t10357;
  double t10359, t10361, t10363, t10365, t10367, t10369, t10373, t10378;
  double t10380, t10382, t10384, t10386, t10388, t10390, t10392, t10394;
  double t10396, t10398, t10400, t10402, t10408, t10434, t10437, t10440;
  double tv4rho2sigmatau11, t10455, t10456, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16;
  double t10459, t10460, t10463, t10482, t10483, t10491, t10495, t10499;
  double t10507, t10514, t10529, t10535, t10555, t10556, t10560, t10569;
  double t10585, t10592, t10601, t10618, t10651, t10694, t10726, t10729;
  double t10733, tv4rho2sigmatau17, t10736, t10748, t10751, t10769, t10772, t10773;
  double t10776, t10778, t10780, t10784, t10793, t10794, t10797, t10799;
  double t10809, t10811, t10815, t10817, t10822, t10839, t10841, t10844;
  double t10848, t10850, t10851, t10853, t10857, t10866, t10892, t10900;
  double t10906, t10921, t10922, t10924, t10925, t10930, t10938, t10940;
  double t10942, t10954, t10956, t10957, t10963, t10969, t10971, t10972;
  double t10976, tv4rho2lapl20, tv4rho2lapl21, t10981, t10984, t10987, t10990, t10993;
  double t10996, t10999, t11002, t11003, t11004, tv4rho2lapl22, t11033, t11046;
  double t11048, t11050, t11052, t11054, t11066, t11072, t11075, tv4rho2lapl23;
  double tv4rho2lapl24, t11093, t11095, t11097, t11099, t11101, t11103, t11105;
  double t11106, t11108, t11110, t11112, t11114, t11116, t11118, t11130;
  double t11132, t11134, t11136, t11138, t11140, t11150, t11157, t11160;
  double tv4rho2lapl25, t11175, t11176, tv4rho2lapl26, tv4rho2lapl27, t11187, t11190, t11200;
  double t11210, t11217, t11224, t11237, t11240, t11248, t11252, t11255;
  double t11261, t11263, t11272, t11297, t11304, t11317, t11338, t11351;
  double t11352, t11362, t11363, t11386, t11389, t11393, tv4rho2lapl28, t11396;
  double t11403, t11407, t11410, t11414, t11427, t11440, t11442, t11444;
  double t11447, t11451, t11477, t11482, t11484, t11488, t11495, t11497;
  double t11499, t11503, t11506, t11509, t11512, t11516, t11518, t11522;
  double t11530, t11540, t11541, t11561, t11565, t11590, t11592, t11595;
  double t11597, t11599, t11601, t11603, t11605, t11607, t11609, t11611;
  double t11614, t11616, t11618, t11620, t11630, t11646, t11648, t11650;
  double t11678, t11691, t11695, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, t11700, t11703;
  double t11706, t11709, t11712, t11715, t11718, t11721, t11722, t11723;
  double tv4rho2lapltau3, t11750, t11777, t11779, t11781, t11783, t11785, t11799;
  double t11803, t11806, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, t11808, t11810, t11812;
  double t11814, t11816, t11818, t11820, t11822, t11824, t11840, t11845;
  double t11847, t11849, t11851, t11853, t11855, t11857, t11875, t11877;
  double t11879, t11881, t11883, t11885, t11887, t11902, t11904, t11907;
  double tv4rho2lapltau7, t11922, t11923, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, t11936, t11957;
  double t11961, t11970, t11973, t11979, t11983, t11994, t12004, t12007;
  double t12011, t12018, t12022, t12026, t12029, t12031, t12040, t12043;
  double t12065, t12069, t12079, t12115, t12160, t12188, t12191, t12195;
  double tv4rho2lapltau11, t12198, t12203, t12207, t12226, t12228, t12232, t12237;
  double t12238, t12252, t12259, t12268, t12276, t12278, t12289, t12307;
  double t12309, t12313, t12315, t12316, t12318, t12330, t12333, t12337;
  double t12342, t12351, t12359, t12361, t12382, t12385, t12386, t12387;
  double t12396, t12398, t12404, t12406, t12418, t12421, t12423, t12425;
  double t12428, t12432, t12436, tv4rho2tau20, tv4rho2tau21, t12441, t12444, t12447;
  double t12450, t12453, t12456, t12459, t12462, t12463, t12464, tv4rho2tau22;
  double t12493, t12506, t12518, t12520, t12522, t12524, t12526, t12532;
  double t12535, tv4rho2tau23, tv4rho2tau24, t12537, t12539, t12541, t12543, t12545;
  double t12547, t12549, t12551, t12553, t12555, t12557, t12559, t12561;
  double t12565, t12590, t12602, t12604, t12606, t12608, t12610, t12611;
  double t12617, t12620, tv4rho2tau25, t12635, t12636, tv4rho2tau26, tv4rho2tau27, t12650;
  double t12654, t12658, t12666, t12676, t12691, t12694, t12704, t12715;
  double t12727, t12728, t12735, t12738, t12759, t12788, t12798, t12811;
  double t12813, t12818, t12845, t12848, t12852, tv4rho2tau28, t12854, t12855;
  double t12856, t12857, t12860, t12862, t12866, t12870, t12874, t12878;
  double t12881, t12885, t12890, t12891, t12895, t12896, t12899, t12900;
  double t12907, t12911, t12912, t12917, t12918, t12923, t12925, t12929;
  double t12931, t12936, t12944, t12946, t12949, t12954, t12957, t12959;
  double t12962, t12969, t12981, t12982, t12983, t12984, t12985, t12986;
  double t12987, t12988, t12992, t13002, t13005, t13010, t13020, t13023;
  double t13025, t13027, t13029, t13031, t13033, t13047, t13048, t13051;
  double t13052, t13053, t13060, t13063, t13066, t13081, t13090, t13099;
  double t13119, t13121, t13123, t13124, t13126, t13127, t13131, tv4rhosigma30;
  double tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38;
  double t13133, t13134, t13135, t13136, t13137, t13138, t13139, t13140;
  double t13141, t13143, t13145, t13147, t13150, t13152, t13154, t13156;
  double t13158, t13160, t13162, t13163, t13165, t13167, t13169, t13190;
  double t13192, tv4rhosigma39, t13194, t13196, t13198, t13200, t13216, t13223;
  double t13225, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316;
  double tv4rhosigma317, tv4rhosigma318, t13229, t13233, t13237, t13239, t13240, t13242;
  double t13244, t13245, t13248, t13250, t13254, t13258, t13261, t13271;
  double t13272, t13273, t13276, t13277, t13284, t13288, t13289, t13290;
  double t13295, t13296, t13301, t13309, t13316, t13325, t13330, t13338;
  double t13339, t13341, t13344, t13349, t13352, t13357, t13363, t13367;
  double t13369, t13382, t13394, t13408, t13409, t13412, t13413, t13414;
  double t13420, t13421, t13424, t13427, t13442, t13451, t13464, t13471;
  double t13472, t13476, tv4rhosigma319, t13482, t13487, t13488, t13491, t13492;
  double t13501, t13505, t13506, t13509, t13517, t13518, t13522, t13523;
  double t13524, t13525, t13526, t13527, t13528, t13530, t13531, t13532;
  double t13534, t13535, t13537, t13538, t13539, t13542, t13548, t13549;
  double t13550, t13552, t13553, t13570, t13572, t13592, t13598, t13599;
  double t13600, t13601, t13602, t13603, t13604, t13605, t13606, t13607;
  double t13609, t13610, t13611, t13612, t13615, t13616, t13618, t13620;
  double t13622, t13624, t13626, t13628, t13630, t13632, t13634, t13635;
  double t13636, t13638, t13640, t13641, t13644, t13645, t13646, t13647;
  double t13648, t13649, t13654, t13660, t13672, t13673, t13675, t13676;
  double t13677, t13680, t13682, t13689, t13690, t13692, t13693, t13694;
  double t13695, t13696, t13697, t13717, t13729, t13730, t13731, t13732;
  double t13733, t13734, t13735, t13736, t13737, t13738, t13739, t13740;
  double t13741, t13742, t13743, t13747, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3;
  double tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, t13753;
  double t13754, t13755, t13758, t13759, t13760, t13761, t13762, t13763;
  double t13764, t13765, t13766, t13767, t13768, t13769, t13771, t13773;
  double t13774, t13775, t13777, t13779, t13781, t13783, t13785, t13787;
  double t13789, t13790, t13792, t13794, t13809, t13810, t13811, t13812;
  double t13813, t13814, t13815, t13816, t13817, t13819, tv4rhosigma2lapl11, t13837;
  double t13842, t13843, t13844, t13845, t13846, t13847, t13848, t13849;
  double t13850, t13851, t13852, t13853, t13854, t13855, t13857, tv4rhosigma2lapl12;
  double tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20;
  double tv4rhosigma2lapl21, tv4rhosigma2lapl22, t13860, t13861, t13864, t13873, t13878, t13879;
  double t13884, t13885, t13888, t13892, t13893, t13901, t13903, t13904;
  double t13907, t13908, t13912, t13929, t13936, t13937, t13938, t13939;
  double t13941, t13942, t13944, t13945, t13947, t13948, t13951, t13953;
  double t13954, t13955, t13957, t13958, t13971, t13980, t13981, t13982;
  double t13983, t13984, t13985, t13986, t13987, t13988, t13989, t13990;
  double t13991, t13993, t13994, t13995, t13996, t13998, t13999, t14011;
  double t14017, t14022, t14026, t14029, t14036, t14037, t14038, t14039;
  double t14041, t14042, t14043, t14044, t14047, t14048, t14049, t14050;
  double t14067, t14081, t14083, t14084, t14085, t14086, t14087, t14088;
  double t14089, t14090, t14091, t14092, t14093, t14097, tv4rhosigma2lapl23, t14099;
  double t14102, t14107, t14108, t14109, t14110, t14112, t14113, t14115;
  double t14116, t14118, t14119, t14140, t14142, t14143, t14149, t14150;
  double t14163, t14164, t14165, t14169, t14189, t14190, t14192, t14193;
  double t14194, t14200, t14201, t14204, t14214, t14215, t14216, t14218;
  double t14219, t14220, t14221, t14222, t14223, t14225, t14226, t14228;
  double t14230, t14232, t14234, t14236, t14238, t14240, t14242, t14244;
  double t14245, t14246, t14247, t14250, t14251, t14252, t14253, t14254;
  double t14255, t14257, t14258, t14272, t14285, t14288, t14289, t14297;
  double t14298, t14300, t14301, t14310, t14311, t14312, t14313, t14322;
  double t14333, t14334, t14338, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4;
  double tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t14340, t14341;
  double t14344, t14345, t14346, t14347, t14349, t14351, t14353, t14354;
  double t14355, t14356, t14357, t14358, t14359, t14378, t14379, t14380;
  double t14381, t14382, t14384, t14386, t14388, t14390, t14392, t14394;
  double t14396, t14397, t14399, tv4rhosigma2tau11, t14415, t14416, t14417, t14418;
  double t14419, t14420, t14421, t14422, t14429, t14430, t14432, tv4rhosigma2tau12;
  double tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20;
  double tv4rhosigma2tau21, tv4rhosigma2tau22, t14438, t14439, t14440, t14441, t14442, t14444;
  double t14445, t14446, t14448, t14449, t14451, t14452, t14454, t14455;
  double t14458, t14459, t14460, t14474, t14475, t14481, t14482, t14483;
  double t14486, t14497, t14498, t14507, t14523, t14537, t14542, t14543;
  double t14544, t14546, t14547, t14550, t14555, t14556, t14557, t14558;
  double t14560, t14561, t14562, t14563, t14566, t14567, t14568, t14569;
  double t14571, t14572, t14578, t14586, t14589, t14615, t14616, t14618;
  double t14619, t14624, t14637, t14639, t14640, t14644, tv4rhosigma2tau23, t14647;
  double t14648, t14651, t14660, t14670, t14679, t14682, t14683, t14690;
  double t14698, t14699, t14733, t14734, t14735, t14736, t14737, t14739;
  double t14740, t14741, t14742, t14743, t14744, t14745, t14746, t14747;
  double t14748, t14749, t14750, t14751, t14752, t14755, t14770, t14779;
  double t14781, t14783, t14785, t14787, t14789, t14790, t14794, t14796;
  double t14798, t14828, t14835, t14836, t14837, t14838, t14839, t14840;
  double t14841, t14842, t14843, t14844, t14845, t14846, t14847, t14849;
  double t14850, t14851, t14852, t14853, t14854, t14855, t14856, t14857;
  double t14858, t14859, t14860, t14861, t14862, t14864, t14865, t14872;
  double t14876, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26;
  double tv4rhosigmalapl27, t14879, t14881, t14883, t14885, t14887, t14907, t14909;
  double t14911, t14913, t14914, t14915, t14916, t14917, t14918, t14919;
  double t14920, t14921, t14922, t14923, t14924, t14925, t14926, t14927;
  double t14928, t14929, t14930, t14934, t14935, t14937, tv4rhosigmalapl28, t14957;
  double t14958, t14959, t14960, t14961, t14962, t14963, t14964, t14965;
  double t14968, t14970, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214;
  double tv4rhosigmalapl215, tv4rhosigmalapl216, t14976, t14977, t14978, t14981, t14985, t14986;
  double t15019, t15024, t15059, t15060, t15061, t15062, t15063, t15065;
  double t15066, t15067, t15068, t15069, t15070, t15071, t15072, t15073;
  double t15074, t15075, t15076, t15077, t15078, t15082, t15097, t15118;
  double t15142, t15143, t15144, t15145, t15146, t15147, t15148, t15149;
  double t15150, t15151, t15152, t15154, t15155, t15156, t15157, t15158;
  double t15159, t15160, t15161, t15162, t15163, t15170, t15174, tv4rhosigmalapl217;
  double t15177, t15179, t15181, t15183, t15185, t15187, t15221, t15224;
  double t15227, t15230, t15275, t15300, t15302, t15304, t15309, t15310;
  double t15322, t15323, t15324, t15327, t15331, t15333, t15353, t15381;
  double t15383, t15384, t15388, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4;
  double tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, t15391, t15393;
  double t15395, t15397, t15399, t15401, t15412, t15422, t15424, t15426;
  double t15430, t15431, t15433, t15434, t15437, tv4rhosigmalapltau11, t15457, t15460;
  double t15462, t15463, t15466, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16;
  double tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, t15515, t15518;
  double t15519, t15522, t15571, t15583, t15584, t15585, t15587, t15593;
  double t15600, t15611, t15613, t15626, t15657, t15658, t15662, tv4rhosigmalapltau23;
  double t15664, t15668, t15669, t15672, t15673, t15676, t15677, t15680;
  double t15691, t15695, t15705, t15706, t15707, t15708, t15709, t15710;
  double t15711, t15712, t15713, t15714, t15715, t15717, t15721, t15723;
  double t15725, t15727, t15729, t15752, t15777, t15779, t15781, t15783;
  double t15786, t15798, t15799, t15800, t15801, t15802, t15803, t15804;
  double t15805, t15806, t15807, t15808, t15809, t15810, t15811, t15812;
  double t15821, t15822, t15823, t15827, t15834, t15838, t15842, t15848;
  double t15867, t15871, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25;
  double tv4rhosigmatau26, tv4rhosigmatau27, t15878, t15880, t15882, t15884, t15886, t15888;
  double t15890, t15892, t15894, t15909, t15910, t15911, t15912, t15913;
  double t15914, t15915, t15916, t15917, t15919, t15922, t15924, tv4rhosigmatau28;
  double t15944, t15945, t15946, t15947, t15948, t15951, t15953, tv4rhosigmatau29;
  double tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, t15955;
  double t15956, t15957, t15958, t15959, t15960, t15961, t15962, t15963;
  double t15976, t15984, t16014, t16026, t16027, t16028, t16029, t16030;
  double t16031, t16032, t16033, t16034, t16037, t16038, t16039, t16040;
  double t16044, t16052, t16053, t16056, t16060, t16061, t16070, t16081;
  double t16083, t16084, t16085, t16088, t16099, t16106, t16117, t16129;
  double t16134, t16138, tv4rhosigmatau217, t16142, t16159, t16163, t16164, t16167;
  double t16174, t16181, t16189, t16193, t16197, t16201, t16210, t16211;
  double t16221, t16233, t16244, t16245, t16248, t16249, t16250, t16258;
  double t16261, t16263, t16265, t16272, t16285, t16295, t16298, t16301;
  double t16304, t16305, t16329, t16344, t16346, t16348, t16350, t16352;
  double t16353, t16355, t16356, t16360, tv4rholapl30, tv4rholapl31, tv4rholapl32, t16366;
  double t16367, t16368, t16369, t16373, t16384, t16394, t16396, t16398;
  double t16400, t16402, t16404, t16406, t16408, t16410, t16411, t16413;
  double tv4rholapl33, t16433, t16440, t16442, tv4rholapl34, tv4rholapl35, tv4rholapl36, t16444;
  double t16454, t16458, t16462, t16466, t16470, t16474, t16487, t16502;
  double t16503, t16508, t16514, t16515, t16525, t16537, t16549, t16560;
  double t16572, t16575, t16578, t16581, t16582, t16606, t16628, t16635;
  double t16636, t16640, tv4rholapl37, t16643, t16645, t16647, t16649, t16651;
  double t16655, t16658, t16664, t16665, t16694, t16696, t16698, t16700;
  double t16701, t16729, t16730, t16733, t16737, t16741, t16745, t16746;
  double t16749, t16761, t16768, t16781, t16787, t16792, t16811, t16815;
  double t16820, t16824, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, t16827;
  double t16829, t16833, t16856, t16858, t16860, t16862, t16864, t16866;
  double t16867, t16869, t16870, t16872, tv4rholapl2tau5, t16895, t16896, t16898;
  double tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, t16909, t16917, t16920;
  double t16958, t16965, t16966, t16969, t16970, t16974, t16975, t16978;
  double t16982, t16986, t16992, t16999, t17006, t17025, t17031, t17035;
  double t17036, t17037, t17058, t17062, tv4rholapl2tau11, t17085, t17100, t17108;
  double t17110, t17112, t17114, t17116, t17118, t17120, t17122, t17124;
  double t17132, t17144, t17145, t17148, t17150, t17157, t17159, t17162;
  double t17165, t17183, t17187, t17188, t17193, t17204, t17232, t17236;
  double t17240, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, t17243, t17245;
  double t17247, t17267, t17269, t17271, t17273, t17275, t17277, t17278;
  double t17282, t17283, t17285, tv4rholapltau25, t17305, t17308, t17310, tv4rholapltau26;
  double tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, t17314, t17330, t17368, t17374;
  double t17375, t17378, t17385, t17390, t17394, t17403, t17404, t17407;
  double t17414, t17424, t17431, t17463, t17467, tv4rholapltau211, t17469, t17477;
  double t17485, t17489, t17490, t17493, t17499, t17518, t17528, t17535;
  double t17537, t17541, t17551, t17554, t17565, t17577, t17580, t17581;
  double t17582, t17583, t17592, t17618, t17626, t17629, t17632, t17636;
  double t17660, t17668, t17670, t17672, t17674, t17676, t17678, t17680;
  double t17682, t17684, t17685, t17687, t17688, t17692, tv4rhotau30, tv4rhotau31;
  double tv4rhotau32, t17696, t17697, t17698, t17699, t17703, t17705, t17716;
  double t17728, t17730, t17732, t17734, t17736, t17738, t17740, t17742;
  double t17743, t17745, tv4rhotau33, t17765, t17772, t17774, tv4rhotau34, tv4rhotau35;
  double tv4rhotau36, t17776, t17786, t17789, t17790, t17793, t17801, t17805;
  double t17817, t17824, t17825, t17828, t17842, t17844, t17871, t17883;
  double t17894, t17920, t17930, t17933, t17936, t17940, t17964, t17969;
  double t17970, t17974, tv4rhotau37, t17976, t17978, t17981, t17984, t17987;
  double t17989, t17990, t17991, t17994, t17997, t17999, t18001, t18003;
  double t18005, t18007, t18008, t18012, t18019, t18023, t18030, t18035;
  double t18047, t18048, t18055, t18061, t18062, t18069, t18074, t18114;
  double t18117, t18120, t18123, t18128, t18130, tv4sigma40, tv4sigma41, tv4sigma42;
  double tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410;
  double tv4sigma411, tv4sigma412, tv4sigma413, t18131, t18133, t18136, t18139, t18142;
  double t18144, t18145, t18146, t18149, t18152, t18154, t18156, t18158;
  double t18160, t18162, t18163, t18166, t18169, t18173, t18176, t18177;
  double t18178, t18186, t18198, t18199, t18206, t18212, t18213, t18220;
  double t18225, t18229, t18236, t18283, t18285, tv4sigma414, t18286, t18293;
  double t18300, t18301, t18307, t18320, t18323, t18324, t18344, t18347;
  double t18348, t18349, t18350, t18351, t18352, t18353, t18355, t18356;
  double t18357, t18358, t18359, t18360, t18361, t18362, t18363, t18364;
  double t18366, t18367, t18369, t18370, t18371, t18372, t18374, t18375;
  double t18376, t18377, t18379, t18380, t18383, t18384, t18386, t18387;
  double t18389, t18390, t18391, t18394, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3;
  double tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11;
  double tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t18395;
  double t18399, t18405, t18406, t18410, t18431, t18437, t18452, t18455;
  double t18456, t18457, t18458, t18459, t18460, t18461, t18463, t18464;
  double t18465, t18466, t18467, t18468, t18471, t18472, t18474, t18475;
  double t18476, t18478, t18479, t18480, t18482, t18483, t18484, t18485;
  double t18486, t18487, t18488, t18490, t18491, t18493, t18494, t18496;
  double t18497, t18498, t18501, tv4sigma3lapl19, t18502, t18513, t18514, t18520;
  double t18524, t18538, t18557, t18558, t18561, t18564, t18565, t18568;
  double t18569, t18571, t18572, t18573, t18575, t18576, t18577, t18578;
  double t18579, t18580, t18581, t18583, t18584, t18586, t18587, t18589;
  double t18590, t18591, t18594, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4;
  double tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12;
  double tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, t18595, t18602;
  double t18607, t18608, t18615, t18616, t18623, t18631, t18654, t18656;
  double t18657, t18658, t18660, t18661, t18663, t18664, t18665, t18667;
  double t18668, t18670, t18671, t18674, t18675, t18677, t18678, t18680;
  double t18681, t18682, t18683, t18684, t18687, tv4sigma3tau19, t18690, t18700;
  double t18701, t18703, t18704, t18707, t18708, t18709, t18713, t18714;
  double t18716, t18717, t18719, t18722, t18723, t18724, t18729, t18730;
  double t18731, t18737, t18738, t18741, t18748, t18759, t18768, t18770;
  double t18771, t18772, t18773, t18775, t18776, t18778, t18779, t18780;
  double t18781, t18782, t18783, t18784, t18785, t18786, t18792, t18800;
  double t18803, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26;
  double tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214;
  double tv4sigma2lapl215, tv4sigma2lapl216, t18806, t18818, t18819, t18821, t18822, t18824;
  double t18827, t18834, t18838, t18841, t18842, t18845, t18846, t18847;
  double t18848, t18850, t18851, t18852, t18862, t18863, t18866, t18868;
  double t18869, t18870, t18876, t18877, t18880, t18881, t18886, t18887;
  double t18892, t18893, t18895, t18896, t18897, t18898, t18899, t18900;
  double t18901, t18902, t18903, t18909, t18917, t18920, tv4sigma2lapl217, t18926;
  double t18927, t18933, t18945, t18949, t18955, t18958, t18962, t18963;
  double t18973, t18982, t18991, t18994, t18997, t19000, t19004, t19006;
  double t19007, t19008, t19009, t19010, t19011, t19012, t19013, t19014;
  double t19015, t19016, t19017, t19018, t19019, t19020, t19021, t19022;
  double t19023, t19024, t19025, t19028, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3;
  double tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11;
  double tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19;
  double tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, t19033, t19036, t19040, t19041, t19047;
  double t19051, t19053, t19054, t19057, t19060, t19064, t19069, t19071;
  double t19074, t19080, t19087, t19091, t19096, t19115, t19116, t19117;
  double t19118, t19119, t19120, t19121, t19122, t19123, t19124, t19125;
  double t19126, t19127, t19128, t19129, t19130, t19131, t19132, t19133;
  double t19134, t19137, tv4sigma2lapltau23, t19138, t19147, t19150, t19159, t19160;
  double t19162, t19163, t19165, t19166, t19169, t19170, t19173, t19174;
  double t19175, t19177, t19178, t19179, t19180, t19181, t19184, t19185;
  double t19186, t19193, t19194, t19196, t19197, t19221, t19228, t19236;
  double t19239, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26;
  double tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214;
  double tv4sigma2tau215, tv4sigma2tau216, t19243, t19244, t19246, t19247, t19248, t19251;
  double t19252, t19253, t19257, t19261, t19273, t19281, t19297, t19298;
  double t19300, t19301, t19303, t19304, t19306, t19307, t19310, t19311;
  double t19315, t19316, t19321, t19328, t19336, t19339, tv4sigma2tau217, t19342;
  double t19352, t19356, t19365, t19369, t19374, t19379, t19385, t19392;
  double t19398, t19399, t19400, t19401, t19402, t19403, t19404, t19405;
  double t19407, t19408, t19410, t19421, t19433, t19436, t19439, t19442;
  double t19454, t19459, t19460, t19463, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33;
  double tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, t19464;
  double t19471, t19480, t19484, t19489, t19500, t19504, t19511, t19521;
  double t19522, t19523, t19524, t19525, t19526, t19527, t19528, t19530;
  double t19531, t19533, t19544, t19556, t19559, t19562, t19565, t19577;
  double t19582, t19583, t19586, tv4sigmalapl311, t19597, t19599, t19601, t19607;
  double t19611, t19614, t19635, t19654, t19656, t19657, t19658, t19659;
  double t19660, t19661, t19662, t19663, t19664, t19674, t19675, t19678;
  double tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7;
  double tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15;
  double tv4sigmalapl2tau16, t19689, t19691, t19693, t19700, t19701, t19714, t19728;
  double t19746, t19748, t19749, t19750, t19751, t19752, t19753, t19754;
  double t19755, t19756, t19766, t19767, t19770, tv4sigmalapl2tau17, t19783, t19785;
  double t19790, t19800, t19803, t19837, t19840, t19849, t19852, tv4sigmalapltau20;
  double tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28;
  double tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216;
  double t19865, t19867, t19872, t19888, t19891, t19894, t19919, t19922;
  double t19931, t19934, tv4sigmalapltau217, t19938, t19954, t19970, t19971, t19972;
  double t19978, t19983, t19990, t19991, t19992, t19993, t19994, t19995;
  double t19996, t19997, t19999, t20000, t20002, t20040, t20045, t20046;
  double t20049, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35, tv4sigmatau36;
  double tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t20050, t20060, t20063, t20075;
  double t20076, t20084, t20091, t20105, t20106, t20107, t20108, t20109;
  double t20110, t20111, t20112, t20114, t20115, t20117, t20152, t20160;
  double t20161, t20164, tv4sigmatau311, t20175, t20176, t20190, t20197, t20201;
  double t20208, t20213, t20220, t20233, t20274, t20276, tv4lapl40, tv4lapl41;
  double tv4lapl42, tv4lapl43, t20287, t20288, t20292, t20305, t20315, t20332;
  double t20339, t20343, t20350, t20386, t20388, tv4lapl44, t20390, t20397;
  double t20407, t20410, t20427, t20450, t20452, t20453, t20454, t20455;
  double t20456, t20457, t20458, t20459, t20460, t20461, t20462, t20465;
  double tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, t20471;
  double t20478, t20484, t20497, t20505, t20527, t20529, t20530, t20531;
  double t20532, t20533, t20534, t20535, t20536, t20537, t20538, t20539;
  double t20542, tv4lapl3tau7, t20545, t20552, t20558, t20575, t20586, t20588;
  double t20601, t20608, t20616, t20619, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23;
  double tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, t20620, t20627, t20632, t20637;
  double t20661, t20677, t20684, t20692, t20695, tv4lapl2tau28, t20696, t20706;
  double t20723, t20734, t20743, t20752, t20754, t20780, t20783, t20786;
  double t20798, t20803, t20804, t20807, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33;
  double tv4lapltau34, tv4lapltau35, tv4lapltau36, t20808, t20818, t20822, t20839, t20844;
  double t20847, t20865, t20867, t20893, t20896, t20899, t20911, t20916;
  double t20917, t20920, tv4lapltau37, t20931, t20932, t20949, t20960, t20967;
  double t20978, t20988, t20989, t21030, t21032, tv4tau40, tv4tau41, tv4tau42;
  double tv4tau43, t21043, t21044, t21064, t21075, t21082, t21087, t21100;
  double t21104, t21142, t21144, tv4tau44;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t227 = 0.1e1 / t20;
  t228 = t87 * t87;
  t231 = t83 * t3;
  t232 = 0.1e1 / t231;
  t233 = t13 * t232;
  t236 = my_piecewise5(t7, 0, t11, 0, -0.2e1 * t84 + 0.2e1 * t233);
  t240 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t228 + 0.3e1 / 0.2e1 * t20 * t236);
  t241 = M_PI * t240;
  t244 = t91 * t96;
  t246 = t91 * t26;
  t251 = t24 / t25 / t3;
  t252 = t251 * t46;
  t254 = t23 * t252 / 0.32e2;
  t255 = t23 * t95;
  t256 = t255 * t117;
  t258 = 0.1e1 / t45;
  t260 = -t258 * t100 + t46;
  t261 = t111 * t111;
  t263 = t43 * t43;
  t264 = t44 * t44;
  t265 = 0.1e1 / t264;
  t266 = t263 * t265;
  t267 = t40 * t40;
  t268 = 0.1e1 / t267;
  t269 = t266 * t268;
  t270 = t260 * t261 * t269;
  t278 = 0.1e1 / t105 / rho[0];
  t283 = my_piecewise3(t39, (0.3e1 / 0.2e1 * lapl[0] * t106 - 0.6e1 * tau[0] * t106 + 0.3e1 / 0.2e1 * sigma[0] * t278) * t37, 0);
  t285 = t100 * t283 * t116;
  t288 = t100 * t261;
  t289 = t43 * t265;
  t290 = t289 * t268;
  t291 = t288 * t290;
  t294 = t264 * t44;
  t295 = 0.1e1 / t294;
  t296 = t263 * t295;
  t297 = t296 * t268;
  t298 = t288 * t297;
  t301 = t114 * t268;
  t302 = t288 * t301;
  t306 = my_piecewise3(t2, 0, -t241 * t47 / 0.8e1 - t244 / 0.8e1 - t246 * t117 / 0.8e1 + t254 - t256 / 0.16e2 - t99 * t270 / 0.32e2 - t99 * t285 / 0.16e2 - t99 * t291 / 0.16e2 + t99 * t298 / 0.16e2 + t99 * t302 / 0.16e2);
  t307 = 0.1e1 / t57;
  t308 = t124 * t124;
  t311 = t52 * t232;
  t314 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t84 + 0.2e1 * t311);
  t318 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t308 + 0.3e1 / 0.2e1 * t57 * t314);
  t319 = M_PI * t318;
  t322 = t128 * t131;
  t324 = t251 * t78;
  t326 = t60 * t324 / 0.32e2;
  t328 = my_piecewise3(t51, 0, -t319 * t79 / 0.8e1 - t322 / 0.8e1 + t326);
  tv2rho20 = 0.2e1 * t121 + 0.2e1 * t135 + t3 * (t306 + t328);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t331 = t227 * t139;
  t335 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t233);
  t339 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t331 * t87 + 0.3e1 / 0.2e1 * t20 * t335);
  t340 = M_PI * t339;
  t343 = t143 * t96;
  t345 = t143 * t26;
  t351 = my_piecewise3(t2, 0, -t340 * t47 / 0.8e1 - t343 / 0.16e2 - t345 * t117 / 0.16e2 - t244 / 0.16e2 + t254 - t256 / 0.32e2);
  t352 = t307 * t149;
  t356 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t311);
  t360 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t352 * t124 + 0.3e1 / 0.2e1 * t57 * t356);
  t361 = M_PI * t360;
  t364 = t153 * t131;
  t367 = t128 * t26;
  t370 = t60 * t95;
  t371 = t370 * t174;
  t374 = my_piecewise3(t51, 0, -t361 * t79 / 0.8e1 - t364 / 0.16e2 - t322 / 0.16e2 + t326 - t367 * t174 / 0.16e2 - t371 / 0.32e2);
  tv2rho21 = t121 + t135 + t147 + t178 + t3 * (t351 + t374);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t379 = t139 * t139;
  t384 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t84 + 0.2e1 * t233);
  t388 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t379 + 0.3e1 / 0.2e1 * t20 * t384);
  t389 = M_PI * t388;
  t394 = my_piecewise3(t2, 0, -t389 * t47 / 0.8e1 - t343 / 0.8e1 + t254);
  t395 = t149 * t149;
  t400 = my_piecewise5(t11, 0, t7, 0, -0.2e1 * t84 + 0.2e1 * t311);
  t404 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t395 + 0.3e1 / 0.2e1 * t57 * t400);
  t405 = M_PI * t404;
  t409 = t153 * t26;
  t413 = 0.1e1 / t77;
  t415 = -t413 * t157 + t78;
  t416 = t168 * t168;
  t418 = t75 * t75;
  t419 = t76 * t76;
  t420 = 0.1e1 / t419;
  t421 = t418 * t420;
  t422 = t73 * t73;
  t423 = 0.1e1 / t422;
  t424 = t421 * t423;
  t425 = t415 * t416 * t424;
  t433 = 0.1e1 / t162 / rho[1];
  t438 = my_piecewise3(t72, (0.3e1 / 0.2e1 * lapl[1] * t163 - 0.6e1 * tau[1] * t163 + 0.3e1 / 0.2e1 * sigma[2] * t433) * t37, 0);
  t440 = t157 * t438 * t173;
  t443 = t157 * t416;
  t444 = t75 * t420;
  t445 = t444 * t423;
  t446 = t443 * t445;
  t449 = t419 * t76;
  t450 = 0.1e1 / t449;
  t451 = t418 * t450;
  t452 = t451 * t423;
  t453 = t443 * t452;
  t456 = t171 * t423;
  t457 = t443 * t456;
  t461 = my_piecewise3(t51, 0, -t405 * t79 / 0.8e1 - t364 / 0.8e1 - t409 * t174 / 0.8e1 + t326 - t371 / 0.16e2 - t156 * t425 / 0.32e2 - t156 * t440 / 0.16e2 - t156 * t446 / 0.16e2 + t156 * t453 / 0.16e2 + t156 * t457 / 0.16e2);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t178 + t3 * (t394 + t461);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t467 = t255 * t185 / 0.32e2;
  t468 = t26 * t260;
  t469 = t23 * t468;
  t470 = t111 * t263;
  t471 = t265 * t268;
  t472 = t471 * t183;
  t473 = t470 * t472;
  t476 = t106 * t37;
  t478 = my_piecewise3(t39, -0.3e1 / 0.8e1 * t476, 0);
  t480 = t100 * t478 * t116;
  t483 = t26 * t100;
  t484 = t23 * t483;
  t485 = t183 * t111;
  t486 = t485 * t290;
  t489 = t183 * t263;
  t490 = t295 * t268;
  t491 = t490 * t111;
  t492 = t489 * t491;
  t495 = t183 * t43;
  t496 = t113 * t268;
  t497 = t496 * t111;
  t498 = t495 * t497;
  t502 = my_piecewise3(t2, 0, -t246 * t185 / 0.16e2 - t467 - t469 * t473 / 0.32e2 - t99 * t480 / 0.16e2 - t484 * t486 / 0.16e2 + t484 * t492 / 0.16e2 + t484 * t498 / 0.16e2);
  tv2rhosigma0 = t3 * t502 + t188;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t507 = t370 * t193 / 0.32e2;
  t509 = my_piecewise3(t51, 0, -t367 * t193 / 0.16e2 - t507);
  tv2rhosigma2 = t3 * t509 + t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t514 = my_piecewise3(t2, 0, -t345 * t185 / 0.16e2 - t467);
  tv2rhosigma3 = t3 * t514 + t188;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t518 = t26 * t415;
  t519 = t60 * t518;
  t520 = t168 * t418;
  t521 = t420 * t423;
  t522 = t521 * t191;
  t523 = t520 * t522;
  t526 = t163 * t37;
  t528 = my_piecewise3(t72, -0.3e1 / 0.8e1 * t526, 0);
  t530 = t157 * t528 * t173;
  t533 = t26 * t157;
  t534 = t60 * t533;
  t535 = t191 * t168;
  t536 = t535 * t445;
  t539 = t191 * t418;
  t540 = t450 * t423;
  t541 = t540 * t168;
  t542 = t539 * t541;
  t545 = t191 * t75;
  t546 = t170 * t423;
  t547 = t546 * t168;
  t548 = t545 * t547;
  t552 = my_piecewise3(t51, 0, -t409 * t193 / 0.16e2 - t507 - t519 * t523 / 0.32e2 - t156 * t530 / 0.16e2 - t534 * t536 / 0.16e2 + t534 * t542 / 0.16e2 + t534 * t548 / 0.16e2);
  tv2rhosigma5 = t3 * t552 + t196;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t557 = t255 * t201 / 0.32e2;
  t558 = t471 * t199;
  t559 = t470 * t558;
  t563 = my_piecewise3(t39, -t181 / 0.2e1, 0);
  t565 = t100 * t563 * t116;
  t568 = t199 * t111;
  t569 = t568 * t290;
  t572 = t199 * t263;
  t573 = t572 * t491;
  t576 = t199 * t43;
  t577 = t576 * t497;
  t581 = my_piecewise3(t2, 0, -t246 * t201 / 0.16e2 - t557 - t469 * t559 / 0.32e2 - t99 * t565 / 0.16e2 - t484 * t569 / 0.16e2 + t484 * t573 / 0.16e2 + t484 * t577 / 0.16e2);
  tv2rholapl0 = t3 * t581 + t204;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t586 = t370 * t209 / 0.32e2;
  t588 = my_piecewise3(t51, 0, -t367 * t209 / 0.16e2 - t586);
  tv2rholapl1 = t3 * t588 + t212;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t593 = my_piecewise3(t2, 0, -t345 * t201 / 0.16e2 - t557);
  tv2rholapl2 = t3 * t593 + t204;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t597 = t521 * t207;
  t598 = t520 * t597;
  t602 = my_piecewise3(t72, -t189 / 0.2e1, 0);
  t604 = t157 * t602 * t173;
  t607 = t207 * t168;
  t608 = t607 * t445;
  t611 = t207 * t418;
  t612 = t611 * t541;
  t615 = t207 * t75;
  t616 = t615 * t547;
  t620 = my_piecewise3(t51, 0, -t409 * t209 / 0.16e2 - t586 - t519 * t598 / 0.32e2 - t156 * t604 / 0.16e2 - t534 * t608 / 0.16e2 + t534 * t612 / 0.16e2 + t534 * t616 / 0.16e2);
  tv2rholapl3 = t3 * t620 + t212;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t625 = t255 * t215 / 0.32e2;
  t626 = t471 * t213;
  t627 = t470 * t626;
  t631 = my_piecewise3(t39, 0.2e1 * t181, 0);
  t633 = t100 * t631 * t116;
  t636 = t213 * t111;
  t637 = t636 * t290;
  t640 = t213 * t263;
  t641 = t640 * t491;
  t644 = t213 * t43;
  t645 = t644 * t497;
  t649 = my_piecewise3(t2, 0, -t246 * t215 / 0.16e2 - t625 - t469 * t627 / 0.32e2 - t99 * t633 / 0.16e2 - t484 * t637 / 0.16e2 + t484 * t641 / 0.16e2 + t484 * t645 / 0.16e2);
  tv2rhotau0 = t3 * t649 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t654 = t370 * t221 / 0.32e2;
  t656 = my_piecewise3(t51, 0, -t367 * t221 / 0.16e2 - t654);
  tv2rhotau1 = t3 * t656 + t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t661 = my_piecewise3(t2, 0, -t345 * t215 / 0.16e2 - t625);
  tv2rhotau2 = t3 * t661 + t218;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t665 = t521 * t219;
  t666 = t520 * t665;
  t670 = my_piecewise3(t72, 0.2e1 * t189, 0);
  t672 = t157 * t670 * t173;
  t675 = t219 * t168;
  t676 = t675 * t445;
  t679 = t219 * t418;
  t680 = t679 * t541;
  t683 = t219 * t75;
  t684 = t683 * t547;
  t688 = my_piecewise3(t51, 0, -t409 * t221 / 0.16e2 - t654 - t519 * t666 / 0.32e2 - t156 * t672 / 0.16e2 - t534 * t676 / 0.16e2 + t534 * t680 / 0.16e2 + t534 * t684 / 0.16e2);
  tv2rhotau3 = t3 * t688 + t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t690 = t183 * t183;
  t692 = t260 * t690 * t269;
  t695 = my_piecewise3(t39, 0, 0);
  t697 = t100 * t695 * t116;
  t699 = t99 * t697 / 0.16e2;
  t700 = t100 * t690;
  t701 = t700 * t290;
  t704 = t700 * t297;
  t707 = t700 * t301;
  t711 = my_piecewise3(t2, 0, -t99 * t692 / 0.32e2 - t699 - t99 * t701 / 0.16e2 + t99 * t704 / 0.16e2 + t99 * t707 / 0.16e2);
  tv2sigma20 = t3 * t711;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t712 = t191 * t191;
  t714 = t415 * t712 * t424;
  t717 = my_piecewise3(t72, 0, 0);
  t719 = t157 * t717 * t173;
  t721 = t156 * t719 / 0.16e2;
  t722 = t157 * t712;
  t723 = t722 * t445;
  t726 = t722 * t452;
  t729 = t722 * t456;
  t733 = my_piecewise3(t51, 0, -t156 * t714 / 0.32e2 - t721 - t156 * t723 / 0.16e2 + t156 * t726 / 0.16e2 + t156 * t729 / 0.16e2);
  tv2sigma25 = t3 * t733;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t734 = t489 * t558;
  t737 = t199 * t183;
  t738 = t737 * t290;
  t741 = t490 * t183;
  t742 = t572 * t741;
  t745 = t496 * t183;
  t746 = t576 * t745;
  t750 = my_piecewise3(t2, 0, -t469 * t734 / 0.32e2 - t699 - t484 * t738 / 0.16e2 + t484 * t742 / 0.16e2 + t484 * t746 / 0.16e2);
  tv2sigmalapl0 = t3 * t750;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t751 = t539 * t597;
  t754 = t207 * t191;
  t755 = t754 * t445;
  t758 = t540 * t191;
  t759 = t611 * t758;
  t762 = t546 * t191;
  t763 = t615 * t762;
  t767 = my_piecewise3(t51, 0, -t519 * t751 / 0.32e2 - t721 - t534 * t755 / 0.16e2 + t534 * t759 / 0.16e2 + t534 * t763 / 0.16e2);
  tv2sigmalapl5 = t3 * t767;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t768 = t489 * t626;
  t771 = t213 * t183;
  t772 = t771 * t290;
  t775 = t640 * t741;
  t778 = t644 * t745;
  t782 = my_piecewise3(t2, 0, -t469 * t768 / 0.32e2 - t699 - t484 * t772 / 0.16e2 + t484 * t775 / 0.16e2 + t484 * t778 / 0.16e2);
  tv2sigmatau0 = t3 * t782;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t783 = t539 * t665;
  t786 = t219 * t191;
  t787 = t786 * t445;
  t790 = t679 * t758;
  t793 = t683 * t762;
  t797 = my_piecewise3(t51, 0, -t519 * t783 / 0.32e2 - t721 - t534 * t787 / 0.16e2 + t534 * t790 / 0.16e2 + t534 * t793 / 0.16e2);
  tv2sigmatau5 = t3 * t797;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t798 = t199 * t199;
  t800 = t260 * t798 * t269;
  t803 = t100 * t798;
  t804 = t803 * t290;
  t807 = t803 * t297;
  t810 = t803 * t301;
  t814 = my_piecewise3(t2, 0, -t99 * t800 / 0.32e2 - t699 - t99 * t804 / 0.16e2 + t99 * t807 / 0.16e2 + t99 * t810 / 0.16e2);
  tv2lapl20 = t3 * t814;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t815 = t207 * t207;
  t817 = t415 * t815 * t424;
  t820 = t157 * t815;
  t821 = t820 * t445;
  t824 = t820 * t452;
  t827 = t820 * t456;
  t831 = my_piecewise3(t51, 0, -t156 * t817 / 0.32e2 - t721 - t156 * t821 / 0.16e2 + t156 * t824 / 0.16e2 + t156 * t827 / 0.16e2);
  tv2lapl22 = t3 * t831;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t832 = t572 * t626;
  t835 = t213 * t199;
  t836 = t835 * t290;
  t839 = t490 * t199;
  t840 = t640 * t839;
  t843 = t496 * t199;
  t844 = t644 * t843;
  t848 = my_piecewise3(t2, 0, -t469 * t832 / 0.32e2 - t699 - t484 * t836 / 0.16e2 + t484 * t840 / 0.16e2 + t484 * t844 / 0.16e2);
  tv2lapltau0 = t3 * t848;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t849 = t611 * t665;
  t852 = t219 * t207;
  t853 = t852 * t445;
  t856 = t540 * t207;
  t857 = t679 * t856;
  t860 = t546 * t207;
  t861 = t683 * t860;
  t865 = my_piecewise3(t51, 0, -t519 * t849 / 0.32e2 - t721 - t534 * t853 / 0.16e2 + t534 * t857 / 0.16e2 + t534 * t861 / 0.16e2);
  tv2lapltau3 = t3 * t865;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t866 = t213 * t213;
  t868 = t260 * t866 * t269;
  t871 = t100 * t866;
  t872 = t871 * t290;
  t875 = t871 * t297;
  t878 = t871 * t301;
  t882 = my_piecewise3(t2, 0, -t99 * t868 / 0.32e2 - t699 - t99 * t872 / 0.16e2 + t99 * t875 / 0.16e2 + t99 * t878 / 0.16e2);
  tv2tau20 = t3 * t882;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t883 = t219 * t219;
  t885 = t415 * t883 * t424;
  t888 = t157 * t883;
  t889 = t888 * t445;
  t892 = t888 * t452;
  t895 = t888 * t456;
  t899 = my_piecewise3(t51, 0, -t156 * t885 / 0.32e2 - t721 - t156 * t889 / 0.16e2 + t156 * t892 / 0.16e2 + t156 * t895 / 0.16e2);
  tv2tau22 = t3 * t899;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t902 = 0.1e1 / t21;
  t903 = t228 * t87;
  t906 = t227 * t87;
  t909 = t83 * t83;
  t910 = 0.1e1 / t909;
  t911 = t13 * t910;
  t914 = my_piecewise5(t7, 0, t11, 0, 0.6e1 * t232 - 0.6e1 * t911);
  t918 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t902 * t903 + 0.9e1 / 0.4e1 * t906 * t236 + 0.3e1 / 0.2e1 * t20 * t914);
  t919 = M_PI * t918;
  t924 = t24 / t25 / t83;
  t925 = t924 * t46;
  t927 = 0.3e1 / 0.64e2 * t23 * t925;
  t928 = t241 * t96;
  t930 = t91 * t252;
  t932 = t261 * t111;
  t933 = t100 * t932;
  t934 = t264 * t264;
  t935 = 0.1e1 / t934;
  t936 = t263 * t935;
  t938 = 0.1e1 / t267 / t40;
  t939 = t936 * t938;
  t940 = t933 * t939;
  t943 = t263 * t43;
  t945 = 0.1e1 / t934 / t44;
  t946 = t943 * t945;
  t947 = t946 * t938;
  t948 = t933 * t947;
  t953 = t255 * t298;
  t955 = t260 * t932;
  t956 = t296 * t938;
  t957 = t955 * t956;
  t960 = t114 * t938;
  t961 = t933 * t960;
  t964 = t266 * t938;
  t965 = t955 * t964;
  t968 = t289 * t938;
  t969 = t933 * t968;
  t972 = t933 * t956;
  t977 = t255 * t302;
  t981 = -t919 * t47 / 0.8e1 - t927 - 0.3e1 / 0.16e2 * t928 + 0.3e1 / 0.32e2 * t930 + t99 * t940 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t948 + 0.3e1 / 0.16e2 * t246 * t298 + 0.3e1 / 0.32e2 * t953 - 0.3e1 / 0.32e2 * t99 * t957 - t99 * t961 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t965 + 0.3e1 / 0.16e2 * t99 * t969 - 0.3e1 / 0.16e2 * t99 * t972 + 0.3e1 / 0.16e2 * t246 * t302 + 0.3e1 / 0.32e2 * t977 - 0.3e1 / 0.16e2 * t246 * t285;
  t984 = t23 * t251;
  t985 = t984 * t117;
  t987 = t255 * t285;
  t989 = t255 * t270;
  t991 = t45 * t45;
  t992 = 0.1e1 / t991;
  t993 = t992 * t100;
  t996 = t258 * t260;
  t1000 = t993 * t111 * t116 / 0.2e1 - t996 * t111 * t116 / 0.2e1 + t117 / 0.2e1;
  t1002 = t1000 * t261 * t269;
  t1010 = 0.1e1 / t105 / t27;
  t1015 = my_piecewise3(t39, (-0.6e1 * lapl[0] * t278 + 0.24e2 * tau[0] * t278 - 0.15e2 / 0.2e1 * sigma[0] * t1010) * t37, 0);
  t1017 = t100 * t1015 * t116;
  t1020 = t241 * t26;
  t1023 = t91 * t95;
  t1024 = t1023 * t117;
  t1028 = t255 * t291;
  t1030 = t43 * t295;
  t1031 = t1030 * t938;
  t1032 = t933 * t1031;
  t1035 = t943 * t935;
  t1036 = t1035 * t938;
  t1037 = t955 * t1036;
  t1041 = t470 * t471 * t283;
  t1045 = t283 * t111 * t290;
  t1048 = t283 * t263;
  t1049 = t1048 * t491;
  t1053 = t283 * t43 * t497;
  t1056 = -0.3e1 / 0.32e2 * t246 * t270 + 0.3e1 / 0.64e2 * t985 - 0.3e1 / 0.32e2 * t987 - 0.3e1 / 0.64e2 * t989 - t99 * t1002 / 0.32e2 - t99 * t1017 / 0.16e2 - 0.3e1 / 0.16e2 * t1020 * t117 - 0.3e1 / 0.16e2 * t1024 - 0.3e1 / 0.16e2 * t246 * t291 - 0.3e1 / 0.32e2 * t1028 - t99 * t1032 / 0.16e2 + 0.3e1 / 0.32e2 * t99 * t1037 - 0.3e1 / 0.32e2 * t469 * t1041 - 0.3e1 / 0.16e2 * t484 * t1045 + 0.3e1 / 0.16e2 * t484 * t1049 + 0.3e1 / 0.16e2 * t484 * t1053;
  t1058 = my_piecewise3(t2, 0, t981 + t1056);
  t1059 = 0.1e1 / t58;
  t1060 = t308 * t124;
  t1063 = t307 * t124;
  t1066 = t52 * t910;
  t1069 = my_piecewise5(t11, 0, t7, 0, -0.6e1 * t232 - 0.6e1 * t1066);
  t1073 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1060 + 0.9e1 / 0.4e1 * t1063 * t314 + 0.3e1 / 0.2e1 * t57 * t1069);
  t1074 = M_PI * t1073;
  t1077 = t319 * t131;
  t1079 = t128 * t324;
  t1081 = t924 * t78;
  t1083 = 0.3e1 / 0.64e2 * t60 * t1081;
  t1085 = my_piecewise3(t51, 0, -t1074 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t1077 + 0.3e1 / 0.32e2 * t1079 - t1083);
  tv3rho30 = 0.3e1 * t306 + 0.3e1 * t328 + t3 * (t1058 + t1085);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1088 = 0.2e1 * t351;
  t1089 = 0.2e1 * t374;
  t1093 = t902 * t139;
  t1096 = t227 * t335;
  t1101 = 0.2e1 * t232;
  t1102 = 0.6e1 * t911;
  t1104 = my_piecewise5(t7, 0, t11, 0, t1101 - t1102);
  t1108 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1093 * t228 + 0.3e1 / 0.2e1 * t1096 * t87 + 0.3e1 / 0.4e1 * t331 * t236 + 0.3e1 / 0.2e1 * t20 * t1104);
  t1109 = M_PI * t1108;
  t1113 = t340 * t96 / 0.8e1;
  t1114 = t143 * t252;
  t1124 = t340 * t26;
  t1127 = t143 * t95;
  t1129 = t1127 * t117 / 0.16e2;
  t1138 = -t1028 / 0.32e2 - t345 * t291 / 0.16e2 - t1109 * t47 / 0.8e1 - t1113 + t1114 / 0.32e2 - t927 - t928 / 0.16e2 + t930 / 0.16e2 + t345 * t298 / 0.16e2 + t953 / 0.32e2 + t345 * t302 / 0.16e2 + t977 / 0.32e2 - t1124 * t117 / 0.8e1 - t1129 - t345 * t285 / 0.16e2 - t345 * t270 / 0.32e2 + t985 / 0.32e2 - t987 / 0.32e2 - t989 / 0.64e2 - t1024 / 0.16e2;
  t1139 = my_piecewise3(t2, 0, t1138);
  t1140 = t1059 * t149;
  t1143 = t307 * t356;
  t1148 = 0.6e1 * t1066;
  t1150 = my_piecewise5(t11, 0, t7, 0, -t1101 - t1148);
  t1154 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1140 * t308 + 0.3e1 / 0.2e1 * t1143 * t124 + 0.3e1 / 0.4e1 * t352 * t314 + 0.3e1 / 0.2e1 * t57 * t1150);
  t1155 = M_PI * t1154;
  t1159 = t361 * t131 / 0.8e1;
  t1160 = t153 * t324;
  t1164 = t319 * t26;
  t1167 = t128 * t95;
  t1169 = t1167 * t174 / 0.16e2;
  t1170 = t60 * t251;
  t1171 = t1170 * t174;
  t1174 = my_piecewise3(t51, 0, -t1155 * t79 / 0.8e1 - t1159 + t1160 / 0.32e2 - t1077 / 0.16e2 + t1079 / 0.16e2 - t1083 - t1164 * t174 / 0.16e2 - t1169 + t1171 / 0.64e2);
  tv3rho31 = t306 + t328 + t1088 + t1089 + t3 * (t1139 + t1174);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1177 = t902 * t379;
  t1182 = t227 * t384;
  t1186 = my_piecewise5(t7, 0, t11, 0, -t1101 - t1102);
  t1190 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1177 * t87 + 0.3e1 / 0.2e1 * t331 * t335 + 0.3e1 / 0.4e1 * t1182 * t87 + 0.3e1 / 0.2e1 * t20 * t1186);
  t1191 = M_PI * t1190;
  t1194 = t389 * t96;
  t1196 = t389 * t26;
  t1203 = my_piecewise3(t2, 0, -t1191 * t47 / 0.8e1 - t1194 / 0.16e2 - t1196 * t117 / 0.16e2 - t1113 + t1114 / 0.16e2 - t1129 + t930 / 0.32e2 - t927 + t985 / 0.64e2);
  t1204 = t1059 * t395;
  t1209 = t307 * t400;
  t1213 = my_piecewise5(t11, 0, t7, 0, t1101 - t1148);
  t1217 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1204 * t124 + 0.3e1 / 0.2e1 * t352 * t356 + 0.3e1 / 0.4e1 * t1209 * t124 + 0.3e1 / 0.2e1 * t57 * t1213);
  t1218 = M_PI * t1217;
  t1221 = t405 * t131;
  t1224 = t361 * t26;
  t1227 = t153 * t95;
  t1228 = t1227 * t174;
  t1234 = t370 * t425;
  t1238 = t370 * t440;
  t1242 = t370 * t446;
  t1246 = t370 * t453;
  t1250 = t370 * t457;
  t1252 = -t1218 * t79 / 0.8e1 - t1221 / 0.16e2 - t1159 + t1160 / 0.16e2 - t1224 * t174 / 0.8e1 - t1228 / 0.16e2 + t1079 / 0.32e2 - t1083 - t1169 + t1171 / 0.32e2 - t367 * t425 / 0.32e2 - t1234 / 0.64e2 - t367 * t440 / 0.16e2 - t1238 / 0.32e2 - t367 * t446 / 0.16e2 - t1242 / 0.32e2 + t367 * t453 / 0.16e2 + t1246 / 0.32e2 + t367 * t457 / 0.16e2 + t1250 / 0.32e2;
  t1253 = my_piecewise3(t51, 0, t1252);
  tv3rho32 = t1088 + t1089 + t394 + t461 + t3 * (t1203 + t1253);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1258 = t379 * t139;
  t1265 = my_piecewise5(t7, 0, t11, 0, -0.6e1 * t232 - 0.6e1 * t911);
  t1269 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t902 * t1258 + 0.9e1 / 0.4e1 * t331 * t384 + 0.3e1 / 0.2e1 * t20 * t1265);
  t1270 = M_PI * t1269;
  t1276 = my_piecewise3(t2, 0, -t1270 * t47 / 0.8e1 - 0.3e1 / 0.16e2 * t1194 + 0.3e1 / 0.32e2 * t1114 - t927);
  t1279 = t395 * t149;
  t1286 = my_piecewise5(t11, 0, t7, 0, 0.6e1 * t232 - 0.6e1 * t1066);
  t1290 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1279 + 0.9e1 / 0.4e1 * t352 * t400 + 0.3e1 / 0.2e1 * t57 * t1286);
  t1291 = M_PI * t1290;
  t1298 = t520 * t521 * t438;
  t1302 = t438 * t75 * t547;
  t1306 = t438 * t168 * t445;
  t1309 = t438 * t418;
  t1310 = t1309 * t541;
  t1313 = t405 * t26;
  t1320 = t77 * t77;
  t1321 = 0.1e1 / t1320;
  t1322 = t1321 * t157;
  t1325 = t413 * t415;
  t1329 = t1322 * t168 * t173 / 0.2e1 - t1325 * t168 * t173 / 0.2e1 + t174 / 0.2e1;
  t1331 = t1329 * t416 * t424;
  t1339 = 0.1e1 / t162 / t61;
  t1344 = my_piecewise3(t72, (-0.6e1 * lapl[1] * t433 + 0.24e2 * tau[1] * t433 - 0.15e2 / 0.2e1 * sigma[2] * t1339) * t37, 0);
  t1346 = t157 * t1344 * t173;
  t1349 = -t1083 + 0.3e1 / 0.32e2 * t1160 - 0.3e1 / 0.16e2 * t1221 - t1291 * t79 / 0.8e1 + 0.3e1 / 0.64e2 * t1171 - 0.3e1 / 0.16e2 * t1228 - 0.3e1 / 0.64e2 * t1234 - 0.3e1 / 0.32e2 * t519 * t1298 + 0.3e1 / 0.16e2 * t534 * t1302 - 0.3e1 / 0.16e2 * t534 * t1306 + 0.3e1 / 0.16e2 * t534 * t1310 - 0.3e1 / 0.16e2 * t1313 * t174 - 0.3e1 / 0.16e2 * t409 * t440 - 0.3e1 / 0.32e2 * t409 * t425 - t156 * t1331 / 0.32e2 - t156 * t1346 / 0.16e2;
  t1356 = t416 * t168;
  t1357 = t157 * t1356;
  t1358 = t75 * t450;
  t1360 = 0.1e1 / t422 / t73;
  t1361 = t1358 * t1360;
  t1362 = t1357 * t1361;
  t1365 = t415 * t1356;
  t1366 = t451 * t1360;
  t1367 = t1365 * t1366;
  t1370 = t418 * t75;
  t1371 = t419 * t419;
  t1372 = 0.1e1 / t1371;
  t1373 = t1370 * t1372;
  t1374 = t1373 * t1360;
  t1375 = t1365 * t1374;
  t1378 = t418 * t1372;
  t1379 = t1378 * t1360;
  t1380 = t1357 * t1379;
  t1384 = 0.1e1 / t1371 / t76;
  t1385 = t1370 * t1384;
  t1386 = t1385 * t1360;
  t1387 = t1357 * t1386;
  t1392 = t444 * t1360;
  t1393 = t1357 * t1392;
  t1396 = t1357 * t1366;
  t1399 = t171 * t1360;
  t1400 = t1357 * t1399;
  t1405 = t421 * t1360;
  t1406 = t1365 * t1405;
  t1409 = -0.3e1 / 0.32e2 * t1238 - 0.3e1 / 0.32e2 * t1242 + 0.3e1 / 0.32e2 * t1246 + 0.3e1 / 0.32e2 * t1250 - 0.3e1 / 0.16e2 * t409 * t446 - t156 * t1362 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t1367 + 0.3e1 / 0.32e2 * t156 * t1375 + t156 * t1380 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t1387 + 0.3e1 / 0.16e2 * t409 * t453 + 0.3e1 / 0.16e2 * t156 * t1393 - 0.3e1 / 0.16e2 * t156 * t1396 - t156 * t1400 / 0.8e1 + 0.3e1 / 0.16e2 * t409 * t457 + 0.3e1 / 0.32e2 * t156 * t1406;
  t1411 = my_piecewise3(t51, 0, t1349 + t1409);
  tv3rho33 = 0.3e1 * t394 + 0.3e1 * t461 + t3 * (t1276 + t1411);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1415 = t91 * t483;
  t1418 = t95 * t100;
  t1419 = t23 * t1418;
  t1420 = t1419 * t486;
  t1422 = t1023 * t185;
  t1425 = t984 * t185 / 0.64e2;
  t1430 = t255 * t480;
  t1432 = t278 * t37;
  t1434 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t1432, 0);
  t1436 = t100 * t1434 * t116;
  t1440 = t478 * t111 * t290;
  t1445 = t1419 * t492;
  t1447 = t478 * t263;
  t1448 = t1447 * t491;
  t1451 = t183 * t261;
  t1452 = t1451 * t1031;
  t1455 = t1451 * t968;
  t1458 = t295 * t938;
  t1459 = t1458 * t261;
  t1460 = t489 * t1459;
  t1463 = t113 * t938;
  t1464 = t1463 * t261;
  t1465 = t495 * t1464;
  t1468 = -t1415 * t486 / 0.8e1 - t1420 / 0.16e2 - t1422 / 0.16e2 + t1425 - t1020 * t185 / 0.16e2 - t246 * t480 / 0.8e1 - t1430 / 0.16e2 - t99 * t1436 / 0.16e2 - t484 * t1440 / 0.8e1 + t1415 * t492 / 0.8e1 + t1445 / 0.16e2 + t484 * t1448 / 0.8e1 - t484 * t1452 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t1455 - 0.3e1 / 0.16e2 * t484 * t1460 - t484 * t1465 / 0.8e1;
  t1469 = t261 * t263;
  t1470 = t265 * t938;
  t1471 = t1470 * t183;
  t1472 = t1469 * t1471;
  t1475 = t496 * t283;
  t1476 = t495 * t1475;
  t1479 = t478 * t43;
  t1480 = t1479 * t497;
  t1483 = t183 * t283;
  t1484 = t1483 * t290;
  t1487 = t490 * t283;
  t1488 = t489 * t1487;
  t1493 = t91 * t468;
  t1496 = t1419 * t498;
  t1498 = t95 * t260;
  t1499 = t23 * t1498;
  t1500 = t1499 * t473;
  t1502 = t26 * t1000;
  t1503 = t23 * t1502;
  t1506 = t1048 * t472;
  t1509 = t471 * t478;
  t1510 = t470 * t1509;
  t1515 = t261 * t943;
  t1516 = t935 * t938;
  t1517 = t1516 * t183;
  t1518 = t1515 * t1517;
  t1521 = t1451 * t939;
  t1524 = t183 * t943;
  t1525 = t945 * t938;
  t1526 = t1525 * t261;
  t1527 = t1524 * t1526;
  t1530 = 0.3e1 / 0.32e2 * t469 * t1472 + t484 * t1476 / 0.16e2 + t484 * t1480 / 0.8e1 - t484 * t1484 / 0.16e2 + t484 * t1488 / 0.16e2 + t1415 * t498 / 0.8e1 - t1493 * t473 / 0.16e2 + t1496 / 0.16e2 - t1500 / 0.32e2 - t1503 * t473 / 0.32e2 - t469 * t1506 / 0.32e2 - t469 * t1510 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t1460 + 0.3e1 / 0.32e2 * t469 * t1518 + t484 * t1521 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1527;
  t1532 = my_piecewise3(t2, 0, t1468 + t1530);
  tv3rho2sigma0 = t3 * t1532 + 0.2e1 * t502;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1537 = t1167 * t193;
  t1540 = t1170 * t193 / 0.64e2;
  t1542 = my_piecewise3(t51, 0, -t1164 * t193 / 0.16e2 - t1537 / 0.16e2 + t1540);
  tv3rho2sigma2 = t3 * t1542 + 0.2e1 * t509;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1546 = t1127 * t185;
  t1548 = t143 * t468;
  t1553 = t143 * t483;
  t1566 = -t1124 * t185 / 0.16e2 - t1546 / 0.32e2 - t1548 * t473 / 0.32e2 - t345 * t480 / 0.16e2 - t1553 * t486 / 0.16e2 + t1553 * t492 / 0.16e2 + t1553 * t498 / 0.16e2 - t1422 / 0.32e2 + t1425 - t1500 / 0.64e2 - t1430 / 0.32e2 - t1420 / 0.32e2 + t1445 / 0.32e2 + t1496 / 0.32e2;
  t1567 = my_piecewise3(t2, 0, t1566);
  tv3rho2sigma3 = t3 * t1567 + t502 + t514;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1571 = t1227 * t193;
  t1574 = t128 * t518;
  t1577 = t95 * t415;
  t1578 = t60 * t1577;
  t1579 = t1578 * t523;
  t1583 = t370 * t530;
  t1585 = t128 * t533;
  t1588 = t95 * t157;
  t1589 = t60 * t1588;
  t1590 = t1589 * t536;
  t1594 = t1589 * t542;
  t1598 = t1589 * t548;
  t1600 = -t1224 * t193 / 0.16e2 - t1571 / 0.32e2 - t1537 / 0.32e2 + t1540 - t1574 * t523 / 0.32e2 - t1579 / 0.64e2 - t367 * t530 / 0.16e2 - t1583 / 0.32e2 - t1585 * t536 / 0.16e2 - t1590 / 0.32e2 + t1585 * t542 / 0.16e2 + t1594 / 0.32e2 + t1585 * t548 / 0.16e2 + t1598 / 0.32e2;
  t1601 = my_piecewise3(t51, 0, t1600);
  tv3rho2sigma5 = t3 * t1601 + t509 + t552;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1608 = my_piecewise3(t2, 0, -t1196 * t185 / 0.16e2 - t1546 / 0.16e2 + t1425);
  tv3rho2sigma6 = t3 * t1608 + 0.2e1 * t514;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1611 = t433 * t37;
  t1613 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t1611, 0);
  t1615 = t157 * t1613 * t173;
  t1622 = t416 * t418;
  t1623 = t450 * t1360;
  t1624 = t1623 * t191;
  t1625 = t1622 * t1624;
  t1628 = t416 * t1370;
  t1629 = t1372 * t1360;
  t1630 = t1629 * t191;
  t1631 = t1628 * t1630;
  t1634 = t191 * t416;
  t1635 = t1634 * t1379;
  t1638 = t191 * t1370;
  t1639 = t1384 * t1360;
  t1640 = t1639 * t416;
  t1641 = t1638 * t1640;
  t1650 = t546 * t438;
  t1651 = t545 * t1650;
  t1654 = t26 * t1329;
  t1655 = t60 * t1654;
  t1658 = -t156 * t1615 / 0.16e2 - t1313 * t193 / 0.16e2 - t409 * t530 / 0.8e1 - 0.3e1 / 0.32e2 * t519 * t1625 + 0.3e1 / 0.32e2 * t519 * t1631 + t534 * t1635 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1641 + t1540 - t1571 / 0.16e2 - t1583 / 0.16e2 - t1579 / 0.32e2 - t1590 / 0.16e2 + t1594 / 0.16e2 + t1598 / 0.16e2 + t534 * t1651 / 0.16e2 - t1655 * t523 / 0.32e2;
  t1659 = t1309 * t522;
  t1662 = t521 * t528;
  t1663 = t520 * t1662;
  t1666 = t528 * t75;
  t1667 = t1666 * t547;
  t1670 = t191 * t438;
  t1671 = t1670 * t445;
  t1674 = t540 * t438;
  t1675 = t539 * t1674;
  t1678 = t153 * t533;
  t1681 = t153 * t518;
  t1685 = t528 * t168 * t445;
  t1692 = t528 * t418;
  t1693 = t1692 * t541;
  t1696 = t1634 * t1361;
  t1701 = t170 * t1360;
  t1702 = t1701 * t416;
  t1703 = t545 * t1702;
  t1706 = t420 * t1360;
  t1707 = t1706 * t191;
  t1708 = t1622 * t1707;
  t1711 = t1634 * t1392;
  t1714 = -t519 * t1659 / 0.32e2 - t519 * t1663 / 0.16e2 + t534 * t1667 / 0.8e1 - t534 * t1671 / 0.16e2 + t534 * t1675 / 0.16e2 + t1678 * t548 / 0.8e1 - t1681 * t523 / 0.16e2 - t534 * t1685 / 0.8e1 - t1678 * t536 / 0.8e1 + t1678 * t542 / 0.8e1 + t534 * t1693 / 0.8e1 - t534 * t1696 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t1625 - t534 * t1703 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t1708 + 0.3e1 / 0.16e2 * t534 * t1711;
  t1716 = my_piecewise3(t51, 0, t1658 + t1714);
  tv3rho2sigma8 = t3 * t1716 + 0.2e1 * t552;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1720 = t984 * t201 / 0.64e2;
  t1721 = t1023 * t201;
  t1723 = t255 * t565;
  t1726 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t476, 0);
  t1728 = t100 * t1726 * t116;
  t1735 = t199 * t943;
  t1736 = t1735 * t1526;
  t1739 = t1458 * t199;
  t1740 = t1469 * t1739;
  t1743 = t1516 * t199;
  t1744 = t1515 * t1743;
  t1747 = t1048 * t558;
  t1750 = t471 * t563;
  t1751 = t470 * t1750;
  t1754 = t563 * t43;
  t1755 = t1754 * t497;
  t1760 = t1419 * t569;
  t1763 = t563 * t111 * t290;
  t1768 = t1720 - t1721 / 0.16e2 - t1723 / 0.16e2 - t99 * t1728 / 0.16e2 - t1020 * t201 / 0.16e2 - t246 * t565 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t1736 - 0.3e1 / 0.32e2 * t469 * t1740 + 0.3e1 / 0.32e2 * t469 * t1744 - t469 * t1747 / 0.32e2 - t469 * t1751 / 0.16e2 + t484 * t1755 / 0.8e1 - t1415 * t569 / 0.8e1 - t1760 / 0.16e2 - t484 * t1763 / 0.8e1 + t1415 * t573 / 0.8e1;
  t1769 = t1419 * t573;
  t1771 = t563 * t263;
  t1772 = t1771 * t491;
  t1775 = t199 * t261;
  t1776 = t1775 * t1031;
  t1779 = t1775 * t968;
  t1784 = t576 * t1464;
  t1787 = t1470 * t199;
  t1788 = t1469 * t1787;
  t1791 = t1775 * t939;
  t1794 = t199 * t283;
  t1795 = t1794 * t290;
  t1798 = t572 * t1487;
  t1801 = t576 * t1475;
  t1808 = t1419 * t577;
  t1810 = t1499 * t559;
  t1814 = t1769 / 0.16e2 + t484 * t1772 / 0.8e1 - t484 * t1776 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t1779 - 0.3e1 / 0.16e2 * t484 * t1740 - t484 * t1784 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1788 + t484 * t1791 / 0.4e1 - t484 * t1795 / 0.16e2 + t484 * t1798 / 0.16e2 + t484 * t1801 / 0.16e2 + t1415 * t577 / 0.8e1 - t1493 * t559 / 0.16e2 + t1808 / 0.16e2 - t1810 / 0.32e2 - t1503 * t559 / 0.32e2;
  t1816 = my_piecewise3(t2, 0, t1768 + t1814);
  tv3rho2lapl0 = t3 * t1816 + 0.2e1 * t581;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1821 = t1167 * t209;
  t1824 = t1170 * t209 / 0.64e2;
  t1826 = my_piecewise3(t51, 0, -t1164 * t209 / 0.16e2 - t1821 / 0.16e2 + t1824);
  tv3rho2lapl1 = t3 * t1826 + 0.2e1 * t588;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1830 = t1127 * t201;
  t1848 = -t1124 * t201 / 0.16e2 - t1830 / 0.32e2 - t1548 * t559 / 0.32e2 - t345 * t565 / 0.16e2 - t1553 * t569 / 0.16e2 + t1553 * t573 / 0.16e2 + t1553 * t577 / 0.16e2 - t1721 / 0.32e2 + t1720 - t1810 / 0.64e2 - t1723 / 0.32e2 - t1760 / 0.32e2 + t1769 / 0.32e2 + t1808 / 0.32e2;
  t1849 = my_piecewise3(t2, 0, t1848);
  tv3rho2lapl2 = t3 * t1849 + t581 + t593;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1853 = t1227 * t209;
  t1858 = t1578 * t598;
  t1862 = t370 * t604;
  t1866 = t1589 * t608;
  t1870 = t1589 * t612;
  t1874 = t1589 * t616;
  t1876 = -t1224 * t209 / 0.16e2 - t1853 / 0.32e2 - t1821 / 0.32e2 + t1824 - t1574 * t598 / 0.32e2 - t1858 / 0.64e2 - t367 * t604 / 0.16e2 - t1862 / 0.32e2 - t1585 * t608 / 0.16e2 - t1866 / 0.32e2 + t1585 * t612 / 0.16e2 + t1870 / 0.32e2 + t1585 * t616 / 0.16e2 + t1874 / 0.32e2;
  t1877 = my_piecewise3(t51, 0, t1876);
  tv3rho2lapl3 = t3 * t1877 + t588 + t620;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1884 = my_piecewise3(t2, 0, -t1196 * t201 / 0.16e2 - t1830 / 0.16e2 + t1720);
  tv3rho2lapl4 = t3 * t1884 + 0.2e1 * t593;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1892 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t526, 0);
  t1894 = t157 * t1892 * t173;
  t1901 = t602 * t168;
  t1902 = t1901 * t445;
  t1907 = t602 * t418;
  t1908 = t1907 * t541;
  t1911 = t207 * t416;
  t1912 = t1911 * t1361;
  t1915 = t207 * t438;
  t1916 = t1915 * t445;
  t1919 = t611 * t1674;
  t1922 = t615 * t1650;
  t1929 = -t1313 * t209 / 0.16e2 - t409 * t604 / 0.8e1 - t156 * t1894 / 0.16e2 - t1853 / 0.16e2 - t1862 / 0.16e2 + t1824 - t1678 * t608 / 0.8e1 - t534 * t1902 / 0.8e1 + t1678 * t612 / 0.8e1 + t534 * t1908 / 0.8e1 - t534 * t1912 / 0.16e2 - t534 * t1916 / 0.16e2 + t534 * t1919 / 0.16e2 + t534 * t1922 / 0.16e2 - t1681 * t598 / 0.16e2 - t1655 * t598 / 0.32e2;
  t1930 = t1309 * t597;
  t1933 = t521 * t602;
  t1934 = t520 * t1933;
  t1937 = t602 * t75;
  t1938 = t1937 * t547;
  t1947 = t1623 * t416;
  t1948 = t611 * t1947;
  t1951 = t615 * t1702;
  t1954 = t1706 * t207;
  t1955 = t1622 * t1954;
  t1958 = t1911 * t1392;
  t1961 = t1911 * t1379;
  t1964 = t207 * t1370;
  t1965 = t1964 * t1640;
  t1970 = t1629 * t207;
  t1971 = t1628 * t1970;
  t1974 = -t519 * t1930 / 0.32e2 - t519 * t1934 / 0.16e2 + t534 * t1938 / 0.8e1 + t1678 * t616 / 0.8e1 - t1858 / 0.32e2 - t1866 / 0.16e2 + t1870 / 0.16e2 + t1874 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t1948 - t534 * t1951 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t1955 + 0.3e1 / 0.16e2 * t534 * t1958 + t534 * t1961 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1965 - 0.3e1 / 0.32e2 * t519 * t1948 + 0.3e1 / 0.32e2 * t519 * t1971;
  t1976 = my_piecewise3(t51, 0, t1929 + t1974);
  tv3rho2lapl5 = t3 * t1976 + 0.2e1 * t620;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1979 = t213 * t261;
  t1980 = t1979 * t1031;
  t1983 = t1979 * t968;
  t1986 = t640 * t1459;
  t1989 = t644 * t1464;
  t1992 = t1470 * t213;
  t1993 = t1469 * t1992;
  t1998 = t1516 * t213;
  t1999 = t1515 * t1998;
  t2002 = t1979 * t939;
  t2005 = t213 * t943;
  t2006 = t2005 * t1526;
  t2009 = t471 * t631;
  t2010 = t470 * t2009;
  t2013 = t631 * t43;
  t2014 = t2013 * t497;
  t2017 = t213 * t283;
  t2018 = t2017 * t290;
  t2021 = t640 * t1487;
  t2028 = t1419 * t645;
  t2030 = -t484 * t1980 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t1983 - 0.3e1 / 0.16e2 * t484 * t1986 - t484 * t1989 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1993 - 0.3e1 / 0.32e2 * t469 * t1986 + 0.3e1 / 0.32e2 * t469 * t1999 + t484 * t2002 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2006 - t469 * t2010 / 0.16e2 + t484 * t2014 / 0.8e1 - t484 * t2018 / 0.16e2 + t484 * t2021 / 0.16e2 + t1415 * t645 / 0.8e1 - t1493 * t627 / 0.16e2 + t2028 / 0.16e2;
  t2031 = t1499 * t627;
  t2035 = t1048 * t626;
  t2040 = t1419 * t637;
  t2043 = t631 * t111 * t290;
  t2048 = t1419 * t641;
  t2050 = t631 * t263;
  t2051 = t2050 * t491;
  t2054 = t1023 * t215;
  t2057 = t984 * t215 / 0.64e2;
  t2062 = t255 * t633;
  t2065 = my_piecewise3(t39, -0.6e1 * t476, 0);
  t2067 = t100 * t2065 * t116;
  t2070 = t644 * t1475;
  t2073 = -t2031 / 0.32e2 - t1503 * t627 / 0.32e2 - t469 * t2035 / 0.32e2 - t1415 * t637 / 0.8e1 - t2040 / 0.16e2 - t484 * t2043 / 0.8e1 + t1415 * t641 / 0.8e1 + t2048 / 0.16e2 + t484 * t2051 / 0.8e1 - t2054 / 0.16e2 + t2057 - t1020 * t215 / 0.16e2 - t246 * t633 / 0.8e1 - t2062 / 0.16e2 - t99 * t2067 / 0.16e2 + t484 * t2070 / 0.16e2;
  t2075 = my_piecewise3(t2, 0, t2030 + t2073);
  tv3rho2tau0 = t3 * t2075 + 0.2e1 * t649;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2080 = t1167 * t221;
  t2083 = t1170 * t221 / 0.64e2;
  t2085 = my_piecewise3(t51, 0, -t1164 * t221 / 0.16e2 - t2080 / 0.16e2 + t2083);
  tv3rho2tau1 = t3 * t2085 + 0.2e1 * t656;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2089 = t1127 * t215;
  t2107 = -t1124 * t215 / 0.16e2 - t2089 / 0.32e2 - t1548 * t627 / 0.32e2 - t345 * t633 / 0.16e2 - t1553 * t637 / 0.16e2 + t1553 * t641 / 0.16e2 + t1553 * t645 / 0.16e2 - t2054 / 0.32e2 + t2057 - t2031 / 0.64e2 - t2062 / 0.32e2 - t2040 / 0.32e2 + t2048 / 0.32e2 + t2028 / 0.32e2;
  t2108 = my_piecewise3(t2, 0, t2107);
  tv3rho2tau2 = t3 * t2108 + t649 + t661;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2112 = t1227 * t221;
  t2117 = t1578 * t666;
  t2121 = t370 * t672;
  t2125 = t1589 * t676;
  t2129 = t1589 * t680;
  t2133 = t1589 * t684;
  t2135 = -t1224 * t221 / 0.16e2 - t2112 / 0.32e2 - t2080 / 0.32e2 + t2083 - t1574 * t666 / 0.32e2 - t2117 / 0.64e2 - t367 * t672 / 0.16e2 - t2121 / 0.32e2 - t1585 * t676 / 0.16e2 - t2125 / 0.32e2 + t1585 * t680 / 0.16e2 + t2129 / 0.32e2 + t1585 * t684 / 0.16e2 + t2133 / 0.32e2;
  t2136 = my_piecewise3(t51, 0, t2135);
  tv3rho2tau3 = t3 * t2136 + t656 + t688;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2143 = my_piecewise3(t2, 0, -t1196 * t215 / 0.16e2 - t2089 / 0.16e2 + t2057);
  tv3rho2tau4 = t3 * t2143 + 0.2e1 * t661;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2146 = t1706 * t219;
  t2147 = t1622 * t2146;
  t2150 = t219 * t416;
  t2151 = t2150 * t1392;
  t2155 = t1622 * t1623 * t219;
  t2158 = t1629 * t219;
  t2159 = t1628 * t2158;
  t2162 = t2150 * t1379;
  t2165 = t219 * t1370;
  t2166 = t2165 * t1640;
  t2169 = t679 * t1674;
  t2178 = t1309 * t665;
  t2181 = t521 * t670;
  t2182 = t520 * t2181;
  t2188 = t670 * t168 * t445;
  t2193 = t670 * t418;
  t2194 = t2193 * t541;
  t2197 = 0.3e1 / 0.32e2 * t519 * t2147 + 0.3e1 / 0.16e2 * t534 * t2151 - 0.3e1 / 0.32e2 * t519 * t2155 + 0.3e1 / 0.32e2 * t519 * t2159 + t534 * t2162 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2166 + t534 * t2169 / 0.16e2 + t1678 * t684 / 0.8e1 - t1681 * t666 / 0.16e2 - t1655 * t666 / 0.32e2 - t519 * t2178 / 0.32e2 - t519 * t2182 / 0.16e2 - t1678 * t676 / 0.8e1 - t534 * t2188 / 0.8e1 + t1678 * t680 / 0.8e1 + t534 * t2194 / 0.8e1;
  t2198 = t2150 * t1361;
  t2203 = t683 * t1702;
  t2209 = t683 * t1650;
  t2212 = t670 * t75;
  t2213 = t2212 * t547;
  t2216 = t219 * t438;
  t2217 = t2216 * t445;
  t2228 = my_piecewise3(t72, -0.6e1 * t526, 0);
  t2230 = t157 * t2228 * t173;
  t2233 = -t534 * t2198 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2155 - t534 * t2203 / 0.8e1 - t2125 / 0.16e2 + t2129 / 0.16e2 + t2133 / 0.16e2 + t534 * t2209 / 0.16e2 + t534 * t2213 / 0.8e1 - t534 * t2217 / 0.16e2 - t2117 / 0.32e2 - t1313 * t221 / 0.16e2 - t409 * t672 / 0.8e1 - t2112 / 0.16e2 - t2121 / 0.16e2 - t156 * t2230 / 0.16e2 + t2083;
  t2235 = my_piecewise3(t51, 0, t2197 + t2233);
  tv3rho2tau5 = t3 * t2235 + 0.2e1 * t688;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2237 = t695 * t111;
  t2238 = t2237 * t290;
  t2239 = t484 * t2238;
  t2240 = t2239 / 0.16e2;
  t2241 = t690 * t263;
  t2242 = t1458 * t111;
  t2243 = t2241 * t2242;
  t2246 = t690 * t943;
  t2247 = t1516 * t111;
  t2248 = t2246 * t2247;
  t2251 = t695 * t263;
  t2252 = t2251 * t491;
  t2253 = t484 * t2252;
  t2254 = t2253 / 0.16e2;
  t2255 = t2241 * t2247;
  t2258 = t1525 * t111;
  t2259 = t2246 * t2258;
  t2262 = t690 * t43;
  t2263 = t1463 * t111;
  t2264 = t2262 * t2263;
  t2267 = t489 * t1509;
  t2270 = t1470 * t111;
  t2271 = t2241 * t2270;
  t2274 = t695 * t43;
  t2275 = t2274 * t497;
  t2276 = t484 * t2275;
  t2277 = t2276 / 0.16e2;
  t2278 = t471 * t695;
  t2279 = t470 * t2278;
  t2280 = t469 * t2279;
  t2281 = t2280 / 0.32e2;
  t2283 = t690 * t111 * t1031;
  t2286 = t495 * t1509;
  t2289 = -t699 - t2240 - 0.3e1 / 0.32e2 * t469 * t2243 + 0.3e1 / 0.32e2 * t469 * t2248 + t2254 + t484 * t2255 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2259 - t484 * t2264 / 0.8e1 - t469 * t2267 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2271 + t2277 - t2281 - t484 * t2283 / 0.16e2 - t484 * t2286 / 0.8e1;
  t2290 = t2262 * t2270;
  t2293 = t490 * t478;
  t2294 = t489 * t2293;
  t2299 = t496 * t478;
  t2300 = t495 * t2299;
  t2308 = t255 * t704 / 0.32e2;
  t2310 = t255 * t707 / 0.32e2;
  t2312 = t255 * t692 / 0.64e2;
  t2313 = t255 * t697;
  t2314 = t2313 / 0.32e2;
  t2316 = t255 * t701 / 0.32e2;
  t2320 = t1000 * t690 * t269;
  t2323 = t246 * t697;
  t2324 = t2323 / 0.16e2;
  t2327 = 0.3e1 / 0.16e2 * t484 * t2290 + t484 * t2294 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t2243 + t484 * t2300 / 0.8e1 + t246 * t704 / 0.16e2 + t246 * t707 / 0.16e2 + t2308 + t2310 - t2312 - t2314 - t2316 - t246 * t692 / 0.32e2 - t99 * t2320 / 0.32e2 - t2324 - t246 * t701 / 0.16e2;
  t2329 = my_piecewise3(t2, 0, t2289 + t2327);
  tv3rhosigma20 = t3 * t2329 + t711;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2334 = t370 * t714 / 0.64e2;
  t2336 = t367 * t719 / 0.16e2;
  t2337 = t370 * t719;
  t2338 = t2337 / 0.32e2;
  t2342 = t370 * t723 / 0.32e2;
  t2346 = t370 * t726 / 0.32e2;
  t2350 = t370 * t729 / 0.32e2;
  t2352 = my_piecewise3(t51, 0, -t367 * t714 / 0.32e2 - t2334 - t2336 - t2338 - t367 * t723 / 0.16e2 - t2342 + t367 * t726 / 0.16e2 + t2346 + t367 * t729 / 0.16e2 + t2350);
  tv3rhosigma25 = t3 * t2352 + t733;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2357 = t345 * t697 / 0.16e2;
  t2365 = my_piecewise3(t2, 0, -t345 * t692 / 0.32e2 - t2312 - t2357 - t2314 - t345 * t701 / 0.16e2 - t2316 + t345 * t704 / 0.16e2 + t2308 + t345 * t707 / 0.16e2 + t2310);
  tv3rhosigma26 = t3 * t2365 + t711;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2367 = t717 * t418;
  t2368 = t2367 * t541;
  t2369 = t534 * t2368;
  t2370 = t2369 / 0.16e2;
  t2371 = t712 * t418;
  t2372 = t1629 * t168;
  t2373 = t2371 * t2372;
  t2376 = t712 * t1370;
  t2377 = t1639 * t168;
  t2378 = t2376 * t2377;
  t2381 = t1623 * t168;
  t2382 = t2371 * t2381;
  t2385 = t546 * t528;
  t2386 = t545 * t2385;
  t2389 = t712 * t75;
  t2390 = t1701 * t168;
  t2391 = t2389 * t2390;
  t2394 = t539 * t1662;
  t2397 = t1706 * t168;
  t2398 = t2371 * t2397;
  t2401 = t717 * t75;
  t2402 = t2401 * t547;
  t2403 = t534 * t2402;
  t2404 = t2403 / 0.16e2;
  t2405 = t521 * t717;
  t2406 = t520 * t2405;
  t2407 = t519 * t2406;
  t2408 = t2407 / 0.32e2;
  t2409 = t545 * t1662;
  t2412 = t2389 * t2397;
  t2415 = t540 * t528;
  t2416 = t539 * t2415;
  t2419 = -t721 + t2370 + t534 * t2373 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2378 - 0.3e1 / 0.16e2 * t534 * t2382 + t534 * t2386 / 0.8e1 - t534 * t2391 / 0.8e1 - t519 * t2394 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2398 + t2404 - t2408 - t534 * t2409 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2412 + t534 * t2416 / 0.8e1;
  t2420 = t717 * t168;
  t2421 = t2420 * t445;
  t2422 = t534 * t2421;
  t2423 = t2422 / 0.16e2;
  t2425 = t712 * t168 * t1361;
  t2430 = t2376 * t2372;
  t2436 = t1329 * t712 * t424;
  t2439 = t409 * t719;
  t2440 = t2439 / 0.16e2;
  t2447 = -t2423 - t534 * t2425 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2382 + 0.3e1 / 0.32e2 * t519 * t2430 - t409 * t714 / 0.32e2 - t156 * t2436 / 0.32e2 - t2440 - t409 * t723 / 0.16e2 + t409 * t726 / 0.16e2 + t2346 + t2350 + t409 * t729 / 0.16e2 - t2334 - t2338 - t2342;
  t2449 = my_piecewise3(t51, 0, t2419 + t2447);
  tv3rhosigma211 = t3 * t2449 + t733;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2451 = t737 * t111;
  t2452 = t2451 * t1031;
  t2455 = t572 * t295;
  t2456 = t938 * t183;
  t2457 = t2456 * t111;
  t2458 = t2455 * t2457;
  t2461 = t576 * t113;
  t2462 = t2461 * t2457;
  t2465 = t489 * t265;
  t2466 = t938 * t199;
  t2467 = t2466 * t111;
  t2468 = t2465 * t2467;
  t2471 = t737 * t43;
  t2472 = t2471 * t2270;
  t2475 = t1735 * t945;
  t2476 = t2475 * t2457;
  t2481 = t1524 * t935;
  t2482 = t2481 * t2467;
  t2485 = t737 * t263;
  t2486 = t2485 * t2247;
  t2490 = t1419 * t738 / 0.32e2;
  t2493 = t1754 * t745;
  t2500 = t1447 * t558;
  t2503 = -t484 * t2452 / 0.16e2 - 0.3e1 / 0.16e2 * t484 * t2458 - t484 * t2462 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2468 + 0.3e1 / 0.16e2 * t484 * t2472 - 0.3e1 / 0.16e2 * t484 * t2476 - 0.3e1 / 0.32e2 * t469 * t2458 + 0.3e1 / 0.32e2 * t469 * t2482 + t484 * t2486 / 0.4e1 - t699 - t2490 + t1415 * t746 / 0.16e2 + t484 * t2493 / 0.16e2 - t1493 * t734 / 0.32e2 - t1503 * t734 / 0.32e2 - t469 * t2500 / 0.32e2;
  t2504 = t489 * t1750;
  t2508 = t1419 * t742 / 0.32e2;
  t2510 = t1419 * t746 / 0.32e2;
  t2512 = t1499 * t734 / 0.64e2;
  t2513 = t576 * t2299;
  t2518 = t563 * t183;
  t2519 = t2518 * t290;
  t2522 = t199 * t478;
  t2523 = t2522 * t290;
  t2528 = t1771 * t741;
  t2531 = t572 * t2293;
  t2534 = -t469 * t2504 / 0.32e2 + t2508 + t2510 - t2512 + t484 * t2513 / 0.16e2 - t1415 * t738 / 0.16e2 - t484 * t2519 / 0.16e2 - t484 * t2523 / 0.16e2 + t1415 * t742 / 0.16e2 + t484 * t2528 / 0.16e2 + t484 * t2531 / 0.16e2 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t2536 = my_piecewise3(t2, 0, t2503 + t2534);
  tv3rhosigmalapl0 = t3 * t2536 + t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2541 = t1578 * t751 / 0.64e2;
  t2545 = t1589 * t755 / 0.32e2;
  t2549 = t1589 * t759 / 0.32e2;
  t2553 = t1589 * t763 / 0.32e2;
  t2555 = my_piecewise3(t51, 0, -t1574 * t751 / 0.32e2 - t2541 - t2336 - t2338 - t1585 * t755 / 0.16e2 - t2545 + t1585 * t759 / 0.16e2 + t2549 + t1585 * t763 / 0.16e2 + t2553);
  tv3rhosigmalapl5 = t3 * t2555 + t767;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2566 = my_piecewise3(t2, 0, -t1548 * t734 / 0.32e2 - t2512 - t2357 - t2314 - t1553 * t738 / 0.16e2 - t2490 + t1553 * t742 / 0.16e2 + t2508 + t1553 * t746 / 0.16e2 + t2510);
  tv3rhosigmalapl6 = t3 * t2566 + t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2568 = t539 * t450;
  t2569 = t1360 * t207;
  t2570 = t2569 * t168;
  t2571 = t2568 * t2570;
  t2574 = t1638 * t1372;
  t2575 = t2574 * t2570;
  t2578 = t754 * t418;
  t2579 = t2578 * t2372;
  t2582 = t1964 * t1384;
  t2583 = t1360 * t191;
  t2584 = t2583 * t168;
  t2585 = t2582 * t2584;
  t2588 = t754 * t168;
  t2589 = t2588 * t1361;
  t2594 = t615 * t170;
  t2595 = t2594 * t2584;
  t2598 = t539 * t420;
  t2599 = t2598 * t2570;
  t2602 = t754 * t75;
  t2603 = t2602 * t2397;
  t2610 = t1937 * t762;
  t2613 = t615 * t2385;
  t2616 = t1692 * t597;
  t2619 = t539 * t1933;
  t2622 = -0.3e1 / 0.32e2 * t519 * t2571 + 0.3e1 / 0.32e2 * t519 * t2575 + t534 * t2579 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2585 - t534 * t2589 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2571 - t534 * t2595 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2599 + 0.3e1 / 0.16e2 * t534 * t2603 - t721 - t1681 * t751 / 0.32e2 - t1655 * t751 / 0.32e2 + t534 * t2610 / 0.16e2 + t534 * t2613 / 0.16e2 - t519 * t2616 / 0.32e2 - t519 * t2619 / 0.32e2;
  t2625 = t602 * t191;
  t2626 = t2625 * t445;
  t2629 = t207 * t528;
  t2630 = t2629 * t445;
  t2635 = t1907 * t758;
  t2638 = t611 * t2415;
  t2643 = -t1678 * t755 / 0.16e2 - t534 * t2626 / 0.16e2 - t534 * t2630 / 0.16e2 + t1678 * t759 / 0.16e2 + t534 * t2635 / 0.16e2 + t534 * t2638 / 0.16e2 + t1678 * t763 / 0.16e2 - t2541 - t2545 + t2549 + t2553 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t2645 = my_piecewise3(t51, 0, t2622 + t2643);
  tv3rhosigmalapl11 = t3 * t2645 + t767;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2647 = t771 * t111;
  t2648 = t2647 * t1031;
  t2651 = t771 * t43;
  t2652 = t2651 * t2270;
  t2655 = t640 * t295;
  t2656 = t2655 * t2457;
  t2659 = t644 * t113;
  t2660 = t2659 * t2457;
  t2663 = t938 * t213;
  t2664 = t2663 * t111;
  t2665 = t2465 * t2664;
  t2668 = t2005 * t945;
  t2669 = t2668 * t2457;
  t2674 = t2481 * t2664;
  t2677 = t771 * t263;
  t2678 = t2677 * t2247;
  t2681 = t640 * t2293;
  t2686 = t2013 * t745;
  t2689 = t644 * t2299;
  t2696 = -t484 * t2648 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t2652 - 0.3e1 / 0.16e2 * t484 * t2656 - t484 * t2660 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2665 - 0.3e1 / 0.16e2 * t484 * t2669 - 0.3e1 / 0.32e2 * t469 * t2656 + 0.3e1 / 0.32e2 * t469 * t2674 + t484 * t2678 / 0.4e1 - t699 + t484 * t2681 / 0.16e2 + t1415 * t778 / 0.16e2 + t484 * t2686 / 0.16e2 + t484 * t2689 / 0.16e2 - t1493 * t768 / 0.32e2 - t1503 * t768 / 0.32e2;
  t2697 = t1447 * t626;
  t2700 = t489 * t2009;
  t2704 = t1419 * t772 / 0.32e2;
  t2706 = t1419 * t775 / 0.32e2;
  t2708 = t1419 * t778 / 0.32e2;
  t2710 = t1499 * t768 / 0.64e2;
  t2713 = t631 * t183;
  t2714 = t2713 * t290;
  t2717 = t213 * t478;
  t2718 = t2717 * t290;
  t2723 = t2050 * t741;
  t2726 = -t469 * t2697 / 0.32e2 - t469 * t2700 / 0.32e2 - t2704 + t2706 + t2708 - t2710 - t1415 * t772 / 0.16e2 - t484 * t2714 / 0.16e2 - t484 * t2718 / 0.16e2 + t1415 * t775 / 0.16e2 + t484 * t2723 / 0.16e2 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t2728 = my_piecewise3(t2, 0, t2696 + t2726);
  tv3rhosigmatau0 = t3 * t2728 + t782;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2733 = t1578 * t783 / 0.64e2;
  t2737 = t1589 * t787 / 0.32e2;
  t2741 = t1589 * t790 / 0.32e2;
  t2745 = t1589 * t793 / 0.32e2;
  t2747 = my_piecewise3(t51, 0, -t1574 * t783 / 0.32e2 - t2733 - t2336 - t2338 - t1585 * t787 / 0.16e2 - t2737 + t1585 * t790 / 0.16e2 + t2741 + t1585 * t793 / 0.16e2 + t2745);
  tv3rhosigmatau5 = t3 * t2747 + t797;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2758 = my_piecewise3(t2, 0, -t1548 * t768 / 0.32e2 - t2710 - t2357 - t2314 - t1553 * t772 / 0.16e2 - t2704 + t1553 * t775 / 0.16e2 + t2706 + t1553 * t778 / 0.16e2 + t2708);
  tv3rhosigmatau6 = t3 * t2758 + t782;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2760 = t1360 * t219;
  t2761 = t2760 * t168;
  t2762 = t2598 * t2761;
  t2765 = t786 * t75;
  t2766 = t2765 * t2397;
  t2769 = t2568 * t2761;
  t2772 = t2574 * t2761;
  t2775 = t786 * t418;
  t2776 = t2775 * t2372;
  t2779 = t2165 * t1384;
  t2780 = t2779 * t2584;
  t2783 = t786 * t168;
  t2784 = t2783 * t1361;
  t2789 = t683 * t170;
  t2790 = t2789 * t2584;
  t2793 = t219 * t528;
  t2794 = t2793 * t445;
  t2799 = t2193 * t758;
  t2802 = t679 * t2415;
  t2807 = t2212 * t762;
  t2810 = 0.3e1 / 0.32e2 * t519 * t2762 + 0.3e1 / 0.16e2 * t534 * t2766 - 0.3e1 / 0.32e2 * t519 * t2769 + 0.3e1 / 0.32e2 * t519 * t2772 + t534 * t2776 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2780 - t534 * t2784 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2769 - t534 * t2790 / 0.8e1 - t721 - t534 * t2794 / 0.16e2 + t1678 * t790 / 0.16e2 + t534 * t2799 / 0.16e2 + t534 * t2802 / 0.16e2 + t1678 * t793 / 0.16e2 + t534 * t2807 / 0.16e2;
  t2811 = t683 * t2385;
  t2818 = t1692 * t665;
  t2821 = t539 * t2181;
  t2826 = t670 * t191;
  t2827 = t2826 * t445;
  t2830 = t534 * t2811 / 0.16e2 - t1681 * t783 / 0.32e2 - t1655 * t783 / 0.32e2 - t519 * t2818 / 0.32e2 - t519 * t2821 / 0.32e2 - t2737 + t2741 + t2745 - t1678 * t787 / 0.16e2 - t534 * t2827 / 0.16e2 - t2733 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t2832 = my_piecewise3(t51, 0, t2810 + t2830);
  tv3rhosigmatau11 = t3 * t2832 + t797;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2834 = t576 * t1750;
  t2837 = t798 * t43;
  t2838 = t2837 * t2270;
  t2841 = t798 * t111;
  t2842 = t2841 * t1031;
  t2845 = t798 * t263;
  t2846 = t2845 * t2242;
  t2849 = t798 * t943;
  t2850 = t2849 * t2247;
  t2853 = t2845 * t2247;
  t2856 = t2849 * t2258;
  t2859 = t490 * t563;
  t2860 = t572 * t2859;
  t2865 = t496 * t563;
  t2866 = t576 * t2865;
  t2869 = t2837 * t2263;
  t2872 = t572 * t1750;
  t2875 = t2845 * t2270;
  t2878 = -t699 - t484 * t2834 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2838 - t484 * t2842 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t2846 + 0.3e1 / 0.32e2 * t469 * t2850 + t484 * t2853 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2856 + t484 * t2860 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t2846 + t484 * t2866 / 0.8e1 - t484 * t2869 / 0.8e1 - t469 * t2872 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2875;
  t2880 = t255 * t810 / 0.32e2;
  t2882 = t255 * t800 / 0.64e2;
  t2884 = t255 * t804 / 0.32e2;
  t2888 = t1000 * t798 * t269;
  t2898 = t255 * t807 / 0.32e2;
  t2899 = -t2240 + t2254 + t2277 - t2281 + t2880 - t2882 - t2884 - t246 * t800 / 0.32e2 - t99 * t2888 / 0.32e2 - t246 * t804 / 0.16e2 + t246 * t807 / 0.16e2 + t246 * t810 / 0.16e2 + t2898 - t2314 - t2324;
  t2901 = my_piecewise3(t2, 0, t2878 + t2899);
  tv3rholapl20 = t3 * t2901 + t814;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2906 = t370 * t817 / 0.64e2;
  t2910 = t370 * t821 / 0.32e2;
  t2914 = t370 * t824 / 0.32e2;
  t2918 = t370 * t827 / 0.32e2;
  t2920 = my_piecewise3(t51, 0, -t367 * t817 / 0.32e2 - t2906 - t2336 - t2338 - t367 * t821 / 0.16e2 - t2910 + t367 * t824 / 0.16e2 + t2914 + t367 * t827 / 0.16e2 + t2918);
  tv3rholapl22 = t3 * t2920 + t831;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2931 = my_piecewise3(t2, 0, -t345 * t800 / 0.32e2 - t2882 - t2357 - t2314 - t345 * t804 / 0.16e2 - t2884 + t345 * t807 / 0.16e2 + t2898 + t345 * t810 / 0.16e2 + t2880);
  tv3rholapl23 = t3 * t2931 + t814;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2933 = t815 * t168;
  t2934 = t2933 * t1361;
  t2937 = t815 * t418;
  t2938 = t2937 * t2381;
  t2941 = t815 * t1370;
  t2942 = t2941 * t2372;
  t2945 = t2937 * t2372;
  t2948 = t2941 * t2377;
  t2951 = t615 * t1933;
  t2954 = t815 * t75;
  t2955 = t2954 * t2397;
  t2958 = t540 * t602;
  t2959 = t611 * t2958;
  t2964 = t546 * t602;
  t2965 = t615 * t2964;
  t2968 = t2954 * t2390;
  t2971 = t611 * t1933;
  t2974 = t2937 * t2397;
  t2977 = -t721 - t534 * t2934 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2938 + 0.3e1 / 0.32e2 * t519 * t2942 + t534 * t2945 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2948 - t534 * t2951 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2955 + t534 * t2959 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t2938 + t534 * t2965 / 0.8e1 - t534 * t2968 / 0.8e1 - t519 * t2971 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2974;
  t2979 = t1329 * t815 * t424;
  t2990 = t2370 + t2404 - t2408 - t2423 - t156 * t2979 / 0.32e2 - t409 * t821 / 0.16e2 + t409 * t824 / 0.16e2 + t409 * t827 / 0.16e2 - t409 * t817 / 0.32e2 - t2906 - t2910 + t2914 + t2918 - t2440 - t2338;
  t2992 = my_piecewise3(t51, 0, t2977 + t2990);
  tv3rholapl25 = t3 * t2992 + t831;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  t2994 = t1735 * t935;
  t2995 = t2994 * t2664;
  t2998 = t835 * t263;
  t2999 = t2998 * t2247;
  t3002 = t2668 * t2467;
  t3006 = t835 * t111 * t1031;
  t3009 = t2455 * t2664;
  t3012 = t835 * t43;
  t3013 = t3012 * t2270;
  t3018 = t2659 * t2467;
  t3021 = t572 * t265;
  t3022 = t3021 * t2664;
  t3025 = t640 * t2859;
  t3030 = t2013 * t843;
  t3033 = t644 * t2865;
  t3040 = 0.3e1 / 0.32e2 * t469 * t2995 + t484 * t2999 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3002 - t484 * t3006 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3009 + 0.3e1 / 0.16e2 * t484 * t3013 - 0.3e1 / 0.16e2 * t484 * t3009 - t484 * t3018 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3022 - t699 + t484 * t3025 / 0.16e2 + t1415 * t844 / 0.16e2 + t484 * t3030 / 0.16e2 + t484 * t3033 / 0.16e2 - t1493 * t832 / 0.32e2 - t1503 * t832 / 0.32e2;
  t3041 = t1771 * t626;
  t3044 = t572 * t2009;
  t3050 = t1419 * t836 / 0.32e2;
  t3052 = t1419 * t840 / 0.32e2;
  t3054 = t1419 * t844 / 0.32e2;
  t3056 = t1499 * t832 / 0.64e2;
  t3057 = t631 * t199;
  t3058 = t3057 * t290;
  t3061 = t213 * t563;
  t3062 = t3061 * t290;
  t3067 = t2050 * t839;
  t3070 = -t469 * t3041 / 0.32e2 - t469 * t3044 / 0.32e2 - t1415 * t836 / 0.16e2 - t3050 + t3052 + t3054 - t3056 - t484 * t3058 / 0.16e2 - t484 * t3062 / 0.16e2 + t1415 * t840 / 0.16e2 + t484 * t3067 / 0.16e2 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t3072 = my_piecewise3(t2, 0, t3040 + t3070);
  tv3rholapltau0 = t3 * t3072 + t848;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  t3077 = t1578 * t849 / 0.64e2;
  t3081 = t1589 * t853 / 0.32e2;
  t3085 = t1589 * t857 / 0.32e2;
  t3089 = t1589 * t861 / 0.32e2;
  t3091 = my_piecewise3(t51, 0, -t1574 * t849 / 0.32e2 - t3077 - t2336 - t2338 - t1585 * t853 / 0.16e2 - t3081 + t1585 * t857 / 0.16e2 + t3085 + t1585 * t861 / 0.16e2 + t3089);
  tv3rholapltau3 = t3 * t3091 + t865;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  t3102 = my_piecewise3(t2, 0, -t1548 * t832 / 0.32e2 - t3056 - t2357 - t2314 - t1553 * t836 / 0.16e2 - t3050 + t1553 * t840 / 0.16e2 + t3052 + t1553 * t844 / 0.16e2 + t3054);
  tv3rholapltau4 = t3 * t3102 + t848;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  t3105 = t852 * t168 * t1361;
  t3108 = t611 * t450;
  t3109 = t3108 * t2761;
  t3112 = t1964 * t1372;
  t3113 = t3112 * t2761;
  t3116 = t852 * t418;
  t3117 = t3116 * t2372;
  t3120 = t2779 * t2570;
  t3123 = t852 * t75;
  t3124 = t3123 * t2397;
  t3129 = t2789 * t2570;
  t3132 = t611 * t420;
  t3133 = t3132 * t2761;
  t3136 = t670 * t207;
  t3137 = t3136 * t445;
  t3140 = t219 * t602;
  t3141 = t3140 * t445;
  t3146 = t2193 * t856;
  t3149 = t679 * t2958;
  t3154 = -t534 * t3105 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3109 + 0.3e1 / 0.32e2 * t519 * t3113 + t534 * t3117 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3120 + 0.3e1 / 0.16e2 * t534 * t3124 - 0.3e1 / 0.16e2 * t534 * t3109 - t534 * t3129 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3133 - t721 - t534 * t3137 / 0.16e2 - t534 * t3141 / 0.16e2 + t1678 * t857 / 0.16e2 + t534 * t3146 / 0.16e2 + t534 * t3149 / 0.16e2 + t1678 * t861 / 0.16e2;
  t3155 = t2212 * t860;
  t3158 = t683 * t2964;
  t3165 = t1907 * t665;
  t3168 = t611 * t2181;
  t3173 = t534 * t3155 / 0.16e2 + t534 * t3158 / 0.16e2 - t1681 * t849 / 0.32e2 - t1655 * t849 / 0.32e2 - t519 * t3165 / 0.32e2 - t519 * t3168 / 0.32e2 - t1678 * t853 / 0.16e2 - t3081 + t3085 + t3089 - t3077 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t3175 = my_piecewise3(t51, 0, t3154 + t3173);
  tv3rholapltau7 = t3 * t3175 + t865;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3177 = t866 * t111;
  t3178 = t3177 * t1031;
  t3181 = t866 * t263;
  t3182 = t3181 * t2242;
  t3185 = t866 * t943;
  t3186 = t3185 * t2247;
  t3189 = t3181 * t2247;
  t3192 = t3185 * t2258;
  t3196 = t644 * t496 * t631;
  t3199 = t866 * t43;
  t3200 = t3199 * t2263;
  t3203 = t640 * t2009;
  t3206 = t3181 * t2270;
  t3209 = t644 * t2009;
  t3212 = t3199 * t2270;
  t3216 = t640 * t490 * t631;
  t3221 = -t699 - t484 * t3178 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3182 + 0.3e1 / 0.32e2 * t469 * t3186 + t484 * t3189 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3192 + t484 * t3196 / 0.8e1 - t484 * t3200 / 0.8e1 - t469 * t3203 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3206 - t484 * t3209 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3212 + t484 * t3216 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t3182;
  t3223 = t255 * t878 / 0.32e2;
  t3225 = t255 * t872 / 0.32e2;
  t3227 = t255 * t875 / 0.32e2;
  t3229 = t255 * t868 / 0.64e2;
  t3235 = t1000 * t866 * t269;
  t3242 = -t2240 + t2254 + t2277 - t2281 + t3223 - t3225 + t3227 - t3229 + t246 * t878 / 0.16e2 - t246 * t868 / 0.32e2 - t99 * t3235 / 0.32e2 - t246 * t872 / 0.16e2 + t246 * t875 / 0.16e2 - t2314 - t2324;
  t3244 = my_piecewise3(t2, 0, t3221 + t3242);
  tv3rhotau20 = t3 * t3244 + t882;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3249 = t370 * t885 / 0.64e2;
  t3253 = t370 * t889 / 0.32e2;
  t3257 = t370 * t892 / 0.32e2;
  t3261 = t370 * t895 / 0.32e2;
  t3263 = my_piecewise3(t51, 0, -t367 * t885 / 0.32e2 - t3249 - t2336 - t2338 - t367 * t889 / 0.16e2 - t3253 + t367 * t892 / 0.16e2 + t3257 + t367 * t895 / 0.16e2 + t3261);
  tv3rhotau22 = t3 * t3263 + t899;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3274 = my_piecewise3(t2, 0, -t345 * t868 / 0.32e2 - t3229 - t2357 - t2314 - t345 * t872 / 0.16e2 - t3225 + t345 * t875 / 0.16e2 + t3227 + t345 * t878 / 0.16e2 + t3223);
  tv3rhotau23 = t3 * t3274 + t882;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3276 = t883 * t1370;
  t3277 = t3276 * t2377;
  t3281 = t679 * t540 * t670;
  t3284 = t883 * t418;
  t3285 = t3284 * t2381;
  t3289 = t683 * t546 * t670;
  t3292 = t883 * t75;
  t3293 = t3292 * t2390;
  t3296 = t679 * t2181;
  t3299 = t3284 * t2397;
  t3302 = t883 * t168;
  t3303 = t3302 * t1361;
  t3308 = t3276 * t2372;
  t3311 = t3284 * t2372;
  t3314 = t683 * t2181;
  t3317 = t3292 * t2397;
  t3320 = -t721 - 0.3e1 / 0.16e2 * t534 * t3277 + t534 * t3281 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t3285 + t534 * t3289 / 0.8e1 - t534 * t3293 / 0.8e1 - t519 * t3296 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t3299 - t534 * t3303 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3285 + 0.3e1 / 0.32e2 * t519 * t3308 + t534 * t3311 / 0.4e1 - t534 * t3314 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t3317;
  t3324 = t1329 * t883 * t424;
  t3333 = t2370 + t2404 - t2408 - t2423 + t3257 + t3261 - t409 * t885 / 0.32e2 - t156 * t3324 / 0.32e2 - t409 * t889 / 0.16e2 + t409 * t892 / 0.16e2 + t409 * t895 / 0.16e2 - t3249 - t3253 - t2440 - t2338;
  t3335 = my_piecewise3(t51, 0, t3320 + t3333);
  tv3rhotau25 = t3 * t3335 + t899;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3337 = t690 * t183;
  t3338 = t100 * t3337;
  t3339 = t3338 * t956;
  t3342 = t3338 * t960;
  t3345 = t489 * t2278;
  t3346 = t469 * t3345;
  t3347 = 0.3e1 / 0.32e2 * t3346;
  t3348 = t260 * t3337;
  t3349 = t3348 * t964;
  t3352 = t2274 * t745;
  t3353 = t484 * t3352;
  t3354 = 0.3e1 / 0.16e2 * t3353;
  t3355 = t3338 * t968;
  t3358 = t993 * t183;
  t3360 = t996 * t183;
  t3363 = t3358 * t116 / 0.2e1 - t3360 * t116 / 0.2e1 + t185 / 0.2e1;
  t3365 = t3363 * t690 * t269;
  t3368 = t695 * t183;
  t3369 = t3368 * t290;
  t3370 = t484 * t3369;
  t3371 = 0.3e1 / 0.16e2 * t3370;
  t3372 = t3338 * t1031;
  t3375 = t3348 * t956;
  t3378 = t3348 * t1036;
  t3381 = t2251 * t741;
  t3382 = t484 * t3381;
  t3383 = 0.3e1 / 0.16e2 * t3382;
  t3384 = t3338 * t939;
  t3387 = t3338 * t947;
  t3390 = -0.3e1 / 0.16e2 * t99 * t3339 - t99 * t3342 / 0.8e1 - t3347 + 0.3e1 / 0.32e2 * t99 * t3349 + t3354 + 0.3e1 / 0.16e2 * t99 * t3355 - t99 * t3365 / 0.32e2 - t3371 - t99 * t3372 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3375 + 0.3e1 / 0.32e2 * t99 * t3378 + t3383 + t99 * t3384 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3387 - t699;
  t3391 = my_piecewise3(t2, 0, t3390);
  tv3sigma30 = t3 * t3391;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3392 = t712 * t191;
  t3393 = t157 * t3392;
  t3394 = t3393 * t1366;
  t3397 = t3393 * t1399;
  t3400 = t539 * t2405;
  t3401 = t519 * t3400;
  t3402 = 0.3e1 / 0.32e2 * t3401;
  t3403 = t415 * t3392;
  t3404 = t3403 * t1405;
  t3407 = t2401 * t762;
  t3408 = t534 * t3407;
  t3409 = 0.3e1 / 0.16e2 * t3408;
  t3410 = t3393 * t1392;
  t3413 = t1322 * t191;
  t3415 = t1325 * t191;
  t3418 = t3413 * t173 / 0.2e1 - t3415 * t173 / 0.2e1 + t193 / 0.2e1;
  t3420 = t3418 * t712 * t424;
  t3423 = t717 * t191;
  t3424 = t3423 * t445;
  t3425 = t534 * t3424;
  t3426 = 0.3e1 / 0.16e2 * t3425;
  t3427 = t3393 * t1361;
  t3430 = t3403 * t1366;
  t3433 = t3403 * t1374;
  t3436 = t2367 * t758;
  t3437 = t534 * t3436;
  t3438 = 0.3e1 / 0.16e2 * t3437;
  t3439 = t3393 * t1379;
  t3442 = t3393 * t1386;
  t3445 = -0.3e1 / 0.16e2 * t156 * t3394 - t156 * t3397 / 0.8e1 - t3402 + 0.3e1 / 0.32e2 * t156 * t3404 + t3409 + 0.3e1 / 0.16e2 * t156 * t3410 - t156 * t3420 / 0.32e2 - t3426 - t156 * t3427 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3430 + 0.3e1 / 0.32e2 * t156 * t3433 + t3438 + t156 * t3439 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3442 - t721;
  t3446 = my_piecewise3(t51, 0, t3445);
  tv3sigma39 = t3 * t3446;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3447 = t496 * t695;
  t3448 = t576 * t3447;
  t3449 = t484 * t3448;
  t3450 = t3449 / 0.16e2;
  t3451 = t2251 * t558;
  t3452 = t469 * t3451;
  t3453 = t3452 / 0.32e2;
  t3454 = t199 * t695;
  t3455 = t3454 * t290;
  t3456 = t484 * t3455;
  t3457 = t3456 / 0.16e2;
  t3458 = t490 * t695;
  t3459 = t572 * t3458;
  t3460 = t484 * t3459;
  t3461 = t3460 / 0.16e2;
  t3462 = t26 * t3363;
  t3463 = t23 * t3462;
  t3466 = t3346 / 0.16e2;
  t3467 = t3353 / 0.8e1;
  t3468 = t199 * t690;
  t3469 = t3468 * t968;
  t3472 = t1458 * t690;
  t3473 = t572 * t3472;
  t3476 = t1463 * t690;
  t3477 = t576 * t3476;
  t3480 = t2241 * t1787;
  t3483 = t3370 / 0.8e1;
  t3484 = t3468 * t1031;
  t3487 = t3382 / 0.8e1;
  t3490 = t2246 * t1743;
  t3493 = t3468 * t939;
  t3496 = t1525 * t690;
  t3497 = t1735 * t3496;
  t3500 = t3450 - t3453 - t3457 + t3461 - t3463 * t734 / 0.32e2 - t3466 + t3467 + 0.3e1 / 0.16e2 * t484 * t3469 - 0.3e1 / 0.16e2 * t484 * t3473 - t484 * t3477 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3480 - t3483 - t484 * t3484 / 0.16e2 + t3487 - 0.3e1 / 0.32e2 * t469 * t3473 + 0.3e1 / 0.32e2 * t469 * t3490 + t484 * t3493 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3497 - t699;
  t3501 = my_piecewise3(t2, 0, t3500);
  tv3sigma2lapl0 = t3 * t3501;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3502 = t207 * t717;
  t3503 = t3502 * t445;
  t3504 = t534 * t3503;
  t3505 = t3504 / 0.16e2;
  t3506 = t540 * t717;
  t3507 = t611 * t3506;
  t3508 = t534 * t3507;
  t3509 = t3508 / 0.16e2;
  t3510 = t546 * t717;
  t3511 = t615 * t3510;
  t3512 = t534 * t3511;
  t3513 = t3512 / 0.16e2;
  t3514 = t26 * t3418;
  t3515 = t60 * t3514;
  t3518 = t2367 * t597;
  t3519 = t519 * t3518;
  t3520 = t3519 / 0.32e2;
  t3521 = t3401 / 0.16e2;
  t3522 = t3408 / 0.8e1;
  t3523 = t2371 * t1954;
  t3526 = t207 * t712;
  t3527 = t3526 * t1392;
  t3530 = t1623 * t712;
  t3531 = t611 * t3530;
  t3534 = t1701 * t712;
  t3535 = t615 * t3534;
  t3538 = t3425 / 0.8e1;
  t3539 = t3526 * t1361;
  t3542 = t3437 / 0.8e1;
  t3545 = t2376 * t1970;
  t3548 = t3526 * t1379;
  t3551 = t1639 * t712;
  t3552 = t1964 * t3551;
  t3555 = -t3505 + t3509 + t3513 - t3515 * t751 / 0.32e2 - t3520 - t3521 + t3522 + 0.3e1 / 0.32e2 * t519 * t3523 + 0.3e1 / 0.16e2 * t534 * t3527 - 0.3e1 / 0.16e2 * t534 * t3531 - t534 * t3535 / 0.8e1 - t3538 - t534 * t3539 / 0.16e2 + t3542 - 0.3e1 / 0.32e2 * t519 * t3531 + 0.3e1 / 0.32e2 * t519 * t3545 + t534 * t3548 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3552 - t721;
  t3556 = my_piecewise3(t51, 0, t3555);
  tv3sigma2lapl11 = t3 * t3556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3557 = t640 * t3458;
  t3558 = t484 * t3557;
  t3559 = t3558 / 0.16e2;
  t3560 = t644 * t3447;
  t3561 = t484 * t3560;
  t3562 = t3561 / 0.16e2;
  t3565 = t2251 * t626;
  t3566 = t469 * t3565;
  t3567 = t3566 / 0.32e2;
  t3568 = t213 * t695;
  t3569 = t3568 * t290;
  t3570 = t484 * t3569;
  t3571 = t3570 / 0.16e2;
  t3572 = t2241 * t1992;
  t3575 = t213 * t690;
  t3576 = t3575 * t968;
  t3579 = t640 * t3472;
  t3582 = t644 * t3476;
  t3585 = t3575 * t1031;
  t3590 = t2246 * t1998;
  t3593 = t3575 * t939;
  t3596 = t2005 * t3496;
  t3599 = t3559 + t3562 - t3463 * t768 / 0.32e2 - t3567 - t3571 - t3466 + t3467 + 0.3e1 / 0.32e2 * t469 * t3572 + 0.3e1 / 0.16e2 * t484 * t3576 - 0.3e1 / 0.16e2 * t484 * t3579 - t484 * t3582 / 0.8e1 - t3483 - t484 * t3585 / 0.16e2 + t3487 - 0.3e1 / 0.32e2 * t469 * t3579 + 0.3e1 / 0.32e2 * t469 * t3590 + t484 * t3593 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3596 - t699;
  t3600 = my_piecewise3(t2, 0, t3599);
  tv3sigma2tau0 = t3 * t3600;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3601 = t683 * t3510;
  t3602 = t534 * t3601;
  t3603 = t3602 / 0.16e2;
  t3606 = t2367 * t665;
  t3607 = t519 * t3606;
  t3608 = t3607 / 0.32e2;
  t3609 = t219 * t717;
  t3610 = t3609 * t445;
  t3611 = t534 * t3610;
  t3612 = t3611 / 0.16e2;
  t3613 = t679 * t3506;
  t3614 = t534 * t3613;
  t3615 = t3614 / 0.16e2;
  t3616 = t2371 * t2146;
  t3619 = t219 * t712;
  t3620 = t3619 * t1392;
  t3623 = t679 * t3530;
  t3626 = t683 * t3534;
  t3629 = t3619 * t1361;
  t3634 = t2376 * t2158;
  t3637 = t3619 * t1379;
  t3640 = t2165 * t3551;
  t3643 = t3603 - t3515 * t783 / 0.32e2 - t3608 - t3612 + t3615 - t3521 + t3522 + 0.3e1 / 0.32e2 * t519 * t3616 + 0.3e1 / 0.16e2 * t534 * t3620 - 0.3e1 / 0.16e2 * t534 * t3623 - t534 * t3626 / 0.8e1 - t3538 - t534 * t3629 / 0.16e2 + t3542 - 0.3e1 / 0.32e2 * t519 * t3623 + 0.3e1 / 0.32e2 * t519 * t3634 + t534 * t3637 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3640 - t721;
  t3644 = my_piecewise3(t51, 0, t3643);
  tv3sigma2tau11 = t3 * t3644;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3645 = t2837 * t1471;
  t3648 = t1458 * t183;
  t3649 = t2845 * t3648;
  t3652 = t1463 * t183;
  t3653 = t2837 * t3652;
  t3656 = t2845 * t1471;
  t3659 = t3449 / 0.8e1;
  t3660 = t3452 / 0.16e2;
  t3661 = t3456 / 0.8e1;
  t3662 = t3460 / 0.8e1;
  t3663 = t3346 / 0.32e2;
  t3664 = t3353 / 0.16e2;
  t3666 = t3363 * t798 * t269;
  t3669 = t798 * t183;
  t3670 = t3669 * t1031;
  t3673 = t3370 / 0.16e2;
  t3676 = t2849 * t1517;
  t3679 = t2845 * t1517;
  t3682 = t1525 * t183;
  t3683 = t2849 * t3682;
  t3686 = t3382 / 0.16e2;
  t3687 = 0.3e1 / 0.16e2 * t484 * t3645 - 0.3e1 / 0.16e2 * t484 * t3649 - t484 * t3653 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3656 + t3659 - t3660 - t3661 + t3662 - t3663 + t3664 - t99 * t3666 / 0.32e2 - t484 * t3670 / 0.16e2 - t3673 - 0.3e1 / 0.32e2 * t469 * t3649 + 0.3e1 / 0.32e2 * t469 * t3676 + t484 * t3679 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3683 + t3686 - t699;
  t3688 = my_piecewise3(t2, 0, t3687);
  tv3sigmalapl20 = t3 * t3688;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3689 = t2954 * t1707;
  t3692 = t2937 * t1624;
  t3695 = t1701 * t191;
  t3696 = t2954 * t3695;
  t3699 = t2937 * t1707;
  t3702 = t3504 / 0.8e1;
  t3703 = t3508 / 0.8e1;
  t3704 = t3512 / 0.8e1;
  t3705 = t3519 / 0.16e2;
  t3706 = t3401 / 0.32e2;
  t3707 = t3408 / 0.16e2;
  t3709 = t3418 * t815 * t424;
  t3712 = t815 * t191;
  t3713 = t3712 * t1361;
  t3716 = t3425 / 0.16e2;
  t3717 = t2937 * t1630;
  t3720 = t1639 * t191;
  t3721 = t2941 * t3720;
  t3726 = t2941 * t1630;
  t3729 = t3437 / 0.16e2;
  t3730 = 0.3e1 / 0.16e2 * t534 * t3689 - 0.3e1 / 0.16e2 * t534 * t3692 - t534 * t3696 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3699 - t3702 + t3703 + t3704 - t3705 - t3706 + t3707 - t156 * t3709 / 0.32e2 - t534 * t3713 / 0.16e2 - t3716 + t534 * t3717 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3721 - 0.3e1 / 0.32e2 * t519 * t3692 + 0.3e1 / 0.32e2 * t519 * t3726 + t3729 - t721;
  t3731 = my_piecewise3(t51, 0, t3730);
  tv3sigmalapl28 = t3 * t3731;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  t3734 = -t3463 * t832 / 0.32e2 + t3559 + t3562 - t3567 - t3571 + t3450 - t3453 - t3457 + t3461 - t3663 + t3664;
  t3735 = t3012 * t1471;
  t3738 = t2466 * t183;
  t3739 = t2655 * t3738;
  t3742 = t2659 * t3738;
  t3745 = t2663 * t183;
  t3746 = t3021 * t3745;
  t3749 = t835 * t183;
  t3750 = t3749 * t1031;
  t3753 = t2994 * t3745;
  t3756 = t2998 * t1517;
  t3759 = t2668 * t3738;
  t3764 = 0.3e1 / 0.16e2 * t484 * t3735 - 0.3e1 / 0.16e2 * t484 * t3739 - t484 * t3742 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3746 - t3673 - t484 * t3750 / 0.16e2 + t3686 + 0.3e1 / 0.32e2 * t469 * t3753 + t484 * t3756 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3759 - 0.3e1 / 0.32e2 * t469 * t3739 - t699;
  t3766 = my_piecewise3(t2, 0, t3734 + t3764);
  tv3sigmalapltau0 = t3 * t3766;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  t3769 = -t3515 * t849 / 0.32e2 + t3603 - t3608 - t3612 + t3615 - t3505 + t3509 + t3513 - t3520 - t3706 + t3707;
  t3770 = t2569 * t191;
  t3771 = t2789 * t3770;
  t3774 = t2760 * t191;
  t3775 = t3132 * t3774;
  t3778 = t3123 * t1707;
  t3781 = t679 * t450;
  t3782 = t3781 * t3770;
  t3785 = t852 * t191;
  t3786 = t3785 * t1361;
  t3791 = t3112 * t3774;
  t3794 = t3116 * t1630;
  t3797 = t2779 * t3770;
  t3800 = -t534 * t3771 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3775 + 0.3e1 / 0.16e2 * t534 * t3778 - 0.3e1 / 0.16e2 * t534 * t3782 - t3716 - t534 * t3786 / 0.16e2 + t3729 - 0.3e1 / 0.32e2 * t519 * t3782 + 0.3e1 / 0.32e2 * t519 * t3791 + t534 * t3794 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3797 - t721;
  t3802 = my_piecewise3(t51, 0, t3769 + t3800);
  tv3sigmalapltau11 = t3 * t3802;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3803 = t3199 * t3652;
  t3806 = t3199 * t1471;
  t3809 = t3181 * t3648;
  t3812 = t3181 * t1471;
  t3815 = t3558 / 0.8e1;
  t3816 = t3561 / 0.8e1;
  t3817 = t3566 / 0.16e2;
  t3818 = t3570 / 0.8e1;
  t3820 = t3363 * t866 * t269;
  t3823 = t866 * t183;
  t3824 = t3823 * t1031;
  t3829 = t3185 * t1517;
  t3832 = t3181 * t1517;
  t3835 = t3185 * t3682;
  t3838 = -t484 * t3803 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3806 - 0.3e1 / 0.16e2 * t484 * t3809 + 0.3e1 / 0.32e2 * t469 * t3812 + t3815 + t3816 - t3817 - t3818 - t3663 + t3664 - t99 * t3820 / 0.32e2 - t484 * t3824 / 0.16e2 - t3673 - 0.3e1 / 0.32e2 * t469 * t3809 + 0.3e1 / 0.32e2 * t469 * t3829 + t484 * t3832 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3835 + t3686 - t699;
  t3839 = my_piecewise3(t2, 0, t3838);
  tv3sigmatau20 = t3 * t3839;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3840 = t3292 * t1707;
  t3843 = t3284 * t1624;
  t3846 = t3292 * t3695;
  t3849 = t3284 * t1707;
  t3852 = t3602 / 0.8e1;
  t3853 = t3607 / 0.16e2;
  t3854 = t3611 / 0.8e1;
  t3855 = t3614 / 0.8e1;
  t3857 = t3418 * t883 * t424;
  t3860 = t883 * t191;
  t3861 = t3860 * t1361;
  t3866 = t3276 * t1630;
  t3869 = t3284 * t1630;
  t3872 = t3276 * t3720;
  t3875 = 0.3e1 / 0.16e2 * t534 * t3840 - 0.3e1 / 0.16e2 * t534 * t3843 - t534 * t3846 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3849 + t3852 - t3853 - t3854 + t3855 - t3706 + t3707 - t156 * t3857 / 0.32e2 - t534 * t3861 / 0.16e2 - t3716 - 0.3e1 / 0.32e2 * t519 * t3843 + 0.3e1 / 0.32e2 * t519 * t3866 + t534 * t3869 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3872 + t3729 - t721;
  t3876 = my_piecewise3(t51, 0, t3875);
  tv3sigmatau28 = t3 * t3876;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3877 = t993 * t199;
  t3879 = t996 * t199;
  t3882 = t3877 * t116 / 0.2e1 - t3879 * t116 / 0.2e1 + t201 / 0.2e1;
  t3884 = t3882 * t798 * t269;
  t3887 = t798 * t199;
  t3888 = t100 * t3887;
  t3889 = t3888 * t956;
  t3892 = t3888 * t960;
  t3895 = t260 * t3887;
  t3896 = t3895 * t964;
  t3899 = t3888 * t968;
  t3902 = 0.3e1 / 0.16e2 * t3449;
  t3903 = 0.3e1 / 0.32e2 * t3452;
  t3904 = 0.3e1 / 0.16e2 * t3456;
  t3905 = 0.3e1 / 0.16e2 * t3460;
  t3906 = t3888 * t1031;
  t3909 = t3895 * t956;
  t3912 = t3895 * t1036;
  t3915 = t3888 * t939;
  t3918 = t3888 * t947;
  t3921 = -t99 * t3884 / 0.32e2 - 0.3e1 / 0.16e2 * t99 * t3889 - t99 * t3892 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t3896 + 0.3e1 / 0.16e2 * t99 * t3899 + t3902 - t3903 - t3904 + t3905 - t99 * t3906 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3909 + 0.3e1 / 0.32e2 * t99 * t3912 + t99 * t3915 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3918 - t699;
  t3922 = my_piecewise3(t2, 0, t3921);
  tv3lapl30 = t3 * t3922;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3923 = t1322 * t207;
  t3925 = t1325 * t207;
  t3928 = t3923 * t173 / 0.2e1 - t3925 * t173 / 0.2e1 + t209 / 0.2e1;
  t3930 = t3928 * t815 * t424;
  t3933 = t815 * t207;
  t3934 = t157 * t3933;
  t3935 = t3934 * t1366;
  t3938 = t3934 * t1399;
  t3941 = t415 * t3933;
  t3942 = t3941 * t1405;
  t3945 = t3934 * t1392;
  t3948 = 0.3e1 / 0.16e2 * t3504;
  t3949 = 0.3e1 / 0.16e2 * t3508;
  t3950 = 0.3e1 / 0.16e2 * t3512;
  t3951 = 0.3e1 / 0.32e2 * t3519;
  t3952 = t3934 * t1361;
  t3955 = t3941 * t1366;
  t3958 = t3941 * t1374;
  t3961 = t3934 * t1379;
  t3964 = t3934 * t1386;
  t3967 = -t156 * t3930 / 0.32e2 - 0.3e1 / 0.16e2 * t156 * t3935 - t156 * t3938 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t3942 + 0.3e1 / 0.16e2 * t156 * t3945 - t3948 + t3949 + t3950 - t3951 - t156 * t3952 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3955 + 0.3e1 / 0.32e2 * t156 * t3958 + t156 * t3961 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3964 - t721;
  t3968 = my_piecewise3(t51, 0, t3967);
  tv3lapl33 = t3 * t3968;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  t3969 = t26 * t3882;
  t3970 = t23 * t3969;
  t3973 = t213 * t798;
  t3974 = t3973 * t968;
  t3977 = t1458 * t798;
  t3978 = t640 * t3977;
  t3981 = t1463 * t798;
  t3982 = t644 * t3981;
  t3985 = t2845 * t1992;
  t3988 = t3973 * t1031;
  t3993 = t2849 * t1998;
  t3996 = t3973 * t939;
  t3999 = t1525 * t798;
  t4000 = t2005 * t3999;
  t4003 = -t3970 * t832 / 0.32e2 + t3559 + t3562 - t3567 - t3571 + t3659 - t3660 - t3661 + t3662 + 0.3e1 / 0.16e2 * t484 * t3974 - 0.3e1 / 0.16e2 * t484 * t3978 - t484 * t3982 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3985 - t484 * t3988 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3978 + 0.3e1 / 0.32e2 * t469 * t3993 + t484 * t3996 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t4000 - t699;
  t4004 = my_piecewise3(t2, 0, t4003);
  tv3lapl2tau0 = t3 * t4004;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  t4005 = t26 * t3928;
  t4006 = t60 * t4005;
  t4009 = t219 * t815;
  t4010 = t4009 * t1392;
  t4014 = t679 * t1623 * t815;
  t4017 = t1701 * t815;
  t4018 = t683 * t4017;
  t4021 = t2937 * t2146;
  t4024 = t4009 * t1361;
  t4029 = t2941 * t2158;
  t4032 = t4009 * t1379;
  t4035 = t1639 * t815;
  t4036 = t2165 * t4035;
  t4039 = -t4006 * t849 / 0.32e2 + t3603 - t3608 - t3612 + t3615 - t3702 + t3703 + t3704 - t3705 + 0.3e1 / 0.16e2 * t534 * t4010 - 0.3e1 / 0.16e2 * t534 * t4014 - t534 * t4018 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t4021 - t534 * t4024 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4014 + 0.3e1 / 0.32e2 * t519 * t4029 + t534 * t4032 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4036 - t721;
  t4040 = my_piecewise3(t51, 0, t4039);
  tv3lapl2tau5 = t3 * t4040;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  t4042 = t3882 * t866 * t269;
  t4045 = t3199 * t1787;
  t4048 = t3181 * t1739;
  t4052 = t3199 * t1463 * t199;
  t4055 = t3181 * t1787;
  t4058 = t866 * t199;
  t4059 = t4058 * t1031;
  t4064 = t3185 * t1743;
  t4067 = t3181 * t1743;
  t4071 = t3185 * t1525 * t199;
  t4074 = -t99 * t4042 / 0.32e2 + 0.3e1 / 0.16e2 * t484 * t4045 - 0.3e1 / 0.16e2 * t484 * t4048 - t484 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t4055 + t3815 + t3816 - t3817 - t3818 + t3450 - t3453 - t3457 + t3461 - t484 * t4059 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t4048 + 0.3e1 / 0.32e2 * t469 * t4064 + t484 * t4067 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t4071 - t699;
  t4075 = my_piecewise3(t2, 0, t4074);
  tv3lapltau20 = t3 * t4075;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  t4077 = t3928 * t883 * t424;
  t4081 = t3292 * t1701 * t207;
  t4084 = t3292 * t1954;
  t4088 = t3284 * t1623 * t207;
  t4091 = t3284 * t1954;
  t4094 = t883 * t207;
  t4095 = t4094 * t1361;
  t4100 = t3276 * t1970;
  t4103 = t3284 * t1970;
  t4107 = t3276 * t1639 * t207;
  t4110 = -t156 * t4077 / 0.32e2 - t534 * t4081 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t4084 - 0.3e1 / 0.16e2 * t534 * t4088 + 0.3e1 / 0.32e2 * t519 * t4091 + t3852 - t3853 - t3854 + t3855 - t3505 + t3509 + t3513 - t3520 - t534 * t4095 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4088 + 0.3e1 / 0.32e2 * t519 * t4100 + t534 * t4103 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4107 - t721;
  t4111 = my_piecewise3(t51, 0, t4110);
  tv3lapltau25 = t3 * t4111;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4112 = t993 * t213;
  t4114 = t996 * t213;
  t4117 = t4112 * t116 / 0.2e1 - t4114 * t116 / 0.2e1 + t215 / 0.2e1;
  t4119 = t4117 * t866 * t269;
  t4122 = t866 * t213;
  t4123 = t100 * t4122;
  t4124 = t4123 * t968;
  t4127 = t4123 * t956;
  t4130 = t4123 * t960;
  t4133 = t260 * t4122;
  t4134 = t4133 * t964;
  t4137 = 0.3e1 / 0.16e2 * t3558;
  t4138 = 0.3e1 / 0.16e2 * t3561;
  t4139 = 0.3e1 / 0.32e2 * t3566;
  t4140 = 0.3e1 / 0.16e2 * t3570;
  t4141 = t4123 * t1031;
  t4144 = t4133 * t956;
  t4147 = t4133 * t1036;
  t4150 = t4123 * t939;
  t4153 = t4123 * t947;
  t4156 = -t99 * t4119 / 0.32e2 + 0.3e1 / 0.16e2 * t99 * t4124 - 0.3e1 / 0.16e2 * t99 * t4127 - t99 * t4130 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t4134 + t4137 + t4138 - t4139 - t4140 - t99 * t4141 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t4144 + 0.3e1 / 0.32e2 * t99 * t4147 + t99 * t4150 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t4153 - t699;
  t4157 = my_piecewise3(t2, 0, t4156);
  tv3tau30 = t3 * t4157;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4158 = t1322 * t219;
  t4160 = t1325 * t219;
  t4163 = t4158 * t173 / 0.2e1 - t4160 * t173 / 0.2e1 + t221 / 0.2e1;
  t4165 = t4163 * t883 * t424;
  t4168 = t883 * t219;
  t4169 = t157 * t4168;
  t4170 = t4169 * t1366;
  t4173 = t4169 * t1399;
  t4176 = t415 * t4168;
  t4177 = t4176 * t1405;
  t4180 = t4169 * t1392;
  t4183 = 0.3e1 / 0.16e2 * t3602;
  t4184 = 0.3e1 / 0.32e2 * t3607;
  t4185 = 0.3e1 / 0.16e2 * t3611;
  t4186 = 0.3e1 / 0.16e2 * t3614;
  t4187 = t4169 * t1361;
  t4190 = t4176 * t1366;
  t4193 = t4176 * t1374;
  t4196 = t4169 * t1379;
  t4199 = t4169 * t1386;
  t4202 = -t156 * t4165 / 0.32e2 - 0.3e1 / 0.16e2 * t156 * t4170 - t156 * t4173 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t4177 + 0.3e1 / 0.16e2 * t156 * t4180 + t4183 - t4184 - t4185 + t4186 - t156 * t4187 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t4190 + 0.3e1 / 0.32e2 * t156 * t4193 + t156 * t4196 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t4199 - t721;
  t4203 = my_piecewise3(t51, 0, t4202);
  tv3tau33 = t3 * t4203;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t4206 = t283 * t261;
  t4217 = t1499 * t1041;
  t4219 = t1419 * t1049;
  t4221 = t1048 * t1459;
  t4224 = t1419 * t1053;
  t4229 = t1419 * t1045;
  t4237 = -0.3e1 / 0.8e1 * t484 * t4206 * t1031 - 0.9e1 / 0.8e1 * t484 * t283 * t943 * t1526 + 0.3e1 / 0.2e1 * t484 * t4206 * t939 - 0.3e1 / 0.16e2 * t4217 + 0.3e1 / 0.8e1 * t4219 - 0.9e1 / 0.8e1 * t484 * t4221 + 0.3e1 / 0.8e1 * t4224 + 0.9e1 / 0.8e1 * t484 * t4206 * t968 - 0.3e1 / 0.8e1 * t4229 - t484 * t1015 * t111 * t290 / 0.4e1 - 0.9e1 / 0.16e2 * t469 * t4221;
  t4239 = t1463 * t283;
  t4243 = t1470 * t283;
  t4253 = t1516 * t283;
  t4259 = t1015 * t263;
  t4273 = t261 * t261;
  t4274 = t260 * t4273;
  t4275 = t267 * t267;
  t4276 = 0.1e1 / t4275;
  t4277 = t936 * t4276;
  t4281 = -0.3e1 / 0.4e1 * t484 * t261 * t43 * t4239 + 0.9e1 / 0.16e2 * t469 * t1469 * t4243 + 0.3e1 / 0.4e1 * t1415 * t1053 + t484 * t1015 * t43 * t497 / 0.4e1 + 0.9e1 / 0.16e2 * t469 * t1515 * t4253 + 0.3e1 / 0.4e1 * t1415 * t1049 + t484 * t4259 * t491 / 0.4e1 - 0.3e1 / 0.4e1 * t1415 * t1045 - 0.3e1 / 0.8e1 * t1493 * t1041 - 0.5e1 / 0.32e2 * t1503 * t1041 - t469 * t470 * t471 * t1015 / 0.8e1 - 0.7e1 / 0.32e2 * t99 * t4274 * t4277;
  t4283 = t919 * t26;
  t4286 = t23 * t924;
  t4287 = t4286 * t117;
  t4289 = t241 * t95;
  t4290 = t4289 * t117;
  t4292 = t91 * t251;
  t4293 = t4292 * t117;
  t4297 = t1000 * t932;
  t4307 = t255 * t1032;
  t4309 = t100 * t4273;
  t4311 = t43 * t935 * t4276;
  t4315 = -t4283 * t117 / 0.4e1 - 0.3e1 / 0.32e2 * t4287 - 0.3e1 / 0.8e1 * t4290 + 0.3e1 / 0.16e2 * t4293 + 0.3e1 / 0.8e1 * t246 * t1037 + 0.5e1 / 0.32e2 * t99 * t4297 * t1036 - 0.3e1 / 0.8e1 * t1020 * t291 - 0.3e1 / 0.8e1 * t246 * t957 - t246 * t1032 / 0.4e1 - t4307 / 0.8e1 - t99 * t4309 * t4311 / 0.16e2;
  t4316 = t289 * t4276;
  t4321 = 0.1e1 / t934 / t264;
  t4323 = t943 * t4321 * t4276;
  t4327 = t263 * t263;
  t4329 = 0.1e1 / t934 / t294;
  t4331 = t4327 * t4329 * t4276;
  t4335 = t296 * t4276;
  t4340 = t255 * t940;
  t4343 = t263 * t945 * t4276;
  t4347 = t946 * t4276;
  t4352 = t4327 * t4321 * t4276;
  t4356 = t283 * t283;
  t4357 = t100 * t4356;
  t4364 = t1023 * t291;
  t4366 = -0.11e2 / 0.16e2 * t99 * t4309 * t4316 - 0.25e2 / 0.16e2 * t99 * t4309 * t4323 + 0.15e2 / 0.16e2 * t99 * t4309 * t4331 + 0.11e2 / 0.16e2 * t99 * t4309 * t4335 + t246 * t940 + t4340 / 0.2e1 + 0.11e2 / 0.16e2 * t99 * t4309 * t4343 + 0.11e2 / 0.16e2 * t99 * t4274 * t4347 - 0.15e2 / 0.32e2 * t99 * t4274 * t4352 + 0.3e1 / 0.16e2 * t99 * t4357 * t297 - 0.3e1 / 0.2e1 * t99 * t4309 * t4277 - 0.3e1 / 0.8e1 * t4364;
  t4371 = t984 * t291;
  t4373 = t255 * t969;
  t4378 = t1030 * t4276;
  t4390 = t984 * t285;
  t4392 = t984 * t270;
  t4394 = 0.3e1 / 0.4e1 * t246 * t969 + 0.3e1 / 0.32e2 * t4371 + 0.3e1 / 0.8e1 * t4373 - 0.3e1 / 0.16e2 * t99 * t4357 * t290 + 0.3e1 / 0.8e1 * t99 * t4309 * t4378 - 0.3e1 / 0.8e1 * t1020 * t285 - t246 * t1017 / 0.4e1 - 0.3e1 / 0.16e2 * t1020 * t270 - t246 * t1002 / 0.8e1 + 0.3e1 / 0.32e2 * t4390 + 0.3e1 / 0.64e2 * t4392;
  t4395 = t255 * t1017;
  t4397 = t255 * t1002;
  t4415 = t266 * t4276;
  t4419 = t255 * t957;
  t4428 = 0.1e1 / t991 / t45 * t100;
  t4432 = t992 * t260;
  t4439 = t993 * t261;
  t4446 = t258 * t1000;
  t4453 = t996 * t261;
  t4460 = t270 / 0.4e1 + t285 / 0.2e1 + t291 / 0.2e1 - t298 / 0.2e1 - t302 / 0.2e1 - t4428 * t261 * t269 / 0.2e1 + t4432 * t261 * t269 / 0.2e1 + t993 * t283 * t116 / 0.2e1 + t4439 * t290 / 0.2e1 - t4439 * t297 / 0.2e1 - t4439 * t301 / 0.2e1 - t4446 * t111 * t116 / 0.2e1 - t996 * t283 * t116 / 0.2e1 - t4453 * t290 / 0.2e1 + t4453 * t297 / 0.2e1 + t4453 * t301 / 0.2e1;
  t4465 = -t4395 / 0.8e1 - t4397 / 0.16e2 + 0.3e1 / 0.8e1 * t246 * t965 + 0.5e1 / 0.32e2 * t99 * t4297 * t964 + 0.3e1 / 0.8e1 * t1020 * t302 - 0.3e1 / 0.4e1 * t246 * t948 + 0.3e1 / 0.8e1 * t1020 * t298 - 0.5e1 / 0.32e2 * t99 * t4297 * t956 - t246 * t961 / 0.2e1 - 0.11e2 / 0.32e2 * t99 * t4274 * t4415 - 0.3e1 / 0.16e2 * t4419 - t99 * t4460 * t261 * t269 / 0.32e2;
  t4477 = my_piecewise3(t39, (0.3e2 * lapl[0] * t1010 - 0.12e3 * tau[0] * t1010 + 0.45e2 * sigma[0] / t105 / t32) * t37, 0);
  t4486 = t1023 * t285;
  t4488 = t1023 * t270;
  t4490 = t1023 * t302;
  t4492 = t984 * t302;
  t4497 = t255 * t961;
  t4499 = t114 * t4276;
  t4503 = t255 * t965;
  t4508 = t255 * t948;
  t4510 = -t99 * t100 * t4477 * t116 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t260 * t4356 * t269 - 0.3e1 / 0.8e1 * t4486 - 0.3e1 / 0.16e2 * t4488 + 0.3e1 / 0.8e1 * t4490 - 0.3e1 / 0.32e2 * t4492 + 0.9e1 / 0.16e2 * t99 * t4274 * t4335 - t4497 / 0.4e1 + 0.3e1 / 0.8e1 * t99 * t4309 * t4499 + 0.3e1 / 0.16e2 * t4503 + 0.3e1 / 0.16e2 * t99 * t4357 * t301 - 0.3e1 / 0.8e1 * t4508;
  t4514 = t1023 * t298;
  t4518 = t984 * t298;
  t4520 = t255 * t972;
  t4522 = t255 * t1037;
  t4524 = t1035 * t4276;
  t4528 = t16 * t16;
  t4530 = 0.1e1 / t20 / t4528;
  t4531 = t228 * t228;
  t4537 = t236 * t236;
  t4543 = 0.1e1 / t909 / t3;
  t4544 = t13 * t4543;
  t4547 = my_piecewise5(t7, 0, t11, 0, -0.24e2 * t910 + 0.24e2 * t4544);
  t4551 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4530 * t4531 - 0.9e1 / 0.4e1 * t902 * t228 * t236 + 0.9e1 / 0.4e1 * t227 * t4537 + 0.3e1 * t906 * t914 + 0.3e1 / 0.2e1 * t20 * t4547);
  t4555 = t91 * t925;
  t4559 = t24 / t25 / t231;
  t4562 = 0.15e2 / 0.128e3 * t23 * t4559 * t46;
  t4563 = t241 * t252;
  t4565 = t919 * t96;
  t4567 = 0.9e1 / 0.8e1 * t99 * t4309 * t4347 + 0.3e1 / 0.8e1 * t4514 - 0.3e1 / 0.4e1 * t246 * t972 - 0.3e1 / 0.32e2 * t4518 - 0.3e1 / 0.8e1 * t4520 + 0.3e1 / 0.16e2 * t4522 - 0.9e1 / 0.16e2 * t99 * t4274 * t4524 - M_PI * t4551 * t47 / 0.8e1 - 0.3e1 / 0.16e2 * t4555 + t4562 + 0.3e1 / 0.16e2 * t4563 - t4565 / 0.4e1;
  t4571 = my_piecewise3(t2, 0, t4237 + t4281 + t4315 + t4366 + t4394 + t4465 + t4510 + t4567);
  t4572 = t55 * t55;
  t4574 = 0.1e1 / t57 / t4572;
  t4575 = t308 * t308;
  t4581 = t314 * t314;
  t4586 = t52 * t4543;
  t4589 = my_piecewise5(t11, 0, t7, 0, 0.24e2 * t910 + 0.24e2 * t4586);
  t4593 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t4575 - 0.9e1 / 0.4e1 * t1059 * t308 * t314 + 0.9e1 / 0.4e1 * t307 * t4581 + 0.3e1 * t1063 * t1069 + 0.3e1 / 0.2e1 * t57 * t4589);
  t4597 = t1074 * t131;
  t4599 = t319 * t324;
  t4601 = t128 * t1081;
  t4605 = 0.15e2 / 0.128e3 * t60 * t4559 * t78;
  t4607 = my_piecewise3(t51, 0, -M_PI * t4593 * t79 / 0.8e1 - t4597 / 0.4e1 + 0.3e1 / 0.16e2 * t4599 - 0.3e1 / 0.16e2 * t4601 + t4605);
  tv4rho40 = 0.4e1 * t1058 + 0.4e1 * t1085 + t3 * (t4571 + t4607);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t4640 = 0.3e1 / 0.16e2 * t1553 * t1049 - 0.3e1 / 0.32e2 * t1548 * t1041 + 0.3e1 / 0.16e2 * t1553 * t1053 - 0.3e1 / 0.16e2 * t1553 * t1045 - 0.3e1 / 0.64e2 * t4217 + 0.3e1 / 0.32e2 * t4219 + 0.3e1 / 0.32e2 * t4224 - 0.3e1 / 0.32e2 * t4229 - t345 * t1032 / 0.16e2 + t345 * t940 / 0.4e1 - 0.3e1 / 0.16e2 * t345 * t948 - t345 * t1017 / 0.16e2 - t345 * t1002 / 0.32e2 + 0.3e1 / 0.16e2 * t1124 * t302 + 0.3e1 / 0.32e2 * t345 * t965 - 0.3e1 / 0.16e2 * t1124 * t285;
  t4647 = t1109 * t26;
  t4650 = t340 * t95;
  t4651 = t4650 * t117;
  t4653 = t143 * t251;
  t4654 = t4653 * t117;
  t4655 = 0.3e1 / 0.64e2 * t4654;
  t4662 = t1127 * t302;
  t4666 = t1127 * t291;
  t4670 = t1127 * t298;
  t4674 = -0.3e1 / 0.32e2 * t1124 * t270 - 0.3e1 / 0.16e2 * t1124 * t291 - 0.3e1 / 0.32e2 * t345 * t957 - 0.3e1 / 0.16e2 * t4647 * t117 - 0.3e1 / 0.16e2 * t4651 + t4655 + 0.3e1 / 0.16e2 * t1124 * t298 + 0.3e1 / 0.32e2 * t345 * t1037 - 0.3e1 / 0.16e2 * t345 * t972 + 0.3e1 / 0.32e2 * t4662 - t345 * t961 / 0.8e1 - 0.3e1 / 0.32e2 * t4666 + 0.3e1 / 0.16e2 * t345 * t969 + 0.3e1 / 0.32e2 * t4670 - 0.9e1 / 0.128e3 * t4287 - 0.3e1 / 0.32e2 * t4290;
  t4679 = t1127 * t285;
  t4681 = t1127 * t270;
  t4694 = 0.3e1 / 0.32e2 * t4293 - t4307 / 0.32e2 + t4340 / 0.8e1 - 0.3e1 / 0.32e2 * t4679 - 0.3e1 / 0.64e2 * t4681 - 0.3e1 / 0.32e2 * t4364 + 0.3e1 / 0.64e2 * t4371 + 0.3e1 / 0.32e2 * t4373 + 0.3e1 / 0.64e2 * t4390 + 0.3e1 / 0.128e3 * t4392 - t4395 / 0.32e2 - t4397 / 0.64e2 - 0.3e1 / 0.64e2 * t4419 - 0.3e1 / 0.32e2 * t4486 - 0.3e1 / 0.64e2 * t4488 + 0.3e1 / 0.32e2 * t4490;
  t4706 = t1109 * t96;
  t4708 = t340 * t252;
  t4709 = 0.3e1 / 0.32e2 * t4708;
  t4710 = t143 * t925;
  t4728 = 0.12e2 * t910;
  t4729 = 0.24e2 * t4544;
  t4731 = my_piecewise5(t7, 0, t11, 0, -t4728 + t4729);
  t4735 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4530 * t139 * t903 - 0.9e1 / 0.8e1 * t902 * t335 * t228 - 0.9e1 / 0.8e1 * t1093 * t87 * t236 + 0.9e1 / 0.4e1 * t227 * t1104 * t87 + 0.9e1 / 0.4e1 * t1096 * t236 + 0.3e1 / 0.4e1 * t331 * t914 + 0.3e1 / 0.2e1 * t20 * t4731);
  t4739 = -0.3e1 / 0.64e2 * t4492 - t4497 / 0.16e2 + 0.3e1 / 0.64e2 * t4503 - 0.3e1 / 0.32e2 * t4508 + 0.3e1 / 0.32e2 * t4514 - 0.3e1 / 0.64e2 * t4518 - 0.3e1 / 0.32e2 * t4520 + 0.3e1 / 0.64e2 * t4522 - 0.9e1 / 0.64e2 * t4555 + t4562 + 0.3e1 / 0.32e2 * t4563 - t4565 / 0.16e2 - 0.3e1 / 0.16e2 * t4706 + t4709 - 0.3e1 / 0.64e2 * t4710 - M_PI * t4735 * t47 / 0.8e1;
  t4742 = my_piecewise3(t2, 0, t4640 + t4674 + t4694 + t4739);
  t4759 = 0.24e2 * t4586;
  t4761 = my_piecewise5(t11, 0, t7, 0, t4728 + t4759);
  t4765 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t149 * t1060 - 0.9e1 / 0.8e1 * t1059 * t356 * t308 - 0.9e1 / 0.8e1 * t1140 * t124 * t314 + 0.9e1 / 0.4e1 * t307 * t1150 * t124 + 0.9e1 / 0.4e1 * t1143 * t314 + 0.3e1 / 0.4e1 * t352 * t1069 + 0.3e1 / 0.2e1 * t57 * t4761);
  t4769 = t1155 * t131;
  t4771 = t361 * t324;
  t4772 = 0.3e1 / 0.32e2 * t4771;
  t4773 = t153 * t1081;
  t4778 = t1074 * t26;
  t4781 = t319 * t95;
  t4782 = t4781 * t174;
  t4784 = t128 * t251;
  t4785 = t4784 * t174;
  t4786 = 0.3e1 / 0.64e2 * t4785;
  t4787 = t60 * t924;
  t4788 = t4787 * t174;
  t4790 = -M_PI * t4765 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t4769 + t4772 - 0.3e1 / 0.64e2 * t4773 - t4597 / 0.16e2 + 0.3e1 / 0.32e2 * t4599 - 0.9e1 / 0.64e2 * t4601 + t4605 - t4778 * t174 / 0.16e2 - 0.3e1 / 0.32e2 * t4782 + t4786 - 0.3e1 / 0.128e3 * t4788;
  t4791 = my_piecewise3(t51, 0, t4790);
  tv4rho41 = t1058 + t1085 + 0.3e1 * t1139 + 0.3e1 * t1174 + t3 * (t4742 + t4791);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4802 = t1191 * t26;
  t4805 = t389 * t95;
  t4806 = t4805 * t117;
  t4822 = t1196 * t298 / 0.16e2 + t1196 * t302 / 0.16e2 - t4802 * t117 / 0.8e1 - t4806 / 0.16e2 - t1196 * t285 / 0.16e2 - t1196 * t270 / 0.32e2 - t1196 * t291 / 0.16e2 - t4651 / 0.8e1 + t4654 / 0.16e2 + t4662 / 0.16e2 - t4666 / 0.16e2 + t4670 / 0.16e2 - 0.3e1 / 0.64e2 * t4287 + t4293 / 0.32e2 - t4679 / 0.16e2;
  t4835 = t335 * t335;
  t4848 = my_piecewise5(t7, 0, t11, 0, t4729);
  t4852 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4530 * t379 * t228 - 0.3e1 / 0.2e1 * t1093 * t87 * t335 - 0.3e1 / 0.8e1 * t1177 * t236 + 0.3e1 / 0.2e1 * t227 * t4835 + 0.3e1 / 0.2e1 * t331 * t1104 - 0.3e1 / 0.8e1 * t902 * t384 * t228 + 0.3e1 / 0.2e1 * t227 * t1186 * t87 + 0.3e1 / 0.4e1 * t1182 * t236 + 0.3e1 / 0.2e1 * t20 * t4848);
  t4856 = t1191 * t96;
  t4858 = t389 * t252;
  t4867 = -t4681 / 0.32e2 + t4371 / 0.64e2 + t4390 / 0.64e2 + t4392 / 0.128e3 - M_PI * t4852 * t47 / 0.8e1 - t4856 / 0.8e1 + t4858 / 0.32e2 - t4492 / 0.64e2 - t4518 / 0.64e2 - 0.3e1 / 0.32e2 * t4555 + t4562 + t4563 / 0.32e2 - t4706 / 0.8e1 + t4708 / 0.8e1 - 0.3e1 / 0.32e2 * t4710;
  t4869 = my_piecewise3(t2, 0, t4822 + t4867);
  t4874 = t1155 * t26;
  t4877 = t1170 * t453;
  t4879 = t1167 * t457;
  t4881 = t1170 * t457;
  t4883 = t1167 * t440;
  t4885 = t1170 * t440;
  t4887 = t1167 * t446;
  t4889 = t1170 * t446;
  t4891 = t1167 * t453;
  t4893 = t153 * t251;
  t4894 = t4893 * t174;
  t4896 = t1167 * t425;
  t4898 = t1170 * t425;
  t4900 = t361 * t95;
  t4901 = t4900 * t174;
  t4903 = -t1164 * t425 / 0.32e2 - t1164 * t440 / 0.16e2 - t4874 * t174 / 0.8e1 - t4877 / 0.64e2 + t4879 / 0.16e2 - t4881 / 0.64e2 - t4883 / 0.16e2 + t4885 / 0.64e2 - t4887 / 0.16e2 + t4889 / 0.64e2 + t4891 / 0.16e2 + t4894 / 0.32e2 - t4896 / 0.32e2 + t4898 / 0.128e3 - t4901 / 0.8e1;
  t4924 = t356 * t356;
  t4937 = my_piecewise5(t11, 0, t7, 0, t4759);
  t4941 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t395 * t308 - 0.3e1 / 0.2e1 * t1140 * t124 * t356 - 0.3e1 / 0.8e1 * t1204 * t314 + 0.3e1 / 0.2e1 * t307 * t4924 + 0.3e1 / 0.2e1 * t352 * t1150 - 0.3e1 / 0.8e1 * t1059 * t400 * t308 + 0.3e1 / 0.2e1 * t307 * t1213 * t124 + 0.3e1 / 0.4e1 * t1209 * t314 + 0.3e1 / 0.2e1 * t57 * t4937);
  t4945 = t1218 * t131;
  t4947 = t405 * t324;
  t4951 = -t1164 * t446 / 0.16e2 + t1164 * t453 / 0.16e2 + t1164 * t457 / 0.16e2 - t4782 / 0.16e2 + t4785 / 0.16e2 - 0.3e1 / 0.64e2 * t4788 - t4769 / 0.8e1 + t4771 / 0.8e1 - 0.3e1 / 0.32e2 * t4773 - M_PI * t4941 * t79 / 0.8e1 - t4945 / 0.8e1 + t4947 / 0.32e2 + t4599 / 0.32e2 - 0.3e1 / 0.32e2 * t4601 + t4605;
  t4953 = my_piecewise3(t51, 0, t4903 + t4951);
  tv4rho42 = 0.2e1 * t1139 + 0.2e1 * t1174 + 0.2e1 * t1203 + 0.2e1 * t1253 + t3 * (t4869 + t4953);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4974 = my_piecewise5(t7, 0, t11, 0, t4728 + t4729);
  t4978 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4530 * t1258 * t87 - 0.9e1 / 0.8e1 * t1177 * t335 - 0.9e1 / 0.8e1 * t1093 * t384 * t87 + 0.9e1 / 0.4e1 * t1096 * t384 + 0.9e1 / 0.4e1 * t331 * t1186 + 0.3e1 / 0.4e1 * t227 * t1265 * t87 + 0.3e1 / 0.2e1 * t20 * t4974);
  t4982 = t1270 * t96;
  t4984 = t1270 * t26;
  t4993 = -M_PI * t4978 * t47 / 0.8e1 - t4982 / 0.16e2 - t4984 * t117 / 0.16e2 - 0.3e1 / 0.16e2 * t4856 + 0.3e1 / 0.32e2 * t4858 - 0.3e1 / 0.32e2 * t4806 + t4709 - 0.9e1 / 0.64e2 * t4710 + t4655 - 0.3e1 / 0.64e2 * t4555 + t4562 - 0.3e1 / 0.128e3 * t4287;
  t4994 = my_piecewise3(t2, 0, t4993);
  t4995 = t1589 * t1302;
  t4997 = t1589 * t1306;
  t4999 = t1589 * t1310;
  t5003 = t1578 * t1298;
  t5011 = t1227 * t457;
  t5013 = t370 * t1375;
  t5015 = t370 * t1380;
  t5017 = t370 * t1387;
  t5019 = t1227 * t446;
  t5021 = t370 * t1362;
  t5023 = t370 * t1367;
  t5027 = 0.3e1 / 0.32e2 * t4995 - 0.3e1 / 0.32e2 * t4997 + 0.3e1 / 0.32e2 * t4999 - 0.3e1 / 0.16e2 * t1585 * t1306 - 0.3e1 / 0.64e2 * t5003 - 0.3e1 / 0.32e2 * t1574 * t1298 + 0.3e1 / 0.16e2 * t1585 * t1302 + 0.3e1 / 0.16e2 * t1585 * t1310 + 0.3e1 / 0.32e2 * t5011 + 0.3e1 / 0.64e2 * t5013 + t5015 / 0.8e1 - 0.3e1 / 0.32e2 * t5017 - 0.3e1 / 0.32e2 * t5019 - t5021 / 0.32e2 - 0.3e1 / 0.64e2 * t5023 - 0.3e1 / 0.16e2 * t367 * t1387;
  t5048 = t370 * t1346;
  t5050 = t405 * t95;
  t5051 = t5050 * t174;
  t5053 = t1227 * t440;
  t5055 = t1227 * t425;
  t5057 = t370 * t1331;
  t5059 = t370 * t1406;
  t5061 = 0.3e1 / 0.16e2 * t1224 * t453 + 0.3e1 / 0.16e2 * t367 * t1393 - 0.3e1 / 0.16e2 * t367 * t1396 - t367 * t1400 / 0.8e1 + 0.3e1 / 0.16e2 * t1224 * t457 - 0.3e1 / 0.16e2 * t1224 * t446 - t367 * t1362 / 0.16e2 - 0.3e1 / 0.32e2 * t367 * t1367 + 0.3e1 / 0.32e2 * t367 * t1375 + t367 * t1380 / 0.4e1 - t5048 / 0.32e2 - 0.3e1 / 0.32e2 * t5051 - 0.3e1 / 0.32e2 * t5053 - 0.3e1 / 0.64e2 * t5055 - t5057 / 0.64e2 + 0.3e1 / 0.64e2 * t5059;
  t5063 = t1227 * t453;
  t5065 = t370 * t1393;
  t5067 = t370 * t1396;
  t5069 = t370 * t1400;
  t5077 = t1218 * t26;
  t5090 = 0.3e1 / 0.32e2 * t5063 + 0.3e1 / 0.32e2 * t5065 - 0.3e1 / 0.32e2 * t5067 - t5069 / 0.16e2 - 0.3e1 / 0.32e2 * t1224 * t425 - t367 * t1331 / 0.32e2 - t367 * t1346 / 0.16e2 - 0.3e1 / 0.16e2 * t5077 * t174 - 0.3e1 / 0.16e2 * t1224 * t440 + 0.3e1 / 0.32e2 * t367 * t1406 - 0.3e1 / 0.64e2 * t4877 + 0.3e1 / 0.32e2 * t4879 - 0.3e1 / 0.64e2 * t4881 - 0.3e1 / 0.32e2 * t4883 + 0.3e1 / 0.64e2 * t4885 - 0.3e1 / 0.32e2 * t4887;
  t5098 = t1291 * t131;
  t5116 = my_piecewise5(t11, 0, t7, 0, -t4728 + t4759);
  t5120 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t1279 * t124 - 0.9e1 / 0.8e1 * t1204 * t356 - 0.9e1 / 0.8e1 * t1140 * t400 * t124 + 0.9e1 / 0.4e1 * t1143 * t400 + 0.9e1 / 0.4e1 * t352 * t1213 + 0.3e1 / 0.4e1 * t307 * t1286 * t124 + 0.3e1 / 0.2e1 * t57 * t5116);
  t5128 = 0.3e1 / 0.64e2 * t4889 + 0.3e1 / 0.32e2 * t4891 + 0.3e1 / 0.32e2 * t4894 - 0.3e1 / 0.64e2 * t4896 + 0.3e1 / 0.128e3 * t4898 - 0.3e1 / 0.16e2 * t4901 + t4786 - 0.9e1 / 0.128e3 * t4788 - t5098 / 0.16e2 - M_PI * t5120 * t79 / 0.8e1 + t4772 - 0.9e1 / 0.64e2 * t4773 - 0.3e1 / 0.16e2 * t4945 + 0.3e1 / 0.32e2 * t4947 - 0.3e1 / 0.64e2 * t4601 + t4605;
  t5131 = my_piecewise3(t51, 0, t5027 + t5061 + t5090 + t5128);
  tv4rho43 = 0.3e1 * t1203 + 0.3e1 * t1253 + t1276 + t1411 + t3 * (t4994 + t5131);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t5136 = t379 * t379;
  t5141 = t384 * t384;
  t5148 = my_piecewise5(t7, 0, t11, 0, 0.24e2 * t910 + 0.24e2 * t4544);
  t5152 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4530 * t5136 - 0.9e1 / 0.4e1 * t1177 * t384 + 0.9e1 / 0.4e1 * t227 * t5141 + 0.3e1 * t331 * t1265 + 0.3e1 / 0.2e1 * t20 * t5148);
  t5160 = my_piecewise3(t2, 0, -M_PI * t5152 * t47 / 0.8e1 - t4982 / 0.4e1 + 0.3e1 / 0.16e2 * t4858 - 0.3e1 / 0.16e2 * t4710 + t4562);
  t5161 = t438 * t1370;
  t5165 = t438 * t416;
  t5169 = t1309 * t1947;
  t5172 = t1706 * t438;
  t5182 = t1629 * t438;
  t5188 = t1344 * t418;
  t5198 = -0.9e1 / 0.8e1 * t534 * t5161 * t1640 + 0.3e1 / 0.2e1 * t534 * t5165 * t1379 - 0.9e1 / 0.8e1 * t534 * t5169 + 0.9e1 / 0.16e2 * t519 * t1622 * t5172 + 0.9e1 / 0.8e1 * t534 * t5165 * t1392 - 0.3e1 / 0.8e1 * t534 * t5165 * t1361 + 0.9e1 / 0.16e2 * t519 * t1628 * t5182 + 0.3e1 / 0.4e1 * t1678 * t1310 + t534 * t5188 * t541 / 0.4e1 - t534 * t1344 * t168 * t445 / 0.4e1 - 0.9e1 / 0.16e2 * t519 * t5169;
  t5209 = t1701 * t438;
  t5226 = -0.3e1 / 0.4e1 * t1678 * t1306 + 0.3e1 / 0.8e1 * t4995 - 0.3e1 / 0.8e1 * t4997 + 0.3e1 / 0.8e1 * t4999 + t534 * t1344 * t75 * t547 / 0.4e1 - 0.3e1 / 0.4e1 * t534 * t416 * t75 * t5209 + 0.3e1 / 0.4e1 * t1678 * t1302 - 0.3e1 / 0.8e1 * t1681 * t1298 - 0.5e1 / 0.32e2 * t1655 * t1298 - t519 * t520 * t521 * t1344 / 0.8e1 - 0.3e1 / 0.16e2 * t5003 - t409 * t1362 / 0.4e1;
  t5228 = t416 * t416;
  t5229 = t157 * t5228;
  t5231 = t422 * t422;
  t5232 = 0.1e1 / t5231;
  t5233 = t75 * t1372 * t5232;
  t5238 = t418 * t1384 * t5232;
  t5242 = t415 * t5228;
  t5243 = t1385 * t5232;
  t5247 = t418 * t418;
  t5249 = 0.1e1 / t1371 / t419;
  t5251 = t5247 * t5249 * t5232;
  t5256 = t1370 * t5249 * t5232;
  t5261 = 0.1e1 / t1371 / t449;
  t5263 = t5247 * t5261 * t5232;
  t5270 = t1378 * t5232;
  t5274 = t1291 * t26;
  t5277 = t1329 * t1356;
  t5281 = -t156 * t5229 * t5233 / 0.16e2 + 0.11e2 / 0.16e2 * t156 * t5229 * t5238 + 0.11e2 / 0.16e2 * t156 * t5242 * t5243 - 0.15e2 / 0.32e2 * t156 * t5242 * t5251 - 0.25e2 / 0.16e2 * t156 * t5229 * t5256 + 0.15e2 / 0.16e2 * t156 * t5229 * t5263 + t409 * t1380 + 0.3e1 / 0.8e1 * t1313 * t457 - 0.7e1 / 0.32e2 * t156 * t5242 * t5270 - t5274 * t174 / 0.4e1 - 0.5e1 / 0.32e2 * t156 * t5277 * t1366;
  t5298 = t444 * t5232;
  t5302 = t451 * t5232;
  t5306 = t1373 * t5232;
  t5310 = t438 * t438;
  t5311 = t157 * t5310;
  t5318 = 0.3e1 / 0.8e1 * t409 * t1375 + 0.5e1 / 0.32e2 * t156 * t5277 * t1374 - 0.3e1 / 0.4e1 * t409 * t1387 - 0.3e1 / 0.8e1 * t1313 * t446 - 0.3e1 / 0.8e1 * t409 * t1367 + 0.9e1 / 0.8e1 * t156 * t5229 * t5243 - 0.3e1 / 0.4e1 * t409 * t1396 - 0.11e2 / 0.16e2 * t156 * t5229 * t5298 + 0.11e2 / 0.16e2 * t156 * t5229 * t5302 - 0.9e1 / 0.16e2 * t156 * t5242 * t5306 + 0.3e1 / 0.16e2 * t156 * t5311 * t452 - 0.3e1 / 0.2e1 * t156 * t5229 * t5270;
  t5324 = t1358 * t5232;
  t5348 = 0.1e1 / t1320 / t77 * t157;
  t5352 = t1321 * t415;
  t5359 = t1322 * t416;
  t5366 = t413 * t1329;
  t5373 = t1325 * t416;
  t5380 = t425 / 0.4e1 + t440 / 0.2e1 + t446 / 0.2e1 - t453 / 0.2e1 - t457 / 0.2e1 - t5348 * t416 * t424 / 0.2e1 + t5352 * t416 * t424 / 0.2e1 + t1322 * t438 * t173 / 0.2e1 + t5359 * t445 / 0.2e1 - t5359 * t452 / 0.2e1 - t5359 * t456 / 0.2e1 - t5366 * t168 * t173 / 0.2e1 - t1325 * t438 * t173 / 0.2e1 - t5373 * t445 / 0.2e1 + t5373 * t452 / 0.2e1 + t5373 * t456 / 0.2e1;
  t5395 = my_piecewise3(t72, (0.3e2 * lapl[1] * t1339 - 0.12e3 * tau[1] * t1339 + 0.45e2 * sigma[2] / t162 / t66) * t37, 0);
  t5402 = -0.3e1 / 0.16e2 * t156 * t5311 * t445 + 0.3e1 / 0.8e1 * t156 * t5229 * t5324 + 0.9e1 / 0.16e2 * t156 * t5242 * t5302 + 0.3e1 / 0.4e1 * t409 * t1393 - 0.3e1 / 0.8e1 * t1313 * t440 - 0.3e1 / 0.16e2 * t1313 * t425 - t409 * t1346 / 0.4e1 - t409 * t1331 / 0.8e1 - t156 * t5380 * t416 * t424 / 0.32e2 - t156 * t157 * t5395 * t173 / 0.16e2 + 0.3e1 / 0.8e1 * t409 * t1406;
  t5410 = t421 * t5232;
  t5424 = 0.5e1 / 0.32e2 * t156 * t5277 * t1405 + 0.3e1 / 0.8e1 * t1313 * t453 - t409 * t1400 / 0.2e1 - 0.11e2 / 0.32e2 * t156 * t5242 * t5410 + 0.3e1 / 0.8e1 * t5011 + 0.3e1 / 0.16e2 * t5013 + t5015 / 0.2e1 - 0.3e1 / 0.8e1 * t5017 - 0.3e1 / 0.8e1 * t5019 - t5021 / 0.8e1 - 0.3e1 / 0.16e2 * t5023 + 0.3e1 / 0.16e2 * t156 * t5311 * t456;
  t5426 = t171 * t5232;
  t5444 = 0.3e1 / 0.8e1 * t156 * t5229 * t5426 - 0.3e1 / 0.32e2 * t156 * t415 * t5310 * t424 - t5048 / 0.8e1 - 0.3e1 / 0.8e1 * t5051 - 0.3e1 / 0.8e1 * t5053 - 0.3e1 / 0.16e2 * t5055 - t5057 / 0.16e2 + 0.3e1 / 0.16e2 * t5059 + 0.3e1 / 0.8e1 * t5063 + 0.3e1 / 0.8e1 * t5065 - 0.3e1 / 0.8e1 * t5067 - t5069 / 0.4e1;
  t5452 = t395 * t395;
  t5457 = t400 * t400;
  t5464 = my_piecewise5(t11, 0, t7, 0, -0.24e2 * t910 + 0.24e2 * t4586);
  t5468 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t5452 - 0.9e1 / 0.4e1 * t1204 * t400 + 0.9e1 / 0.4e1 * t307 * t5457 + 0.3e1 * t352 * t1286 + 0.3e1 / 0.2e1 * t57 * t5464);
  t5475 = -0.3e1 / 0.32e2 * t4877 - 0.3e1 / 0.32e2 * t4881 + 0.3e1 / 0.32e2 * t4885 + 0.3e1 / 0.32e2 * t4889 + 0.3e1 / 0.16e2 * t4894 + 0.3e1 / 0.64e2 * t4898 - 0.3e1 / 0.32e2 * t4788 - M_PI * t5468 * t79 / 0.8e1 - t5098 / 0.4e1 - 0.3e1 / 0.16e2 * t4773 + 0.3e1 / 0.16e2 * t4947 + t4605;
  t5479 = my_piecewise3(t51, 0, t5198 + t5226 + t5281 + t5318 + t5402 + t5424 + t5444 + t5475);
  tv4rho44 = 0.4e1 * t1276 + 0.4e1 * t1411 + t3 * (t5160 + t5479);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t5483 = t113 * t4276;
  t5484 = t5483 * t932;
  t5488 = t1499 * t1472;
  t5493 = t23 * t251 * t100;
  t5494 = t5493 * t492;
  t5496 = t1419 * t1460;
  t5498 = t1447 * t1459;
  t5501 = t183 * t932;
  t5505 = t91 * t1418;
  t5506 = t5505 * t486;
  t5510 = t5493 * t486;
  t5512 = t1419 * t1455;
  t5514 = t478 * t261;
  t5518 = t5505 * t492;
  t5520 = 0.3e1 / 0.8e1 * t484 * t495 * t5484 + 0.9e1 / 0.64e2 * t5488 - 0.9e1 / 0.16e2 * t1415 * t1460 - 0.3e1 / 0.64e2 * t5494 - 0.9e1 / 0.32e2 * t5496 - 0.9e1 / 0.16e2 * t484 * t5498 + 0.3e1 / 0.8e1 * t484 * t5501 * t4378 - 0.3e1 / 0.16e2 * t5506 + 0.9e1 / 0.16e2 * t1415 * t1455 + 0.3e1 / 0.64e2 * t5510 + 0.9e1 / 0.32e2 * t5512 + 0.9e1 / 0.16e2 * t484 * t5514 * t968 + 0.3e1 / 0.16e2 * t5518;
  t5521 = t241 * t483;
  t5528 = t1419 * t1476;
  t5530 = t1419 * t1480;
  t5535 = t295 * t4276;
  t5536 = t5535 * t932;
  t5537 = t489 * t5536;
  t5540 = t1419 * t1465;
  t5545 = t1516 * t478;
  t5549 = t932 * t263;
  t5550 = t935 * t4276;
  t5551 = t5550 * t183;
  t5552 = t5549 * t5551;
  t5557 = t1419 * t1440;
  t5559 = t1419 * t1484;
  t5561 = -0.3e1 / 0.16e2 * t5521 * t486 - 0.3e1 / 0.8e1 * t1415 * t1440 - 0.3e1 / 0.16e2 * t1415 * t1484 + 0.3e1 / 0.32e2 * t5528 + 0.3e1 / 0.16e2 * t5530 - 0.11e2 / 0.16e2 * t484 * t5501 * t4316 + 0.11e2 / 0.16e2 * t484 * t5537 - 0.3e1 / 0.16e2 * t5540 + 0.3e1 / 0.16e2 * t484 * t1447 * t1487 + 0.9e1 / 0.32e2 * t469 * t1515 * t5545 - 0.7e1 / 0.32e2 * t469 * t5552 - 0.9e1 / 0.32e2 * t1493 * t1460 - 0.3e1 / 0.16e2 * t5557 - 0.3e1 / 0.32e2 * t5559;
  t5563 = t1499 * t1460;
  t5586 = t496 * t1015;
  t5602 = -0.9e1 / 0.64e2 * t5563 - 0.3e1 / 0.16e2 * t484 * t1434 * t111 * t290 - 0.3e1 / 0.16e2 * t484 * t478 * t283 * t290 - 0.9e1 / 0.32e2 * t469 * t5498 + 0.3e1 / 0.16e2 * t5521 * t492 + 0.3e1 / 0.8e1 * t1415 * t1448 + 0.3e1 / 0.16e2 * t1415 * t1488 + 0.3e1 / 0.16e2 * t1415 * t1476 + 0.3e1 / 0.16e2 * t484 * t1479 * t1475 + t484 * t495 * t5586 / 0.16e2 + 0.3e1 / 0.8e1 * t1415 * t1480 + 0.3e1 / 0.16e2 * t484 * t1434 * t43 * t497 - t484 * t183 * t1015 * t290 / 0.16e2 + 0.9e1 / 0.16e2 * t469 * t5537;
  t5603 = t932 * t943;
  t5612 = t265 * t4276;
  t5613 = t5612 * t183;
  t5621 = t1470 * t478;
  t5627 = t1419 * t1448;
  t5629 = t1419 * t1488;
  t5631 = t1499 * t1518;
  t5633 = t1434 * t263;
  t5642 = -0.9e1 / 0.16e2 * t469 * t5603 * t5551 - 0.3e1 / 0.8e1 * t1415 * t1465 - 0.3e1 / 0.8e1 * t484 * t1479 * t1464 - 0.11e2 / 0.32e2 * t469 * t5549 * t5613 + 0.9e1 / 0.32e2 * t1493 * t1472 + 0.5e1 / 0.32e2 * t1503 * t1472 + 0.9e1 / 0.32e2 * t469 * t1469 * t5621 + 0.9e1 / 0.32e2 * t1493 * t1518 + 0.3e1 / 0.16e2 * t5627 + 0.3e1 / 0.32e2 * t5629 + 0.9e1 / 0.64e2 * t5631 + 0.3e1 / 0.16e2 * t484 * t5633 * t491 - 0.3e1 / 0.32e2 * t1503 * t1510 - t469 * t4259 * t472 / 0.32e2;
  t5648 = t471 * t1434;
  t5652 = t5493 * t498;
  t5655 = t23 * t251 * t260;
  t5656 = t5655 * t473;
  t5659 = t23 * t95 * t1000;
  t5660 = t5659 * t473;
  t5662 = t1499 * t1506;
  t5664 = t1499 * t1510;
  t5667 = t23 * t26 * t4460;
  t5670 = t490 * t1015;
  t5674 = t5505 * t498;
  t5676 = t91 * t1498;
  t5677 = t5676 * t473;
  t5681 = t241 * t468;
  t5684 = -0.3e1 / 0.32e2 * t469 * t1048 * t1509 - 0.3e1 / 0.32e2 * t469 * t470 * t5648 - 0.3e1 / 0.64e2 * t5652 + 0.3e1 / 0.128e3 * t5656 - 0.3e1 / 0.64e2 * t5660 - 0.3e1 / 0.64e2 * t5662 - 0.3e1 / 0.32e2 * t5664 - t5667 * t473 / 0.32e2 + t484 * t489 * t5670 / 0.16e2 + 0.3e1 / 0.16e2 * t5674 - 0.3e1 / 0.32e2 * t5677 + 0.3e1 / 0.16e2 * t5521 * t498 - 0.3e1 / 0.32e2 * t5681 * t473;
  t5685 = t91 * t1502;
  t5692 = t1419 * t1527;
  t5703 = t945 * t4276;
  t5704 = t5703 * t932;
  t5705 = t1524 * t5704;
  t5710 = t1419 * t1521;
  t5717 = t1419 * t1452;
  t5722 = -0.3e1 / 0.32e2 * t5685 * t473 - 0.3e1 / 0.32e2 * t1493 * t1506 - 0.3e1 / 0.16e2 * t1493 * t1510 - 0.9e1 / 0.32e2 * t5692 - 0.9e1 / 0.16e2 * t484 * t478 * t943 * t1526 + 0.11e2 / 0.16e2 * t484 * t5501 * t4343 - 0.3e1 / 0.2e1 * t484 * t5552 + 0.9e1 / 0.8e1 * t484 * t5705 + 0.3e1 / 0.4e1 * t1415 * t1521 + 0.3e1 / 0.8e1 * t5710 + 0.3e1 / 0.4e1 * t484 * t5514 * t939 - 0.3e1 / 0.16e2 * t1415 * t1452 - 0.3e1 / 0.32e2 * t5717 - 0.3e1 / 0.16e2 * t484 * t5514 * t1031;
  t5729 = t932 * t4327;
  t5730 = t4321 * t4276;
  t5731 = t5730 * t183;
  t5739 = t4329 * t4276;
  t5740 = t5739 * t932;
  t5752 = t255 * t1436;
  t5756 = my_piecewise3(t39, -0.15e2 / 0.2e1 * t1010 * t37, 0);
  t5761 = t1023 * t480;
  t5763 = t984 * t480;
  t5767 = -t484 * t5501 * t4311 / 0.16e2 - t1503 * t1506 / 0.16e2 - 0.15e2 / 0.32e2 * t469 * t5729 * t5731 - 0.25e2 / 0.16e2 * t484 * t5501 * t4323 + 0.15e2 / 0.16e2 * t484 * t183 * t4327 * t5740 - 0.5e1 / 0.32e2 * t1503 * t1460 + 0.5e1 / 0.32e2 * t1503 * t1518 + 0.11e2 / 0.16e2 * t469 * t5705 - 0.9e1 / 0.16e2 * t1415 * t1527 - 0.3e1 / 0.32e2 * t5752 - t99 * t100 * t5756 * t116 / 0.16e2 - 0.3e1 / 0.16e2 * t5761 + 0.3e1 / 0.64e2 * t5763 - t4283 * t185 / 0.16e2;
  t5772 = t4289 * t185;
  t5775 = 0.3e1 / 0.128e3 * t4286 * t185;
  t5776 = t4292 * t185;
  t5778 = t485 * t43;
  t5779 = t1458 * t283;
  t5783 = t470 * t295;
  t5784 = t2456 * t283;
  t5785 = t5783 * t5784;
  t5793 = t495 * t113;
  t5795 = t938 * t111 * t283;
  t5799 = t470 * t265;
  t5803 = t111 * t943;
  t5804 = t5803 * t935;
  t5812 = t1524 * t945;
  t5816 = -0.3e1 / 0.16e2 * t1020 * t480 - 0.3e1 / 0.16e2 * t246 * t1436 - 0.3e1 / 0.32e2 * t5772 - t5775 + 0.3e1 / 0.64e2 * t5776 - 0.3e1 / 0.16e2 * t484 * t5778 * t5779 - 0.9e1 / 0.32e2 * t469 * t5785 + 0.9e1 / 0.16e2 * t484 * t5778 * t4243 - 0.9e1 / 0.16e2 * t484 * t5785 - 0.3e1 / 0.8e1 * t484 * t5793 * t5795 + 0.9e1 / 0.32e2 * t469 * t5799 * t5784 + 0.9e1 / 0.32e2 * t469 * t5804 * t5784 + 0.3e1 / 0.4e1 * t484 * t1483 * t263 * t2247 - 0.9e1 / 0.16e2 * t484 * t5812 * t5795;
  t5820 = my_piecewise3(t2, 0, t5520 + t5561 + t5602 + t5642 + t5684 + t5722 + t5767 + t5816);
  tv4rho3sigma0 = t3 * t5820 + 0.3e1 * t1532;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5825 = t4781 * t193;
  t5827 = t4784 * t193;
  t5830 = 0.3e1 / 0.128e3 * t4787 * t193;
  t5832 = my_piecewise3(t51, 0, -t4778 * t193 / 0.16e2 - 0.3e1 / 0.32e2 * t5825 + 0.3e1 / 0.64e2 * t5827 - t5830);
  tv4rho3sigma2 = t3 * t5832 + 0.3e1 * t1542;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5834 = 0.2e1 * t1567;
  t5835 = t340 * t483;
  t5838 = t143 * t1418;
  t5840 = t5838 * t486 / 0.16e2;
  t5862 = t5838 * t492 / 0.16e2;
  t5869 = -t5835 * t486 / 0.8e1 - t5840 - t1553 * t1440 / 0.8e1 - t1553 * t1465 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t1472 + 0.3e1 / 0.16e2 * t1553 * t1455 - 0.3e1 / 0.16e2 * t1553 * t1460 - 0.3e1 / 0.32e2 * t1548 * t1460 + 0.3e1 / 0.32e2 * t1548 * t1518 + t1553 * t1521 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t1527 + t5835 * t492 / 0.8e1 + t5862 + t1553 * t1448 / 0.8e1 - t1553 * t1452 / 0.16e2 + t1553 * t1476 / 0.16e2;
  t5870 = t143 * t1498;
  t5872 = t5870 * t473 / 0.32e2;
  t5873 = t143 * t1502;
  t5886 = t340 * t468;
  t5890 = t5838 * t498 / 0.16e2;
  t5898 = -t5872 - t5873 * t473 / 0.32e2 - t1548 * t1506 / 0.32e2 - t1548 * t1510 / 0.16e2 + t1553 * t1480 / 0.8e1 - t1553 * t1484 / 0.16e2 + t5835 * t498 / 0.8e1 - t5886 * t473 / 0.16e2 + t5890 + 0.3e1 / 0.64e2 * t5488 - t5494 / 0.32e2 - 0.3e1 / 0.32e2 * t5496 - t5506 / 0.16e2 + t5510 / 0.32e2 + 0.3e1 / 0.32e2 * t5512 + t5518 / 0.16e2;
  t5917 = t1553 * t1488 / 0.16e2 + t5528 / 0.32e2 + t5530 / 0.16e2 - t5540 / 0.16e2 - t5557 / 0.16e2 - t5559 / 0.32e2 - 0.3e1 / 0.64e2 * t5563 + t5627 / 0.16e2 + t5629 / 0.32e2 + 0.3e1 / 0.64e2 * t5631 - t5652 / 0.32e2 + t5656 / 0.64e2 - t5660 / 0.64e2 - t5662 / 0.64e2 - t5664 / 0.32e2 + t5674 / 0.16e2;
  t5928 = t4650 * t185 / 0.16e2;
  t5929 = t4653 * t185;
  t5932 = t1127 * t480 / 0.16e2;
  t5939 = -t5677 / 0.32e2 - 0.3e1 / 0.32e2 * t5692 + t5710 / 0.8e1 - t5717 / 0.32e2 - t5752 / 0.32e2 - t5761 / 0.16e2 + t5763 / 0.32e2 - t5772 / 0.32e2 - t5775 + t5776 / 0.32e2 - t5928 + t5929 / 0.64e2 - t5932 - t345 * t1436 / 0.16e2 - t4647 * t185 / 0.16e2 - t1124 * t480 / 0.8e1;
  t5942 = my_piecewise3(t2, 0, t5869 + t5898 + t5917 + t5939);
  tv4rho3sigma3 = t3 * t5942 + t1532 + t5834;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5944 = 0.2e1 * t1601;
  t5946 = t60 * t251 * t157;
  t5947 = t5946 * t548;
  t5949 = t128 * t1588;
  t5951 = t5949 * t536 / 0.16e2;
  t5952 = t5946 * t536;
  t5955 = t5949 * t542 / 0.16e2;
  t5956 = t5946 * t542;
  t5959 = t5949 * t548 / 0.16e2;
  t5960 = t128 * t1577;
  t5962 = t5960 * t523 / 0.32e2;
  t5964 = t60 * t251 * t415;
  t5965 = t5964 * t523;
  t5967 = t319 * t533;
  t5975 = t319 * t518;
  t5979 = t1167 * t530 / 0.16e2;
  t5980 = t1170 * t530;
  t5983 = t4900 * t193 / 0.16e2;
  t5984 = t4893 * t193;
  t5992 = t5967 * t542 / 0.16e2 - t5975 * t523 / 0.32e2 - t5979 + t5980 / 0.64e2 - t5983 + t5984 / 0.64e2 - t5830 - t5825 / 0.32e2 + t5827 / 0.32e2 - t1164 * t530 / 0.16e2 - t4874 * t193 / 0.16e2;
  t5994 = my_piecewise3(t51, 0, -t5947 / 0.64e2 - t5951 + t5952 / 0.64e2 + t5955 - t5956 / 0.64e2 + t5959 - t5962 + t5965 / 0.128e3 + t5967 * t548 / 0.16e2 - t5967 * t536 / 0.16e2 + t5992);
  tv4rho3sigma5 = t3 * t5994 + t1542 + t5944;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5998 = t4805 * t185;
  t6000 = t389 * t468;
  t6005 = t389 * t483;
  t6020 = -t5932 - t5840 + t5862 + t5890 + t5776 / 0.64e2 - t5775 + t5656 / 0.128e3 + t5763 / 0.64e2 + t5510 / 0.64e2 - t5494 / 0.64e2 - t5652 / 0.64e2;
  t6022 = my_piecewise3(t2, 0, -t4802 * t185 / 0.16e2 - t5998 / 0.32e2 - t6000 * t473 / 0.32e2 - t1196 * t480 / 0.16e2 - t6005 * t486 / 0.16e2 + t6005 * t492 / 0.16e2 + t6005 * t498 / 0.16e2 - t5928 + t5929 / 0.32e2 - t5872 + t6020);
  tv4rho3sigma6 = t3 * t6022 + t1608 + t5834;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t6024 = t1589 * t1625;
  t6026 = t1589 * t1703;
  t6028 = t1578 * t1708;
  t6030 = t1589 * t1711;
  t6032 = t153 * t1588;
  t6033 = t6032 * t536;
  t6035 = t6032 * t542;
  t6037 = t1589 * t1693;
  t6039 = t1589 * t1696;
  t6041 = t1589 * t1675;
  t6043 = t6032 * t548;
  t6045 = t153 * t1577;
  t6046 = t6045 * t523;
  t6048 = t1589 * t1685;
  t6051 = t60 * t95 * t1329;
  t6052 = t6051 * t523;
  t6054 = t1578 * t1659;
  t6056 = t1578 * t1663;
  t6058 = t1589 * t1667;
  t6060 = -0.3e1 / 0.32e2 * t6024 - t6026 / 0.16e2 + 0.3e1 / 0.64e2 * t6028 + 0.3e1 / 0.32e2 * t6030 - t6033 / 0.16e2 + t6035 / 0.16e2 + t6037 / 0.16e2 - t6039 / 0.32e2 + t6041 / 0.32e2 + t6043 / 0.16e2 - t6046 / 0.32e2 - t6048 / 0.16e2 - t6052 / 0.64e2 - t6054 / 0.64e2 - t6056 / 0.32e2 + t6058 / 0.16e2;
  t6061 = t1589 * t1671;
  t6063 = t1589 * t1651;
  t6073 = t361 * t533;
  t6076 = t361 * t518;
  t6079 = t128 * t1654;
  t6090 = t1578 * t1631;
  t6092 = t1589 * t1635;
  t6094 = t1589 * t1641;
  t6096 = -t6061 / 0.32e2 + t6063 / 0.32e2 + t1585 * t1693 / 0.8e1 - t1585 * t1685 / 0.8e1 - t1585 * t1671 / 0.16e2 + t1585 * t1675 / 0.16e2 + t6073 * t548 / 0.8e1 - t6076 * t523 / 0.16e2 - t6079 * t523 / 0.32e2 - t1574 * t1659 / 0.32e2 - t1574 * t1663 / 0.16e2 + t1585 * t1667 / 0.8e1 + t1585 * t1651 / 0.16e2 + 0.3e1 / 0.64e2 * t6090 + t6092 / 0.8e1 - 0.3e1 / 0.32e2 * t6094;
  t6098 = t1578 * t1625;
  t6124 = -0.3e1 / 0.64e2 * t6098 - 0.3e1 / 0.16e2 * t1585 * t1641 - 0.3e1 / 0.32e2 * t1574 * t1625 + 0.3e1 / 0.32e2 * t1574 * t1631 + t1585 * t1635 / 0.4e1 + 0.3e1 / 0.32e2 * t1574 * t1708 + 0.3e1 / 0.16e2 * t1585 * t1711 - t1585 * t1696 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t1625 - t1585 * t1703 / 0.8e1 - t6073 * t536 / 0.8e1 + t6073 * t542 / 0.8e1 - t5947 / 0.32e2 - t5951 + t5952 / 0.32e2 + t5955;
  t6127 = t370 * t1615;
  t6129 = t5050 * t193;
  t6131 = t1227 * t530;
  t6142 = -t5956 / 0.32e2 + t5959 - t5962 + t5965 / 0.64e2 - t6127 / 0.32e2 - t6129 / 0.32e2 - t6131 / 0.16e2 - t367 * t1615 / 0.16e2 - t5077 * t193 / 0.16e2 - t1224 * t530 / 0.8e1 - t5979 + t5980 / 0.32e2 - t5983 + t5984 / 0.32e2 + t5827 / 0.64e2 - t5830;
  t6145 = my_piecewise3(t51, 0, t6060 + t6096 + t6124 + t6142);
  tv4rho3sigma8 = t3 * t6145 + t1716 + t5944;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t6153 = my_piecewise3(t2, 0, -t4984 * t185 / 0.16e2 - 0.3e1 / 0.32e2 * t5998 + 0.3e1 / 0.64e2 * t5929 - t5775);
  tv4rho3sigma9 = t3 * t6153 + 0.3e1 * t1608;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t6158 = t1623 * t528;
  t6159 = t1622 * t6158;
  t6162 = t1629 * t528;
  t6174 = t528 * t416;
  t6180 = t1613 * t418;
  t6184 = t405 * t533;
  t6192 = 0.5e1 / 0.32e2 * t1655 * t1631 - 0.9e1 / 0.32e2 * t519 * t6159 + 0.9e1 / 0.32e2 * t519 * t1628 * t6162 - 0.9e1 / 0.16e2 * t534 * t6159 - 0.9e1 / 0.16e2 * t1678 * t1625 - 0.9e1 / 0.32e2 * t1681 * t1625 + 0.9e1 / 0.32e2 * t1681 * t1631 + 0.9e1 / 0.16e2 * t534 * t6174 * t1392 + 0.9e1 / 0.16e2 * t1678 * t1711 + 0.3e1 / 0.16e2 * t534 * t6180 * t541 + 0.3e1 / 0.16e2 * t6184 * t542 + 0.3e1 / 0.8e1 * t1678 * t1693 - 0.3e1 / 0.16e2 * t534 * t6174 * t1361;
  t6195 = t191 * t1356;
  t6202 = t1356 * t1370;
  t6203 = t1384 * t5232;
  t6204 = t6203 * t191;
  t6205 = t6202 * t6204;
  t6208 = t1356 * t5247;
  t6209 = t5249 * t5232;
  t6210 = t6209 * t191;
  t6217 = t191 * t5247;
  t6218 = t5261 * t5232;
  t6219 = t6218 * t1356;
  t6230 = t528 * t1370;
  t6237 = t1372 * t5232;
  t6238 = t6237 * t1356;
  t6239 = t539 * t6238;
  t6244 = -0.3e1 / 0.16e2 * t1678 * t1696 - t534 * t6195 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t6195 * t5298 + 0.11e2 / 0.16e2 * t519 * t6205 - 0.15e2 / 0.32e2 * t519 * t6208 * t6210 - 0.25e2 / 0.16e2 * t534 * t6195 * t5256 + 0.15e2 / 0.16e2 * t534 * t6217 * t6219 + 0.3e1 / 0.4e1 * t534 * t6174 * t1379 + 0.3e1 / 0.4e1 * t1678 * t1635 - 0.9e1 / 0.16e2 * t1678 * t1641 - 0.9e1 / 0.16e2 * t534 * t6230 * t1640 + 0.11e2 / 0.16e2 * t534 * t6195 * t5238 - 0.3e1 / 0.2e1 * t534 * t6239 + 0.9e1 / 0.8e1 * t534 * t6205;
  t6246 = t1356 * t418;
  t6247 = t450 * t5232;
  t6248 = t6247 * t191;
  t6249 = t6246 * t6248;
  t6257 = t546 * t1344;
  t6261 = t153 * t1654;
  t6265 = t60 * t26 * t5380;
  t6287 = 0.9e1 / 0.16e2 * t519 * t6249 - 0.5e1 / 0.32e2 * t1655 * t1625 - 0.3e1 / 0.8e1 * t534 * t1666 * t1702 + t534 * t545 * t6257 / 0.16e2 - 0.3e1 / 0.32e2 * t6261 * t523 - t6265 * t523 / 0.32e2 - t1655 * t1659 / 0.16e2 - 0.3e1 / 0.32e2 * t1655 * t1663 - 0.3e1 / 0.32e2 * t1681 * t1659 - 0.3e1 / 0.16e2 * t534 * t1613 * t168 * t445 - 0.3e1 / 0.16e2 * t6184 * t536 - 0.3e1 / 0.8e1 * t1678 * t1685 + 0.3e1 / 0.8e1 * t534 * t6195 * t5324 + 0.11e2 / 0.16e2 * t534 * t6249;
  t6288 = t170 * t5232;
  t6289 = t6288 * t1356;
  t6297 = t1706 * t528;
  t6303 = t6237 * t191;
  t6312 = t540 * t1344;
  t6320 = t405 * t518;
  t6329 = 0.3e1 / 0.8e1 * t534 * t545 * t6289 - 0.3e1 / 0.8e1 * t1678 * t1703 + 0.5e1 / 0.32e2 * t1655 * t1708 + 0.9e1 / 0.32e2 * t519 * t1622 * t6297 - 0.7e1 / 0.32e2 * t519 * t6239 - 0.9e1 / 0.16e2 * t519 * t6202 * t6303 + 0.3e1 / 0.16e2 * t1678 * t1675 + 0.3e1 / 0.16e2 * t534 * t1692 * t1674 + t534 * t539 * t6312 / 0.16e2 + 0.3e1 / 0.16e2 * t6184 * t548 + 0.9e1 / 0.32e2 * t1681 * t1708 - 0.3e1 / 0.32e2 * t6320 * t523 - t519 * t5188 * t522 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t1309 * t1662;
  t6334 = t521 * t1613;
  t6359 = t420 * t5232;
  t6360 = t6359 * t191;
  t6367 = -0.3e1 / 0.16e2 * t1681 * t1663 - 0.3e1 / 0.32e2 * t519 * t520 * t6334 + 0.3e1 / 0.8e1 * t1678 * t1667 + 0.3e1 / 0.16e2 * t534 * t1613 * t75 * t547 - 0.3e1 / 0.16e2 * t1678 * t1671 - 0.3e1 / 0.16e2 * t534 * t528 * t438 * t445 - t534 * t191 * t1344 * t445 / 0.16e2 + 0.3e1 / 0.16e2 * t1678 * t1651 + 0.3e1 / 0.16e2 * t534 * t1666 * t1650 - 0.11e2 / 0.32e2 * t519 * t6246 * t6360 - 0.9e1 / 0.32e2 * t6024 - 0.3e1 / 0.16e2 * t6026 + 0.9e1 / 0.64e2 * t6028;
  t6382 = 0.9e1 / 0.32e2 * t6030 - 0.3e1 / 0.16e2 * t6033 + 0.3e1 / 0.16e2 * t6035 + 0.3e1 / 0.16e2 * t6037 - 0.3e1 / 0.32e2 * t6039 + 0.3e1 / 0.32e2 * t6041 + 0.3e1 / 0.16e2 * t6043 - 0.3e1 / 0.32e2 * t6046 - 0.3e1 / 0.16e2 * t6048 - 0.3e1 / 0.64e2 * t6052 - 0.3e1 / 0.64e2 * t6054 - 0.3e1 / 0.32e2 * t6056 + 0.3e1 / 0.16e2 * t6058 - 0.3e1 / 0.32e2 * t6061;
  t6399 = my_piecewise3(t72, -0.15e2 / 0.2e1 * t1339 * t37, 0);
  t6406 = 0.3e1 / 0.32e2 * t6063 + 0.9e1 / 0.64e2 * t6090 + 0.3e1 / 0.8e1 * t6092 - 0.9e1 / 0.32e2 * t6094 - 0.9e1 / 0.64e2 * t6098 - 0.3e1 / 0.64e2 * t5947 + 0.3e1 / 0.64e2 * t5952 - 0.3e1 / 0.64e2 * t5956 + 0.3e1 / 0.128e3 * t5965 - 0.3e1 / 0.16e2 * t1313 * t530 - 0.3e1 / 0.16e2 * t409 * t1615 - t156 * t157 * t6399 * t173 / 0.16e2 - 0.3e1 / 0.32e2 * t6127 - 0.3e1 / 0.32e2 * t6129;
  t6417 = t1309 * t450 * t2584;
  t6428 = t1638 * t1384;
  t6430 = t1360 * t438 * t168;
  t6434 = t535 * t75;
  t6440 = t545 * t170;
  t6444 = t520 * t420;
  t6445 = t2583 * t438;
  t6449 = -0.3e1 / 0.16e2 * t6131 - t5274 * t193 / 0.16e2 + 0.3e1 / 0.64e2 * t5980 + 0.3e1 / 0.64e2 * t5984 - t5830 - 0.3e1 / 0.16e2 * t534 * t1670 * t168 * t1361 - 0.9e1 / 0.32e2 * t519 * t6417 + 0.9e1 / 0.32e2 * t519 * t5161 * t1372 * t2584 + 0.3e1 / 0.4e1 * t534 * t1670 * t418 * t2372 - 0.9e1 / 0.16e2 * t534 * t6428 * t6430 + 0.9e1 / 0.16e2 * t534 * t6434 * t5172 - 0.9e1 / 0.16e2 * t534 * t6417 - 0.3e1 / 0.8e1 * t534 * t6440 * t6430 + 0.9e1 / 0.32e2 * t519 * t6444 * t6445;
  t6453 = my_piecewise3(t51, 0, t6192 + t6244 + t6287 + t6329 + t6367 + t6382 + t6406 + t6449);
  tv4rho3sigma11 = t3 * t6453 + 0.3e1 * t1716;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t6456 = t5493 * t573;
  t6458 = t1419 * t1779;
  t6460 = t563 * t261;
  t6464 = t1419 * t1740;
  t6466 = t1499 * t1740;
  t6468 = t1499 * t1744;
  t6474 = t1458 * t563;
  t6475 = t1469 * t6474;
  t6478 = t1516 * t563;
  t6482 = t5505 * t573;
  t6484 = t1419 * t1772;
  t6486 = t1726 * t263;
  t6490 = -0.3e1 / 0.64e2 * t6456 + 0.9e1 / 0.32e2 * t6458 + 0.9e1 / 0.16e2 * t484 * t6460 * t968 - 0.9e1 / 0.32e2 * t6464 - 0.9e1 / 0.64e2 * t6466 + 0.9e1 / 0.64e2 * t6468 - 0.5e1 / 0.32e2 * t1503 * t1740 + 0.5e1 / 0.32e2 * t1503 * t1744 - 0.9e1 / 0.32e2 * t469 * t6475 + 0.9e1 / 0.32e2 * t469 * t1515 * t6478 + 0.3e1 / 0.16e2 * t6482 + 0.3e1 / 0.16e2 * t6484 + 0.3e1 / 0.16e2 * t484 * t6486 * t491;
  t6497 = t1419 * t1776;
  t6502 = t199 * t932;
  t6508 = t5493 * t569;
  t6510 = t1735 * t5704;
  t6516 = t199 * t4327;
  t6524 = t1419 * t1791;
  t6526 = 0.3e1 / 0.16e2 * t5521 * t573 + 0.3e1 / 0.8e1 * t1415 * t1772 - 0.3e1 / 0.16e2 * t1415 * t1776 - 0.3e1 / 0.32e2 * t6497 - 0.3e1 / 0.16e2 * t484 * t6460 * t1031 - t484 * t6502 * t4311 / 0.16e2 + 0.9e1 / 0.16e2 * t1415 * t1779 + 0.3e1 / 0.64e2 * t6508 + 0.9e1 / 0.8e1 * t484 * t6510 - 0.25e2 / 0.16e2 * t484 * t6502 * t4323 + 0.15e2 / 0.16e2 * t484 * t6516 * t5740 - 0.9e1 / 0.16e2 * t484 * t6475 + 0.3e1 / 0.4e1 * t1415 * t1791 + 0.3e1 / 0.8e1 * t6524;
  t6533 = t1419 * t1736;
  t6535 = t563 * t943;
  t6542 = t6502 * t4277;
  t6563 = 0.3e1 / 0.4e1 * t484 * t6460 * t939 - 0.9e1 / 0.16e2 * t1415 * t1736 - 0.9e1 / 0.32e2 * t6533 - 0.9e1 / 0.16e2 * t484 * t6535 * t1526 + 0.11e2 / 0.16e2 * t484 * t6502 * t4343 - 0.3e1 / 0.2e1 * t484 * t6542 - 0.9e1 / 0.16e2 * t1415 * t1740 - 0.9e1 / 0.32e2 * t1493 * t1740 + 0.9e1 / 0.32e2 * t1493 * t1744 - 0.3e1 / 0.32e2 * t5685 * t559 - 0.3e1 / 0.32e2 * t1493 * t1747 - 0.3e1 / 0.16e2 * t1493 * t1751 - 0.3e1 / 0.16e2 * t1415 * t1795 - 0.3e1 / 0.16e2 * t484 * t563 * t283 * t290;
  t6573 = t5505 * t569;
  t6575 = t1419 * t1763;
  t6593 = t471 * t1726;
  t6597 = t1726 * t43;
  t6601 = t5493 * t577;
  t6603 = -t484 * t199 * t1015 * t290 / 0.16e2 + 0.3e1 / 0.16e2 * t1415 * t1798 + 0.3e1 / 0.16e2 * t484 * t1771 * t1487 - 0.3e1 / 0.16e2 * t6573 - 0.3e1 / 0.16e2 * t6575 - 0.3e1 / 0.16e2 * t484 * t1726 * t111 * t290 - 0.3e1 / 0.16e2 * t5521 * t569 - 0.3e1 / 0.8e1 * t1415 * t1763 - 0.3e1 / 0.32e2 * t1503 * t1751 - t469 * t4259 * t558 / 0.32e2 - 0.3e1 / 0.32e2 * t469 * t1048 * t1750 - 0.3e1 / 0.32e2 * t469 * t470 * t6593 + 0.3e1 / 0.16e2 * t484 * t6597 * t497 - 0.3e1 / 0.64e2 * t6601;
  t6606 = t5655 * t559;
  t6608 = t1419 * t1755;
  t6610 = t1499 * t1788;
  t6612 = t5659 * t559;
  t6614 = t1499 * t1747;
  t6616 = t1499 * t1751;
  t6635 = 0.3e1 / 0.128e3 * t6606 + 0.3e1 / 0.16e2 * t6608 + 0.9e1 / 0.64e2 * t6610 - 0.3e1 / 0.64e2 * t6612 - 0.3e1 / 0.64e2 * t6614 - 0.3e1 / 0.32e2 * t6616 - t5667 * t559 / 0.32e2 + t484 * t572 * t5670 / 0.16e2 + 0.3e1 / 0.16e2 * t1415 * t1801 + 0.3e1 / 0.16e2 * t484 * t1754 * t1475 + t484 * t576 * t5586 / 0.16e2 + 0.3e1 / 0.16e2 * t5521 * t577 + 0.3e1 / 0.8e1 * t1415 * t1755;
  t6640 = t572 * t5536;
  t6651 = t1470 * t563;
  t6660 = t5676 * t559;
  t6662 = t1419 * t1784;
  t6664 = t1419 * t1795;
  t6666 = t1419 * t1798;
  t6668 = t1419 * t1801;
  t6670 = 0.9e1 / 0.32e2 * t1493 * t1788 - 0.3e1 / 0.32e2 * t5681 * t559 + 0.11e2 / 0.16e2 * t484 * t6640 + 0.3e1 / 0.8e1 * t484 * t576 * t5484 + 0.3e1 / 0.8e1 * t484 * t6502 * t4378 + 0.5e1 / 0.32e2 * t1503 * t1788 + 0.9e1 / 0.32e2 * t469 * t1469 * t6651 - 0.3e1 / 0.8e1 * t484 * t1754 * t1464 - 0.3e1 / 0.8e1 * t1415 * t1784 - 0.3e1 / 0.32e2 * t6660 - 0.3e1 / 0.16e2 * t6662 - 0.3e1 / 0.32e2 * t6664 + 0.3e1 / 0.32e2 * t6666 + 0.3e1 / 0.32e2 * t6668;
  t6672 = t5505 * t577;
  t6674 = t5612 * t199;
  t6680 = t5730 * t199;
  t6688 = t5550 * t199;
  t6698 = 0.3e1 / 0.128e3 * t4286 * t201;
  t6699 = t1023 * t565;
  t6701 = t255 * t1728;
  t6706 = my_piecewise3(t39, -0.6e1 * t1432, 0);
  t6711 = 0.3e1 / 0.16e2 * t6672 - 0.11e2 / 0.32e2 * t469 * t5549 * t6674 + 0.11e2 / 0.16e2 * t469 * t6510 - 0.15e2 / 0.32e2 * t469 * t5729 * t6680 - 0.7e1 / 0.32e2 * t469 * t6542 + 0.9e1 / 0.16e2 * t469 * t6640 - 0.9e1 / 0.16e2 * t469 * t5603 * t6688 - t1503 * t1747 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t6502 * t4316 - t6698 - 0.3e1 / 0.16e2 * t6699 - 0.3e1 / 0.32e2 * t6701 - 0.3e1 / 0.16e2 * t246 * t1728 - t99 * t100 * t6706 * t116 / 0.16e2;
  t6716 = t4292 * t201;
  t6718 = t984 * t565;
  t6720 = t4289 * t201;
  t6737 = t2466 * t283;
  t6738 = t5783 * t6737;
  t6752 = -t4283 * t201 / 0.16e2 - 0.3e1 / 0.16e2 * t1020 * t565 + 0.3e1 / 0.64e2 * t6716 + 0.3e1 / 0.64e2 * t6718 - 0.3e1 / 0.32e2 * t6720 - 0.3e1 / 0.16e2 * t484 * t1794 * t111 * t1031 + 0.3e1 / 0.4e1 * t484 * t1794 * t263 * t2247 - 0.9e1 / 0.16e2 * t484 * t2475 * t5795 + 0.9e1 / 0.16e2 * t484 * t1794 * t43 * t2270 - 0.9e1 / 0.32e2 * t469 * t6738 - 0.9e1 / 0.16e2 * t484 * t6738 + 0.9e1 / 0.32e2 * t469 * t5804 * t6737 - 0.3e1 / 0.8e1 * t484 * t2461 * t5795 + 0.9e1 / 0.32e2 * t469 * t5799 * t6737;
  t6756 = my_piecewise3(t2, 0, t6490 + t6526 + t6563 + t6603 + t6635 + t6670 + t6711 + t6752);
  tv4rho3lapl0 = t3 * t6756 + 0.3e1 * t1816;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t6761 = t4781 * t209;
  t6763 = t4784 * t209;
  t6766 = 0.3e1 / 0.128e3 * t4787 * t209;
  t6768 = my_piecewise3(t51, 0, -t4778 * t209 / 0.16e2 - 0.3e1 / 0.32e2 * t6761 + 0.3e1 / 0.64e2 * t6763 - t6766);
  tv4rho3lapl1 = t3 * t6768 + 0.3e1 * t1826;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t6770 = 0.2e1 * t1849;
  t6776 = t5838 * t573 / 0.16e2;
  t6784 = t5838 * t569 / 0.16e2;
  t6801 = 0.3e1 / 0.32e2 * t1548 * t1744 + t5835 * t573 / 0.8e1 + t6776 + t1553 * t1772 / 0.8e1 - t1553 * t1776 / 0.16e2 - t5835 * t569 / 0.8e1 - t6784 - t1553 * t1763 / 0.8e1 + t1553 * t1791 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t1736 - 0.3e1 / 0.32e2 * t1548 * t1740 - 0.3e1 / 0.16e2 * t1553 * t1740 - t6456 / 0.32e2 + 0.3e1 / 0.32e2 * t6458 + t1553 * t1801 / 0.16e2 - t1548 * t1751 / 0.16e2;
  t6813 = t5838 * t577 / 0.16e2;
  t6815 = t5870 * t559 / 0.32e2;
  t6830 = t1553 * t1755 / 0.8e1 - t1553 * t1795 / 0.16e2 + t1553 * t1798 / 0.16e2 + t5835 * t577 / 0.8e1 - t5886 * t559 / 0.16e2 + t6813 - t6815 - t5873 * t559 / 0.32e2 - t1548 * t1747 / 0.32e2 - t1553 * t1784 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t1788 + 0.3e1 / 0.16e2 * t1553 * t1779 - 0.3e1 / 0.32e2 * t6464 - 0.3e1 / 0.64e2 * t6466 + 0.3e1 / 0.64e2 * t6468 + t6482 / 0.16e2;
  t6848 = t6484 / 0.16e2 - t6497 / 0.32e2 + t6508 / 0.32e2 + t6524 / 0.8e1 - 0.3e1 / 0.32e2 * t6533 - t6573 / 0.16e2 - t6575 / 0.16e2 - t6601 / 0.32e2 + t6606 / 0.64e2 + t6608 / 0.16e2 + 0.3e1 / 0.64e2 * t6610 - t6612 / 0.64e2 - t6614 / 0.64e2 - t6616 / 0.32e2 - t6660 / 0.32e2 - t6662 / 0.16e2;
  t6853 = t4653 * t201;
  t6860 = t1127 * t565 / 0.16e2;
  t6869 = t4650 * t201 / 0.16e2;
  t6870 = -t6664 / 0.32e2 + t6666 / 0.32e2 + t6668 / 0.32e2 + t6672 / 0.16e2 + t6853 / 0.64e2 - t4647 * t201 / 0.16e2 - t1124 * t565 / 0.8e1 - t6860 - t345 * t1728 / 0.16e2 - t6698 - t6699 / 0.16e2 - t6701 / 0.32e2 + t6716 / 0.32e2 + t6718 / 0.32e2 - t6720 / 0.32e2 - t6869;
  t6873 = my_piecewise3(t2, 0, t6801 + t6830 + t6848 + t6870);
  tv4rho3lapl2 = t3 * t6873 + t1816 + t6770;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t6875 = 0.2e1 * t1877;
  t6881 = t1167 * t604 / 0.16e2;
  t6882 = t1170 * t604;
  t6887 = t4900 * t209 / 0.16e2;
  t6888 = t4893 * t209;
  t6892 = t5946 * t616;
  t6895 = t5949 * t608 / 0.16e2;
  t6897 = t5946 * t608;
  t6900 = t5949 * t612 / 0.16e2;
  t6901 = t5946 * t612;
  t6904 = t5949 * t616 / 0.16e2;
  t6906 = t5960 * t598 / 0.32e2;
  t6907 = t5964 * t598;
  t6915 = t6897 / 0.64e2 + t6900 - t6901 / 0.64e2 + t6904 - t6906 + t6907 / 0.128e3 - t6761 / 0.32e2 + t6763 / 0.32e2 - t6766 - t4874 * t209 / 0.16e2 - t1164 * t604 / 0.16e2;
  t6917 = my_piecewise3(t51, 0, t5967 * t612 / 0.16e2 + t5967 * t616 / 0.16e2 - t6881 + t6882 / 0.64e2 - t5967 * t608 / 0.16e2 - t6887 + t6888 / 0.64e2 - t5975 * t598 / 0.32e2 - t6892 / 0.64e2 - t6895 + t6915);
  tv4rho3lapl3 = t3 * t6917 + t1826 + t6875;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t6921 = t4805 * t201;
  t6941 = -t6860 - t6784 + t6776 + t6813 + t6716 / 0.64e2 - t6698 + t6606 / 0.128e3 + t6718 / 0.64e2 + t6508 / 0.64e2 - t6456 / 0.64e2 - t6601 / 0.64e2;
  t6943 = my_piecewise3(t2, 0, -t4802 * t201 / 0.16e2 - t6921 / 0.32e2 - t6000 * t559 / 0.32e2 - t1196 * t565 / 0.16e2 - t6005 * t569 / 0.16e2 + t6005 * t573 / 0.16e2 + t6005 * t577 / 0.16e2 - t6869 + t6853 / 0.32e2 - t6815 + t6941);
  tv4rho3lapl4 = t3 * t6943 + t1884 + t6770;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t6945 = t6032 * t608;
  t6947 = t1589 * t1922;
  t6949 = t6045 * t598;
  t6951 = t6051 * t598;
  t6953 = t1578 * t1930;
  t6955 = t1589 * t1916;
  t6957 = t1589 * t1919;
  t6959 = t1589 * t1951;
  t6961 = t1578 * t1955;
  t6963 = t1589 * t1958;
  t6965 = t1589 * t1902;
  t6967 = t6032 * t612;
  t6969 = t1589 * t1908;
  t6971 = t1589 * t1912;
  t6973 = t1589 * t1948;
  t6975 = t1578 * t1934;
  t6977 = -t6945 / 0.16e2 + t6947 / 0.32e2 - t6949 / 0.32e2 - t6951 / 0.64e2 - t6953 / 0.64e2 - t6955 / 0.32e2 + t6957 / 0.32e2 - t6959 / 0.16e2 + 0.3e1 / 0.64e2 * t6961 + 0.3e1 / 0.32e2 * t6963 - t6965 / 0.16e2 + t6967 / 0.16e2 + t6969 / 0.16e2 - t6971 / 0.32e2 - 0.3e1 / 0.32e2 * t6973 - t6975 / 0.32e2;
  t6978 = t1589 * t1938;
  t6980 = t6032 * t616;
  t7008 = t1589 * t1965;
  t7010 = t6978 / 0.16e2 + t6980 / 0.16e2 + t6073 * t612 / 0.8e1 + t1585 * t1908 / 0.8e1 - t1585 * t1912 / 0.16e2 - t6073 * t608 / 0.8e1 - t1574 * t1934 / 0.16e2 + t1585 * t1938 / 0.8e1 + t6073 * t616 / 0.8e1 + t1585 * t1922 / 0.16e2 - t6076 * t598 / 0.16e2 - t6079 * t598 / 0.32e2 - t1574 * t1930 / 0.32e2 - t1585 * t1916 / 0.16e2 + t1585 * t1919 / 0.16e2 - 0.3e1 / 0.32e2 * t7008;
  t7012 = t1578 * t1948;
  t7014 = t1578 * t1971;
  t7016 = t1589 * t1961;
  t7038 = -0.3e1 / 0.64e2 * t7012 + 0.3e1 / 0.64e2 * t7014 + t7016 / 0.8e1 + t1585 * t1961 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t1965 - 0.3e1 / 0.32e2 * t1574 * t1948 + 0.3e1 / 0.32e2 * t1574 * t1971 - 0.3e1 / 0.16e2 * t1585 * t1948 - t1585 * t1951 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t1955 + 0.3e1 / 0.16e2 * t1585 * t1958 - t1585 * t1902 / 0.8e1 - t6892 / 0.32e2 - t6895 + t6897 / 0.32e2 + t6900;
  t7047 = t5050 * t209;
  t7049 = t1227 * t604;
  t7051 = t370 * t1894;
  t7056 = -t6901 / 0.32e2 + t6904 - t6906 + t6907 / 0.64e2 - t5077 * t209 / 0.16e2 - t1224 * t604 / 0.8e1 - t367 * t1894 / 0.16e2 - t7047 / 0.32e2 - t7049 / 0.16e2 - t7051 / 0.32e2 - t6881 + t6882 / 0.32e2 - t6887 + t6888 / 0.32e2 + t6763 / 0.64e2 - t6766;
  t7059 = my_piecewise3(t51, 0, t6977 + t7010 + t7038 + t7056);
  tv4rho3lapl5 = t3 * t7059 + t1976 + t6875;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t7067 = my_piecewise3(t2, 0, -t4984 * t201 / 0.16e2 - 0.3e1 / 0.32e2 * t6921 + 0.3e1 / 0.64e2 * t6853 - t6698);
  tv4rho3lapl6 = t3 * t7067 + 0.3e1 * t1884;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t7070 = t611 * t6238;
  t7073 = t6203 * t1356;
  t7074 = t1964 * t7073;
  t7085 = t1623 * t602;
  t7086 = t1622 * t7085;
  t7089 = t1629 * t602;
  t7093 = t602 * t416;
  t7103 = t1892 * t418;
  t7107 = -0.3e1 / 0.2e1 * t534 * t7070 + 0.9e1 / 0.8e1 * t534 * t7074 - 0.9e1 / 0.32e2 * t1681 * t1948 + 0.9e1 / 0.32e2 * t1681 * t1971 - 0.5e1 / 0.32e2 * t1655 * t1948 + 0.5e1 / 0.32e2 * t1655 * t1971 - 0.9e1 / 0.32e2 * t519 * t7086 + 0.9e1 / 0.32e2 * t519 * t1628 * t7089 + 0.9e1 / 0.16e2 * t534 * t7093 * t1392 + 0.9e1 / 0.16e2 * t1678 * t1958 + 0.3e1 / 0.16e2 * t6184 * t612 + 0.3e1 / 0.8e1 * t1678 * t1908 + 0.3e1 / 0.16e2 * t534 * t7103 * t541;
  t7113 = t207 * t1356;
  t7128 = t6247 * t207;
  t7129 = t6246 * t7128;
  t7135 = t207 * t5247;
  t7148 = -0.3e1 / 0.16e2 * t1678 * t1912 - 0.3e1 / 0.16e2 * t534 * t7093 * t1361 - t534 * t7113 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t7113 * t5298 - 0.3e1 / 0.16e2 * t534 * t1892 * t168 * t445 - 0.3e1 / 0.16e2 * t6184 * t608 - 0.3e1 / 0.8e1 * t1678 * t1902 + 0.9e1 / 0.16e2 * t519 * t7129 - 0.25e2 / 0.16e2 * t534 * t7113 * t5256 + 0.15e2 / 0.16e2 * t534 * t7135 * t6219 - 0.9e1 / 0.16e2 * t534 * t7086 - 0.9e1 / 0.16e2 * t1678 * t1948 + 0.3e1 / 0.4e1 * t1678 * t1961 + 0.3e1 / 0.4e1 * t534 * t7093 * t1379;
  t7152 = t602 * t1370;
  t7169 = t521 * t1892;
  t7191 = -0.9e1 / 0.16e2 * t1678 * t1965 - 0.9e1 / 0.16e2 * t534 * t7152 * t1640 + 0.11e2 / 0.16e2 * t534 * t7113 * t5238 - t1655 * t1930 / 0.16e2 - 0.3e1 / 0.32e2 * t1655 * t1934 - t519 * t5188 * t597 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t1309 * t1933 - 0.3e1 / 0.32e2 * t519 * t520 * t7169 - 0.3e1 / 0.16e2 * t1678 * t1916 - 0.3e1 / 0.16e2 * t534 * t602 * t438 * t445 - t534 * t207 * t1344 * t445 / 0.16e2 + 0.3e1 / 0.16e2 * t1678 * t1919 + 0.3e1 / 0.16e2 * t534 * t1907 * t1674 + t534 * t611 * t6312 / 0.16e2;
  t7214 = t1706 * t602;
  t7227 = 0.3e1 / 0.16e2 * t1678 * t1922 + 0.3e1 / 0.16e2 * t534 * t1937 * t1650 + t534 * t615 * t6257 / 0.16e2 - 0.3e1 / 0.32e2 * t6320 * t598 - 0.3e1 / 0.32e2 * t6261 * t598 - 0.3e1 / 0.32e2 * t1681 * t1930 + 0.3e1 / 0.8e1 * t534 * t7113 * t5324 + 0.11e2 / 0.16e2 * t534 * t7129 + 0.3e1 / 0.8e1 * t534 * t615 * t6289 + 0.9e1 / 0.32e2 * t519 * t1622 * t7214 - 0.3e1 / 0.8e1 * t534 * t1937 * t1702 - 0.3e1 / 0.8e1 * t1678 * t1951 + 0.9e1 / 0.32e2 * t1681 * t1955 + 0.5e1 / 0.32e2 * t1655 * t1955;
  t7232 = t6209 * t207;
  t7236 = t6359 * t207;
  t7242 = t6237 * t207;
  t7248 = t1892 * t75;
  t7261 = 0.11e2 / 0.16e2 * t519 * t7074 - 0.15e2 / 0.32e2 * t519 * t6208 * t7232 - 0.11e2 / 0.32e2 * t519 * t6246 * t7236 - 0.7e1 / 0.32e2 * t519 * t7070 - 0.9e1 / 0.16e2 * t519 * t6202 * t7242 + 0.3e1 / 0.8e1 * t1678 * t1938 + 0.3e1 / 0.16e2 * t534 * t7248 * t547 + 0.3e1 / 0.16e2 * t6184 * t616 - 0.3e1 / 0.16e2 * t1681 * t1934 - t6265 * t598 / 0.32e2 - 0.3e1 / 0.16e2 * t6945 + 0.3e1 / 0.32e2 * t6947 - 0.3e1 / 0.32e2 * t6949;
  t7276 = -0.3e1 / 0.64e2 * t6951 - 0.3e1 / 0.64e2 * t6953 - 0.3e1 / 0.32e2 * t6955 + 0.3e1 / 0.32e2 * t6957 - 0.3e1 / 0.16e2 * t6959 + 0.9e1 / 0.64e2 * t6961 + 0.9e1 / 0.32e2 * t6963 - 0.3e1 / 0.16e2 * t6965 + 0.3e1 / 0.16e2 * t6967 + 0.3e1 / 0.16e2 * t6969 - 0.3e1 / 0.32e2 * t6971 - 0.9e1 / 0.32e2 * t6973 - 0.3e1 / 0.32e2 * t6975 + 0.3e1 / 0.16e2 * t6978;
  t7298 = t168 * t1370;
  t7299 = t7298 * t1372;
  t7300 = t2569 * t438;
  t7307 = 0.3e1 / 0.16e2 * t6980 - 0.9e1 / 0.32e2 * t7008 - 0.9e1 / 0.64e2 * t7012 + 0.9e1 / 0.64e2 * t7014 + 0.3e1 / 0.8e1 * t7016 - 0.3e1 / 0.64e2 * t6892 + 0.3e1 / 0.64e2 * t6897 - 0.3e1 / 0.64e2 * t6901 + 0.3e1 / 0.128e3 * t6907 + 0.3e1 / 0.4e1 * t534 * t1915 * t418 * t2372 - 0.9e1 / 0.16e2 * t534 * t2582 * t6430 - 0.3e1 / 0.16e2 * t534 * t1915 * t168 * t1361 + 0.9e1 / 0.32e2 * t519 * t7299 * t7300 - 0.3e1 / 0.8e1 * t534 * t2594 * t6430;
  t7315 = t520 * t450;
  t7316 = t7315 * t7300;
  t7322 = my_piecewise3(t72, -0.6e1 * t1611, 0);
  t7338 = 0.9e1 / 0.32e2 * t519 * t6444 * t7300 + 0.9e1 / 0.16e2 * t534 * t1915 * t75 * t2397 - 0.9e1 / 0.32e2 * t519 * t7316 - 0.9e1 / 0.16e2 * t534 * t7316 - t156 * t157 * t7322 * t173 / 0.16e2 - t5274 * t209 / 0.16e2 - 0.3e1 / 0.16e2 * t1313 * t604 - 0.3e1 / 0.16e2 * t409 * t1894 - 0.3e1 / 0.32e2 * t7047 - 0.3e1 / 0.16e2 * t7049 - 0.3e1 / 0.32e2 * t7051 + 0.3e1 / 0.64e2 * t6882 + 0.3e1 / 0.64e2 * t6888 - t6766;
  t7342 = my_piecewise3(t51, 0, t7107 + t7148 + t7191 + t7227 + t7261 + t7276 + t7307 + t7338);
  tv4rho3lapl7 = t3 * t7342 + 0.3e1 * t1976;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t7345 = t1419 * t1986;
  t7347 = t5493 * t641;
  t7349 = t1419 * t1983;
  t7355 = t1419 * t2051;
  t7357 = t2065 * t263;
  t7363 = t1419 * t1980;
  t7365 = t631 * t261;
  t7369 = t213 * t932;
  t7376 = t5505 * t641;
  t7378 = -0.9e1 / 0.32e2 * t7345 - 0.3e1 / 0.64e2 * t7347 + 0.9e1 / 0.32e2 * t7349 + 0.3e1 / 0.16e2 * t5521 * t641 + 0.3e1 / 0.8e1 * t1415 * t2051 + 0.3e1 / 0.16e2 * t7355 + 0.3e1 / 0.16e2 * t484 * t7357 * t491 - 0.3e1 / 0.16e2 * t1415 * t1980 - 0.3e1 / 0.32e2 * t7363 - 0.3e1 / 0.16e2 * t484 * t7365 * t1031 - t484 * t7369 * t4311 / 0.16e2 + 0.9e1 / 0.16e2 * t484 * t7365 * t968 + 0.3e1 / 0.16e2 * t7376;
  t7384 = t7369 * t4277;
  t7387 = t2005 * t5704;
  t7392 = t5730 * t213;
  t7399 = t213 * t4327;
  t7403 = t1499 * t1986;
  t7405 = t1499 * t1999;
  t7413 = t1419 * t2002;
  t7415 = 0.9e1 / 0.16e2 * t1415 * t1983 + 0.11e2 / 0.16e2 * t484 * t7369 * t4343 - 0.3e1 / 0.2e1 * t484 * t7384 + 0.9e1 / 0.8e1 * t484 * t7387 + 0.11e2 / 0.16e2 * t469 * t7387 - 0.15e2 / 0.32e2 * t469 * t5729 * t7392 - 0.25e2 / 0.16e2 * t484 * t7369 * t4323 + 0.15e2 / 0.16e2 * t484 * t7399 * t5740 - 0.9e1 / 0.64e2 * t7403 + 0.9e1 / 0.64e2 * t7405 - 0.5e1 / 0.32e2 * t1503 * t1986 + 0.5e1 / 0.32e2 * t1503 * t1999 + 0.3e1 / 0.4e1 * t1415 * t2002 + 0.3e1 / 0.8e1 * t7413;
  t7422 = t1419 * t2006;
  t7424 = t1458 * t631;
  t7425 = t1469 * t7424;
  t7428 = t1516 * t631;
  t7440 = t1419 * t1989;
  t7442 = t1419 * t2070;
  t7444 = t1499 * t2010;
  t7446 = t1470 * t631;
  t7450 = t1419 * t2014;
  t7452 = 0.3e1 / 0.4e1 * t484 * t7365 * t939 - 0.9e1 / 0.16e2 * t1415 * t2006 - 0.9e1 / 0.32e2 * t7422 - 0.9e1 / 0.32e2 * t469 * t7425 + 0.9e1 / 0.32e2 * t469 * t1515 * t7428 - 0.9e1 / 0.16e2 * t484 * t7425 - 0.9e1 / 0.16e2 * t1415 * t1986 - 0.9e1 / 0.32e2 * t1493 * t1986 + 0.9e1 / 0.32e2 * t1493 * t1999 - 0.3e1 / 0.16e2 * t7440 + 0.3e1 / 0.32e2 * t7442 - 0.3e1 / 0.32e2 * t7444 + 0.9e1 / 0.32e2 * t469 * t1469 * t7446 + 0.3e1 / 0.16e2 * t7450;
  t7456 = t1419 * t2018;
  t7458 = t5493 * t637;
  t7464 = t1419 * t2043;
  t7470 = t5505 * t637;
  t7472 = t631 * t943;
  t7482 = t5505 * t645;
  t7484 = t5676 * t627;
  t7488 = -0.3e1 / 0.8e1 * t484 * t2013 * t1464 - 0.3e1 / 0.32e2 * t7456 + 0.3e1 / 0.64e2 * t7458 - 0.3e1 / 0.16e2 * t5521 * t637 - 0.3e1 / 0.8e1 * t1415 * t2043 - 0.3e1 / 0.16e2 * t7464 - 0.3e1 / 0.16e2 * t484 * t2065 * t111 * t290 - 0.3e1 / 0.16e2 * t7470 - 0.9e1 / 0.16e2 * t484 * t7472 * t1526 + 0.3e1 / 0.16e2 * t484 * t2050 * t1487 + t484 * t640 * t5670 / 0.16e2 + 0.3e1 / 0.16e2 * t7482 - 0.3e1 / 0.32e2 * t7484 + 0.3e1 / 0.16e2 * t1415 * t2070;
  t7504 = t471 * t2065;
  t7510 = t2065 * t43;
  t7517 = t640 * t5536;
  t7528 = 0.3e1 / 0.16e2 * t484 * t2013 * t1475 + t484 * t644 * t5586 / 0.16e2 - 0.3e1 / 0.16e2 * t1493 * t2010 - 0.3e1 / 0.32e2 * t1503 * t2010 - 0.3e1 / 0.32e2 * t469 * t1048 * t2009 - 0.3e1 / 0.32e2 * t469 * t470 * t7504 + 0.3e1 / 0.8e1 * t1415 * t2014 + 0.3e1 / 0.16e2 * t484 * t7510 * t497 - 0.11e2 / 0.16e2 * t484 * t7369 * t4316 + 0.11e2 / 0.16e2 * t484 * t7517 + 0.3e1 / 0.8e1 * t484 * t644 * t5484 + 0.3e1 / 0.8e1 * t484 * t7369 * t4378 + 0.5e1 / 0.32e2 * t1503 * t1993;
  t7529 = t1419 * t2021;
  t7535 = t5550 * t213;
  t7539 = t5612 * t213;
  t7543 = t1499 * t1993;
  t7545 = t5659 * t627;
  t7547 = t1499 * t2035;
  t7562 = 0.3e1 / 0.32e2 * t7529 - 0.3e1 / 0.8e1 * t1415 * t1989 + 0.9e1 / 0.16e2 * t469 * t7517 - 0.9e1 / 0.16e2 * t469 * t5603 * t7535 - 0.11e2 / 0.32e2 * t469 * t5549 * t7539 + 0.9e1 / 0.64e2 * t7543 - 0.3e1 / 0.64e2 * t7545 - 0.3e1 / 0.64e2 * t7547 - t5667 * t627 / 0.32e2 - t1503 * t2035 / 0.16e2 - t469 * t4259 * t626 / 0.32e2 + 0.3e1 / 0.16e2 * t5521 * t645 + 0.9e1 / 0.32e2 * t1493 * t1993 - 0.3e1 / 0.32e2 * t5681 * t627;
  t7568 = t5493 * t645;
  t7570 = t5655 * t627;
  t7586 = t636 * t43;
  t7594 = t2655 * t5795;
  t7604 = -0.3e1 / 0.32e2 * t5685 * t627 - 0.3e1 / 0.32e2 * t1493 * t2035 - 0.3e1 / 0.64e2 * t7568 + 0.3e1 / 0.128e3 * t7570 - 0.3e1 / 0.16e2 * t1415 * t2018 - 0.3e1 / 0.16e2 * t484 * t631 * t283 * t290 - t484 * t213 * t1015 * t290 / 0.16e2 + 0.3e1 / 0.16e2 * t1415 * t2021 - 0.7e1 / 0.32e2 * t469 * t7384 + 0.9e1 / 0.16e2 * t484 * t7586 * t4243 - 0.3e1 / 0.16e2 * t484 * t2017 * t111 * t1031 - 0.9e1 / 0.16e2 * t484 * t7594 + 0.3e1 / 0.4e1 * t484 * t2017 * t263 * t2247 - 0.9e1 / 0.16e2 * t484 * t2668 * t5795;
  t7605 = t2663 * t283;
  t7618 = 0.3e1 / 0.128e3 * t4286 * t215;
  t7619 = t4292 * t215;
  t7623 = t255 * t2067;
  t7626 = my_piecewise3(t39, 0.24e2 * t1432, 0);
  t7631 = t4289 * t215;
  t7633 = t1023 * t633;
  t7635 = t984 * t633;
  t7641 = 0.9e1 / 0.32e2 * t469 * t5804 * t7605 - 0.3e1 / 0.8e1 * t484 * t2659 * t5795 + 0.9e1 / 0.32e2 * t469 * t5799 * t7605 - 0.9e1 / 0.32e2 * t469 * t7594 - t7618 + 0.3e1 / 0.64e2 * t7619 - 0.3e1 / 0.16e2 * t246 * t2067 - 0.3e1 / 0.32e2 * t7623 - t99 * t100 * t7626 * t116 / 0.16e2 - 0.3e1 / 0.32e2 * t7631 - 0.3e1 / 0.16e2 * t7633 + 0.3e1 / 0.64e2 * t7635 - t4283 * t215 / 0.16e2 - 0.3e1 / 0.16e2 * t1020 * t633;
  t7645 = my_piecewise3(t2, 0, t7378 + t7415 + t7452 + t7488 + t7528 + t7562 + t7604 + t7641);
  tv4rho3tau0 = t3 * t7645 + 0.3e1 * t2075;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t7650 = t4781 * t221;
  t7652 = t4784 * t221;
  t7655 = 0.3e1 / 0.128e3 * t4787 * t221;
  t7657 = my_piecewise3(t51, 0, -t4778 * t221 / 0.16e2 - 0.3e1 / 0.32e2 * t7650 + 0.3e1 / 0.64e2 * t7652 - t7655);
  tv4rho3tau1 = t3 * t7657 + 0.3e1 * t2085;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t7659 = 0.2e1 * t2108;
  t7671 = t5838 * t641 / 0.16e2;
  t7681 = t5838 * t637 / 0.16e2;
  t7692 = -0.3e1 / 0.32e2 * t1548 * t1986 + 0.3e1 / 0.32e2 * t1548 * t1999 + t1553 * t2002 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2006 + t5835 * t641 / 0.8e1 + t7671 + t1553 * t2051 / 0.8e1 - t1553 * t1980 / 0.16e2 - t1553 * t2043 / 0.8e1 - t5835 * t637 / 0.8e1 - t7681 - t5873 * t627 / 0.32e2 - t1548 * t2035 / 0.32e2 - t1548 * t2010 / 0.16e2 + t1553 * t2014 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t1993;
  t7710 = t5838 * t645 / 0.16e2;
  t7712 = t5870 * t627 / 0.32e2;
  t7719 = 0.3e1 / 0.16e2 * t1553 * t1983 - 0.3e1 / 0.16e2 * t1553 * t1986 - t1553 * t1989 / 0.8e1 - t1553 * t2018 / 0.16e2 + t1553 * t2021 / 0.16e2 + t1553 * t2070 / 0.16e2 + t5835 * t645 / 0.8e1 - t5886 * t627 / 0.16e2 + t7710 - t7712 - 0.3e1 / 0.32e2 * t7345 - t7347 / 0.32e2 + 0.3e1 / 0.32e2 * t7349 + t7355 / 0.16e2 - t7363 / 0.32e2 + t7376 / 0.16e2;
  t7737 = -0.3e1 / 0.64e2 * t7403 + 0.3e1 / 0.64e2 * t7405 + t7413 / 0.8e1 - 0.3e1 / 0.32e2 * t7422 - t7440 / 0.16e2 + t7442 / 0.32e2 - t7444 / 0.32e2 + t7450 / 0.16e2 - t7456 / 0.32e2 + t7458 / 0.32e2 - t7464 / 0.16e2 - t7470 / 0.16e2 + t7482 / 0.16e2 - t7484 / 0.32e2 + t7529 / 0.32e2 + 0.3e1 / 0.64e2 * t7543;
  t7752 = t4650 * t215 / 0.16e2;
  t7753 = t4653 * t215;
  t7758 = t1127 * t633 / 0.16e2;
  t7759 = -t7545 / 0.64e2 - t7547 / 0.64e2 - t7568 / 0.32e2 + t7570 / 0.64e2 - t345 * t2067 / 0.16e2 - t4647 * t215 / 0.16e2 - t7618 + t7619 / 0.32e2 - t7623 / 0.32e2 - t7631 / 0.32e2 - t7633 / 0.16e2 + t7635 / 0.32e2 - t7752 + t7753 / 0.64e2 - t1124 * t633 / 0.8e1 - t7758;
  t7762 = my_piecewise3(t2, 0, t7692 + t7719 + t7737 + t7759);
  tv4rho3tau2 = t3 * t7762 + t2075 + t7659;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t7764 = 0.2e1 * t2136;
  t7774 = t1167 * t672 / 0.16e2;
  t7775 = t1170 * t672;
  t7779 = t4893 * t221;
  t7784 = t4900 * t221 / 0.16e2;
  t7786 = t5946 * t676;
  t7789 = t5949 * t680 / 0.16e2;
  t7790 = t5946 * t680;
  t7793 = t5949 * t684 / 0.16e2;
  t7794 = t5946 * t684;
  t7797 = t5960 * t666 / 0.32e2;
  t7798 = t5964 * t666;
  t7801 = t5949 * t676 / 0.16e2;
  t7804 = t7786 / 0.64e2 + t7789 - t7790 / 0.64e2 + t7793 - t7794 / 0.64e2 - t7797 + t7798 / 0.128e3 - t7801 - t7650 / 0.32e2 + t7652 / 0.32e2 - t7655;
  t7806 = my_piecewise3(t51, 0, -t1164 * t672 / 0.16e2 - t4874 * t221 / 0.16e2 + t5967 * t680 / 0.16e2 + t5967 * t684 / 0.16e2 - t7774 + t7775 / 0.64e2 - t5967 * t676 / 0.16e2 + t7779 / 0.64e2 - t5975 * t666 / 0.32e2 - t7784 + t7804);
  tv4rho3tau3 = t3 * t7806 + t2085 + t7764;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t7810 = t4805 * t215;
  t7830 = -t7758 - t7681 + t7671 + t7710 + t7619 / 0.64e2 - t7618 + t7570 / 0.128e3 + t7635 / 0.64e2 + t7458 / 0.64e2 - t7347 / 0.64e2 - t7568 / 0.64e2;
  t7832 = my_piecewise3(t2, 0, -t4802 * t215 / 0.16e2 - t7810 / 0.32e2 - t6000 * t627 / 0.32e2 - t1196 * t633 / 0.16e2 - t6005 * t637 / 0.16e2 + t6005 * t641 / 0.16e2 + t6005 * t645 / 0.16e2 - t7752 + t7753 / 0.32e2 - t7712 + t7830);
  tv4rho3tau4 = t3 * t7832 + t2143 + t7659;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t7834 = t6032 * t676;
  t7836 = t1589 * t2217;
  t7838 = t1589 * t2169;
  t7840 = t6032 * t684;
  t7842 = t6045 * t666;
  t7844 = t6051 * t666;
  t7846 = t1589 * t2209;
  t7848 = t1589 * t2213;
  t7854 = t1589 * t2162;
  t7856 = t1589 * t2166;
  t7858 = t1578 * t2155;
  t7860 = t1578 * t2159;
  t7862 = t1589 * t2203;
  t7864 = t1578 * t2147;
  t7866 = -t7834 / 0.16e2 - t7836 / 0.32e2 + t7838 / 0.32e2 + t7840 / 0.16e2 - t7842 / 0.32e2 - t7844 / 0.64e2 + t7846 / 0.32e2 + t7848 / 0.16e2 + t1585 * t2213 / 0.8e1 - t1585 * t2217 / 0.16e2 + t7854 / 0.8e1 - 0.3e1 / 0.32e2 * t7856 - 0.3e1 / 0.64e2 * t7858 + 0.3e1 / 0.64e2 * t7860 - t7862 / 0.16e2 + 0.3e1 / 0.64e2 * t7864;
  t7867 = t1589 * t2151;
  t7869 = t1589 * t2188;
  t7871 = t6032 * t680;
  t7873 = t1589 * t2194;
  t7875 = t1589 * t2198;
  t7877 = t1589 * t2155;
  t7879 = t1578 * t2178;
  t7881 = t1578 * t2182;
  t7899 = 0.3e1 / 0.32e2 * t7867 - t7869 / 0.16e2 + t7871 / 0.16e2 + t7873 / 0.16e2 - t7875 / 0.32e2 - 0.3e1 / 0.32e2 * t7877 - t7879 / 0.64e2 - t7881 / 0.32e2 + 0.3e1 / 0.16e2 * t1585 * t2151 + t6073 * t680 / 0.8e1 + t1585 * t2194 / 0.8e1 - t1585 * t2198 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t2155 - t6073 * t676 / 0.8e1 - t1585 * t2188 / 0.8e1 - t1574 * t2178 / 0.32e2;
  t7927 = -t1574 * t2182 / 0.16e2 + t1585 * t2169 / 0.16e2 + t6073 * t684 / 0.8e1 - t6076 * t666 / 0.16e2 - t6079 * t666 / 0.32e2 + t1585 * t2209 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t2159 + t1585 * t2162 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2166 - 0.3e1 / 0.32e2 * t1574 * t2155 - t1585 * t2203 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t2147 - t7801 + t7786 / 0.32e2 + t7789 - t7790 / 0.32e2;
  t7936 = t370 * t2230;
  t7938 = t5050 * t221;
  t7940 = t1227 * t672;
  t7945 = t7793 - t7794 / 0.32e2 - t7797 + t7798 / 0.64e2 - t1224 * t672 / 0.8e1 - t367 * t2230 / 0.16e2 - t5077 * t221 / 0.16e2 - t7936 / 0.32e2 - t7938 / 0.32e2 - t7940 / 0.16e2 - t7774 + t7775 / 0.32e2 + t7779 / 0.32e2 - t7784 + t7652 / 0.64e2 - t7655;
  t7948 = my_piecewise3(t51, 0, t7866 + t7899 + t7927 + t7945);
  tv4rho3tau5 = t3 * t7948 + t2235 + t7764;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t7956 = my_piecewise3(t2, 0, -t4984 * t215 / 0.16e2 - 0.3e1 / 0.32e2 * t7810 + 0.3e1 / 0.64e2 * t7753 - t7618);
  tv4rho3tau6 = t3 * t7956 + 0.3e1 * t2143;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t7965 = t670 * t416;
  t7969 = t219 * t1356;
  t7989 = t2228 * t418;
  t7994 = t679 * t6247 * t1356;
  t7997 = 0.3e1 / 0.16e2 * t6184 * t680 + 0.3e1 / 0.8e1 * t1678 * t2194 - 0.3e1 / 0.16e2 * t1678 * t2198 - 0.3e1 / 0.16e2 * t534 * t7965 * t1361 - t534 * t7969 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t7969 * t5298 - 0.3e1 / 0.16e2 * t534 * t2228 * t168 * t445 - 0.3e1 / 0.16e2 * t6184 * t676 - 0.3e1 / 0.8e1 * t1678 * t2188 + 0.9e1 / 0.16e2 * t534 * t7965 * t1392 + 0.9e1 / 0.16e2 * t1678 * t2151 + 0.3e1 / 0.16e2 * t534 * t7989 * t541 + 0.11e2 / 0.16e2 * t534 * t7994;
  t8008 = t670 * t1370;
  t8015 = t679 * t6238;
  t8018 = t2165 * t7073;
  t8029 = t1623 * t670;
  t8030 = t1622 * t8029;
  t8033 = t1629 * t670;
  t8037 = 0.3e1 / 0.8e1 * t534 * t683 * t6289 + 0.5e1 / 0.32e2 * t1655 * t2147 - 0.3e1 / 0.8e1 * t1678 * t2203 - 0.3e1 / 0.8e1 * t534 * t2212 * t1702 - 0.9e1 / 0.16e2 * t534 * t8008 * t1640 + 0.11e2 / 0.16e2 * t534 * t7969 * t5238 - 0.3e1 / 0.2e1 * t534 * t8015 + 0.9e1 / 0.8e1 * t534 * t8018 + 0.9e1 / 0.16e2 * t519 * t7994 + 0.11e2 / 0.16e2 * t519 * t8018 - 0.5e1 / 0.32e2 * t1655 * t2155 + 0.5e1 / 0.32e2 * t1655 * t2159 - 0.9e1 / 0.32e2 * t519 * t8030 + 0.9e1 / 0.32e2 * t519 * t1628 * t8033;
  t8067 = t6209 * t219;
  t8074 = 0.3e1 / 0.4e1 * t1678 * t2162 + 0.3e1 / 0.4e1 * t534 * t7965 * t1379 - 0.9e1 / 0.16e2 * t1678 * t2166 - 0.9e1 / 0.16e2 * t534 * t8030 - 0.9e1 / 0.16e2 * t1678 * t2155 - 0.9e1 / 0.32e2 * t1681 * t2155 + 0.9e1 / 0.32e2 * t1681 * t2159 + 0.3e1 / 0.8e1 * t534 * t7969 * t5324 + 0.3e1 / 0.16e2 * t6184 * t684 + 0.3e1 / 0.16e2 * t1678 * t2209 + 0.3e1 / 0.16e2 * t534 * t2212 * t1650 + t534 * t683 * t6257 / 0.16e2 - 0.15e2 / 0.32e2 * t519 * t6208 * t8067 - 0.25e2 / 0.16e2 * t534 * t7969 * t5256;
  t8075 = t219 * t5247;
  t8079 = t675 * t75;
  t8094 = t2760 * t438;
  t8095 = t7315 * t8094;
  t8109 = t6237 * t219;
  t8113 = t6359 * t219;
  t8123 = 0.15e2 / 0.16e2 * t534 * t8075 * t6219 + 0.9e1 / 0.16e2 * t534 * t8079 * t5172 - 0.3e1 / 0.16e2 * t534 * t2216 * t168 * t1361 + 0.3e1 / 0.4e1 * t534 * t2216 * t418 * t2372 - 0.9e1 / 0.16e2 * t534 * t2779 * t6430 - 0.9e1 / 0.32e2 * t519 * t8095 + 0.9e1 / 0.32e2 * t519 * t7299 * t8094 - 0.3e1 / 0.8e1 * t534 * t2789 * t6430 + 0.9e1 / 0.32e2 * t519 * t6444 * t8094 - 0.9e1 / 0.16e2 * t534 * t8095 - 0.9e1 / 0.16e2 * t519 * t6202 * t8109 - 0.11e2 / 0.32e2 * t519 * t6246 * t8113 - t519 * t5188 * t665 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t1309 * t2181;
  t8126 = t521 * t2228;
  t8148 = t2228 * t75;
  t8152 = t1706 * t670;
  t8158 = -0.3e1 / 0.32e2 * t519 * t520 * t8126 + 0.9e1 / 0.32e2 * t1681 * t2147 - 0.3e1 / 0.32e2 * t6320 * t666 - 0.3e1 / 0.32e2 * t6261 * t666 - 0.3e1 / 0.32e2 * t1681 * t2178 - 0.3e1 / 0.16e2 * t1681 * t2182 - t6265 * t666 / 0.32e2 - t1655 * t2178 / 0.16e2 - 0.3e1 / 0.32e2 * t1655 * t2182 + 0.3e1 / 0.8e1 * t1678 * t2213 + 0.3e1 / 0.16e2 * t534 * t8148 * t547 + 0.9e1 / 0.32e2 * t519 * t1622 * t8152 - 0.3e1 / 0.16e2 * t1678 * t2217;
  t8185 = -0.3e1 / 0.16e2 * t534 * t670 * t438 * t445 - t534 * t219 * t1344 * t445 / 0.16e2 + 0.3e1 / 0.16e2 * t1678 * t2169 + 0.3e1 / 0.16e2 * t534 * t2193 * t1674 + t534 * t679 * t6312 / 0.16e2 - 0.3e1 / 0.16e2 * t7834 - 0.3e1 / 0.32e2 * t7836 + 0.3e1 / 0.32e2 * t7838 + 0.3e1 / 0.16e2 * t7840 - 0.3e1 / 0.32e2 * t7842 - 0.3e1 / 0.64e2 * t7844 + 0.3e1 / 0.32e2 * t7846 + 0.3e1 / 0.16e2 * t7848 - 0.7e1 / 0.32e2 * t519 * t8015;
  t8201 = 0.3e1 / 0.8e1 * t7854 - 0.9e1 / 0.32e2 * t7856 - 0.9e1 / 0.64e2 * t7858 + 0.9e1 / 0.64e2 * t7860 - 0.3e1 / 0.16e2 * t7862 + 0.9e1 / 0.64e2 * t7864 + 0.9e1 / 0.32e2 * t7867 - 0.3e1 / 0.16e2 * t7869 + 0.3e1 / 0.16e2 * t7871 + 0.3e1 / 0.16e2 * t7873 - 0.3e1 / 0.32e2 * t7875 - 0.9e1 / 0.32e2 * t7877 - 0.3e1 / 0.64e2 * t7879 - 0.3e1 / 0.32e2 * t7881;
  t8209 = my_piecewise3(t72, 0.24e2 * t1611, 0);
  t8223 = 0.3e1 / 0.64e2 * t7786 - 0.3e1 / 0.64e2 * t7790 - 0.3e1 / 0.64e2 * t7794 + 0.3e1 / 0.128e3 * t7798 - 0.3e1 / 0.16e2 * t409 * t2230 - t156 * t157 * t8209 * t173 / 0.16e2 - t5274 * t221 / 0.16e2 - 0.3e1 / 0.16e2 * t1313 * t672 - 0.3e1 / 0.32e2 * t7936 - 0.3e1 / 0.32e2 * t7938 - 0.3e1 / 0.16e2 * t7940 + 0.3e1 / 0.64e2 * t7775 + 0.3e1 / 0.64e2 * t7779 - t7655;
  t8227 = my_piecewise3(t51, 0, t7997 + t8037 + t8074 + t8123 + t8158 + t8185 + t8201 + t8223);
  tv4rho3tau7 = t3 * t8227 + 0.3e1 * t2235;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t8230 = t1419 * t2255;
  t8232 = t1419 * t2259;
  t8234 = t1499 * t2243;
  t8236 = t1419 * t2252;
  t8237 = t8236 / 0.16e2;
  t8238 = t695 * t261;
  t8241 = 0.3e1 / 0.16e2 * t484 * t8238 * t968;
  t8250 = t5703 * t261;
  t8251 = t2246 * t8250;
  t8254 = t690 * t4327;
  t8255 = t5730 * t261;
  t8259 = t695 * t943;
  t8262 = 0.3e1 / 0.16e2 * t484 * t8259 * t1526;
  t8266 = -t699 + t8230 / 0.4e1 - 0.3e1 / 0.16e2 * t8232 - 0.3e1 / 0.32e2 * t8234 + t8237 + t8241 - 0.3e1 / 0.16e2 * t1493 * t2243 - 0.5e1 / 0.32e2 * t1503 * t2243 + 0.5e1 / 0.32e2 * t1503 * t2248 + t1415 * t2255 / 0.2e1 + 0.11e2 / 0.16e2 * t469 * t8251 - 0.15e2 / 0.32e2 * t469 * t8254 * t8255 - t8262 - 0.25e2 / 0.16e2 * t484 * t2246 * t8255;
  t8267 = t5739 * t261;
  t8271 = t5550 * t261;
  t8272 = t2241 * t8271;
  t8277 = t2251 * t1459;
  t8279 = 0.3e1 / 0.16e2 * t484 * t8277;
  t8281 = 0.3e1 / 0.32e2 * t469 * t8277;
  t8282 = t1516 * t695;
  t8285 = 0.3e1 / 0.32e2 * t469 * t1515 * t8282;
  t8286 = t1419 * t2283;
  t8289 = t1415 * t2238 / 0.8e1;
  t8294 = t1419 * t2238;
  t8295 = t8294 / 0.16e2;
  t8297 = t1415 * t2252 / 0.8e1;
  t8298 = t690 * t261;
  t8304 = t484 * t8238 * t1031 / 0.16e2;
  t8307 = 0.15e2 / 0.16e2 * t484 * t8254 * t8267 - 0.3e1 / 0.2e1 * t484 * t8272 + 0.9e1 / 0.8e1 * t484 * t8251 - t8279 - t8281 + t8285 - t8286 / 0.16e2 - t8289 - t1415 * t2283 / 0.8e1 + 0.3e1 / 0.8e1 * t1415 * t2290 - t8295 + t8297 - t484 * t8298 * t4311 / 0.16e2 - t8304 - 0.3e1 / 0.8e1 * t1415 * t2259;
  t8316 = t1469 * t5535 * t690;
  t8319 = t1419 * t2294;
  t8332 = t484 * t8238 * t939 / 0.4e1;
  t8335 = t1419 * t2243;
  t8337 = t1499 * t2248;
  t8339 = t490 * t1434;
  t8343 = t2241 * t5779;
  t8346 = t5550 * t690;
  t8350 = 0.3e1 / 0.8e1 * t484 * t8298 * t4378 + 0.3e1 / 0.16e2 * t484 * t2262 * t4243 + 0.9e1 / 0.16e2 * t469 * t8316 + t8319 / 0.8e1 + t1415 * t2294 / 0.4e1 - 0.3e1 / 0.8e1 * t1415 * t2243 + 0.3e1 / 0.16e2 * t1493 * t2248 + 0.11e2 / 0.16e2 * t484 * t8298 * t4343 + t8332 - t1503 * t2267 / 0.8e1 - 0.3e1 / 0.16e2 * t8335 + 0.3e1 / 0.32e2 * t8337 + t484 * t489 * t8339 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t8343 - 0.9e1 / 0.16e2 * t469 * t1515 * t8346;
  t8351 = t1419 * t2300;
  t8353 = t1419 * t2264;
  t8355 = t1499 * t2271;
  t8368 = t1419 * t2290;
  t8370 = t5612 * t261;
  t8382 = t1419 * t2275;
  t8383 = t8382 / 0.16e2;
  t8384 = t1499 * t2279;
  t8385 = t8384 / 0.32e2;
  t8386 = t8351 / 0.8e1 - t8353 / 0.8e1 + 0.3e1 / 0.32e2 * t8355 + t1415 * t2300 / 0.4e1 - t1415 * t2264 / 0.4e1 + 0.3e1 / 0.16e2 * t1493 * t2271 - t1415 * t2286 / 0.4e1 - t484 * t495 * t5648 / 0.8e1 + 0.3e1 / 0.16e2 * t8368 - 0.11e2 / 0.16e2 * t484 * t2262 * t8370 - t469 * t489 * t5648 / 0.16e2 + 0.5e1 / 0.32e2 * t1503 * t2271 + 0.3e1 / 0.32e2 * t469 * t2241 * t4243 + t8383 - t8385;
  t8390 = t1415 * t2275 / 0.8e1;
  t8393 = t484 * t2274 * t1475 / 0.16e2;
  t8394 = t1470 * t695;
  t8397 = 0.3e1 / 0.32e2 * t469 * t1469 * t8394;
  t8399 = t1493 * t2279 / 0.16e2;
  t8401 = t1503 * t2279 / 0.32e2;
  t8402 = t496 * t1434;
  t8409 = t5612 * t690;
  t8413 = t1499 * t2267;
  t8420 = t1525 * t283;
  t8427 = t484 * t695 * t283 * t290 / 0.16e2;
  t8433 = t8390 + t8393 + t8397 - t8399 - t8401 + t484 * t495 * t8402 / 0.8e1 - t484 * t2262 * t4239 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t1469 * t8409 - t8413 / 0.16e2 - t1493 * t2267 / 0.8e1 + t484 * t2241 * t4253 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2246 * t8420 - t8427 - 0.3e1 / 0.32e2 * t469 * t8343 + 0.3e1 / 0.32e2 * t469 * t2246 * t4253;
  t8436 = t484 * t2251 * t1487 / 0.16e2;
  t8445 = t469 * t1048 * t2278 / 0.32e2;
  t8448 = t484 * t2274 * t1464 / 0.8e1;
  t8451 = t5483 * t261;
  t8455 = t1419 * t2286;
  t8459 = t938 * t478 * t111;
  t8462 = t1458 * t478;
  t8469 = t2456 * t478;
  t8470 = t5783 * t8469;
  t8481 = t8436 - t484 * t690 * t283 * t1031 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t8272 - t8445 - t8448 + 0.11e2 / 0.16e2 * t484 * t8316 + 0.3e1 / 0.8e1 * t484 * t2262 * t8451 - t8455 / 0.8e1 + t484 * t489 * t935 * t8459 - t484 * t5778 * t8462 / 0.4e1 - 0.3e1 / 0.4e1 * t484 * t5812 * t8459 - 0.3e1 / 0.8e1 * t469 * t8470 - 0.3e1 / 0.4e1 * t484 * t8470 + 0.3e1 / 0.8e1 * t469 * t5804 * t8469 - t484 * t5793 * t8459 / 0.2e1;
  t8490 = t1023 * t707;
  t8492 = t478 * t478;
  t8493 = t100 * t8492;
  t8498 = t984 * t704 / 0.64e2;
  t8499 = t1023 * t704;
  t8503 = t1023 * t701;
  t8514 = t1020 * t697 / 0.16e2;
  t8519 = t1023 * t692;
  t8521 = 0.3e1 / 0.8e1 * t469 * t5799 * t8469 + 0.3e1 / 0.4e1 * t484 * t495 * t265 * t8459 + t8490 / 0.16e2 - t99 * t8493 * t290 / 0.8e1 - t8498 + t8499 / 0.16e2 - t1020 * t701 / 0.16e2 - t8503 / 0.16e2 - t1020 * t692 / 0.32e2 - t246 * t2320 / 0.16e2 - t99 * t4460 * t690 * t269 / 0.32e2 - t8514 + t1020 * t704 / 0.16e2 + t1020 * t707 / 0.16e2 - t8519 / 0.32e2;
  t8522 = t255 * t2320;
  t8524 = t1023 * t697;
  t8525 = t8524 / 0.16e2;
  t8527 = t984 * t701 / 0.64e2;
  t8529 = t984 * t697 / 0.64e2;
  t8534 = t984 * t692 / 0.128e3;
  t8543 = t984 * t707 / 0.64e2;
  t8544 = t2239 / 0.8e1;
  t8545 = t2253 / 0.8e1;
  t8546 = t2276 / 0.8e1;
  t8547 = t2280 / 0.16e2;
  t8548 = t2313 / 0.16e2;
  t8549 = t2323 / 0.8e1;
  t8550 = -t8522 / 0.32e2 - t8525 + t8527 + t8529 + t99 * t8493 * t301 / 0.8e1 + t8534 - t99 * t260 * t8492 * t269 / 0.16e2 + t99 * t8493 * t297 / 0.8e1 - t8543 - t8544 + t8545 + t8546 - t8547 - t8548 - t8549;
  t8554 = my_piecewise3(t2, 0, t8266 + t8307 + t8350 + t8386 + t8433 + t8481 + t8521 + t8550);
  tv4rho2sigma20 = t3 * t8554 + 0.2e1 * t2329;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t8559 = t1167 * t714;
  t8562 = t1170 * t714 / 0.128e3;
  t8564 = t1164 * t719 / 0.16e2;
  t8565 = t1167 * t719;
  t8566 = t8565 / 0.16e2;
  t8568 = t1170 * t719 / 0.64e2;
  t8571 = t1167 * t723;
  t8574 = t1170 * t723 / 0.64e2;
  t8577 = t1167 * t726;
  t8580 = t1170 * t726 / 0.64e2;
  t8583 = t1167 * t729;
  t8586 = t1170 * t729 / 0.64e2;
  t8587 = -t1164 * t714 / 0.32e2 - t8559 / 0.32e2 + t8562 - t8564 - t8566 + t8568 - t1164 * t723 / 0.16e2 - t8571 / 0.16e2 + t8574 + t1164 * t726 / 0.16e2 + t8577 / 0.16e2 - t8580 + t1164 * t729 / 0.16e2 + t8583 / 0.16e2 - t8586;
  t8588 = my_piecewise3(t51, 0, t8587);
  tv4rho2sigma25 = t3 * t8588 + 0.2e1 * t2352;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t8591 = t1553 * t2238 / 0.16e2;
  t8595 = t1553 * t2252 / 0.16e2;
  t8611 = t1553 * t2275 / 0.16e2;
  t8613 = t1548 * t2279 / 0.32e2;
  t8618 = -t8591 - t1553 * t2283 / 0.16e2 + t8595 + t1553 * t2255 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2259 - 0.3e1 / 0.32e2 * t1548 * t2243 + 0.3e1 / 0.32e2 * t1548 * t2248 + t1553 * t2294 / 0.8e1 - t1548 * t2267 / 0.16e2 + 0.3e1 / 0.32e2 * t1548 * t2271 + t8611 - t8613 - 0.3e1 / 0.16e2 * t1553 * t2243 + t1553 * t2300 / 0.8e1;
  t8628 = t8236 / 0.32e2;
  t8630 = t8294 / 0.32e2;
  t8637 = -t1553 * t2264 / 0.8e1 - t1553 * t2286 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2290 + t8230 / 0.8e1 - 0.3e1 / 0.32e2 * t8232 - 0.3e1 / 0.64e2 * t8234 + t8628 - t8286 / 0.32e2 - t8630 + t8319 / 0.16e2 - 0.3e1 / 0.32e2 * t8335 + 0.3e1 / 0.64e2 * t8337 + t8351 / 0.16e2 - t8353 / 0.16e2 + 0.3e1 / 0.64e2 * t8355;
  t8640 = t8382 / 0.32e2;
  t8641 = t8384 / 0.64e2;
  t8655 = t1124 * t697 / 0.16e2;
  t8656 = t1127 * t707;
  t8658 = t1127 * t701;
  t8660 = t1127 * t704;
  t8662 = 0.3e1 / 0.32e2 * t8368 + t8640 - t8641 - t8413 / 0.32e2 - t8455 / 0.16e2 + t1124 * t707 / 0.16e2 - t1124 * t701 / 0.16e2 + t1124 * t704 / 0.16e2 - t1124 * t692 / 0.32e2 - t345 * t2320 / 0.32e2 - t8655 + t8656 / 0.32e2 - t8658 / 0.32e2 + t8660 / 0.32e2;
  t8663 = t1127 * t692;
  t8665 = t1127 * t697;
  t8666 = t8665 / 0.32e2;
  t8672 = t8524 / 0.32e2;
  t8673 = -t8663 / 0.64e2 - t8666 + t8490 / 0.32e2 - t8498 + t8499 / 0.32e2 - t8503 / 0.32e2 - t8519 / 0.64e2 - t8522 / 0.64e2 - t8672 + t8527 + t8529 + t8534 - t8543 - t2357 - t2314;
  t8676 = my_piecewise3(t2, 0, t8618 + t8637 + t8662 + t8673);
  tv4rho2sigma26 = t3 * t8676 + t2329 + t2365;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t8678 = t1578 * t2430;
  t8680 = t1589 * t2368;
  t8681 = t8680 / 0.32e2;
  t8682 = t1589 * t2373;
  t8684 = t1589 * t2416;
  t8686 = t1589 * t2421;
  t8687 = t8686 / 0.32e2;
  t8688 = t1589 * t2425;
  t8690 = t1578 * t2398;
  t8692 = t1589 * t2402;
  t8693 = t8692 / 0.32e2;
  t8694 = t1578 * t2406;
  t8695 = t8694 / 0.64e2;
  t8696 = t1589 * t2409;
  t8698 = t1589 * t2412;
  t8700 = t1589 * t2382;
  t8702 = t1589 * t2386;
  t8704 = t1589 * t2391;
  t8706 = 0.3e1 / 0.64e2 * t8678 + t8681 + t8682 / 0.8e1 + t8684 / 0.16e2 - t8687 - t8688 / 0.32e2 + 0.3e1 / 0.64e2 * t8690 + t8693 - t8695 - t8696 / 0.16e2 + 0.3e1 / 0.32e2 * t8698 - 0.3e1 / 0.32e2 * t8700 + t8702 / 0.16e2 - t8704 / 0.16e2;
  t8707 = t1578 * t2394;
  t8715 = t1589 * t2378;
  t8717 = t1578 * t2382;
  t8724 = t1585 * t2368 / 0.16e2;
  t8736 = t1585 * t2402 / 0.16e2;
  t8737 = -t8707 / 0.32e2 - 0.3e1 / 0.16e2 * t1585 * t2382 + t1585 * t2386 / 0.8e1 - t1585 * t2391 / 0.8e1 - 0.3e1 / 0.32e2 * t8715 - 0.3e1 / 0.64e2 * t8717 - 0.3e1 / 0.32e2 * t1574 * t2382 + 0.3e1 / 0.32e2 * t1574 * t2430 + t8724 - t1585 * t2409 / 0.8e1 + 0.3e1 / 0.16e2 * t1585 * t2412 + t1585 * t2416 / 0.8e1 - t1574 * t2394 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t2398 + t8736;
  t8740 = t1574 * t2406 / 0.32e2;
  t8746 = t1585 * t2421 / 0.16e2;
  t8752 = t1224 * t719 / 0.16e2;
  t8761 = t1227 * t726;
  t8763 = t1227 * t729;
  t8765 = t1227 * t714;
  t8767 = -t8740 + t1585 * t2373 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2378 - t8746 - t1585 * t2425 / 0.16e2 - t367 * t2436 / 0.32e2 - t8752 - t1224 * t723 / 0.16e2 + t1224 * t726 / 0.16e2 + t1224 * t729 / 0.16e2 - t1224 * t714 / 0.32e2 + t8761 / 0.32e2 + t8763 / 0.32e2 - t8765 / 0.64e2;
  t8768 = t370 * t2436;
  t8770 = t1227 * t719;
  t8771 = t8770 / 0.32e2;
  t8772 = t1227 * t723;
  t8778 = t8565 / 0.32e2;
  t8779 = -t8768 / 0.64e2 - t8771 - t8772 / 0.32e2 - t8571 / 0.32e2 + t8574 + t8577 / 0.32e2 - t8580 + t8583 / 0.32e2 - t8586 - t8559 / 0.64e2 + t8562 - t8778 + t8568 - t2336 - t2338;
  t8782 = my_piecewise3(t51, 0, t8706 + t8737 + t8767 + t8779);
  tv4rho2sigma211 = t3 * t8782 + t2352 + t2449;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t8789 = t1196 * t697 / 0.16e2;
  t8790 = t8665 / 0.16e2;
  t8800 = -t1196 * t692 / 0.32e2 - t8663 / 0.32e2 + t8534 - t8789 - t8790 + t8529 - t1196 * t701 / 0.16e2 - t8658 / 0.16e2 + t8527 + t1196 * t704 / 0.16e2 + t8660 / 0.16e2 - t8498 + t1196 * t707 / 0.16e2 + t8656 / 0.16e2 - t8543;
  t8801 = my_piecewise3(t2, 0, t8800);
  tv4rho2sigma212 = t3 * t8801 + 0.2e1 * t2365;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t8811 = t1360 * t528 * t168;
  t8812 = t2568 * t8811;
  t8829 = t2583 * t528;
  t8835 = t2367 * t1947;
  t8837 = 0.3e1 / 0.16e2 * t534 * t8835;
  t8839 = 0.3e1 / 0.32e2 * t519 * t8835;
  t8840 = t1629 * t717;
  t8843 = 0.3e1 / 0.32e2 * t519 * t1628 * t8840;
  t8844 = -t721 + 0.3e1 / 0.4e1 * t534 * t6434 * t6297 - t534 * t6434 * t6158 / 0.4e1 - 0.3e1 / 0.8e1 * t519 * t8812 + 0.3e1 / 0.8e1 * t519 * t2574 * t8811 + t534 * t539 * t1372 * t8811 - 0.3e1 / 0.4e1 * t534 * t6428 * t8811 - 0.3e1 / 0.4e1 * t534 * t8812 - t534 * t6440 * t8811 / 0.2e1 + 0.3e1 / 0.8e1 * t519 * t6444 * t8829 - 0.3e1 / 0.16e2 * t1681 * t2382 - t8837 - t8839 + t8843;
  t8845 = t6237 * t416;
  t8846 = t2371 * t8845;
  t8849 = t6203 * t416;
  t8850 = t2376 * t8849;
  t8853 = t717 * t416;
  t8856 = t534 * t8853 * t1361 / 0.16e2;
  t8857 = t712 * t416;
  t8868 = t1678 * t2368 / 0.8e1;
  t8878 = 0.3e1 / 0.16e2 * t534 * t8853 * t1392;
  t8886 = t534 * t8853 * t1379 / 0.4e1;
  t8887 = -0.3e1 / 0.2e1 * t534 * t8846 + 0.9e1 / 0.8e1 * t534 * t8850 - t8856 - t534 * t8857 * t5233 / 0.16e2 + 0.3e1 / 0.16e2 * t1681 * t2430 - 0.5e1 / 0.32e2 * t1655 * t2382 + 0.5e1 / 0.32e2 * t1655 * t2430 + t8868 + t1678 * t2373 / 0.2e1 - 0.3e1 / 0.8e1 * t1678 * t2378 - 0.11e2 / 0.16e2 * t534 * t8857 * t5298 + t8878 + 0.3e1 / 0.8e1 * t534 * t8857 * t5324 - 0.3e1 / 0.8e1 * t1678 * t2382 + t8886;
  t8894 = t712 * t5247;
  t8895 = t6209 * t416;
  t8899 = t717 * t1370;
  t8902 = 0.3e1 / 0.16e2 * t534 * t8899 * t1640;
  t8906 = t6218 * t416;
  t8910 = t6247 * t416;
  t8911 = t2371 * t8910;
  t8916 = t534 * t2401 * t1702 / 0.8e1;
  t8919 = t6288 * t416;
  t8923 = t546 * t1613;
  t8932 = t1678 * t2402 / 0.8e1;
  t8934 = t1681 * t2406 / 0.16e2;
  t8935 = 0.11e2 / 0.16e2 * t534 * t8857 * t5238 + 0.11e2 / 0.16e2 * t519 * t8850 - 0.15e2 / 0.32e2 * t519 * t8894 * t8895 - t8902 - 0.25e2 / 0.16e2 * t534 * t2376 * t8895 + 0.15e2 / 0.16e2 * t534 * t8894 * t8906 + 0.9e1 / 0.16e2 * t519 * t8911 - t8916 + 0.11e2 / 0.16e2 * t534 * t8911 + 0.3e1 / 0.8e1 * t534 * t2389 * t8919 + t534 * t545 * t8923 / 0.8e1 - t1655 * t2394 / 0.8e1 + 0.5e1 / 0.32e2 * t1655 * t2398 + t8932 - t8934;
  t8949 = t1678 * t2421 / 0.8e1;
  t8954 = t519 * t1309 * t2405 / 0.32e2;
  t8964 = t6359 * t712;
  t8974 = -t1678 * t2409 / 0.4e1 + t1678 * t2386 / 0.4e1 - t1678 * t2391 / 0.4e1 + 0.3e1 / 0.16e2 * t1681 * t2398 - t1681 * t2394 / 0.8e1 + 0.3e1 / 0.8e1 * t1678 * t2412 - t8949 - t1678 * t2425 / 0.8e1 - t8954 - t534 * t545 * t6334 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2389 * t5172 - t534 * t2389 * t5209 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t1622 * t8964 - t519 * t539 * t6334 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2371 * t5172;
  t8979 = t534 * t2401 * t1650 / 0.16e2;
  t8980 = t1706 * t717;
  t8983 = 0.3e1 / 0.32e2 * t519 * t1622 * t8980;
  t8986 = t1623 * t438;
  t8987 = t2371 * t8986;
  t8990 = t6237 * t712;
  t8997 = t1639 * t438;
  t9014 = t534 * t2367 * t1674 / 0.16e2;
  t9018 = t534 * t717 * t438 * t445 / 0.16e2;
  t9019 = t540 * t1613;
  t9024 = t1655 * t2406 / 0.32e2;
  t9025 = t8979 + t8983 + t1678 * t2416 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t8987 - 0.9e1 / 0.16e2 * t519 * t1628 * t8990 + t534 * t2371 * t5182 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2376 * t8997 - t534 * t712 * t438 * t1361 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t8846 - 0.3e1 / 0.32e2 * t519 * t8987 + 0.3e1 / 0.32e2 * t519 * t2376 * t5182 + t9014 - t9018 + t534 * t539 * t9019 / 0.8e1 - t9024;
  t9027 = t8680 / 0.16e2;
  t9030 = t8686 / 0.16e2;
  t9033 = t8692 / 0.16e2;
  t9034 = t8694 / 0.32e2;
  t9041 = 0.3e1 / 0.32e2 * t8678 + t9027 + t8682 / 0.4e1 + t8684 / 0.8e1 - t9030 - t8688 / 0.16e2 + 0.3e1 / 0.32e2 * t8690 + t9033 - t9034 - t8696 / 0.8e1 + 0.3e1 / 0.16e2 * t8698 - 0.3e1 / 0.16e2 * t8700 + t8702 / 0.8e1 - t8704 / 0.8e1 - t8707 / 0.16e2;
  t9045 = t528 * t528;
  t9046 = t157 * t9045;
  t9075 = t1313 * t719 / 0.16e2;
  t9078 = -0.3e1 / 0.16e2 * t8715 - 0.3e1 / 0.32e2 * t8717 + t156 * t9046 * t452 / 0.8e1 - t156 * t9046 * t445 / 0.8e1 - t156 * t415 * t9045 * t424 / 0.16e2 + t156 * t9046 * t456 / 0.8e1 - t1313 * t723 / 0.16e2 + t1313 * t726 / 0.16e2 + t1313 * t729 / 0.16e2 - t1313 * t714 / 0.32e2 - t409 * t2436 / 0.16e2 - t156 * t5380 * t712 * t424 / 0.32e2 - t9075 + t8761 / 0.16e2 + t8763 / 0.16e2;
  t9081 = t8770 / 0.16e2;
  t9083 = t2369 / 0.8e1;
  t9084 = t2403 / 0.8e1;
  t9085 = t2407 / 0.16e2;
  t9086 = t2422 / 0.8e1;
  t9087 = t2439 / 0.8e1;
  t9088 = t2337 / 0.16e2;
  t9089 = -t8765 / 0.32e2 - t8768 / 0.32e2 - t9081 - t8772 / 0.16e2 + t8574 - t8580 - t8586 + t8562 + t8568 + t9083 + t9084 - t9085 - t9086 - t9087 - t9088;
  t9093 = my_piecewise3(t51, 0, t8844 + t8887 + t8935 + t8974 + t9025 + t9041 + t9078 + t9089);
  tv4rho2sigma217 = t3 * t9093 + 0.2e1 * t2449;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t9096 = t489 * t295;
  t9097 = t4276 * t199;
  t9098 = t9097 * t261;
  t9099 = t9096 * t9098;
  t9102 = t1735 * t4321;
  t9103 = t4276 * t183;
  t9104 = t9103 * t261;
  t9108 = t6516 * t4329;
  t9112 = t5812 * t9098;
  t9117 = t1419 * t2472;
  t9119 = t568 * t43;
  t9133 = t737 * t261;
  t9137 = t572 * t935;
  t9138 = t9137 * t9104;
  t9146 = t1419 * t2486;
  t9148 = t1419 * t2476;
  t9150 = -t699 + 0.9e1 / 0.16e2 * t469 * t9099 - 0.25e2 / 0.16e2 * t484 * t9102 * t9104 + 0.15e2 / 0.16e2 * t484 * t9108 * t9104 + 0.11e2 / 0.16e2 * t469 * t9112 - 0.3e1 / 0.8e1 * t1415 * t2476 + 0.3e1 / 0.16e2 * t9117 + 0.3e1 / 0.8e1 * t484 * t9119 * t5621 - t1415 * t2452 / 0.8e1 - t484 * t2518 * t111 * t1031 / 0.8e1 - t484 * t2522 * t111 * t1031 / 0.8e1 + 0.11e2 / 0.16e2 * t484 * t9133 * t4343 - 0.3e1 / 0.2e1 * t484 * t9138 + 0.9e1 / 0.8e1 * t484 * t9112 - t484 * t9133 * t4311 / 0.16e2 + t9146 / 0.4e1 - 0.3e1 / 0.16e2 * t9148;
  t9155 = t1499 * t2458;
  t9168 = t2455 * t8459;
  t9184 = t1419 * t2452;
  t9195 = t938 * t563;
  t9196 = t9195 * t183;
  t9204 = t5783 * t9196;
  t9207 = -0.11e2 / 0.16e2 * t484 * t1775 * t43 * t5613 - 0.3e1 / 0.32e2 * t9155 - 0.3e1 / 0.8e1 * t484 * t6535 * t945 * t2457 - 0.3e1 / 0.8e1 * t484 * t2475 * t8459 - 0.5e1 / 0.32e2 * t1503 * t2458 + 0.5e1 / 0.32e2 * t1503 * t2482 - 0.3e1 / 0.8e1 * t484 * t9168 + t1415 * t2486 / 0.2e1 + t484 * t2518 * t263 * t2247 / 0.2e1 + t484 * t2522 * t263 * t2247 / 0.2e1 + 0.3e1 / 0.8e1 * t484 * t2461 * t9104 - t9184 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t9133 * t4378 + 0.11e2 / 0.16e2 * t484 * t9099 - t484 * t1754 * t113 * t2457 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5799 * t9196 + 0.3e1 / 0.8e1 * t484 * t2518 * t43 * t2270 - 0.3e1 / 0.16e2 * t469 * t9204;
  t9218 = t2466 * t478;
  t9232 = t1419 * t2458;
  t9234 = t1499 * t2482;
  t9250 = -0.3e1 / 0.16e2 * t469 * t9168 - 0.3e1 / 0.8e1 * t1415 * t2458 + 0.3e1 / 0.16e2 * t1493 * t2482 - t484 * t2461 * t8459 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5799 * t9218 + 0.3e1 / 0.8e1 * t1415 * t2472 - 0.3e1 / 0.16e2 * t1493 * t2458 - t484 * t737 * t283 * t1031 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t9138 - 0.3e1 / 0.16e2 * t9232 + 0.3e1 / 0.32e2 * t9234 + 0.5e1 / 0.32e2 * t1503 * t2468 - 0.3e1 / 0.8e1 * t484 * t9204 + 0.3e1 / 0.16e2 * t469 * t5804 * t9196 + 0.3e1 / 0.16e2 * t469 * t5804 * t9218 - t1415 * t2462 / 0.4e1 + 0.3e1 / 0.16e2 * t1493 * t2468;
  t9264 = t261 * t4327 * t4321;
  t9265 = t9097 * t183;
  t9269 = t9096 * t6737;
  t9277 = t1515 * t935;
  t9281 = t1419 * t2462;
  t9283 = t1499 * t2468;
  t9288 = t1469 * t265;
  t9307 = 0.3e1 / 0.32e2 * t469 * t2481 * t6737 + t484 * t2485 * t4253 / 0.4e1 + 0.3e1 / 0.16e2 * t484 * t2471 * t4243 - 0.3e1 / 0.16e2 * t484 * t2475 * t5784 - 0.15e2 / 0.32e2 * t469 * t9264 * t9265 - 0.3e1 / 0.32e2 * t469 * t9269 + 0.3e1 / 0.32e2 * t469 * t2465 * t6737 - 0.3e1 / 0.16e2 * t484 * t9269 - 0.9e1 / 0.16e2 * t469 * t9277 * t9265 - t9281 / 0.8e1 + 0.3e1 / 0.32e2 * t9283 - t484 * t2461 * t5784 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t9288 * t9265 + t484 * t6597 * t745 / 0.16e2 - t1415 * t2519 / 0.8e1 - t1415 * t2523 / 0.8e1 - t484 * t1726 * t183 * t290 / 0.16e2 - t484 * t563 * t478 * t290 / 0.8e1;
  t9330 = t1419 * t2493;
  t9332 = t1419 * t2519;
  t9334 = t1419 * t2523;
  t9336 = t5505 * t742;
  t9338 = t1419 * t2528;
  t9340 = t1419 * t2513;
  t9342 = t5505 * t738;
  t9349 = -t484 * t199 * t1434 * t290 / 0.16e2 + t5521 * t742 / 0.16e2 + t1415 * t2528 / 0.8e1 + t1415 * t2531 / 0.8e1 + t1415 * t2513 / 0.8e1 + t484 * t1754 * t2299 / 0.8e1 + t484 * t576 * t8402 / 0.16e2 - t5521 * t738 / 0.16e2 + t9330 / 0.16e2 - t9332 / 0.16e2 - t9334 / 0.16e2 + t9336 / 0.16e2 + t9338 / 0.16e2 + t9340 / 0.16e2 - t9342 / 0.16e2 - t469 * t489 * t6593 / 0.32e2 - t5681 * t734 / 0.32e2;
  t9382 = t5493 * t738 / 0.64e2;
  t9384 = t5493 * t746 / 0.64e2;
  t9386 = t5655 * t734 / 0.128e3;
  t9388 = t5493 * t742 / 0.64e2;
  t9389 = t5676 * t734;
  t9391 = -t5685 * t734 / 0.16e2 - t1493 * t2500 / 0.16e2 - t1493 * t2504 / 0.16e2 - t5667 * t734 / 0.32e2 - t1503 * t2500 / 0.16e2 - t1503 * t2504 / 0.16e2 - t469 * t5633 * t558 / 0.32e2 - t469 * t1447 * t1750 / 0.16e2 + t484 * t6486 * t741 / 0.16e2 + t484 * t1771 * t2293 / 0.8e1 + t484 * t572 * t8339 / 0.16e2 + t5521 * t746 / 0.16e2 + t1415 * t2493 / 0.8e1 + t9382 - t9384 + t9386 - t9388 - t9389 / 0.32e2;
  t9393 = t5659 * t734;
  t9395 = t1499 * t2500;
  t9397 = t1499 * t2504;
  t9399 = t1419 * t2531;
  t9401 = t5505 * t746;
  t9403 = -t9393 / 0.32e2 - t9395 / 0.32e2 - t9397 / 0.32e2 + t9399 / 0.16e2 + t9401 / 0.16e2 + t8237 + t8241 - t8262 - t8279 - t8281 + t8285 - t8289 - t8295 + t8297 - t8304 + t8332 + t8383 - t8385;
  t9404 = t8390 + t8393 + t8397 - t8399 - t8401 - t8427 + t8436 - t8445 - t8448 - t8514 - t8525 + t8529 - t8544 + t8545 + t8546 - t8547 - t8548 - t8549;
  t9408 = my_piecewise3(t2, 0, t9150 + t9207 + t9250 + t9307 + t9349 + t9391 + t9403 + t9404);
  tv4rho2sigmalapl0 = t3 * t9408 + 0.2e1 * t2536;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t9413 = t5960 * t751;
  t9416 = t5964 * t751 / 0.128e3;
  t9419 = t5949 * t755;
  t9422 = t5946 * t755 / 0.64e2;
  t9425 = t5949 * t759;
  t9428 = t5946 * t759 / 0.64e2;
  t9431 = t5949 * t763;
  t9434 = t5946 * t763 / 0.64e2;
  t9435 = -t5975 * t751 / 0.32e2 - t9413 / 0.32e2 + t9416 - t8564 - t8566 + t8568 - t5967 * t755 / 0.16e2 - t9419 / 0.16e2 + t9422 + t5967 * t759 / 0.16e2 + t9425 / 0.16e2 - t9428 + t5967 * t763 / 0.16e2 + t9431 / 0.16e2 - t9434;
  t9436 = my_piecewise3(t51, 0, t9435);
  tv4rho2sigmalapl5 = t3 * t9436 + 0.2e1 * t2555;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t9463 = -0.3e1 / 0.32e2 * t1548 * t2458 + 0.3e1 / 0.32e2 * t1548 * t2482 + t1553 * t2486 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2476 - t1553 * t2452 / 0.16e2 - 0.3e1 / 0.16e2 * t1553 * t2458 - t1553 * t2462 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t2468 + 0.3e1 / 0.16e2 * t1553 * t2472 + 0.3e1 / 0.32e2 * t9117 + t9146 / 0.8e1 - 0.3e1 / 0.32e2 * t9148 - 0.3e1 / 0.64e2 * t9155 - t9184 / 0.32e2 - 0.3e1 / 0.32e2 * t9232 + 0.3e1 / 0.64e2 * t9234;
  t9490 = t5838 * t742;
  t9492 = t5838 * t746;
  t9494 = t5870 * t734;
  t9496 = -t9281 / 0.16e2 + 0.3e1 / 0.64e2 * t9283 + t1553 * t2513 / 0.16e2 + t5835 * t742 / 0.16e2 + t1553 * t2528 / 0.16e2 + t1553 * t2531 / 0.16e2 + t5835 * t746 / 0.16e2 - t5835 * t738 / 0.16e2 - t1553 * t2519 / 0.16e2 - t1553 * t2523 / 0.16e2 - t5886 * t734 / 0.32e2 - t5873 * t734 / 0.32e2 - t1548 * t2500 / 0.32e2 - t1548 * t2504 / 0.32e2 + t9490 / 0.32e2 + t9492 / 0.32e2 - t9494 / 0.64e2;
  t9498 = t5838 * t738;
  t9512 = -t9498 / 0.32e2 + t1553 * t2493 / 0.16e2 + t9330 / 0.32e2 - t9332 / 0.32e2 - t9334 / 0.32e2 + t9336 / 0.32e2 + t9338 / 0.32e2 + t9340 / 0.32e2 - t9342 / 0.32e2 + t9382 - t9384 + t9386 - t9388 - t9389 / 0.64e2 - t9393 / 0.64e2 - t9395 / 0.64e2;
  t9516 = -t9397 / 0.64e2 + t9399 / 0.32e2 + t9401 / 0.32e2 - t8591 + t8595 + t8611 - t8613 + t8628 - t8630 + t8640 - t8641 - t8655 - t8666 - t8672 + t8529 - t2357 - t2314;
  t9519 = my_piecewise3(t2, 0, t9463 + t9496 + t9512 + t9516);
  tv4rho2sigmalapl6 = t3 * t9519 + t2536 + t2566;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t9521 = t1589 * t2585;
  t9523 = t1589 * t2603;
  t9525 = t1578 * t2571;
  t9527 = t1578 * t2575;
  t9529 = t1589 * t2589;
  t9531 = t1589 * t2571;
  t9533 = t1589 * t2595;
  t9535 = t1578 * t2599;
  t9537 = t1589 * t2579;
  t9553 = -0.3e1 / 0.32e2 * t9521 + 0.3e1 / 0.32e2 * t9523 - 0.3e1 / 0.64e2 * t9525 + 0.3e1 / 0.64e2 * t9527 - t9529 / 0.32e2 - 0.3e1 / 0.32e2 * t9531 - t9533 / 0.16e2 + 0.3e1 / 0.64e2 * t9535 + t9537 / 0.8e1 - t1585 * t2589 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t2571 - t1585 * t2595 / 0.8e1 + t1585 * t2579 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2585 - 0.3e1 / 0.32e2 * t1574 * t2571 + 0.3e1 / 0.32e2 * t1574 * t2575;
  t9558 = t6051 * t751;
  t9560 = t1578 * t2619;
  t9562 = t6032 * t755;
  t9564 = t1589 * t2626;
  t9566 = t1589 * t2630;
  t9568 = t6032 * t759;
  t9570 = t1589 * t2610;
  t9572 = t1589 * t2613;
  t9574 = t1578 * t2616;
  t9588 = 0.3e1 / 0.32e2 * t1574 * t2599 + 0.3e1 / 0.16e2 * t1585 * t2603 - t9558 / 0.64e2 - t9560 / 0.64e2 - t9562 / 0.32e2 - t9564 / 0.32e2 - t9566 / 0.32e2 + t9568 / 0.32e2 + t9570 / 0.32e2 + t9572 / 0.32e2 - t9574 / 0.64e2 - t6079 * t751 / 0.32e2 + t1585 * t2638 / 0.16e2 + t6073 * t763 / 0.16e2 - t6076 * t751 / 0.32e2 - t1585 * t2626 / 0.16e2 - t1585 * t2630 / 0.16e2;
  t9604 = t1589 * t2635;
  t9606 = t1589 * t2638;
  t9608 = t6032 * t763;
  t9610 = t6045 * t751;
  t9615 = t6073 * t759 / 0.16e2 + t1585 * t2635 / 0.16e2 + t1585 * t2613 / 0.16e2 - t1574 * t2616 / 0.32e2 - t1574 * t2619 / 0.32e2 - t6073 * t755 / 0.16e2 + t1585 * t2610 / 0.16e2 + t9604 / 0.32e2 + t9606 / 0.32e2 + t9608 / 0.32e2 - t9610 / 0.64e2 - t9413 / 0.64e2 + t9416 - t9419 / 0.32e2 + t9422 + t9425 / 0.32e2;
  t9617 = -t9428 + t9431 / 0.32e2 - t9434 + t8681 - t8687 + t8693 - t8695 + t8724 + t8736 - t8740 - t8746 - t8752 - t8771 - t8778 + t8568 - t2336 - t2338;
  t9620 = my_piecewise3(t51, 0, t9553 + t9588 + t9615 + t9617);
  tv4rho2sigmalapl11 = t3 * t9620 + t2555 + t2645;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t9635 = -t6000 * t734 / 0.32e2 - t9494 / 0.32e2 + t9386 - t8789 - t8790 + t8529 - t6005 * t738 / 0.16e2 - t9498 / 0.16e2 + t9382 + t6005 * t742 / 0.16e2 + t9490 / 0.16e2 - t9388 + t6005 * t746 / 0.16e2 + t9492 / 0.16e2 - t9384;
  t9636 = my_piecewise3(t2, 0, t9635);
  tv4rho2sigmalapl12 = t3 * t9636 + 0.2e1 * t2566;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t9651 = t7135 * t5261;
  t9652 = t5232 * t191;
  t9653 = t9652 * t416;
  t9657 = t754 * t416;
  t9661 = t611 * t1372;
  t9662 = t9661 * t9653;
  t9665 = t2582 * t9653;
  t9668 = t5232 * t207;
  t9669 = t9668 * t416;
  t9670 = t2568 * t9669;
  t9675 = t6217 * t5249;
  t9692 = t1907 * t450;
  t9693 = t9692 * t2584;
  t9696 = -t721 - t534 * t2625 * t168 * t1361 / 0.8e1 - t534 * t2629 * t168 * t1361 / 0.8e1 - 0.25e2 / 0.16e2 * t534 * t754 * t1370 * t8895 + 0.15e2 / 0.16e2 * t534 * t9651 * t9653 + 0.11e2 / 0.16e2 * t534 * t9657 * t5238 - 0.3e1 / 0.2e1 * t534 * t9662 + 0.9e1 / 0.8e1 * t534 * t9665 + 0.9e1 / 0.16e2 * t519 * t9670 + 0.11e2 / 0.16e2 * t519 * t9665 - 0.15e2 / 0.32e2 * t519 * t9675 * t9669 - 0.3e1 / 0.8e1 * t1678 * t2585 - 0.3e1 / 0.8e1 * t534 * t7152 * t1384 * t2584 - 0.3e1 / 0.8e1 * t534 * t2582 * t8811 - 0.5e1 / 0.32e2 * t1655 * t2571 + 0.5e1 / 0.32e2 * t1655 * t2575 - 0.3e1 / 0.8e1 * t534 * t9693;
  t9697 = t3108 * t8811;
  t9712 = t607 * t75;
  t9725 = t1360 * t602;
  t9726 = t9725 * t168;
  t9748 = t1622 * t420;
  t9749 = t9668 * t191;
  t9756 = -0.3e1 / 0.8e1 * t534 * t9697 - 0.3e1 / 0.16e2 * t519 * t9697 + 0.3e1 / 0.16e2 * t519 * t6230 * t1372 * t2570 - 0.3e1 / 0.16e2 * t519 * t9693 + 0.3e1 / 0.8e1 * t534 * t1901 * t75 * t1707 + 0.3e1 / 0.8e1 * t534 * t9712 * t6297 - t1678 * t2589 / 0.8e1 - t534 * t9657 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t1911 * t75 * t6360 + 0.3e1 / 0.16e2 * t519 * t2574 * t9726 + t1678 * t2579 / 0.2e1 + t534 * t2625 * t418 * t2372 / 0.2e1 + t534 * t2629 * t418 * t2372 / 0.2e1 + 0.11e2 / 0.16e2 * t534 * t9670 + 0.3e1 / 0.8e1 * t534 * t2594 * t9653 + 0.3e1 / 0.8e1 * t534 * t9657 * t5324 - 0.11e2 / 0.32e2 * t519 * t9748 * t9749 + 0.3e1 / 0.32e2 * t519 * t2598 * t7300;
  t9777 = t2569 * t528;
  t9789 = t9725 * t191;
  t9799 = t2568 * t7300;
  t9805 = -t534 * t754 * t438 * t1361 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t9662 + 0.5e1 / 0.32e2 * t1655 * t2599 - t1678 * t2595 / 0.4e1 + 0.3e1 / 0.16e2 * t1681 * t2599 - 0.3e1 / 0.8e1 * t1678 * t2571 + 0.3e1 / 0.16e2 * t1681 * t2575 - t534 * t2594 * t8811 / 0.4e1 + 0.3e1 / 0.16e2 * t519 * t6444 * t9777 + 0.3e1 / 0.8e1 * t1678 * t2603 - 0.3e1 / 0.16e2 * t1681 * t2571 - t534 * t1937 * t170 * t2584 / 0.4e1 + 0.3e1 / 0.16e2 * t519 * t6444 * t9789 + t534 * t2578 * t5182 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2582 * t6445 - 0.3e1 / 0.32e2 * t519 * t9799 + 0.3e1 / 0.32e2 * t519 * t2574 * t7300;
  t9811 = t1628 * t1372;
  t9838 = 0.3e1 / 0.16e2 * t534 * t2602 * t5172 - 0.3e1 / 0.16e2 * t534 * t9799 - 0.9e1 / 0.16e2 * t519 * t9811 * t9749 - t534 * t2594 * t6445 / 0.8e1 - 0.3e1 / 0.16e2 * t9521 + 0.3e1 / 0.16e2 * t9523 - 0.3e1 / 0.32e2 * t9525 + 0.3e1 / 0.32e2 * t9527 - t9529 / 0.16e2 - 0.3e1 / 0.16e2 * t9531 - t9533 / 0.8e1 + 0.3e1 / 0.32e2 * t9535 + t9537 / 0.4e1 - t1655 * t2619 / 0.16e2 - t519 * t539 * t7169 / 0.32e2 - t6184 * t755 / 0.16e2 - t1678 * t2626 / 0.8e1 - t1678 * t2630 / 0.8e1;
  t9886 = t1678 * t2610 / 0.8e1 + t534 * t7248 * t762 / 0.16e2 + t534 * t1937 * t2385 / 0.8e1 + t1678 * t2613 / 0.8e1 + t534 * t611 * t9019 / 0.16e2 + t6184 * t763 / 0.16e2 - t6320 * t751 / 0.32e2 - t6261 * t751 / 0.16e2 - t6265 * t751 / 0.32e2 - t534 * t1892 * t191 * t445 / 0.16e2 - t534 * t602 * t528 * t445 / 0.8e1 - t534 * t207 * t1613 * t445 / 0.16e2 + t6184 * t759 / 0.16e2 + t1678 * t2635 / 0.8e1 + t1678 * t2638 / 0.8e1 + t534 * t7103 * t758 / 0.16e2 + t534 * t1907 * t2415 / 0.8e1;
  t9914 = t534 * t615 * t8923 / 0.16e2 - t1681 * t2616 / 0.16e2 - t1655 * t2616 / 0.16e2 - t519 * t6180 * t597 / 0.32e2 - t519 * t1692 * t1933 / 0.16e2 - t1681 * t2619 / 0.16e2 - t9558 / 0.32e2 - t9560 / 0.32e2 - t9562 / 0.16e2 - t9564 / 0.16e2 - t9566 / 0.16e2 + t9568 / 0.16e2 + t9570 / 0.16e2 + t9572 / 0.16e2 - t9574 / 0.32e2 + t9604 / 0.16e2 + t9606 / 0.16e2 + t9608 / 0.16e2;
  t9917 = -t9610 / 0.32e2 + t9416 + t9422 - t9428 - t9434 - t8837 - t8839 + t8843 - t8856 + t8868 + t8878 + t8886 - t8902 - t8916 + t8932 - t8934 - t8949 - t8954;
  t9918 = t8979 + t8983 + t9014 - t9018 - t9024 + t9027 - t9030 + t9033 - t9034 - t9075 - t9081 + t8568 + t9083 + t9084 - t9085 - t9086 - t9087 - t9088;
  t9922 = my_piecewise3(t51, 0, t9696 + t9756 + t9805 + t9838 + t9886 + t9914 + t9917 + t9918);
  tv4rho2sigmalapl17 = t3 * t9922 + 0.2e1 * t2645;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t9925 = t7399 * t4329;
  t9929 = t4276 * t213;
  t9930 = t9929 * t261;
  t9931 = t5812 * t9930;
  t9934 = t771 * t261;
  t9938 = t2677 * t8271;
  t9947 = t1419 * t2678;
  t9949 = t1419 * t2669;
  t9953 = t7472 * t945;
  t9974 = -t699 + 0.15e2 / 0.16e2 * t484 * t9925 * t9104 + 0.11e2 / 0.16e2 * t469 * t9931 + 0.11e2 / 0.16e2 * t484 * t9934 * t4343 - 0.3e1 / 0.2e1 * t484 * t9938 + 0.9e1 / 0.8e1 * t484 * t9931 - 0.25e2 / 0.16e2 * t484 * t2005 * t4321 * t9104 + t9947 / 0.4e1 - 0.3e1 / 0.16e2 * t9949 - 0.3e1 / 0.8e1 * t1415 * t2669 - 0.3e1 / 0.8e1 * t484 * t9953 * t2457 - 0.3e1 / 0.8e1 * t484 * t2668 * t8459 - 0.5e1 / 0.32e2 * t1503 * t2656 + 0.5e1 / 0.32e2 * t1503 * t2674 + t1415 * t2678 / 0.2e1 + t484 * t2713 * t263 * t2247 / 0.2e1 + t484 * t2717 * t263 * t2247 / 0.2e1;
  t9984 = t2655 * t9104;
  t9987 = t1419 * t2648;
  t9994 = t2050 * t295;
  t9995 = t9994 * t2457;
  t9998 = t938 * t631;
  t9999 = t9998 * t183;
  t10003 = t2655 * t8459;
  t10006 = t2663 * t478;
  t10028 = 0.3e1 / 0.8e1 * t484 * t2659 * t9104 + 0.3e1 / 0.8e1 * t484 * t9934 * t4378 - 0.11e2 / 0.16e2 * t484 * t2651 * t8370 + 0.11e2 / 0.16e2 * t484 * t9984 - t9987 / 0.16e2 - t484 * t9934 * t4311 / 0.16e2 + 0.3e1 / 0.16e2 * t1493 * t2674 - 0.3e1 / 0.8e1 * t484 * t9995 + 0.3e1 / 0.16e2 * t469 * t5804 * t9999 - 0.3e1 / 0.8e1 * t484 * t10003 + 0.3e1 / 0.16e2 * t469 * t5804 * t10006 - t1415 * t2660 / 0.4e1 + 0.3e1 / 0.8e1 * t1415 * t2652 - 0.3e1 / 0.16e2 * t1493 * t2656 + 0.3e1 / 0.8e1 * t484 * t2713 * t43 * t2270 - 0.3e1 / 0.16e2 * t469 * t9995 + 0.3e1 / 0.8e1 * t484 * t2717 * t43 * t2270 - 0.3e1 / 0.16e2 * t469 * t10003;
  t10051 = t1419 * t2660;
  t10053 = t1499 * t2665;
  t10055 = t1419 * t2652;
  t10057 = t1499 * t2656;
  t10074 = -0.3e1 / 0.8e1 * t1415 * t2656 + 0.3e1 / 0.16e2 * t469 * t5799 * t9999 - t484 * t2659 * t8459 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5799 * t10006 - t1415 * t2648 / 0.8e1 - t484 * t2713 * t111 * t1031 / 0.8e1 - t484 * t2717 * t111 * t1031 / 0.8e1 - t10051 / 0.8e1 + 0.3e1 / 0.32e2 * t10053 + 0.3e1 / 0.16e2 * t10055 - 0.3e1 / 0.32e2 * t10057 + 0.3e1 / 0.16e2 * t484 * t2651 * t4243 + 0.9e1 / 0.16e2 * t469 * t9984 - t484 * t771 * t283 * t1031 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t9938 + 0.5e1 / 0.32e2 * t1503 * t2665 + 0.3e1 / 0.16e2 * t1493 * t2665;
  t10075 = t2013 * t113;
  t10085 = t9929 * t183;
  t10089 = t9096 * t7605;
  t10104 = t1419 * t2656;
  t10106 = t1499 * t2674;
  t10126 = -t484 * t10075 * t2457 / 0.4e1 + t484 * t2677 * t4253 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2668 * t5784 - 0.15e2 / 0.32e2 * t469 * t9264 * t10085 - 0.3e1 / 0.32e2 * t469 * t10089 + 0.3e1 / 0.32e2 * t469 * t2481 * t7605 - t484 * t2659 * t5784 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t9288 * t10085 + 0.3e1 / 0.32e2 * t469 * t2465 * t7605 - 0.3e1 / 0.16e2 * t10104 + 0.3e1 / 0.32e2 * t10106 - 0.3e1 / 0.16e2 * t484 * t10089 - 0.9e1 / 0.16e2 * t469 * t9277 * t10085 + t1415 * t2689 / 0.8e1 + t484 * t7510 * t745 / 0.16e2 - t1415 * t2714 / 0.8e1 - t1415 * t2718 / 0.8e1 - t484 * t2065 * t183 * t290 / 0.16e2;
  t10145 = t1419 * t2723;
  t10147 = t1419 * t2681;
  t10149 = t5505 * t778;
  t10151 = t5505 * t772;
  t10153 = t1419 * t2714;
  t10155 = t1419 * t2718;
  t10157 = t5505 * t775;
  t10159 = t1419 * t2689;
  t10161 = t5676 * t768;
  t10163 = t5659 * t768;
  t10168 = -t484 * t631 * t478 * t290 / 0.8e1 - t484 * t213 * t1434 * t290 / 0.16e2 + t5521 * t775 / 0.16e2 + t1415 * t2723 / 0.8e1 + t1415 * t2681 / 0.8e1 - t5521 * t772 / 0.16e2 + t10145 / 0.16e2 + t10147 / 0.16e2 + t10149 / 0.16e2 - t10151 / 0.16e2 - t10153 / 0.16e2 - t10155 / 0.16e2 + t10157 / 0.16e2 + t10159 / 0.16e2 - t10161 / 0.32e2 - t10163 / 0.32e2 - t469 * t5633 * t626 / 0.32e2;
  t10209 = t5655 * t768 / 0.128e3;
  t10211 = t5493 * t778 / 0.64e2;
  t10212 = -t469 * t1447 * t2009 / 0.16e2 - t469 * t489 * t7504 / 0.32e2 + t484 * t2013 * t2299 / 0.8e1 + t484 * t644 * t8402 / 0.16e2 - t5681 * t768 / 0.32e2 - t5685 * t768 / 0.16e2 - t1493 * t2697 / 0.16e2 - t1493 * t2700 / 0.16e2 - t5667 * t768 / 0.32e2 - t1503 * t2697 / 0.16e2 - t1503 * t2700 / 0.16e2 + t484 * t7357 * t741 / 0.16e2 + t484 * t2050 * t2293 / 0.8e1 + t484 * t640 * t8339 / 0.16e2 + t5521 * t778 / 0.16e2 + t1415 * t2686 / 0.8e1 + t10209 - t10211;
  t10215 = t5493 * t772 / 0.64e2;
  t10217 = t5493 * t775 / 0.64e2;
  t10218 = t1499 * t2697;
  t10220 = t1499 * t2700;
  t10222 = t1419 * t2686;
  t10224 = t10215 - t10217 - t10218 / 0.32e2 - t10220 / 0.32e2 + t10222 / 0.16e2 + t8237 + t8241 - t8262 - t8279 - t8281 + t8285 - t8289 - t8295 + t8297 - t8304 + t8332 + t8383 - t8385;
  t10228 = my_piecewise3(t2, 0, t9974 + t10028 + t10074 + t10126 + t10168 + t10212 + t10224 + t9404);
  tv4rho2sigmatau0 = t3 * t10228 + 0.2e1 * t2728;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t10233 = t5960 * t783;
  t10236 = t5964 * t783 / 0.128e3;
  t10239 = t5949 * t787;
  t10242 = t5946 * t787 / 0.64e2;
  t10245 = t5949 * t790;
  t10248 = t5946 * t790 / 0.64e2;
  t10251 = t5949 * t793;
  t10254 = t5946 * t793 / 0.64e2;
  t10255 = -t5975 * t783 / 0.32e2 - t10233 / 0.32e2 + t10236 - t8564 - t8566 + t8568 - t5967 * t787 / 0.16e2 - t10239 / 0.16e2 + t10242 + t5967 * t790 / 0.16e2 + t10245 / 0.16e2 - t10248 + t5967 * t793 / 0.16e2 + t10251 / 0.16e2 - t10254;
  t10256 = my_piecewise3(t51, 0, t10255);
  tv4rho2sigmatau5 = t3 * t10256 + 0.2e1 * t2747;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t10283 = -0.3e1 / 0.16e2 * t1553 * t2669 - 0.3e1 / 0.32e2 * t1548 * t2656 + 0.3e1 / 0.32e2 * t1548 * t2674 + t1553 * t2678 / 0.4e1 - t1553 * t2648 / 0.16e2 - 0.3e1 / 0.16e2 * t1553 * t2656 + 0.3e1 / 0.32e2 * t1548 * t2665 - t1553 * t2660 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2652 + t9947 / 0.8e1 - 0.3e1 / 0.32e2 * t9949 - t9987 / 0.32e2 - t10051 / 0.16e2 + 0.3e1 / 0.64e2 * t10053 + 0.3e1 / 0.32e2 * t10055 - 0.3e1 / 0.64e2 * t10057;
  t10312 = t5838 * t778;
  t10314 = t5838 * t772;
  t10316 = -0.3e1 / 0.32e2 * t10104 + 0.3e1 / 0.64e2 * t10106 - t5835 * t772 / 0.16e2 - t1553 * t2714 / 0.16e2 - t1553 * t2718 / 0.16e2 + t5835 * t775 / 0.16e2 + t1553 * t2723 / 0.16e2 + t1553 * t2681 / 0.16e2 - t5886 * t768 / 0.32e2 - t5873 * t768 / 0.32e2 - t1548 * t2697 / 0.32e2 - t1548 * t2700 / 0.32e2 + t5835 * t778 / 0.16e2 + t1553 * t2686 / 0.16e2 + t1553 * t2689 / 0.16e2 + t10312 / 0.32e2 - t10314 / 0.32e2;
  t10318 = t5838 * t775;
  t10320 = t5870 * t768;
  t10332 = t10318 / 0.32e2 - t10320 / 0.64e2 + t10145 / 0.32e2 + t10147 / 0.32e2 + t10149 / 0.32e2 - t10151 / 0.32e2 - t10153 / 0.32e2 - t10155 / 0.32e2 + t10157 / 0.32e2 + t10159 / 0.32e2 - t10161 / 0.64e2 - t10163 / 0.64e2 + t10209 - t10211 + t10215 - t10217;
  t10336 = -t10218 / 0.64e2 - t10220 / 0.64e2 + t10222 / 0.32e2 - t8591 + t8595 + t8611 - t8613 + t8628 - t8630 + t8640 - t8641 - t8655 - t8666 - t8672 + t8529 - t2357 - t2314;
  t10339 = my_piecewise3(t2, 0, t10283 + t10316 + t10332 + t10336);
  tv4rho2sigmatau6 = t3 * t10339 + t2728 + t2758;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t10345 = t1589 * t2769;
  t10347 = t1589 * t2790;
  t10357 = t1578 * t2769;
  t10359 = t1578 * t2772;
  t10361 = t1589 * t2776;
  t10363 = t1589 * t2780;
  t10365 = t1589 * t2784;
  t10367 = t1578 * t2762;
  t10369 = t1589 * t2766;
  t10373 = -0.3e1 / 0.16e2 * t1585 * t2769 - t1585 * t2790 / 0.8e1 - 0.3e1 / 0.32e2 * t10345 - t10347 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t2762 + 0.3e1 / 0.16e2 * t1585 * t2766 - t1585 * t2784 / 0.16e2 + t1585 * t2776 / 0.4e1 - 0.3e1 / 0.64e2 * t10357 + 0.3e1 / 0.64e2 * t10359 + t10361 / 0.8e1 - 0.3e1 / 0.32e2 * t10363 - t10365 / 0.32e2 + 0.3e1 / 0.64e2 * t10367 + 0.3e1 / 0.32e2 * t10369 - 0.3e1 / 0.16e2 * t1585 * t2780;
  t10378 = t1578 * t2821;
  t10380 = t1589 * t2807;
  t10382 = t1589 * t2811;
  t10384 = t6045 * t783;
  t10386 = t6051 * t783;
  t10388 = t1578 * t2818;
  t10390 = t1589 * t2794;
  t10392 = t6032 * t790;
  t10394 = t1589 * t2799;
  t10396 = t1589 * t2802;
  t10398 = t6032 * t793;
  t10400 = t6032 * t787;
  t10402 = t1589 * t2827;
  t10408 = -0.3e1 / 0.32e2 * t1574 * t2769 + 0.3e1 / 0.32e2 * t1574 * t2772 - t10378 / 0.64e2 + t10380 / 0.32e2 + t10382 / 0.32e2 - t10384 / 0.64e2 - t10386 / 0.64e2 - t10388 / 0.64e2 - t10390 / 0.32e2 + t10392 / 0.32e2 + t10394 / 0.32e2 + t10396 / 0.32e2 + t10398 / 0.32e2 - t10400 / 0.32e2 - t10402 / 0.32e2 - t1574 * t2821 / 0.32e2 + t1585 * t2811 / 0.16e2;
  t10434 = -t6076 * t783 / 0.32e2 - t6079 * t783 / 0.32e2 - t1574 * t2818 / 0.32e2 + t1585 * t2799 / 0.16e2 + t1585 * t2802 / 0.16e2 + t6073 * t793 / 0.16e2 + t1585 * t2807 / 0.16e2 - t1585 * t2827 / 0.16e2 - t1585 * t2794 / 0.16e2 + t6073 * t790 / 0.16e2 - t6073 * t787 / 0.16e2 - t10248 + t10251 / 0.32e2 - t10254 - t10233 / 0.64e2 + t10236;
  t10437 = -t10239 / 0.32e2 + t10242 + t10245 / 0.32e2 + t8681 - t8687 + t8693 - t8695 + t8724 + t8736 - t8740 - t8746 - t8752 - t8771 - t8778 + t8568 - t2336 - t2338;
  t10440 = my_piecewise3(t51, 0, t10373 + t10408 + t10434 + t10437);
  tv4rho2sigmatau11 = t3 * t10440 + t2747 + t2832;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t10455 = -t6000 * t768 / 0.32e2 - t10320 / 0.32e2 + t10209 - t8789 - t8790 + t8529 - t6005 * t772 / 0.16e2 - t10314 / 0.16e2 + t10215 + t6005 * t775 / 0.16e2 + t10318 / 0.16e2 - t10217 + t6005 * t778 / 0.16e2 + t10312 / 0.16e2 - t10211;
  t10456 = my_piecewise3(t2, 0, t10455);
  tv4rho2sigmatau12 = t3 * t10456 + 0.2e1 * t2758;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t10459 = t679 * t1372;
  t10460 = t10459 * t9653;
  t10463 = t2779 * t9653;
  t10482 = t5232 * t219;
  t10483 = t10482 * t416;
  t10491 = t8075 * t5261;
  t10495 = t786 * t416;
  t10499 = t2568 * t10483;
  t10507 = t8008 * t1384;
  t10514 = -t721 - 0.3e1 / 0.2e1 * t534 * t10460 + 0.9e1 / 0.8e1 * t534 * t10463 - 0.11e2 / 0.16e2 * t534 * t2150 * t75 * t6360 + t1678 * t2776 / 0.2e1 + t534 * t2826 * t418 * t2372 / 0.2e1 + t534 * t2793 * t418 * t2372 / 0.2e1 + 0.11e2 / 0.16e2 * t519 * t10463 - 0.15e2 / 0.32e2 * t519 * t9675 * t10483 - 0.25e2 / 0.16e2 * t534 * t786 * t1370 * t8895 + 0.15e2 / 0.16e2 * t534 * t10491 * t9653 + 0.11e2 / 0.16e2 * t534 * t10495 * t5238 + 0.9e1 / 0.16e2 * t519 * t10499 - t534 * t10495 * t5233 / 0.16e2 - 0.3e1 / 0.8e1 * t1678 * t2780 - 0.3e1 / 0.8e1 * t534 * t10507 * t2584 - 0.3e1 / 0.8e1 * t534 * t2779 * t8811;
  t10529 = t10482 * t191;
  t10535 = t2212 * t170;
  t10555 = t1360 * t670;
  t10556 = t10555 * t191;
  t10560 = t2760 * t528;
  t10569 = -0.5e1 / 0.32e2 * t1655 * t2769 + 0.5e1 / 0.32e2 * t1655 * t2772 - t1678 * t2784 / 0.8e1 - t534 * t2826 * t168 * t1361 / 0.8e1 - t534 * t2793 * t168 * t1361 / 0.8e1 - 0.9e1 / 0.16e2 * t519 * t9811 * t10529 - t1678 * t2790 / 0.4e1 - t534 * t10535 * t2584 / 0.4e1 - t534 * t2789 * t8811 / 0.4e1 - t534 * t2789 * t6445 / 0.8e1 + 0.3e1 / 0.8e1 * t534 * t10495 * t5324 + 0.11e2 / 0.16e2 * t534 * t10499 + 0.3e1 / 0.8e1 * t534 * t2789 * t9653 + 0.3e1 / 0.16e2 * t1681 * t2762 + 0.3e1 / 0.16e2 * t519 * t6444 * t10556 + 0.3e1 / 0.16e2 * t519 * t6444 * t10560 + 0.3e1 / 0.16e2 * t1681 * t2772 + 0.3e1 / 0.16e2 * t519 * t7299 * t10556;
  t10585 = t7315 * t10556;
  t10592 = t7315 * t10560;
  t10601 = t3781 * t6445;
  t10618 = 0.3e1 / 0.16e2 * t519 * t7299 * t10560 - 0.11e2 / 0.32e2 * t519 * t9748 * t10529 + 0.3e1 / 0.8e1 * t1678 * t2766 - 0.3e1 / 0.16e2 * t1681 * t2769 + 0.3e1 / 0.8e1 * t534 * t2826 * t75 * t2397 - 0.3e1 / 0.16e2 * t519 * t10585 + 0.3e1 / 0.8e1 * t534 * t2793 * t75 * t2397 - 0.3e1 / 0.16e2 * t519 * t10592 - 0.3e1 / 0.8e1 * t1678 * t2769 - 0.3e1 / 0.8e1 * t534 * t10585 - 0.3e1 / 0.8e1 * t534 * t10592 - 0.3e1 / 0.16e2 * t534 * t10601 - 0.3e1 / 0.16e2 * t534 * t2779 * t6445 - 0.3e1 / 0.32e2 * t519 * t10601 + 0.3e1 / 0.32e2 * t519 * t2574 * t8094 + t534 * t2775 * t5182 / 0.4e1 + 0.3e1 / 0.32e2 * t519 * t2598 * t8094;
  t10651 = 0.3e1 / 0.16e2 * t534 * t2765 * t5172 - t534 * t786 * t438 * t1361 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t10460 + 0.5e1 / 0.32e2 * t1655 * t2762 - 0.3e1 / 0.16e2 * t10345 - t10347 / 0.8e1 - 0.3e1 / 0.32e2 * t10357 + 0.3e1 / 0.32e2 * t10359 + t10361 / 0.4e1 - 0.3e1 / 0.16e2 * t10363 - t10365 / 0.16e2 + 0.3e1 / 0.32e2 * t10367 + 0.3e1 / 0.16e2 * t10369 + t1678 * t2799 / 0.8e1 + t1678 * t2802 / 0.8e1 + t534 * t7989 * t758 / 0.16e2 + t534 * t2193 * t2415 / 0.8e1 - t6184 * t787 / 0.16e2;
  t10694 = -t1678 * t2827 / 0.8e1 - t1678 * t2794 / 0.8e1 - t534 * t2228 * t191 * t445 / 0.16e2 - t519 * t539 * t8126 / 0.32e2 - t6320 * t783 / 0.32e2 - t6261 * t783 / 0.16e2 - t1681 * t2818 / 0.16e2 - t1681 * t2821 / 0.16e2 - t6265 * t783 / 0.32e2 - t1655 * t2818 / 0.16e2 - t1655 * t2821 / 0.16e2 - t519 * t6180 * t665 / 0.32e2 - t519 * t1692 * t2181 / 0.16e2 + t534 * t679 * t9019 / 0.16e2 + t6184 * t793 / 0.16e2 + t1678 * t2807 / 0.8e1 + t1678 * t2811 / 0.8e1;
  t10726 = t534 * t8148 * t762 / 0.16e2 + t534 * t2212 * t2385 / 0.8e1 + t534 * t683 * t8923 / 0.16e2 - t534 * t670 * t528 * t445 / 0.8e1 - t534 * t219 * t1613 * t445 / 0.16e2 + t6184 * t790 / 0.16e2 - t10378 / 0.32e2 + t10380 / 0.16e2 + t10382 / 0.16e2 - t10384 / 0.32e2 - t10386 / 0.32e2 - t10388 / 0.32e2 - t10390 / 0.16e2 + t10392 / 0.16e2 + t10394 / 0.16e2 + t10396 / 0.16e2 + t10398 / 0.16e2 - t10400 / 0.16e2;
  t10729 = -t10402 / 0.16e2 - t10248 - t10254 + t10236 + t10242 - t8837 - t8839 + t8843 - t8856 + t8868 + t8878 + t8886 - t8902 - t8916 + t8932 - t8934 - t8949 - t8954;
  t10733 = my_piecewise3(t51, 0, t10514 + t10569 + t10618 + t10651 + t10694 + t10726 + t10729 + t9918);
  tv4rho2sigmatau17 = t3 * t10733 + 0.2e1 * t2832;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t10736 = t9195 * t111;
  t10748 = t2455 * t10736;
  t10751 = t2466 * t563;
  t10769 = t2845 * t8271;
  t10772 = -t699 + t484 * t9137 * t10736 - 0.3e1 / 0.4e1 * t484 * t2475 * t10736 + 0.3e1 / 0.4e1 * t484 * t9119 * t6651 - t484 * t9119 * t6474 / 0.4e1 - 0.3e1 / 0.4e1 * t484 * t10748 + 0.3e1 / 0.8e1 * t469 * t5804 * t10751 - t484 * t2461 * t10736 / 0.2e1 + 0.3e1 / 0.8e1 * t469 * t5799 * t10751 - 0.3e1 / 0.8e1 * t469 * t10748 - 0.3e1 / 0.16e2 * t1493 * t2846 + 0.3e1 / 0.16e2 * t1493 * t2850 - 0.5e1 / 0.32e2 * t1503 * t2846 - 0.3e1 / 0.2e1 * t484 * t10769;
  t10773 = t2849 * t8250;
  t10776 = t1419 * t2860;
  t10778 = t1419 * t2846;
  t10780 = t1499 * t2850;
  t10784 = t490 * t1726;
  t10793 = t5535 * t261;
  t10794 = t2845 * t10793;
  t10797 = t1419 * t2838;
  t10799 = t1419 * t2842;
  t10809 = 0.9e1 / 0.8e1 * t484 * t10773 + t10776 / 0.8e1 - 0.3e1 / 0.16e2 * t10778 + 0.3e1 / 0.32e2 * t10780 + t1415 * t2860 / 0.4e1 + t484 * t572 * t10784 / 0.8e1 - 0.3e1 / 0.8e1 * t1415 * t2846 + 0.3e1 / 0.8e1 * t484 * t2837 * t8451 + 0.11e2 / 0.16e2 * t484 * t10794 + 0.3e1 / 0.16e2 * t10797 - t10799 / 0.16e2 - t1415 * t2842 / 0.8e1 + 0.5e1 / 0.32e2 * t1503 * t2850 + t1415 * t2853 / 0.2e1 - 0.3e1 / 0.8e1 * t1415 * t2856;
  t10811 = t798 * t261;
  t10815 = t1419 * t2853;
  t10817 = t1419 * t2856;
  t10822 = t1499 * t2846;
  t10839 = t1419 * t2834;
  t10841 = t2845 * t5779;
  t10844 = t5550 * t798;
  t10848 = t1419 * t2866;
  t10850 = -t484 * t10811 * t4311 / 0.16e2 + t10815 / 0.4e1 - 0.3e1 / 0.16e2 * t10817 - 0.11e2 / 0.16e2 * t484 * t10811 * t4316 - 0.3e1 / 0.32e2 * t10822 + 0.3e1 / 0.8e1 * t484 * t10811 * t4378 - t1503 * t2872 / 0.8e1 - t469 * t572 * t6593 / 0.16e2 + 0.3e1 / 0.16e2 * t1493 * t2875 + 0.5e1 / 0.32e2 * t1503 * t2875 + 0.3e1 / 0.32e2 * t469 * t2845 * t4243 - t10839 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t10841 - 0.9e1 / 0.16e2 * t469 * t1515 * t10844 + t10848 / 0.8e1;
  t10851 = t1419 * t2869;
  t10853 = t1499 * t2875;
  t10857 = t496 * t1726;
  t10866 = t5612 * t798;
  t10892 = -t10851 / 0.8e1 + 0.3e1 / 0.32e2 * t10853 + t1415 * t2866 / 0.4e1 + t484 * t576 * t10857 / 0.8e1 - t1415 * t2869 / 0.4e1 - t484 * t2837 * t4239 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t1469 * t10866 + 0.3e1 / 0.32e2 * t469 * t2849 * t4253 + t484 * t2845 * t4253 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2849 * t8420 - t484 * t798 * t283 * t1031 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t10769 - 0.3e1 / 0.32e2 * t469 * t10841 - t1415 * t2834 / 0.4e1 - t484 * t576 * t6593 / 0.8e1;
  t10900 = t1499 * t2872;
  t10906 = t798 * t4327;
  t10921 = 0.3e1 / 0.8e1 * t1415 * t2838 + 0.3e1 / 0.16e2 * t484 * t2837 * t4243 - t10900 / 0.16e2 - t1493 * t2872 / 0.8e1 + 0.11e2 / 0.16e2 * t469 * t10773 - 0.15e2 / 0.32e2 * t469 * t10906 * t8255 - 0.25e2 / 0.16e2 * t484 * t2849 * t8255 + 0.15e2 / 0.16e2 * t484 * t10906 * t8267 + 0.9e1 / 0.16e2 * t469 * t10794 + 0.11e2 / 0.16e2 * t484 * t10811 * t4343 + t8237 + t8241 - t8262 - t8279 - t8281;
  t10922 = t8285 - t8289 - t8295 + t8297 - t8304 + t8332 + t8383 - t8385 + t8390 + t8393 + t8397 - t8399 - t8401 - t8427 + t8436;
  t10924 = t563 * t563;
  t10925 = t100 * t10924;
  t10930 = t984 * t807 / 0.64e2;
  t10938 = t1023 * t800;
  t10940 = t255 * t2888;
  t10942 = t1023 * t804;
  t10954 = t1023 * t807;
  t10956 = -t8445 - t8448 + t99 * t10925 * t301 / 0.8e1 - t10930 + t99 * t10925 * t297 / 0.8e1 + t1020 * t807 / 0.16e2 + t1020 * t810 / 0.16e2 - t10938 / 0.32e2 - t10940 / 0.32e2 - t10942 / 0.16e2 - t1020 * t800 / 0.32e2 - t246 * t2888 / 0.16e2 - t99 * t4460 * t798 * t269 / 0.32e2 - t1020 * t804 / 0.16e2 + t10954 / 0.16e2;
  t10957 = t1023 * t810;
  t10963 = t984 * t800 / 0.128e3;
  t10969 = t984 * t804 / 0.64e2;
  t10971 = t984 * t810 / 0.64e2;
  t10972 = t10957 / 0.16e2 - t99 * t10925 * t290 / 0.8e1 + t10963 - t99 * t260 * t10924 * t269 / 0.16e2 + t10969 - t10971 - t8514 - t8525 + t8529 - t8544 + t8545 + t8546 - t8547 - t8548 - t8549;
  t10976 = my_piecewise3(t2, 0, t10772 + t10809 + t10850 + t10892 + t10921 + t10922 + t10956 + t10972);
  tv4rho2lapl20 = t3 * t10976 + 0.2e1 * t2901;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t10981 = t1167 * t817;
  t10984 = t1170 * t817 / 0.128e3;
  t10987 = t1167 * t821;
  t10990 = t1170 * t821 / 0.64e2;
  t10993 = t1167 * t824;
  t10996 = t1170 * t824 / 0.64e2;
  t10999 = t1167 * t827;
  t11002 = t1170 * t827 / 0.64e2;
  t11003 = -t1164 * t817 / 0.32e2 - t10981 / 0.32e2 + t10984 - t8564 - t8566 + t8568 - t1164 * t821 / 0.16e2 - t10987 / 0.16e2 + t10990 + t1164 * t824 / 0.16e2 + t10993 / 0.16e2 - t10996 + t1164 * t827 / 0.16e2 + t10999 / 0.16e2 - t11002;
  t11004 = my_piecewise3(t51, 0, t11003);
  tv4rho2lapl22 = t3 * t11004 + 0.2e1 * t2920;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t11033 = -t1553 * t2842 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t2846 + 0.3e1 / 0.32e2 * t1548 * t2850 + t1553 * t2853 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2856 + 0.3e1 / 0.16e2 * t1553 * t2838 + t1553 * t2860 / 0.8e1 - 0.3e1 / 0.16e2 * t1553 * t2846 + 0.3e1 / 0.32e2 * t1548 * t2875 - t1553 * t2834 / 0.8e1 - t1548 * t2872 / 0.16e2 + t1553 * t2866 / 0.8e1 - t1553 * t2869 / 0.8e1 + t10776 / 0.16e2;
  t11046 = -0.3e1 / 0.32e2 * t10778 + 0.3e1 / 0.64e2 * t10780 + 0.3e1 / 0.32e2 * t10797 - t10799 / 0.32e2 + t10815 / 0.8e1 - 0.3e1 / 0.32e2 * t10817 - 0.3e1 / 0.64e2 * t10822 - t10839 / 0.16e2 + t10848 / 0.16e2 - t10851 / 0.16e2 + 0.3e1 / 0.64e2 * t10853 - t10900 / 0.32e2 - t8591 + t8595 + t8611;
  t11048 = t1127 * t810;
  t11050 = t1127 * t807;
  t11052 = t1127 * t804;
  t11054 = t1127 * t800;
  t11066 = -t8613 + t8628 - t8630 + t8640 - t8641 + t11048 / 0.32e2 + t11050 / 0.32e2 - t11052 / 0.32e2 - t11054 / 0.64e2 - t1124 * t804 / 0.16e2 + t1124 * t807 / 0.16e2 + t1124 * t810 / 0.16e2 - t1124 * t800 / 0.32e2 - t345 * t2888 / 0.32e2;
  t11072 = -t10930 - t10938 / 0.64e2 - t10940 / 0.64e2 - t10942 / 0.32e2 + t10954 / 0.32e2 + t10957 / 0.32e2 + t10963 + t10969 - t10971 - t8655 - t8666 - t8672 + t8529 - t2357 - t2314;
  t11075 = my_piecewise3(t2, 0, t11033 + t11046 + t11066 + t11072);
  tv4rho2lapl23 = t3 * t11075 + t2901 + t2931;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t11093 = t1578 * t2942;
  t11095 = t1589 * t2945;
  t11097 = t1589 * t2948;
  t11099 = t1589 * t2934;
  t11101 = t1578 * t2938;
  t11103 = t1578 * t2974;
  t11105 = -t1574 * t2971 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t2974 + t1585 * t2959 / 0.8e1 - 0.3e1 / 0.16e2 * t1585 * t2938 + t1585 * t2965 / 0.8e1 - t1585 * t2968 / 0.8e1 - t1585 * t2951 / 0.8e1 + 0.3e1 / 0.16e2 * t1585 * t2955 + 0.3e1 / 0.64e2 * t11093 + t11095 / 0.8e1 - 0.3e1 / 0.32e2 * t11097 - t11099 / 0.32e2 - 0.3e1 / 0.64e2 * t11101 + 0.3e1 / 0.64e2 * t11103;
  t11106 = t1589 * t2959;
  t11108 = t1589 * t2938;
  t11110 = t1589 * t2965;
  t11112 = t1589 * t2968;
  t11114 = t1578 * t2971;
  t11116 = t1589 * t2951;
  t11118 = t1589 * t2955;
  t11130 = t11106 / 0.16e2 - 0.3e1 / 0.32e2 * t11108 + t11110 / 0.16e2 - t11112 / 0.16e2 - t11114 / 0.32e2 - t11116 / 0.16e2 + 0.3e1 / 0.32e2 * t11118 - 0.3e1 / 0.32e2 * t1574 * t2938 + 0.3e1 / 0.32e2 * t1574 * t2942 + t1585 * t2945 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2948 - t1585 * t2934 / 0.16e2 + t8681 - t8687 + t8693;
  t11132 = t1227 * t827;
  t11134 = t1227 * t817;
  t11136 = t370 * t2979;
  t11138 = t1227 * t821;
  t11140 = t1227 * t824;
  t11150 = -t8695 + t8724 + t8736 - t8740 - t8746 + t11132 / 0.32e2 - t11134 / 0.64e2 - t11136 / 0.64e2 - t11138 / 0.32e2 + t11140 / 0.32e2 - t367 * t2979 / 0.32e2 - t1224 * t821 / 0.16e2 + t1224 * t824 / 0.16e2 + t1224 * t827 / 0.16e2;
  t11157 = -t1224 * t817 / 0.32e2 - t11002 - t10981 / 0.64e2 + t10984 - t10987 / 0.32e2 + t10990 + t10993 / 0.32e2 - t10996 + t10999 / 0.32e2 - t8752 - t8771 - t8778 + t8568 - t2336 - t2338;
  t11160 = my_piecewise3(t51, 0, t11105 + t11130 + t11150 + t11157);
  tv4rho2lapl25 = t3 * t11160 + t2920 + t2992;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t11175 = -t1196 * t800 / 0.32e2 - t11054 / 0.32e2 + t10963 - t8789 - t8790 + t8529 - t1196 * t804 / 0.16e2 - t11052 / 0.16e2 + t10969 + t1196 * t807 / 0.16e2 + t11050 / 0.16e2 - t10930 + t1196 * t810 / 0.16e2 + t11048 / 0.16e2 - t10971;
  t11176 = my_piecewise3(t2, 0, t11175);
  tv4rho2lapl26 = t3 * t11176 + 0.2e1 * t2931;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t11187 = t3108 * t9726;
  t11190 = t2569 * t602;
  t11200 = t615 * t420;
  t11210 = t815 * t416;
  t11217 = -t721 - t534 * t9712 * t7085 / 0.4e1 + t534 * t9661 * t9726 - 0.3e1 / 0.4e1 * t534 * t2582 * t9726 - 0.3e1 / 0.4e1 * t534 * t11187 + 0.3e1 / 0.8e1 * t519 * t7299 * t11190 - t534 * t2594 * t9726 / 0.2e1 + 0.3e1 / 0.8e1 * t519 * t6444 * t11190 + 0.3e1 / 0.4e1 * t534 * t11200 * t9726 - 0.3e1 / 0.8e1 * t519 * t11187 - t1678 * t2934 / 0.8e1 - 0.3e1 / 0.8e1 * t1678 * t2948 - t534 * t11210 * t5233 / 0.16e2 + 0.3e1 / 0.8e1 * t534 * t11210 * t5324;
  t11224 = t815 * t5247;
  t11237 = t2941 * t8849;
  t11240 = t2937 * t8845;
  t11248 = t6359 * t416;
  t11252 = t2937 * t8910;
  t11255 = t6237 * t815;
  t11261 = -0.5e1 / 0.32e2 * t1655 * t2938 + 0.5e1 / 0.32e2 * t1655 * t2942 + t1678 * t2945 / 0.2e1 - 0.15e2 / 0.32e2 * t519 * t11224 * t8895 - 0.25e2 / 0.16e2 * t534 * t2941 * t8895 + 0.15e2 / 0.16e2 * t534 * t11224 * t8906 + 0.11e2 / 0.16e2 * t534 * t11210 * t5238 + 0.11e2 / 0.16e2 * t519 * t11237 - 0.3e1 / 0.2e1 * t534 * t11240 + 0.9e1 / 0.8e1 * t534 * t11237 + 0.3e1 / 0.8e1 * t534 * t2954 * t8919 - 0.11e2 / 0.16e2 * t534 * t2954 * t11248 + 0.11e2 / 0.16e2 * t534 * t11252 - 0.9e1 / 0.16e2 * t519 * t1628 * t11255 + t1678 * t2965 / 0.4e1;
  t11263 = t546 * t1892;
  t11272 = t6359 * t815;
  t11297 = t540 * t1892;
  t11304 = t534 * t615 * t11263 / 0.8e1 - t1678 * t2968 / 0.4e1 - t534 * t2954 * t5209 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t1622 * t11272 - t1681 * t2971 / 0.8e1 - t1655 * t2971 / 0.8e1 - t519 * t611 * t7169 / 0.16e2 - t1678 * t2951 / 0.4e1 - t534 * t615 * t7169 / 0.8e1 + 0.3e1 / 0.8e1 * t1678 * t2955 + 0.3e1 / 0.16e2 * t534 * t2954 * t5172 + 0.9e1 / 0.16e2 * t519 * t11252 + t1678 * t2959 / 0.4e1 + t534 * t611 * t11297 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2941 * t5182;
  t11317 = t2937 * t8986;
  t11338 = t534 * t2937 * t5182 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2941 * t8997 - t534 * t815 * t438 * t1361 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t11240 - 0.3e1 / 0.32e2 * t519 * t11317 - 0.3e1 / 0.16e2 * t1681 * t2938 + 0.3e1 / 0.16e2 * t1681 * t2942 + 0.3e1 / 0.16e2 * t1681 * t2974 + 0.5e1 / 0.32e2 * t1655 * t2974 + 0.3e1 / 0.32e2 * t519 * t2937 * t5172 - 0.3e1 / 0.8e1 * t1678 * t2938 - 0.3e1 / 0.16e2 * t534 * t11317 + 0.3e1 / 0.32e2 * t11093 + t11095 / 0.4e1 - 0.3e1 / 0.16e2 * t11097;
  t11351 = -t11099 / 0.16e2 - 0.3e1 / 0.32e2 * t11101 + 0.3e1 / 0.32e2 * t11103 + t11106 / 0.8e1 - 0.3e1 / 0.16e2 * t11108 + t11110 / 0.8e1 - t11112 / 0.8e1 - t11114 / 0.16e2 - t11116 / 0.8e1 + 0.3e1 / 0.16e2 * t11118 - t8837 - t8839 + t8843 - t8856 + t8868;
  t11352 = t8878 + t8886 - t8902 - t8916 + t8932 - t8934 - t8949 - t8954 + t8979 + t8983 + t9014 - t9018 - t9024 + t9027 - t9030;
  t11362 = t602 * t602;
  t11363 = t157 * t11362;
  t11386 = t9033 - t9034 - t156 * t5380 * t815 * t424 / 0.32e2 - t1313 * t821 / 0.16e2 + t1313 * t824 / 0.16e2 + t156 * t11363 * t456 / 0.8e1 - t156 * t415 * t11362 * t424 / 0.16e2 - t156 * t11363 * t445 / 0.8e1 + t156 * t11363 * t452 / 0.8e1 + t1313 * t827 / 0.16e2 - t1313 * t817 / 0.32e2 - t409 * t2979 / 0.16e2 + t11132 / 0.16e2 - t11134 / 0.32e2 - t11136 / 0.32e2;
  t11389 = -t11138 / 0.16e2 + t11140 / 0.16e2 - t11002 + t10984 + t10990 - t10996 - t9075 - t9081 + t8568 + t9083 + t9084 - t9085 - t9086 - t9087 - t9088;
  t11393 = my_piecewise3(t51, 0, t11217 + t11261 + t11304 + t11338 + t11351 + t11352 + t11386 + t11389);
  tv4rho2lapl28 = t3 * t11393 + 0.2e1 * t2992;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  t11396 = t835 * t943;
  t11403 = t835 * t261;
  t11407 = t2475 * t9930;
  t11410 = t6516 * t4321;
  t11414 = t2998 * t8271;
  t11427 = t2655 * t9098;
  t11440 = t1419 * t3006;
  t11442 = t1499 * t3009;
  t11444 = -t699 - 0.25e2 / 0.16e2 * t484 * t11396 * t8255 + 0.15e2 / 0.16e2 * t484 * t9925 * t9098 + 0.11e2 / 0.16e2 * t484 * t11403 * t4343 + 0.11e2 / 0.16e2 * t469 * t11407 - 0.15e2 / 0.32e2 * t469 * t11410 * t9930 - 0.3e1 / 0.2e1 * t484 * t11414 + 0.9e1 / 0.8e1 * t484 * t11407 + t1415 * t2999 / 0.2e1 + 0.3e1 / 0.8e1 * t484 * t2659 * t9098 - 0.11e2 / 0.16e2 * t484 * t3012 * t8370 + 0.11e2 / 0.16e2 * t484 * t11427 - t484 * t3057 * t111 * t1031 / 0.8e1 - t484 * t3061 * t111 * t1031 / 0.8e1 - t1415 * t3006 / 0.8e1 - t11440 / 0.16e2 - 0.3e1 / 0.32e2 * t11442;
  t11447 = t3057 * t43;
  t11451 = t3061 * t43;
  t11477 = t1419 * t2999;
  t11482 = t1419 * t3002;
  t11484 = t3057 * t263;
  t11488 = t3061 * t263;
  t11495 = 0.3e1 / 0.8e1 * t1415 * t3013 + 0.3e1 / 0.8e1 * t484 * t11447 * t2270 + 0.3e1 / 0.8e1 * t484 * t11451 * t2270 + 0.3e1 / 0.16e2 * t484 * t3012 * t4243 + 0.9e1 / 0.16e2 * t469 * t11427 - t484 * t11403 * t4311 / 0.16e2 - 0.3e1 / 0.8e1 * t1415 * t3002 - 0.3e1 / 0.8e1 * t484 * t9953 * t2467 - 0.3e1 / 0.8e1 * t484 * t2668 * t10736 - 0.3e1 / 0.16e2 * t1493 * t3009 - 0.5e1 / 0.32e2 * t1503 * t3009 + 0.5e1 / 0.32e2 * t1503 * t2995 + t11477 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t11403 * t4378 - 0.3e1 / 0.16e2 * t11482 + t484 * t11484 * t2247 / 0.2e1 + t484 * t11488 * t2247 / 0.2e1 + 0.3e1 / 0.32e2 * t469 * t3021 * t7605;
  t11497 = t1419 * t3009;
  t11499 = t1499 * t2995;
  t11503 = t9994 * t2467;
  t11506 = t2655 * t10736;
  t11509 = t2655 * t6737;
  t11512 = t9929 * t199;
  t11516 = t1419 * t3018;
  t11518 = t1499 * t3022;
  t11522 = t1419 * t3013;
  t11530 = t2663 * t563;
  t11540 = -0.3e1 / 0.16e2 * t11497 + 0.3e1 / 0.32e2 * t11499 - 0.3e1 / 0.8e1 * t1415 * t3009 - 0.3e1 / 0.8e1 * t484 * t11503 - 0.3e1 / 0.8e1 * t484 * t11506 - 0.3e1 / 0.16e2 * t484 * t11509 - 0.9e1 / 0.16e2 * t469 * t9277 * t11512 - t11516 / 0.8e1 + 0.3e1 / 0.32e2 * t11518 - t1415 * t3018 / 0.4e1 + 0.3e1 / 0.16e2 * t11522 - t484 * t835 * t283 * t1031 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t11414 + 0.3e1 / 0.16e2 * t469 * t5804 * t11530 - 0.3e1 / 0.16e2 * t469 * t11503 - 0.3e1 / 0.16e2 * t469 * t11506 + 0.3e1 / 0.16e2 * t1493 * t2995;
  t11541 = t9998 * t199;
  t11561 = t1771 * t265;
  t11565 = t9998 * t111;
  t11590 = t5505 * t836;
  t11592 = 0.3e1 / 0.16e2 * t469 * t5804 * t11541 - t484 * t10075 * t2467 / 0.4e1 - t484 * t2659 * t10736 / 0.4e1 - t484 * t2659 * t6737 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t9288 * t11512 + 0.3e1 / 0.16e2 * t1493 * t3022 + 0.5e1 / 0.32e2 * t1503 * t3022 + 0.3e1 / 0.16e2 * t469 * t11561 * t2664 + 0.3e1 / 0.16e2 * t469 * t3021 * t11565 + 0.3e1 / 0.32e2 * t469 * t2994 * t7605 + t484 * t2998 * t4253 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2668 * t6737 - 0.3e1 / 0.32e2 * t469 * t11509 - t484 * t213 * t1726 * t290 / 0.16e2 + t5521 * t840 / 0.16e2 + t1415 * t3067 / 0.8e1 + t1415 * t3025 / 0.8e1 - t11590 / 0.16e2;
  t11595 = t1419 * t3058;
  t11597 = t1419 * t3062;
  t11599 = t5505 * t840;
  t11601 = t1419 * t3067;
  t11603 = t1419 * t3025;
  t11605 = t5505 * t844;
  t11607 = t1419 * t3030;
  t11609 = t1419 * t3033;
  t11611 = t5676 * t832;
  t11614 = t5655 * t832 / 0.128e3;
  t11616 = t5493 * t844 / 0.64e2;
  t11618 = t5493 * t836 / 0.64e2;
  t11620 = t5493 * t840 / 0.64e2;
  t11630 = -t11595 / 0.16e2 - t11597 / 0.16e2 + t11599 / 0.16e2 + t11601 / 0.16e2 + t11603 / 0.16e2 + t11605 / 0.16e2 + t11607 / 0.16e2 + t11609 / 0.16e2 - t11611 / 0.32e2 + t11614 - t11616 + t11618 - t11620 - t5667 * t832 / 0.32e2 - t1503 * t3041 / 0.16e2 - t1503 * t3044 / 0.16e2 + t484 * t7357 * t839 / 0.16e2;
  t11646 = t5659 * t832;
  t11648 = t1499 * t3041;
  t11650 = t1499 * t3044;
  t11678 = t484 * t2050 * t2859 / 0.8e1 + t484 * t640 * t10784 / 0.16e2 + t5521 * t844 / 0.16e2 + t1415 * t3030 / 0.8e1 + t1415 * t3033 / 0.8e1 + t484 * t7510 * t843 / 0.16e2 - t11646 / 0.32e2 - t11648 / 0.32e2 - t11650 / 0.32e2 - t1415 * t3058 / 0.8e1 - t484 * t2065 * t199 * t290 / 0.16e2 - t484 * t631 * t563 * t290 / 0.8e1 - t1415 * t3062 / 0.8e1 - t469 * t6486 * t626 / 0.32e2 - t469 * t1771 * t2009 / 0.16e2 - t469 * t572 * t7504 / 0.32e2 - t5521 * t836 / 0.16e2 + t484 * t2013 * t2865 / 0.8e1;
  t11691 = t484 * t644 * t10857 / 0.16e2 - t5681 * t832 / 0.32e2 - t5685 * t832 / 0.16e2 - t1493 * t3041 / 0.16e2 - t1493 * t3044 / 0.16e2 + t8237 + t8241 - t8262 - t8279 - t8281 + t8285 - t8289 - t8295 + t8297 - t8304 + t8332 + t8383 - t8385;
  t11695 = my_piecewise3(t2, 0, t11444 + t11495 + t11540 + t11592 + t11630 + t11678 + t11691 + t9404);
  tv4rho2lapltau0 = t3 * t11695 + 0.2e1 * t3072;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  t11700 = t5960 * t849;
  t11703 = t5964 * t849 / 0.128e3;
  t11706 = t5949 * t853;
  t11709 = t5946 * t853 / 0.64e2;
  t11712 = t5949 * t857;
  t11715 = t5946 * t857 / 0.64e2;
  t11718 = t5949 * t861;
  t11721 = t5946 * t861 / 0.64e2;
  t11722 = -t5975 * t849 / 0.32e2 - t11700 / 0.32e2 + t11703 - t8564 - t8566 + t8568 - t5967 * t853 / 0.16e2 - t11706 / 0.16e2 + t11709 + t5967 * t857 / 0.16e2 + t11712 / 0.16e2 - t11715 + t5967 * t861 / 0.16e2 + t11718 / 0.16e2 - t11721;
  t11723 = my_piecewise3(t51, 0, t11722);
  tv4rho2lapltau3 = t3 * t11723 + 0.2e1 * t3091;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  t11750 = -t1553 * t3006 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3009 + 0.3e1 / 0.32e2 * t1548 * t2995 + t1553 * t2999 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3002 + 0.3e1 / 0.16e2 * t1553 * t3013 - 0.3e1 / 0.16e2 * t1553 * t3009 - t1553 * t3018 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3022 - t11440 / 0.32e2 - 0.3e1 / 0.64e2 * t11442 + t11477 / 0.8e1 - 0.3e1 / 0.32e2 * t11482 - 0.3e1 / 0.32e2 * t11497 + 0.3e1 / 0.64e2 * t11499 - t11516 / 0.16e2;
  t11777 = t5838 * t844;
  t11779 = t5838 * t836;
  t11781 = t5838 * t840;
  t11783 = 0.3e1 / 0.64e2 * t11518 + 0.3e1 / 0.32e2 * t11522 + t1553 * t3030 / 0.16e2 + t1553 * t3033 / 0.16e2 - t5835 * t836 / 0.16e2 - t1553 * t3058 / 0.16e2 - t1553 * t3062 / 0.16e2 + t5835 * t840 / 0.16e2 + t1553 * t3067 / 0.16e2 + t1553 * t3025 / 0.16e2 - t5886 * t832 / 0.32e2 - t5873 * t832 / 0.32e2 - t1548 * t3041 / 0.32e2 - t1548 * t3044 / 0.32e2 + t11777 / 0.32e2 - t11779 / 0.32e2 + t11781 / 0.32e2;
  t11785 = t5870 * t832;
  t11799 = -t11785 / 0.64e2 + t5835 * t844 / 0.16e2 - t11590 / 0.32e2 - t11595 / 0.32e2 - t11597 / 0.32e2 + t11599 / 0.32e2 + t11601 / 0.32e2 + t11603 / 0.32e2 + t11605 / 0.32e2 + t11607 / 0.32e2 + t11609 / 0.32e2 - t11611 / 0.64e2 + t11614 - t11616 + t11618 - t11620;
  t11803 = -t11646 / 0.64e2 - t11648 / 0.64e2 - t11650 / 0.64e2 - t8591 + t8595 + t8611 - t8613 + t8628 - t8630 + t8640 - t8641 - t8655 - t8666 - t8672 + t8529 - t2357 - t2314;
  t11806 = my_piecewise3(t2, 0, t11750 + t11783 + t11799 + t11803);
  tv4rho2lapltau4 = t3 * t11806 + t3072 + t3102;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  t11808 = t1589 * t3117;
  t11810 = t1589 * t3120;
  t11812 = t1589 * t3105;
  t11814 = t1578 * t3109;
  t11816 = t1578 * t3113;
  t11818 = t1578 * t3133;
  t11820 = t1589 * t3124;
  t11822 = t1589 * t3109;
  t11824 = t1589 * t3129;
  t11840 = t11808 / 0.8e1 - 0.3e1 / 0.32e2 * t11810 - t11812 / 0.32e2 - 0.3e1 / 0.64e2 * t11814 + 0.3e1 / 0.64e2 * t11816 + 0.3e1 / 0.64e2 * t11818 + 0.3e1 / 0.32e2 * t11820 - 0.3e1 / 0.32e2 * t11822 - t11824 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t3133 + 0.3e1 / 0.16e2 * t1585 * t3124 - 0.3e1 / 0.16e2 * t1585 * t3109 - t1585 * t3129 / 0.8e1 + t1585 * t3117 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3120 - 0.3e1 / 0.32e2 * t1574 * t3109;
  t11845 = t1589 * t3155;
  t11847 = t1589 * t3158;
  t11849 = t6045 * t849;
  t11851 = t1589 * t3137;
  t11853 = t1589 * t3141;
  t11855 = t6032 * t857;
  t11857 = t1589 * t3146;
  t11875 = 0.3e1 / 0.32e2 * t1574 * t3113 - t1585 * t3105 / 0.16e2 + t11845 / 0.32e2 + t11847 / 0.32e2 - t11849 / 0.64e2 - t11851 / 0.32e2 - t11853 / 0.32e2 + t11855 / 0.32e2 + t11857 / 0.32e2 + t1585 * t3149 / 0.16e2 + t6073 * t861 / 0.16e2 + t1585 * t3155 / 0.16e2 + t1585 * t3158 / 0.16e2 - t1585 * t3137 / 0.16e2 - t1585 * t3141 / 0.16e2 + t6073 * t857 / 0.16e2 + t1585 * t3146 / 0.16e2;
  t11877 = t6051 * t849;
  t11879 = t1578 * t3165;
  t11881 = t1578 * t3168;
  t11883 = t6032 * t853;
  t11885 = t1589 * t3149;
  t11887 = t6032 * t861;
  t11902 = -t11877 / 0.64e2 - t11879 / 0.64e2 - t11881 / 0.64e2 - t11883 / 0.32e2 + t11885 / 0.32e2 + t11887 / 0.32e2 - t6073 * t853 / 0.16e2 - t6076 * t849 / 0.32e2 - t6079 * t849 / 0.32e2 - t1574 * t3165 / 0.32e2 - t1574 * t3168 / 0.32e2 - t11700 / 0.64e2 + t11703 - t11706 / 0.32e2 + t11709 + t11712 / 0.32e2;
  t11904 = -t11715 + t11718 / 0.32e2 - t11721 + t8681 - t8687 + t8693 - t8695 + t8724 + t8736 - t8740 - t8746 - t8752 - t8771 - t8778 + t8568 - t2336 - t2338;
  t11907 = my_piecewise3(t51, 0, t11840 + t11875 + t11902 + t11904);
  tv4rho2lapltau7 = t3 * t11907 + t3091 + t3175;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  t11922 = -t6000 * t832 / 0.32e2 - t11785 / 0.32e2 + t11614 - t8789 - t8790 + t8529 - t6005 * t836 / 0.16e2 - t11779 / 0.16e2 + t11618 + t6005 * t840 / 0.16e2 + t11781 / 0.16e2 - t11620 + t6005 * t844 / 0.16e2 + t11777 / 0.16e2 - t11616;
  t11923 = my_piecewise3(t2, 0, t11922);
  tv4rho2lapltau8 = t3 * t11923 + 0.2e1 * t3102;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  t11936 = t852 * t416;
  t11957 = t3136 * t418;
  t11961 = t3140 * t418;
  t11970 = t3781 * t9669;
  t11973 = -t721 - t534 * t3136 * t168 * t1361 / 0.8e1 - t534 * t3140 * t168 * t1361 / 0.8e1 - t1678 * t3105 / 0.8e1 - t534 * t11936 * t5233 / 0.16e2 - 0.3e1 / 0.8e1 * t1678 * t3120 - 0.3e1 / 0.8e1 * t534 * t10507 * t2570 - 0.3e1 / 0.8e1 * t534 * t2779 * t9726 - 0.3e1 / 0.16e2 * t1681 * t3109 - 0.5e1 / 0.32e2 * t1655 * t3109 + 0.5e1 / 0.32e2 * t1655 * t3113 + 0.3e1 / 0.8e1 * t534 * t11936 * t5324 + t534 * t11957 * t2372 / 0.2e1 + t534 * t11961 * t2372 / 0.2e1 + t1678 * t3117 / 0.2e1 - 0.11e2 / 0.16e2 * t534 * t3123 * t11248 + 0.11e2 / 0.16e2 * t534 * t11970;
  t11979 = t3136 * t75;
  t11983 = t3140 * t75;
  t11994 = t852 * t1370;
  t12004 = t2582 * t10483;
  t12007 = t7135 * t5249;
  t12011 = t3116 * t8845;
  t12018 = t10555 * t207;
  t12022 = t2760 * t602;
  t12026 = t7315 * t12018;
  t12029 = 0.3e1 / 0.8e1 * t534 * t2789 * t9669 + 0.3e1 / 0.8e1 * t1678 * t3124 + 0.3e1 / 0.8e1 * t534 * t11979 * t2397 + 0.3e1 / 0.8e1 * t534 * t11983 * t2397 + 0.3e1 / 0.16e2 * t534 * t3123 * t5172 + 0.9e1 / 0.16e2 * t519 * t11970 - 0.3e1 / 0.8e1 * t1678 * t3109 - 0.25e2 / 0.16e2 * t534 * t11994 * t8895 + 0.15e2 / 0.16e2 * t534 * t10491 * t9669 + 0.11e2 / 0.16e2 * t534 * t11936 * t5238 + 0.11e2 / 0.16e2 * t519 * t12004 - 0.15e2 / 0.32e2 * t519 * t12007 * t10483 - 0.3e1 / 0.2e1 * t534 * t12011 + 0.9e1 / 0.8e1 * t534 * t12004 - 0.7e1 / 0.32e2 * t519 * t12011 + 0.3e1 / 0.16e2 * t519 * t7299 * t12018 + 0.3e1 / 0.16e2 * t519 * t7299 * t12022 - 0.3e1 / 0.16e2 * t519 * t12026;
  t12031 = t7315 * t12022;
  t12040 = t3781 * t7300;
  t12043 = t10482 * t207;
  t12065 = t1907 * t420;
  t12069 = t10555 * t168;
  t12079 = -0.3e1 / 0.16e2 * t519 * t12031 + 0.3e1 / 0.16e2 * t1681 * t3113 - 0.3e1 / 0.8e1 * t534 * t12026 - 0.3e1 / 0.8e1 * t534 * t12031 - 0.3e1 / 0.16e2 * t534 * t12040 - 0.9e1 / 0.16e2 * t519 * t9811 * t12043 - t1678 * t3129 / 0.4e1 - t534 * t10535 * t2570 / 0.4e1 - t534 * t2789 * t9726 / 0.4e1 - t534 * t2789 * t7300 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t9748 * t12043 + 0.3e1 / 0.16e2 * t1681 * t3133 + 0.5e1 / 0.32e2 * t1655 * t3133 + 0.3e1 / 0.16e2 * t519 * t12065 * t2761 + 0.3e1 / 0.16e2 * t519 * t3132 * t12069 + 0.3e1 / 0.32e2 * t519 * t3132 * t8094 + t534 * t3116 * t5182 / 0.4e1;
  t12115 = -0.3e1 / 0.16e2 * t534 * t2779 * t7300 - 0.3e1 / 0.32e2 * t519 * t12040 + 0.3e1 / 0.32e2 * t519 * t3112 * t8094 - t534 * t852 * t438 * t1361 / 0.16e2 + t11808 / 0.4e1 - 0.3e1 / 0.16e2 * t11810 - t11812 / 0.16e2 - 0.3e1 / 0.32e2 * t11814 + 0.3e1 / 0.32e2 * t11816 + 0.3e1 / 0.32e2 * t11818 + 0.3e1 / 0.16e2 * t11820 - 0.3e1 / 0.16e2 * t11822 - t11824 / 0.8e1 + t534 * t2193 * t2958 / 0.8e1 + t534 * t679 * t11297 / 0.16e2 + t6184 * t861 / 0.16e2 - t1678 * t3137 / 0.8e1 - t534 * t2228 * t207 * t445 / 0.16e2;
  t12160 = -t534 * t670 * t602 * t445 / 0.8e1 - t1678 * t3141 / 0.8e1 + t534 * t8148 * t860 / 0.16e2 + t534 * t2212 * t2964 / 0.8e1 + t534 * t683 * t11263 / 0.16e2 - t6320 * t849 / 0.32e2 - t6261 * t849 / 0.16e2 - t1681 * t3165 / 0.16e2 - t1681 * t3168 / 0.16e2 - t534 * t219 * t1892 * t445 / 0.16e2 + t6184 * t857 / 0.16e2 + t1678 * t3146 / 0.8e1 + t1678 * t3149 / 0.8e1 + t534 * t7989 * t856 / 0.16e2 - t6265 * t849 / 0.32e2 - t1655 * t3165 / 0.16e2 - t1655 * t3168 / 0.16e2;
  t12188 = -t519 * t7103 * t665 / 0.32e2 - t519 * t1907 * t2181 / 0.16e2 - t519 * t611 * t8126 / 0.32e2 - t6184 * t853 / 0.16e2 + t1678 * t3155 / 0.8e1 + t1678 * t3158 / 0.8e1 + t11845 / 0.16e2 + t11847 / 0.16e2 - t11849 / 0.32e2 - t11851 / 0.16e2 - t11853 / 0.16e2 + t11855 / 0.16e2 + t11857 / 0.16e2 - t11877 / 0.32e2 - t11879 / 0.32e2 - t11881 / 0.32e2 - t11883 / 0.16e2 + t11885 / 0.16e2;
  t12191 = t11887 / 0.16e2 + t11703 + t11709 - t11715 - t11721 - t8837 - t8839 + t8843 - t8856 + t8868 + t8878 + t8886 - t8902 - t8916 + t8932 - t8934 - t8949 - t8954;
  t12195 = my_piecewise3(t51, 0, t11973 + t12029 + t12079 + t12115 + t12160 + t12188 + t12191 + t9918);
  tv4rho2lapltau11 = t3 * t12195 + 0.2e1 * t3175;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t12198 = t2655 * t11565;
  t12203 = t2005 * t935;
  t12207 = t640 * t935;
  t12226 = t1419 * t3182;
  t12228 = t866 * t261;
  t12232 = t1419 * t3189;
  t12237 = -t699 - 0.3e1 / 0.4e1 * t484 * t12198 - 0.3e1 / 0.8e1 * t469 * t12198 + 0.3e1 / 0.8e1 * t469 * t12203 * t11565 + t484 * t12207 * t11565 - 0.3e1 / 0.4e1 * t484 * t2668 * t11565 + 0.3e1 / 0.4e1 * t484 * t7586 * t7446 - t484 * t7586 * t7424 / 0.4e1 - t484 * t2659 * t11565 / 0.2e1 + 0.3e1 / 0.8e1 * t469 * t5799 * t2663 * t631 - 0.3e1 / 0.16e2 * t12226 - 0.11e2 / 0.16e2 * t484 * t12228 * t4316 + t12232 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t12228 * t4378;
  t12238 = t1419 * t3192;
  t12252 = t866 * t4327;
  t12259 = t3185 * t8250;
  t12268 = t3181 * t10793;
  t12276 = -0.3e1 / 0.16e2 * t12238 - 0.3e1 / 0.16e2 * t1493 * t3182 + 0.3e1 / 0.16e2 * t1493 * t3186 - 0.5e1 / 0.32e2 * t1503 * t3182 + 0.5e1 / 0.32e2 * t1503 * t3186 + t1415 * t3189 / 0.2e1 - 0.3e1 / 0.8e1 * t1415 * t3192 + 0.15e2 / 0.16e2 * t484 * t12252 * t8267 + 0.11e2 / 0.16e2 * t484 * t12228 * t4343 + 0.11e2 / 0.16e2 * t469 * t12259 - 0.15e2 / 0.32e2 * t469 * t12252 * t8255 - 0.25e2 / 0.16e2 * t484 * t3185 * t8255 + 0.11e2 / 0.16e2 * t484 * t12268 + 0.9e1 / 0.16e2 * t469 * t12268 - 0.9e1 / 0.16e2 * t469 * t3185 * t8271;
  t12278 = t3181 * t8271;
  t12289 = t5612 * t866;
  t12307 = t1419 * t3209;
  t12309 = t1499 * t3182;
  t12313 = t1419 * t3196;
  t12315 = -0.3e1 / 0.2e1 * t484 * t12278 + 0.9e1 / 0.8e1 * t484 * t12259 - t484 * t12228 * t4311 / 0.16e2 - t484 * t3199 * t4239 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t1469 * t12289 - t1493 * t3203 / 0.8e1 - t1503 * t3203 / 0.8e1 - t469 * t640 * t7504 / 0.16e2 + 0.3e1 / 0.16e2 * t1493 * t3206 + 0.5e1 / 0.32e2 * t1503 * t3206 + 0.3e1 / 0.32e2 * t469 * t3181 * t4243 - t12307 / 0.8e1 - 0.3e1 / 0.32e2 * t12309 - t1415 * t3209 / 0.4e1 + t12313 / 0.8e1;
  t12316 = t1419 * t3200;
  t12318 = t1499 * t3206;
  t12330 = t3181 * t5779;
  t12333 = t1419 * t3178;
  t12337 = t1419 * t3212;
  t12342 = t1499 * t3203;
  t12351 = -t12316 / 0.8e1 + 0.3e1 / 0.32e2 * t12318 + t1415 * t3196 / 0.4e1 + t484 * t644 * t496 * t2065 / 0.8e1 - t1415 * t3200 / 0.4e1 - 0.7e1 / 0.32e2 * t469 * t12278 - 0.3e1 / 0.32e2 * t469 * t12330 - t12333 / 0.16e2 - t1415 * t3178 / 0.8e1 + 0.3e1 / 0.16e2 * t12337 + 0.3e1 / 0.8e1 * t484 * t3199 * t8451 - t12342 / 0.16e2 - 0.3e1 / 0.8e1 * t1415 * t3182 - 0.3e1 / 0.16e2 * t484 * t12330 - t484 * t644 * t7504 / 0.8e1;
  t12359 = t1419 * t3216;
  t12361 = t1499 * t3186;
  t12382 = 0.3e1 / 0.8e1 * t1415 * t3212 + 0.3e1 / 0.16e2 * t484 * t3199 * t4243 + t12359 / 0.8e1 + 0.3e1 / 0.32e2 * t12361 + t1415 * t3216 / 0.4e1 + t484 * t640 * t490 * t2065 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3185 * t4253 + t484 * t3181 * t4253 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3185 * t8420 - t484 * t866 * t283 * t1031 / 0.16e2 + t8237 + t8241 - t8262 - t8279 - t8281;
  t12385 = t984 * t875 / 0.64e2;
  t12386 = t631 * t631;
  t12387 = t100 * t12386;
  t12396 = t984 * t872 / 0.64e2;
  t12398 = t984 * t878 / 0.64e2;
  t12404 = t1023 * t868;
  t12406 = t255 * t3235;
  t12418 = -t8445 - t8448 - t12385 + t99 * t12387 * t297 / 0.8e1 - t99 * t260 * t12386 * t269 / 0.16e2 + t12396 - t12398 + t99 * t12387 * t301 / 0.8e1 + t1020 * t875 / 0.16e2 - t12404 / 0.32e2 - t12406 / 0.32e2 + t1020 * t878 / 0.16e2 - t1020 * t868 / 0.32e2 - t246 * t3235 / 0.16e2 - t99 * t4460 * t866 * t269 / 0.32e2;
  t12421 = t1023 * t878;
  t12423 = t1023 * t872;
  t12425 = t1023 * t875;
  t12428 = t984 * t868 / 0.128e3;
  t12432 = -t1020 * t872 / 0.16e2 + t12421 / 0.16e2 - t12423 / 0.16e2 + t12425 / 0.16e2 + t12428 - t99 * t12387 * t290 / 0.8e1 - t8514 - t8525 + t8529 - t8544 + t8545 + t8546 - t8547 - t8548 - t8549;
  t12436 = my_piecewise3(t2, 0, t12237 + t12276 + t12315 + t12351 + t12382 + t10922 + t12418 + t12432);
  tv4rho2tau20 = t3 * t12436 + 0.2e1 * t3244;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t12441 = t1167 * t885;
  t12444 = t1170 * t885 / 0.128e3;
  t12447 = t1167 * t889;
  t12450 = t1170 * t889 / 0.64e2;
  t12453 = t1167 * t892;
  t12456 = t1170 * t892 / 0.64e2;
  t12459 = t1167 * t895;
  t12462 = t1170 * t895 / 0.64e2;
  t12463 = -t1164 * t885 / 0.32e2 - t12441 / 0.32e2 + t12444 - t8564 - t8566 + t8568 - t1164 * t889 / 0.16e2 - t12447 / 0.16e2 + t12450 + t1164 * t892 / 0.16e2 + t12453 / 0.16e2 - t12456 + t1164 * t895 / 0.16e2 + t12459 / 0.16e2 - t12462;
  t12464 = my_piecewise3(t51, 0, t12463);
  tv4rho2tau22 = t3 * t12464 + 0.2e1 * t3263;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t12493 = t1553 * t3189 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3192 - 0.3e1 / 0.32e2 * t1548 * t3182 + 0.3e1 / 0.32e2 * t1548 * t3186 + t1553 * t3196 / 0.8e1 - t1553 * t3200 / 0.8e1 + t1553 * t3216 / 0.8e1 - 0.3e1 / 0.16e2 * t1553 * t3182 + 0.3e1 / 0.32e2 * t1548 * t3206 - t1553 * t3209 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t3212 - t1548 * t3203 / 0.16e2 - t1553 * t3178 / 0.16e2 - 0.3e1 / 0.32e2 * t12226;
  t12506 = t12232 / 0.8e1 - 0.3e1 / 0.32e2 * t12238 - t12307 / 0.16e2 - 0.3e1 / 0.64e2 * t12309 + t12313 / 0.16e2 - t12316 / 0.16e2 + 0.3e1 / 0.64e2 * t12318 - t12333 / 0.32e2 + 0.3e1 / 0.32e2 * t12337 - t12342 / 0.32e2 + t12359 / 0.16e2 + 0.3e1 / 0.64e2 * t12361 - t8591 + t8595 + t8611;
  t12518 = t1127 * t878;
  t12520 = t1127 * t875;
  t12522 = t1127 * t872;
  t12524 = t1127 * t868;
  t12526 = -t8613 + t8628 - t8630 + t8640 - t8641 + t1124 * t875 / 0.16e2 + t1124 * t878 / 0.16e2 - t1124 * t868 / 0.32e2 - t345 * t3235 / 0.32e2 - t1124 * t872 / 0.16e2 + t12518 / 0.32e2 + t12520 / 0.32e2 - t12522 / 0.32e2 - t12524 / 0.64e2;
  t12532 = -t12385 + t12396 - t12398 - t12404 / 0.64e2 - t12406 / 0.64e2 + t12421 / 0.32e2 - t12423 / 0.32e2 + t12425 / 0.32e2 + t12428 - t8655 - t8666 - t8672 + t8529 - t2357 - t2314;
  t12535 = my_piecewise3(t2, 0, t12493 + t12506 + t12526 + t12532);
  tv4rho2tau23 = t3 * t12535 + t3244 + t3274;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t12537 = t1578 * t3308;
  t12539 = t1589 * t3311;
  t12541 = t1589 * t3277;
  t12543 = t1589 * t3303;
  t12545 = t1578 * t3285;
  t12547 = t1589 * t3293;
  t12549 = t1578 * t3296;
  t12551 = t1578 * t3299;
  t12553 = t1589 * t3314;
  t12555 = t1589 * t3317;
  t12557 = t1589 * t3281;
  t12559 = t1589 * t3285;
  t12561 = t1589 * t3289;
  t12565 = 0.3e1 / 0.64e2 * t12537 + t12539 / 0.8e1 - 0.3e1 / 0.32e2 * t12541 - t12543 / 0.32e2 - 0.3e1 / 0.64e2 * t12545 - t12547 / 0.16e2 - t12549 / 0.32e2 + 0.3e1 / 0.64e2 * t12551 - t12553 / 0.16e2 + 0.3e1 / 0.32e2 * t12555 + t12557 / 0.16e2 - 0.3e1 / 0.32e2 * t12559 + t12561 / 0.16e2 - t1585 * t3303 / 0.16e2;
  t12590 = -t1585 * t3293 / 0.8e1 - t1574 * t3296 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t3299 + 0.3e1 / 0.16e2 * t1585 * t3317 + t1585 * t3281 / 0.8e1 - 0.3e1 / 0.16e2 * t1585 * t3285 + t1585 * t3289 / 0.8e1 - t1585 * t3314 / 0.8e1 - 0.3e1 / 0.32e2 * t1574 * t3285 + 0.3e1 / 0.32e2 * t1574 * t3308 + t1585 * t3311 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3277 + t8681 - t8687 + t8693;
  t12602 = t1227 * t889;
  t12604 = t1227 * t892;
  t12606 = t1227 * t895;
  t12608 = t1227 * t885;
  t12610 = -t8695 + t8724 + t8736 - t8740 - t8746 - t1224 * t885 / 0.32e2 - t367 * t3324 / 0.32e2 - t1224 * t889 / 0.16e2 + t1224 * t892 / 0.16e2 + t1224 * t895 / 0.16e2 - t12602 / 0.32e2 + t12604 / 0.32e2 + t12606 / 0.32e2 - t12608 / 0.64e2;
  t12611 = t370 * t3324;
  t12617 = -t12611 / 0.64e2 + t12444 - t12447 / 0.32e2 + t12450 + t12453 / 0.32e2 - t12456 + t12459 / 0.32e2 - t12462 - t12441 / 0.64e2 - t8752 - t8771 - t8778 + t8568 - t2336 - t2338;
  t12620 = my_piecewise3(t51, 0, t12565 + t12590 + t12610 + t12617);
  tv4rho2tau25 = t3 * t12620 + t3263 + t3335;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t12635 = -t1196 * t868 / 0.32e2 - t12524 / 0.32e2 + t12428 - t8789 - t8790 + t8529 - t1196 * t872 / 0.16e2 - t12522 / 0.16e2 + t12396 + t1196 * t875 / 0.16e2 + t12520 / 0.16e2 - t12385 + t1196 * t878 / 0.16e2 + t12518 / 0.16e2 - t12398;
  t12636 = my_piecewise3(t2, 0, t12635);
  tv4rho2tau26 = t3 * t12636 + 0.2e1 * t3274;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t12650 = t2760 * t670;
  t12654 = t683 * t420;
  t12658 = t7315 * t12650;
  t12666 = t883 * t416;
  t12676 = -t721 + t534 * t10459 * t12069 - 0.3e1 / 0.4e1 * t534 * t2779 * t12069 - t534 * t8079 * t8029 / 0.4e1 - t534 * t2789 * t12069 / 0.2e1 + 0.3e1 / 0.8e1 * t519 * t6444 * t12650 + 0.3e1 / 0.4e1 * t534 * t12654 * t12069 - 0.3e1 / 0.8e1 * t519 * t12658 - 0.3e1 / 0.4e1 * t534 * t12658 + 0.3e1 / 0.8e1 * t519 * t7299 * t12650 - t534 * t12666 * t5233 / 0.16e2 + 0.3e1 / 0.16e2 * t1681 * t3308 - 0.5e1 / 0.32e2 * t1655 * t3285 + 0.5e1 / 0.32e2 * t1655 * t3308;
  t12691 = t3276 * t8849;
  t12694 = t883 * t5247;
  t12704 = t3284 * t8845;
  t12715 = t1678 * t3311 / 0.2e1 - 0.3e1 / 0.8e1 * t1678 * t3277 + 0.3e1 / 0.8e1 * t534 * t12666 * t5324 - 0.3e1 / 0.16e2 * t1681 * t3285 - t1678 * t3303 / 0.8e1 + 0.11e2 / 0.16e2 * t534 * t12666 * t5238 + 0.11e2 / 0.16e2 * t519 * t12691 - 0.15e2 / 0.32e2 * t519 * t12694 * t8895 - 0.25e2 / 0.16e2 * t534 * t3276 * t8895 + 0.15e2 / 0.16e2 * t534 * t12694 * t8906 - 0.3e1 / 0.2e1 * t534 * t12704 + 0.9e1 / 0.8e1 * t534 * t12691 + 0.3e1 / 0.16e2 * t1681 * t3299 - t1655 * t3296 / 0.8e1 + 0.5e1 / 0.32e2 * t1655 * t3299;
  t12727 = t6247 * t883;
  t12728 = t1622 * t12727;
  t12735 = t3284 * t8986;
  t12738 = t6237 * t883;
  t12759 = -t1678 * t3314 / 0.4e1 + 0.3e1 / 0.8e1 * t1678 * t3317 + 0.3e1 / 0.32e2 * t519 * t3284 * t5172 + 0.3e1 / 0.16e2 * t534 * t3292 * t5172 + 0.9e1 / 0.16e2 * t519 * t12728 + t534 * t679 * t540 * t2228 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t12735 - 0.9e1 / 0.16e2 * t519 * t1628 * t12738 + t534 * t683 * t546 * t2228 / 0.8e1 + t1678 * t3281 / 0.4e1 - 0.3e1 / 0.8e1 * t1678 * t3285 + t1678 * t3289 / 0.4e1 - t1678 * t3293 / 0.4e1 - t534 * t683 * t8126 / 0.8e1 - t1681 * t3296 / 0.8e1;
  t12788 = t6359 * t883;
  t12798 = 0.11e2 / 0.16e2 * t534 * t12728 + 0.3e1 / 0.8e1 * t534 * t3292 * t8919 - 0.11e2 / 0.16e2 * t534 * t3292 * t11248 + t534 * t3284 * t5182 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3276 * t8997 - t534 * t883 * t438 * t1361 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t12704 - 0.3e1 / 0.32e2 * t519 * t12735 + 0.3e1 / 0.32e2 * t519 * t3276 * t5182 - t534 * t3292 * t5209 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t1622 * t12788 - t519 * t679 * t8126 / 0.16e2 + 0.3e1 / 0.32e2 * t12537 + t12539 / 0.4e1 - 0.3e1 / 0.16e2 * t12541;
  t12811 = -t12543 / 0.16e2 - 0.3e1 / 0.32e2 * t12545 - t12547 / 0.8e1 - t12549 / 0.16e2 + 0.3e1 / 0.32e2 * t12551 - t12553 / 0.8e1 + 0.3e1 / 0.16e2 * t12555 + t12557 / 0.8e1 - 0.3e1 / 0.16e2 * t12559 + t12561 / 0.8e1 - t8837 - t8839 + t8843 - t8856 + t8868;
  t12813 = t670 * t670;
  t12818 = t157 * t12813;
  t12845 = t9033 - t9034 - t156 * t415 * t12813 * t424 / 0.16e2 + t156 * t12818 * t452 / 0.8e1 + t156 * t12818 * t456 / 0.8e1 - t156 * t12818 * t445 / 0.8e1 - t1313 * t889 / 0.16e2 + t1313 * t892 / 0.16e2 + t1313 * t895 / 0.16e2 - t1313 * t885 / 0.32e2 - t409 * t3324 / 0.16e2 - t156 * t5380 * t883 * t424 / 0.32e2 - t12602 / 0.16e2 + t12604 / 0.16e2 + t12606 / 0.16e2;
  t12848 = -t12608 / 0.32e2 - t12611 / 0.32e2 + t12444 + t12450 - t12456 - t12462 - t9075 - t9081 + t8568 + t9083 + t9084 - t9085 - t9086 - t9087 - t9088;
  t12852 = my_piecewise3(t51, 0, t12676 + t12715 + t12759 + t12798 + t12811 + t11352 + t12845 + t12848);
  tv4rho2tau28 = t3 * t12852 + 0.2e1 * t3335;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t12854 = t938 * t695;
  t12855 = t12854 * t111;
  t12856 = t9096 * t12855;
  t12857 = t469 * t12856;
  t12860 = t469 * t2481 * t12855;
  t12862 = t484 * t12856;
  t12866 = t484 * t3368 * t263 * t2247;
  t12870 = t484 * t8259 * t945 * t2457;
  t12874 = t484 * t2237 * t43 * t1471;
  t12878 = t484 * t3368 * t111 * t1031;
  t12881 = t469 * t2465 * t12855;
  t12885 = t484 * t2274 * t113 * t2457;
  t12890 = t3337 * t263;
  t12891 = t5703 * t111;
  t12895 = t3337 * t943;
  t12896 = t12895 * t12891;
  t12899 = t3337 * t4327;
  t12900 = t5730 * t111;
  t12907 = t5739 * t111;
  t12911 = t5550 * t111;
  t12912 = t12890 * t12911;
  t12917 = t5535 * t111;
  t12918 = t12890 * t12917;
  t12923 = t1415 * t3369;
  t12925 = t3463 * t2248 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t12890 * t12891 + 0.11e2 / 0.16e2 * t469 * t12896 - 0.15e2 / 0.32e2 * t469 * t12899 * t12900 - 0.25e2 / 0.16e2 * t484 * t12895 * t12900 + 0.15e2 / 0.16e2 * t484 * t12899 * t12907 - 0.3e1 / 0.2e1 * t484 * t12912 + 0.9e1 / 0.8e1 * t484 * t12896 + 0.9e1 / 0.16e2 * t469 * t12918 + t3463 * t2271 / 0.16e2 - 0.3e1 / 0.16e2 * t12923;
  t12929 = t484 * t695 * t478 * t290;
  t12931 = t1463 * t478;
  t12936 = t5483 * t111;
  t12944 = t1493 * t3345;
  t12946 = t1503 * t3345;
  t12949 = t469 * t1447 * t2278;
  t12954 = t1415 * t3352;
  t12957 = t484 * t2274 * t2299;
  t12959 = t2241 * t8462;
  t12962 = -0.3e1 / 0.16e2 * t12929 - 0.3e1 / 0.8e1 * t484 * t2262 * t12931 + 0.3e1 / 0.8e1 * t484 * t3337 * t43 * t12936 - 0.11e2 / 0.32e2 * t469 * t470 * t5612 * t3337 - 0.3e1 / 0.32e2 * t12944 - 0.3e1 / 0.32e2 * t12946 - 0.3e1 / 0.32e2 * t12949 + 0.9e1 / 0.32e2 * t469 * t2241 * t5621 + 0.3e1 / 0.16e2 * t12954 + 0.3e1 / 0.16e2 * t12957 - 0.9e1 / 0.16e2 * t484 * t12959;
  t12969 = t3337 * t111;
  t12981 = t1419 * t3369;
  t12982 = 0.3e1 / 0.32e2 * t12981;
  t12983 = t1419 * t3381;
  t12984 = 0.3e1 / 0.32e2 * t12983;
  t12985 = t1499 * t3345;
  t12986 = 0.3e1 / 0.64e2 * t12985;
  t12987 = t1419 * t3352;
  t12988 = 0.3e1 / 0.32e2 * t12987;
  t12992 = 0.11e2 / 0.16e2 * t484 * t12918 - 0.9e1 / 0.16e2 * t469 * t5803 * t5550 * t3337 - 0.11e2 / 0.16e2 * t484 * t12969 * t4316 + 0.3e1 / 0.8e1 * t484 * t12969 * t4378 - t484 * t12969 * t4311 / 0.16e2 - t3463 * t2243 / 0.16e2 - t12982 + t12984 - t12986 + t12988 + 0.9e1 / 0.16e2 * t484 * t2262 * t5621;
  t13002 = t1415 * t3381;
  t13005 = t484 * t2251 * t2293;
  t13010 = t1525 * t478;
  t13020 = t255 * t3342 / 0.16e2;
  t13023 = t255 * t3384 / 0.8e1;
  t13025 = 0.3e1 / 0.32e2 * t255 * t3387;
  t13027 = t255 * t3372 / 0.32e2;
  t13029 = 0.3e1 / 0.64e2 * t255 * t3375;
  t13031 = 0.3e1 / 0.64e2 * t255 * t3378;
  t13033 = t260 * t111 * t263;
  t13047 = t268 * t111;
  t13048 = t266 * t13047;
  t13051 = t4432 * t111;
  t13052 = t268 * t183;
  t13053 = t266 * t13052;
  t13060 = t111 * t43 * t471;
  t13063 = t296 * t13047;
  t13066 = t114 * t13047;
  t13081 = t13033 * t472 / 0.4e1 + t480 / 0.2e1 + t184 * t111 * t290 / 0.2e1 - t184 * t263 * t491 / 0.2e1 - t184 * t43 * t497 / 0.2e1 - t4428 * t183 * t13048 / 0.2e1 + t13051 * t13053 / 0.2e1 + t993 * t478 * t116 / 0.2e1 + t3358 * t13060 / 0.2e1 - t3358 * t13063 / 0.2e1 - t3358 * t13066 / 0.2e1 - t4446 * t183 * t116 / 0.2e1 - t996 * t478 * t116 / 0.2e1 - t3360 * t13060 / 0.2e1 + t3360 * t13063 / 0.2e1 + t3360 * t13066 / 0.2e1;
  t13090 = t1000 * t3337;
  t13099 = t13023 - t13025 - t13027 - t13029 + t13031 - t99 * t13081 * t690 * t269 / 0.32e2 - t246 * t3372 / 0.16e2 - 0.3e1 / 0.32e2 * t246 * t3375 - 0.3e1 / 0.32e2 * t99 * t13090 * t956 + 0.3e1 / 0.32e2 * t246 * t3378 + 0.3e1 / 0.32e2 * t99 * t13090 * t1036;
  t13119 = 0.3e1 / 0.32e2 * t255 * t3355;
  t13121 = t255 * t3365 / 0.64e2;
  t13123 = 0.3e1 / 0.64e2 * t255 * t3349;
  t13124 = t246 * t3384 / 0.4e1 - 0.3e1 / 0.16e2 * t246 * t3387 - 0.3e1 / 0.16e2 * t246 * t3339 - t246 * t3342 / 0.8e1 + 0.3e1 / 0.32e2 * t246 * t3349 + 0.3e1 / 0.32e2 * t99 * t13090 * t964 + 0.3e1 / 0.16e2 * t246 * t3355 - t246 * t3365 / 0.32e2 + t13119 - t13121 + t13123;
  t13126 = 0.3e1 / 0.32e2 * t255 * t3339;
  t13127 = -t13126 + t3383 - t3347 + t3354 - t3371 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t13131 = my_piecewise3(t2, 0, t13127 + t13124 + t13099 - t13020 + 0.3e1 / 0.16e2 * t13002 + t12992 + t12962 - 0.7e1 / 0.32e2 * t469 * t12912 - t3463 * t2267 / 0.16e2 - 0.9e1 / 0.32e2 * t469 * t12959 - 0.3e1 / 0.8e1 * t12885 + 0.9e1 / 0.32e2 * t12881 + t12925 + 0.9e1 / 0.16e2 * t12874 - 0.3e1 / 0.16e2 * t12878 - 0.9e1 / 0.16e2 * t12870 + 0.3e1 / 0.16e2 * t13005 + 0.3e1 / 0.4e1 * t12866 + 0.9e1 / 0.32e2 * t12860 - 0.9e1 / 0.16e2 * t12862 - 0.9e1 / 0.32e2 * t12857 - t699 + 0.9e1 / 0.32e2 * t469 * t2246 * t5545 + 0.3e1 / 0.4e1 * t484 * t2241 * t5545 - 0.9e1 / 0.16e2 * t484 * t2246 * t13010 - 0.3e1 / 0.16e2 * t484 * t2262 * t8462);
  tv4rhosigma30 = t3 * t13131 + t3391;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t13133 = t1589 * t3424;
  t13134 = 0.3e1 / 0.32e2 * t13133;
  t13135 = t1589 * t3436;
  t13136 = 0.3e1 / 0.32e2 * t13135;
  t13137 = t1578 * t3400;
  t13138 = 0.3e1 / 0.64e2 * t13137;
  t13139 = t1589 * t3407;
  t13140 = 0.3e1 / 0.32e2 * t13139;
  t13141 = t1585 * t3436;
  t13143 = t1585 * t3407;
  t13145 = t1585 * t3424;
  t13147 = t1574 * t3400;
  t13150 = t370 * t3439 / 0.8e1;
  t13152 = 0.3e1 / 0.32e2 * t370 * t3442;
  t13154 = t370 * t3427 / 0.32e2;
  t13156 = 0.3e1 / 0.64e2 * t370 * t3430;
  t13158 = 0.3e1 / 0.64e2 * t370 * t3433;
  t13160 = 0.3e1 / 0.32e2 * t370 * t3410;
  t13162 = t370 * t3420 / 0.64e2;
  t13163 = -t13134 + t13136 - t13138 + t13140 + 0.3e1 / 0.16e2 * t13141 + 0.3e1 / 0.16e2 * t13143 - 0.3e1 / 0.16e2 * t13145 - 0.3e1 / 0.32e2 * t13147 + t13150 - t13152 - t13154 - t13156 + t13158 + t13160 - t13162;
  t13165 = 0.3e1 / 0.32e2 * t370 * t3394;
  t13167 = t370 * t3397 / 0.16e2;
  t13169 = 0.3e1 / 0.64e2 * t370 * t3404;
  t13190 = -t13165 - t13167 + t13169 - t367 * t3420 / 0.32e2 - t367 * t3427 / 0.16e2 - 0.3e1 / 0.32e2 * t367 * t3430 + 0.3e1 / 0.32e2 * t367 * t3433 + t367 * t3439 / 0.4e1 - 0.3e1 / 0.16e2 * t367 * t3442 - 0.3e1 / 0.16e2 * t367 * t3394 - t367 * t3397 / 0.8e1 + 0.3e1 / 0.32e2 * t367 * t3404 + 0.3e1 / 0.16e2 * t367 * t3410 - t2336 - t2338;
  t13192 = my_piecewise3(t51, 0, t13163 + t13190);
  tv4rhosigma39 = t3 * t13192 + t3446;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t13194 = t1553 * t3381;
  t13196 = t1553 * t3369;
  t13198 = t1553 * t3352;
  t13200 = t1548 * t3345;
  t13216 = 0.3e1 / 0.16e2 * t13194 - 0.3e1 / 0.16e2 * t13196 + 0.3e1 / 0.16e2 * t13198 - 0.3e1 / 0.32e2 * t13200 - t12982 + t12984 - t12986 + t12988 - 0.3e1 / 0.16e2 * t345 * t3387 + 0.3e1 / 0.16e2 * t345 * t3355 - t345 * t3365 / 0.32e2 - t345 * t3372 / 0.16e2 - 0.3e1 / 0.32e2 * t345 * t3375 + 0.3e1 / 0.32e2 * t345 * t3378 + t345 * t3384 / 0.4e1;
  t13223 = -0.3e1 / 0.16e2 * t345 * t3339 - t345 * t3342 / 0.8e1 + 0.3e1 / 0.32e2 * t345 * t3349 - t13020 + t13023 - t13025 - t13027 - t13029 + t13031 + t13119 - t13121 + t13123 - t13126 - t2357 - t2314;
  t13225 = my_piecewise3(t2, 0, t13216 + t13223);
  tv4rhosigma310 = t3 * t13225 + t3391;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t13229 = t534 * t2420 * t75 * t1707;
  t13233 = t534 * t3423 * t168 * t1361;
  t13237 = t534 * t2401 * t170 * t2584;
  t13239 = t1360 * t717;
  t13240 = t13239 * t168;
  t13242 = t519 * t2598 * t13240;
  t13244 = t2568 * t13240;
  t13245 = t519 * t13244;
  t13248 = t519 * t2574 * t13240;
  t13250 = t534 * t13244;
  t13254 = t534 * t3423 * t418 * t2372;
  t13258 = t534 * t8899 * t1384 * t2584;
  t13261 = t3392 * t168;
  t13271 = t3392 * t1370;
  t13272 = t6203 * t168;
  t13273 = t13271 * t13272;
  t13276 = t3392 * t5247;
  t13277 = t6209 * t168;
  t13284 = t6218 * t168;
  t13288 = t3392 * t418;
  t13289 = t6237 * t168;
  t13290 = t13288 * t13289;
  t13295 = t6247 * t168;
  t13296 = t13288 * t13295;
  t13301 = -0.11e2 / 0.16e2 * t534 * t13261 * t5298 + 0.3e1 / 0.8e1 * t534 * t13261 * t5324 - t534 * t13261 * t5233 / 0.16e2 + 0.11e2 / 0.16e2 * t519 * t13273 - 0.15e2 / 0.32e2 * t519 * t13276 * t13277 - 0.25e2 / 0.16e2 * t534 * t13271 * t13277 + 0.15e2 / 0.16e2 * t534 * t13276 * t13284 - 0.3e1 / 0.2e1 * t534 * t13290 + 0.9e1 / 0.8e1 * t534 * t13273 + 0.9e1 / 0.16e2 * t519 * t13296 - t3515 * t2382 / 0.16e2;
  t13309 = t534 * t2401 * t2385;
  t13316 = t2371 * t6158;
  t13325 = t1701 * t528;
  t13330 = t6288 * t168;
  t13338 = t3515 * t2430 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t13288 * t13272 + 0.3e1 / 0.16e2 * t13309 + 0.9e1 / 0.16e2 * t534 * t2389 * t6297 - t3515 * t2394 / 0.16e2 - 0.9e1 / 0.16e2 * t534 * t13316 + 0.11e2 / 0.16e2 * t534 * t13296 - 0.9e1 / 0.16e2 * t519 * t7298 * t6237 * t3392 - 0.3e1 / 0.8e1 * t534 * t2389 * t13325 + 0.3e1 / 0.8e1 * t534 * t3392 * t75 * t13330 - 0.11e2 / 0.32e2 * t519 * t520 * t6359 * t3392;
  t13339 = t1681 * t3400;
  t13341 = t1655 * t3400;
  t13344 = t519 * t1692 * t2405;
  t13349 = t1678 * t3436;
  t13352 = t534 * t2367 * t2415;
  t13357 = t1639 * t528;
  t13363 = t1678 * t3424;
  t13367 = t534 * t717 * t528 * t445;
  t13369 = -0.3e1 / 0.32e2 * t13339 - 0.3e1 / 0.32e2 * t13341 - 0.3e1 / 0.32e2 * t13344 + 0.9e1 / 0.32e2 * t519 * t2376 * t6162 + 0.3e1 / 0.16e2 * t13349 + 0.3e1 / 0.16e2 * t13352 + 0.3e1 / 0.4e1 * t534 * t2371 * t6162 - 0.9e1 / 0.16e2 * t534 * t2376 * t13357 + t3515 * t2398 / 0.16e2 - 0.3e1 / 0.16e2 * t13363 - 0.3e1 / 0.16e2 * t13367;
  t13382 = t1678 * t3407;
  t13394 = t415 * t168 * t418;
  t13408 = t423 * t168;
  t13409 = t421 * t13408;
  t13412 = t5352 * t168;
  t13413 = t423 * t191;
  t13414 = t421 * t13413;
  t13420 = t168 * t75;
  t13421 = t13420 * t521;
  t13424 = t451 * t13408;
  t13427 = t171 * t13408;
  t13442 = t13394 * t522 / 0.4e1 + t530 / 0.2e1 + t192 * t168 * t445 / 0.2e1 - t192 * t418 * t541 / 0.2e1 - t192 * t75 * t547 / 0.2e1 - t5348 * t191 * t13409 / 0.2e1 + t13412 * t13414 / 0.2e1 + t1322 * t528 * t173 / 0.2e1 + t3413 * t13421 / 0.2e1 - t3413 * t13424 / 0.2e1 - t3413 * t13427 / 0.2e1 - t5366 * t191 * t173 / 0.2e1 - t1325 * t528 * t173 / 0.2e1 - t3415 * t13421 / 0.2e1 + t3415 * t13424 / 0.2e1 + t3415 * t13427 / 0.2e1;
  t13451 = t1329 * t3392;
  t13464 = -0.3e1 / 0.16e2 * t409 * t3442 + 0.3e1 / 0.16e2 * t409 * t3410 - t409 * t3420 / 0.32e2 - t156 * t13442 * t712 * t424 / 0.32e2 - t409 * t3427 / 0.16e2 - 0.3e1 / 0.32e2 * t409 * t3430 - 0.3e1 / 0.32e2 * t156 * t13451 * t1366 + 0.3e1 / 0.32e2 * t409 * t3433 + 0.3e1 / 0.32e2 * t156 * t13451 * t1374 - 0.3e1 / 0.16e2 * t409 * t3394 - t409 * t3397 / 0.8e1;
  t13471 = 0.3e1 / 0.32e2 * t409 * t3404 + 0.3e1 / 0.32e2 * t156 * t13451 * t1405 + t13150 - t13152 - t13154 - t13156 + t13158 + t13160 - t13162 - t13165 - t13167;
  t13472 = t13169 - t3402 + t3409 - t3426 + t3438 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t13476 = my_piecewise3(t51, 0, t13471 + t13472 + t13464 + t13140 + t13136 - t13138 - t13134 + t409 * t3439 / 0.4e1 - 0.7e1 / 0.32e2 * t519 * t13290 - 0.9e1 / 0.32e2 * t519 * t13316 + t13301 - 0.3e1 / 0.8e1 * t13237 + 0.3e1 / 0.16e2 * t13382 + t13369 - 0.9e1 / 0.16e2 * t13258 - 0.3e1 / 0.16e2 * t13233 + 0.9e1 / 0.16e2 * t13229 + t13338 + 0.3e1 / 0.4e1 * t13254 + 0.9e1 / 0.32e2 * t13248 - 0.9e1 / 0.16e2 * t13250 - 0.3e1 / 0.16e2 * t534 * t2389 * t6158 + 0.9e1 / 0.32e2 * t519 * t2371 * t6297 - t721 + 0.9e1 / 0.32e2 * t13242 - 0.9e1 / 0.32e2 * t13245);
  tv4rhosigma319 = t3 * t13476 + t3446;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t13482 = t3468 * t111;
  t13487 = t484 * t9119 * t8394;
  t13488 = 0.3e1 / 0.16e2 * t13487;
  t13491 = t484 * t3454 * t111 * t1031;
  t13492 = t13491 / 0.16e2;
  t13501 = t4276 * t690 * t111;
  t13505 = t3468 * t263;
  t13506 = t13505 * t12911;
  t13509 = t2475 * t13501;
  t13517 = t8254 * t4321;
  t13518 = t9097 * t111;
  t13522 = t2455 * t12855;
  t13523 = t484 * t13522;
  t13524 = 0.3e1 / 0.16e2 * t13523;
  t13525 = -t699 - t3463 * t2458 / 0.16e2 + t3463 * t2482 / 0.16e2 - t484 * t13482 * t4311 / 0.16e2 + t13488 - t13492 + 0.3e1 / 0.8e1 * t484 * t13482 * t4378 - 0.25e2 / 0.16e2 * t484 * t3468 * t943 * t12900 + 0.15e2 / 0.16e2 * t484 * t9108 * t13501 - 0.3e1 / 0.2e1 * t484 * t13506 + 0.9e1 / 0.8e1 * t484 * t13509 + 0.11e2 / 0.16e2 * t484 * t13505 * t12891 + 0.11e2 / 0.16e2 * t469 * t13509 - 0.15e2 / 0.32e2 * t469 * t13517 * t13518 - t13524;
  t13526 = t469 * t13522;
  t13527 = 0.3e1 / 0.32e2 * t13526;
  t13528 = t8259 * t935;
  t13530 = t469 * t13528 * t2467;
  t13531 = 0.3e1 / 0.32e2 * t13530;
  t13532 = t3454 * t263;
  t13534 = t484 * t13532 * t2247;
  t13535 = t13534 / 0.4e1;
  t13537 = t484 * t2475 * t12855;
  t13538 = 0.3e1 / 0.16e2 * t13537;
  t13539 = t2455 * t13501;
  t13542 = t2455 * t8469;
  t13548 = t484 * t2461 * t12855;
  t13549 = t13548 / 0.8e1;
  t13550 = t2466 * t695;
  t13552 = t469 * t5799 * t13550;
  t13553 = 0.3e1 / 0.32e2 * t13552;
  t13570 = -t13527 + t13531 + t13535 - t13538 + 0.11e2 / 0.16e2 * t484 * t13539 - 0.3e1 / 0.8e1 * t484 * t13542 + t3463 * t2468 / 0.16e2 - t13549 + t13553 + t484 * t2485 * t5545 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2475 * t8469 - t484 * t2471 * t8462 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t13506 - 0.3e1 / 0.16e2 * t469 * t13542 + 0.3e1 / 0.16e2 * t469 * t2481 * t9218;
  t13572 = t9097 * t690;
  t13592 = t5612 * t111;
  t13598 = 0.3e1 / 0.16e2 * t12857;
  t13599 = 0.3e1 / 0.16e2 * t12860;
  t13600 = 0.3e1 / 0.8e1 * t12862;
  t13601 = t12866 / 0.2e1;
  t13602 = 0.3e1 / 0.8e1 * t12870;
  t13603 = 0.3e1 / 0.8e1 * t12874;
  t13604 = t12878 / 0.8e1;
  t13605 = -0.9e1 / 0.16e2 * t469 * t5804 * t13572 + 0.3e1 / 0.8e1 * t484 * t2461 * t13501 - t484 * t2461 * t8469 / 0.4e1 - 0.11e2 / 0.32e2 * t469 * t5799 * t13572 + 0.3e1 / 0.16e2 * t469 * t2465 * t9218 + 0.3e1 / 0.8e1 * t484 * t2471 * t5621 - 0.11e2 / 0.16e2 * t484 * t3468 * t43 * t13592 + 0.9e1 / 0.16e2 * t469 * t13539 - t13598 + t13599 - t13600 + t13601 - t13602 + t13603 - t13604;
  t13606 = 0.3e1 / 0.16e2 * t12881;
  t13607 = t12885 / 0.4e1;
  t13609 = t469 * t2251 * t1750;
  t13610 = t13609 / 0.32e2;
  t13611 = t1415 * t3455;
  t13612 = t13611 / 0.16e2;
  t13615 = t484 * t563 * t695 * t290;
  t13616 = t13615 / 0.16e2;
  t13618 = t1419 * t3493 / 0.8e1;
  t13620 = 0.3e1 / 0.32e2 * t1419 * t3497;
  t13622 = 0.3e1 / 0.64e2 * t1499 * t3473;
  t13624 = 0.3e1 / 0.64e2 * t1499 * t3490;
  t13626 = t1419 * t3477 / 0.16e2;
  t13628 = 0.3e1 / 0.64e2 * t1499 * t3480;
  t13630 = t1419 * t3484 / 0.32e2;
  t13632 = 0.3e1 / 0.32e2 * t1419 * t3469;
  t13634 = 0.3e1 / 0.32e2 * t1419 * t3473;
  t13635 = t1419 * t3459;
  t13636 = t13635 / 0.32e2;
  t13638 = t23 * t95 * t3363;
  t13640 = t13638 * t734 / 0.64e2;
  t13641 = t13606 - t13607 - t13610 - t13612 - t13616 + t13618 - t13620 - t13622 + t13624 - t13626 + t13628 - t13630 + t13632 - t13634 + t13636 - t13640;
  t13644 = t1419 * t3448;
  t13645 = t13644 / 0.32e2;
  t13646 = t1499 * t3451;
  t13647 = t13646 / 0.64e2;
  t13648 = t1419 * t3455;
  t13649 = t13648 / 0.32e2;
  t13654 = t563 * t690;
  t13660 = t1771 * t3472;
  t13672 = t1415 * t3459;
  t13673 = t13672 / 0.16e2;
  t13675 = t484 * t1771 * t3458;
  t13676 = t13675 / 0.16e2;
  t13677 = t91 * t3462;
  t13680 = t13645 - t13647 - t13649 - 0.3e1 / 0.32e2 * t1503 * t3473 + 0.3e1 / 0.16e2 * t1415 * t3469 + 0.3e1 / 0.16e2 * t484 * t13654 * t968 - 0.3e1 / 0.16e2 * t1415 * t3473 - 0.3e1 / 0.16e2 * t484 * t13660 - t1415 * t3477 / 0.8e1 - t484 * t1754 * t3476 / 0.8e1 + 0.3e1 / 0.32e2 * t1493 * t3480 + 0.3e1 / 0.32e2 * t1503 * t3480 + t13673 + t13676 - t13677 * t734 / 0.32e2;
  t13682 = t23 * t26 * t13081;
  t13689 = t1415 * t3448;
  t13690 = t13689 / 0.16e2;
  t13692 = t484 * t1754 * t3447;
  t13693 = t13692 / 0.16e2;
  t13694 = t1493 * t3451;
  t13695 = t13694 / 0.32e2;
  t13696 = t1503 * t3451;
  t13697 = t13696 / 0.32e2;
  t13717 = -t13682 * t734 / 0.32e2 - t3463 * t2500 / 0.32e2 - t3463 * t2504 / 0.32e2 + t13690 + t13693 - t13695 - t13697 - 0.3e1 / 0.32e2 * t469 * t13660 + 0.3e1 / 0.32e2 * t1493 * t3490 + 0.3e1 / 0.32e2 * t1503 * t3490 + 0.3e1 / 0.32e2 * t469 * t2246 * t6478 + t1415 * t3493 / 0.4e1 + t484 * t13654 * t939 / 0.4e1 - 0.3e1 / 0.16e2 * t1415 * t3497 - 0.3e1 / 0.16e2 * t484 * t6535 * t3496;
  t13729 = t12923 / 0.8e1;
  t13730 = t12929 / 0.8e1;
  t13731 = t12944 / 0.16e2;
  t13732 = t12946 / 0.16e2;
  t13733 = t12949 / 0.16e2;
  t13734 = t12954 / 0.8e1;
  t13735 = t12957 / 0.8e1;
  t13736 = t12981 / 0.16e2;
  t13737 = t12983 / 0.16e2;
  t13738 = t12985 / 0.32e2;
  t13739 = t12987 / 0.16e2;
  t13740 = 0.3e1 / 0.32e2 * t469 * t2241 * t6651 - t1415 * t3484 / 0.16e2 - t484 * t13654 * t1031 / 0.16e2 - 0.3e1 / 0.32e2 * t1493 * t3473 - t13729 - t13730 - t13731 - t13732 - t13733 + t13734 + t13735 - t13736 + t13737 - t13738 + t13739;
  t13741 = t13002 / 0.8e1;
  t13742 = t13005 / 0.8e1;
  t13743 = t13741 + t13742 + t3450 - t3453 - t3457 + t3461 + t3487 - t3466 + t3467 - t3483 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t13747 = my_piecewise3(t2, 0, t13525 + t13570 + t13605 + t13641 + t13680 + t13717 + t13740 + t13743);
  tv4rhosigma2lapl0 = t3 * t13747 + t3501;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t13753 = t1585 * t3511;
  t13754 = t13753 / 0.16e2;
  t13755 = t128 * t3514;
  t13758 = t1574 * t3518;
  t13759 = t13758 / 0.32e2;
  t13760 = t1585 * t3503;
  t13761 = t13760 / 0.16e2;
  t13762 = t1585 * t3507;
  t13763 = t13762 / 0.16e2;
  t13764 = t1589 * t3503;
  t13765 = t13764 / 0.32e2;
  t13766 = t1589 * t3507;
  t13767 = t13766 / 0.32e2;
  t13768 = t1589 * t3511;
  t13769 = t13768 / 0.32e2;
  t13771 = t60 * t95 * t3418;
  t13773 = t13771 * t751 / 0.64e2;
  t13774 = t1578 * t3518;
  t13775 = t13774 / 0.64e2;
  t13777 = 0.3e1 / 0.64e2 * t1578 * t3531;
  t13779 = 0.3e1 / 0.64e2 * t1578 * t3545;
  t13781 = t1589 * t3548 / 0.8e1;
  t13783 = 0.3e1 / 0.32e2 * t1589 * t3552;
  t13785 = 0.3e1 / 0.32e2 * t1589 * t3531;
  t13787 = t1589 * t3535 / 0.16e2;
  t13789 = t1589 * t3539 / 0.32e2;
  t13790 = 0.3e1 / 0.32e2 * t1574 * t3523 + 0.3e1 / 0.16e2 * t1585 * t3527 + t13754 - t13755 * t751 / 0.32e2 - t13759 - t13761 + t13763 - t13765 + t13767 + t13769 - t13773 - t13775 - t13777 + t13779 + t13781 - t13783 - t13785 - t13787 - t13789;
  t13792 = 0.3e1 / 0.64e2 * t1578 * t3523;
  t13794 = 0.3e1 / 0.32e2 * t1589 * t3527;
  t13809 = t13133 / 0.16e2;
  t13810 = t13135 / 0.16e2;
  t13811 = t13137 / 0.32e2;
  t13812 = t13139 / 0.16e2;
  t13813 = t13141 / 0.8e1;
  t13814 = t13143 / 0.8e1;
  t13815 = t13145 / 0.8e1;
  t13816 = t13147 / 0.16e2;
  t13817 = t13792 + t13794 - 0.3e1 / 0.32e2 * t1574 * t3531 + 0.3e1 / 0.32e2 * t1574 * t3545 + t1585 * t3548 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3552 - 0.3e1 / 0.16e2 * t1585 * t3531 - t1585 * t3535 / 0.8e1 - t1585 * t3539 / 0.16e2 - t13809 + t13810 - t13811 + t13812 + t13813 + t13814 - t13815 - t13816 - t2336 - t2338;
  t13819 = my_piecewise3(t51, 0, t13790 + t13817);
  tv4rhosigma2lapl11 = t3 * t13819 + t3556;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t13837 = t143 * t3462;
  t13842 = t1553 * t3448;
  t13843 = t13842 / 0.16e2;
  t13844 = t1548 * t3451;
  t13845 = t13844 / 0.32e2;
  t13846 = t1553 * t3455;
  t13847 = t13846 / 0.16e2;
  t13848 = t1553 * t3459;
  t13849 = t13848 / 0.16e2;
  t13850 = t1553 * t3493 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3497 - t1553 * t3484 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3473 + 0.3e1 / 0.32e2 * t1548 * t3490 - 0.3e1 / 0.16e2 * t1553 * t3473 - t1553 * t3477 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3480 - t13837 * t734 / 0.32e2 + 0.3e1 / 0.16e2 * t1553 * t3469 + t13843 - t13845 - t13847 + t13849 + t13618 - t13620 - t13622 + t13624 - t13626;
  t13851 = t13194 / 0.8e1;
  t13852 = t13196 / 0.8e1;
  t13853 = t13198 / 0.8e1;
  t13854 = t13200 / 0.16e2;
  t13855 = t13628 - t13630 + t13632 - t13634 + t13636 - t13640 + t13645 - t13647 - t13649 + t13851 - t13852 + t13853 - t13854 - t13736 + t13737 - t13738 + t13739 - t2357 - t2314;
  t13857 = my_piecewise3(t2, 0, t13850 + t13855);
  tv4rhosigma2lapl12 = t3 * t13857 + t3501;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t13860 = t9668 * t168;
  t13861 = t2376 * t1384 * t13860;
  t13864 = t8894 * t5249;
  t13873 = t5232 * t712 * t168;
  t13878 = t534 * t2582 * t13240;
  t13879 = 0.3e1 / 0.16e2 * t13878;
  t13884 = t2371 * t450;
  t13885 = t13884 * t13860;
  t13888 = t2376 * t1372;
  t13892 = t3526 * t418;
  t13893 = t13892 * t13289;
  t13901 = t3502 * t418;
  t13903 = t534 * t13901 * t2372;
  t13904 = t13903 / 0.4e1;
  t13907 = -t721 + 0.11e2 / 0.16e2 * t519 * t13861 - 0.15e2 / 0.32e2 * t519 * t13864 * t13860 - 0.25e2 / 0.16e2 * t534 * t3526 * t1370 * t13277 + 0.15e2 / 0.16e2 * t534 * t9651 * t13873 - t13879 - t3515 * t2571 / 0.16e2 + t3515 * t2575 / 0.16e2 + 0.9e1 / 0.16e2 * t519 * t13885 - 0.9e1 / 0.16e2 * t519 * t13888 * t13860 - 0.3e1 / 0.2e1 * t534 * t13893 + 0.9e1 / 0.8e1 * t534 * t13861 + 0.11e2 / 0.16e2 * t534 * t13892 * t13272 + t13904 - 0.7e1 / 0.32e2 * t519 * t13893;
  t13908 = t2568 * t9777;
  t13912 = t6359 * t168;
  t13929 = t2371 * t420;
  t13936 = t3108 * t13240;
  t13937 = t534 * t13936;
  t13938 = 0.3e1 / 0.16e2 * t13937;
  t13939 = t2569 * t717;
  t13941 = t519 * t7299 * t13939;
  t13942 = 0.3e1 / 0.32e2 * t13941;
  t13944 = t534 * t2594 * t13240;
  t13945 = t13944 / 0.8e1;
  t13947 = t519 * t6444 * t13939;
  t13948 = 0.3e1 / 0.32e2 * t13947;
  t13951 = t3502 * t75;
  t13953 = t534 * t13951 * t2397;
  t13954 = 0.3e1 / 0.16e2 * t13953;
  t13955 = -0.3e1 / 0.16e2 * t519 * t13908 - 0.11e2 / 0.16e2 * t534 * t3526 * t75 * t13912 + 0.11e2 / 0.16e2 * t534 * t13885 - 0.3e1 / 0.8e1 * t534 * t13908 + 0.3e1 / 0.8e1 * t534 * t2594 * t13873 - t534 * t2594 * t8829 / 0.4e1 + 0.3e1 / 0.16e2 * t519 * t2598 * t9777 - 0.11e2 / 0.32e2 * t519 * t13929 * t13860 + 0.3e1 / 0.8e1 * t534 * t2602 * t6297 - t13938 + t13942 - t13945 + t13948 + t3515 * t2599 / 0.16e2 + t13954;
  t13957 = t519 * t13936;
  t13958 = 0.3e1 / 0.32e2 * t13957;
  t13971 = t3526 * t168;
  t13980 = t534 * t3502 * t168 * t1361;
  t13981 = t13980 / 0.16e2;
  t13982 = 0.3e1 / 0.8e1 * t13229;
  t13983 = t13233 / 0.8e1;
  t13984 = t13237 / 0.4e1;
  t13985 = 0.3e1 / 0.16e2 * t13242;
  t13986 = 0.3e1 / 0.16e2 * t13245;
  t13987 = 0.3e1 / 0.16e2 * t13248;
  t13988 = 0.3e1 / 0.8e1 * t13250;
  t13989 = -t13958 + 0.3e1 / 0.16e2 * t519 * t2574 * t9777 + t534 * t2578 * t6162 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2582 * t8829 - t534 * t2602 * t6158 / 0.8e1 + 0.3e1 / 0.8e1 * t534 * t13971 * t5324 - t534 * t13971 * t5233 / 0.16e2 - t13981 + t13982 - t13983 - t13984 + t13985 - t13986 + t13987 - t13988;
  t13990 = t13254 / 0.2e1;
  t13991 = 0.3e1 / 0.8e1 * t13258;
  t13993 = t534 * t1907 * t3506;
  t13994 = t13993 / 0.16e2;
  t13995 = t1678 * t3511;
  t13996 = t13995 / 0.16e2;
  t13998 = t534 * t1937 * t3510;
  t13999 = t13998 / 0.16e2;
  t14011 = t602 * t712;
  t14017 = t1907 * t3530;
  t14022 = t153 * t3514;
  t14026 = t60 * t26 * t13442;
  t14029 = t13990 - t13991 + t13994 + t13996 + t13999 - 0.3e1 / 0.32e2 * t1681 * t3531 + 0.3e1 / 0.32e2 * t1681 * t3523 + 0.3e1 / 0.32e2 * t1655 * t3523 + 0.3e1 / 0.32e2 * t519 * t2371 * t7214 + 0.3e1 / 0.16e2 * t1678 * t3527 + 0.3e1 / 0.16e2 * t534 * t14011 * t1392 - 0.3e1 / 0.16e2 * t1678 * t3531 - 0.3e1 / 0.16e2 * t534 * t14017 - t1678 * t3535 / 0.8e1 - t14022 * t751 / 0.32e2 - t14026 * t751 / 0.32e2;
  t14036 = t1681 * t3518;
  t14037 = t14036 / 0.32e2;
  t14038 = t1655 * t3518;
  t14039 = t14038 / 0.32e2;
  t14041 = t519 * t2367 * t1933;
  t14042 = t14041 / 0.32e2;
  t14043 = t1678 * t3503;
  t14044 = t14043 / 0.16e2;
  t14047 = t534 * t602 * t717 * t445;
  t14048 = t14047 / 0.16e2;
  t14049 = t1678 * t3507;
  t14050 = t14049 / 0.16e2;
  t14067 = -t3515 * t2616 / 0.32e2 - t3515 * t2619 / 0.32e2 - t14037 - t14039 - t14042 - t14044 - t14048 + t14050 - 0.3e1 / 0.32e2 * t1655 * t3531 - 0.3e1 / 0.32e2 * t519 * t14017 + 0.3e1 / 0.32e2 * t1681 * t3545 + 0.3e1 / 0.32e2 * t1655 * t3545 + 0.3e1 / 0.32e2 * t519 * t2376 * t7089 + t1678 * t3548 / 0.4e1 + t534 * t14011 * t1379 / 0.4e1;
  t14081 = -0.3e1 / 0.16e2 * t1678 * t3552 - 0.3e1 / 0.16e2 * t534 * t7152 * t3551 - t534 * t1937 * t3534 / 0.8e1 - t1678 * t3539 / 0.16e2 - t534 * t14011 * t1361 / 0.16e2 - t13765 + t13767 + t13769 - t13773 - t13775 - t13777 + t13779 + t13781 - t13783 - t13785;
  t14083 = t13309 / 0.8e1;
  t14084 = t13339 / 0.16e2;
  t14085 = t13341 / 0.16e2;
  t14086 = t13344 / 0.16e2;
  t14087 = t13349 / 0.8e1;
  t14088 = t13352 / 0.8e1;
  t14089 = t13363 / 0.8e1;
  t14090 = t13367 / 0.8e1;
  t14091 = t13382 / 0.8e1;
  t14092 = -t13787 - t13789 + t13792 + t13794 + t14083 - t14084 - t14085 - t14086 + t14087 + t14088 - t14089 - t14090 + t14091 - t13809 + t13810;
  t14093 = -t13811 + t13812 + t3509 + t3513 - t3520 - t3505 - t3521 + t3522 - t3538 + t3542 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t14097 = my_piecewise3(t51, 0, t13907 + t13955 + t13989 + t14029 + t14067 + t14081 + t14092 + t14093);
  tv4rhosigma2lapl23 = t3 * t14097 + t3556;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t14099 = t2655 * t13501;
  t14102 = t2655 * t8469;
  t14107 = t2655 * t12855;
  t14108 = t484 * t14107;
  t14109 = 0.3e1 / 0.16e2 * t14108;
  t14110 = t2663 * t695;
  t14112 = t469 * t5804 * t14110;
  t14113 = 0.3e1 / 0.32e2 * t14112;
  t14115 = t484 * t2659 * t12855;
  t14116 = t14115 / 0.8e1;
  t14118 = t469 * t5799 * t14110;
  t14119 = 0.3e1 / 0.32e2 * t14118;
  t14140 = -t699 + 0.11e2 / 0.16e2 * t484 * t14099 - 0.3e1 / 0.8e1 * t484 * t14102 + t3463 * t2665 / 0.16e2 - t14109 + t14113 - t14116 + t14119 - 0.3e1 / 0.8e1 * t484 * t2668 * t8469 - 0.3e1 / 0.16e2 * t469 * t14102 + 0.3e1 / 0.16e2 * t469 * t2481 * t10006 + t484 * t2677 * t5545 / 0.2e1 + 0.3e1 / 0.8e1 * t484 * t2659 * t13501 - t484 * t2659 * t8469 / 0.4e1 - t484 * t2651 * t8462 / 0.8e1;
  t14142 = t9929 * t690;
  t14143 = t470 * t935 * t14142;
  t14149 = t2241 * t265;
  t14150 = t9929 * t111;
  t14163 = t484 * t3568 * t111 * t1031;
  t14164 = t14163 / 0.16e2;
  t14165 = t3575 * t111;
  t14169 = t2668 * t13501;
  t14189 = t484 * t12207 * t12855;
  t14190 = t14189 / 0.4e1;
  t14192 = t484 * t2668 * t12855;
  t14193 = 0.3e1 / 0.16e2 * t14192;
  t14194 = -0.7e1 / 0.32e2 * t469 * t14143 + 0.3e1 / 0.16e2 * t469 * t2465 * t10006 - 0.11e2 / 0.32e2 * t469 * t14149 * t14150 + 0.3e1 / 0.8e1 * t484 * t2651 * t5621 - 0.11e2 / 0.16e2 * t484 * t3575 * t43 * t13592 - t14164 + 0.3e1 / 0.8e1 * t484 * t14165 * t4378 + 0.9e1 / 0.8e1 * t484 * t14169 + 0.11e2 / 0.16e2 * t484 * t3575 * t263 * t12891 + 0.11e2 / 0.16e2 * t469 * t14169 - 0.15e2 / 0.32e2 * t469 * t13517 * t14150 - 0.25e2 / 0.16e2 * t484 * t3575 * t943 * t12900 + 0.15e2 / 0.16e2 * t484 * t9925 * t13501 + t14190 - t14193;
  t14200 = t469 * t14107;
  t14201 = 0.3e1 / 0.32e2 * t14200;
  t14204 = t2246 * t935;
  t14214 = t484 * t7586 * t8394;
  t14215 = 0.3e1 / 0.16e2 * t14214;
  t14216 = -t3463 * t2656 / 0.16e2 + t3463 * t2674 / 0.16e2 - t14201 + 0.9e1 / 0.16e2 * t469 * t14099 - 0.9e1 / 0.16e2 * t469 * t14204 * t14150 - 0.3e1 / 0.2e1 * t484 * t14143 - t484 * t14165 * t4311 / 0.16e2 + t14215 - t13598 + t13599 - t13600 + t13601 - t13602 + t13603 - t13604;
  t14218 = t469 * t2251 * t2009;
  t14219 = t14218 / 0.32e2;
  t14220 = t1415 * t3569;
  t14221 = t14220 / 0.16e2;
  t14222 = t1415 * t3557;
  t14223 = t14222 / 0.16e2;
  t14225 = t484 * t2050 * t3458;
  t14226 = t14225 / 0.16e2;
  t14228 = 0.3e1 / 0.32e2 * t1419 * t3596;
  t14230 = 0.3e1 / 0.64e2 * t1499 * t3579;
  t14232 = 0.3e1 / 0.64e2 * t1499 * t3590;
  t14234 = t1419 * t3593 / 0.8e1;
  t14236 = t1419 * t3582 / 0.16e2;
  t14238 = t1419 * t3585 / 0.32e2;
  t14240 = 0.3e1 / 0.64e2 * t1499 * t3572;
  t14242 = 0.3e1 / 0.32e2 * t1419 * t3576;
  t14244 = 0.3e1 / 0.32e2 * t1419 * t3579;
  t14245 = t1499 * t3565;
  t14246 = t14245 / 0.64e2;
  t14247 = t13606 - t13607 - t14219 - t14221 + t14223 + t14226 - t14228 - t14230 + t14232 + t14234 - t14236 - t14238 + t14240 + t14242 - t14244 - t14246;
  t14250 = t1419 * t3569;
  t14251 = t14250 / 0.32e2;
  t14252 = t1419 * t3557;
  t14253 = t14252 / 0.32e2;
  t14254 = t1419 * t3560;
  t14255 = t14254 / 0.32e2;
  t14257 = t13638 * t768 / 0.64e2;
  t14258 = t2241 * t7424;
  t14272 = t631 * t690;
  t14285 = -t14251 + t14253 + t14255 - t14257 - 0.3e1 / 0.32e2 * t469 * t14258 + 0.3e1 / 0.32e2 * t1493 * t3590 + 0.3e1 / 0.32e2 * t1503 * t3590 + 0.3e1 / 0.32e2 * t469 * t2246 * t7428 + t1415 * t3593 / 0.4e1 + 0.3e1 / 0.16e2 * t1415 * t3576 + 0.3e1 / 0.16e2 * t484 * t14272 * t968 - 0.3e1 / 0.16e2 * t1415 * t3579 - 0.3e1 / 0.16e2 * t484 * t14258 - t1415 * t3582 / 0.8e1 - t484 * t2013 * t3476 / 0.8e1;
  t14288 = t484 * t631 * t695 * t290;
  t14289 = t14288 / 0.16e2;
  t14297 = t1415 * t3560;
  t14298 = t14297 / 0.16e2;
  t14300 = t484 * t2013 * t3447;
  t14301 = t14300 / 0.16e2;
  t14310 = t1493 * t3565;
  t14311 = t14310 / 0.32e2;
  t14312 = t1503 * t3565;
  t14313 = t14312 / 0.32e2;
  t14322 = -t14289 + 0.3e1 / 0.32e2 * t1493 * t3572 + 0.3e1 / 0.32e2 * t1503 * t3572 + 0.3e1 / 0.32e2 * t469 * t2241 * t7446 + t14298 + t14301 - t13677 * t768 / 0.32e2 - t13682 * t768 / 0.32e2 - t3463 * t2697 / 0.32e2 - t3463 * t2700 / 0.32e2 - t14311 - t14313 + t484 * t14272 * t939 / 0.4e1 - 0.3e1 / 0.16e2 * t1415 * t3596 - 0.3e1 / 0.16e2 * t484 * t7472 * t3496;
  t14333 = -t1415 * t3585 / 0.16e2 - t484 * t14272 * t1031 / 0.16e2 - 0.3e1 / 0.32e2 * t1493 * t3579 - 0.3e1 / 0.32e2 * t1503 * t3579 - t13729 - t13730 - t13731 - t13732 - t13733 + t13734 + t13735 - t13736 + t13737 - t13738 + t13739;
  t14334 = t13741 + t13742 + t3559 + t3562 - t3567 - t3571 + t3487 - t3466 + t3467 - t3483 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t14338 = my_piecewise3(t2, 0, t14140 + t14194 + t14216 + t14247 + t14285 + t14322 + t14333 + t14334);
  tv4rhosigma2tau0 = t3 * t14338 + t3600;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t14340 = t1585 * t3601;
  t14341 = t14340 / 0.16e2;
  t14344 = t1574 * t3606;
  t14345 = t14344 / 0.32e2;
  t14346 = t1589 * t3601;
  t14347 = t14346 / 0.32e2;
  t14349 = t13771 * t783 / 0.64e2;
  t14351 = 0.3e1 / 0.32e2 * t1589 * t3620;
  t14353 = 0.3e1 / 0.32e2 * t1589 * t3623;
  t14354 = t1578 * t3606;
  t14355 = t14354 / 0.64e2;
  t14356 = t1589 * t3610;
  t14357 = t14356 / 0.32e2;
  t14358 = t1589 * t3613;
  t14359 = t14358 / 0.32e2;
  t14378 = t14341 - t13755 * t783 / 0.32e2 - t14345 + t14347 - t14349 + t14351 - t14353 - t14355 - t14357 + t14359 + 0.3e1 / 0.32e2 * t1574 * t3634 + t1585 * t3637 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3640 - t1585 * t3629 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t3623 + 0.3e1 / 0.32e2 * t1574 * t3616 + 0.3e1 / 0.16e2 * t1585 * t3620 - 0.3e1 / 0.16e2 * t1585 * t3623 - t1585 * t3626 / 0.8e1;
  t14379 = t1585 * t3610;
  t14380 = t14379 / 0.16e2;
  t14381 = t1585 * t3613;
  t14382 = t14381 / 0.16e2;
  t14384 = 0.3e1 / 0.64e2 * t1578 * t3634;
  t14386 = t1589 * t3637 / 0.8e1;
  t14388 = 0.3e1 / 0.32e2 * t1589 * t3640;
  t14390 = t1589 * t3626 / 0.16e2;
  t14392 = t1589 * t3629 / 0.32e2;
  t14394 = 0.3e1 / 0.64e2 * t1578 * t3623;
  t14396 = 0.3e1 / 0.64e2 * t1578 * t3616;
  t14397 = -t14380 + t14382 + t14384 + t14386 - t14388 - t14390 - t14392 - t14394 + t14396 - t13809 + t13810 - t13811 + t13812 + t13813 + t13814 - t13815 - t13816 - t2336 - t2338;
  t14399 = my_piecewise3(t51, 0, t14378 + t14397);
  tv4rhosigma2tau11 = t3 * t14399 + t3644;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t14415 = t1548 * t3565;
  t14416 = t14415 / 0.32e2;
  t14417 = t1553 * t3569;
  t14418 = t14417 / 0.16e2;
  t14419 = t1553 * t3557;
  t14420 = t14419 / 0.16e2;
  t14421 = t1553 * t3560;
  t14422 = t14421 / 0.16e2;
  t14429 = -0.3e1 / 0.16e2 * t1553 * t3596 - t1553 * t3582 / 0.8e1 - t1553 * t3585 / 0.16e2 + 0.3e1 / 0.32e2 * t1548 * t3572 + 0.3e1 / 0.16e2 * t1553 * t3576 - 0.3e1 / 0.16e2 * t1553 * t3579 - t13837 * t768 / 0.32e2 - t14416 - t14418 + t14420 + t14422 - 0.3e1 / 0.32e2 * t1548 * t3579 + 0.3e1 / 0.32e2 * t1548 * t3590 + t1553 * t3593 / 0.4e1 - t14228 - t14230 + t14232 + t14234 - t14236;
  t14430 = -t14238 + t14240 + t14242 - t14244 - t14246 - t14251 + t14253 + t14255 - t14257 + t13851 - t13852 + t13853 - t13854 - t13736 + t13737 - t13738 + t13739 - t2357 - t2314;
  t14432 = my_piecewise3(t2, 0, t14429 + t14430);
  tv4rhosigma2tau12 = t3 * t14432 + t3600;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t14438 = t2367 * t450;
  t14439 = t14438 * t2761;
  t14440 = t519 * t14439;
  t14441 = 0.3e1 / 0.32e2 * t14440;
  t14442 = t8899 * t1372;
  t14444 = t519 * t14442 * t2761;
  t14445 = 0.3e1 / 0.32e2 * t14444;
  t14446 = t3609 * t418;
  t14448 = t534 * t14446 * t2372;
  t14449 = t14448 / 0.4e1;
  t14451 = t534 * t2779 * t13240;
  t14452 = 0.3e1 / 0.16e2 * t14451;
  t14454 = t534 * t8079 * t8980;
  t14455 = 0.3e1 / 0.16e2 * t14454;
  t14458 = t534 * t3609 * t168 * t1361;
  t14459 = t14458 / 0.16e2;
  t14460 = t3619 * t168;
  t14474 = t10482 * t168;
  t14475 = t13884 * t14474;
  t14481 = -t721 - t3515 * t2769 / 0.16e2 + t3515 * t2772 / 0.16e2 - t14441 + t14445 + t14449 - t14452 + t14455 - t14459 + 0.3e1 / 0.8e1 * t534 * t14460 * t5324 - t534 * t14460 * t5233 / 0.16e2 - 0.25e2 / 0.16e2 * t534 * t3619 * t1370 * t13277 + 0.15e2 / 0.16e2 * t534 * t10491 * t13873 + 0.9e1 / 0.16e2 * t519 * t14475 - 0.9e1 / 0.16e2 * t519 * t13888 * t14474;
  t14482 = t3619 * t418;
  t14483 = t14482 * t13289;
  t14486 = t2779 * t13873;
  t14497 = t534 * t14439;
  t14498 = 0.3e1 / 0.16e2 * t14497;
  t14507 = t2568 * t10560;
  t14523 = -0.3e1 / 0.2e1 * t534 * t14483 + 0.9e1 / 0.8e1 * t534 * t14486 + 0.11e2 / 0.16e2 * t534 * t14482 * t13272 + 0.11e2 / 0.16e2 * t519 * t14486 - 0.15e2 / 0.32e2 * t519 * t13864 * t14474 - t14498 + t534 * t2775 * t6162 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2779 * t8829 - 0.7e1 / 0.32e2 * t519 * t14483 - 0.3e1 / 0.16e2 * t519 * t14507 + 0.3e1 / 0.16e2 * t519 * t2574 * t10560 + 0.11e2 / 0.16e2 * t534 * t14475 - 0.3e1 / 0.8e1 * t534 * t14507 + 0.3e1 / 0.8e1 * t534 * t2789 * t13873 - t534 * t2789 * t8829 / 0.4e1;
  t14537 = t3619 * t75;
  t14542 = t534 * t2789 * t13240;
  t14543 = t14542 / 0.8e1;
  t14544 = t2760 * t717;
  t14546 = t519 * t6444 * t14544;
  t14547 = 0.3e1 / 0.32e2 * t14546;
  t14550 = -t534 * t2765 * t6158 / 0.8e1 + 0.3e1 / 0.16e2 * t519 * t2598 * t10560 - 0.11e2 / 0.32e2 * t519 * t13929 * t14474 + 0.3e1 / 0.8e1 * t534 * t2765 * t6297 - 0.11e2 / 0.16e2 * t534 * t14537 * t13912 - t14543 + t14547 + t3515 * t2762 / 0.16e2 + t13982 - t13983 - t13984 + t13985 - t13986 + t13987 - t13988;
  t14555 = t1681 * t3606;
  t14556 = t14555 / 0.32e2;
  t14557 = t1655 * t3606;
  t14558 = t14557 / 0.32e2;
  t14560 = t519 * t2367 * t2181;
  t14561 = t14560 / 0.32e2;
  t14562 = t1678 * t3610;
  t14563 = t14562 / 0.16e2;
  t14566 = t534 * t670 * t717 * t445;
  t14567 = t14566 / 0.16e2;
  t14568 = t1678 * t3601;
  t14569 = t14568 / 0.16e2;
  t14571 = t534 * t2212 * t3510;
  t14572 = t14571 / 0.16e2;
  t14578 = t670 * t712;
  t14586 = t13990 - t13991 - t3515 * t2818 / 0.32e2 - t3515 * t2821 / 0.32e2 - t14556 - t14558 - t14561 - t14563 - t14567 + t14569 + t14572 - 0.3e1 / 0.16e2 * t534 * t8008 * t3551 - t1678 * t3629 / 0.16e2 - t534 * t14578 * t1361 / 0.16e2 - 0.3e1 / 0.32e2 * t1681 * t3623 - 0.3e1 / 0.32e2 * t1655 * t3623;
  t14589 = t2371 * t8029;
  t14615 = t1678 * t3613;
  t14616 = t14615 / 0.16e2;
  t14618 = t534 * t2193 * t3506;
  t14619 = t14618 / 0.16e2;
  t14624 = -0.3e1 / 0.32e2 * t519 * t14589 + 0.3e1 / 0.32e2 * t1681 * t3634 + 0.3e1 / 0.32e2 * t1655 * t3634 + 0.3e1 / 0.32e2 * t519 * t2376 * t8033 + t1678 * t3637 / 0.4e1 + 0.3e1 / 0.16e2 * t1678 * t3620 + 0.3e1 / 0.16e2 * t534 * t14578 * t1392 - 0.3e1 / 0.16e2 * t1678 * t3623 - 0.3e1 / 0.16e2 * t534 * t14589 - t1678 * t3626 / 0.8e1 - t534 * t2212 * t3534 / 0.8e1 + t14616 + t14619 + 0.3e1 / 0.32e2 * t1681 * t3616 + 0.3e1 / 0.32e2 * t1655 * t3616;
  t14637 = 0.3e1 / 0.32e2 * t519 * t2371 * t8152 - t14022 * t783 / 0.32e2 - t14026 * t783 / 0.32e2 + t534 * t14578 * t1379 / 0.4e1 - 0.3e1 / 0.16e2 * t1678 * t3640 + t14347 - t14349 + t14351 - t14353 - t14355 - t14357 + t14359 + t14384 + t14386 - t14388;
  t14639 = -t14390 - t14392 - t14394 + t14396 + t14083 - t14084 - t14085 - t14086 + t14087 + t14088 - t14089 - t14090 + t14091 - t13809 + t13810;
  t14640 = -t13811 + t13812 + t3603 - t3608 - t3612 + t3615 - t3521 + t3522 - t3538 + t3542 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t14644 = my_piecewise3(t51, 0, t14481 + t14523 + t14550 + t14586 + t14624 + t14637 + t14639 + t14640);
  tv4rhosigma2tau23 = t3 * t14644 + t3644;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t14647 = t9103 * t111;
  t14648 = t2849 * t945 * t14647;
  t14651 = t10906 * t4321;
  t14660 = t2845 * t935 * t14647;
  t14670 = t5535 * t183;
  t14679 = t2455 * t9196;
  t14682 = t4276 * t798;
  t14683 = t14682 * t183;
  t14690 = t576 * t265;
  t14698 = -t699 + 0.11e2 / 0.16e2 * t469 * t14648 - 0.15e2 / 0.32e2 * t469 * t14651 * t14647 - 0.25e2 / 0.16e2 * t484 * t2849 * t4321 * t14647 - 0.3e1 / 0.2e1 * t484 * t14660 + 0.9e1 / 0.8e1 * t484 * t14648 - t484 * t3669 * t111 * t4311 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t2841 * t43 * t14670 - t484 * t2471 * t6474 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t14660 - 0.3e1 / 0.16e2 * t469 * t14679 - 0.11e2 / 0.32e2 * t469 * t5799 * t14683 + 0.3e1 / 0.16e2 * t469 * t3021 * t9196 + 0.3e1 / 0.8e1 * t484 * t14690 * t9196 - 0.11e2 / 0.16e2 * t484 * t2837 * t265 * t14647;
  t14699 = t5783 * t14683;
  t14733 = 0.3e1 / 0.8e1 * t13487;
  t14734 = t13491 / 0.8e1;
  t14735 = 0.3e1 / 0.8e1 * t13523;
  t14736 = 0.3e1 / 0.16e2 * t13526;
  t14737 = 0.9e1 / 0.16e2 * t469 * t14699 - 0.3e1 / 0.8e1 * t484 * t14679 + 0.11e2 / 0.16e2 * t484 * t14699 - 0.9e1 / 0.16e2 * t469 * t5804 * t14683 - t484 * t2461 * t9196 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t2837 * t113 * t14647 + 0.15e2 / 0.16e2 * t484 * t10906 * t4329 * t14647 + 0.11e2 / 0.16e2 * t484 * t3669 * t263 * t12891 + 0.3e1 / 0.16e2 * t469 * t2994 * t9196 + t484 * t9137 * t9196 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2475 * t9196 + t14733 - t14734 - t14735 - t14736;
  t14739 = 0.3e1 / 0.16e2 * t13530;
  t14740 = t13534 / 0.2e1;
  t14741 = 0.3e1 / 0.8e1 * t13537;
  t14742 = t13548 / 0.4e1;
  t14743 = 0.3e1 / 0.16e2 * t13552;
  t14744 = 0.3e1 / 0.32e2 * t12857;
  t14745 = 0.3e1 / 0.32e2 * t12860;
  t14746 = 0.3e1 / 0.16e2 * t12862;
  t14747 = t12866 / 0.4e1;
  t14748 = 0.3e1 / 0.16e2 * t12870;
  t14749 = 0.3e1 / 0.16e2 * t12874;
  t14750 = t12878 / 0.16e2;
  t14751 = 0.3e1 / 0.32e2 * t12881;
  t14752 = t12885 / 0.8e1;
  t14755 = t14739 + t14740 - t14741 - t14742 + t14743 - t14744 + t14745 - t14746 + t14747 - t14748 + t14749 - t14750 + t14751 - t14752 - t3463 * t2872 / 0.16e2;
  t14770 = t2845 * t8462;
  t14779 = 0.3e1 / 0.64e2 * t1499 * t3676;
  t14781 = t1419 * t3679 / 0.8e1;
  t14783 = 0.3e1 / 0.32e2 * t1419 * t3683;
  t14785 = t1419 * t3670 / 0.32e2;
  t14787 = 0.3e1 / 0.64e2 * t1499 * t3649;
  t14789 = 0.3e1 / 0.64e2 * t1499 * t3656;
  t14790 = 0.3e1 / 0.32e2 * t1493 * t3656 + 0.3e1 / 0.32e2 * t1503 * t3656 + 0.3e1 / 0.32e2 * t469 * t2845 * t5621 + 0.3e1 / 0.16e2 * t1415 * t3645 + 0.3e1 / 0.16e2 * t484 * t2837 * t5621 - 0.3e1 / 0.16e2 * t1415 * t3649 - 0.3e1 / 0.16e2 * t484 * t14770 - t1415 * t3653 / 0.8e1 - t484 * t2837 * t12931 / 0.8e1 + t14779 + t14781 - t14783 - t14785 - t14787 + t14789;
  t14794 = 0.3e1 / 0.32e2 * t1419 * t3645;
  t14796 = 0.3e1 / 0.32e2 * t1419 * t3649;
  t14798 = t1419 * t3653 / 0.16e2;
  t14828 = t14794 - t14796 - t14798 - t3463 * t2846 / 0.16e2 + t3463 * t2850 / 0.16e2 + 0.3e1 / 0.32e2 * t1503 * t3676 + 0.3e1 / 0.32e2 * t469 * t2849 * t5545 + t1415 * t3679 / 0.4e1 + t484 * t2845 * t5545 / 0.4e1 - 0.3e1 / 0.16e2 * t1415 * t3683 - 0.3e1 / 0.16e2 * t484 * t2849 * t13010 + t3463 * t2875 / 0.16e2 - t1415 * t3670 / 0.16e2 - t484 * t798 * t478 * t1031 / 0.16e2 - 0.3e1 / 0.32e2 * t1493 * t3649;
  t14835 = t13609 / 0.16e2;
  t14836 = t13611 / 0.8e1;
  t14837 = t13615 / 0.8e1;
  t14838 = t13635 / 0.16e2;
  t14839 = t13644 / 0.16e2;
  t14840 = t13646 / 0.32e2;
  t14841 = t13648 / 0.16e2;
  t14842 = t13672 / 0.8e1;
  t14843 = t13675 / 0.8e1;
  t14844 = t13689 / 0.8e1;
  t14845 = t13692 / 0.8e1;
  t14846 = t13694 / 0.16e2;
  t14847 = -0.3e1 / 0.32e2 * t1503 * t3649 - 0.3e1 / 0.32e2 * t469 * t14770 + 0.3e1 / 0.32e2 * t1493 * t3676 - t14835 - t14836 - t14837 + t14838 + t14839 - t14840 - t14841 + t14842 + t14843 + t14844 + t14845 - t14846;
  t14849 = t13696 / 0.16e2;
  t14850 = t12923 / 0.16e2;
  t14851 = t12929 / 0.16e2;
  t14852 = t12944 / 0.32e2;
  t14853 = t12946 / 0.32e2;
  t14854 = t12949 / 0.32e2;
  t14855 = t12954 / 0.16e2;
  t14856 = t12957 / 0.16e2;
  t14857 = t12981 / 0.32e2;
  t14858 = t12983 / 0.32e2;
  t14859 = t12985 / 0.64e2;
  t14860 = t12987 / 0.32e2;
  t14861 = t13002 / 0.16e2;
  t14862 = t13005 / 0.16e2;
  t14864 = t255 * t3666 / 0.64e2;
  t14865 = -t14849 - t14850 - t14851 - t14852 - t14853 - t14854 + t14855 + t14856 - t14857 + t14858 - t14859 + t14860 + t14861 + t14862 - t14864;
  t14872 = -t246 * t3666 / 0.32e2 - t99 * t13081 * t798 * t269 / 0.32e2 + t3659 - t3660 - t3661 + t3662 + t3686 - t3663 + t3664 - t3673 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t14876 = my_piecewise3(t2, 0, t14698 + t14737 + t14755 + t14790 + t14828 + t14847 + t14865 + t14872);
  tv4rhosigmalapl20 = t3 * t14876 + t3688;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t14879 = 0.3e1 / 0.64e2 * t1578 * t3692;
  t14881 = 0.3e1 / 0.64e2 * t1578 * t3726;
  t14883 = t1589 * t3713 / 0.32e2;
  t14885 = t1589 * t3717 / 0.8e1;
  t14887 = 0.3e1 / 0.32e2 * t1589 * t3721;
  t14907 = 0.3e1 / 0.32e2 * t1589 * t3692;
  t14909 = t1589 * t3696 / 0.16e2;
  t14911 = 0.3e1 / 0.64e2 * t1578 * t3699;
  t14913 = 0.3e1 / 0.32e2 * t1589 * t3689;
  t14914 = t13753 / 0.8e1;
  t14915 = -t14879 + t14881 - t14883 + t14885 - t14887 + t1585 * t3717 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3721 - 0.3e1 / 0.32e2 * t1574 * t3692 + 0.3e1 / 0.32e2 * t1574 * t3726 - t1585 * t3713 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t3692 - t1585 * t3696 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t3699 + 0.3e1 / 0.16e2 * t1585 * t3689 - t14907 - t14909 + t14911 + t14913 + t14914;
  t14916 = t13758 / 0.16e2;
  t14917 = t13760 / 0.8e1;
  t14918 = t13762 / 0.8e1;
  t14919 = t13764 / 0.16e2;
  t14920 = t13766 / 0.16e2;
  t14921 = t13768 / 0.16e2;
  t14922 = t13774 / 0.32e2;
  t14923 = t13133 / 0.32e2;
  t14924 = t13135 / 0.32e2;
  t14925 = t13137 / 0.64e2;
  t14926 = t13139 / 0.32e2;
  t14927 = t13141 / 0.16e2;
  t14928 = t13143 / 0.16e2;
  t14929 = t13145 / 0.16e2;
  t14930 = t13147 / 0.32e2;
  t14934 = t370 * t3709 / 0.64e2;
  t14935 = -t14916 - t14917 + t14918 - t14919 + t14920 + t14921 - t14922 - t14923 + t14924 - t14925 + t14926 + t14927 + t14928 - t14929 - t14930 - t367 * t3709 / 0.32e2 - t14934 - t2336 - t2338;
  t14937 = my_piecewise3(t51, 0, t14915 + t14935);
  tv4rhosigmalapl28 = t3 * t14937 + t3731;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t14957 = t13842 / 0.8e1;
  t14958 = 0.3e1 / 0.32e2 * t1548 * t3656 - 0.3e1 / 0.16e2 * t1553 * t3683 - 0.3e1 / 0.32e2 * t1548 * t3649 + 0.3e1 / 0.32e2 * t1548 * t3676 + t1553 * t3679 / 0.4e1 - t1553 * t3670 / 0.16e2 + 0.3e1 / 0.16e2 * t1553 * t3645 - 0.3e1 / 0.16e2 * t1553 * t3649 - t1553 * t3653 / 0.8e1 + t14779 + t14781 - t14783 - t14785 - t14787 + t14789 + t14794 - t14796 - t14798 + t14957;
  t14959 = t13844 / 0.16e2;
  t14960 = t13846 / 0.8e1;
  t14961 = t13848 / 0.8e1;
  t14962 = t13194 / 0.16e2;
  t14963 = t13196 / 0.16e2;
  t14964 = t13198 / 0.16e2;
  t14965 = t13200 / 0.32e2;
  t14968 = -t14959 - t14960 + t14961 + t14838 + t14839 - t14840 - t14841 + t14962 - t14963 + t14964 - t14965 - t14857 + t14858 - t14859 + t14860 - t14864 - t345 * t3666 / 0.32e2 - t2357 - t2314;
  t14970 = my_piecewise3(t2, 0, t14958 + t14968);
  tv4rhosigmalapl29 = t3 * t14970 + t3688;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t14976 = t5232 * t815;
  t14977 = t14976 * t191;
  t14978 = t520 * t1372 * t14977;
  t14981 = t3108 * t9789;
  t14985 = t9652 * t168;
  t14986 = t2937 * t450 * t14985;
  t15019 = -t721 - t534 * t2602 * t7085 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t14978 - 0.3e1 / 0.8e1 * t534 * t14981 + 0.11e2 / 0.16e2 * t534 * t14986 - 0.9e1 / 0.16e2 * t519 * t7299 * t14977 - t534 * t2594 * t9789 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t2954 * t170 * t14985 - 0.11e2 / 0.32e2 * t519 * t6444 * t14977 + 0.3e1 / 0.16e2 * t519 * t3132 * t9789 + 0.3e1 / 0.8e1 * t534 * t11200 * t9789 - 0.11e2 / 0.16e2 * t534 * t2954 * t420 * t14985 + 0.9e1 / 0.16e2 * t519 * t14986 - 0.3e1 / 0.16e2 * t519 * t14981 + 0.3e1 / 0.16e2 * t519 * t3112 * t9789;
  t15024 = t7298 * t1384 * t14977;
  t15059 = 0.3e1 / 0.8e1 * t13878;
  t15060 = t13903 / 0.2e1;
  t15061 = 0.3e1 / 0.8e1 * t13937;
  t15062 = 0.3e1 / 0.16e2 * t13941;
  t15063 = t534 * t9661 * t9789 / 0.2e1 + 0.11e2 / 0.16e2 * t519 * t15024 - 0.3e1 / 0.8e1 * t534 * t2582 * t9789 - 0.15e2 / 0.32e2 * t519 * t168 * t5247 * t5249 * t14977 + 0.11e2 / 0.16e2 * t534 * t3712 * t418 * t13272 - 0.25e2 / 0.16e2 * t534 * t2941 * t5249 * t14985 + 0.15e2 / 0.16e2 * t534 * t11224 * t5261 * t14985 - 0.3e1 / 0.2e1 * t534 * t14978 + 0.9e1 / 0.8e1 * t534 * t15024 + 0.3e1 / 0.8e1 * t534 * t2933 * t75 * t6248 - t534 * t3712 * t168 * t5233 / 0.16e2 - t15059 + t15060 - t15061 + t15062;
  t15065 = t13944 / 0.4e1;
  t15066 = 0.3e1 / 0.16e2 * t13947;
  t15067 = 0.3e1 / 0.8e1 * t13953;
  t15068 = 0.3e1 / 0.16e2 * t13957;
  t15069 = t13980 / 0.8e1;
  t15070 = 0.3e1 / 0.16e2 * t13229;
  t15071 = t13233 / 0.16e2;
  t15072 = t13237 / 0.8e1;
  t15073 = 0.3e1 / 0.32e2 * t13242;
  t15074 = 0.3e1 / 0.32e2 * t13245;
  t15075 = 0.3e1 / 0.32e2 * t13248;
  t15076 = 0.3e1 / 0.16e2 * t13250;
  t15077 = t13254 / 0.4e1;
  t15078 = 0.3e1 / 0.16e2 * t13258;
  t15082 = -t15065 + t15066 + t15067 - t15068 - t15069 + t15070 - t15071 - t15072 + t15073 - t15074 + t15075 - t15076 + t15077 - t15078 - t534 * t2954 * t13325 / 0.8e1;
  t15097 = t2937 * t6158;
  t15118 = 0.3e1 / 0.32e2 * t1681 * t3699 + 0.3e1 / 0.32e2 * t1655 * t3699 + 0.3e1 / 0.32e2 * t519 * t2937 * t6297 + 0.3e1 / 0.16e2 * t1678 * t3689 + 0.3e1 / 0.16e2 * t534 * t2954 * t6297 - 0.3e1 / 0.16e2 * t1678 * t3692 - 0.3e1 / 0.16e2 * t534 * t15097 - t1678 * t3696 / 0.8e1 + t534 * t2937 * t6162 / 0.4e1 - 0.3e1 / 0.16e2 * t1678 * t3721 - 0.3e1 / 0.16e2 * t534 * t2941 * t13357 - 0.3e1 / 0.32e2 * t1681 * t3692 - 0.3e1 / 0.32e2 * t1655 * t3692 - 0.3e1 / 0.32e2 * t519 * t15097 + 0.3e1 / 0.32e2 * t1681 * t3726;
  t15142 = 0.3e1 / 0.32e2 * t1655 * t3726 + 0.3e1 / 0.32e2 * t519 * t2941 * t6162 - t3515 * t2971 / 0.16e2 + t3515 * t2974 / 0.16e2 - t1678 * t3713 / 0.16e2 - t534 * t815 * t528 * t1361 / 0.16e2 + t1678 * t3717 / 0.4e1 - t3515 * t2938 / 0.16e2 + t3515 * t2942 / 0.16e2 - t14879 + t14881 - t14883 + t14885 - t14887 - t14907;
  t15143 = t13993 / 0.8e1;
  t15144 = t13995 / 0.8e1;
  t15145 = t13998 / 0.8e1;
  t15146 = t14036 / 0.16e2;
  t15147 = t14038 / 0.16e2;
  t15148 = t14041 / 0.16e2;
  t15149 = t14043 / 0.8e1;
  t15150 = t14047 / 0.8e1;
  t15151 = t14049 / 0.8e1;
  t15152 = -t14909 + t14911 + t14913 + t15143 + t15144 + t15145 - t15146 - t15147 - t15148 - t15149 - t15150 + t15151 - t14919 + t14920 + t14921;
  t15154 = t13309 / 0.16e2;
  t15155 = t13339 / 0.32e2;
  t15156 = t13341 / 0.32e2;
  t15157 = t13344 / 0.32e2;
  t15158 = t13349 / 0.16e2;
  t15159 = t13352 / 0.16e2;
  t15160 = t13363 / 0.16e2;
  t15161 = t13367 / 0.16e2;
  t15162 = t13382 / 0.16e2;
  t15163 = -t14922 + t15154 - t15155 - t15156 - t15157 + t15158 + t15159 - t15160 - t15161 + t15162 - t14923 + t14924 - t14925 + t14926 - t14934;
  t15170 = -t409 * t3709 / 0.32e2 - t156 * t13442 * t815 * t424 / 0.32e2 + t3703 + t3704 - t3705 - t3702 - t3706 + t3707 - t3716 + t3729 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t15174 = my_piecewise3(t51, 0, t15019 + t15063 + t15082 + t15118 + t15142 + t15152 + t15163 + t15170);
  tv4rhosigmalapl217 = t3 * t15174 + t3731;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  t15177 = 0.3e1 / 0.64e2 * t1499 * t3746;
  t15179 = t1419 * t3750 / 0.32e2;
  t15181 = 0.3e1 / 0.64e2 * t1499 * t3753;
  t15183 = t1419 * t3756 / 0.8e1;
  t15185 = 0.3e1 / 0.32e2 * t1419 * t3759;
  t15187 = 0.3e1 / 0.64e2 * t1499 * t3739;
  t15221 = -t699 + t15177 - t15179 + t15181 + t15183 - t15185 - t15187 - t484 * t2659 * t9218 / 0.8e1 + 0.3e1 / 0.32e2 * t1493 * t3746 + 0.3e1 / 0.32e2 * t1503 * t3746 + 0.3e1 / 0.32e2 * t469 * t11561 * t3745 + 0.3e1 / 0.32e2 * t469 * t3021 * t9999 + 0.3e1 / 0.32e2 * t469 * t3021 * t10006 - t1415 * t3750 / 0.16e2 - t484 * t3057 * t183 * t1031 / 0.16e2 + 0.3e1 / 0.16e2 * t1415 * t3735 + 0.3e1 / 0.16e2 * t484 * t11447 * t1471 + 0.3e1 / 0.16e2 * t484 * t11451 * t1471 + 0.3e1 / 0.16e2 * t484 * t3012 * t5621;
  t15224 = t9994 * t3738;
  t15227 = t2655 * t9196;
  t15230 = t2655 * t9218;
  t15275 = -0.3e1 / 0.16e2 * t1415 * t3739 - 0.3e1 / 0.16e2 * t484 * t15224 - 0.3e1 / 0.16e2 * t484 * t15227 - 0.3e1 / 0.16e2 * t484 * t15230 - t1415 * t3742 / 0.8e1 + t3463 * t3022 / 0.16e2 - 0.3e1 / 0.16e2 * t484 * t2668 * t9196 - 0.3e1 / 0.16e2 * t484 * t2668 * t9218 - 0.3e1 / 0.32e2 * t1493 * t3739 - 0.3e1 / 0.32e2 * t1503 * t3739 - 0.3e1 / 0.32e2 * t469 * t15227 - 0.3e1 / 0.32e2 * t469 * t15224 - 0.3e1 / 0.32e2 * t469 * t15230 - t484 * t3061 * t183 * t1031 / 0.16e2 - t484 * t835 * t478 * t1031 / 0.16e2 + 0.3e1 / 0.32e2 * t1493 * t3753 + 0.3e1 / 0.32e2 * t1503 * t3753 + 0.3e1 / 0.32e2 * t469 * t6535 * t935 * t3745 + 0.3e1 / 0.32e2 * t469 * t2994 * t9999 + 0.3e1 / 0.32e2 * t469 * t2994 * t10006;
  t15300 = t1419 * t3742 / 0.16e2;
  t15302 = 0.3e1 / 0.32e2 * t1419 * t3735;
  t15304 = 0.3e1 / 0.32e2 * t1419 * t3739;
  t15309 = t1415 * t3756 / 0.4e1 + t484 * t11484 * t1517 / 0.4e1 - t484 * t10075 * t3738 / 0.8e1 - t484 * t2659 * t9196 / 0.8e1 + t484 * t11488 * t1517 / 0.4e1 + t484 * t2998 * t5545 / 0.4e1 - 0.3e1 / 0.16e2 * t1415 * t3759 - 0.3e1 / 0.16e2 * t484 * t9953 * t3738 - t15300 + t15302 - t15304 - t3463 * t3009 / 0.16e2 + t3463 * t2995 / 0.16e2 - t14109 + t14113 - t14116 + t14119 - t14164 + t14190;
  t15310 = -t14193 - t14201 + t14215 + t13488 - t13492 - t13524 - t13527 + t13531 + t13535 - t13538 - t13549 + t13553 - t14744 + t14745 - t14746 + t14747 - t14748 + t14749 - t14750 + t14751;
  t15322 = t13638 * t832 / 0.64e2;
  t15323 = -t14752 - t3463 * t3041 / 0.32e2 - t3463 * t3044 / 0.32e2 - t13677 * t832 / 0.32e2 - t13682 * t832 / 0.32e2 - t15322 - t14219 - t14221 + t14223 + t14226 - t14246 - t14251 + t14253 + t14255 - t14289 + t14298 + t14301 - t14311 - t14313;
  t15324 = t23 * t24;
  t15327 = t15324 * t25 * t100 * t213;
  t15331 = t25 * t260;
  t15333 = t15324 * t15331 * t111;
  t15353 = t15324 * t15331 * t199;
  t15381 = 0.3e1 / 0.8e1 * t15327 * t4499 * t2451 - 0.11e2 / 0.32e2 * t15333 * t4415 * t3749 - 0.7e1 / 0.32e2 * t15333 * t4277 * t3749 + 0.11e2 / 0.16e2 * t15327 * t4335 * t2451 - 0.9e1 / 0.16e2 * t15333 * t4524 * t3749 + 0.9e1 / 0.8e1 * t15327 * t4347 * t2451 + 0.11e2 / 0.16e2 * t15327 * t2485 * t12891 + 0.11e2 / 0.16e2 * t15353 * t4347 * t2647 - 0.15e2 / 0.32e2 * t15353 * t4352 * t2647 - 0.25e2 / 0.16e2 * t15327 * t9102 * t14647 + 0.15e2 / 0.16e2 * t15327 * t4331 * t2451 - 0.3e1 / 0.2e1 * t15327 * t9137 * t14647 - 0.11e2 / 0.16e2 * t15327 * t14690 * t14647 + 0.9e1 / 0.16e2 * t15333 * t4335 * t3749 + 0.3e1 / 0.8e1 * t15327 * t9119 * t14670 - t15327 * t2451 * t4311 / 0.16e2 - t13610 - t13612 - t13616 + t13636;
  t15383 = t13645 - t13647 - t13649 + t13673 + t13676 + t13690 + t13693 - t13695 - t13697 - t14850 - t14851 - t14852 - t14853 - t14854 + t14855 + t14856 - t14857 + t14858 - t14859 + t14860;
  t15384 = t14861 + t14862 + t3559 + t3562 - t3567 - t3571 + t3450 - t3453 - t3457 + t3461 + t3686 - t3663 + t3664 - t3673 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t15388 = my_piecewise3(t2, 0, t15221 + t15275 + t15309 + t15310 + t15323 + t15381 + t15383 + t15384);
  tv4rhosigmalapltau0 = t3 * t15388 + t3766;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  t15391 = 0.3e1 / 0.32e2 * t1589 * t3782;
  t15393 = t1589 * t3786 / 0.32e2;
  t15395 = 0.3e1 / 0.64e2 * t1578 * t3782;
  t15397 = 0.3e1 / 0.64e2 * t1578 * t3791;
  t15399 = t1589 * t3794 / 0.8e1;
  t15401 = 0.3e1 / 0.32e2 * t1589 * t3797;
  t15412 = -t15391 - t15393 - t15395 + t15397 + t15399 - t15401 - t1585 * t3771 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t3775 + 0.3e1 / 0.16e2 * t1585 * t3778 - 0.3e1 / 0.16e2 * t1585 * t3782 - t1585 * t3786 / 0.16e2;
  t15422 = t1589 * t3771 / 0.16e2;
  t15424 = 0.3e1 / 0.64e2 * t1578 * t3775;
  t15426 = 0.3e1 / 0.32e2 * t1589 * t3778;
  t15430 = t13771 * t849 / 0.64e2;
  t15431 = -0.3e1 / 0.32e2 * t1574 * t3782 + 0.3e1 / 0.32e2 * t1574 * t3791 + t1585 * t3794 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3797 - t15422 + t15424 + t15426 - t13755 * t849 / 0.32e2 - t15430 + t14341 - t14345 + t14347;
  t15433 = -t14355 - t14357 + t14359 - t14380 + t14382 + t13754 - t13759 - t13761 + t13763 - t13765 + t13767;
  t15434 = t13769 - t13775 - t14923 + t14924 - t14925 + t14926 + t14927 + t14928 - t14929 - t14930 - t2336 - t2338;
  t15437 = my_piecewise3(t51, 0, t15412 + t15431 + t15433 + t15434);
  tv4rhosigmalapltau11 = t3 * t15437 + t3802;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  t15457 = -t1553 * t3750 / 0.16e2 + 0.3e1 / 0.32e2 * t1548 * t3753 + t1553 * t3756 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3759 - 0.3e1 / 0.32e2 * t1548 * t3739 + 0.3e1 / 0.16e2 * t1553 * t3735 - 0.3e1 / 0.16e2 * t1553 * t3739 - t1553 * t3742 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3746 + t15177 - t15179;
  t15460 = t15181 + t15183 - t15185 - t15187 - t15300 + t15302 - t15304 - t13837 * t832 / 0.32e2 - t15322 - t14416 - t14418 + t14420;
  t15462 = t14422 - t14246 - t14251 + t14253 + t14255 + t13843 - t13845 - t13847 + t13849 + t13636 + t13645;
  t15463 = -t13647 - t13649 + t14962 - t14963 + t14964 - t14965 - t14857 + t14858 - t14859 + t14860 - t2357 - t2314;
  t15466 = my_piecewise3(t2, 0, t15457 + t15460 + t15462 + t15463);
  tv4rhosigmalapltau12 = t3 * t15466 + t3766;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  t15515 = t9692 * t3774;
  t15518 = -t721 - t1678 * t3771 / 0.8e1 - t534 * t10535 * t3770 / 0.8e1 - t534 * t2789 * t9789 / 0.8e1 - t534 * t2789 * t9777 / 0.8e1 + 0.3e1 / 0.32e2 * t1681 * t3775 + 0.3e1 / 0.32e2 * t1655 * t3775 + 0.3e1 / 0.32e2 * t519 * t12065 * t3774 + 0.3e1 / 0.32e2 * t519 * t3132 * t10556 + 0.3e1 / 0.32e2 * t519 * t3132 * t10560 + 0.3e1 / 0.16e2 * t1678 * t3778 + t3515 * t3133 / 0.16e2 - 0.3e1 / 0.16e2 * t534 * t2779 * t9777 - t534 * t3136 * t191 * t1361 / 0.16e2 - t534 * t3140 * t191 * t1361 / 0.16e2 - t534 * t852 * t528 * t1361 / 0.16e2 - 0.3e1 / 0.32e2 * t1681 * t3782 - 0.3e1 / 0.32e2 * t1655 * t3782 - 0.3e1 / 0.32e2 * t519 * t15515;
  t15519 = t3108 * t10556;
  t15522 = t3108 * t10560;
  t15571 = -0.3e1 / 0.32e2 * t519 * t15519 - 0.3e1 / 0.32e2 * t519 * t15522 + 0.3e1 / 0.32e2 * t1681 * t3791 + 0.3e1 / 0.32e2 * t1655 * t3791 + 0.3e1 / 0.16e2 * t534 * t11979 * t1707 + 0.3e1 / 0.16e2 * t534 * t11983 * t1707 + 0.3e1 / 0.16e2 * t534 * t3123 * t6297 - 0.3e1 / 0.16e2 * t1678 * t3782 - 0.3e1 / 0.16e2 * t534 * t15519 - 0.3e1 / 0.16e2 * t534 * t15515 - 0.3e1 / 0.16e2 * t534 * t15522 - t1678 * t3786 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t7152 * t1372 * t3774 + 0.3e1 / 0.32e2 * t519 * t3112 * t10556 + 0.3e1 / 0.32e2 * t519 * t3112 * t10560 + t1678 * t3794 / 0.4e1 + t534 * t11957 * t1630 / 0.4e1 + t534 * t11961 * t1630 / 0.4e1 + t534 * t3116 * t6162 / 0.4e1 - 0.3e1 / 0.16e2 * t1678 * t3797;
  t15583 = -0.3e1 / 0.16e2 * t534 * t10507 * t3770 - 0.3e1 / 0.16e2 * t534 * t2779 * t9789 + t3515 * t3113 / 0.16e2 - t3515 * t3109 / 0.16e2 - t15391 - t15393 - t15395 + t15397 + t15399 - t15401 - t15422 + t15424 + t15426 - t14441 + t14445 + t14449 - t14452 + t14455 - t14459;
  t15584 = t60 * t24;
  t15585 = t25 * t415;
  t15587 = t15584 * t15585 * t168;
  t15593 = t15584 * t25 * t157 * t219;
  t15600 = -t14498 - t14543 + t14547 - t13879 + t13904 - t13938 + t13942 - t13945 + t13948 + t13954 - t13958 - t13981 - 0.7e1 / 0.32e2 * t15587 * t5270 * t3785 + 0.3e1 / 0.8e1 * t15593 * t5426 * t2588 - 0.11e2 / 0.32e2 * t15587 * t5410 * t3785 + t15070 - t15071 - t15072 + t15073 - t15074;
  t15611 = t15075 - t15076 + t15077 - t15078 - t14022 * t849 / 0.32e2 - t14026 * t849 / 0.32e2 - t3515 * t3165 / 0.32e2 - t3515 * t3168 / 0.32e2 - t15430 - t14556 - t14558 - t14561 - t14563 - t14567 + t14569 + t14572 + t14616 + t14619 + t14347;
  t15613 = t15584 * t15585 * t207;
  t15626 = -t14355 - t14357 + t14359 + t13994 + t13996 + t13999 - t14037 - t14039 - t14042 - t14044 - t14048 + t14050 - t13765 + t13767 + t13769 - t13775 - 0.9e1 / 0.16e2 * t15613 * t5306 * t2783 - 0.3e1 / 0.2e1 * t15593 * t9661 * t14985 + 0.9e1 / 0.8e1 * t15593 * t5243 * t2588 + 0.11e2 / 0.16e2 * t15593 * t2578 * t13272;
  t15657 = 0.11e2 / 0.16e2 * t15613 * t5243 * t2783 - 0.15e2 / 0.32e2 * t15613 * t5251 * t2783 - 0.25e2 / 0.16e2 * t15593 * t1964 * t5249 * t14985 + 0.15e2 / 0.16e2 * t15593 * t5263 * t2588 + 0.11e2 / 0.16e2 * t15593 * t5302 * t2588 + 0.9e1 / 0.16e2 * t15613 * t5302 * t2783 - 0.11e2 / 0.16e2 * t15593 * t13420 * t420 * t9749 + 0.3e1 / 0.8e1 * t15593 * t9712 * t6248 - t15593 * t2588 * t5233 / 0.16e2 + t15154 - t15155 - t15156 - t15157 + t15158 + t15159 - t15160 - t15161 + t15162 - t14923 + t14924;
  t15658 = -t14925 + t14926 + t3603 - t3608 - t3612 + t3615 + t3509 + t3513 - t3520 - t3505 - t3706 + t3707 - t3716 + t3729 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t15662 = my_piecewise3(t51, 0, t15518 + t15571 + t15583 + t15600 + t15611 + t15626 + t15657 + t15658);
  tv4rhosigmalapltau23 = t3 * t15662 + t3802;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t15664 = t12252 * t4321;
  t15668 = t3181 * t295;
  t15669 = t15668 * t14647;
  t15672 = t3181 * t935;
  t15673 = t15672 * t14647;
  t15676 = t3185 * t945;
  t15677 = t15676 * t14647;
  t15680 = t3177 * t43;
  t15691 = t3185 * t4321;
  t15695 = t12252 * t4329;
  t15705 = 0.3e1 / 0.8e1 * t14108;
  t15706 = 0.3e1 / 0.16e2 * t14112;
  t15707 = t14115 / 0.4e1;
  t15708 = -t699 - 0.15e2 / 0.32e2 * t469 * t15664 * t14647 + 0.11e2 / 0.16e2 * t484 * t15669 - 0.3e1 / 0.2e1 * t484 * t15673 + 0.9e1 / 0.8e1 * t484 * t15677 - 0.11e2 / 0.16e2 * t484 * t15680 * t5613 + 0.3e1 / 0.8e1 * t484 * t15680 * t14670 - t484 * t3823 * t111 * t4311 / 0.16e2 - 0.25e2 / 0.16e2 * t484 * t15691 * t14647 + 0.15e2 / 0.16e2 * t484 * t15695 * t14647 + 0.11e2 / 0.16e2 * t484 * t3823 * t263 * t12891 + 0.11e2 / 0.16e2 * t469 * t15677 - t15705 + t15706 - t15707;
  t15709 = 0.3e1 / 0.16e2 * t14118;
  t15710 = t14163 / 0.8e1;
  t15711 = t14189 / 0.2e1;
  t15712 = 0.3e1 / 0.8e1 * t14192;
  t15713 = 0.3e1 / 0.16e2 * t14200;
  t15714 = 0.3e1 / 0.8e1 * t14214;
  t15715 = t15709 - t15710 + t15711 - t15712 - t15713 + t15714 - t14744 + t14745 - t14746 + t14747 - t14748 + t14749 - t14750 + t14751 - t14752;
  t15717 = t3181 * t8462;
  t15721 = t1419 * t3824 / 0.32e2;
  t15723 = 0.3e1 / 0.64e2 * t1499 * t3809;
  t15725 = 0.3e1 / 0.64e2 * t1499 * t3829;
  t15727 = t1419 * t3832 / 0.8e1;
  t15729 = 0.3e1 / 0.32e2 * t1419 * t3835;
  t15752 = -0.3e1 / 0.16e2 * t484 * t15717 - t15721 - t15723 + t15725 + t15727 - t15729 + t1415 * t3832 / 0.4e1 + t484 * t3181 * t5545 / 0.4e1 - 0.3e1 / 0.16e2 * t1415 * t3835 - 0.3e1 / 0.16e2 * t484 * t3185 * t13010 - t3463 * t3203 / 0.16e2 + t3463 * t3206 / 0.16e2 - t1415 * t3824 / 0.16e2 - t484 * t866 * t478 * t1031 / 0.16e2 - 0.3e1 / 0.32e2 * t1493 * t3809;
  t15777 = 0.3e1 / 0.64e2 * t1499 * t3812;
  t15779 = t1419 * t3803 / 0.16e2;
  t15781 = 0.3e1 / 0.32e2 * t1419 * t3806;
  t15783 = 0.3e1 / 0.32e2 * t1419 * t3809;
  t15786 = -0.3e1 / 0.32e2 * t1503 * t3809 - 0.3e1 / 0.32e2 * t469 * t15717 + 0.3e1 / 0.32e2 * t1493 * t3812 + 0.3e1 / 0.32e2 * t1503 * t3812 + 0.3e1 / 0.32e2 * t469 * t3181 * t5621 - t1415 * t3803 / 0.8e1 - t484 * t3199 * t12931 / 0.8e1 + 0.3e1 / 0.16e2 * t1415 * t3806 + 0.3e1 / 0.16e2 * t484 * t3199 * t5621 - 0.3e1 / 0.16e2 * t1415 * t3809 + t15777 - t15779 + t15781 - t15783 + 0.3e1 / 0.32e2 * t1493 * t3829;
  t15798 = t14218 / 0.16e2;
  t15799 = t14220 / 0.8e1;
  t15800 = t14222 / 0.8e1;
  t15801 = t14225 / 0.8e1;
  t15802 = t14245 / 0.32e2;
  t15803 = t14250 / 0.16e2;
  t15804 = t14252 / 0.16e2;
  t15805 = t14254 / 0.16e2;
  t15806 = t14288 / 0.8e1;
  t15807 = t14297 / 0.8e1;
  t15808 = t14300 / 0.8e1;
  t15809 = 0.3e1 / 0.32e2 * t1503 * t3829 + 0.3e1 / 0.32e2 * t469 * t3185 * t5545 - t3463 * t3182 / 0.16e2 + t3463 * t3186 / 0.16e2 - t15798 - t15799 + t15800 + t15801 - t15802 - t15803 + t15804 + t15805 - t15806 + t15807 + t15808;
  t15810 = t14310 / 0.16e2;
  t15811 = t14312 / 0.16e2;
  t15812 = -t15810 - t15811 - t14850 - t14851 - t14852 - t14853 - t14854 + t14855 + t14856 - t14857 + t14858 - t14859 + t14860 + t14861 + t14862;
  t15821 = t255 * t3820 / 0.64e2;
  t15822 = t4276 * t866;
  t15823 = t15822 * t183;
  t15827 = t640 * t265;
  t15834 = t3199 * t113;
  t15838 = -t246 * t3820 / 0.32e2 - t99 * t13081 * t866 * t269 / 0.32e2 - t15821 + t3815 + t3816 - t3817 - t3818 + t3686 - t3663 + t3664 - t3673 - 0.9e1 / 0.16e2 * t469 * t5804 * t15823 + 0.3e1 / 0.16e2 * t469 * t15827 * t9999 - t484 * t2659 * t9999 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t15834 * t14647;
  t15842 = t644 * t265;
  t15848 = t2655 * t9999;
  t15867 = -0.11e2 / 0.32e2 * t469 * t5799 * t15823 + 0.3e1 / 0.8e1 * t484 * t15842 * t9999 + 0.9e1 / 0.16e2 * t469 * t15669 - 0.3e1 / 0.8e1 * t484 * t15848 - t484 * t2651 * t7424 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t15673 - 0.3e1 / 0.16e2 * t469 * t15848 + 0.3e1 / 0.16e2 * t469 * t12203 * t9999 + t484 * t12207 * t9999 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2668 * t9999 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t15871 = my_piecewise3(t2, 0, t15708 + t15715 + t15752 + t15786 + t15809 + t15812 + t15838 + t15867);
  tv4rhosigmatau20 = t3 * t15871 + t3839;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t15878 = 0.3e1 / 0.32e2 * t1589 * t3843;
  t15880 = t1589 * t3846 / 0.16e2;
  t15882 = 0.3e1 / 0.64e2 * t1578 * t3849;
  t15884 = t1589 * t3861 / 0.32e2;
  t15886 = 0.3e1 / 0.64e2 * t1578 * t3843;
  t15888 = 0.3e1 / 0.64e2 * t1578 * t3866;
  t15890 = t1589 * t3869 / 0.8e1;
  t15892 = 0.3e1 / 0.32e2 * t1589 * t3872;
  t15894 = 0.3e1 / 0.32e2 * t1589 * t3840;
  t15909 = t14340 / 0.8e1;
  t15910 = 0.3e1 / 0.32e2 * t1574 * t3849 + 0.3e1 / 0.16e2 * t1585 * t3840 - t15878 - t15880 + t15882 - t15884 - t15886 + t15888 + t15890 - t15892 + t15894 - 0.3e1 / 0.32e2 * t1574 * t3843 + 0.3e1 / 0.32e2 * t1574 * t3866 + t1585 * t3869 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3872 - t1585 * t3861 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t3843 - t1585 * t3846 / 0.8e1 + t15909;
  t15911 = t14344 / 0.16e2;
  t15912 = t14346 / 0.16e2;
  t15913 = t14354 / 0.32e2;
  t15914 = t14356 / 0.16e2;
  t15915 = t14358 / 0.16e2;
  t15916 = t14379 / 0.8e1;
  t15917 = t14381 / 0.8e1;
  t15919 = t370 * t3857 / 0.64e2;
  t15922 = -t15911 + t15912 - t15913 - t15914 + t15915 - t15916 + t15917 - t14923 + t14924 - t14925 + t14926 + t14927 + t14928 - t14929 - t14930 - t15919 - t367 * t3857 / 0.32e2 - t2336 - t2338;
  t15924 = my_piecewise3(t51, 0, t15910 + t15922);
  tv4rhosigmatau28 = t3 * t15924 + t3876;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t15944 = t14415 / 0.16e2;
  t15945 = -0.3e1 / 0.16e2 * t1553 * t3835 - t1553 * t3824 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3809 + 0.3e1 / 0.32e2 * t1548 * t3829 + t1553 * t3832 / 0.4e1 - t1553 * t3803 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t3806 - 0.3e1 / 0.16e2 * t1553 * t3809 + 0.3e1 / 0.32e2 * t1548 * t3812 - t15721 - t15723 + t15725 + t15727 - t15729 + t15777 - t15779 + t15781 - t15783 - t15944;
  t15946 = t14417 / 0.8e1;
  t15947 = t14419 / 0.8e1;
  t15948 = t14421 / 0.8e1;
  t15951 = -t15946 + t15947 + t15948 - t15802 - t15803 + t15804 + t15805 + t14962 - t14963 + t14964 - t14965 - t14857 + t14858 - t14859 + t14860 - t345 * t3820 / 0.32e2 - t15821 - t2357 - t2314;
  t15953 = my_piecewise3(t2, 0, t15945 + t15951);
  tv4rhosigmatau29 = t3 * t15953 + t3839;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t15955 = 0.3e1 / 0.16e2 * t14440;
  t15956 = 0.3e1 / 0.16e2 * t14444;
  t15957 = t14448 / 0.2e1;
  t15958 = 0.3e1 / 0.8e1 * t14451;
  t15959 = 0.3e1 / 0.8e1 * t14454;
  t15960 = t14458 / 0.8e1;
  t15961 = 0.3e1 / 0.8e1 * t14497;
  t15962 = t14542 / 0.4e1;
  t15963 = 0.3e1 / 0.16e2 * t14546;
  t15976 = -t721 - t15955 + t15956 + t15957 - t15958 + t15959 - t15960 - t15961 - t15962 + t15963 - t1678 * t3846 / 0.8e1 - t534 * t3292 * t13325 / 0.8e1 + 0.3e1 / 0.32e2 * t1681 * t3849 + 0.3e1 / 0.32e2 * t1655 * t3849 + 0.3e1 / 0.32e2 * t519 * t3284 * t6297;
  t15984 = t3284 * t6158;
  t16014 = 0.3e1 / 0.16e2 * t1678 * t3840 + 0.3e1 / 0.16e2 * t534 * t3292 * t6297 - 0.3e1 / 0.16e2 * t1678 * t3843 - 0.3e1 / 0.16e2 * t534 * t15984 + 0.3e1 / 0.32e2 * t1681 * t3866 + 0.3e1 / 0.32e2 * t1655 * t3866 + 0.3e1 / 0.32e2 * t519 * t3276 * t6162 + t1678 * t3869 / 0.4e1 + t534 * t3284 * t6162 / 0.4e1 - 0.3e1 / 0.16e2 * t1678 * t3872 - 0.3e1 / 0.16e2 * t534 * t3276 * t13357 - t1678 * t3861 / 0.16e2 - t534 * t883 * t528 * t1361 / 0.16e2 - 0.3e1 / 0.32e2 * t1681 * t3843 - 0.3e1 / 0.32e2 * t1655 * t3843;
  t16026 = -0.3e1 / 0.32e2 * t519 * t15984 - t3515 * t3296 / 0.16e2 + t3515 * t3299 / 0.16e2 - t3515 * t3285 / 0.16e2 + t3515 * t3308 / 0.16e2 - t15878 - t15880 + t15882 - t15884 - t15886 + t15888 + t15890 - t15892 + t15894 + t15070;
  t16027 = t14555 / 0.16e2;
  t16028 = t14557 / 0.16e2;
  t16029 = t14560 / 0.16e2;
  t16030 = t14562 / 0.8e1;
  t16031 = t14566 / 0.8e1;
  t16032 = t14568 / 0.8e1;
  t16033 = t14571 / 0.8e1;
  t16034 = -t15071 - t15072 + t15073 - t15074 + t15075 - t15076 + t15077 - t15078 - t16027 - t16028 - t16029 - t16030 - t16031 + t16032 + t16033;
  t16037 = t14615 / 0.8e1;
  t16038 = t14618 / 0.8e1;
  t16039 = t16037 + t16038 + t15912 - t15913 - t15914 + t15915 + t15154 - t15155 - t15156 - t15157 + t15158 + t15159 - t15160 - t15161 + t15162;
  t16040 = t3276 * t5249;
  t16044 = t12694 * t5261;
  t16052 = t3276 * t1384;
  t16053 = t16052 * t14985;
  t16056 = t12694 * t5249;
  t16060 = t3284 * t1372;
  t16061 = t16060 * t14985;
  t16070 = t3302 * t75;
  t16081 = -t14923 + t14924 - t14925 + t14926 - 0.25e2 / 0.16e2 * t534 * t16040 * t14985 + 0.15e2 / 0.16e2 * t534 * t16044 * t14985 + 0.11e2 / 0.16e2 * t534 * t3860 * t418 * t13272 + 0.11e2 / 0.16e2 * t519 * t16053 - 0.15e2 / 0.32e2 * t519 * t16056 * t14985 - 0.3e1 / 0.2e1 * t534 * t16061 + 0.9e1 / 0.8e1 * t534 * t16053 - t534 * t3860 * t168 * t5233 / 0.16e2 + 0.3e1 / 0.8e1 * t534 * t16070 * t6248 + 0.3e1 / 0.8e1 * t534 * t12654 * t10556 - 0.11e2 / 0.16e2 * t534 * t3292 * t420 * t14985;
  t16083 = t5232 * t883;
  t16084 = t16083 * t191;
  t16085 = t7315 * t16084;
  t16088 = t3781 * t10556;
  t16099 = t3292 * t170;
  t16106 = t679 * t420;
  t16117 = t2165 * t1372;
  t16129 = 0.9e1 / 0.16e2 * t519 * t16085 - 0.3e1 / 0.8e1 * t534 * t16088 + 0.11e2 / 0.16e2 * t534 * t16085 - 0.9e1 / 0.16e2 * t519 * t7299 * t16084 - t534 * t2789 * t10556 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t16099 * t14985 - 0.11e2 / 0.32e2 * t519 * t6444 * t16084 + 0.3e1 / 0.16e2 * t519 * t16106 * t10556 - t534 * t2765 * t8029 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t16061 - 0.3e1 / 0.16e2 * t519 * t16088 + 0.3e1 / 0.16e2 * t519 * t16117 * t10556 + t534 * t10459 * t10556 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2779 * t10556 - t409 * t3857 / 0.32e2;
  t16134 = -t156 * t13442 * t883 * t424 / 0.32e2 - t15919 + t3852 - t3853 - t3854 + t3855 - t3706 + t3707 - t3716 + t3729 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t16138 = my_piecewise3(t51, 0, t15976 + t16014 + t16026 + t16034 + t16039 + t16081 + t16129 + t16134);
  tv4rhosigmatau217 = t3 * t16138 + t3876;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t16142 = t3887 * t111;
  t16159 = t2845 * t6474;
  t16163 = t3887 * t263;
  t16164 = t16163 * t12917;
  t16167 = t5550 * t3887;
  t16174 = t1525 * t563;
  t16181 = t470 * t16167;
  t16189 = t1463 * t563;
  t16193 = t3887 * t43;
  t16197 = t5612 * t3887;
  t16201 = 0.11e2 / 0.16e2 * t484 * t16164 - 0.9e1 / 0.16e2 * t469 * t5803 * t16167 + 0.3e1 / 0.4e1 * t484 * t2845 * t6478 - 0.9e1 / 0.16e2 * t484 * t2849 * t16174 - 0.3e1 / 0.16e2 * t484 * t2837 * t6474 - 0.7e1 / 0.32e2 * t469 * t16181 - 0.9e1 / 0.32e2 * t469 * t16159 + 0.9e1 / 0.32e2 * t469 * t2849 * t6478 - 0.3e1 / 0.8e1 * t484 * t2837 * t16189 + 0.3e1 / 0.8e1 * t484 * t16193 * t12936 - 0.11e2 / 0.32e2 * t469 * t470 * t16197;
  t16210 = t3887 * t943;
  t16211 = t16210 * t12891;
  t16221 = t3887 * t4327;
  t16233 = 0.9e1 / 0.32e2 * t469 * t2845 * t6651 + t3970 * t2850 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t16181 + 0.9e1 / 0.8e1 * t484 * t16211 + 0.9e1 / 0.16e2 * t469 * t16164 + 0.11e2 / 0.16e2 * t484 * t16163 * t12891 + 0.11e2 / 0.16e2 * t469 * t16211 - 0.15e2 / 0.32e2 * t469 * t16221 * t12900 - 0.25e2 / 0.16e2 * t484 * t16210 * t12900 + 0.15e2 / 0.16e2 * t484 * t16221 * t12907 - t3970 * t2846 / 0.16e2;
  t16244 = 0.3e1 / 0.32e2 * t13635;
  t16245 = -0.9e1 / 0.16e2 * t13523 - 0.9e1 / 0.32e2 * t13526 + 0.9e1 / 0.32e2 * t13530 + 0.3e1 / 0.4e1 * t13534 - 0.9e1 / 0.16e2 * t13537 - 0.3e1 / 0.8e1 * t13548 + 0.9e1 / 0.32e2 * t13552 - 0.3e1 / 0.32e2 * t13609 - 0.3e1 / 0.16e2 * t13611 - 0.3e1 / 0.16e2 * t13615 + t16244;
  t16248 = 0.3e1 / 0.32e2 * t13644;
  t16249 = 0.3e1 / 0.64e2 * t13646;
  t16250 = 0.3e1 / 0.32e2 * t13648;
  t16258 = 0.3e1 / 0.64e2 * t255 * t3896;
  t16261 = 0.3e1 / 0.32e2 * t255 * t3899;
  t16263 = t255 * t3884 / 0.64e2;
  t16265 = 0.3e1 / 0.32e2 * t255 * t3889;
  t16272 = t1000 * t3887;
  t16285 = t16261 - t16263 - t16265 + 0.3e1 / 0.16e2 * t246 * t3899 - t246 * t3906 / 0.16e2 - 0.3e1 / 0.32e2 * t246 * t3909 - 0.3e1 / 0.32e2 * t99 * t16272 * t956 + 0.3e1 / 0.32e2 * t246 * t3912 + 0.3e1 / 0.32e2 * t99 * t16272 * t1036 + t246 * t3915 / 0.4e1 - 0.3e1 / 0.16e2 * t246 * t3918;
  t16295 = t200 * t263;
  t16298 = t200 * t43;
  t16301 = t4428 * t199;
  t16304 = t268 * t199;
  t16305 = t266 * t16304;
  t16329 = t13033 * t558 / 0.4e1 + t565 / 0.2e1 + t200 * t111 * t290 / 0.2e1 - t16295 * t491 / 0.2e1 - t16298 * t497 / 0.2e1 - t16301 * t13048 / 0.2e1 + t13051 * t16305 / 0.2e1 + t993 * t563 * t116 / 0.2e1 + t3877 * t13060 / 0.2e1 - t3877 * t13063 / 0.2e1 - t3877 * t13066 / 0.2e1 - t4446 * t199 * t116 / 0.2e1 - t996 * t563 * t116 / 0.2e1 - t3879 * t13060 / 0.2e1 + t3879 * t13063 / 0.2e1 + t3879 * t13066 / 0.2e1;
  t16344 = 0.3e1 / 0.32e2 * t255 * t3918;
  t16346 = t255 * t3906 / 0.32e2;
  t16348 = 0.3e1 / 0.64e2 * t255 * t3909;
  t16350 = 0.3e1 / 0.64e2 * t255 * t3912;
  t16352 = t255 * t3915 / 0.8e1;
  t16353 = -t246 * t3884 / 0.32e2 - t99 * t16329 * t798 * t269 / 0.32e2 - 0.3e1 / 0.16e2 * t246 * t3889 - t246 * t3892 / 0.8e1 + 0.3e1 / 0.32e2 * t246 * t3896 + 0.3e1 / 0.32e2 * t99 * t16272 * t964 - t16344 - t16346 - t16348 + t16350 + t16352;
  t16355 = t255 * t3892 / 0.16e2;
  t16356 = -t16355 + t3902 - t3903 - t3904 + t3905 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t16360 = my_piecewise3(t2, 0, t3970 * t2875 / 0.16e2 - 0.9e1 / 0.16e2 * t484 * t16159 - t3970 * t2872 / 0.16e2 + t16353 + t16356 - t699 + t16201 + 0.9e1 / 0.16e2 * t13487 + t16245 + t16248 - t16249 - t16250 + t16258 + t16285 - 0.3e1 / 0.32e2 * t13696 + 0.3e1 / 0.16e2 * t13692 - 0.3e1 / 0.32e2 * t13694 + 0.3e1 / 0.16e2 * t13689 + 0.3e1 / 0.16e2 * t13675 + 0.3e1 / 0.16e2 * t13672 - 0.11e2 / 0.16e2 * t484 * t16142 * t4316 + 0.3e1 / 0.8e1 * t484 * t16142 * t4378 - t484 * t16142 * t4311 / 0.16e2 + 0.9e1 / 0.16e2 * t484 * t2837 * t6651 - 0.3e1 / 0.16e2 * t13491 + t16233);
  tv4rholapl30 = t3 * t16360 + t3922;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t16366 = 0.3e1 / 0.32e2 * t13764;
  t16367 = 0.3e1 / 0.32e2 * t13766;
  t16368 = 0.3e1 / 0.32e2 * t13768;
  t16369 = 0.3e1 / 0.64e2 * t13774;
  t16373 = 0.3e1 / 0.32e2 * t370 * t3964;
  t16384 = 0.3e1 / 0.16e2 * t13753 - 0.3e1 / 0.32e2 * t13758 - 0.3e1 / 0.16e2 * t13760 + 0.3e1 / 0.16e2 * t13762 - t16366 + t16367 + t16368 - t16369 - t367 * t3930 / 0.32e2 - t16373 + 0.3e1 / 0.32e2 * t367 * t3958 + t367 * t3961 / 0.4e1 - 0.3e1 / 0.16e2 * t367 * t3964 - 0.3e1 / 0.16e2 * t367 * t3935 - t367 * t3938 / 0.8e1;
  t16394 = 0.3e1 / 0.64e2 * t370 * t3955;
  t16396 = 0.3e1 / 0.64e2 * t370 * t3958;
  t16398 = t370 * t3961 / 0.8e1;
  t16400 = t370 * t3952 / 0.32e2;
  t16402 = 0.3e1 / 0.32e2 * t370 * t3945;
  t16404 = t370 * t3930 / 0.64e2;
  t16406 = 0.3e1 / 0.32e2 * t370 * t3935;
  t16408 = t370 * t3938 / 0.16e2;
  t16410 = 0.3e1 / 0.64e2 * t370 * t3942;
  t16411 = 0.3e1 / 0.32e2 * t367 * t3942 + 0.3e1 / 0.16e2 * t367 * t3945 - t367 * t3952 / 0.16e2 - 0.3e1 / 0.32e2 * t367 * t3955 - t16394 + t16396 + t16398 - t16400 + t16402 - t16404 - t16406 - t16408 + t16410 - t2336 - t2338;
  t16413 = my_piecewise3(t51, 0, t16384 + t16411);
  tv4rholapl33 = t3 * t16413 + t3968;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t16433 = 0.3e1 / 0.16e2 * t13842 - 0.3e1 / 0.32e2 * t13844 - 0.3e1 / 0.16e2 * t13846 + 0.3e1 / 0.16e2 * t13848 + t16244 + t16248 - t16249 - t16250 - t345 * t3892 / 0.8e1 + t345 * t3915 / 0.4e1 - 0.3e1 / 0.16e2 * t345 * t3918 + 0.3e1 / 0.32e2 * t345 * t3896 + 0.3e1 / 0.16e2 * t345 * t3899 - t345 * t3906 / 0.16e2 - 0.3e1 / 0.32e2 * t345 * t3909;
  t16440 = 0.3e1 / 0.32e2 * t345 * t3912 - t345 * t3884 / 0.32e2 - 0.3e1 / 0.16e2 * t345 * t3889 + t16258 + t16261 - t16263 - t16265 - t16344 - t16346 - t16348 + t16350 + t16352 - t16355 - t2357 - t2314;
  t16442 = my_piecewise3(t2, 0, t16433 + t16440);
  tv4rholapl34 = t3 * t16442 + t3922;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t16444 = t3933 * t168;
  t16454 = t6237 * t3933;
  t16458 = t1701 * t602;
  t16462 = t3933 * t75;
  t16466 = t6359 * t3933;
  t16470 = t1639 * t602;
  t16474 = t2937 * t7085;
  t16487 = t520 * t16454;
  t16502 = t3933 * t418;
  t16503 = t16502 * t13295;
  t16508 = 0.9e1 / 0.32e2 * t519 * t2941 * t7089 + 0.3e1 / 0.4e1 * t534 * t2937 * t7089 - 0.3e1 / 0.16e2 * t534 * t2954 * t7085 - 0.7e1 / 0.32e2 * t519 * t16487 + 0.9e1 / 0.32e2 * t519 * t2937 * t7214 + 0.9e1 / 0.16e2 * t534 * t2954 * t7214 - t4006 * t2971 / 0.16e2 + t4006 * t2974 / 0.16e2 - 0.9e1 / 0.16e2 * t534 * t16474 + 0.11e2 / 0.16e2 * t534 * t16503 - t4006 * t2938 / 0.16e2;
  t16514 = t3933 * t1370;
  t16515 = t16514 * t13272;
  t16525 = t3933 * t5247;
  t16537 = t4006 * t2942 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t16487 + 0.9e1 / 0.8e1 * t534 * t16515 + 0.9e1 / 0.16e2 * t519 * t16503 + 0.11e2 / 0.16e2 * t534 * t16502 * t13272 + 0.11e2 / 0.16e2 * t519 * t16515 - 0.15e2 / 0.32e2 * t519 * t16525 * t13277 - 0.25e2 / 0.16e2 * t534 * t16514 * t13277 + 0.15e2 / 0.16e2 * t534 * t16525 * t13284 - 0.9e1 / 0.16e2 * t13878 + 0.3e1 / 0.4e1 * t13903;
  t16549 = -0.9e1 / 0.16e2 * t13937 + 0.9e1 / 0.32e2 * t13941 - 0.3e1 / 0.8e1 * t13944 + 0.9e1 / 0.32e2 * t13947 + 0.9e1 / 0.16e2 * t13953 - 0.9e1 / 0.32e2 * t13957 - 0.3e1 / 0.16e2 * t13980 + 0.3e1 / 0.16e2 * t13993 + 0.3e1 / 0.16e2 * t13995 + 0.3e1 / 0.16e2 * t13998 - 0.3e1 / 0.32e2 * t14036;
  t16560 = t1329 * t3933;
  t16572 = t208 * t418;
  t16575 = t208 * t75;
  t16578 = t5348 * t207;
  t16581 = t423 * t207;
  t16582 = t421 * t16581;
  t16606 = t13394 * t597 / 0.4e1 + t604 / 0.2e1 + t208 * t168 * t445 / 0.2e1 - t16572 * t541 / 0.2e1 - t16575 * t547 / 0.2e1 - t16578 * t13409 / 0.2e1 + t13412 * t16582 / 0.2e1 + t1322 * t602 * t173 / 0.2e1 + t3923 * t13421 / 0.2e1 - t3923 * t13424 / 0.2e1 - t3923 * t13427 / 0.2e1 - t5366 * t207 * t173 / 0.2e1 - t1325 * t602 * t173 / 0.2e1 - t3925 * t13421 / 0.2e1 + t3925 * t13424 / 0.2e1 + t3925 * t13427 / 0.2e1;
  t16628 = 0.3e1 / 0.32e2 * t156 * t16560 * t1374 - t409 * t3930 / 0.32e2 - t156 * t16606 * t815 * t424 / 0.32e2 - 0.3e1 / 0.16e2 * t409 * t3935 - t409 * t3938 / 0.8e1 + t409 * t3961 / 0.4e1 - 0.3e1 / 0.16e2 * t409 * t3964 + 0.3e1 / 0.32e2 * t409 * t3942 + 0.3e1 / 0.32e2 * t156 * t16560 * t1405 + 0.3e1 / 0.16e2 * t409 * t3945 - t409 * t3952 / 0.16e2;
  t16635 = -0.3e1 / 0.32e2 * t409 * t3955 - 0.3e1 / 0.32e2 * t156 * t16560 * t1366 - t16373 - t16394 + t16396 + t16398 - t16400 + t16402 - t16404 - t16406 - t16408;
  t16636 = t16410 + t3949 + t3950 - t3951 - t3948 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t16640 = my_piecewise3(t51, 0, 0.3e1 / 0.32e2 * t409 * t3958 - 0.9e1 / 0.32e2 * t519 * t16474 + 0.3e1 / 0.8e1 * t534 * t16462 * t13330 - 0.11e2 / 0.32e2 * t519 * t520 * t16466 - 0.9e1 / 0.16e2 * t534 * t2941 * t16470 - 0.11e2 / 0.16e2 * t534 * t16444 * t5298 + 0.3e1 / 0.8e1 * t534 * t16444 * t5324 - t534 * t16444 * t5233 / 0.16e2 - 0.9e1 / 0.16e2 * t519 * t7298 * t16454 - 0.3e1 / 0.8e1 * t534 * t2954 * t16458 + t16537 + t16549 + t16636 + t16635 + t16628 - t16366 + t16367 + t16368 - t16369 - 0.3e1 / 0.16e2 * t14047 + 0.3e1 / 0.16e2 * t14049 - 0.3e1 / 0.16e2 * t14043 - 0.3e1 / 0.32e2 * t14041 - 0.3e1 / 0.32e2 * t14038 + t16508 - t721);
  tv4rholapl37 = t3 * t16640 + t3968;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  t16643 = 0.3e1 / 0.64e2 * t1499 * t3993;
  t16645 = 0.3e1 / 0.32e2 * t1419 * t3978;
  t16647 = t1419 * t3982 / 0.16e2;
  t16649 = 0.3e1 / 0.64e2 * t1499 * t3985;
  t16651 = 0.3e1 / 0.32e2 * t1419 * t3974;
  t16655 = t23 * t95 * t3882 * t832 / 0.64e2;
  t16658 = t631 * t798;
  t16664 = -t699 - t14109 + t14113 - t14116 + t14119 - t14164 + t16643 - t16645 - t16647 + t16649 + t16651 - t16655 + t1415 * t3996 / 0.4e1 + 0.3e1 / 0.16e2 * t484 * t16658 * t968 - 0.3e1 / 0.16e2 * t1415 * t3978;
  t16665 = t2050 * t3977;
  t16694 = t1419 * t3996 / 0.8e1;
  t16696 = 0.3e1 / 0.32e2 * t1419 * t4000;
  t16698 = t1419 * t3988 / 0.32e2;
  t16700 = 0.3e1 / 0.64e2 * t1499 * t3978;
  t16701 = -0.3e1 / 0.16e2 * t484 * t16665 - t1415 * t3982 / 0.8e1 - t484 * t2013 * t3981 / 0.8e1 + 0.3e1 / 0.32e2 * t1493 * t3985 + 0.3e1 / 0.32e2 * t1503 * t3985 + 0.3e1 / 0.32e2 * t469 * t2845 * t7446 + 0.3e1 / 0.16e2 * t1415 * t3974 - t91 * t3969 * t832 / 0.32e2 - t23 * t26 * t16329 * t832 / 0.32e2 - t3970 * t3041 / 0.32e2 - t3970 * t3044 / 0.32e2 + t16694 - t16696 - t16698 - t16700;
  t16729 = t484 * t16658 * t939 / 0.4e1 - 0.3e1 / 0.16e2 * t1415 * t4000 - 0.3e1 / 0.16e2 * t484 * t7472 * t3999 - t1415 * t3988 / 0.16e2 - t484 * t16658 * t1031 / 0.16e2 - 0.3e1 / 0.32e2 * t1493 * t3978 - 0.3e1 / 0.32e2 * t1503 * t3978 - 0.3e1 / 0.32e2 * t469 * t16665 + 0.3e1 / 0.32e2 * t1493 * t3993 + 0.3e1 / 0.32e2 * t1503 * t3993 + 0.3e1 / 0.32e2 * t469 * t2849 * t7428 + t14190 - t14193 - t14201 + t14215;
  t16730 = t14733 - t14734 - t14735 - t14736 + t14739 + t14740 - t14741 - t14742 + t14743 - t14219 - t14221 + t14223 + t14226 - t14246 - t14251 + t14253;
  t16733 = t14255 - t14289 + t14298 + t14301 - t14311 - t14313 - t14835 - t14836 - t14837 + t14838 + t14839 - t14840 - t14841 + t14842 + t14843;
  t16737 = t3973 * t943;
  t16741 = t14682 * t111;
  t16745 = t3973 * t263;
  t16746 = t16745 * t12911;
  t16749 = t2668 * t16741;
  t16761 = t3973 * t111;
  t16768 = t14844 + t14845 - t14846 - t14849 - 0.15e2 / 0.32e2 * t469 * t14651 * t14150 - 0.25e2 / 0.16e2 * t484 * t16737 * t12900 + 0.15e2 / 0.16e2 * t484 * t9925 * t16741 - 0.3e1 / 0.2e1 * t484 * t16746 + 0.9e1 / 0.8e1 * t484 * t16749 + 0.11e2 / 0.16e2 * t484 * t16745 * t12891 + 0.11e2 / 0.16e2 * t469 * t16749 - t3970 * t3009 / 0.16e2 + t3970 * t2995 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t16761 * t4378 - t484 * t16761 * t4311 / 0.16e2;
  t16781 = t2455 * t11530;
  t16787 = t2655 * t16741;
  t16792 = t9929 * t798;
  t16811 = t3973 * t43;
  t16815 = t484 * t2998 * t6478 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2668 * t10751 - t484 * t3012 * t6474 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t16746 - 0.3e1 / 0.16e2 * t469 * t16781 + 0.3e1 / 0.16e2 * t469 * t2994 * t11530 + 0.11e2 / 0.16e2 * t484 * t16787 - 0.3e1 / 0.8e1 * t484 * t16781 - 0.9e1 / 0.16e2 * t469 * t5804 * t16792 + 0.3e1 / 0.8e1 * t484 * t2659 * t16741 - t484 * t2659 * t10751 / 0.4e1 - 0.11e2 / 0.32e2 * t469 * t5799 * t16792 + 0.3e1 / 0.16e2 * t469 * t3021 * t11530 + 0.3e1 / 0.8e1 * t484 * t3012 * t6651 - 0.11e2 / 0.16e2 * t484 * t16811 * t13592;
  t16820 = 0.9e1 / 0.16e2 * t469 * t16787 + t3970 * t3022 / 0.16e2 + t3559 + t3562 - t3567 - t3571 + t3659 - t3660 - t3661 + t3662 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t16824 = my_piecewise3(t2, 0, t16664 + t16701 + t16729 + t16730 + t16733 + t16768 + t16815 + t16820);
  tv4rholapl2tau0 = t3 * t16824 + t4004;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  t16827 = 0.3e1 / 0.32e2 * t1589 * t4010;
  t16829 = 0.3e1 / 0.32e2 * t1589 * t4014;
  t16833 = t60 * t95 * t3928 * t849 / 0.64e2;
  t16856 = 0.3e1 / 0.64e2 * t1578 * t4029;
  t16858 = t1589 * t4032 / 0.8e1;
  t16860 = 0.3e1 / 0.32e2 * t1589 * t4036;
  t16862 = t1589 * t4018 / 0.16e2;
  t16864 = 0.3e1 / 0.64e2 * t1578 * t4021;
  t16866 = t1589 * t4024 / 0.32e2;
  t16867 = t16827 - t16829 - t16833 - 0.3e1 / 0.32e2 * t1574 * t4014 + 0.3e1 / 0.32e2 * t1574 * t4029 + t1585 * t4032 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t4036 - t1585 * t4018 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t4021 - t1585 * t4024 / 0.16e2 + 0.3e1 / 0.16e2 * t1585 * t4010 - 0.3e1 / 0.16e2 * t1585 * t4014 - t128 * t4005 * t849 / 0.32e2 + t16856 + t16858 - t16860 - t16862 + t16864 - t16866;
  t16869 = 0.3e1 / 0.64e2 * t1578 * t4014;
  t16870 = -t16869 + t14341 - t14345 + t14347 - t14355 - t14357 + t14359 - t14380 + t14382 + t14914 - t14916 - t14917 + t14918 - t14919 + t14920 + t14921 - t14922 - t2336 - t2338;
  t16872 = my_piecewise3(t51, 0, t16867 + t16870);
  tv4rholapl2tau5 = t3 * t16872 + t4040;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  t16895 = 0.3e1 / 0.32e2 * t1548 * t3993 + t1553 * t3996 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t4000 - t1553 * t3982 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3985 - t1553 * t3988 / 0.16e2 + 0.3e1 / 0.16e2 * t1553 * t3974 - 0.3e1 / 0.16e2 * t1553 * t3978 - t143 * t3969 * t832 / 0.32e2 - 0.3e1 / 0.32e2 * t1548 * t3978 + t16643 - t16645 - t16647 + t16649 + t16651 - t16655 + t16694 - t16696 - t16698;
  t16896 = -t16700 - t14416 - t14418 + t14420 + t14422 - t14246 - t14251 + t14253 + t14255 + t14957 - t14959 - t14960 + t14961 + t14838 + t14839 - t14840 - t14841 - t2357 - t2314;
  t16898 = my_piecewise3(t2, 0, t16895 + t16896);
  tv4rholapl2tau6 = t3 * t16898 + t4004;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  t16909 = t670 * t815;
  t16917 = t2937 * t8029;
  t16920 = -t721 - t14441 + t14445 + t14449 - t14452 + t14455 - t14459 + 0.3e1 / 0.32e2 * t1681 * t4021 + 0.3e1 / 0.32e2 * t1655 * t4021 + 0.3e1 / 0.32e2 * t519 * t2937 * t8152 - t1678 * t4024 / 0.16e2 - t534 * t16909 * t1361 / 0.16e2 - 0.3e1 / 0.32e2 * t1681 * t4014 - 0.3e1 / 0.32e2 * t1655 * t4014 - 0.3e1 / 0.32e2 * t519 * t16917;
  t16958 = 0.3e1 / 0.16e2 * t1678 * t4010 + 0.3e1 / 0.16e2 * t534 * t16909 * t1392 - 0.3e1 / 0.16e2 * t1678 * t4014 - 0.3e1 / 0.16e2 * t534 * t16917 - t60 * t26 * t16606 * t849 / 0.32e2 - t4006 * t3165 / 0.32e2 - t4006 * t3168 / 0.32e2 - t153 * t4005 * t849 / 0.32e2 + 0.3e1 / 0.32e2 * t1681 * t4029 + 0.3e1 / 0.32e2 * t1655 * t4029 + 0.3e1 / 0.32e2 * t519 * t2941 * t8033 + t1678 * t4032 / 0.4e1 + t534 * t16909 * t1379 / 0.4e1 - 0.3e1 / 0.16e2 * t1678 * t4036 - 0.3e1 / 0.16e2 * t534 * t8008 * t4035;
  t16965 = -t1678 * t4018 / 0.8e1 - t534 * t2212 * t4017 / 0.8e1 + t16827 - t16829 - t16833 + t16856 + t16858 - t16860 - t16862 + t16864 - t16866 - t16869 - t14498 - t14543 + t14547;
  t16966 = -t15059 + t15060 - t15061 + t15062 - t15065 + t15066 + t15067 - t15068 - t15069 - t14556 - t14558 - t14561 - t14563 - t14567 + t14569 + t14572;
  t16969 = t14616 + t14619 + t14347 - t14355 - t14357 + t14359 + t15143 + t15144 + t15145 - t15146 - t15147 - t15148 - t15149 - t15150 + t15151;
  t16970 = t4009 * t418;
  t16974 = t2941 * t1384;
  t16975 = t16974 * t14474;
  t16978 = t11224 * t5249;
  t16982 = t4009 * t1370;
  t16986 = t14976 * t168;
  t16992 = t16970 * t13289;
  t16999 = t4009 * t168;
  t17006 = -t14919 + t14920 + t14921 - t14922 + 0.11e2 / 0.16e2 * t534 * t16970 * t13272 + 0.11e2 / 0.16e2 * t519 * t16975 - 0.15e2 / 0.32e2 * t519 * t16978 * t14474 - 0.25e2 / 0.16e2 * t534 * t16982 * t13277 + 0.15e2 / 0.16e2 * t534 * t10491 * t16986 + t4006 * t3113 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t16992 + 0.9e1 / 0.8e1 * t534 * t16975 - t4006 * t3109 / 0.16e2 + 0.3e1 / 0.8e1 * t534 * t16999 * t5324 - t534 * t16999 * t5233 / 0.16e2;
  t17025 = t3108 * t12022;
  t17031 = t4009 * t75;
  t17035 = 0.3e1 / 0.16e2 * t519 * t3112 * t12022 + t534 * t3116 * t7089 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2779 * t11190 + 0.3e1 / 0.16e2 * t519 * t3132 * t12022 - t534 * t3123 * t7085 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t16992 - 0.3e1 / 0.16e2 * t519 * t17025 + 0.3e1 / 0.8e1 * t534 * t3123 * t7214 - 0.11e2 / 0.16e2 * t534 * t17031 * t13912 + t3603 - t3608 - t3612 + t3615 + t3703 + t3704;
  t17036 = t10482 * t815;
  t17037 = t7315 * t17036;
  t17058 = -t3705 - t3702 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338 + 0.9e1 / 0.16e2 * t519 * t17037 + 0.11e2 / 0.16e2 * t534 * t17037 - 0.3e1 / 0.8e1 * t534 * t17025 - 0.9e1 / 0.16e2 * t519 * t7299 * t17036 + 0.3e1 / 0.8e1 * t534 * t2789 * t16986 - t534 * t2789 * t11190 / 0.4e1 - 0.11e2 / 0.32e2 * t519 * t6444 * t17036 + t4006 * t3133 / 0.16e2;
  t17062 = my_piecewise3(t51, 0, t16920 + t16958 + t16965 + t16966 + t16969 + t17006 + t17035 + t17058);
  tv4rholapl2tau11 = t3 * t17062 + t4040;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  t17085 = t3181 * t6474;
  t17100 = -t699 + 0.3e1 / 0.32e2 * t1503 * t4064 + 0.3e1 / 0.32e2 * t469 * t3185 * t6478 + t1415 * t4067 / 0.4e1 + t484 * t3181 * t6478 / 0.4e1 - t1415 * t4059 / 0.16e2 - t484 * t866 * t563 * t1031 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t3199 * t6651 - 0.3e1 / 0.16e2 * t1415 * t4048 - 0.3e1 / 0.16e2 * t484 * t17085 - t1415 * t4052 / 0.8e1 - t484 * t3199 * t16189 / 0.8e1 + 0.3e1 / 0.32e2 * t1493 * t4055 + 0.3e1 / 0.32e2 * t1503 * t4055 + 0.3e1 / 0.32e2 * t469 * t3181 * t6651;
  t17108 = 0.3e1 / 0.32e2 * t1419 * t4071;
  t17110 = 0.3e1 / 0.64e2 * t1499 * t4048;
  t17112 = 0.3e1 / 0.64e2 * t1499 * t4064;
  t17114 = t1419 * t4067 / 0.8e1;
  t17116 = t1419 * t4059 / 0.32e2;
  t17118 = 0.3e1 / 0.32e2 * t1419 * t4048;
  t17120 = t1419 * t4052 / 0.16e2;
  t17122 = 0.3e1 / 0.64e2 * t1499 * t4055;
  t17124 = 0.3e1 / 0.32e2 * t1419 * t4045;
  t17132 = -t3970 * t3203 / 0.16e2 + t3970 * t3206 / 0.16e2 + 0.3e1 / 0.16e2 * t1415 * t4045 - t17108 - t17110 + t17112 + t17114 - t17116 - t17118 - t17120 + t17122 + t17124 - 0.3e1 / 0.16e2 * t1415 * t4071 - 0.3e1 / 0.16e2 * t484 * t3185 * t16174 - 0.3e1 / 0.32e2 * t1493 * t4048;
  t17144 = -0.3e1 / 0.32e2 * t1503 * t4048 - 0.3e1 / 0.32e2 * t469 * t17085 + 0.3e1 / 0.32e2 * t1493 * t4064 - t3970 * t3182 / 0.16e2 + t3970 * t3186 / 0.16e2 - t15705 + t15706 - t15707 + t15709 - t15710 + t15711 - t15712 - t15713 + t15714 + t13488;
  t17145 = -t13492 - t13524 - t13527 + t13531 + t13535 - t13538 - t13549 + t13553 - t15798 - t15799 + t15800 + t15801 - t15802 - t15803 + t15804;
  t17148 = t15805 - t15806 + t15807 + t15808 - t15810 - t15811 - t13610 - t13612 - t13616 + t13636 + t13645 - t13647 - t13649 + t13673 + t13676;
  t17150 = t255 * t4042 / 0.64e2;
  t17157 = t13690 + t13693 - t13695 - t13697 - t17150 - t246 * t4042 / 0.32e2 - t99 * t16329 * t866 * t269 / 0.32e2 + t3815 + t3816 - t3817 - t3818 + t3450 - t3453 - t3457 + t3461;
  t17159 = t15672 * t13518;
  t17162 = t15676 * t13518;
  t17165 = t4058 * t263;
  t17183 = t3199 * t265;
  t17187 = t15822 * t199;
  t17188 = t5783 * t17187;
  t17193 = t2655 * t11541;
  t17204 = -0.3e1 / 0.2e1 * t484 * t17159 + 0.9e1 / 0.8e1 * t484 * t17162 + 0.11e2 / 0.16e2 * t484 * t17165 * t12891 + 0.11e2 / 0.16e2 * t469 * t17162 - 0.15e2 / 0.32e2 * t469 * t15664 * t13518 - 0.25e2 / 0.16e2 * t484 * t15691 * t13518 + 0.15e2 / 0.16e2 * t484 * t15695 * t13518 + 0.3e1 / 0.8e1 * t484 * t15842 * t11541 - 0.11e2 / 0.16e2 * t484 * t17183 * t13518 + 0.9e1 / 0.16e2 * t469 * t17188 - 0.7e1 / 0.32e2 * t469 * t17159 - 0.3e1 / 0.8e1 * t484 * t17193 + 0.11e2 / 0.16e2 * t484 * t17188 - 0.9e1 / 0.16e2 * t469 * t5804 * t17187 - t484 * t2659 * t11541 / 0.4e1;
  t17232 = t5535 * t199;
  t17236 = 0.3e1 / 0.8e1 * t484 * t15834 * t13518 - 0.11e2 / 0.32e2 * t469 * t5799 * t17187 + 0.3e1 / 0.16e2 * t469 * t15827 * t11541 - 0.3e1 / 0.8e1 * t484 * t2668 * t11541 - 0.3e1 / 0.16e2 * t469 * t17193 + 0.3e1 / 0.16e2 * t469 * t12203 * t11541 + t484 * t12207 * t11541 / 0.2e1 - t484 * t3012 * t7424 / 0.8e1 - t484 * t4058 * t111 * t4311 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t15680 * t17232 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t17240 = my_piecewise3(t2, 0, t17100 + t17132 + t17144 + t17145 + t17148 + t17157 + t17204 + t17236);
  tv4rholapltau20 = t3 * t17240 + t4075;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  t17243 = 0.3e1 / 0.32e2 * t1589 * t4084;
  t17245 = 0.3e1 / 0.32e2 * t1589 * t4088;
  t17247 = 0.3e1 / 0.64e2 * t1578 * t4091;
  t17267 = 0.3e1 / 0.32e2 * t1589 * t4107;
  t17269 = 0.3e1 / 0.64e2 * t1578 * t4088;
  t17271 = 0.3e1 / 0.64e2 * t1578 * t4100;
  t17273 = t1589 * t4103 / 0.8e1;
  t17275 = t1589 * t4095 / 0.32e2;
  t17277 = t1589 * t4081 / 0.16e2;
  t17278 = t17243 - t17245 + t17247 - t1585 * t4081 / 0.8e1 + t1585 * t4103 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t4107 - t1585 * t4095 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t4088 + 0.3e1 / 0.32e2 * t1574 * t4100 + 0.3e1 / 0.16e2 * t1585 * t4084 - 0.3e1 / 0.16e2 * t1585 * t4088 + 0.3e1 / 0.32e2 * t1574 * t4091 - t17267 - t17269 + t17271 + t17273 - t17275 - t17277 + t15909;
  t17282 = t370 * t4077 / 0.64e2;
  t17283 = -t15911 + t15912 - t15913 - t15914 + t15915 - t15916 + t15917 + t13754 - t13759 - t13761 + t13763 - t13765 + t13767 + t13769 - t13775 - t367 * t4077 / 0.32e2 - t17282 - t2336 - t2338;
  t17285 = my_piecewise3(t51, 0, t17278 + t17283);
  tv4rholapltau25 = t3 * t17285 + t4111;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  t17305 = -t1553 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t4055 + 0.3e1 / 0.16e2 * t1553 * t4045 + t1553 * t4067 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t4071 - t1553 * t4059 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t4048 + 0.3e1 / 0.32e2 * t1548 * t4064 - 0.3e1 / 0.16e2 * t1553 * t4048 - t17108 - t17110 + t17112 + t17114 - t17116 - t17118 - t17120 + t17122 + t17124 - t15944;
  t17308 = -t15946 + t15947 + t15948 - t15802 - t15803 + t15804 + t15805 + t13843 - t13845 - t13847 + t13849 + t13636 + t13645 - t13647 - t13649 - t345 * t4042 / 0.32e2 - t17150 - t2357 - t2314;
  t17310 = my_piecewise3(t2, 0, t17305 + t17308);
  tv4rholapltau26 = t3 * t17310 + t4075;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  t17314 = t3284 * t7085;
  t17330 = -t721 - t15955 + t15956 + t15957 - t15958 + t15959 - t15960 - 0.3e1 / 0.16e2 * t1678 * t4088 - 0.3e1 / 0.16e2 * t534 * t17314 + 0.3e1 / 0.32e2 * t1681 * t4091 + 0.3e1 / 0.32e2 * t1655 * t4091 + 0.3e1 / 0.32e2 * t519 * t3284 * t7214 - t4006 * t3296 / 0.16e2 + t4006 * t3299 / 0.16e2 - t1678 * t4081 / 0.8e1;
  t17368 = -t534 * t3292 * t16458 / 0.8e1 + 0.3e1 / 0.16e2 * t1678 * t4084 - 0.3e1 / 0.32e2 * t1681 * t4088 - 0.3e1 / 0.32e2 * t1655 * t4088 - 0.3e1 / 0.32e2 * t519 * t17314 + 0.3e1 / 0.32e2 * t1681 * t4100 + 0.3e1 / 0.32e2 * t1655 * t4100 + 0.3e1 / 0.32e2 * t519 * t3276 * t7089 + t1678 * t4103 / 0.4e1 + t534 * t3284 * t7089 / 0.4e1 - 0.3e1 / 0.16e2 * t1678 * t4107 - 0.3e1 / 0.16e2 * t534 * t3276 * t16470 - t1678 * t4095 / 0.16e2 - t534 * t883 * t602 * t1361 / 0.16e2 + 0.3e1 / 0.16e2 * t534 * t3292 * t7214;
  t17374 = -t4006 * t3285 / 0.16e2 + t4006 * t3308 / 0.16e2 + t17243 - t17245 + t17247 - t17267 - t17269 + t17271 + t17273 - t17275 - t17277 - t15961 - t15962 + t15963 - t13879;
  t17375 = t13904 - t13938 + t13942 - t13945 + t13948 + t13954 - t13958 - t13981 - t16027 - t16028 - t16029 - t16030 - t16031 + t16032 + t16033;
  t17378 = t16037 + t16038 + t15912 - t15913 - t15914 + t15915 + t13994 + t13996 + t13999 - t14037 - t14039 - t14042 - t14044 - t14048 + t14050;
  t17385 = -t13765 + t13767 + t13769 - t13775 - t409 * t4077 / 0.32e2 - t156 * t16606 * t883 * t424 / 0.32e2 - t17282 + t3852 - t3853 - t3854 + t3855 + t3509 + t3513 - t3520 - t3505;
  t17390 = t4094 * t418;
  t17394 = t16052 * t13860;
  t17403 = t3284 * t450;
  t17404 = t17403 * t13860;
  t17407 = t16060 * t13860;
  t17414 = t3781 * t12018;
  t17424 = t16083 * t207;
  t17431 = 0.15e2 / 0.16e2 * t534 * t16044 * t13860 + 0.11e2 / 0.16e2 * t534 * t17390 * t13272 + 0.11e2 / 0.16e2 * t519 * t17394 - 0.15e2 / 0.32e2 * t519 * t16056 * t13860 - 0.25e2 / 0.16e2 * t534 * t16040 * t13860 + 0.11e2 / 0.16e2 * t534 * t17404 - 0.3e1 / 0.2e1 * t534 * t17407 + 0.9e1 / 0.8e1 * t534 * t17394 - 0.7e1 / 0.32e2 * t519 * t17407 - 0.3e1 / 0.16e2 * t519 * t17414 + 0.3e1 / 0.8e1 * t534 * t12654 * t12018 + 0.9e1 / 0.16e2 * t519 * t17404 - 0.3e1 / 0.8e1 * t534 * t17414 - 0.9e1 / 0.16e2 * t519 * t7299 * t17424 + 0.3e1 / 0.16e2 * t519 * t16106 * t12018;
  t17463 = -t534 * t2789 * t12018 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t16099 * t13860 - 0.11e2 / 0.32e2 * t519 * t6444 * t17424 - 0.3e1 / 0.8e1 * t534 * t2779 * t12018 + 0.3e1 / 0.16e2 * t519 * t16117 * t12018 + t534 * t10459 * t12018 / 0.2e1 - t534 * t3123 * t8029 / 0.8e1 + 0.3e1 / 0.8e1 * t534 * t16070 * t7128 - t534 * t4094 * t168 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t16070 * t7236 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t17467 = my_piecewise3(t51, 0, t17330 + t17368 + t17374 + t17375 + t17378 + t17385 + t17431 + t17463);
  tv4rholapltau211 = t3 * t17467 + t4111;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t17469 = t4122 * t111;
  t17477 = t23 * t26 * t4117;
  t17485 = t4122 * t43;
  t17489 = t5535 * t4122;
  t17490 = t470 * t17489;
  t17493 = t3181 * t7424;
  t17499 = t5550 * t4122;
  t17518 = t470 * t17499;
  t17528 = t5612 * t4122;
  t17535 = -0.9e1 / 0.16e2 * t469 * t5803 * t17499 - 0.9e1 / 0.16e2 * t484 * t3185 * t1525 * t631 - 0.9e1 / 0.32e2 * t469 * t17493 + 0.9e1 / 0.32e2 * t469 * t3185 * t7428 + 0.3e1 / 0.4e1 * t484 * t3181 * t7428 - 0.3e1 / 0.16e2 * t484 * t3199 * t7424 - 0.7e1 / 0.32e2 * t469 * t17518 - 0.3e1 / 0.8e1 * t484 * t3199 * t1463 * t631 + 0.3e1 / 0.8e1 * t484 * t17485 * t12936 - 0.11e2 / 0.32e2 * t469 * t470 * t17528 + 0.9e1 / 0.32e2 * t469 * t3181 * t7446;
  t17537 = t4122 * t943;
  t17541 = t4122 * t4327;
  t17551 = t17537 * t12891;
  t17554 = t4122 * t263;
  t17565 = -0.25e2 / 0.16e2 * t484 * t17537 * t12900 + 0.15e2 / 0.16e2 * t484 * t17541 * t12907 - t17477 * t3182 / 0.16e2 + t17477 * t3186 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t17518 + 0.9e1 / 0.8e1 * t484 * t17551 + 0.11e2 / 0.16e2 * t484 * t17554 * t12891 + 0.11e2 / 0.16e2 * t469 * t17551 - 0.15e2 / 0.32e2 * t469 * t17541 * t12900 - 0.9e1 / 0.16e2 * t14108 + 0.9e1 / 0.32e2 * t14112;
  t17577 = -0.3e1 / 0.8e1 * t14115 + 0.9e1 / 0.32e2 * t14118 - 0.3e1 / 0.16e2 * t14163 + 0.3e1 / 0.4e1 * t14189 - 0.9e1 / 0.16e2 * t14192 - 0.9e1 / 0.32e2 * t14200 + 0.9e1 / 0.16e2 * t14214 - 0.3e1 / 0.32e2 * t14218 - 0.3e1 / 0.16e2 * t14220 + 0.3e1 / 0.16e2 * t14222 + 0.3e1 / 0.16e2 * t14225;
  t17580 = 0.3e1 / 0.64e2 * t14245;
  t17581 = 0.3e1 / 0.32e2 * t14250;
  t17582 = 0.3e1 / 0.32e2 * t14252;
  t17583 = 0.3e1 / 0.32e2 * t14254;
  t17592 = t1000 * t4122;
  t17618 = 0.3e1 / 0.32e2 * t99 * t17592 * t1036 + t246 * t4150 / 0.4e1 - 0.3e1 / 0.16e2 * t246 * t4153 - 0.3e1 / 0.16e2 * t246 * t4127 - t246 * t4130 / 0.8e1 + 0.3e1 / 0.32e2 * t246 * t4134 + 0.3e1 / 0.32e2 * t99 * t17592 * t964 - t246 * t4141 / 0.16e2 - 0.3e1 / 0.32e2 * t246 * t4144 - 0.3e1 / 0.32e2 * t99 * t17592 * t956 - t246 * t4119 / 0.32e2;
  t17626 = t214 * t263;
  t17629 = t214 * t43;
  t17632 = t4428 * t213;
  t17636 = t266 * t268 * t213;
  t17660 = t13033 * t626 / 0.4e1 + t633 / 0.2e1 + t214 * t111 * t290 / 0.2e1 - t17626 * t491 / 0.2e1 - t17629 * t497 / 0.2e1 - t17632 * t13048 / 0.2e1 + t13051 * t17636 / 0.2e1 + t993 * t631 * t116 / 0.2e1 + t4112 * t13060 / 0.2e1 - t4112 * t13063 / 0.2e1 - t4112 * t13066 / 0.2e1 - t4446 * t213 * t116 / 0.2e1 - t996 * t631 * t116 / 0.2e1 - t4114 * t13060 / 0.2e1 + t4114 * t13063 / 0.2e1 + t4114 * t13066 / 0.2e1;
  t17668 = 0.3e1 / 0.64e2 * t255 * t4144;
  t17670 = 0.3e1 / 0.64e2 * t255 * t4147;
  t17672 = t255 * t4150 / 0.8e1;
  t17674 = 0.3e1 / 0.32e2 * t255 * t4153;
  t17676 = t255 * t4141 / 0.32e2;
  t17678 = 0.3e1 / 0.64e2 * t255 * t4134;
  t17680 = 0.3e1 / 0.32e2 * t255 * t4124;
  t17682 = 0.3e1 / 0.32e2 * t255 * t4127;
  t17684 = t255 * t4130 / 0.16e2;
  t17685 = -t99 * t17660 * t866 * t269 / 0.32e2 + 0.3e1 / 0.16e2 * t246 * t4124 - t17668 + t17670 + t17672 - t17674 - t17676 + t17678 + t17680 - t17682 - t17684;
  t17687 = t255 * t4119 / 0.64e2;
  t17688 = -t17687 + t4137 + t4138 - t4139 - t4140 - t2240 + t2254 + t2277 - t2281 - t2314 - t2324;
  t17692 = my_piecewise3(t2, 0, 0.3e1 / 0.32e2 * t246 * t4147 + 0.11e2 / 0.16e2 * t484 * t17490 - t17477 * t3203 / 0.16e2 + t17477 * t3206 / 0.16e2 + 0.9e1 / 0.16e2 * t469 * t17490 - 0.9e1 / 0.16e2 * t484 * t17493 + 0.3e1 / 0.8e1 * t484 * t17469 * t4378 - t484 * t17469 * t4311 / 0.16e2 + 0.9e1 / 0.16e2 * t484 * t3199 * t7446 - 0.11e2 / 0.16e2 * t484 * t17485 * t13592 + t17688 + t17685 + t17618 - t17580 - t17581 + t17582 + t17583 + t17577 + t17565 + t17535 - t699 - 0.3e1 / 0.32e2 * t14312 - 0.3e1 / 0.32e2 * t14310 + 0.3e1 / 0.16e2 * t14300 + 0.3e1 / 0.16e2 * t14297 - 0.3e1 / 0.16e2 * t14288);
  tv4rhotau30 = t3 * t17692 + t4157;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t17696 = 0.3e1 / 0.32e2 * t14346;
  t17697 = 0.3e1 / 0.64e2 * t14354;
  t17698 = 0.3e1 / 0.32e2 * t14356;
  t17699 = 0.3e1 / 0.32e2 * t14358;
  t17703 = t370 * t4165 / 0.64e2;
  t17705 = 0.3e1 / 0.32e2 * t370 * t4170;
  t17716 = 0.3e1 / 0.16e2 * t14340 - 0.3e1 / 0.32e2 * t14344 + t17696 - t17697 - t17698 + t17699 - 0.3e1 / 0.16e2 * t14379 + 0.3e1 / 0.16e2 * t14381 - t17703 - t17705 - 0.3e1 / 0.16e2 * t367 * t4199 + 0.3e1 / 0.32e2 * t367 * t4177 + 0.3e1 / 0.16e2 * t367 * t4180 - t367 * t4187 / 0.16e2 - 0.3e1 / 0.32e2 * t367 * t4190;
  t17728 = 0.3e1 / 0.32e2 * t370 * t4199;
  t17730 = t370 * t4187 / 0.32e2;
  t17732 = 0.3e1 / 0.64e2 * t370 * t4190;
  t17734 = 0.3e1 / 0.64e2 * t370 * t4193;
  t17736 = t370 * t4196 / 0.8e1;
  t17738 = t370 * t4173 / 0.16e2;
  t17740 = 0.3e1 / 0.64e2 * t370 * t4177;
  t17742 = 0.3e1 / 0.32e2 * t370 * t4180;
  t17743 = 0.3e1 / 0.32e2 * t367 * t4193 + t367 * t4196 / 0.4e1 - t367 * t4165 / 0.32e2 - 0.3e1 / 0.16e2 * t367 * t4170 - t367 * t4173 / 0.8e1 - t17728 - t17730 - t17732 + t17734 + t17736 - t17738 + t17740 + t17742 - t2336 - t2338;
  t17745 = my_piecewise3(t51, 0, t17716 + t17743);
  tv4rhotau33 = t3 * t17745 + t4203;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t17765 = -0.3e1 / 0.32e2 * t14415 - 0.3e1 / 0.16e2 * t14417 + 0.3e1 / 0.16e2 * t14419 + 0.3e1 / 0.16e2 * t14421 - t17580 - t17581 + t17582 + t17583 - t345 * t4141 / 0.16e2 - 0.3e1 / 0.32e2 * t345 * t4144 + 0.3e1 / 0.32e2 * t345 * t4147 + t345 * t4150 / 0.4e1 - 0.3e1 / 0.16e2 * t345 * t4153 - t345 * t4119 / 0.32e2 + 0.3e1 / 0.16e2 * t345 * t4124;
  t17772 = -0.3e1 / 0.16e2 * t345 * t4127 - t345 * t4130 / 0.8e1 + 0.3e1 / 0.32e2 * t345 * t4134 - t17668 + t17670 + t17672 - t17674 - t17676 + t17678 + t17680 - t17682 - t17684 - t17687 - t2357 - t2314;
  t17774 = my_piecewise3(t2, 0, t17765 + t17772);
  tv4rhotau34 = t3 * t17774 + t4157;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t17776 = t4168 * t168;
  t17786 = t3284 * t8029;
  t17789 = t4168 * t418;
  t17790 = t17789 * t13295;
  t17793 = t6237 * t4168;
  t17801 = t4168 * t75;
  t17805 = t6359 * t4168;
  t17817 = t60 * t26 * t4163;
  t17824 = t4168 * t1370;
  t17825 = t17824 * t13272;
  t17828 = t4168 * t5247;
  t17842 = 0.9e1 / 0.32e2 * t519 * t3284 * t8152 + 0.9e1 / 0.16e2 * t534 * t3292 * t8152 - t17817 * t3296 / 0.16e2 + t17817 * t3299 / 0.16e2 - 0.9e1 / 0.16e2 * t534 * t17786 + 0.11e2 / 0.16e2 * t519 * t17825 - 0.15e2 / 0.32e2 * t519 * t17828 * t13277 - 0.25e2 / 0.16e2 * t534 * t17824 * t13277 + 0.15e2 / 0.16e2 * t534 * t17828 * t13284 - t17817 * t3285 / 0.16e2 + t17817 * t3308 / 0.16e2;
  t17844 = t17789 * t13289;
  t17871 = -0.3e1 / 0.2e1 * t534 * t17844 + 0.9e1 / 0.8e1 * t534 * t17825 + 0.9e1 / 0.16e2 * t519 * t17790 + 0.11e2 / 0.16e2 * t534 * t17789 * t13272 + 0.9e1 / 0.32e2 * t519 * t3276 * t8033 + 0.3e1 / 0.4e1 * t534 * t3284 * t8033 - 0.9e1 / 0.16e2 * t534 * t3276 * t1639 * t670 - 0.3e1 / 0.16e2 * t534 * t3292 * t8029 - 0.7e1 / 0.32e2 * t519 * t17844 - 0.9e1 / 0.32e2 * t14440 + 0.9e1 / 0.32e2 * t14444;
  t17883 = 0.3e1 / 0.4e1 * t14448 - 0.9e1 / 0.16e2 * t14451 + 0.9e1 / 0.16e2 * t14454 - 0.3e1 / 0.16e2 * t14458 - 0.9e1 / 0.16e2 * t14497 - 0.3e1 / 0.8e1 * t14542 + 0.9e1 / 0.32e2 * t14546 - 0.3e1 / 0.32e2 * t14555 - 0.3e1 / 0.32e2 * t14557 - 0.3e1 / 0.32e2 * t14560 - 0.3e1 / 0.16e2 * t14562;
  t17894 = t1329 * t4168;
  t17920 = -0.3e1 / 0.32e2 * t156 * t17894 * t1366 + 0.3e1 / 0.32e2 * t409 * t4193 + 0.3e1 / 0.32e2 * t156 * t17894 * t1374 + t409 * t4196 / 0.4e1 - 0.3e1 / 0.16e2 * t409 * t4199 - 0.3e1 / 0.16e2 * t409 * t4170 - t409 * t4173 / 0.8e1 + 0.3e1 / 0.32e2 * t409 * t4177 + 0.3e1 / 0.32e2 * t156 * t17894 * t1405 + 0.3e1 / 0.16e2 * t409 * t4180 - t409 * t4187 / 0.16e2;
  t17930 = t220 * t418;
  t17933 = t220 * t75;
  t17936 = t5348 * t219;
  t17940 = t421 * t423 * t219;
  t17964 = t13394 * t665 / 0.4e1 + t672 / 0.2e1 + t220 * t168 * t445 / 0.2e1 - t17930 * t541 / 0.2e1 - t17933 * t547 / 0.2e1 - t17936 * t13409 / 0.2e1 + t13412 * t17940 / 0.2e1 + t1322 * t670 * t173 / 0.2e1 + t4158 * t13421 / 0.2e1 - t4158 * t13424 / 0.2e1 - t4158 * t13427 / 0.2e1 - t5366 * t219 * t173 / 0.2e1 - t1325 * t670 * t173 / 0.2e1 - t4160 * t13421 / 0.2e1 + t4160 * t13424 / 0.2e1 + t4160 * t13427 / 0.2e1;
  t17969 = -t409 * t4165 / 0.32e2 - t156 * t17964 * t883 * t424 / 0.32e2 - t17703 - t17705 - t17728 - t17730 - t17732 + t17734 + t17736 - t17738 + t17740;
  t17970 = t17742 + t4183 - t4184 - t4185 + t4186 + t2370 + t2404 - t2408 - t2423 - t2440 - t2338;
  t17974 = my_piecewise3(t51, 0, -0.3e1 / 0.32e2 * t409 * t4190 - 0.9e1 / 0.32e2 * t519 * t17786 + 0.11e2 / 0.16e2 * t534 * t17790 - 0.3e1 / 0.8e1 * t534 * t3292 * t1701 * t670 - t534 * t17776 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t17776 * t5298 + 0.3e1 / 0.8e1 * t534 * t17776 * t5324 - 0.9e1 / 0.16e2 * t519 * t7298 * t17793 + 0.3e1 / 0.8e1 * t534 * t17801 * t13330 - 0.11e2 / 0.32e2 * t519 * t520 * t17805 - t17697 - t17698 + t17699 + t17696 + t17969 + t17970 + t17920 + t17883 + t17871 + t17842 + 0.3e1 / 0.16e2 * t14615 + 0.3e1 / 0.16e2 * t14618 - t721 - 0.3e1 / 0.16e2 * t14566 + 0.3e1 / 0.16e2 * t14568 + 0.3e1 / 0.16e2 * t14571);
  tv4rhotau37 = t3 * t17974 + t4203;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t17976 = t695 * t690;
  t17978 = t484 * t17976 * t939;
  t17981 = t484 * t8259 * t3496;
  t17984 = t484 * t17976 * t1031;
  t17987 = t484 * t17976 * t968;
  t17989 = t1458 * t695;
  t17990 = t2241 * t17989;
  t17991 = t469 * t17990;
  t17994 = t469 * t2246 * t8282;
  t17997 = t469 * t2241 * t8394;
  t17999 = t484 * t17990;
  t18001 = t1463 * t695;
  t18003 = t484 * t2262 * t18001;
  t18005 = t3463 * t3345;
  t18007 = t690 * t690;
  t18008 = t260 * t18007;
  t18012 = t100 * t18007;
  t18019 = t695 * t695;
  t18023 = 0.3e1 / 0.32e2 * t99 * t260 * t18019 * t269;
  t18030 = t3363 * t3337;
  t18035 = t697 / 0.2e1;
  t18047 = t993 * t695 * t116 / 0.2e1;
  t18048 = t993 * t690;
  t18055 = t258 * t3363;
  t18061 = t996 * t695 * t116 / 0.2e1;
  t18062 = t996 * t690;
  t18069 = t692 / 0.4e1 + t18035 + t701 / 0.2e1 - t704 / 0.2e1 - t707 / 0.2e1 - t4428 * t690 * t269 / 0.2e1 + t4432 * t690 * t269 / 0.2e1 + t18047 + t18048 * t290 / 0.2e1 - t18048 * t297 / 0.2e1 - t18048 * t301 / 0.2e1 - t18055 * t183 * t116 / 0.2e1 - t18061 - t18062 * t290 / 0.2e1 + t18062 * t297 / 0.2e1 + t18062 * t301 / 0.2e1;
  t18074 = -t699 + 0.3e1 / 0.2e1 * t17978 - 0.9e1 / 0.8e1 * t17981 - 0.3e1 / 0.8e1 * t17984 + 0.9e1 / 0.8e1 * t17987 - 0.9e1 / 0.16e2 * t17991 + 0.9e1 / 0.16e2 * t17994 + 0.9e1 / 0.16e2 * t17997 - 0.9e1 / 0.8e1 * t17999 - 0.3e1 / 0.4e1 * t18003 - 0.5e1 / 0.32e2 * t18005 + 0.9e1 / 0.16e2 * t99 * t18008 * t4335 + 0.11e2 / 0.16e2 * t99 * t18012 * t4335 + 0.3e1 / 0.8e1 * t99 * t18012 * t4499 - t18023 - 0.7e1 / 0.32e2 * t99 * t18008 * t4277 - 0.11e2 / 0.32e2 * t99 * t18008 * t4415 + 0.5e1 / 0.32e2 * t99 * t18030 * t964 - t99 * t18069 * t690 * t269 / 0.32e2;
  t18114 = t100 * t18019;
  t18117 = 0.3e1 / 0.16e2 * t99 * t18114 * t297;
  t18120 = 0.3e1 / 0.16e2 * t99 * t18114 * t290;
  t18123 = 0.3e1 / 0.16e2 * t99 * t18114 * t301;
  t18128 = -0.9e1 / 0.16e2 * t99 * t18008 * t4524 - 0.11e2 / 0.16e2 * t99 * t18012 * t4316 + 0.3e1 / 0.8e1 * t99 * t18012 * t4378 - t99 * t18012 * t4311 / 0.16e2 + 0.5e1 / 0.32e2 * t99 * t18030 * t1036 + 0.11e2 / 0.16e2 * t99 * t18012 * t4343 + 0.11e2 / 0.16e2 * t99 * t18008 * t4347 - 0.15e2 / 0.32e2 * t99 * t18008 * t4352 - 0.25e2 / 0.16e2 * t99 * t18012 * t4323 + 0.15e2 / 0.16e2 * t99 * t18012 * t4331 - 0.5e1 / 0.32e2 * t99 * t18030 * t956 + 0.9e1 / 0.8e1 * t99 * t18012 * t4347 - 0.3e1 / 0.2e1 * t99 * t18012 * t4277 + t18117 - t18120 + t18123 + t3382 / 0.4e1 - t3346 / 0.8e1 + t3353 / 0.4e1 - t3370 / 0.4e1;
  t18130 = my_piecewise3(t2, 0, t18074 + t18128);
  tv4sigma40 = t3 * t18130;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t18131 = t717 * t712;
  t18133 = t534 * t18131 * t1361;
  t18136 = t519 * t2376 * t8840;
  t18139 = t534 * t18131 * t1379;
  t18142 = t534 * t8899 * t3551;
  t18144 = t1623 * t717;
  t18145 = t2371 * t18144;
  t18146 = t519 * t18145;
  t18149 = t534 * t18131 * t1392;
  t18152 = t519 * t2371 * t8980;
  t18154 = t3515 * t3400;
  t18156 = t534 * t18145;
  t18158 = t1701 * t717;
  t18160 = t534 * t2389 * t18158;
  t18162 = t717 * t717;
  t18163 = t157 * t18162;
  t18166 = 0.3e1 / 0.16e2 * t156 * t18163 * t452;
  t18169 = 0.3e1 / 0.16e2 * t156 * t18163 * t445;
  t18173 = 0.3e1 / 0.32e2 * t156 * t415 * t18162 * t424;
  t18176 = 0.3e1 / 0.16e2 * t156 * t18163 * t456;
  t18177 = t712 * t712;
  t18178 = t157 * t18177;
  t18186 = t719 / 0.2e1;
  t18198 = t1322 * t717 * t173 / 0.2e1;
  t18199 = t1322 * t712;
  t18206 = t413 * t3418;
  t18212 = t1325 * t717 * t173 / 0.2e1;
  t18213 = t1325 * t712;
  t18220 = t714 / 0.4e1 + t18186 + t723 / 0.2e1 - t726 / 0.2e1 - t729 / 0.2e1 - t5348 * t712 * t424 / 0.2e1 + t5352 * t712 * t424 / 0.2e1 + t18198 + t18199 * t445 / 0.2e1 - t18199 * t452 / 0.2e1 - t18199 * t456 / 0.2e1 - t18206 * t191 * t173 / 0.2e1 - t18212 - t18213 * t445 / 0.2e1 + t18213 * t452 / 0.2e1 + t18213 * t456 / 0.2e1;
  t18225 = t415 * t18177;
  t18229 = -t721 - 0.3e1 / 0.8e1 * t18133 + 0.9e1 / 0.16e2 * t18136 + 0.3e1 / 0.2e1 * t18139 - 0.9e1 / 0.8e1 * t18142 - 0.9e1 / 0.16e2 * t18146 + 0.9e1 / 0.8e1 * t18149 + 0.9e1 / 0.16e2 * t18152 - 0.5e1 / 0.32e2 * t18154 - 0.9e1 / 0.8e1 * t18156 - 0.3e1 / 0.4e1 * t18160 + t18166 - t18169 - t18173 + t18176 + 0.11e2 / 0.16e2 * t156 * t18178 * t5302 + 0.3e1 / 0.8e1 * t156 * t18178 * t5426 - t156 * t18220 * t712 * t424 / 0.32e2 - 0.7e1 / 0.32e2 * t156 * t18225 * t5270;
  t18236 = t3418 * t3392;
  t18283 = -0.9e1 / 0.16e2 * t156 * t18225 * t5306 - 0.11e2 / 0.32e2 * t156 * t18225 * t5410 + 0.5e1 / 0.32e2 * t156 * t18236 * t1405 + 0.3e1 / 0.8e1 * t156 * t18178 * t5324 - t156 * t18178 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t156 * t18178 * t5298 + 0.11e2 / 0.16e2 * t156 * t18225 * t5243 - 0.15e2 / 0.32e2 * t156 * t18225 * t5251 - 0.25e2 / 0.16e2 * t156 * t18178 * t5256 + 0.15e2 / 0.16e2 * t156 * t18178 * t5263 + 0.9e1 / 0.8e1 * t156 * t18178 * t5243 + 0.9e1 / 0.16e2 * t156 * t18225 * t5302 - 0.5e1 / 0.32e2 * t156 * t18236 * t1366 + 0.5e1 / 0.32e2 * t156 * t18236 * t1374 + 0.11e2 / 0.16e2 * t156 * t18178 * t5238 - 0.3e1 / 0.2e1 * t156 * t18178 * t5270 - t3401 / 0.8e1 + t3408 / 0.4e1 - t3425 / 0.4e1 + t3437 / 0.4e1;
  t18285 = my_piecewise3(t51, 0, t18229 + t18283);
  tv4sigma414 = t3 * t18285;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t18286 = t199 * t3337;
  t18293 = t5739 * t3337;
  t18300 = t5703 * t199;
  t18301 = t12895 * t18300;
  t18307 = t18286 * t4277;
  t18320 = t572 * t5535 * t3337;
  t18323 = -t699 - t484 * t18286 * t4311 / 0.16e2 - 0.25e2 / 0.16e2 * t484 * t18286 * t4323 + 0.15e2 / 0.16e2 * t484 * t6516 * t18293 + 0.11e2 / 0.16e2 * t484 * t18286 * t4343 + 0.11e2 / 0.16e2 * t469 * t18301 - 0.15e2 / 0.32e2 * t469 * t12899 * t6680 - 0.3e1 / 0.2e1 * t484 * t18307 + 0.9e1 / 0.8e1 * t484 * t18301 - 0.5e1 / 0.32e2 * t3463 * t3473 + 0.5e1 / 0.32e2 * t3463 * t3490 + 0.3e1 / 0.8e1 * t484 * t18286 * t4378 + 0.11e2 / 0.16e2 * t484 * t18320;
  t18324 = t5483 * t3337;
  t18344 = t23 * t26 * t18069;
  t18347 = t3463 * t3451;
  t18348 = t18347 / 0.16e2;
  t18349 = 0.3e1 / 0.4e1 * t17978;
  t18350 = 0.9e1 / 0.16e2 * t17981;
  t18351 = 0.3e1 / 0.16e2 * t17984;
  t18352 = 0.9e1 / 0.16e2 * t17987;
  t18353 = 0.3e1 / 0.8e1 * t484 * t576 * t18324 + 0.5e1 / 0.32e2 * t3463 * t3480 - 0.11e2 / 0.16e2 * t484 * t18286 * t4316 - 0.7e1 / 0.32e2 * t469 * t18307 + 0.9e1 / 0.16e2 * t469 * t18320 - 0.9e1 / 0.16e2 * t469 * t12895 * t6688 - 0.11e2 / 0.32e2 * t469 * t12890 * t6674 - t18344 * t734 / 0.32e2 - t18348 + t18349 - t18350 - t18351 + t18352;
  t18355 = 0.9e1 / 0.32e2 * t17991;
  t18356 = 0.9e1 / 0.32e2 * t17994;
  t18357 = 0.9e1 / 0.32e2 * t17997;
  t18358 = 0.9e1 / 0.16e2 * t17999;
  t18359 = 0.3e1 / 0.8e1 * t18003;
  t18360 = 0.3e1 / 0.32e2 * t18005;
  t18361 = t2251 * t295;
  t18362 = t18361 * t3738;
  t18363 = t469 * t18362;
  t18364 = 0.9e1 / 0.32e2 * t18363;
  t18366 = t469 * t13528 * t3738;
  t18367 = 0.9e1 / 0.32e2 * t18366;
  t18369 = t484 * t13532 * t1517;
  t18370 = 0.3e1 / 0.4e1 * t18369;
  t18371 = -t18355 + t18356 + t18357 - t18358 - t18359 - t18360 - t18023 + t18117 - t18120 + t18123 - t18364 + t18367 + t18370;
  t18372 = t12854 * t183;
  t18374 = t484 * t2475 * t18372;
  t18375 = 0.9e1 / 0.16e2 * t18374;
  t18376 = t484 * t18362;
  t18377 = 0.9e1 / 0.16e2 * t18376;
  t18379 = t484 * t2471 * t8394;
  t18380 = 0.9e1 / 0.16e2 * t18379;
  t18383 = t484 * t3454 * t183 * t1031;
  t18384 = 0.3e1 / 0.16e2 * t18383;
  t18386 = t484 * t2461 * t18372;
  t18387 = 0.3e1 / 0.8e1 * t18386;
  t18389 = t469 * t2465 * t13550;
  t18390 = 0.9e1 / 0.32e2 * t18389;
  t18391 = -t18375 - t18377 + t18380 - t18384 - t18387 + t18390 + t3450 - t3453 - t3457 + t3461 + t3383 - t3347 + t3354 - t3371;
  t18394 = my_piecewise3(t2, 0, t18323 + t18353 + t18371 + t18391);
  tv4sigma3lapl0 = t3 * t18394;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t18395 = t6218 * t3392;
  t18399 = t13288 * t7128;
  t18405 = t207 * t3392;
  t18406 = t18405 * t5270;
  t18410 = t1964 * t6203 * t3392;
  t18431 = -t721 + 0.15e2 / 0.16e2 * t534 * t7135 * t18395 + 0.9e1 / 0.16e2 * t519 * t18399 - 0.9e1 / 0.16e2 * t519 * t13271 * t7242 - 0.3e1 / 0.2e1 * t534 * t18406 + 0.9e1 / 0.8e1 * t534 * t18410 + 0.11e2 / 0.16e2 * t534 * t18405 * t5238 - 0.5e1 / 0.32e2 * t3515 * t3531 + 0.5e1 / 0.32e2 * t3515 * t3545 + 0.3e1 / 0.8e1 * t534 * t18405 * t5324 - t534 * t18405 * t5233 / 0.16e2 + 0.11e2 / 0.16e2 * t519 * t18410 - 0.15e2 / 0.32e2 * t519 * t13276 * t7232;
  t18437 = t6288 * t3392;
  t18452 = t60 * t26 * t18220;
  t18455 = t3515 * t3518;
  t18456 = t18455 / 0.16e2;
  t18457 = 0.3e1 / 0.16e2 * t18133;
  t18458 = 0.9e1 / 0.32e2 * t18136;
  t18459 = 0.3e1 / 0.4e1 * t18139;
  t18460 = 0.9e1 / 0.16e2 * t18142;
  t18461 = -0.25e2 / 0.16e2 * t534 * t18405 * t5256 + 0.11e2 / 0.16e2 * t534 * t18399 + 0.3e1 / 0.8e1 * t534 * t615 * t18437 - 0.11e2 / 0.32e2 * t519 * t13288 * t7236 - 0.11e2 / 0.16e2 * t534 * t18405 * t5298 + 0.5e1 / 0.32e2 * t3515 * t3523 - 0.7e1 / 0.32e2 * t519 * t18406 - t18452 * t751 / 0.32e2 - t18456 - t18457 + t18458 + t18459 - t18460;
  t18463 = 0.9e1 / 0.32e2 * t18146;
  t18464 = 0.9e1 / 0.16e2 * t18149;
  t18465 = 0.9e1 / 0.32e2 * t18152;
  t18466 = 0.3e1 / 0.32e2 * t18154;
  t18467 = 0.9e1 / 0.16e2 * t18156;
  t18468 = 0.3e1 / 0.8e1 * t18160;
  t18471 = t534 * t3502 * t191 * t1361;
  t18472 = 0.3e1 / 0.16e2 * t18471;
  t18474 = t534 * t13901 * t1630;
  t18475 = 0.3e1 / 0.4e1 * t18474;
  t18476 = t13239 * t191;
  t18478 = t534 * t2582 * t18476;
  t18479 = 0.9e1 / 0.16e2 * t18478;
  t18480 = -t18463 + t18464 + t18465 - t18466 - t18467 - t18468 + t18166 - t18169 - t18173 + t18176 - t18472 + t18475 - t18479;
  t18482 = t534 * t13951 * t1707;
  t18483 = 0.9e1 / 0.16e2 * t18482;
  t18484 = t2568 * t13939;
  t18485 = t519 * t18484;
  t18486 = 0.9e1 / 0.32e2 * t18485;
  t18487 = t534 * t18484;
  t18488 = 0.9e1 / 0.16e2 * t18487;
  t18490 = t519 * t2574 * t13939;
  t18491 = 0.9e1 / 0.32e2 * t18490;
  t18493 = t534 * t2594 * t18476;
  t18494 = 0.3e1 / 0.8e1 * t18493;
  t18496 = t519 * t2598 * t13939;
  t18497 = 0.9e1 / 0.32e2 * t18496;
  t18498 = t18483 - t18486 - t18488 + t18491 - t18494 + t18497 + t3509 + t3513 - t3520 - t3505 - t3402 + t3409 - t3426 + t3438;
  t18501 = my_piecewise3(t51, 0, t18431 + t18461 + t18480 + t18498);
  tv4sigma3lapl19 = t3 * t18501;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t18502 = t213 * t3337;
  t18513 = t5535 * t213;
  t18514 = t12890 * t18513;
  t18520 = t18502 * t4277;
  t18524 = t2005 * t5703 * t3337;
  t18538 = -t699 - t484 * t18502 * t4311 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t18502 * t4378 - 0.5e1 / 0.32e2 * t3463 * t3579 + 0.5e1 / 0.32e2 * t3463 * t3590 + 0.9e1 / 0.16e2 * t469 * t18514 - 0.9e1 / 0.16e2 * t469 * t12895 * t7535 - 0.3e1 / 0.2e1 * t484 * t18520 + 0.9e1 / 0.8e1 * t484 * t18524 + 0.11e2 / 0.16e2 * t484 * t18502 * t4343 + 0.11e2 / 0.16e2 * t469 * t18524 - 0.15e2 / 0.32e2 * t469 * t12899 * t7392 - 0.25e2 / 0.16e2 * t484 * t18502 * t4323;
  t18557 = t3463 * t3565;
  t18558 = t18557 / 0.16e2;
  t18561 = 0.15e2 / 0.16e2 * t484 * t7399 * t18293 + 0.11e2 / 0.16e2 * t484 * t18514 + 0.3e1 / 0.8e1 * t484 * t644 * t18324 - 0.11e2 / 0.32e2 * t469 * t12890 * t7539 - 0.11e2 / 0.16e2 * t484 * t18502 * t4316 + 0.5e1 / 0.32e2 * t3463 * t3572 - 0.7e1 / 0.32e2 * t469 * t18520 - t18558 - t18344 * t768 / 0.32e2 + t18349 - t18350 - t18351 + t18352;
  t18564 = t484 * t2651 * t8394;
  t18565 = 0.9e1 / 0.16e2 * t18564;
  t18568 = t484 * t3568 * t183 * t1031;
  t18569 = 0.3e1 / 0.16e2 * t18568;
  t18571 = t484 * t12207 * t18372;
  t18572 = 0.3e1 / 0.4e1 * t18571;
  t18573 = -t18355 + t18356 + t18357 - t18358 - t18359 - t18360 - t18023 + t18117 - t18120 + t18123 + t18565 - t18569 + t18572;
  t18575 = t484 * t2668 * t18372;
  t18576 = 0.9e1 / 0.16e2 * t18575;
  t18577 = t18361 * t3745;
  t18578 = t469 * t18577;
  t18579 = 0.9e1 / 0.32e2 * t18578;
  t18580 = t484 * t18577;
  t18581 = 0.9e1 / 0.16e2 * t18580;
  t18583 = t469 * t2481 * t14110;
  t18584 = 0.9e1 / 0.32e2 * t18583;
  t18586 = t484 * t2659 * t18372;
  t18587 = 0.3e1 / 0.8e1 * t18586;
  t18589 = t469 * t2465 * t14110;
  t18590 = 0.9e1 / 0.32e2 * t18589;
  t18591 = -t18576 - t18579 - t18581 + t18584 - t18587 + t18590 + t3559 + t3562 - t3567 - t3571 + t3383 - t3347 + t3354 - t3371;
  t18594 = my_piecewise3(t2, 0, t18538 + t18561 + t18573 + t18591);
  tv4sigma3tau0 = t3 * t18594;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t18595 = t219 * t3392;
  t18602 = t13288 * t8109;
  t18607 = t3515 * t3606;
  t18608 = t18607 / 0.16e2;
  t18615 = t6203 * t219;
  t18616 = t13271 * t18615;
  t18623 = t13288 * t6247 * t219;
  t18631 = -t721 + 0.3e1 / 0.8e1 * t534 * t18595 * t5324 - t534 * t18595 * t5233 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t18602 - t18452 * t783 / 0.32e2 - t18608 - 0.25e2 / 0.16e2 * t534 * t18595 * t5256 + 0.15e2 / 0.16e2 * t534 * t8075 * t18395 + 0.11e2 / 0.16e2 * t519 * t18616 - 0.15e2 / 0.32e2 * t519 * t13276 * t8067 + 0.9e1 / 0.16e2 * t519 * t18623 - 0.9e1 / 0.16e2 * t519 * t13271 * t8109 - 0.3e1 / 0.2e1 * t534 * t18602;
  t18654 = 0.9e1 / 0.8e1 * t534 * t18616 + 0.11e2 / 0.16e2 * t534 * t18595 * t5238 - 0.5e1 / 0.32e2 * t3515 * t3623 + 0.5e1 / 0.32e2 * t3515 * t3634 + 0.11e2 / 0.16e2 * t534 * t18623 + 0.3e1 / 0.8e1 * t534 * t683 * t18437 - 0.11e2 / 0.32e2 * t519 * t13288 * t8113 - 0.11e2 / 0.16e2 * t534 * t18595 * t5298 + 0.5e1 / 0.32e2 * t3515 * t3616 - t18457 + t18458 + t18459 - t18460;
  t18656 = t14438 * t3774;
  t18657 = t519 * t18656;
  t18658 = 0.9e1 / 0.32e2 * t18657;
  t18660 = t519 * t14442 * t3774;
  t18661 = 0.9e1 / 0.32e2 * t18660;
  t18663 = t534 * t14446 * t1630;
  t18664 = 0.3e1 / 0.4e1 * t18663;
  t18665 = -t18463 + t18464 + t18465 - t18466 - t18467 - t18468 + t18166 - t18169 - t18173 + t18176 - t18658 + t18661 + t18664;
  t18667 = t534 * t2779 * t18476;
  t18668 = 0.9e1 / 0.16e2 * t18667;
  t18670 = t534 * t2765 * t8980;
  t18671 = 0.9e1 / 0.16e2 * t18670;
  t18674 = t534 * t3609 * t191 * t1361;
  t18675 = 0.3e1 / 0.16e2 * t18674;
  t18677 = t534 * t2789 * t18476;
  t18678 = 0.3e1 / 0.8e1 * t18677;
  t18680 = t519 * t2598 * t14544;
  t18681 = 0.9e1 / 0.32e2 * t18680;
  t18682 = t534 * t18656;
  t18683 = 0.9e1 / 0.16e2 * t18682;
  t18684 = -t18668 + t18671 - t18675 - t18678 + t18681 - t18683 + t3603 - t3608 - t3612 + t3615 - t3402 + t3409 - t3426 + t3438;
  t18687 = my_piecewise3(t51, 0, t18631 + t18654 + t18665 + t18684);
  tv4sigma3tau19 = t3 * t18687;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t18690 = t798 * t690;
  t18700 = t469 * t2849 * t8282;
  t18701 = 0.3e1 / 0.32e2 * t18700;
  t18703 = t484 * t2845 * t8282;
  t18704 = t18703 / 0.4e1;
  t18707 = t484 * t798 * t695 * t1031;
  t18708 = t18707 / 0.16e2;
  t18709 = t2241 * t10844;
  t18713 = t469 * t2845 * t8394;
  t18714 = 0.3e1 / 0.32e2 * t18713;
  t18716 = t484 * t2837 * t8394;
  t18717 = 0.3e1 / 0.16e2 * t18716;
  t18719 = t2241 * t5535 * t798;
  t18722 = t2845 * t17989;
  t18723 = t484 * t18722;
  t18724 = 0.3e1 / 0.16e2 * t18723;
  t18729 = t484 * t2837 * t18001;
  t18730 = t18729 / 0.8e1;
  t18731 = -t699 + 0.5e1 / 0.32e2 * t3463 * t3676 - t484 * t18690 * t4311 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t18690 * t4378 - 0.5e1 / 0.32e2 * t3463 * t3649 + t18701 + t18704 - t18708 - 0.7e1 / 0.32e2 * t469 * t18709 + t18714 + t18717 + 0.9e1 / 0.16e2 * t469 * t18719 - t18724 - 0.9e1 / 0.16e2 * t469 * t2246 * t10844 - t18730;
  t18737 = t5703 * t690;
  t18738 = t2849 * t18737;
  t18741 = t5730 * t690;
  t18748 = t5739 * t690;
  t18759 = t5483 * t690;
  t18768 = t1525 * t695;
  t18770 = t484 * t2849 * t18768;
  t18771 = 0.3e1 / 0.16e2 * t18770;
  t18772 = t469 * t18722;
  t18773 = 0.3e1 / 0.32e2 * t18772;
  t18775 = t17978 / 0.4e1;
  t18776 = -0.11e2 / 0.32e2 * t469 * t2241 * t10866 + 0.5e1 / 0.32e2 * t3463 * t3656 + 0.11e2 / 0.16e2 * t469 * t18738 - 0.15e2 / 0.32e2 * t469 * t10906 * t18741 - 0.25e2 / 0.16e2 * t484 * t2849 * t18741 + 0.15e2 / 0.16e2 * t484 * t10906 * t18748 + 0.11e2 / 0.16e2 * t484 * t18690 * t4343 - 0.3e1 / 0.2e1 * t484 * t18709 + 0.9e1 / 0.8e1 * t484 * t18738 + 0.3e1 / 0.8e1 * t484 * t2837 * t18759 - 0.11e2 / 0.16e2 * t484 * t2837 * t8409 + 0.11e2 / 0.16e2 * t484 * t18719 - t18771 - t18773 - t18347 / 0.8e1 + t18775;
  t18778 = 0.3e1 / 0.16e2 * t17981;
  t18779 = t17984 / 0.16e2;
  t18780 = 0.3e1 / 0.16e2 * t17987;
  t18781 = 0.3e1 / 0.32e2 * t17991;
  t18782 = 0.3e1 / 0.32e2 * t17994;
  t18783 = 0.3e1 / 0.32e2 * t17997;
  t18784 = 0.3e1 / 0.16e2 * t17999;
  t18785 = t18003 / 0.8e1;
  t18786 = t18005 / 0.32e2;
  t18792 = -t18778 - t18779 + t18780 - t18781 + t18782 + t18783 - t18784 - t18785 - t18786 - t99 * t18069 * t798 * t269 / 0.32e2 - t18023 + t18117 - t18120 + t18123 - 0.3e1 / 0.8e1 * t18363;
  t18800 = 0.3e1 / 0.8e1 * t18366 + t18369 - 0.3e1 / 0.4e1 * t18374 - 0.3e1 / 0.4e1 * t18376 + 0.3e1 / 0.4e1 * t18379 - t18383 / 0.4e1 - t18386 / 0.2e1 + 0.3e1 / 0.8e1 * t18389 + t3659 - t3660 - t3661 + t3662 + t3487 - t3466 + t3467 - t3483;
  t18803 = my_piecewise3(t2, 0, t18731 + t18776 + t18792 + t18800);
  tv4sigma2lapl20 = t3 * t18803;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t18806 = t815 * t712;
  t18818 = t519 * t2937 * t8980;
  t18819 = 0.3e1 / 0.32e2 * t18818;
  t18821 = t534 * t2954 * t8980;
  t18822 = 0.3e1 / 0.16e2 * t18821;
  t18824 = t2371 * t6247 * t815;
  t18827 = t6218 * t712;
  t18834 = t6209 * t712;
  t18838 = t2937 * t8990;
  t18841 = t6203 * t712;
  t18842 = t2941 * t18841;
  t18845 = t2937 * t18144;
  t18846 = t519 * t18845;
  t18847 = 0.3e1 / 0.32e2 * t18846;
  t18848 = -t721 + 0.5e1 / 0.32e2 * t3515 * t3726 - t534 * t18806 * t5233 / 0.16e2 + 0.3e1 / 0.8e1 * t534 * t18806 * t5324 - 0.5e1 / 0.32e2 * t3515 * t3692 + 0.5e1 / 0.32e2 * t3515 * t3699 + t18819 + t18822 + 0.9e1 / 0.16e2 * t519 * t18824 + 0.15e2 / 0.16e2 * t534 * t11224 * t18827 + 0.11e2 / 0.16e2 * t534 * t18806 * t5238 - 0.25e2 / 0.16e2 * t534 * t2941 * t18834 - 0.3e1 / 0.2e1 * t534 * t18838 + 0.9e1 / 0.8e1 * t534 * t18842 - t18847;
  t18850 = t519 * t2941 * t8840;
  t18851 = 0.3e1 / 0.32e2 * t18850;
  t18852 = t6288 * t712;
  t18862 = t534 * t2937 * t8840;
  t18863 = t18862 / 0.4e1;
  t18866 = t1639 * t717;
  t18868 = t534 * t2941 * t18866;
  t18869 = 0.3e1 / 0.16e2 * t18868;
  t18870 = t6209 * t815;
  t18876 = t534 * t815 * t717 * t1361;
  t18877 = t18876 / 0.16e2;
  t18880 = t534 * t18845;
  t18881 = 0.3e1 / 0.16e2 * t18880;
  t18886 = t534 * t2954 * t18158;
  t18887 = t18886 / 0.8e1;
  t18892 = t18133 / 0.16e2;
  t18893 = t18851 + 0.3e1 / 0.8e1 * t534 * t2954 * t18852 - 0.11e2 / 0.16e2 * t534 * t2954 * t8964 + 0.11e2 / 0.16e2 * t534 * t18824 + t18863 + 0.11e2 / 0.16e2 * t519 * t18842 - t18869 - 0.15e2 / 0.32e2 * t519 * t8894 * t18870 - t18877 - 0.7e1 / 0.32e2 * t519 * t18838 - t18881 - 0.9e1 / 0.16e2 * t519 * t2376 * t11255 - t18887 - 0.11e2 / 0.32e2 * t519 * t2371 * t11272 - t18455 / 0.8e1 - t18892;
  t18895 = 0.3e1 / 0.32e2 * t18136;
  t18896 = t18139 / 0.4e1;
  t18897 = 0.3e1 / 0.16e2 * t18142;
  t18898 = 0.3e1 / 0.32e2 * t18146;
  t18899 = 0.3e1 / 0.16e2 * t18149;
  t18900 = 0.3e1 / 0.32e2 * t18152;
  t18901 = t18154 / 0.32e2;
  t18902 = 0.3e1 / 0.16e2 * t18156;
  t18903 = t18160 / 0.8e1;
  t18909 = t18895 + t18896 - t18897 - t18898 + t18899 + t18900 - t18901 - t18902 - t18903 - t156 * t18220 * t815 * t424 / 0.32e2 + t18166 - t18169 - t18173 + t18176 - t18471 / 0.4e1;
  t18917 = t18474 - 0.3e1 / 0.4e1 * t18478 + 0.3e1 / 0.4e1 * t18482 - 0.3e1 / 0.8e1 * t18485 - 0.3e1 / 0.4e1 * t18487 + 0.3e1 / 0.8e1 * t18490 - t18493 / 0.2e1 + 0.3e1 / 0.8e1 * t18496 + t3703 + t3704 - t3705 - t3702 - t3521 + t3522 - t3538 + t3542;
  t18920 = my_piecewise3(t51, 0, t18848 + t18893 + t18909 + t18917);
  tv4sigma2lapl217 = t3 * t18920;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  t18926 = -t699 - t18344 * t832 / 0.32e2 - t18558 - t18348 + t18775 - t18778 - t18779 + t18780 - t18781 + t18782 + t18783 - t18784 - t18785 - t18786 - t18023 + t18117 - t18120 + t18123 - 0.11e2 / 0.16e2 * t484 * t3012 * t8409;
  t18927 = t2655 * t13572;
  t18933 = t835 * t690;
  t18945 = t2241 * t935 * t11512;
  t18949 = t484 * t2659 * t13550;
  t18955 = t469 * t3021 * t14110;
  t18958 = t484 * t3012 * t8394;
  t18962 = t2655 * t13550;
  t18963 = t484 * t18962;
  t18973 = t2475 * t14142;
  t18982 = 0.11e2 / 0.16e2 * t484 * t18927 + 0.3e1 / 0.8e1 * t484 * t2659 * t13572 + 0.3e1 / 0.8e1 * t484 * t18933 * t4378 - t484 * t18933 * t4311 / 0.16e2 - 0.5e1 / 0.32e2 * t3463 * t3739 + 0.5e1 / 0.32e2 * t3463 * t3753 - 0.7e1 / 0.32e2 * t469 * t18945 - t18949 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t14149 * t11512 + 0.3e1 / 0.32e2 * t18955 + 0.3e1 / 0.16e2 * t18958 + 0.9e1 / 0.16e2 * t469 * t18927 - 0.3e1 / 0.16e2 * t18963 - 0.9e1 / 0.16e2 * t469 * t14204 * t11512 + 0.5e1 / 0.32e2 * t3463 * t3746 + 0.11e2 / 0.16e2 * t484 * t18933 * t4343 + 0.11e2 / 0.16e2 * t469 * t18973 - 0.15e2 / 0.32e2 * t469 * t11410 * t14142 - 0.25e2 / 0.16e2 * t484 * t11396 * t18741;
  t18991 = t469 * t18962;
  t18994 = t469 * t2994 * t14110;
  t18997 = t484 * t2998 * t8282;
  t19000 = t484 * t2668 * t13550;
  t19004 = t484 * t835 * t695 * t1031;
  t19006 = 0.3e1 / 0.8e1 * t18564;
  t19007 = t18568 / 0.8e1;
  t19008 = t18571 / 0.2e1;
  t19009 = 0.3e1 / 0.8e1 * t18575;
  t19010 = 0.3e1 / 0.16e2 * t18578;
  t19011 = 0.3e1 / 0.8e1 * t18580;
  t19012 = 0.3e1 / 0.16e2 * t18583;
  t19013 = t18586 / 0.4e1;
  t19014 = 0.3e1 / 0.16e2 * t18589;
  t19015 = 0.3e1 / 0.16e2 * t18363;
  t19016 = 0.3e1 / 0.16e2 * t18366;
  t19017 = 0.15e2 / 0.16e2 * t484 * t9925 * t13572 - 0.3e1 / 0.2e1 * t484 * t18945 + 0.9e1 / 0.8e1 * t484 * t18973 - 0.3e1 / 0.32e2 * t18991 + 0.3e1 / 0.32e2 * t18994 + t18997 / 0.4e1 - 0.3e1 / 0.16e2 * t19000 - t19004 / 0.16e2 + t19006 - t19007 + t19008 - t19009 - t19010 - t19011 + t19012 - t19013 + t19014 - t19015 + t19016;
  t19018 = t18369 / 0.2e1;
  t19019 = 0.3e1 / 0.8e1 * t18374;
  t19020 = 0.3e1 / 0.8e1 * t18376;
  t19021 = 0.3e1 / 0.8e1 * t18379;
  t19022 = t18383 / 0.8e1;
  t19023 = t18386 / 0.4e1;
  t19024 = 0.3e1 / 0.16e2 * t18389;
  t19025 = t19018 - t19019 - t19020 + t19021 - t19022 - t19023 + t19024 + t3559 + t3562 - t3567 - t3571 + t3450 - t3453 - t3457 + t3461 + t3487 - t3466 + t3467 - t3483;
  t19028 = my_piecewise3(t2, 0, t18926 + t18982 + t19017 + t19025);
  tv4sigma2lapltau0 = t3 * t19028;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  t19033 = -t721 - t18452 * t849 / 0.32e2 - t18608 - t18456 - t18892 + t18895 + t18896 - t18897 - t18898 + t18899 + t18900 - t18901 - t18902 - t18903 + t18166 - t18169 - t18173 + t18176 - 0.5e1 / 0.32e2 * t3515 * t3782;
  t19036 = t9668 * t712;
  t19040 = t10482 * t712;
  t19041 = t3108 * t19040;
  t19047 = t3116 * t8990;
  t19051 = t534 * t2779 * t13939;
  t19053 = t3108 * t14544;
  t19054 = t519 * t19053;
  t19057 = t519 * t3112 * t14544;
  t19060 = t534 * t3116 * t8840;
  t19064 = t534 * t852 * t717 * t1361;
  t19069 = t534 * t3123 * t8980;
  t19071 = t534 * t19053;
  t19074 = t534 * t2789 * t13939;
  t19080 = t519 * t3132 * t14544;
  t19087 = t852 * t712;
  t19091 = 0.5e1 / 0.32e2 * t3515 * t3791 + 0.3e1 / 0.8e1 * t534 * t2789 * t19036 + 0.9e1 / 0.16e2 * t519 * t19041 - 0.9e1 / 0.16e2 * t519 * t3112 * t19040 - 0.3e1 / 0.2e1 * t534 * t19047 - 0.3e1 / 0.16e2 * t19051 - 0.3e1 / 0.32e2 * t19054 + 0.3e1 / 0.32e2 * t19057 + t19060 / 0.4e1 - t19064 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t19047 + 0.3e1 / 0.16e2 * t19069 - 0.3e1 / 0.16e2 * t19071 - t19074 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t13929 * t12043 + 0.3e1 / 0.32e2 * t19080 + 0.5e1 / 0.32e2 * t3515 * t3775 - 0.11e2 / 0.16e2 * t534 * t14537 * t7236 + 0.3e1 / 0.8e1 * t534 * t19087 * t5324;
  t19096 = t2779 * t19036;
  t19115 = 0.3e1 / 0.16e2 * t18657;
  t19116 = 0.3e1 / 0.16e2 * t18660;
  t19117 = t18663 / 0.2e1;
  t19118 = 0.3e1 / 0.8e1 * t18667;
  t19119 = 0.3e1 / 0.8e1 * t18670;
  t19120 = t18674 / 0.8e1;
  t19121 = t18677 / 0.4e1;
  t19122 = 0.3e1 / 0.16e2 * t18680;
  t19123 = 0.3e1 / 0.8e1 * t18682;
  t19124 = t18471 / 0.8e1;
  t19125 = t18474 / 0.2e1;
  t19126 = -t534 * t19087 * t5233 / 0.16e2 + 0.9e1 / 0.8e1 * t534 * t19096 + 0.11e2 / 0.16e2 * t534 * t19087 * t5238 + 0.11e2 / 0.16e2 * t519 * t19096 - 0.15e2 / 0.32e2 * t519 * t12007 * t19040 - 0.25e2 / 0.16e2 * t534 * t11994 * t18834 + 0.15e2 / 0.16e2 * t534 * t10491 * t19036 + 0.11e2 / 0.16e2 * t534 * t19041 - t19115 + t19116 + t19117 - t19118 + t19119 - t19120 - t19121 + t19122 - t19123 - t19124 + t19125;
  t19127 = 0.3e1 / 0.8e1 * t18478;
  t19128 = 0.3e1 / 0.8e1 * t18482;
  t19129 = 0.3e1 / 0.16e2 * t18485;
  t19130 = 0.3e1 / 0.8e1 * t18487;
  t19131 = 0.3e1 / 0.16e2 * t18490;
  t19132 = t18493 / 0.4e1;
  t19133 = 0.3e1 / 0.16e2 * t18496;
  t19134 = -t19127 + t19128 - t19129 - t19130 + t19131 - t19132 + t19133 + t3603 - t3608 - t3612 + t3615 + t3509 + t3513 - t3520 - t3505 - t3521 + t3522 - t3538 + t3542;
  t19137 = my_piecewise3(t51, 0, t19033 + t19091 + t19126 + t19134);
  tv4sigma2lapltau23 = t3 * t19137;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t19138 = t866 * t690;
  t19147 = t3181 * t8346;
  t19150 = t3185 * t18737;
  t19159 = t469 * t3185 * t8282;
  t19160 = 0.3e1 / 0.32e2 * t19159;
  t19162 = t484 * t3181 * t8282;
  t19163 = t19162 / 0.4e1;
  t19165 = t484 * t3185 * t18768;
  t19166 = 0.3e1 / 0.16e2 * t19165;
  t19169 = t484 * t866 * t695 * t1031;
  t19170 = t19169 / 0.16e2;
  t19173 = t3181 * t17989;
  t19174 = t469 * t19173;
  t19175 = 0.3e1 / 0.32e2 * t19174;
  t19177 = t484 * t3199 * t8394;
  t19178 = 0.3e1 / 0.16e2 * t19177;
  t19179 = -t699 - 0.11e2 / 0.16e2 * t484 * t19138 * t4316 + 0.3e1 / 0.8e1 * t484 * t19138 * t4378 - 0.5e1 / 0.32e2 * t3463 * t3809 - 0.3e1 / 0.2e1 * t484 * t19147 + 0.9e1 / 0.8e1 * t484 * t19150 + 0.5e1 / 0.32e2 * t3463 * t3829 - t484 * t19138 * t4311 / 0.16e2 + t19160 + t19163 - t19166 - t19170 - 0.7e1 / 0.32e2 * t469 * t19147 - t19175 + t19178;
  t19180 = t5535 * t866;
  t19181 = t2241 * t19180;
  t19184 = t484 * t19173;
  t19185 = 0.3e1 / 0.16e2 * t19184;
  t19186 = t5550 * t866;
  t19193 = t469 * t3181 * t8394;
  t19194 = 0.3e1 / 0.32e2 * t19193;
  t19196 = t484 * t3199 * t18001;
  t19197 = t19196 / 0.8e1;
  t19221 = 0.9e1 / 0.16e2 * t469 * t19181 - t19185 - 0.9e1 / 0.16e2 * t469 * t2246 * t19186 + 0.5e1 / 0.32e2 * t3463 * t3812 + t19194 - t19197 - 0.11e2 / 0.32e2 * t469 * t2241 * t12289 - 0.25e2 / 0.16e2 * t484 * t3185 * t18741 + 0.15e2 / 0.16e2 * t484 * t12252 * t18748 + 0.11e2 / 0.16e2 * t484 * t19138 * t4343 + 0.11e2 / 0.16e2 * t469 * t19150 - 0.15e2 / 0.32e2 * t469 * t12252 * t18741 + 0.11e2 / 0.16e2 * t484 * t19181 + 0.3e1 / 0.8e1 * t484 * t3199 * t18759 - t18557 / 0.8e1 + t18775;
  t19228 = -t18778 - t18779 + t18780 - t18781 + t18782 + t18783 - t18784 - t18785 - t18786 - t99 * t18069 * t866 * t269 / 0.32e2 - t18023 + t18117 - t18120 + t18123 + 0.3e1 / 0.4e1 * t18564;
  t19236 = -t18568 / 0.4e1 + t18571 - 0.3e1 / 0.4e1 * t18575 - 0.3e1 / 0.8e1 * t18578 - 0.3e1 / 0.4e1 * t18580 + 0.3e1 / 0.8e1 * t18583 - t18586 / 0.2e1 + 0.3e1 / 0.8e1 * t18589 + t3815 + t3816 - t3817 - t3818 + t3487 - t3466 + t3467 - t3483;
  t19239 = my_piecewise3(t2, 0, t19179 + t19221 + t19228 + t19236);
  tv4sigma2tau20 = t3 * t19239;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t19243 = t519 * t3284 * t8980;
  t19244 = 0.3e1 / 0.32e2 * t19243;
  t19246 = t534 * t3292 * t8980;
  t19247 = 0.3e1 / 0.16e2 * t19246;
  t19248 = t2371 * t12727;
  t19251 = t3284 * t18144;
  t19252 = t534 * t19251;
  t19253 = 0.3e1 / 0.16e2 * t19252;
  t19257 = t883 * t712;
  t19261 = t3276 * t18841;
  t19273 = t3284 * t8990;
  t19281 = -t721 + 0.5e1 / 0.32e2 * t3515 * t3849 + t19244 + t19247 + 0.9e1 / 0.16e2 * t519 * t19248 - t19253 - 0.9e1 / 0.16e2 * t519 * t2376 * t12738 + 0.11e2 / 0.16e2 * t534 * t19257 * t5238 + 0.11e2 / 0.16e2 * t519 * t19261 - 0.15e2 / 0.32e2 * t519 * t12694 * t18834 - 0.25e2 / 0.16e2 * t534 * t3276 * t18834 + 0.15e2 / 0.16e2 * t534 * t12694 * t18827 - 0.3e1 / 0.2e1 * t534 * t19273 + 0.9e1 / 0.8e1 * t534 * t19261 - t534 * t19257 * t5233 / 0.16e2;
  t19297 = t519 * t19251;
  t19298 = 0.3e1 / 0.32e2 * t19297;
  t19300 = t519 * t3276 * t8840;
  t19301 = 0.3e1 / 0.32e2 * t19300;
  t19303 = t534 * t3284 * t8840;
  t19304 = t19303 / 0.4e1;
  t19306 = t534 * t3276 * t18866;
  t19307 = 0.3e1 / 0.16e2 * t19306;
  t19310 = t534 * t883 * t717 * t1361;
  t19311 = t19310 / 0.16e2;
  t19315 = t534 * t3292 * t18158;
  t19316 = t19315 / 0.8e1;
  t19321 = 0.3e1 / 0.8e1 * t534 * t19257 * t5324 - 0.5e1 / 0.32e2 * t3515 * t3843 + 0.5e1 / 0.32e2 * t3515 * t3866 + 0.11e2 / 0.16e2 * t534 * t19248 + 0.3e1 / 0.8e1 * t534 * t3292 * t18852 - 0.11e2 / 0.16e2 * t534 * t3292 * t8964 - t19298 + t19301 + t19304 - t19307 - t19311 - 0.7e1 / 0.32e2 * t519 * t19273 - t19316 - 0.11e2 / 0.32e2 * t519 * t2371 * t12788 - t18607 / 0.8e1 - t18892;
  t19328 = t18895 + t18896 - t18897 - t18898 + t18899 + t18900 - t18901 - t18902 - t18903 - t156 * t18220 * t883 * t424 / 0.32e2 + t18166 - t18169 - t18173 + t18176 - 0.3e1 / 0.8e1 * t18657;
  t19336 = 0.3e1 / 0.8e1 * t18660 + t18663 - 0.3e1 / 0.4e1 * t18667 + 0.3e1 / 0.4e1 * t18670 - t18674 / 0.4e1 - t18677 / 0.2e1 + 0.3e1 / 0.8e1 * t18680 - 0.3e1 / 0.4e1 * t18682 + t3852 - t3853 - t3854 + t3855 - t3521 + t3522 - t3538 + t3542;
  t19339 = my_piecewise3(t51, 0, t19281 + t19321 + t19328 + t19336);
  tv4sigma2tau217 = t3 * t19339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t19342 = t3887 * t183;
  t19352 = t5703 * t183;
  t19356 = t16210 * t19352;
  t19365 = t5739 * t183;
  t19369 = t16163 * t5551;
  t19374 = t16163 * t14670;
  t19379 = -t699 + t3970 * t3676 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t19342 * t4316 + 0.3e1 / 0.8e1 * t484 * t19342 * t4378 - t484 * t19342 * t4311 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t16163 * t19352 + 0.11e2 / 0.16e2 * t469 * t19356 - 0.15e2 / 0.32e2 * t469 * t16221 * t5731 - 0.25e2 / 0.16e2 * t484 * t16210 * t5731 + 0.15e2 / 0.16e2 * t484 * t16221 * t19365 - 0.3e1 / 0.2e1 * t484 * t19369 + 0.9e1 / 0.8e1 * t484 * t19356 + 0.9e1 / 0.16e2 * t469 * t19374 - t3970 * t3649 / 0.16e2;
  t19385 = t5483 * t183;
  t19392 = t3970 * t3451;
  t19398 = 0.9e1 / 0.32e2 * t18700;
  t19399 = 0.3e1 / 0.4e1 * t18703;
  t19400 = 0.3e1 / 0.16e2 * t18707;
  t19401 = 0.9e1 / 0.32e2 * t18713;
  t19402 = 0.9e1 / 0.16e2 * t18716;
  t19403 = 0.9e1 / 0.16e2 * t18723;
  t19404 = 0.3e1 / 0.8e1 * t18729;
  t19405 = -0.7e1 / 0.32e2 * t469 * t19369 - 0.9e1 / 0.16e2 * t469 * t1524 * t16167 + 0.3e1 / 0.8e1 * t484 * t16193 * t19385 - 0.11e2 / 0.32e2 * t469 * t489 * t16197 - t19392 / 0.16e2 + t3970 * t3656 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t19374 + t19398 + t19399 - t19400 + t19401 + t19402 - t19403 - t19404;
  t19407 = 0.9e1 / 0.16e2 * t18770;
  t19408 = 0.9e1 / 0.32e2 * t18772;
  t19410 = t3363 * t3887;
  t19421 = t260 * t183 * t263;
  t19433 = t4432 * t183;
  t19436 = t495 * t471;
  t19439 = t296 * t13052;
  t19442 = t114 * t13052;
  t19454 = t19421 * t558 / 0.4e1 + t18035 + t200 * t183 * t290 / 0.2e1 - t16295 * t741 / 0.2e1 - t16298 * t745 / 0.2e1 - t16301 * t13053 / 0.2e1 + t19433 * t16305 / 0.2e1 + t18047 + t3877 * t19436 / 0.2e1 - t3877 * t19439 / 0.2e1 - t3877 * t19442 / 0.2e1 - t18055 * t199 * t116 / 0.2e1 - t18061 - t3879 * t19436 / 0.2e1 + t3879 * t19439 / 0.2e1 + t3879 * t19442 / 0.2e1;
  t19459 = -t19407 - t19408 - 0.3e1 / 0.32e2 * t18347 - 0.3e1 / 0.32e2 * t99 * t19410 * t956 + 0.3e1 / 0.32e2 * t99 * t19410 * t1036 + 0.3e1 / 0.32e2 * t99 * t19410 * t964 - t99 * t19454 * t798 * t269 / 0.32e2 - t18023 + t18117 - t18120 + t18123 - t18364 + t18367 + t18370;
  t19460 = -t18375 - t18377 + t18380 - t18384 - t18387 + t18390 + t3902 - t3903 - t3904 + t3905 + t3686 - t3663 + t3664 - t3673;
  t19463 = my_piecewise3(t2, 0, t19379 + t19405 + t19459 + t19460);
  tv4sigmalapl30 = t3 * t19463;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t19464 = t3933 * t191;
  t19471 = t16514 * t6204;
  t19480 = t6218 * t191;
  t19484 = t16502 * t6303;
  t19489 = t16502 * t6248;
  t19500 = -t721 - t534 * t19464 * t5233 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t16502 * t6204 + 0.11e2 / 0.16e2 * t519 * t19471 - 0.15e2 / 0.32e2 * t519 * t16525 * t6210 - 0.25e2 / 0.16e2 * t534 * t16514 * t6210 + 0.15e2 / 0.16e2 * t534 * t16525 * t19480 - 0.3e1 / 0.2e1 * t534 * t19484 + 0.9e1 / 0.8e1 * t534 * t19471 + 0.9e1 / 0.16e2 * t519 * t19489 - t4006 * t3692 / 0.16e2 + t4006 * t3726 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t19484 + 0.11e2 / 0.16e2 * t534 * t19489;
  t19504 = t6288 * t191;
  t19511 = t4006 * t3518;
  t19521 = 0.9e1 / 0.32e2 * t18818;
  t19522 = 0.9e1 / 0.16e2 * t18821;
  t19523 = 0.9e1 / 0.32e2 * t18846;
  t19524 = 0.9e1 / 0.32e2 * t18850;
  t19525 = 0.3e1 / 0.4e1 * t18862;
  t19526 = 0.9e1 / 0.16e2 * t18868;
  t19527 = 0.3e1 / 0.16e2 * t18876;
  t19528 = -0.9e1 / 0.16e2 * t519 * t1638 * t16454 + 0.3e1 / 0.8e1 * t534 * t16462 * t19504 - 0.11e2 / 0.32e2 * t519 * t539 * t16466 - t19511 / 0.16e2 + t4006 * t3699 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t19464 * t5298 + 0.3e1 / 0.8e1 * t534 * t19464 * t5324 + t19521 + t19522 - t19523 + t19524 + t19525 - t19526 - t19527;
  t19530 = 0.9e1 / 0.16e2 * t18880;
  t19531 = 0.3e1 / 0.8e1 * t18886;
  t19533 = t3418 * t3933;
  t19544 = t415 * t191 * t418;
  t19556 = t5352 * t191;
  t19559 = t545 * t521;
  t19562 = t451 * t13413;
  t19565 = t171 * t13413;
  t19577 = t19544 * t597 / 0.4e1 + t18186 + t208 * t191 * t445 / 0.2e1 - t16572 * t758 / 0.2e1 - t16575 * t762 / 0.2e1 - t16578 * t13414 / 0.2e1 + t19556 * t16582 / 0.2e1 + t18198 + t3923 * t19559 / 0.2e1 - t3923 * t19562 / 0.2e1 - t3923 * t19565 / 0.2e1 - t18206 * t207 * t173 / 0.2e1 - t18212 - t3925 * t19559 / 0.2e1 + t3925 * t19562 / 0.2e1 + t3925 * t19565 / 0.2e1;
  t19582 = -t19530 - t19531 - 0.3e1 / 0.32e2 * t18455 - 0.3e1 / 0.32e2 * t156 * t19533 * t1366 + 0.3e1 / 0.32e2 * t156 * t19533 * t1374 + 0.3e1 / 0.32e2 * t156 * t19533 * t1405 - t156 * t19577 * t815 * t424 / 0.32e2 + t18166 - t18169 - t18173 + t18176 - t18472 + t18475 - t18479;
  t19583 = t18483 - t18486 - t18488 + t18491 - t18494 + t18497 + t3949 + t3950 - t3951 - t3948 - t3706 + t3707 - t3716 + t3729;
  t19586 = my_piecewise3(t51, 0, t19500 + t19528 + t19582 + t19583);
  tv4sigmalapl311 = t3 * t19586;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  t19597 = t3970 * t3565;
  t19599 = t19392 / 0.32e2;
  t19601 = t3973 * t183;
  t19607 = -t699 - 0.3e1 / 0.32e2 * t3463 * t3978 + 0.3e1 / 0.32e2 * t3463 * t3993 + 0.3e1 / 0.32e2 * t3463 * t3985 - t23 * t26 * t19454 * t832 / 0.32e2 - t19597 / 0.32e2 - t19599 + t18701 + t18704 - t18708 + t18714 + t18717 - t18724 - t18730 - t18771 - t18773 - t18557 / 0.32e2 - t18348 + 0.3e1 / 0.8e1 * t484 * t19601 * t4378 + t3970 * t3753 / 0.16e2;
  t19611 = t16745 * t5551;
  t19614 = t2668 * t14683;
  t19635 = t2655 * t14683;
  t19654 = -t484 * t19601 * t4311 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t19611 + 0.9e1 / 0.8e1 * t484 * t19614 - t3970 * t3739 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t16745 * t19352 + 0.11e2 / 0.16e2 * t469 * t19614 - 0.15e2 / 0.32e2 * t469 * t14651 * t10085 - 0.25e2 / 0.16e2 * t484 * t16737 * t5731 + 0.15e2 / 0.16e2 * t484 * t9925 * t14683 - 0.7e1 / 0.32e2 * t469 * t19611 + 0.11e2 / 0.16e2 * t484 * t19635 - 0.9e1 / 0.16e2 * t469 * t2481 * t16792 + 0.3e1 / 0.8e1 * t484 * t2659 * t14683 - 0.11e2 / 0.32e2 * t469 * t2465 * t16792 - 0.11e2 / 0.16e2 * t484 * t16811 * t5613 + 0.9e1 / 0.16e2 * t469 * t19635 + t3970 * t3746 / 0.16e2 - t18023 + t18117 - t18120;
  t19656 = t18949 / 0.4e1;
  t19657 = 0.3e1 / 0.16e2 * t18955;
  t19658 = 0.3e1 / 0.8e1 * t18958;
  t19659 = 0.3e1 / 0.8e1 * t18963;
  t19660 = 0.3e1 / 0.16e2 * t18991;
  t19661 = 0.3e1 / 0.16e2 * t18994;
  t19662 = t18997 / 0.2e1;
  t19663 = 0.3e1 / 0.8e1 * t19000;
  t19664 = t19004 / 0.8e1;
  t19674 = t18123 - t19656 + t19657 + t19658 - t19659 - t19660 + t19661 + t19662 - t19663 - t19664 + 0.3e1 / 0.16e2 * t18564 - t18568 / 0.16e2 + t18571 / 0.4e1 - 0.3e1 / 0.16e2 * t18575 - 0.3e1 / 0.32e2 * t18578 - 0.3e1 / 0.16e2 * t18580 + 0.3e1 / 0.32e2 * t18583 - t18586 / 0.8e1 + 0.3e1 / 0.32e2 * t18589 - t19015;
  t19675 = t19016 + t19018 - t19019 - t19020 + t19021 - t19022 - t19023 + t19024 + t3559 + t3562 - t3567 - t3571 + t3659 - t3660 - t3661 + t3662 + t3686 - t3663 + t3664 - t3673;
  t19678 = my_piecewise3(t2, 0, t19607 + t19654 + t19674 + t19675);
  tv4sigmalapl2tau0 = t3 * t19678;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  t19689 = t4006 * t3606;
  t19691 = t19511 / 0.32e2;
  t19693 = t4009 * t191;
  t19700 = -t721 - 0.3e1 / 0.32e2 * t3515 * t4014 + 0.3e1 / 0.32e2 * t3515 * t4029 + 0.3e1 / 0.32e2 * t3515 * t4021 - t60 * t26 * t19577 * t849 / 0.32e2 - t19689 / 0.32e2 - t19691 + t18819 + t18822 - t18847 + t18851 + t18863 - t18869 - t18877 - t18881 - t18887 - t18607 / 0.32e2 - t18456 + 0.3e1 / 0.8e1 * t534 * t19693 * t5324 - t534 * t19693 * t5233 / 0.16e2;
  t19701 = t16974 * t10529;
  t19714 = t16970 * t6303;
  t19728 = t2568 * t17036;
  t19746 = 0.11e2 / 0.16e2 * t519 * t19701 - 0.15e2 / 0.32e2 * t519 * t16978 * t10529 + t4006 * t3791 / 0.16e2 - t4006 * t3782 / 0.16e2 + 0.15e2 / 0.16e2 * t534 * t10491 * t14977 - 0.3e1 / 0.2e1 * t534 * t19714 + 0.9e1 / 0.8e1 * t534 * t19701 + 0.11e2 / 0.16e2 * t534 * t16970 * t6204 - 0.25e2 / 0.16e2 * t534 * t16982 * t6210 - 0.11e2 / 0.16e2 * t534 * t17031 * t6360 + 0.9e1 / 0.16e2 * t519 * t19728 + 0.11e2 / 0.16e2 * t534 * t19728 - 0.9e1 / 0.16e2 * t519 * t2574 * t17036 + 0.3e1 / 0.8e1 * t534 * t2789 * t14977 + t4006 * t3775 / 0.16e2 - 0.11e2 / 0.32e2 * t519 * t2598 * t17036 - 0.7e1 / 0.32e2 * t519 * t19714 + t18166 - t18169 - t18173;
  t19748 = 0.3e1 / 0.8e1 * t19051;
  t19749 = 0.3e1 / 0.16e2 * t19054;
  t19750 = 0.3e1 / 0.16e2 * t19057;
  t19751 = t19060 / 0.2e1;
  t19752 = t19064 / 0.8e1;
  t19753 = 0.3e1 / 0.8e1 * t19069;
  t19754 = 0.3e1 / 0.8e1 * t19071;
  t19755 = t19074 / 0.4e1;
  t19756 = 0.3e1 / 0.16e2 * t19080;
  t19766 = t18176 - t19748 - t19749 + t19750 + t19751 - t19752 + t19753 - t19754 - t19755 + t19756 - 0.3e1 / 0.32e2 * t18657 + 0.3e1 / 0.32e2 * t18660 + t18663 / 0.4e1 - 0.3e1 / 0.16e2 * t18667 + 0.3e1 / 0.16e2 * t18670 - t18674 / 0.16e2 - t18677 / 0.8e1 + 0.3e1 / 0.32e2 * t18680 - 0.3e1 / 0.16e2 * t18682 - t19124;
  t19767 = t19125 - t19127 + t19128 - t19129 - t19130 + t19131 - t19132 + t19133 + t3603 - t3608 - t3612 + t3615 + t3703 + t3704 - t3705 - t3702 - t3706 + t3707 - t3716 + t3729;
  t19770 = my_piecewise3(t51, 0, t19700 + t19746 + t19766 + t19767);
  tv4sigmalapl2tau17 = t3 * t19770;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  t19783 = t19597 / 0.16e2;
  t19785 = -t699 - t3970 * t3809 / 0.16e2 + t3970 * t3829 / 0.16e2 - 0.3e1 / 0.32e2 * t3463 * t4048 + 0.3e1 / 0.32e2 * t3463 * t4064 + 0.3e1 / 0.32e2 * t3463 * t4055 + t3970 * t3812 / 0.16e2 - t19783 + t19160 + t19163 - t19166 - t19170 - t19175 + t19178 - t19185 + t19194 - t19197 - t18558 - t18347 / 0.32e2;
  t19790 = t15676 * t9265;
  t19800 = t15672 * t9265;
  t19803 = t15668 * t9265;
  t19837 = -t484 * t4058 * t183 * t4311 / 0.16e2 + 0.9e1 / 0.8e1 * t484 * t19790 + 0.3e1 / 0.8e1 * t484 * t3823 * t43 * t17232 + 0.11e2 / 0.16e2 * t484 * t17165 * t19352 - 0.3e1 / 0.2e1 * t484 * t19800 + 0.11e2 / 0.16e2 * t484 * t19803 + 0.15e2 / 0.16e2 * t484 * t15695 * t9265 - 0.7e1 / 0.32e2 * t469 * t19800 - 0.9e1 / 0.16e2 * t469 * t2481 * t17187 + 0.3e1 / 0.8e1 * t484 * t15834 * t9265 - 0.11e2 / 0.32e2 * t469 * t2465 * t17187 - 0.11e2 / 0.16e2 * t484 * t17183 * t9265 + 0.9e1 / 0.16e2 * t469 * t19803 + 0.11e2 / 0.16e2 * t469 * t19790 - 0.15e2 / 0.32e2 * t469 * t15664 * t9265 - 0.25e2 / 0.16e2 * t484 * t15691 * t9265 - t99 * t19454 * t866 * t269 / 0.32e2 - t18023 + t18117 - t18120;
  t19840 = t18123 - t19656 + t19657 + t19658 - t19659 - t19660 + t19661 + t19662 - t19663 - t19664 + t19006 - t19007 + t19008 - t19009 - t19010 - t19011 + t19012 - t19013 + t19014 - 0.3e1 / 0.32e2 * t18363;
  t19849 = 0.3e1 / 0.32e2 * t18366 + t18369 / 0.4e1 - 0.3e1 / 0.16e2 * t18374 - 0.3e1 / 0.16e2 * t18376 + 0.3e1 / 0.16e2 * t18379 - t18383 / 0.16e2 - t18386 / 0.8e1 + 0.3e1 / 0.32e2 * t18389 + t3815 + t3816 - t3817 - t3818 + t3450 - t3453 - t3457 + t3461 + t3686 - t3663 + t3664 - t3673;
  t19852 = my_piecewise3(t2, 0, t19785 + t19837 + t19840 + t19849);
  tv4sigmalapltau20 = t3 * t19852;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  t19865 = t19689 / 0.16e2;
  t19867 = -t721 - t4006 * t3843 / 0.16e2 + t4006 * t3866 / 0.16e2 - 0.3e1 / 0.32e2 * t3515 * t4088 + 0.3e1 / 0.32e2 * t3515 * t4100 + 0.3e1 / 0.32e2 * t3515 * t4091 + t4006 * t3849 / 0.16e2 - t19865 + t19244 + t19247 - t19253 - t19298 + t19301 + t19304 - t19307 - t19311 - t19316 - t18608 - t18455 / 0.32e2;
  t19872 = t3860 * t75;
  t19888 = t16060 * t9749;
  t19891 = t16052 * t9749;
  t19894 = t17403 * t9749;
  t19919 = -t534 * t4094 * t191 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t19872 * t7236 + 0.3e1 / 0.8e1 * t534 * t19872 * t7128 - 0.15e2 / 0.32e2 * t519 * t16056 * t9749 - 0.25e2 / 0.16e2 * t534 * t16040 * t9749 + 0.15e2 / 0.16e2 * t534 * t16044 * t9749 - 0.3e1 / 0.2e1 * t534 * t19888 + 0.9e1 / 0.8e1 * t534 * t19891 + 0.11e2 / 0.16e2 * t534 * t19894 - 0.9e1 / 0.16e2 * t519 * t2574 * t17424 + 0.3e1 / 0.8e1 * t534 * t16099 * t9749 - 0.11e2 / 0.32e2 * t519 * t2598 * t17424 + 0.9e1 / 0.16e2 * t519 * t19894 - 0.7e1 / 0.32e2 * t519 * t19888 + 0.11e2 / 0.16e2 * t534 * t17390 * t6204 + 0.11e2 / 0.16e2 * t519 * t19891 - t156 * t19577 * t883 * t424 / 0.32e2 + t18166 - t18169 - t18173;
  t19922 = t18176 - t19748 - t19749 + t19750 + t19751 - t19752 + t19753 - t19754 - t19755 + t19756 - t19115 + t19116 + t19117 - t19118 + t19119 - t19120 - t19121 + t19122 - t19123 - t18471 / 0.16e2;
  t19931 = t18474 / 0.4e1 - 0.3e1 / 0.16e2 * t18478 + 0.3e1 / 0.16e2 * t18482 - 0.3e1 / 0.32e2 * t18485 - 0.3e1 / 0.16e2 * t18487 + 0.3e1 / 0.32e2 * t18490 - t18493 / 0.8e1 + 0.3e1 / 0.32e2 * t18496 + t3852 - t3853 - t3854 + t3855 + t3509 + t3513 - t3520 - t3505 - t3706 + t3707 - t3716 + t3729;
  t19934 = my_piecewise3(t51, 0, t19867 + t19919 + t19922 + t19931);
  tv4sigmalapltau217 = t3 * t19934;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t19938 = t17537 * t19352;
  t19954 = t17554 * t5551;
  t19970 = -t699 + 0.11e2 / 0.16e2 * t484 * t17554 * t19352 + 0.11e2 / 0.16e2 * t469 * t19938 - 0.15e2 / 0.32e2 * t469 * t17541 * t5731 - 0.25e2 / 0.16e2 * t484 * t17537 * t5731 + 0.15e2 / 0.16e2 * t484 * t17541 * t19365 - t17477 * t3809 / 0.16e2 + t17477 * t3829 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t19954 + 0.9e1 / 0.8e1 * t484 * t19938 - 0.7e1 / 0.32e2 * t469 * t19954 - 0.9e1 / 0.16e2 * t469 * t1524 * t17499 + 0.3e1 / 0.8e1 * t484 * t17485 * t19385 - 0.11e2 / 0.32e2 * t469 * t489 * t17528;
  t19971 = t17477 * t3565;
  t19972 = t19971 / 0.16e2;
  t19978 = t489 * t17489;
  t19983 = t4122 * t183;
  t19990 = 0.9e1 / 0.32e2 * t19159;
  t19991 = 0.3e1 / 0.4e1 * t19162;
  t19992 = 0.9e1 / 0.16e2 * t19165;
  t19993 = 0.3e1 / 0.16e2 * t19169;
  t19994 = 0.9e1 / 0.32e2 * t19174;
  t19995 = 0.9e1 / 0.16e2 * t19177;
  t19996 = 0.9e1 / 0.16e2 * t19184;
  t19997 = -t19972 + t17477 * t3812 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t17485 * t5613 + 0.9e1 / 0.16e2 * t469 * t19978 + 0.11e2 / 0.16e2 * t484 * t19978 + 0.3e1 / 0.8e1 * t484 * t19983 * t4378 - t484 * t19983 * t4311 / 0.16e2 + t19990 + t19991 - t19992 - t19993 - t19994 + t19995 - t19996;
  t19999 = 0.9e1 / 0.32e2 * t19193;
  t20000 = 0.3e1 / 0.8e1 * t19196;
  t20002 = t3363 * t4122;
  t20040 = t19421 * t626 / 0.4e1 + t18035 + t214 * t183 * t290 / 0.2e1 - t17626 * t741 / 0.2e1 - t17629 * t745 / 0.2e1 - t17632 * t13053 / 0.2e1 + t19433 * t17636 / 0.2e1 + t18047 + t4112 * t19436 / 0.2e1 - t4112 * t19439 / 0.2e1 - t4112 * t19442 / 0.2e1 - t18055 * t213 * t116 / 0.2e1 - t18061 - t4114 * t19436 / 0.2e1 + t4114 * t19439 / 0.2e1 + t4114 * t19442 / 0.2e1;
  t20045 = t19999 - t20000 - 0.3e1 / 0.32e2 * t18557 + 0.3e1 / 0.32e2 * t99 * t20002 * t964 - 0.3e1 / 0.32e2 * t99 * t20002 * t956 + 0.3e1 / 0.32e2 * t99 * t20002 * t1036 - t99 * t20040 * t866 * t269 / 0.32e2 - t18023 + t18117 - t18120 + t18123 + t18565 - t18569 + t18572;
  t20046 = -t18576 - t18579 - t18581 + t18584 - t18587 + t18590 + t4137 + t4138 - t4139 - t4140 + t3686 - t3663 + t3664 - t3673;
  t20049 = my_piecewise3(t2, 0, t19970 + t19997 + t20045 + t20046);
  tv4sigmatau30 = t3 * t20049;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t20050 = t17789 * t6248;
  t20060 = t17789 * t6303;
  t20063 = t4168 * t191;
  t20075 = t17817 * t3606;
  t20076 = t20075 / 0.16e2;
  t20084 = -t721 + 0.9e1 / 0.16e2 * t519 * t20050 + 0.11e2 / 0.16e2 * t534 * t17789 * t6204 - t17817 * t3843 / 0.16e2 + t17817 * t3866 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t20060 - t534 * t20063 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t20063 * t5298 + 0.3e1 / 0.8e1 * t534 * t20063 * t5324 - 0.7e1 / 0.32e2 * t519 * t20060 - t20076 + t17817 * t3849 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t20050 - 0.9e1 / 0.16e2 * t519 * t1638 * t17793;
  t20091 = t17824 * t6204;
  t20105 = 0.9e1 / 0.32e2 * t19243;
  t20106 = 0.9e1 / 0.16e2 * t19246;
  t20107 = 0.9e1 / 0.16e2 * t19252;
  t20108 = 0.9e1 / 0.32e2 * t19297;
  t20109 = 0.9e1 / 0.32e2 * t19300;
  t20110 = 0.3e1 / 0.4e1 * t19303;
  t20111 = 0.9e1 / 0.16e2 * t19306;
  t20112 = 0.3e1 / 0.8e1 * t534 * t17801 * t19504 - 0.11e2 / 0.32e2 * t519 * t539 * t17805 + 0.11e2 / 0.16e2 * t519 * t20091 - 0.15e2 / 0.32e2 * t519 * t17828 * t6210 - 0.25e2 / 0.16e2 * t534 * t17824 * t6210 + 0.15e2 / 0.16e2 * t534 * t17828 * t19480 + 0.9e1 / 0.8e1 * t534 * t20091 + t20105 + t20106 - t20107 - t20108 + t20109 + t20110 - t20111;
  t20114 = 0.3e1 / 0.16e2 * t19310;
  t20115 = 0.3e1 / 0.8e1 * t19315;
  t20117 = t3418 * t4168;
  t20152 = t19544 * t665 / 0.4e1 + t18186 + t220 * t191 * t445 / 0.2e1 - t17930 * t758 / 0.2e1 - t17933 * t762 / 0.2e1 - t17936 * t13414 / 0.2e1 + t19556 * t17940 / 0.2e1 + t18198 + t4158 * t19559 / 0.2e1 - t4158 * t19562 / 0.2e1 - t4158 * t19565 / 0.2e1 - t18206 * t219 * t173 / 0.2e1 - t18212 - t4160 * t19559 / 0.2e1 + t4160 * t19562 / 0.2e1 + t4160 * t19565 / 0.2e1;
  t20160 = -t20114 - t20115 - 0.3e1 / 0.32e2 * t18607 - 0.3e1 / 0.32e2 * t156 * t20117 * t1366 + 0.3e1 / 0.32e2 * t156 * t20117 * t1374 - t156 * t20152 * t883 * t424 / 0.32e2 + 0.3e1 / 0.32e2 * t156 * t20117 * t1405 + t18166 - t18169 - t18173 + t18176 - t18658 + t18661 + t18664;
  t20161 = -t18668 + t18671 - t18675 - t18678 + t18681 - t18683 + t4183 - t4184 - t4185 + t4186 - t3706 + t3707 - t3716 + t3729;
  t20164 = my_piecewise3(t51, 0, t20084 + t20112 + t20160 + t20161);
  tv4sigmatau311 = t3 * t20164;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t20175 = t798 * t798;
  t20176 = t260 * t20175;
  t20190 = t993 * t798;
  t20197 = t258 * t3882;
  t20201 = t996 * t798;
  t20208 = t800 / 0.4e1 + t18035 + t804 / 0.2e1 - t807 / 0.2e1 - t810 / 0.2e1 - t4428 * t798 * t269 / 0.2e1 + t4432 * t798 * t269 / 0.2e1 + t18047 + t20190 * t290 / 0.2e1 - t20190 * t297 / 0.2e1 - t20190 * t301 / 0.2e1 - t20197 * t199 * t116 / 0.2e1 - t18061 - t20201 * t290 / 0.2e1 + t20201 * t297 / 0.2e1 + t20201 * t301 / 0.2e1;
  t20213 = t100 * t20175;
  t20220 = t3882 * t3887;
  t20233 = -t699 - 0.5e1 / 0.32e2 * t19392 + 0.9e1 / 0.16e2 * t18700 + 0.3e1 / 0.2e1 * t18703 - 0.3e1 / 0.8e1 * t18707 + 0.9e1 / 0.16e2 * t18713 + 0.9e1 / 0.8e1 * t18716 - 0.9e1 / 0.8e1 * t18723 - 0.3e1 / 0.4e1 * t18729 - 0.9e1 / 0.8e1 * t18770 - 0.9e1 / 0.16e2 * t18772 - 0.7e1 / 0.32e2 * t99 * t20176 * t4277 - t99 * t20208 * t798 * t269 / 0.32e2 + 0.11e2 / 0.16e2 * t99 * t20213 * t4335 + 0.3e1 / 0.8e1 * t99 * t20213 * t4499 + 0.5e1 / 0.32e2 * t99 * t20220 * t964 + 0.11e2 / 0.16e2 * t99 * t20176 * t4347 - 0.15e2 / 0.32e2 * t99 * t20176 * t4352 - 0.25e2 / 0.16e2 * t99 * t20213 * t4323;
  t20274 = 0.15e2 / 0.16e2 * t99 * t20213 * t4331 - 0.5e1 / 0.32e2 * t99 * t20220 * t956 + 0.5e1 / 0.32e2 * t99 * t20220 * t1036 - 0.3e1 / 0.2e1 * t99 * t20213 * t4277 + 0.9e1 / 0.8e1 * t99 * t20213 * t4347 + 0.9e1 / 0.16e2 * t99 * t20176 * t4335 + 0.11e2 / 0.16e2 * t99 * t20213 * t4343 - 0.11e2 / 0.16e2 * t99 * t20213 * t4316 + 0.3e1 / 0.8e1 * t99 * t20213 * t4378 - t99 * t20213 * t4311 / 0.16e2 - 0.9e1 / 0.16e2 * t99 * t20176 * t4524 - 0.11e2 / 0.32e2 * t99 * t20176 * t4415 - t18023 + t18117 - t18120 + t18123 + t3449 / 0.4e1 - t3452 / 0.8e1 - t3456 / 0.4e1 + t3460 / 0.4e1;
  t20276 = my_piecewise3(t2, 0, t20233 + t20274);
  tv4lapl40 = t3 * t20276;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t20287 = t815 * t815;
  t20288 = t415 * t20287;
  t20292 = t157 * t20287;
  t20305 = t3928 * t3933;
  t20315 = -t721 - 0.5e1 / 0.32e2 * t19511 + 0.9e1 / 0.16e2 * t18818 + 0.9e1 / 0.8e1 * t18821 - 0.9e1 / 0.16e2 * t18846 + 0.9e1 / 0.16e2 * t18850 + 0.3e1 / 0.2e1 * t18862 - 0.9e1 / 0.8e1 * t18868 - 0.3e1 / 0.8e1 * t18876 - 0.9e1 / 0.8e1 * t18880 - 0.3e1 / 0.4e1 * t18886 + 0.9e1 / 0.16e2 * t156 * t20288 * t5302 + 0.11e2 / 0.16e2 * t156 * t20292 * t5238 + 0.11e2 / 0.16e2 * t156 * t20288 * t5243 - 0.15e2 / 0.32e2 * t156 * t20288 * t5251 - 0.25e2 / 0.16e2 * t156 * t20292 * t5256 - 0.5e1 / 0.32e2 * t156 * t20305 * t1366 + 0.5e1 / 0.32e2 * t156 * t20305 * t1374 - 0.11e2 / 0.16e2 * t156 * t20292 * t5298;
  t20332 = t1322 * t815;
  t20339 = t413 * t3928;
  t20343 = t1325 * t815;
  t20350 = t817 / 0.4e1 + t18186 + t821 / 0.2e1 - t824 / 0.2e1 - t827 / 0.2e1 - t5348 * t815 * t424 / 0.2e1 + t5352 * t815 * t424 / 0.2e1 + t18198 + t20332 * t445 / 0.2e1 - t20332 * t452 / 0.2e1 - t20332 * t456 / 0.2e1 - t20339 * t207 * t173 / 0.2e1 - t18212 - t20343 * t445 / 0.2e1 + t20343 * t452 / 0.2e1 + t20343 * t456 / 0.2e1;
  t20386 = 0.3e1 / 0.8e1 * t156 * t20292 * t5324 - t156 * t20292 * t5233 / 0.16e2 - t156 * t20350 * t815 * t424 / 0.32e2 - 0.9e1 / 0.16e2 * t156 * t20288 * t5306 + 0.5e1 / 0.32e2 * t156 * t20305 * t1405 + 0.11e2 / 0.16e2 * t156 * t20292 * t5302 + 0.3e1 / 0.8e1 * t156 * t20292 * t5426 - 0.11e2 / 0.32e2 * t156 * t20288 * t5410 - 0.7e1 / 0.32e2 * t156 * t20288 * t5270 + 0.15e2 / 0.16e2 * t156 * t20292 * t5263 - 0.3e1 / 0.2e1 * t156 * t20292 * t5270 + 0.9e1 / 0.8e1 * t156 * t20292 * t5243 + t18166 - t18169 - t18173 + t18176 + t3508 / 0.4e1 + t3512 / 0.4e1 - t3519 / 0.8e1 - t3504 / 0.4e1;
  t20388 = my_piecewise3(t51, 0, t20315 + t20386);
  tv4lapl44 = t3 * t20388;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  t20390 = t2005 * t5703 * t3887;
  t20397 = t213 * t3887;
  t20407 = t16163 * t7535;
  t20410 = t16163 * t18513;
  t20427 = -t699 + 0.9e1 / 0.8e1 * t484 * t20390 - 0.5e1 / 0.32e2 * t3970 * t3978 + 0.5e1 / 0.32e2 * t3970 * t3993 + 0.3e1 / 0.8e1 * t484 * t20397 * t4378 - t484 * t20397 * t4311 / 0.16e2 - 0.11e2 / 0.32e2 * t469 * t16163 * t7539 - 0.7e1 / 0.32e2 * t469 * t20407 + 0.9e1 / 0.16e2 * t469 * t20410 - 0.9e1 / 0.16e2 * t469 * t16210 * t7535 - t23 * t26 * t20208 * t832 / 0.32e2 + 0.3e1 / 0.8e1 * t484 * t644 * t5483 * t3887 - 0.11e2 / 0.16e2 * t484 * t20397 * t4316;
  t20450 = 0.11e2 / 0.16e2 * t484 * t20410 + 0.5e1 / 0.32e2 * t3970 * t3985 + 0.11e2 / 0.16e2 * t484 * t20397 * t4343 + 0.11e2 / 0.16e2 * t469 * t20390 - 0.15e2 / 0.32e2 * t469 * t16221 * t7392 - 0.25e2 / 0.16e2 * t484 * t20397 * t4323 + 0.15e2 / 0.16e2 * t484 * t7399 * t5739 * t3887 - 0.3e1 / 0.2e1 * t484 * t20407 - t19783 - 0.3e1 / 0.32e2 * t19392 + t19398 + t19399 - t19400;
  t20452 = 0.3e1 / 0.8e1 * t18949;
  t20453 = 0.9e1 / 0.32e2 * t18955;
  t20454 = 0.9e1 / 0.16e2 * t18958;
  t20455 = t19401 + t19402 - t19403 - t19404 - t19407 - t19408 - t18023 + t18117 - t18120 + t18123 - t20452 + t20453 + t20454;
  t20456 = 0.9e1 / 0.16e2 * t18963;
  t20457 = 0.9e1 / 0.32e2 * t18991;
  t20458 = 0.9e1 / 0.32e2 * t18994;
  t20459 = 0.3e1 / 0.4e1 * t18997;
  t20460 = 0.9e1 / 0.16e2 * t19000;
  t20461 = 0.3e1 / 0.16e2 * t19004;
  t20462 = -t20456 - t20457 + t20458 + t20459 - t20460 - t20461 + t3559 + t3562 - t3567 - t3571 + t3902 - t3903 - t3904 + t3905;
  t20465 = my_piecewise3(t2, 0, t20427 + t20450 + t20455 + t20462);
  tv4lapl3tau0 = t3 * t20465;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  t20471 = t679 * t6247 * t3933;
  t20478 = t219 * t3933;
  t20484 = t16514 * t18615;
  t20497 = t20478 * t5270;
  t20505 = -t721 - t60 * t26 * t20350 * t849 / 0.32e2 + 0.11e2 / 0.16e2 * t534 * t20471 + 0.3e1 / 0.8e1 * t534 * t683 * t6288 * t3933 - 0.11e2 / 0.16e2 * t534 * t20478 * t5298 + 0.5e1 / 0.32e2 * t4006 * t4021 + 0.11e2 / 0.16e2 * t519 * t20484 - 0.15e2 / 0.32e2 * t519 * t16525 * t8067 - 0.25e2 / 0.16e2 * t534 * t20478 * t5256 + 0.15e2 / 0.16e2 * t534 * t8075 * t6218 * t3933 - 0.3e1 / 0.2e1 * t534 * t20497 + 0.9e1 / 0.8e1 * t534 * t20484 + 0.11e2 / 0.16e2 * t534 * t20478 * t5238;
  t20527 = -0.5e1 / 0.32e2 * t4006 * t4014 + 0.5e1 / 0.32e2 * t4006 * t4029 + 0.3e1 / 0.8e1 * t534 * t20478 * t5324 - t534 * t20478 * t5233 / 0.16e2 - 0.11e2 / 0.32e2 * t519 * t16502 * t8113 - 0.7e1 / 0.32e2 * t519 * t20497 + 0.9e1 / 0.16e2 * t519 * t20471 - 0.9e1 / 0.16e2 * t519 * t16514 * t8109 - t19865 - 0.3e1 / 0.32e2 * t19511 + t19521 + t19522 - t19523;
  t20529 = 0.9e1 / 0.16e2 * t19051;
  t20530 = 0.9e1 / 0.32e2 * t19054;
  t20531 = 0.9e1 / 0.32e2 * t19057;
  t20532 = t19524 + t19525 - t19526 - t19527 - t19530 - t19531 + t18166 - t18169 - t18173 + t18176 - t20529 - t20530 + t20531;
  t20533 = 0.3e1 / 0.4e1 * t19060;
  t20534 = 0.3e1 / 0.16e2 * t19064;
  t20535 = 0.9e1 / 0.16e2 * t19069;
  t20536 = 0.9e1 / 0.16e2 * t19071;
  t20537 = 0.3e1 / 0.8e1 * t19074;
  t20538 = 0.9e1 / 0.32e2 * t19080;
  t20539 = t20533 - t20534 + t20535 - t20536 - t20537 + t20538 + t3603 - t3608 - t3612 + t3615 + t3949 + t3950 - t3951 - t3948;
  t20542 = my_piecewise3(t51, 0, t20505 + t20527 + t20532 + t20539);
  tv4lapl3tau7 = t3 * t20542;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  t20545 = t866 * t798;
  t20552 = t2845 * t19186;
  t20558 = t2845 * t19180;
  t20575 = t5730 * t798;
  t20586 = -t699 + 0.5e1 / 0.32e2 * t3970 * t4064 + 0.3e1 / 0.8e1 * t484 * t20545 * t4378 - t484 * t20545 * t4311 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t20552 - 0.11e2 / 0.32e2 * t469 * t2845 * t12289 + 0.9e1 / 0.16e2 * t469 * t20558 - 0.9e1 / 0.16e2 * t469 * t2849 * t19186 + 0.5e1 / 0.32e2 * t3970 * t4055 - 0.11e2 / 0.16e2 * t484 * t3199 * t10866 + 0.11e2 / 0.16e2 * t484 * t20558 + 0.3e1 / 0.8e1 * t484 * t3199 * t5483 * t798 - 0.25e2 / 0.16e2 * t484 * t3185 * t20575 + 0.15e2 / 0.16e2 * t484 * t12252 * t5739 * t798 + 0.11e2 / 0.16e2 * t484 * t20545 * t4343;
  t20588 = t3185 * t5703 * t798;
  t20601 = 0.11e2 / 0.16e2 * t469 * t20588 - 0.15e2 / 0.32e2 * t469 * t12252 * t20575 - 0.3e1 / 0.2e1 * t484 * t20552 + 0.9e1 / 0.8e1 * t484 * t20588 - 0.5e1 / 0.32e2 * t3970 * t4048 - t19597 / 0.8e1 - t19599 + t19160 + t19163 - t19166 - t19170 - t19175 + t19178 - t19185 + t19194 - t19197;
  t20608 = t18701 + t18704 - t18708 + t18714 + t18717 - t18724 - t18730 - t18771 - t18773 - t99 * t20208 * t866 * t269 / 0.32e2 - t18023 + t18117 - t18120 + t18123 - t18949 / 0.2e1;
  t20616 = 0.3e1 / 0.8e1 * t18955 + 0.3e1 / 0.4e1 * t18958 - 0.3e1 / 0.4e1 * t18963 - 0.3e1 / 0.8e1 * t18991 + 0.3e1 / 0.8e1 * t18994 + t18997 - 0.3e1 / 0.4e1 * t19000 - t19004 / 0.4e1 + t3815 + t3816 - t3817 - t3818 + t3659 - t3660 - t3661 + t3662;
  t20619 = my_piecewise3(t2, 0, t20586 + t20601 + t20608 + t20616);
  tv4lapl2tau20 = t3 * t20619;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  t20620 = t2937 * t12727;
  t20627 = t883 * t815;
  t20632 = t3276 * t6203 * t815;
  t20637 = t3284 * t11255;
  t20661 = -t721 + 0.9e1 / 0.16e2 * t519 * t20620 + 0.3e1 / 0.8e1 * t534 * t3292 * t6288 * t815 + 0.11e2 / 0.16e2 * t534 * t20627 * t5238 + 0.11e2 / 0.16e2 * t519 * t20632 + 0.11e2 / 0.16e2 * t534 * t20620 - 0.3e1 / 0.2e1 * t534 * t20637 + 0.9e1 / 0.8e1 * t534 * t20632 - 0.5e1 / 0.32e2 * t4006 * t4088 + 0.5e1 / 0.32e2 * t4006 * t4100 - 0.11e2 / 0.16e2 * t534 * t20627 * t5298 + 0.3e1 / 0.8e1 * t534 * t20627 * t5324 - t534 * t20627 * t5233 / 0.16e2 - 0.15e2 / 0.32e2 * t519 * t12694 * t18870 - 0.25e2 / 0.16e2 * t534 * t3276 * t18870;
  t20677 = 0.15e2 / 0.16e2 * t534 * t12694 * t6218 * t815 - 0.7e1 / 0.32e2 * t519 * t20637 - 0.9e1 / 0.16e2 * t519 * t2941 * t12738 + 0.5e1 / 0.32e2 * t4006 * t4091 - 0.11e2 / 0.32e2 * t519 * t2937 * t12788 - t19689 / 0.8e1 - t19691 + t19244 + t19247 - t19253 - t19298 + t19301 + t19304 - t19307 - t19311 - t19316;
  t20684 = t18819 + t18822 - t18847 + t18851 + t18863 - t18869 - t18877 - t18881 - t18887 - t156 * t20350 * t883 * t424 / 0.32e2 + t18166 - t18169 - t18173 + t18176 - 0.3e1 / 0.4e1 * t19051;
  t20692 = -0.3e1 / 0.8e1 * t19054 + 0.3e1 / 0.8e1 * t19057 + t19060 - t19064 / 0.4e1 + 0.3e1 / 0.4e1 * t19069 - 0.3e1 / 0.4e1 * t19071 - t19074 / 0.2e1 + 0.3e1 / 0.8e1 * t19080 + t3852 - t3853 - t3854 + t3855 + t3703 + t3704 - t3705 - t3702;
  t20695 = my_piecewise3(t51, 0, t20661 + t20677 + t20684 + t20692);
  tv4lapl2tau28 = t3 * t20695;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  t20696 = t4122 * t199;
  t20706 = t17537 * t18300;
  t20723 = t17554 * t6688;
  t20734 = -t699 + 0.3e1 / 0.8e1 * t484 * t20696 * t4378 - t484 * t20696 * t4311 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t17554 * t18300 + 0.11e2 / 0.16e2 * t469 * t20706 - 0.15e2 / 0.32e2 * t469 * t17541 * t6680 - 0.25e2 / 0.16e2 * t484 * t17537 * t6680 + 0.15e2 / 0.16e2 * t484 * t17541 * t5739 * t199 - t17477 * t4048 / 0.16e2 + t17477 * t4064 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t20723 + 0.9e1 / 0.8e1 * t484 * t20706 - 0.7e1 / 0.32e2 * t469 * t20723 + 0.3e1 / 0.8e1 * t484 * t17485 * t5483 * t199;
  t20743 = t572 * t17489;
  t20752 = -0.11e2 / 0.32e2 * t469 * t572 * t17528 + t17477 * t4055 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t17485 * t6674 + 0.9e1 / 0.16e2 * t469 * t20743 + 0.11e2 / 0.16e2 * t484 * t20743 - 0.9e1 / 0.16e2 * t469 * t1735 * t17499 - t19972 - 0.3e1 / 0.32e2 * t19597 + t19990 + t19991 - t19992 - t19993 - t19994 + t19995;
  t20754 = t3882 * t4122;
  t20780 = t576 * t471;
  t20783 = t296 * t16304;
  t20786 = t114 * t16304;
  t20798 = t260 * t199 * t263 * t626 / 0.4e1 + t18035 + t214 * t199 * t290 / 0.2e1 - t17626 * t839 / 0.2e1 - t17629 * t843 / 0.2e1 - t17632 * t16305 / 0.2e1 + t4432 * t199 * t17636 / 0.2e1 + t18047 + t4112 * t20780 / 0.2e1 - t4112 * t20783 / 0.2e1 - t4112 * t20786 / 0.2e1 - t20197 * t213 * t116 / 0.2e1 - t18061 - t4114 * t20780 / 0.2e1 + t4114 * t20783 / 0.2e1 + t4114 * t20786 / 0.2e1;
  t20803 = -t19996 + t19999 - t20000 - 0.3e1 / 0.32e2 * t99 * t20754 * t956 + 0.3e1 / 0.32e2 * t99 * t20754 * t1036 + 0.3e1 / 0.32e2 * t99 * t20754 * t964 - t99 * t20798 * t866 * t269 / 0.32e2 - t18023 + t18117 - t18120 + t18123 - t20452 + t20453 + t20454;
  t20804 = -t20456 - t20457 + t20458 + t20459 - t20460 - t20461 + t4137 + t4138 - t4139 - t4140 + t3450 - t3453 - t3457 + t3461;
  t20807 = my_piecewise3(t2, 0, t20734 + t20752 + t20803 + t20804);
  tv4lapltau30 = t3 * t20807;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  t20808 = t4168 * t207;
  t20818 = t6203 * t207;
  t20822 = t17824 * t20818;
  t20839 = t17789 * t7242;
  t20844 = t17789 * t7128;
  t20847 = -t721 - 0.11e2 / 0.16e2 * t534 * t20808 * t5298 + 0.3e1 / 0.8e1 * t534 * t20808 * t5324 - t534 * t20808 * t5233 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t17789 * t20818 + 0.11e2 / 0.16e2 * t519 * t20822 - 0.15e2 / 0.32e2 * t519 * t17828 * t7232 - 0.25e2 / 0.16e2 * t534 * t17824 * t7232 + 0.15e2 / 0.16e2 * t534 * t17828 * t6218 * t207 - t17817 * t4088 / 0.16e2 + t17817 * t4100 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t20839 + 0.9e1 / 0.8e1 * t534 * t20822 + 0.9e1 / 0.16e2 * t519 * t20844;
  t20865 = -0.7e1 / 0.32e2 * t519 * t20839 - 0.9e1 / 0.16e2 * t519 * t1964 * t17793 + 0.3e1 / 0.8e1 * t534 * t17801 * t6288 * t207 - 0.11e2 / 0.32e2 * t519 * t611 * t17805 + t17817 * t4091 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t20844 - t20076 - 0.3e1 / 0.32e2 * t19689 + t20105 + t20106 - t20107 - t20108 + t20109 + t20110;
  t20867 = t3928 * t4168;
  t20893 = t615 * t521;
  t20896 = t451 * t16581;
  t20899 = t171 * t16581;
  t20911 = t415 * t207 * t418 * t665 / 0.4e1 + t18186 + t220 * t207 * t445 / 0.2e1 - t17930 * t856 / 0.2e1 - t17933 * t860 / 0.2e1 - t17936 * t16582 / 0.2e1 + t5352 * t207 * t17940 / 0.2e1 + t18198 + t4158 * t20893 / 0.2e1 - t4158 * t20896 / 0.2e1 - t4158 * t20899 / 0.2e1 - t20339 * t219 * t173 / 0.2e1 - t18212 - t4160 * t20893 / 0.2e1 + t4160 * t20896 / 0.2e1 + t4160 * t20899 / 0.2e1;
  t20916 = -t20111 - t20114 - t20115 + 0.3e1 / 0.32e2 * t156 * t20867 * t1405 - 0.3e1 / 0.32e2 * t156 * t20867 * t1366 + 0.3e1 / 0.32e2 * t156 * t20867 * t1374 - t156 * t20911 * t883 * t424 / 0.32e2 + t18166 - t18169 - t18173 + t18176 - t20529 - t20530 + t20531;
  t20917 = t20533 - t20534 + t20535 - t20536 - t20537 + t20538 + t4183 - t4184 - t4185 + t4186 + t3509 + t3513 - t3520 - t3505;
  t20920 = my_piecewise3(t51, 0, t20847 + t20865 + t20916 + t20917);
  tv4lapltau37 = t3 * t20920;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t20931 = t866 * t866;
  t20932 = t260 * t20931;
  t20949 = t993 * t866;
  t20960 = t996 * t866;
  t20967 = t868 / 0.4e1 + t18035 + t872 / 0.2e1 - t875 / 0.2e1 - t878 / 0.2e1 - t4428 * t866 * t269 / 0.2e1 + t4432 * t866 * t269 / 0.2e1 + t18047 + t20949 * t290 / 0.2e1 - t20949 * t297 / 0.2e1 - t20949 * t301 / 0.2e1 - t258 * t4117 * t213 * t116 / 0.2e1 - t18061 - t20960 * t290 / 0.2e1 + t20960 * t297 / 0.2e1 + t20960 * t301 / 0.2e1;
  t20978 = t100 * t20931;
  t20988 = -t699 - 0.5e1 / 0.32e2 * t19971 + 0.9e1 / 0.16e2 * t19159 + 0.3e1 / 0.2e1 * t19162 - 0.9e1 / 0.8e1 * t19165 - 0.3e1 / 0.8e1 * t19169 - 0.9e1 / 0.16e2 * t19174 + 0.9e1 / 0.8e1 * t19177 - 0.9e1 / 0.8e1 * t19184 + 0.9e1 / 0.16e2 * t19193 - 0.3e1 / 0.4e1 * t19196 - 0.11e2 / 0.32e2 * t99 * t20932 * t4415 - 0.7e1 / 0.32e2 * t99 * t20932 * t4277 - t99 * t20967 * t866 * t269 / 0.32e2 + 0.9e1 / 0.16e2 * t99 * t20932 * t4335 - 0.9e1 / 0.16e2 * t99 * t20932 * t4524 - t99 * t20978 * t4311 / 0.16e2 + 0.3e1 / 0.8e1 * t99 * t20978 * t4378 + 0.3e1 / 0.8e1 * t99 * t20978 * t4499;
  t20989 = t4117 * t4122;
  t21030 = 0.5e1 / 0.32e2 * t99 * t20989 * t964 - 0.11e2 / 0.16e2 * t99 * t20978 * t4316 + 0.11e2 / 0.16e2 * t99 * t20978 * t4335 + 0.11e2 / 0.16e2 * t99 * t20978 * t4343 + 0.11e2 / 0.16e2 * t99 * t20932 * t4347 - 0.15e2 / 0.32e2 * t99 * t20932 * t4352 - 0.25e2 / 0.16e2 * t99 * t20978 * t4323 + 0.15e2 / 0.16e2 * t99 * t20978 * t4331 - 0.5e1 / 0.32e2 * t99 * t20989 * t956 + 0.5e1 / 0.32e2 * t99 * t20989 * t1036 - 0.3e1 / 0.2e1 * t99 * t20978 * t4277 + 0.9e1 / 0.8e1 * t99 * t20978 * t4347 - t18023 + t18117 - t18120 + t18123 + t3558 / 0.4e1 + t3561 / 0.4e1 - t3566 / 0.8e1 - t3570 / 0.4e1;
  t21032 = my_piecewise3(t2, 0, t20988 + t21030);
  tv4tau40 = t3 * t21032;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t21043 = t883 * t883;
  t21044 = t415 * t21043;
  t21064 = t1322 * t883;
  t21075 = t1325 * t883;
  t21082 = t885 / 0.4e1 + t18186 + t889 / 0.2e1 - t892 / 0.2e1 - t895 / 0.2e1 - t5348 * t883 * t424 / 0.2e1 + t5352 * t883 * t424 / 0.2e1 + t18198 + t21064 * t445 / 0.2e1 - t21064 * t452 / 0.2e1 - t21064 * t456 / 0.2e1 - t413 * t4163 * t219 * t173 / 0.2e1 - t18212 - t21075 * t445 / 0.2e1 + t21075 * t452 / 0.2e1 + t21075 * t456 / 0.2e1;
  t21087 = t157 * t21043;
  t21100 = -t721 - 0.5e1 / 0.32e2 * t20075 + 0.9e1 / 0.16e2 * t19243 + 0.9e1 / 0.8e1 * t19246 - 0.9e1 / 0.8e1 * t19252 - 0.9e1 / 0.16e2 * t19297 + 0.9e1 / 0.16e2 * t19300 + 0.3e1 / 0.2e1 * t19303 - 0.9e1 / 0.8e1 * t19306 - 0.3e1 / 0.8e1 * t19310 - 0.3e1 / 0.4e1 * t19315 - 0.7e1 / 0.32e2 * t156 * t21044 * t5270 - 0.9e1 / 0.16e2 * t156 * t21044 * t5306 - 0.11e2 / 0.32e2 * t156 * t21044 * t5410 - t156 * t21082 * t883 * t424 / 0.32e2 - t156 * t21087 * t5233 / 0.16e2 - 0.11e2 / 0.16e2 * t156 * t21087 * t5298 + 0.3e1 / 0.8e1 * t156 * t21087 * t5324 + 0.11e2 / 0.16e2 * t156 * t21087 * t5302;
  t21104 = t4163 * t4168;
  t21142 = 0.3e1 / 0.8e1 * t156 * t21087 * t5426 + 0.5e1 / 0.32e2 * t156 * t21104 * t1405 - 0.25e2 / 0.16e2 * t156 * t21087 * t5256 + 0.15e2 / 0.16e2 * t156 * t21087 * t5263 + 0.5e1 / 0.32e2 * t156 * t21104 * t1374 - 0.3e1 / 0.2e1 * t156 * t21087 * t5270 + 0.9e1 / 0.8e1 * t156 * t21087 * t5243 + 0.9e1 / 0.16e2 * t156 * t21044 * t5302 + 0.11e2 / 0.16e2 * t156 * t21087 * t5238 + 0.11e2 / 0.16e2 * t156 * t21044 * t5243 - 0.15e2 / 0.32e2 * t156 * t21044 * t5251 - 0.5e1 / 0.32e2 * t156 * t21104 * t1366 + t18166 - t18169 - t18173 + t18176 + t3602 / 0.4e1 - t3607 / 0.8e1 - t3611 / 0.4e1 + t3614 / 0.4e1;
  t21144 = my_piecewise3(t51, 0, t21100 + t21142);
  tv4tau44 = t3 * t21144;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

