; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64 -mattr=-bf16 -stop-after=finalize-isel | FileCheck %s --check-prefixes=CHECK-NOBF16
; RUN: llc < %s -mtriple=aarch64 -mattr=+bf16 -stop-after=finalize-isel | FileCheck %s --check-prefixes=CHECK-BF16

; Check that the output instructions have the same fast math flags as the input
; fadd, even when bf16 is legalized to f32.

define bfloat @normal_fadd(bfloat %x, bfloat %y) {
  ; CHECK-NOBF16-LABEL: name: normal_fadd
  ; CHECK-NOBF16: bb.0.entry:
  ; CHECK-NOBF16-NEXT:   liveins: $h0, $h1
  ; CHECK-NOBF16-NEXT: {{  $}}
  ; CHECK-NOBF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-NOBF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-NOBF16-NEXT:   [[COPY2:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-NOBF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nofpexcept FADDSrr killed [[COPY3]], killed [[COPY2]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY4:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri:%[0-9]+]]:gpr32 = UBFMWri [[COPY4]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri]], [[COPY4]]
  ; CHECK-NOBF16-NEXT:   [[MOVi32imm:%[0-9]+]]:gpr32 = MOVi32imm 32767
  ; CHECK-NOBF16-NEXT:   [[ADDWrr1:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr]], killed [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri1:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr1]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY5:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri1]]
  ; CHECK-NOBF16-NEXT:   [[COPY6:%[0-9]+]]:fpr16 = COPY [[COPY5]].hsub
  ; CHECK-NOBF16-NEXT:   $h0 = COPY [[COPY6]]
  ; CHECK-NOBF16-NEXT:   RET_ReallyLR implicit $h0
  ;
  ; CHECK-BF16-LABEL: name: normal_fadd
  ; CHECK-BF16: bb.0.entry:
  ; CHECK-BF16-NEXT:   liveins: $h0, $h1
  ; CHECK-BF16-NEXT: {{  $}}
  ; CHECK-BF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-BF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-BF16-NEXT:   [[COPY2:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-BF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nofpexcept FADDSrr killed [[COPY3]], killed [[COPY2]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT:%[0-9]+]]:fpr16 = nofpexcept BFCVT killed [[FADDSrr]], implicit $fpcr
  ; CHECK-BF16-NEXT:   $h0 = COPY [[BFCVT]]
  ; CHECK-BF16-NEXT:   RET_ReallyLR implicit $h0
entry:
  %add = fadd bfloat %x, %y
  ret bfloat %add
}

define bfloat @fast_fadd(bfloat %x, bfloat %y) {
  ; CHECK-NOBF16-LABEL: name: fast_fadd
  ; CHECK-NOBF16: bb.0.entry:
  ; CHECK-NOBF16-NEXT:   liveins: $h0, $h1
  ; CHECK-NOBF16-NEXT: {{  $}}
  ; CHECK-NOBF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-NOBF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-NOBF16-NEXT:   [[COPY2:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-NOBF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nnan ninf nsz arcp contract afn reassoc nofpexcept FADDSrr killed [[COPY3]], killed [[COPY2]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY4:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri:%[0-9]+]]:gpr32 = UBFMWri [[COPY4]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri]], [[COPY4]]
  ; CHECK-NOBF16-NEXT:   [[MOVi32imm:%[0-9]+]]:gpr32 = MOVi32imm 32767
  ; CHECK-NOBF16-NEXT:   [[ADDWrr1:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr]], killed [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri1:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr1]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY5:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri1]]
  ; CHECK-NOBF16-NEXT:   [[COPY6:%[0-9]+]]:fpr16 = COPY [[COPY5]].hsub
  ; CHECK-NOBF16-NEXT:   $h0 = COPY [[COPY6]]
  ; CHECK-NOBF16-NEXT:   RET_ReallyLR implicit $h0
  ;
  ; CHECK-BF16-LABEL: name: fast_fadd
  ; CHECK-BF16: bb.0.entry:
  ; CHECK-BF16-NEXT:   liveins: $h0, $h1
  ; CHECK-BF16-NEXT: {{  $}}
  ; CHECK-BF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-BF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-BF16-NEXT:   [[COPY2:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-BF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nnan ninf nsz arcp contract afn reassoc nofpexcept FADDSrr killed [[COPY3]], killed [[COPY2]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT:%[0-9]+]]:fpr16 = nnan ninf nsz arcp contract afn reassoc nofpexcept BFCVT killed [[FADDSrr]], implicit $fpcr
  ; CHECK-BF16-NEXT:   $h0 = COPY [[BFCVT]]
  ; CHECK-BF16-NEXT:   RET_ReallyLR implicit $h0
entry:
  %add = fadd fast bfloat %x, %y
  ret bfloat %add
}

define bfloat @ninf_fadd(bfloat %x, bfloat %y) {
  ; CHECK-NOBF16-LABEL: name: ninf_fadd
  ; CHECK-NOBF16: bb.0.entry:
  ; CHECK-NOBF16-NEXT:   liveins: $h0, $h1
  ; CHECK-NOBF16-NEXT: {{  $}}
  ; CHECK-NOBF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-NOBF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-NOBF16-NEXT:   [[COPY2:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-NOBF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = ninf nofpexcept FADDSrr killed [[COPY3]], killed [[COPY2]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY4:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri:%[0-9]+]]:gpr32 = UBFMWri [[COPY4]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri]], [[COPY4]]
  ; CHECK-NOBF16-NEXT:   [[MOVi32imm:%[0-9]+]]:gpr32 = MOVi32imm 32767
  ; CHECK-NOBF16-NEXT:   [[ADDWrr1:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr]], killed [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri1:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr1]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY5:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri1]]
  ; CHECK-NOBF16-NEXT:   [[COPY6:%[0-9]+]]:fpr16 = COPY [[COPY5]].hsub
  ; CHECK-NOBF16-NEXT:   $h0 = COPY [[COPY6]]
  ; CHECK-NOBF16-NEXT:   RET_ReallyLR implicit $h0
  ;
  ; CHECK-BF16-LABEL: name: ninf_fadd
  ; CHECK-BF16: bb.0.entry:
  ; CHECK-BF16-NEXT:   liveins: $h0, $h1
  ; CHECK-BF16-NEXT: {{  $}}
  ; CHECK-BF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-BF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-BF16-NEXT:   [[COPY2:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-BF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = ninf nofpexcept FADDSrr killed [[COPY3]], killed [[COPY2]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT:%[0-9]+]]:fpr16 = ninf nofpexcept BFCVT killed [[FADDSrr]], implicit $fpcr
  ; CHECK-BF16-NEXT:   $h0 = COPY [[BFCVT]]
  ; CHECK-BF16-NEXT:   RET_ReallyLR implicit $h0
entry:
  %add = fadd ninf bfloat %x, %y
  ret bfloat %add
}

; Check that when we have the right fast math flags the converts in between the
; two fadds are removed.

define bfloat @normal_fadd_sequence(bfloat %x, bfloat %y, bfloat %z) {
  ; CHECK-NOBF16-LABEL: name: normal_fadd_sequence
  ; CHECK-NOBF16: bb.0.entry:
  ; CHECK-NOBF16-NEXT:   liveins: $h0, $h1, $h2
  ; CHECK-NOBF16-NEXT: {{  $}}
  ; CHECK-NOBF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h2
  ; CHECK-NOBF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-NOBF16-NEXT:   [[COPY2:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-NOBF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY2]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-NOBF16-NEXT:   [[COPY4:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nofpexcept FADDSrr killed [[COPY4]], killed [[COPY3]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY5:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri:%[0-9]+]]:gpr32 = UBFMWri [[COPY5]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri]], [[COPY5]]
  ; CHECK-NOBF16-NEXT:   [[MOVi32imm:%[0-9]+]]:gpr32 = MOVi32imm 32767
  ; CHECK-NOBF16-NEXT:   [[ADDWrr1:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr]], [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri1:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr1]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY6:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri1]]
  ; CHECK-NOBF16-NEXT:   [[COPY7:%[0-9]+]]:fpr16 = COPY [[COPY6]].hsub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG2:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, killed [[COPY7]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_2:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG2]]
  ; CHECK-NOBF16-NEXT:   [[COPY8:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_2]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG3:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_3:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG3]]
  ; CHECK-NOBF16-NEXT:   [[COPY9:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_3]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr1:%[0-9]+]]:fpr32 = nofpexcept FADDSrr killed [[COPY8]], killed [[COPY9]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY10:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr1]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri2:%[0-9]+]]:gpr32 = UBFMWri [[COPY10]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr2:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri2]], [[COPY10]]
  ; CHECK-NOBF16-NEXT:   [[ADDWrr3:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr2]], [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri3:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr3]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY11:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri3]]
  ; CHECK-NOBF16-NEXT:   [[COPY12:%[0-9]+]]:fpr16 = COPY [[COPY11]].hsub
  ; CHECK-NOBF16-NEXT:   $h0 = COPY [[COPY12]]
  ; CHECK-NOBF16-NEXT:   RET_ReallyLR implicit $h0
  ;
  ; CHECK-BF16-LABEL: name: normal_fadd_sequence
  ; CHECK-BF16: bb.0.entry:
  ; CHECK-BF16-NEXT:   liveins: $h0, $h1, $h2
  ; CHECK-BF16-NEXT: {{  $}}
  ; CHECK-BF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h2
  ; CHECK-BF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-BF16-NEXT:   [[COPY2:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-BF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY2]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-BF16-NEXT:   [[COPY4:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nofpexcept FADDSrr killed [[COPY4]], killed [[COPY3]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT:%[0-9]+]]:fpr16 = nofpexcept BFCVT killed [[FADDSrr]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG2:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, killed [[BFCVT]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_2:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG2]]
  ; CHECK-BF16-NEXT:   [[COPY5:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_2]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG3:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_3:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG3]]
  ; CHECK-BF16-NEXT:   [[COPY6:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_3]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr1:%[0-9]+]]:fpr32 = nofpexcept FADDSrr killed [[COPY5]], killed [[COPY6]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT1:%[0-9]+]]:fpr16 = nofpexcept BFCVT killed [[FADDSrr1]], implicit $fpcr
  ; CHECK-BF16-NEXT:   $h0 = COPY [[BFCVT1]]
  ; CHECK-BF16-NEXT:   RET_ReallyLR implicit $h0
entry:
  %add1 = fadd bfloat %x, %y
  %add2 = fadd bfloat %add1, %z
  ret bfloat %add2
}

define bfloat @nnan_ninf_contract_fadd_sequence(bfloat %x, bfloat %y, bfloat %z) {
  ; CHECK-NOBF16-LABEL: name: nnan_ninf_contract_fadd_sequence
  ; CHECK-NOBF16: bb.0.entry:
  ; CHECK-NOBF16-NEXT:   liveins: $h0, $h1, $h2
  ; CHECK-NOBF16-NEXT: {{  $}}
  ; CHECK-NOBF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h2
  ; CHECK-NOBF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-NOBF16-NEXT:   [[COPY2:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-NOBF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY2]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-NOBF16-NEXT:   [[COPY4:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nnan ninf contract nofpexcept FADDSrr killed [[COPY4]], killed [[COPY3]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY5:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri:%[0-9]+]]:gpr32 = UBFMWri [[COPY5]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri]], [[COPY5]]
  ; CHECK-NOBF16-NEXT:   [[MOVi32imm:%[0-9]+]]:gpr32 = MOVi32imm 32767
  ; CHECK-NOBF16-NEXT:   [[ADDWrr1:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr]], [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri1:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr1]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY6:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri1]]
  ; CHECK-NOBF16-NEXT:   [[COPY7:%[0-9]+]]:fpr16 = COPY [[COPY6]].hsub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG2:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, killed [[COPY7]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_2:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG2]]
  ; CHECK-NOBF16-NEXT:   [[COPY8:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_2]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG3:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_3:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG3]]
  ; CHECK-NOBF16-NEXT:   [[COPY9:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_3]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr1:%[0-9]+]]:fpr32 = nnan ninf contract nofpexcept FADDSrr killed [[COPY8]], killed [[COPY9]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY10:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr1]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri2:%[0-9]+]]:gpr32 = UBFMWri [[COPY10]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr2:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri2]], [[COPY10]]
  ; CHECK-NOBF16-NEXT:   [[ADDWrr3:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr2]], [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri3:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr3]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY11:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri3]]
  ; CHECK-NOBF16-NEXT:   [[COPY12:%[0-9]+]]:fpr16 = COPY [[COPY11]].hsub
  ; CHECK-NOBF16-NEXT:   $h0 = COPY [[COPY12]]
  ; CHECK-NOBF16-NEXT:   RET_ReallyLR implicit $h0
  ;
  ; CHECK-BF16-LABEL: name: nnan_ninf_contract_fadd_sequence
  ; CHECK-BF16: bb.0.entry:
  ; CHECK-BF16-NEXT:   liveins: $h0, $h1, $h2
  ; CHECK-BF16-NEXT: {{  $}}
  ; CHECK-BF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h2
  ; CHECK-BF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-BF16-NEXT:   [[COPY2:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-BF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY2]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-BF16-NEXT:   [[COPY4:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = nnan ninf contract nofpexcept FADDSrr killed [[COPY4]], killed [[COPY3]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG2:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_2:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG2]]
  ; CHECK-BF16-NEXT:   [[COPY5:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_2]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr1:%[0-9]+]]:fpr32 = nnan ninf contract nofpexcept FADDSrr killed [[FADDSrr]], killed [[COPY5]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT:%[0-9]+]]:fpr16 = nnan ninf contract nofpexcept BFCVT killed [[FADDSrr1]], implicit $fpcr
  ; CHECK-BF16-NEXT:   $h0 = COPY [[BFCVT]]
  ; CHECK-BF16-NEXT:   RET_ReallyLR implicit $h0
entry:
  %add1 = fadd nnan ninf contract bfloat %x, %y
  %add2 = fadd nnan ninf contract bfloat %add1, %z
  ret bfloat %add2
}

define bfloat @ninf_fadd_sequence(bfloat %x, bfloat %y, bfloat %z) {
  ; CHECK-NOBF16-LABEL: name: ninf_fadd_sequence
  ; CHECK-NOBF16: bb.0.entry:
  ; CHECK-NOBF16-NEXT:   liveins: $h0, $h1, $h2
  ; CHECK-NOBF16-NEXT: {{  $}}
  ; CHECK-NOBF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h2
  ; CHECK-NOBF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-NOBF16-NEXT:   [[COPY2:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-NOBF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY2]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-NOBF16-NEXT:   [[COPY4:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = ninf nofpexcept FADDSrr killed [[COPY4]], killed [[COPY3]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY5:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri:%[0-9]+]]:gpr32 = UBFMWri [[COPY5]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri]], [[COPY5]]
  ; CHECK-NOBF16-NEXT:   [[MOVi32imm:%[0-9]+]]:gpr32 = MOVi32imm 32767
  ; CHECK-NOBF16-NEXT:   [[ADDWrr1:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr]], [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri1:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr1]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY6:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri1]]
  ; CHECK-NOBF16-NEXT:   [[COPY7:%[0-9]+]]:fpr16 = COPY [[COPY6]].hsub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG2:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, killed [[COPY7]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_2:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG2]]
  ; CHECK-NOBF16-NEXT:   [[COPY8:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_2]].ssub
  ; CHECK-NOBF16-NEXT:   [[SUBREG_TO_REG3:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-NOBF16-NEXT:   [[SHLLv4i16_3:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG3]]
  ; CHECK-NOBF16-NEXT:   [[COPY9:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_3]].ssub
  ; CHECK-NOBF16-NEXT:   [[FADDSrr1:%[0-9]+]]:fpr32 = ninf nofpexcept FADDSrr killed [[COPY8]], killed [[COPY9]], implicit $fpcr
  ; CHECK-NOBF16-NEXT:   [[COPY10:%[0-9]+]]:gpr32 = COPY killed [[FADDSrr1]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri2:%[0-9]+]]:gpr32 = UBFMWri [[COPY10]], 16, 16
  ; CHECK-NOBF16-NEXT:   [[ADDWrr2:%[0-9]+]]:gpr32 = ADDWrr killed [[UBFMWri2]], [[COPY10]]
  ; CHECK-NOBF16-NEXT:   [[ADDWrr3:%[0-9]+]]:gpr32 = ADDWrr killed [[ADDWrr2]], [[MOVi32imm]]
  ; CHECK-NOBF16-NEXT:   [[UBFMWri3:%[0-9]+]]:gpr32 = UBFMWri killed [[ADDWrr3]], 16, 31
  ; CHECK-NOBF16-NEXT:   [[COPY11:%[0-9]+]]:fpr32 = COPY killed [[UBFMWri3]]
  ; CHECK-NOBF16-NEXT:   [[COPY12:%[0-9]+]]:fpr16 = COPY [[COPY11]].hsub
  ; CHECK-NOBF16-NEXT:   $h0 = COPY [[COPY12]]
  ; CHECK-NOBF16-NEXT:   RET_ReallyLR implicit $h0
  ;
  ; CHECK-BF16-LABEL: name: ninf_fadd_sequence
  ; CHECK-BF16: bb.0.entry:
  ; CHECK-BF16-NEXT:   liveins: $h0, $h1, $h2
  ; CHECK-BF16-NEXT: {{  $}}
  ; CHECK-BF16-NEXT:   [[COPY:%[0-9]+]]:fpr16 = COPY $h2
  ; CHECK-BF16-NEXT:   [[COPY1:%[0-9]+]]:fpr16 = COPY $h1
  ; CHECK-BF16-NEXT:   [[COPY2:%[0-9]+]]:fpr16 = COPY $h0
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY1]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG]]
  ; CHECK-BF16-NEXT:   [[COPY3:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG1:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY2]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_1:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG1]]
  ; CHECK-BF16-NEXT:   [[COPY4:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_1]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr:%[0-9]+]]:fpr32 = ninf nofpexcept FADDSrr killed [[COPY4]], killed [[COPY3]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT:%[0-9]+]]:fpr16 = ninf nofpexcept BFCVT killed [[FADDSrr]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG2:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, killed [[BFCVT]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_2:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG2]]
  ; CHECK-BF16-NEXT:   [[COPY5:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_2]].ssub
  ; CHECK-BF16-NEXT:   [[SUBREG_TO_REG3:%[0-9]+]]:fpr64 = SUBREG_TO_REG 0, [[COPY]], %subreg.hsub
  ; CHECK-BF16-NEXT:   [[SHLLv4i16_3:%[0-9]+]]:fpr128 = SHLLv4i16 killed [[SUBREG_TO_REG3]]
  ; CHECK-BF16-NEXT:   [[COPY6:%[0-9]+]]:fpr32 = COPY [[SHLLv4i16_3]].ssub
  ; CHECK-BF16-NEXT:   [[FADDSrr1:%[0-9]+]]:fpr32 = ninf nofpexcept FADDSrr killed [[COPY5]], killed [[COPY6]], implicit $fpcr
  ; CHECK-BF16-NEXT:   [[BFCVT1:%[0-9]+]]:fpr16 = ninf nofpexcept BFCVT killed [[FADDSrr1]], implicit $fpcr
  ; CHECK-BF16-NEXT:   $h0 = COPY [[BFCVT1]]
  ; CHECK-BF16-NEXT:   RET_ReallyLR implicit $h0
entry:
  %add1 = fadd ninf bfloat %x, %y
  %add2 = fadd ninf bfloat %add1, %z
  ret bfloat %add2
}
