; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i64_stride4_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride4_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps %xmm2, 48(%r8)
; SSE-NEXT:    movaps %xmm5, 16(%r8)
; SSE-NEXT:    movaps %xmm4, (%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride4_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm0
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX-NEXT:    vmovaps %ymm2, (%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride4_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride4_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride4_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride4_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride4_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride4_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride4_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride4_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride4_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride4_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride4_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,2,8,10,1,3,9,11]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i64>, ptr %in.vecptr3, align 64
  %1 = shufflevector <2 x i64> %in.vec0, <2 x i64> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i64> %in.vec2, <2 x i64> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <4 x i64> %1, <4 x i64> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %interleaved.vec = shufflevector <8 x i64> %3, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride4_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride4_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm3
; SSE-NEXT:    movaps (%rdx), %xmm4
; SSE-NEXT:    movaps 16(%rdx), %xmm5
; SSE-NEXT:    movaps (%rcx), %xmm6
; SSE-NEXT:    movaps 16(%rcx), %xmm7
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm6[0]
; SSE-NEXT:    movaps %xmm0, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm2[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm6[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm7[0]
; SSE-NEXT:    movaps %xmm1, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm7[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    movaps %xmm1, 96(%r8)
; SSE-NEXT:    movaps %xmm5, 112(%r8)
; SSE-NEXT:    movaps %xmm6, 64(%r8)
; SSE-NEXT:    movaps %xmm2, 80(%r8)
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps %xmm4, 48(%r8)
; SSE-NEXT:    movaps %xmm9, (%r8)
; SSE-NEXT:    movaps %xmm8, 16(%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride4_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps (%rsi), %ymm1
; AVX-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm2
; AVX-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm3
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[2,3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],mem[2,3]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vmovaps %ymm5, 64(%r8)
; AVX-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX-NEXT:    vmovaps %ymm2, 32(%r8)
; AVX-NEXT:    vmovaps %ymm4, (%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride4_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-NEXT:    vmovaps %ymm4, 32(%r8)
; AVX2-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride4_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm4, 32(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride4_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 32(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride4_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX512-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX512-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX512-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX512-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 64(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride4_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rdx), %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,8,4,12,1,9,5,13]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [2,10,6,14,3,11,7,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride4_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512DQ-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512DQ-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX512DQ-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX512DQ-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX512DQ-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 64(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride4_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rdx), %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,8,4,12,1,9,5,13]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [2,10,6,14,3,11,7,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride4_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm1
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride4_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rdx), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,8,4,12,1,9,5,13]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [2,10,6,14,3,11,7,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride4_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa (%rcx), %ymm3
; AVX512DQ-BW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm0[0,1],ymm2[0,1]
; AVX512DQ-BW-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm1[0,1],ymm3[0,1]
; AVX512DQ-BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX512DQ-BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride4_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rdx), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,8,4,12,1,9,5,13]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [2,10,6,14,3,11,7,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i64>, ptr %in.vecptr3, align 64
  %1 = shufflevector <4 x i64> %in.vec0, <4 x i64> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i64> %in.vec2, <4 x i64> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <8 x i64> %1, <8 x i64> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %interleaved.vec = shufflevector <16 x i64> %3, <16 x i64> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride4_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride4_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm5
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm3
; SSE-NEXT:    movaps 48(%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm10
; SSE-NEXT:    movaps 16(%rsi), %xmm14
; SSE-NEXT:    movaps 32(%rsi), %xmm11
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps 16(%rdx), %xmm4
; SSE-NEXT:    movaps 32(%rdx), %xmm7
; SSE-NEXT:    movaps 48(%rdx), %xmm9
; SSE-NEXT:    movaps (%rcx), %xmm8
; SSE-NEXT:    movaps 16(%rcx), %xmm13
; SSE-NEXT:    movaps 32(%rcx), %xmm15
; SSE-NEXT:    movaps 48(%rcx), %xmm12
; SSE-NEXT:    movaps %xmm2, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm8[0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm8[1]
; SSE-NEXT:    movaps %xmm5, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm10[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm10[1]
; SSE-NEXT:    movaps %xmm4, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm13[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm13[1]
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm14[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm14[1]
; SSE-NEXT:    movaps %xmm7, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm15[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm15[1]
; SSE-NEXT:    movaps %xmm3, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm11[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm11[1]
; SSE-NEXT:    movaps %xmm9, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm12[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm12[1]
; SSE-NEXT:    movaps 48(%rsi), %xmm12
; SSE-NEXT:    movaps %xmm0, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm12[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm12[1]
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps %xmm9, 240(%r8)
; SSE-NEXT:    movaps %xmm6, 192(%r8)
; SSE-NEXT:    movaps %xmm11, 208(%r8)
; SSE-NEXT:    movaps %xmm3, 160(%r8)
; SSE-NEXT:    movaps %xmm7, 176(%r8)
; SSE-NEXT:    movaps %xmm15, 128(%r8)
; SSE-NEXT:    movaps %xmm14, 144(%r8)
; SSE-NEXT:    movaps %xmm1, 96(%r8)
; SSE-NEXT:    movaps %xmm4, 112(%r8)
; SSE-NEXT:    movaps %xmm13, 64(%r8)
; SSE-NEXT:    movaps %xmm10, 80(%r8)
; SSE-NEXT:    movaps %xmm5, 32(%r8)
; SSE-NEXT:    movaps %xmm2, 48(%r8)
; SSE-NEXT:    movaps %xmm8, (%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride4_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdx), %ymm2
; AVX-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX-NEXT:    vmovaps (%rcx), %ymm3
; AVX-NEXT:    vmovaps 32(%rcx), %ymm4
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX-NEXT:    vmovaps 48(%rsi), %xmm5
; AVX-NEXT:    vmovaps 48(%rdi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm5[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm4[1],ymm1[3],ymm4[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm6[1],xmm5[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX-NEXT:    vmovaps 16(%rsi), %xmm5
; AVX-NEXT:    vmovaps 16(%rdi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm5[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm6[1],xmm5[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX-NEXT:    vmovaps 32(%rdx), %xmm5
; AVX-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm3[0]
; AVX-NEXT:    vmovaps 32(%rsi), %xmm7
; AVX-NEXT:    vmovaps 32(%rdi), %xmm8
; AVX-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm8[0],xmm7[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm5[1],xmm3[1]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm8[1],xmm7[1]
; AVX-NEXT:    vmovaps (%rcx), %xmm7
; AVX-NEXT:    vmovaps (%rdx), %xmm8
; AVX-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm8[0],xmm7[0]
; AVX-NEXT:    vmovaps (%rsi), %xmm11
; AVX-NEXT:    vmovaps (%rdi), %xmm12
; AVX-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm12[0],xmm11[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm8[1],xmm7[1]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm12[1],xmm11[1]
; AVX-NEXT:    vmovaps %xmm8, 32(%r8)
; AVX-NEXT:    vmovaps %xmm7, 48(%r8)
; AVX-NEXT:    vmovaps %xmm13, (%r8)
; AVX-NEXT:    vmovaps %xmm10, 16(%r8)
; AVX-NEXT:    vmovaps %xmm5, 160(%r8)
; AVX-NEXT:    vmovaps %xmm3, 176(%r8)
; AVX-NEXT:    vmovaps %xmm9, 128(%r8)
; AVX-NEXT:    vmovaps %xmm6, 144(%r8)
; AVX-NEXT:    vmovaps %ymm2, 96(%r8)
; AVX-NEXT:    vmovaps %ymm4, 64(%r8)
; AVX-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride4_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-NEXT:    vmovaps (%rdx), %ymm4
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm5
; AVX2-NEXT:    vmovaps (%rcx), %ymm6
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX2-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm9
; AVX2-NEXT:    vinsertf128 $1, (%rcx), %ymm8, %ymm8
; AVX2-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX2-NEXT:    vinsertf128 $1, (%rdx), %ymm10, %ymm10
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm10[1],ymm8[1],ymm10[3],ymm8[3]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm10[0],ymm8[0],ymm10[2],ymm8[2]
; AVX2-NEXT:    vinsertf128 $1, 32(%rcx), %ymm9, %ymm9
; AVX2-NEXT:    vinsertf128 $1, 32(%rdx), %ymm11, %ymm10
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm5[0],ymm7[0],ymm5[2],ymm7[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm13[2,3],ymm10[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm7[1],ymm5[3],ymm7[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm5[2,3]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm4[0],ymm6[0],ymm4[2],ymm6[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm6[1],ymm4[3],ymm6[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-NEXT:    vmovaps %ymm10, 192(%r8)
; AVX2-NEXT:    vmovaps %ymm9, 160(%r8)
; AVX2-NEXT:    vmovaps %ymm11, 128(%r8)
; AVX2-NEXT:    vmovaps %ymm8, (%r8)
; AVX2-NEXT:    vmovaps %ymm12, 32(%r8)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride4_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm4
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm5
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm6
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm9
; AVX2-FP-NEXT:    vinsertf128 $1, (%rcx), %ymm8, %ymm8
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX2-FP-NEXT:    vinsertf128 $1, (%rdx), %ymm10, %ymm10
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm10[1],ymm8[1],ymm10[3],ymm8[3]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm10[0],ymm8[0],ymm10[2],ymm8[2]
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm9, %ymm9
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm11, %ymm10
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm5[0],ymm7[0],ymm5[2],ymm7[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm13[2,3],ymm10[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm7[1],ymm5[3],ymm7[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm5[2,3]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm4[0],ymm6[0],ymm4[2],ymm6[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm6[1],ymm4[3],ymm6[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm10, 192(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm9, 160(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm11, 128(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm8, (%r8)
; AVX2-FP-NEXT:    vmovaps %ymm12, 32(%r8)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride4_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm4
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm6
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm9
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm8, %ymm8
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rdx), %ymm10, %ymm10
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm10[1],ymm8[1],ymm10[3],ymm8[3]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm10[0],ymm8[0],ymm10[2],ymm8[2]
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm9, %ymm9
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm11, %ymm10
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm5[0],ymm7[0],ymm5[2],ymm7[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm13[2,3],ymm10[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm7[1],ymm5[3],ymm7[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm5[2,3]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm4[0],ymm6[0],ymm4[2],ymm6[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm6[1],ymm4[3],ymm6[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 192(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 160(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 128(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm8, (%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 32(%r8)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride4_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512-NEXT:    movb $-52, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride4_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512-FCP-NEXT:    movb $-52, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride4_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512DQ-NEXT:    movb $-52, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride4_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    movb $-52, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride4_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512BW-NEXT:    movb $-52, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride4_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    movb $-52, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride4_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    movb $-52, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride4_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    movb $-52, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i64>, ptr %in.vecptr3, align 64
  %1 = shufflevector <8 x i64> %in.vec0, <8 x i64> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i64> %in.vec2, <8 x i64> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <16 x i64> %1, <16 x i64> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %interleaved.vec = shufflevector <32 x i64> %3, <32 x i64> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride4_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride4_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $152, %rsp
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps 48(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm2
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm12
; SSE-NEXT:    movaps 32(%rdx), %xmm14
; SSE-NEXT:    movaps 48(%rdx), %xmm15
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm5
; SSE-NEXT:    movaps 32(%rcx), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm3[0]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm4[0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm2[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm5[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm1[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm6[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm14
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps 64(%rdx), %xmm12
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rdi), %xmm11
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm11, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rdx), %xmm7
; SSE-NEXT:    movaps 80(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm7, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm1[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm8
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 96(%rdx), %xmm5
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    movaps 112(%rdx), %xmm3
; SSE-NEXT:    movaps 112(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movaps %xmm3, 496(%r8)
; SSE-NEXT:    movaps %xmm2, 480(%r8)
; SSE-NEXT:    movaps %xmm0, 464(%r8)
; SSE-NEXT:    movaps %xmm4, 448(%r8)
; SSE-NEXT:    movaps %xmm5, 432(%r8)
; SSE-NEXT:    movaps %xmm8, 416(%r8)
; SSE-NEXT:    movaps %xmm6, 400(%r8)
; SSE-NEXT:    movaps %xmm9, 384(%r8)
; SSE-NEXT:    movaps %xmm7, 368(%r8)
; SSE-NEXT:    movaps %xmm11, 352(%r8)
; SSE-NEXT:    movaps %xmm10, 336(%r8)
; SSE-NEXT:    movaps %xmm13, 320(%r8)
; SSE-NEXT:    movaps %xmm12, 304(%r8)
; SSE-NEXT:    movaps %xmm14, 288(%r8)
; SSE-NEXT:    movaps %xmm15, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    addq $152, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride4_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $152, %rsp
; AVX-NEXT:    vmovaps 96(%rdx), %ymm7
; AVX-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX-NEXT:    vmovaps 32(%rdx), %ymm3
; AVX-NEXT:    vmovaps (%rdx), %ymm1
; AVX-NEXT:    vmovaps 96(%rcx), %ymm8
; AVX-NEXT:    vmovaps 64(%rcx), %ymm6
; AVX-NEXT:    vmovaps 32(%rcx), %ymm4
; AVX-NEXT:    vmovaps (%rcx), %ymm2
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vmovaps 16(%rsi), %xmm9
; AVX-NEXT:    vmovaps 16(%rdi), %xmm10
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm10[0],xmm9[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm10[1],xmm9[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX-NEXT:    vmovaps 48(%rsi), %xmm9
; AVX-NEXT:    vmovaps 48(%rdi), %xmm10
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm10[0],xmm9[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm4[1],ymm3[3],ymm4[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm10[1],xmm9[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX-NEXT:    vmovaps 80(%rsi), %xmm9
; AVX-NEXT:    vmovaps 80(%rdi), %xmm10
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm10[0],xmm9[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm6[1],ymm5[3],ymm6[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm10[1],xmm9[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX-NEXT:    vmovaps 112(%rsi), %xmm9
; AVX-NEXT:    vmovaps 112(%rdi), %xmm10
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm10[0],xmm9[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm6[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm8[1],ymm7[3],ymm8[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm10[1],xmm9[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm10
; AVX-NEXT:    vmovaps 64(%rdi), %xmm11
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm11[0],xmm10[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm14
; AVX-NEXT:    vmovaps 64(%rcx), %xmm12
; AVX-NEXT:    vmovaps 64(%rdx), %xmm13
; AVX-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm13[0],xmm12[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm11[1],xmm10[1]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm13[1],xmm12[1]
; AVX-NEXT:    vmovaps 32(%rsi), %xmm13
; AVX-NEXT:    vmovaps 32(%rdi), %xmm15
; AVX-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm15[0],xmm13[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm15[1],xmm13[1]
; AVX-NEXT:    vmovaps 32(%rdx), %xmm15
; AVX-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm15[0],xmm14[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm14 = xmm15[1],xmm14[1]
; AVX-NEXT:    vmovaps 96(%rsi), %xmm15
; AVX-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm0[0],xmm15[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm0[1],xmm15[1]
; AVX-NEXT:    vmovaps 96(%rcx), %xmm15
; AVX-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm0[0],xmm15[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm0[1],xmm15[1]
; AVX-NEXT:    vmovaps (%rsi), %xmm15
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm0[0],xmm15[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm0[1],xmm15[1]
; AVX-NEXT:    vmovaps (%rcx), %xmm15
; AVX-NEXT:    vmovaps (%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm15[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm15[1]
; AVX-NEXT:    vmovaps %xmm0, 48(%r8)
; AVX-NEXT:    vmovaps %xmm2, 32(%r8)
; AVX-NEXT:    vmovaps %xmm1, 16(%r8)
; AVX-NEXT:    vmovaps %xmm3, (%r8)
; AVX-NEXT:    vmovaps %xmm4, 432(%r8)
; AVX-NEXT:    vmovaps %xmm6, 416(%r8)
; AVX-NEXT:    vmovaps %xmm5, 400(%r8)
; AVX-NEXT:    vmovaps %xmm7, 384(%r8)
; AVX-NEXT:    vmovaps %xmm14, 176(%r8)
; AVX-NEXT:    vmovaps %xmm13, 160(%r8)
; AVX-NEXT:    vmovaps %xmm8, 144(%r8)
; AVX-NEXT:    vmovaps %xmm12, 128(%r8)
; AVX-NEXT:    vmovaps %xmm11, 304(%r8)
; AVX-NEXT:    vmovaps %xmm10, 288(%r8)
; AVX-NEXT:    vmovaps %xmm9, 272(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 256(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX-NEXT:    addq $152, %rsp
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride4_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rax
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-NEXT:    vmovaps (%rsi), %ymm9
; AVX2-NEXT:    vmovaps (%rdx), %ymm11
; AVX2-NEXT:    vmovaps (%rcx), %ymm13
; AVX2-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm2
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX2-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm1
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX2-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm10
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm10[0],ymm1[0],ymm10[2],ymm1[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm10[1],ymm1[1],ymm10[3],ymm1[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 32(%rcx), %ymm2, %ymm10
; AVX2-NEXT:    vinsertf128 $1, 32(%rdx), %ymm3, %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm3[0],ymm10[0],ymm3[2],ymm10[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm10[1],ymm3[3],ymm10[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 64(%rcx), %ymm6, %ymm10
; AVX2-NEXT:    vinsertf128 $1, 64(%rdx), %ymm7, %ymm7
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm7[0],ymm10[0],ymm7[2],ymm10[2]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm10
; AVX2-NEXT:    vinsertf128 $1, 96(%rcx), %ymm10, %ymm12
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm10
; AVX2-NEXT:    vinsertf128 $1, 96(%rdx), %ymm10, %ymm14
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm14[0],ymm12[0],ymm14[2],ymm12[2]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm12[1],ymm14[3],ymm12[3]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm8[0],ymm9[0],ymm8[2],ymm9[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm15[2,3],ymm14[2,3]
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm15
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm13
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm8 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm11[2,3]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm15[0],ymm13[0],ymm15[2],ymm13[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm11[2,3],ymm9[2,3]
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm11
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm15[1],ymm13[1],ymm15[3],ymm13[3]
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm15
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm13[2,3]
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm13
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm13[0],ymm5[2],ymm13[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm11[0],ymm15[0],ymm11[2],ymm15[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm13[1],ymm5[3],ymm13[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm15[1],ymm11[3],ymm15[3]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm11
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm5
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm15
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm11[0],ymm5[0],ymm11[2],ymm5[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm3[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm5[1],ymm11[3],ymm5[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX2-NEXT:    vmovaps %ymm3, 480(%r8)
; AVX2-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX2-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX2-NEXT:    vmovaps %ymm2, 320(%r8)
; AVX2-NEXT:    vmovaps %ymm4, 224(%r8)
; AVX2-NEXT:    vmovaps %ymm9, 192(%r8)
; AVX2-NEXT:    vmovaps %ymm8, 96(%r8)
; AVX2-NEXT:    vmovaps %ymm14, 64(%r8)
; AVX2-NEXT:    vmovaps %ymm12, 416(%r8)
; AVX2-NEXT:    vmovaps %ymm10, 384(%r8)
; AVX2-NEXT:    vmovaps %ymm7, 288(%r8)
; AVX2-NEXT:    vmovaps %ymm6, 256(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-NEXT:    popq %rax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride4_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    pushq %rax
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm9
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm11
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm13
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX2-FP-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX2-FP-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm10
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm10[0],ymm1[0],ymm10[2],ymm1[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm10[1],ymm1[1],ymm10[3],ymm1[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm2, %ymm10
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm3, %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm3[0],ymm10[0],ymm3[2],ymm10[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm10[1],ymm3[3],ymm10[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%rcx), %ymm6, %ymm10
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%rdx), %ymm7, %ymm7
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm7[0],ymm10[0],ymm7[2],ymm10[2]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm10
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%rcx), %ymm10, %ymm12
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm10
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%rdx), %ymm10, %ymm14
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm14[0],ymm12[0],ymm14[2],ymm12[2]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm12[1],ymm14[3],ymm12[3]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm8[0],ymm9[0],ymm8[2],ymm9[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm15[2,3],ymm14[2,3]
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm15
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm13
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm8 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm11[2,3]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm15[0],ymm13[0],ymm15[2],ymm13[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm11[2,3],ymm9[2,3]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm11
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm15[1],ymm13[1],ymm15[3],ymm13[3]
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm15
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm13[2,3]
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm13
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm13[0],ymm5[2],ymm13[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm11[0],ymm15[0],ymm11[2],ymm15[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm13[1],ymm5[3],ymm13[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm15[1],ymm11[3],ymm15[3]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm11
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm15
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm11[0],ymm5[0],ymm11[2],ymm5[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm3[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm5[1],ymm11[3],ymm5[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vmovaps %ymm3, 480(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm2, 320(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm4, 224(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm9, 192(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm8, 96(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm14, 64(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm12, 416(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm10, 384(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm7, 288(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm6, 256(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FP-NEXT:    popq %rax
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride4_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    pushq %rax
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm9
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm11
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm13
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm10
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm10[0],ymm1[0],ymm10[2],ymm1[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm10[1],ymm1[1],ymm10[3],ymm1[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm2, %ymm10
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm3, %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm3[0],ymm10[0],ymm3[2],ymm10[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm10[1],ymm3[3],ymm10[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%rcx), %ymm6, %ymm10
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%rdx), %ymm7, %ymm7
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm7[0],ymm10[0],ymm7[2],ymm10[2]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm10
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%rcx), %ymm10, %ymm12
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm10
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%rdx), %ymm10, %ymm14
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm14[0],ymm12[0],ymm14[2],ymm12[2]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm12[1],ymm14[3],ymm12[3]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm8[0],ymm9[0],ymm8[2],ymm9[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm15[2,3],ymm14[2,3]
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm15
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm13
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm8 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm11[2,3]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm15[0],ymm13[0],ymm15[2],ymm13[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm11[2,3],ymm9[2,3]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm11
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm15[1],ymm13[1],ymm15[3],ymm13[3]
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm15
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm13[2,3]
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm13
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm13[0],ymm5[2],ymm13[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm11[0],ymm15[0],ymm11[2],ymm15[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm13[1],ymm5[3],ymm13[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm15[1],ymm11[3],ymm15[3]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm11
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm15
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm11[0],ymm5[0],ymm11[2],ymm5[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm3[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm5[1],ymm11[3],ymm5[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm3, 480(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 320(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 224(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 192(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 96(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 64(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 416(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 384(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 288(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 256(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FCP-NEXT:    popq %rax
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride4_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512-NEXT:    movb $-52, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride4_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512-FCP-NEXT:    movb $-52, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride4_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512DQ-NEXT:    movb $-52, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512DQ-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512DQ-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride4_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512DQ-FCP-NEXT:    movb $-52, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride4_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512BW-NEXT:    movb $-52, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride4_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512BW-FCP-NEXT:    movb $-52, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride4_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512DQ-BW-NEXT:    movb $-52, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride4_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm10 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm10, %zmm11
; AVX512DQ-BW-FCP-NEXT:    movb $-52, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm12 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm12, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm15, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm1, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 448(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 256(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 320(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i64>, ptr %in.vecptr3, align 64
  %1 = shufflevector <16 x i64> %in.vec0, <16 x i64> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i64> %in.vec2, <16 x i64> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <32 x i64> %1, <32 x i64> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %interleaved.vec = shufflevector <64 x i64> %3, <64 x i64> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride4_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride4_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $664, %rsp # imm = 0x298
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps 48(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm2
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm12
; SSE-NEXT:    movaps 32(%rdx), %xmm13
; SSE-NEXT:    movaps 48(%rdx), %xmm14
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm5
; SSE-NEXT:    movaps 32(%rcx), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm3[0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm4[0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm2[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm5[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm1[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm2
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm2
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm2
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm2
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm14
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps 192(%rdi), %xmm12
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 192(%rdx), %xmm15
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 208(%rdi), %xmm10
; SSE-NEXT:    movaps 208(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm10, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps 208(%rdx), %xmm7
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm7, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rdi), %xmm8
; SSE-NEXT:    movaps 224(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rdx), %xmm4
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm4, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm0[1]
; SSE-NEXT:    movaps 240(%rdi), %xmm2
; SSE-NEXT:    movaps 240(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    movaps 240(%rdx), %xmm3
; SSE-NEXT:    movaps 240(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movaps %xmm3, 1008(%r8)
; SSE-NEXT:    movaps %xmm2, 992(%r8)
; SSE-NEXT:    movaps %xmm0, 976(%r8)
; SSE-NEXT:    movaps %xmm5, 960(%r8)
; SSE-NEXT:    movaps %xmm4, 944(%r8)
; SSE-NEXT:    movaps %xmm8, 928(%r8)
; SSE-NEXT:    movaps %xmm6, 912(%r8)
; SSE-NEXT:    movaps %xmm9, 896(%r8)
; SSE-NEXT:    movaps %xmm7, 880(%r8)
; SSE-NEXT:    movaps %xmm10, 864(%r8)
; SSE-NEXT:    movaps %xmm11, 848(%r8)
; SSE-NEXT:    movaps %xmm13, 832(%r8)
; SSE-NEXT:    movaps %xmm15, 816(%r8)
; SSE-NEXT:    movaps %xmm12, 800(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%r8)
; SSE-NEXT:    movaps %xmm14, 752(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%r8)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    addq $664, %rsp # imm = 0x298
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride4_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $664, %rsp # imm = 0x298
; AVX-NEXT:    vmovaps 160(%rdx), %ymm0
; AVX-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX-NEXT:    vmovaps 96(%rdx), %ymm4
; AVX-NEXT:    vmovaps 64(%rdx), %ymm6
; AVX-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX-NEXT:    vmovaps (%rdx), %ymm8
; AVX-NEXT:    vmovaps 160(%rcx), %ymm1
; AVX-NEXT:    vmovaps 128(%rcx), %ymm3
; AVX-NEXT:    vmovaps 96(%rcx), %ymm5
; AVX-NEXT:    vmovaps 64(%rcx), %ymm9
; AVX-NEXT:    vmovaps 32(%rcx), %ymm10
; AVX-NEXT:    vmovaps (%rcx), %ymm11
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm8[0],ymm11[0],ymm8[2],ymm11[2]
; AVX-NEXT:    vmovaps 16(%rsi), %xmm13
; AVX-NEXT:    vmovaps 16(%rdi), %xmm14
; AVX-NEXT:    vmovlhps {{.*#+}} xmm15 = xmm14[0],xmm13[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm15[0,1,2,3],ymm12[4,5,6,7]
; AVX-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm8 = ymm8[1],ymm11[1],ymm8[3],ymm11[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm14[1],xmm13[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm7[0],ymm10[0],ymm7[2],ymm10[2]
; AVX-NEXT:    vmovaps 48(%rsi), %xmm11
; AVX-NEXT:    vmovaps 48(%rdi), %xmm12
; AVX-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm12[0],xmm11[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1,2,3],ymm8[4,5,6,7]
; AVX-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm12[1],xmm11[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm6[0],ymm9[0],ymm6[2],ymm9[2]
; AVX-NEXT:    vmovaps 80(%rsi), %xmm8
; AVX-NEXT:    vmovaps 80(%rdi), %xmm10
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm10[0],xmm8[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm6[1],ymm9[1],ymm6[3],ymm9[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm10[1],xmm8[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX-NEXT:    vmovaps 112(%rsi), %xmm7
; AVX-NEXT:    vmovaps 112(%rdi), %xmm8
; AVX-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm8[0],xmm7[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm8[1],xmm7[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX-NEXT:    vmovaps 144(%rsi), %xmm5
; AVX-NEXT:    vmovaps 144(%rdi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm5[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm6[1],xmm5[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 176(%rsi), %xmm3
; AVX-NEXT:    vmovaps 176(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vmovaps 192(%rcx), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX-NEXT:    vmovaps 208(%rsi), %xmm3
; AVX-NEXT:    vmovaps 208(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm1[1],ymm2[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %ymm0
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX-NEXT:    vmovaps 240(%rsi), %xmm3
; AVX-NEXT:    vmovaps 240(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rcx), %xmm0
; AVX-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm0
; AVX-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm15 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps 160(%rcx), %xmm0
; AVX-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm1[0],xmm0[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps 224(%rcx), %xmm1
; AVX-NEXT:    vmovaps 224(%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps 192(%rcx), %xmm1
; AVX-NEXT:    vmovaps 192(%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps (%rcx), %xmm1
; AVX-NEXT:    vmovaps (%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps %xmm0, 48(%r8)
; AVX-NEXT:    vmovaps %xmm3, 32(%r8)
; AVX-NEXT:    vmovaps %xmm2, 16(%r8)
; AVX-NEXT:    vmovaps %xmm4, (%r8)
; AVX-NEXT:    vmovaps %xmm5, 816(%r8)
; AVX-NEXT:    vmovaps %xmm7, 800(%r8)
; AVX-NEXT:    vmovaps %xmm6, 784(%r8)
; AVX-NEXT:    vmovaps %xmm8, 768(%r8)
; AVX-NEXT:    vmovaps %xmm9, 944(%r8)
; AVX-NEXT:    vmovaps %xmm11, 928(%r8)
; AVX-NEXT:    vmovaps %xmm10, 912(%r8)
; AVX-NEXT:    vmovaps %xmm12, 896(%r8)
; AVX-NEXT:    vmovaps %xmm13, 688(%r8)
; AVX-NEXT:    vmovaps %xmm15, 672(%r8)
; AVX-NEXT:    vmovaps %xmm14, 656(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 640(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 432(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 416(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 400(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 384(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 176(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 160(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 144(%r8)
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 128(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 304(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 288(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 272(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 256(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 560(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 544(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 528(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 512(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 992(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 864(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 736(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 704(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 576(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX-NEXT:    addq $664, %rsp # imm = 0x298
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride4_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $520, %rsp # imm = 0x208
; AVX2-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 32(%rcx), %ymm1, %ymm0
; AVX2-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 64(%rcx), %ymm2, %ymm0
; AVX2-NEXT:    vinsertf128 $1, 64(%rdx), %ymm5, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 160(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 224(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm11[2,3],ymm4[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm0[2,3]
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm3
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm11
; AVX2-NEXT:    vmovaps 128(%rcx), %ymm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm11[0],ymm0[0],ymm11[2],ymm0[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm13[2,3],ymm2[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm11[1],ymm0[1],ymm11[3],ymm0[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm0[2,3]
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm3
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm11
; AVX2-NEXT:    vmovaps 160(%rcx), %ymm13
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm15[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm11[2,3]
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm11
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm13
; AVX2-NEXT:    vmovaps 192(%rcx), %ymm15
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm3[0],ymm11[0],ymm3[2],ymm11[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm14[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm11[1],ymm3[3],ymm11[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm13[2,3]
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm11
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm13
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm14
; AVX2-NEXT:    vmovaps 224(%rcx), %ymm15
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm12[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-NEXT:    vmovaps %ymm11, 992(%r8)
; AVX2-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX2-NEXT:    vmovaps %ymm3, 864(%r8)
; AVX2-NEXT:    vmovaps %ymm1, 832(%r8)
; AVX2-NEXT:    vmovaps %ymm2, 736(%r8)
; AVX2-NEXT:    vmovaps %ymm4, 704(%r8)
; AVX2-NEXT:    vmovaps %ymm5, 608(%r8)
; AVX2-NEXT:    vmovaps %ymm6, 576(%r8)
; AVX2-NEXT:    vmovaps %ymm7, 480(%r8)
; AVX2-NEXT:    vmovaps %ymm8, 448(%r8)
; AVX2-NEXT:    vmovaps %ymm9, 352(%r8)
; AVX2-NEXT:    vmovaps %ymm10, 320(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 928(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 896(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 768(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 544(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-NEXT:    addq $520, %rsp # imm = 0x208
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride4_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $520, %rsp # imm = 0x208
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-FP-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-FP-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm1, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%rcx), %ymm2, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%rdx), %ymm5, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 160(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 224(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm0
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm11[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm11
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %ymm0
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm11[0],ymm0[0],ymm11[2],ymm0[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm13[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm11[1],ymm0[1],ymm11[3],ymm0[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm11
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %ymm13
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm15[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm11[2,3]
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm11
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm13
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %ymm15
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm3[0],ymm11[0],ymm3[2],ymm11[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm14[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm11[1],ymm3[3],ymm11[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm13[2,3]
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm11
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm13
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm14
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %ymm15
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm12[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    vmovaps %ymm11, 992(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm3, 864(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm1, 832(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm2, 736(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm4, 704(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm5, 608(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm6, 576(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm7, 480(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm8, 448(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm9, 352(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm10, 320(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 928(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 896(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 768(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 544(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FP-NEXT:    addq $520, %rsp # imm = 0x208
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride4_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $520, %rsp # imm = 0x208
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm1, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%rcx), %ymm2, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%rdx), %ymm5, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 160(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 224(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm0
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm11[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm11
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %ymm0
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm11[0],ymm0[0],ymm11[2],ymm0[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm13[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm11[1],ymm0[1],ymm11[3],ymm0[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm11
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %ymm13
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm15[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm11[2,3]
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm13
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %ymm15
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm3[0],ymm11[0],ymm3[2],ymm11[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm14[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm11[1],ymm3[3],ymm11[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm13[2,3]
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm13
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm14
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %ymm15
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm11[0],ymm13[0],ymm11[2],ymm13[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm12[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm11[1],ymm13[1],ymm11[3],ymm13[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm11, 992(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 864(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 832(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 736(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 704(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 608(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 576(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 480(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 448(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 352(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 320(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-FCP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 928(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 896(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 768(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 544(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FCP-NEXT:    addq $520, %rsp # imm = 0x208
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride4_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512-NEXT:    movb $-52, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride4_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512-FCP-NEXT:    movb $-52, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride4_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512DQ-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512DQ-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512DQ-NEXT:    movb $-52, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512DQ-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512DQ-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512DQ-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride4_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512DQ-FCP-NEXT:    movb $-52, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride4_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512BW-NEXT:    movb $-52, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride4_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512BW-FCP-NEXT:    movb $-52, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride4_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512DQ-BW-NEXT:    movb $-52, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride4_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm14 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm14, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm7, %zmm4
; AVX512DQ-BW-FCP-NEXT:    movb $-52, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm16, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm18 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm18, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm20, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm14, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm7, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm16, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm11, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm18, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, %zmm24 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm20, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm21, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm14, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm7, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm25 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm16, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm11, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm26 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm18, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm15, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm27 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm20, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm21, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm9, %zmm6, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm3, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm20, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm21, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 896(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 960(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 768(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 832(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 640(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, 704(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, 512(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 384(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, 448(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, 256(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 320(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i64>, ptr %in.vecptr3, align 64
  %1 = shufflevector <32 x i64> %in.vec0, <32 x i64> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i64> %in.vec2, <32 x i64> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <64 x i64> %1, <64 x i64> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %interleaved.vec = shufflevector <128 x i64> %3, <128 x i64> poison, <128 x i32> <i32 0, i32 32, i32 64, i32 96, i32 1, i32 33, i32 65, i32 97, i32 2, i32 34, i32 66, i32 98, i32 3, i32 35, i32 67, i32 99, i32 4, i32 36, i32 68, i32 100, i32 5, i32 37, i32 69, i32 101, i32 6, i32 38, i32 70, i32 102, i32 7, i32 39, i32 71, i32 103, i32 8, i32 40, i32 72, i32 104, i32 9, i32 41, i32 73, i32 105, i32 10, i32 42, i32 74, i32 106, i32 11, i32 43, i32 75, i32 107, i32 12, i32 44, i32 76, i32 108, i32 13, i32 45, i32 77, i32 109, i32 14, i32 46, i32 78, i32 110, i32 15, i32 47, i32 79, i32 111, i32 16, i32 48, i32 80, i32 112, i32 17, i32 49, i32 81, i32 113, i32 18, i32 50, i32 82, i32 114, i32 19, i32 51, i32 83, i32 115, i32 20, i32 52, i32 84, i32 116, i32 21, i32 53, i32 85, i32 117, i32 22, i32 54, i32 86, i32 118, i32 23, i32 55, i32 87, i32 119, i32 24, i32 56, i32 88, i32 120, i32 25, i32 57, i32 89, i32 121, i32 26, i32 58, i32 90, i32 122, i32 27, i32 59, i32 91, i32 123, i32 28, i32 60, i32 92, i32 124, i32 29, i32 61, i32 93, i32 125, i32 30, i32 62, i32 94, i32 126, i32 31, i32 63, i32 95, i32 127>
  store <128 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride4_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride4_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1688, %rsp # imm = 0x698
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps 48(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm2
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm12
; SSE-NEXT:    movaps 32(%rdx), %xmm13
; SSE-NEXT:    movaps 48(%rdx), %xmm14
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm5
; SSE-NEXT:    movaps 32(%rcx), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm3[0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm2[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm5[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm1[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm2
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm2
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm2
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm2
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm2
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm2
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm2
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdi), %xmm2
; SSE-NEXT:    movaps 208(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdx), %xmm2
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdi), %xmm2
; SSE-NEXT:    movaps 224(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdx), %xmm2
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%rdi), %xmm2
; SSE-NEXT:    movaps 240(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%rdx), %xmm2
; SSE-NEXT:    movaps 240(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdi), %xmm2
; SSE-NEXT:    movaps 256(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdx), %xmm2
; SSE-NEXT:    movaps 256(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%rdi), %xmm2
; SSE-NEXT:    movaps 272(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%rdx), %xmm2
; SSE-NEXT:    movaps 272(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%rdi), %xmm2
; SSE-NEXT:    movaps 288(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%rdx), %xmm2
; SSE-NEXT:    movaps 288(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%rdi), %xmm2
; SSE-NEXT:    movaps 304(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%rdx), %xmm2
; SSE-NEXT:    movaps 304(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%rdi), %xmm2
; SSE-NEXT:    movaps 320(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%rdx), %xmm2
; SSE-NEXT:    movaps 320(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%rdi), %xmm2
; SSE-NEXT:    movaps 336(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%rdx), %xmm2
; SSE-NEXT:    movaps 336(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%rdi), %xmm2
; SSE-NEXT:    movaps 352(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%rdx), %xmm2
; SSE-NEXT:    movaps 352(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdi), %xmm2
; SSE-NEXT:    movaps 368(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdx), %xmm2
; SSE-NEXT:    movaps 368(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%rdi), %xmm2
; SSE-NEXT:    movaps 384(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%rdx), %xmm2
; SSE-NEXT:    movaps 384(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%rdi), %xmm2
; SSE-NEXT:    movaps 400(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%rdx), %xmm2
; SSE-NEXT:    movaps 400(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%rdi), %xmm2
; SSE-NEXT:    movaps 416(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%rdx), %xmm2
; SSE-NEXT:    movaps 416(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%rdi), %xmm2
; SSE-NEXT:    movaps 432(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%rdx), %xmm15
; SSE-NEXT:    movaps 432(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 448(%rdi), %xmm12
; SSE-NEXT:    movaps 448(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 448(%rdx), %xmm11
; SSE-NEXT:    movaps 448(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm0[1]
; SSE-NEXT:    movaps 464(%rdi), %xmm13
; SSE-NEXT:    movaps 464(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movaps 464(%rdx), %xmm7
; SSE-NEXT:    movaps 464(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm7, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm1[1]
; SSE-NEXT:    movaps 480(%rdi), %xmm8
; SSE-NEXT:    movaps 480(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 480(%rdx), %xmm5
; SSE-NEXT:    movaps 480(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 496(%rdi), %xmm2
; SSE-NEXT:    movaps 496(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    movaps 496(%rdx), %xmm3
; SSE-NEXT:    movaps 496(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movaps %xmm3, 2032(%r8)
; SSE-NEXT:    movaps %xmm2, 2016(%r8)
; SSE-NEXT:    movaps %xmm0, 2000(%r8)
; SSE-NEXT:    movaps %xmm4, 1984(%r8)
; SSE-NEXT:    movaps %xmm5, 1968(%r8)
; SSE-NEXT:    movaps %xmm8, 1952(%r8)
; SSE-NEXT:    movaps %xmm6, 1936(%r8)
; SSE-NEXT:    movaps %xmm9, 1920(%r8)
; SSE-NEXT:    movaps %xmm7, 1904(%r8)
; SSE-NEXT:    movaps %xmm13, 1888(%r8)
; SSE-NEXT:    movaps %xmm10, 1872(%r8)
; SSE-NEXT:    movaps %xmm14, 1856(%r8)
; SSE-NEXT:    movaps %xmm11, 1840(%r8)
; SSE-NEXT:    movaps %xmm12, 1824(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1808(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1792(%r8)
; SSE-NEXT:    movaps %xmm15, 1776(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1760(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1744(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1712(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1696(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1680(%r8)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1664(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1648(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1632(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1600(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1584(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1552(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    addq $1688, %rsp # imm = 0x698
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride4_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $1688, %rsp # imm = 0x698
; AVX-NEXT:    vmovaps 160(%rdx), %ymm0
; AVX-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX-NEXT:    vmovaps (%rdx), %ymm8
; AVX-NEXT:    vmovaps 160(%rcx), %ymm2
; AVX-NEXT:    vmovaps 128(%rcx), %ymm4
; AVX-NEXT:    vmovaps 96(%rcx), %ymm6
; AVX-NEXT:    vmovaps 64(%rcx), %ymm9
; AVX-NEXT:    vmovaps 32(%rcx), %ymm10
; AVX-NEXT:    vmovaps (%rcx), %ymm11
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm8[0],ymm11[0],ymm8[2],ymm11[2]
; AVX-NEXT:    vmovaps 16(%rsi), %xmm13
; AVX-NEXT:    vmovaps 16(%rdi), %xmm14
; AVX-NEXT:    vmovlhps {{.*#+}} xmm15 = xmm14[0],xmm13[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm15[0,1,2,3],ymm12[4,5,6,7]
; AVX-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm8 = ymm8[1],ymm11[1],ymm8[3],ymm11[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm14[1],xmm13[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm7[0],ymm10[0],ymm7[2],ymm10[2]
; AVX-NEXT:    vmovaps 48(%rsi), %xmm11
; AVX-NEXT:    vmovaps 48(%rdi), %xmm12
; AVX-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm12[0],xmm11[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1,2,3],ymm8[4,5,6,7]
; AVX-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm10[1],ymm7[3],ymm10[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm12[1],xmm11[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm5[0],ymm9[0],ymm5[2],ymm9[2]
; AVX-NEXT:    vmovaps 80(%rsi), %xmm8
; AVX-NEXT:    vmovaps 80(%rdi), %xmm10
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm10[0],xmm8[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm9[1],ymm5[3],ymm9[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm10[1],xmm8[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm3[0],ymm6[0],ymm3[2],ymm6[2]
; AVX-NEXT:    vmovaps 112(%rsi), %xmm7
; AVX-NEXT:    vmovaps 112(%rdi), %xmm8
; AVX-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm8[0],xmm7[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm9[0,1,2,3],ymm5[4,5,6,7]
; AVX-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm6[1],ymm3[3],ymm6[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm8[1],xmm7[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX-NEXT:    vmovaps 144(%rsi), %xmm5
; AVX-NEXT:    vmovaps 144(%rdi), %xmm6
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm5[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm4[1],ymm1[3],ymm4[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm6[1],xmm5[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX-NEXT:    vmovaps 176(%rsi), %xmm3
; AVX-NEXT:    vmovaps 176(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX-NEXT:    vmovaps 192(%rcx), %ymm2
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX-NEXT:    vmovaps 208(%rsi), %xmm3
; AVX-NEXT:    vmovaps 208(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %ymm0
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX-NEXT:    vmovaps 240(%rsi), %xmm3
; AVX-NEXT:    vmovaps 240(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rdx), %ymm0
; AVX-NEXT:    vmovaps 256(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 272(%rsi), %xmm3
; AVX-NEXT:    vmovaps 272(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 288(%rdx), %ymm0
; AVX-NEXT:    vmovaps 288(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 304(%rsi), %xmm3
; AVX-NEXT:    vmovaps 304(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 320(%rdx), %ymm0
; AVX-NEXT:    vmovaps 320(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 336(%rsi), %xmm3
; AVX-NEXT:    vmovaps 336(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 352(%rdx), %ymm0
; AVX-NEXT:    vmovaps 352(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 368(%rsi), %xmm3
; AVX-NEXT:    vmovaps 368(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 384(%rdx), %ymm0
; AVX-NEXT:    vmovaps 384(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 400(%rsi), %xmm3
; AVX-NEXT:    vmovaps 400(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rdx), %ymm0
; AVX-NEXT:    vmovaps 416(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 432(%rsi), %xmm3
; AVX-NEXT:    vmovaps 432(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 448(%rdx), %ymm0
; AVX-NEXT:    vmovaps 448(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 464(%rsi), %xmm3
; AVX-NEXT:    vmovaps 464(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 480(%rdx), %ymm0
; AVX-NEXT:    vmovaps 480(%rcx), %ymm1
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX-NEXT:    vmovaps 496(%rsi), %xmm3
; AVX-NEXT:    vmovaps 496(%rdi), %xmm4
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rsi), %xmm0
; AVX-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 256(%rcx), %xmm0
; AVX-NEXT:    vmovaps 256(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rcx), %xmm0
; AVX-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm0
; AVX-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rcx), %xmm0
; AVX-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rcx), %xmm0
; AVX-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 288(%rsi), %xmm0
; AVX-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 288(%rcx), %xmm0
; AVX-NEXT:    vmovaps 288(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 352(%rsi), %xmm0
; AVX-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 352(%rcx), %xmm0
; AVX-NEXT:    vmovaps 352(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 320(%rsi), %xmm0
; AVX-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 320(%rcx), %xmm0
; AVX-NEXT:    vmovaps 320(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 416(%rsi), %xmm0
; AVX-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 416(%rcx), %xmm0
; AVX-NEXT:    vmovaps 416(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 480(%rsi), %xmm0
; AVX-NEXT:    vmovaps 480(%rdi), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm15 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps 480(%rcx), %xmm0
; AVX-NEXT:    vmovaps 480(%rdx), %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm1[0],xmm0[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps 448(%rsi), %xmm1
; AVX-NEXT:    vmovaps 448(%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps 448(%rcx), %xmm1
; AVX-NEXT:    vmovaps 448(%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps 384(%rsi), %xmm1
; AVX-NEXT:    vmovaps 384(%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps 384(%rcx), %xmm1
; AVX-NEXT:    vmovaps 384(%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps (%rcx), %xmm1
; AVX-NEXT:    vmovaps (%rdx), %xmm0
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps %xmm0, 48(%r8)
; AVX-NEXT:    vmovaps %xmm3, 32(%r8)
; AVX-NEXT:    vmovaps %xmm2, 16(%r8)
; AVX-NEXT:    vmovaps %xmm4, (%r8)
; AVX-NEXT:    vmovaps %xmm5, 1584(%r8)
; AVX-NEXT:    vmovaps %xmm7, 1568(%r8)
; AVX-NEXT:    vmovaps %xmm6, 1552(%r8)
; AVX-NEXT:    vmovaps %xmm8, 1536(%r8)
; AVX-NEXT:    vmovaps %xmm9, 1840(%r8)
; AVX-NEXT:    vmovaps %xmm11, 1824(%r8)
; AVX-NEXT:    vmovaps %xmm10, 1808(%r8)
; AVX-NEXT:    vmovaps %xmm12, 1792(%r8)
; AVX-NEXT:    vmovaps %xmm13, 1968(%r8)
; AVX-NEXT:    vmovaps %xmm15, 1952(%r8)
; AVX-NEXT:    vmovaps %xmm14, 1936(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1920(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1712(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1696(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1680(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1664(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1328(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1312(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1296(%r8)
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1280(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1456(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1440(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1424(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1408(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1200(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1184(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1168(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1152(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 816(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 800(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 784(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 768(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 944(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 928(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 912(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 896(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 688(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 672(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 656(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 640(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 432(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 416(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 400(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 384(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 176(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 160(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 144(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 128(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 304(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 288(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 272(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 256(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 560(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 544(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 528(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 512(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1072(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1056(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1040(%r8)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1024(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2016(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1984(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1888(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1856(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1760(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1728(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1632(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1600(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1504(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1472(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1376(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1344(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1248(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1216(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1120(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1088(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 992(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 864(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 736(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 704(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 576(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX-NEXT:    addq $1688, %rsp # imm = 0x698
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride4_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $1544, %rsp # imm = 0x608
; AVX2-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 32(%rcx), %ymm1, %ymm0
; AVX2-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 64(%rcx), %ymm2, %ymm0
; AVX2-NEXT:    vinsertf128 $1, 64(%rdx), %ymm5, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 160(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 224(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 256(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 256(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 288(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 288(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 320(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 320(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 352(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 352(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 352(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 384(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 384(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 384(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 384(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 416(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 416(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 416(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 448(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 448(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 448(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 448(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 480(%rsi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, 480(%rcx), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps 480(%rdi), %xmm1
; AVX2-NEXT:    vinsertf128 $1, 480(%rdx), %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 128(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 160(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 192(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 224(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 256(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 256(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 288(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 288(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 320(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 320(%rcx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm5[2,3],ymm4[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovaps 352(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 352(%rdx), %ymm2
; AVX2-NEXT:    vmovaps 352(%rcx), %ymm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm15[2,3],ymm4[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm0[2,3]
; AVX2-NEXT:    vmovaps 384(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 384(%rsi), %ymm3
; AVX2-NEXT:    vmovaps 384(%rdx), %ymm15
; AVX2-NEXT:    vmovaps 384(%rcx), %ymm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm15[0],ymm0[0],ymm15[2],ymm0[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm14[2,3],ymm2[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm0[2,3]
; AVX2-NEXT:    vmovaps 416(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 416(%rsi), %ymm3
; AVX2-NEXT:    vmovaps 416(%rdx), %ymm14
; AVX2-NEXT:    vmovaps 416(%rcx), %ymm15
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm13[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm13[2,3]
; AVX2-NEXT:    vmovaps 448(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 448(%rsi), %ymm13
; AVX2-NEXT:    vmovaps 448(%rdx), %ymm14
; AVX2-NEXT:    vmovaps 448(%rcx), %ymm15
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm3[0],ymm13[0],ymm3[2],ymm13[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm13[1],ymm3[3],ymm13[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm12[2,3]
; AVX2-NEXT:    vmovaps 480(%rdi), %ymm12
; AVX2-NEXT:    vmovaps 480(%rsi), %ymm13
; AVX2-NEXT:    vmovaps 480(%rdx), %ymm14
; AVX2-NEXT:    vmovaps 480(%rcx), %ymm15
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm12[0],ymm13[0],ymm12[2],ymm13[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm0[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm12[1],ymm13[1],ymm12[3],ymm13[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm12[2,3],ymm11[2,3]
; AVX2-NEXT:    vmovaps %ymm11, 2016(%r8)
; AVX2-NEXT:    vmovaps %ymm0, 1984(%r8)
; AVX2-NEXT:    vmovaps %ymm3, 1888(%r8)
; AVX2-NEXT:    vmovaps %ymm1, 1856(%r8)
; AVX2-NEXT:    vmovaps %ymm2, 1760(%r8)
; AVX2-NEXT:    vmovaps %ymm4, 1728(%r8)
; AVX2-NEXT:    vmovaps %ymm5, 1632(%r8)
; AVX2-NEXT:    vmovaps %ymm6, 1600(%r8)
; AVX2-NEXT:    vmovaps %ymm7, 1504(%r8)
; AVX2-NEXT:    vmovaps %ymm8, 1472(%r8)
; AVX2-NEXT:    vmovaps %ymm9, 1376(%r8)
; AVX2-NEXT:    vmovaps %ymm10, 1344(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1248(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1216(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1120(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1088(%r8)
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 992(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 864(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 832(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 736(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 704(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 608(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1952(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1920(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1824(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1792(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1696(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1664(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1568(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1536(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1440(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1408(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1312(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1280(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1184(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1152(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1056(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1024(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 928(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 896(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 768(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 544(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-NEXT:    addq $1544, %rsp # imm = 0x608
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride4_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $1544, %rsp # imm = 0x608
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-FP-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-FP-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm1, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%rcx), %ymm2, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%rdx), %ymm5, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 160(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 224(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 256(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 256(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 288(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 288(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 320(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 320(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 352(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 352(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 384(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 384(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 384(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 416(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 416(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 416(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 448(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 448(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 448(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 448(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%rsi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, 480(%rcx), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %xmm1
; AVX2-FP-NEXT:    vinsertf128 $1, 480(%rdx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 256(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 256(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 288(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 288(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 320(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 320(%rcx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm5[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovaps 352(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 352(%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps 352(%rcx), %ymm0
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm15[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vmovaps 384(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 384(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps 384(%rdx), %ymm15
; AVX2-FP-NEXT:    vmovaps 384(%rcx), %ymm0
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm15[0],ymm0[0],ymm15[2],ymm0[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm14[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 416(%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps 416(%rdx), %ymm14
; AVX2-FP-NEXT:    vmovaps 416(%rcx), %ymm15
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm13[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm13[2,3]
; AVX2-FP-NEXT:    vmovaps 448(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 448(%rsi), %ymm13
; AVX2-FP-NEXT:    vmovaps 448(%rdx), %ymm14
; AVX2-FP-NEXT:    vmovaps 448(%rcx), %ymm15
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm3[0],ymm13[0],ymm3[2],ymm13[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm13[1],ymm3[3],ymm13[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %ymm12
; AVX2-FP-NEXT:    vmovaps 480(%rsi), %ymm13
; AVX2-FP-NEXT:    vmovaps 480(%rdx), %ymm14
; AVX2-FP-NEXT:    vmovaps 480(%rcx), %ymm15
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm12[0],ymm13[0],ymm12[2],ymm13[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm12[1],ymm13[1],ymm12[3],ymm13[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm12[2,3],ymm11[2,3]
; AVX2-FP-NEXT:    vmovaps %ymm11, 2016(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm0, 1984(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm3, 1888(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm1, 1856(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm2, 1760(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm4, 1728(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm5, 1632(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm6, 1600(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm7, 1504(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm8, 1472(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm9, 1376(%r8)
; AVX2-FP-NEXT:    vmovaps %ymm10, 1344(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1248(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1216(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1120(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1088(%r8)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 992(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 864(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 832(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 736(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 704(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 608(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1952(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1920(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1824(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1792(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1696(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1664(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1568(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1536(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1440(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1408(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1312(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1280(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1184(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1152(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1056(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1024(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 928(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 896(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 768(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 544(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FP-NEXT:    addq $1544, %rsp # imm = 0x608
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride4_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $1544, %rsp # imm = 0x608
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rcx), %ymm1, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%rcx), %ymm2, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%rdx), %ymm5, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 160(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 160(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 224(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 224(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 256(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 256(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 288(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 288(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 320(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 320(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 352(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 352(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 384(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 384(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 384(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 416(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 416(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 416(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 448(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 448(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 448(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 448(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%rsi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, 480(%rcx), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %xmm1
; AVX2-FCP-NEXT:    vinsertf128 $1, 480(%rdx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 256(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 256(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 288(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 288(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 320(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 320(%rcx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm5[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovaps 352(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 352(%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps 352(%rcx), %ymm0
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm15[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vmovaps 384(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 384(%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 384(%rdx), %ymm15
; AVX2-FCP-NEXT:    vmovaps 384(%rcx), %ymm0
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm15[0],ymm0[0],ymm15[2],ymm0[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm14[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 416(%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 416(%rdx), %ymm14
; AVX2-FCP-NEXT:    vmovaps 416(%rcx), %ymm15
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm13[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm13[2,3]
; AVX2-FCP-NEXT:    vmovaps 448(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 448(%rsi), %ymm13
; AVX2-FCP-NEXT:    vmovaps 448(%rdx), %ymm14
; AVX2-FCP-NEXT:    vmovaps 448(%rcx), %ymm15
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm3[0],ymm13[0],ymm3[2],ymm13[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm13[1],ymm3[3],ymm13[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %ymm12
; AVX2-FCP-NEXT:    vmovaps 480(%rsi), %ymm13
; AVX2-FCP-NEXT:    vmovaps 480(%rdx), %ymm14
; AVX2-FCP-NEXT:    vmovaps 480(%rcx), %ymm15
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm14[0],ymm15[0],ymm14[2],ymm15[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm12[0],ymm13[0],ymm12[2],ymm13[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm12[1],ymm13[1],ymm12[3],ymm13[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm12[2,3],ymm11[2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm11, 2016(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1984(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 1888(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 1856(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 1760(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 1728(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 1632(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 1600(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 1504(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 1472(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 1376(%r8)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 1344(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1248(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1216(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1120(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1088(%r8)
; AVX2-FCP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 992(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 960(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 864(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 832(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 736(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 704(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1952(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1920(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1824(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1792(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1696(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1664(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1568(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1536(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1440(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1408(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1312(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1280(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1184(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1152(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1056(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1024(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 928(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 896(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 768(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 544(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r8)
; AVX2-FCP-NEXT:    addq $1544, %rsp # imm = 0x608
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride4_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512-NEXT:    movb $-52, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride4_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512-FCP-NEXT:    movb $-52, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512-FCP-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride4_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQ-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512DQ-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512DQ-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512DQ-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512DQ-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512DQ-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512DQ-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512DQ-NEXT:    movb $-52, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512DQ-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride4_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512DQ-FCP-NEXT:    movb $-52, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512DQ-FCP-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride4_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512BW-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512BW-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512BW-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512BW-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512BW-NEXT:    movb $-52, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512BW-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512BW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512BW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride4_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512BW-FCP-NEXT:    movb $-52, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512BW-FCP-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride4_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512DQ-BW-NEXT:    movb $-52, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512DQ-BW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride4_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,0,0,8,0,0,1,9]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,0,2,10,0,0,3,11]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm13, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,0,4,12,0,0,5,13]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,0,6,14,0,0,7,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm26, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm9, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm13, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm26, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm26, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm9, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm13, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm26, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm9, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm13, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm15, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm9, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm13, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm9, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm13, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm26, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm28
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm28, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm26, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,8,0,0,1,9,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [2,10,0,0,3,11,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [4,12,0,0,5,13,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm22 = [6,14,0,0,7,15,0,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm2, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm22, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm7, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm5, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm2, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm22, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm7, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm5, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm2, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm22, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512DQ-BW-FCP-NEXT:    movb $-52, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm30 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm28, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 1984(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 1920(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 1856(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 1792(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 1728(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 1664(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, 1600(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 1536(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 1472(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 1408(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, 1344(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 1280(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 1216(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, 1152(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 1088(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 1024(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, 960(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 896(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, 832(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, 768(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, 704(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, 640(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, 576(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, 512(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, 448(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm30, 320(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm0, 256(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm31, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm0, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512DQ-BW-FCP-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <64 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i64>, ptr %in.vecptr3, align 64
  %1 = shufflevector <64 x i64> %in.vec0, <64 x i64> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i64> %in.vec2, <64 x i64> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <128 x i64> %1, <128 x i64> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %interleaved.vec = shufflevector <256 x i64> %3, <256 x i64> poison, <256 x i32> <i32 0, i32 64, i32 128, i32 192, i32 1, i32 65, i32 129, i32 193, i32 2, i32 66, i32 130, i32 194, i32 3, i32 67, i32 131, i32 195, i32 4, i32 68, i32 132, i32 196, i32 5, i32 69, i32 133, i32 197, i32 6, i32 70, i32 134, i32 198, i32 7, i32 71, i32 135, i32 199, i32 8, i32 72, i32 136, i32 200, i32 9, i32 73, i32 137, i32 201, i32 10, i32 74, i32 138, i32 202, i32 11, i32 75, i32 139, i32 203, i32 12, i32 76, i32 140, i32 204, i32 13, i32 77, i32 141, i32 205, i32 14, i32 78, i32 142, i32 206, i32 15, i32 79, i32 143, i32 207, i32 16, i32 80, i32 144, i32 208, i32 17, i32 81, i32 145, i32 209, i32 18, i32 82, i32 146, i32 210, i32 19, i32 83, i32 147, i32 211, i32 20, i32 84, i32 148, i32 212, i32 21, i32 85, i32 149, i32 213, i32 22, i32 86, i32 150, i32 214, i32 23, i32 87, i32 151, i32 215, i32 24, i32 88, i32 152, i32 216, i32 25, i32 89, i32 153, i32 217, i32 26, i32 90, i32 154, i32 218, i32 27, i32 91, i32 155, i32 219, i32 28, i32 92, i32 156, i32 220, i32 29, i32 93, i32 157, i32 221, i32 30, i32 94, i32 158, i32 222, i32 31, i32 95, i32 159, i32 223, i32 32, i32 96, i32 160, i32 224, i32 33, i32 97, i32 161, i32 225, i32 34, i32 98, i32 162, i32 226, i32 35, i32 99, i32 163, i32 227, i32 36, i32 100, i32 164, i32 228, i32 37, i32 101, i32 165, i32 229, i32 38, i32 102, i32 166, i32 230, i32 39, i32 103, i32 167, i32 231, i32 40, i32 104, i32 168, i32 232, i32 41, i32 105, i32 169, i32 233, i32 42, i32 106, i32 170, i32 234, i32 43, i32 107, i32 171, i32 235, i32 44, i32 108, i32 172, i32 236, i32 45, i32 109, i32 173, i32 237, i32 46, i32 110, i32 174, i32 238, i32 47, i32 111, i32 175, i32 239, i32 48, i32 112, i32 176, i32 240, i32 49, i32 113, i32 177, i32 241, i32 50, i32 114, i32 178, i32 242, i32 51, i32 115, i32 179, i32 243, i32 52, i32 116, i32 180, i32 244, i32 53, i32 117, i32 181, i32 245, i32 54, i32 118, i32 182, i32 246, i32 55, i32 119, i32 183, i32 247, i32 56, i32 120, i32 184, i32 248, i32 57, i32 121, i32 185, i32 249, i32 58, i32 122, i32 186, i32 250, i32 59, i32 123, i32 187, i32 251, i32 60, i32 124, i32 188, i32 252, i32 61, i32 125, i32 189, i32 253, i32 62, i32 126, i32 190, i32 254, i32 63, i32 127, i32 191, i32 255>
  store <256 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
