/**
 * SPDX-FileCopyrightText: (C) 2022 Francesco Pretto <ceztko@gmail.com>
 * SPDX-License-Identifier: LGPL-2.0-or-later
 * SPDX-License-Identifier: MPL-2.0
 */

#ifndef PDF_NAMES_H
#define PDF_NAMES_H

#include <podofo/main/PdfName.h>

namespace PoDoFo
{
/**
 * A storage class for several known PdfName entries
 */
class PdfNames final
{
private:
    PdfNames() = delete;

public:
    static inline const PdfName Contents = "Contents"_n;
    static inline const PdfName Flags = "Flags"_n;
    static inline const PdfName Length = "Length"_n;
    static inline const PdfName Rect = "Rect"_n;
    static inline const PdfName Size = "Size"_n;
    static inline const PdfName Subtype = "Subtype"_n;
    static inline const PdfName Type = "Type"_n;
    static inline const PdfName Filter = "Filter"_n;
    static inline const PdfName Parent = "Parent"_n;
    static inline const PdfName Kids = "Kids"_n;
    static inline const PdfName Count = "Count"_n;
    static inline const PdfName ExtGState = "ExtGState"_n;
    static inline const PdfName ColorSpace = "ColorSpace"_n;
    static inline const PdfName Pattern = "Pattern"_n;
    static inline const PdfName Shading = "Shading"_n;
    static inline const PdfName XObject = "XObject"_n;
    static inline const PdfName Font = "Font"_n;
    static inline const PdfName Properties = "Properties"_n;
    static inline const PdfName Resources = "Resources"_n;
    static inline const PdfName AP = "AP"_n;
    static inline const PdfName AS = "AS"_n;
    static inline const PdfName Names = "Names"_n;
    static inline const PdfName Limits = "Limits"_n;
    static inline const PdfName Matrix = "Matrix"_n;
    static inline const PdfName BBox = "BBox"_n;
    static inline const PdfName Encrypt = "Encrypt"_n;
    static inline const PdfName Info = "Info"_n;
    static inline const PdfName Root = "Root"_n;
    static inline const PdfName ID = "ID"_n;
    static inline const PdfName Catalog = "Catalog"_n;
    static inline const PdfName C = "C"_n;
    static inline const PdfName N = "N"_n;
    static inline const PdfName R = "R"_n;
    static inline const PdfName D = "D"_n;
    static inline const PdfName Yes = "Yes"_n;
    static inline const PdfName Off = "Off"_n;
    static inline const PdfName V = "V"_n;
    static inline const PdfName T = "T"_n;
    static inline const PdfName F = "F"_n;
    static inline const PdfName FT = "FT"_n;
    static inline const PdfName Ff = "Ff"_n;
    static inline const PdfName A = "A"_n;
    static inline const PdfName AA = "AA"_n;
    static inline const PdfName TU = "TU"_n;
    static inline const PdfName TM = "TM"_n;
    static inline const PdfName H = "H"_n;
    static inline const PdfName P = "P"_n;
    static inline const PdfName CA = "CA"_n;
    static inline const PdfName ca = "ca"_n;
    static inline const PdfName S = "S"_n;
    static inline const PdfName CFM = "CFM"_n;
    static inline const PdfName CF = "CF"_n;
    static inline const PdfName OE = "OE"_n;
    static inline const PdfName UE = "UE"_n;
    static inline const PdfName StrF = "StrF"_n;
    static inline const PdfName StmF = "StmF"_n;
    static inline const PdfName StdCF = "StdCF"_n;
    static inline const PdfName Perms = "Perms"_n;
    static inline const PdfName AuthEvent = "AuthEvent"_n;
    static inline const PdfName EncryptMetadata = "EncryptMetadata"_n;
    static inline const PdfName Fields = "Fields"_n;
    static inline const PdfName Action = "Action"_n;
    static inline const PdfName Annot = "Annot"_n;
    static inline const PdfName Annots = "Annots"_n;
    static inline const PdfName Metadata = "Metadata"_n;
    static inline const PdfName PageMode = "PageMode"_n;
    static inline const PdfName PageLayout = "PageLayout"_n;
    static inline const PdfName URI = "URI"_n;
    static inline const PdfName JS = "JS"_n;
    static inline const PdfName Border = "Border"_n;
    static inline const PdfName Page = "Page"_n;
    static inline const PdfName Pages = "Pages"_n;
    static inline const PdfName Outlines = "Outlines"_n;
    static inline const PdfName MediaBox = "MediaBox"_n;
    static inline const PdfName CropBox = "CropBox"_n;
    static inline const PdfName TrimBox = "TrimBox"_n;
    static inline const PdfName BleedBox = "BleedBox"_n;
    static inline const PdfName ArtBox = "ArtBox"_n;
    static inline const PdfName Rotate = "Rotate"_n;
    static inline const PdfName Alternate = "Alternate"_n;
    static inline const PdfName Title = "Title"_n;
    static inline const PdfName Lang = "Lang"_n;
    static inline const PdfName Base = "Base"_n;
    static inline const PdfName ViewerPreferences = "ViewerPreferences"_n;
    static inline const PdfName AcroForm = "AcroForm"_n;
    static inline const PdfName Filespec = "Filespec"_n;
    static inline const PdfName Prev = "Prev"_n;
    static inline const PdfName Next = "Next"_n;
    static inline const PdfName CreationDate = "CreationDate"_n;
    static inline const PdfName ModDate = "ModDate"_n;
    static inline const PdfName Author = "Author"_n;
    static inline const PdfName Creator = "Creator"_n;
    static inline const PdfName Subject = "Subject"_n;
    static inline const PdfName Producer = "Producer"_n;
    static inline const PdfName Keywords = "Keywords"_n;
    static inline const PdfName Trapped = "Trapped"_n;
    static inline const PdfName Location = "Location"_n;
    static inline const PdfName FormType = "FormType"_n;
    static inline const PdfName EmbeddedFile = "EmbeddedFile"_n;
    static inline const PdfName BaseFont = "BaseFont"_n;
    static inline const PdfName DescendantFonts = "DescendantFonts"_n;
    static inline const PdfName FontDescriptor = "FontDescriptor"_n;
    static inline const PdfName W = "W"_n;
    static inline const PdfName DW = "DW"_n;
    static inline const PdfName Identity = "Identity"_n;
    static inline const PdfName Type0 = "Type0"_n;
    static inline const PdfName Type1 = "Type1"_n;
    static inline const PdfName Type3 = "Type3"_n;
    static inline const PdfName TrueType = "TrueType"_n;
    static inline const PdfName FontFile = "FontFile"_n;
    static inline const PdfName FontFile2 = "FontFile2"_n;
    static inline const PdfName FontFile3 = "FontFile3"_n;
    static inline const PdfName Length1 = "Length1"_n;
    static inline const PdfName Length2 = "Length2"_n;
    static inline const PdfName Length3 = "Length3"_n;
    static inline const PdfName XRef = "XRef"_n;
    static inline const PdfName Sig = "Sig"_n;
    static inline const PdfName SigRef = "SigRef"_n;
    static inline const PdfName TransformParams = "TransformParams"_n;
    static inline const PdfName WinAnsiEncoding = "WinAnsiEncoding"_n;
    static inline const PdfName MacRomanEncoding = "MacRomanEncoding"_n;
    static inline const PdfName MacExpertEncoding = "MacExpertEncoding"_n;
    static inline const PdfName E = "E"_n;
    static inline const PdfName X = "X"_n;
    static inline const PdfName U = "U"_n;
    static inline const PdfName Fo = "Fo"_n;
    static inline const PdfName BI = "BI"_n;
    static inline const PdfName PO = "PO"_n;
    static inline const PdfName PC = "PC"_n;
    static inline const PdfName PV = "PV"_n;
    static inline const PdfName PI = "PI"_n;
    static inline const PdfName K = "K"_n;
    static inline const PdfName I = "I"_n;
    static inline const PdfName O = "O"_n;
    static inline const PdfName Dests = "Dests"_n;
    static inline const PdfName JavaScript = "JavaScript"_n;
    static inline const PdfName Templates = "Templates"_n;
    static inline const PdfName IDS = "IDS"_n;
    static inline const PdfName URLS = "URLS"_n;
    static inline const PdfName EmbeddedFiles = "EmbeddedFiles"_n;
    static inline const PdfName AlternatePresentations = "AlternatePresentations"_n;
    static inline const PdfName Renditions = "Renditions"_n;
    static inline const PdfName MK = "MK"_n;
    static inline const PdfName FS = "FS"_n;
    static inline const PdfName CIDToGIDMap = "CIDToGIDMap"_n;
    static inline const PdfName CIDSystemInfo = "CIDSystemInfo"_n;
    static inline const PdfName Encoding = "Encoding"_n;
    static inline const PdfName ToUnicode = "ToUnicode"_n;
    static inline const PdfName CIDSet = "CIDSet"_n;
    static inline const PdfName Widths = "Widths"_n;
    static inline const PdfName FontName = "FontName"_n;
    static inline const PdfName FontFamily = "FontFamily"_n;
    static inline const PdfName FontStretch = "FontStretch"_n;
    static inline const PdfName ItalicAngle = "ItalicAngle"_n;
    static inline const PdfName FontWeight = "FontWeight"_n;
    static inline const PdfName FontBBox = "FontBBox"_n;
    static inline const PdfName Ascent = "Ascent"_n;
    static inline const PdfName Descent = "Descent"_n;
    static inline const PdfName CapHeight = "CapHeight"_n;
    static inline const PdfName StemV = "StemV"_n;
    static inline const PdfName StemH = "StemH"_n;
    static inline const PdfName XHeight = "XHeight"_n;
    static inline const PdfName MissingWidth = "MissingWidth"_n;
    static inline const PdfName Leading = "Leading"_n;
    static inline const PdfName AvgWidth = "AvgWidth"_n;
    static inline const PdfName MaxWidth = "MaxWidth"_n;
    static inline const PdfName DecodeParms = "DecodeParms"_n;
    static inline const PdfName SMask = "SMask"_n;
    static inline const PdfName ICCBased = "ICCBased"_n;
    static inline const PdfName Indexed = "Indexed"_n;
    static inline const PdfName Separation = "Separation"_n;
    static inline const PdfName DeviceCMYK = "DeviceCMYK"_n;
    static inline const PdfName DeviceRGB = "DeviceRGB"_n;
    static inline const PdfName DeviceGray = "DeviceGray"_n;
    static inline const PdfName FlateDecode = "FlateDecode"_n;
    static inline const PdfName Lab = "Lab"_n;
    static inline const PdfName CMap = "CMap"_n;
    static inline const PdfName Identity_H = "Identity-H"_n;
    static inline const PdfName Identity_V = "Identity-V"_n;
    static inline const PdfName NeedAppearances = "NeedAppearances"_n;
    static inline const PdfName DA = "DA"_n;
    static inline const PdfName DR = "DR"_n;
    static inline const PdfName DS = "DS"_n;
    static inline const PdfName AC = "AC"_n;
    static inline const PdfName BC = "BC"_n;
    static inline const PdfName BG = "BG"_n;
    static inline const PdfName RC = "RC"_n;
    static inline const PdfName RG = "RG"_n;
    static inline const PdfName RV = "RV"_n;
    static inline const PdfName Open = "Open"_n;
    static inline const PdfName QuadPoints = "QuadPoints"_n;
    static inline const PdfName Index = "Index"_n;
    static inline const PdfName MaxLen = "MaxLen"_n;
    static inline const PdfName DocMDP = "DocMDP"_n;
    static inline const PdfName TransformMethod = "TransformMethod"_n;
    static inline const PdfName Reference = "Reference"_n;
    static inline const PdfName ByteRange = "ByteRange"_n;
    static inline const PdfName SubFilter = "SubFilter"_n;
    static inline const PdfName SigFlags = "SigFlags"_n;
    static inline const PdfName Name = "Name"_n;
    static inline const PdfName Reason = "Reason"_n;
    static inline const PdfName M = "M"_n;
    static inline const PdfName Prop_Build = "Prop_Build"_n;
    static inline const PdfName App = "App"_n;
    static inline const PdfName ProcSet = "ProcSet"_n;
    static inline const PdfName Dest = "Dest"_n;
    static inline const PdfName Opt = "Opt"_n;
    static inline const PdfName BaseEncoding = "BaseEncoding"_n;
    static inline const PdfName Differences = "Differences"_n;
    static inline const PdfName Registry = "Registry"_n;
    static inline const PdfName Ordering = "Ordering"_n;
    static inline const PdfName Supplement = "Supplement"_n;
    static inline const PdfName CMapName = "CMapName"_n;
    static inline const PdfName UF = "UF"_n;
    static inline const PdfName Params = "Params"_n;
    static inline const PdfName EF = "EF"_n;
    static inline const PdfName Version = "Version"_n;
    static inline const PdfName BaseVersion = "BaseVersion"_n;
    static inline const PdfName ExtensionLevel = "ExtensionLevel"_n;
    static inline const PdfName Extensions = "Extensions"_n;
    static inline const PdfName FontMatrix = "FontMatrix"_n;
    static inline const PdfName FirstChar = "FirstChar"_n;
    static inline const PdfName LastChar = "LastChar"_n;
    static inline const PdfName BitsPerSample = "BitsPerSample"_n;
    static inline const PdfName Decode = "Decode"_n;
    static inline const PdfName Domain = "Domain"_n;
    static inline const PdfName Encode = "Encode"_n;
    static inline const PdfName FunctionType = "FunctionType"_n;
    static inline const PdfName Range = "Range"_n;
    static inline const PdfName WhitePoint = "WhitePoint"_n;
    static inline const PdfName BlackPoint = "BlackPoint"_n;
    static inline const PdfName First = "First"_n;
    static inline const PdfName Last = "Last"_n;
    static inline const PdfName Width = "Width"_n;
    static inline const PdfName Height = "Height"_n;
    static inline const PdfName BitsPerComponent = "BitsPerComponent"_n;
    static inline const PdfName Mask = "Mask"_n;
    static inline const PdfName Interpolate = "Interpolate"_n;
    static inline const PdfName BM = "BM"_n;
    static inline const PdfName OP = "OP"_n;
    static inline const PdfName op = "op"_n;
    static inline const PdfName OPM = "OPM"_n;
    static inline const PdfName RI = "RI"_n;
    static inline const PdfName HalftoneType = "HalftoneType"_n;
    static inline const PdfName Frequency = "Frequency"_n;
    static inline const PdfName Angle = "Angle"_n;
    static inline const PdfName SpotFunction = "SpotFunction"_n;
    static inline const PdfName HT = "HT"_n;
};

}

#endif // PDF_NAMES_H
