#! /usr/bin/env python

'''
Python Interface to SAGA Tools Library
----------
- Category : SCIMAP Toolkit 1.1
- Name     : SCIMAP Toolkit 1.1
- ID       : ta_scimap

Description
----------
SCIMAP Risk Maps for diffuse pollution.
'''

from PySAGA.helper import Tool_Wrapper

def SCIMAPFine_Sediment(
    DEM=None,
    ERODE=None,
    RAINFALL=None,
    SLOPE=None,
    CAREA=None,
    CHANNELS=None,
    EROSRISK=None,
    WETNESS=None,
    EROSRISKFACC=None,
    EROSRISKFACC_TOP=None,
    CHANNELSRISK=None,
    CHANNELSRISKCONCN=None,
    CRITAREA=None,
    PREPROCESS=None,
    FLOWDIRMETHOD=None,
    CONVERGENCE=None,
    WETNESSINDEXMETHOD=None,
    CONNINDEX=None,
    STREAMPOWERMETHOD=None, Verbose=2):
    '''
    SCIMAP-Fine Sediment
    ----------
    [ta_scimap.0]\n
    SCIMAP Risk Maps Generation. SCIMAP considers the spatial pattern of connectivity and source risks to create risk maps of the diffuse pollution. SCIMAP works in relative terms across the landscape to identify the most probable sources of the observed problem.\n
    Arguments
    ----------
    - DEM [`input grid`] : Digital Elevation Model
    - ERODE [`input grid`] : Erodibility
    - RAINFALL [`input grid`] : Rainfall Pattern
    - SLOPE [`output grid`] : Slope
    - CAREA [`output grid`] : Catchment Area
    - CHANNELS [`output grid`] : River Channels
    - EROSRISK [`output grid`] : Erosion Risk. This grid is the potential for material to be exported and connected to the river channels. It is the physical mobilisation risk mutipled by the connectivity
    - WETNESS [`output grid`] : Hydrological Connectivity. This grid is relative strength of the connection between each point in the landscape and the river or lake that it drains to. Scaled between zero and one.
    - EROSRISKFACC [`output grid`] : Accumulated Erosion Risk
    - EROSRISKFACC_TOP [`output grid`] : Top 10 Erosion Risk
    - CHANNELSRISK [`output grid`] : Erosion Risk in Channels
    - CHANNELSRISKCONCN [`output grid`] : Erosion Risk in Channels Concn.
    - CRITAREA [`floating point number`] : Critical Area for Channels (m2). Minimum: 80000.000000 Default: 5.000000
    - PREPROCESS [`choice`] : DEM Pre-Processing. Available Choices: [0] Deepen Drainage Routes [1] Fill Sinks [2] Fill Sinks XXL (Wang & Liu) [3] Fill Sinks (Planchon/Darboux, 2001) [4] none Default: 2
    - FLOWDIRMETHOD [`choice`] : Flow Direction Method. Available Choices: [0] Deterministic 8 [1] Rho 8 [2] Braunschweiger Reliefmodell [3] Deterministic Infinity [4] Multiple Flow Direction [5] Multiple Triangular Flow Directon [6] Multiple Maximum Downslope Gradient Based Flow Directon Default: 4
    - CONVERGENCE [`floating point number`] : Convergence. Minimum: 0.000000 Default: 1.100000 Convergence factor for Multiple Flow Direction Algorithm (Freeman 1991)
    - WETNESSINDEXMETHOD [`choice`] : Wetness Index Method. Available Choices: [0] Classic TWI (Kirkby 1976) [1] SAGA Wetness Index Default: 0
    - CONNINDEX [`choice`] : Connectivity Index. Available Choices: [0] Network Index of Connectivity [1] Percentage Downslope Saturated Length Default: 0
    - STREAMPOWERMETHOD [`choice`] : Stream Power. Available Choices: [0] Stream Power [tan(slope) * area] [1] Simplified Stream power [tan(slope) * (area / cellsize)^0.5] [2] Stream Power Specifc Catchment Area [tan(slope) * (area / cellsize)] [3] do not use Default: 1 Decide how to include stream power as part of erosivity

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('ta_scimap', '0', 'SCIMAP-Fine Sediment')
    if Tool.is_Okay():
        Tool.Set_Input ('DEM', DEM)
        Tool.Set_Input ('ERODE', ERODE)
        Tool.Set_Input ('RAINFALL', RAINFALL)
        Tool.Set_Output('SLOPE', SLOPE)
        Tool.Set_Output('CAREA', CAREA)
        Tool.Set_Output('CHANNELS', CHANNELS)
        Tool.Set_Output('EROSRISK', EROSRISK)
        Tool.Set_Output('WETNESS', WETNESS)
        Tool.Set_Output('EROSRISKFACC', EROSRISKFACC)
        Tool.Set_Output('EROSRISKFACC_TOP', EROSRISKFACC_TOP)
        Tool.Set_Output('CHANNELSRISK', CHANNELSRISK)
        Tool.Set_Output('CHANNELSRISKCONCN', CHANNELSRISKCONCN)
        Tool.Set_Option('CRITAREA', CRITAREA)
        Tool.Set_Option('PREPROCESS', PREPROCESS)
        Tool.Set_Option('FLOWDIRMETHOD', FLOWDIRMETHOD)
        Tool.Set_Option('CONVERGENCE', CONVERGENCE)
        Tool.Set_Option('WETNESSINDEXMETHOD', WETNESSINDEXMETHOD)
        Tool.Set_Option('CONNINDEX', CONNINDEX)
        Tool.Set_Option('STREAMPOWERMETHOD', STREAMPOWERMETHOD)
        return Tool.Execute(Verbose)
    return False

def run_tool_ta_scimap_0(
    DEM=None,
    ERODE=None,
    RAINFALL=None,
    SLOPE=None,
    CAREA=None,
    CHANNELS=None,
    EROSRISK=None,
    WETNESS=None,
    EROSRISKFACC=None,
    EROSRISKFACC_TOP=None,
    CHANNELSRISK=None,
    CHANNELSRISKCONCN=None,
    CRITAREA=None,
    PREPROCESS=None,
    FLOWDIRMETHOD=None,
    CONVERGENCE=None,
    WETNESSINDEXMETHOD=None,
    CONNINDEX=None,
    STREAMPOWERMETHOD=None, Verbose=2):
    '''
    SCIMAP-Fine Sediment
    ----------
    [ta_scimap.0]\n
    SCIMAP Risk Maps Generation. SCIMAP considers the spatial pattern of connectivity and source risks to create risk maps of the diffuse pollution. SCIMAP works in relative terms across the landscape to identify the most probable sources of the observed problem.\n
    Arguments
    ----------
    - DEM [`input grid`] : Digital Elevation Model
    - ERODE [`input grid`] : Erodibility
    - RAINFALL [`input grid`] : Rainfall Pattern
    - SLOPE [`output grid`] : Slope
    - CAREA [`output grid`] : Catchment Area
    - CHANNELS [`output grid`] : River Channels
    - EROSRISK [`output grid`] : Erosion Risk. This grid is the potential for material to be exported and connected to the river channels. It is the physical mobilisation risk mutipled by the connectivity
    - WETNESS [`output grid`] : Hydrological Connectivity. This grid is relative strength of the connection between each point in the landscape and the river or lake that it drains to. Scaled between zero and one.
    - EROSRISKFACC [`output grid`] : Accumulated Erosion Risk
    - EROSRISKFACC_TOP [`output grid`] : Top 10 Erosion Risk
    - CHANNELSRISK [`output grid`] : Erosion Risk in Channels
    - CHANNELSRISKCONCN [`output grid`] : Erosion Risk in Channels Concn.
    - CRITAREA [`floating point number`] : Critical Area for Channels (m2). Minimum: 80000.000000 Default: 5.000000
    - PREPROCESS [`choice`] : DEM Pre-Processing. Available Choices: [0] Deepen Drainage Routes [1] Fill Sinks [2] Fill Sinks XXL (Wang & Liu) [3] Fill Sinks (Planchon/Darboux, 2001) [4] none Default: 2
    - FLOWDIRMETHOD [`choice`] : Flow Direction Method. Available Choices: [0] Deterministic 8 [1] Rho 8 [2] Braunschweiger Reliefmodell [3] Deterministic Infinity [4] Multiple Flow Direction [5] Multiple Triangular Flow Directon [6] Multiple Maximum Downslope Gradient Based Flow Directon Default: 4
    - CONVERGENCE [`floating point number`] : Convergence. Minimum: 0.000000 Default: 1.100000 Convergence factor for Multiple Flow Direction Algorithm (Freeman 1991)
    - WETNESSINDEXMETHOD [`choice`] : Wetness Index Method. Available Choices: [0] Classic TWI (Kirkby 1976) [1] SAGA Wetness Index Default: 0
    - CONNINDEX [`choice`] : Connectivity Index. Available Choices: [0] Network Index of Connectivity [1] Percentage Downslope Saturated Length Default: 0
    - STREAMPOWERMETHOD [`choice`] : Stream Power. Available Choices: [0] Stream Power [tan(slope) * area] [1] Simplified Stream power [tan(slope) * (area / cellsize)^0.5] [2] Stream Power Specifc Catchment Area [tan(slope) * (area / cellsize)] [3] do not use Default: 1 Decide how to include stream power as part of erosivity

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('ta_scimap', '0', 'SCIMAP-Fine Sediment')
    if Tool.is_Okay():
        Tool.Set_Input ('DEM', DEM)
        Tool.Set_Input ('ERODE', ERODE)
        Tool.Set_Input ('RAINFALL', RAINFALL)
        Tool.Set_Output('SLOPE', SLOPE)
        Tool.Set_Output('CAREA', CAREA)
        Tool.Set_Output('CHANNELS', CHANNELS)
        Tool.Set_Output('EROSRISK', EROSRISK)
        Tool.Set_Output('WETNESS', WETNESS)
        Tool.Set_Output('EROSRISKFACC', EROSRISKFACC)
        Tool.Set_Output('EROSRISKFACC_TOP', EROSRISKFACC_TOP)
        Tool.Set_Output('CHANNELSRISK', CHANNELSRISK)
        Tool.Set_Output('CHANNELSRISKCONCN', CHANNELSRISKCONCN)
        Tool.Set_Option('CRITAREA', CRITAREA)
        Tool.Set_Option('PREPROCESS', PREPROCESS)
        Tool.Set_Option('FLOWDIRMETHOD', FLOWDIRMETHOD)
        Tool.Set_Option('CONVERGENCE', CONVERGENCE)
        Tool.Set_Option('WETNESSINDEXMETHOD', WETNESSINDEXMETHOD)
        Tool.Set_Option('CONNINDEX', CONNINDEX)
        Tool.Set_Option('STREAMPOWERMETHOD', STREAMPOWERMETHOD)
        return Tool.Execute(Verbose)
    return False

def Hydrological_Connectivity_Indices_Collection_HCIC(
    DEM=None,
    RAINFALL=None,
    SLOPE=None,
    CAREA=None,
    WETNESS=None,
    CRITAREA=None,
    PREPROCESS=None,
    FLOWDIRMETHOD=None,
    CONVERGENCE=None,
    WETNESSINDEXMETHOD=None,
    CONNINDEX=None,
    RESCALE_WET=None, Verbose=2):
    '''
    Hydrological Connectivity Indices Collection (HCIC)
    ----------
    [ta_scimap.1]\n
    This is a collection of different hydrological conenctivity indicies which repersent how different parts of the landscape connect to the rivers or lakes.\n
    (-) Network Index (see Lane et al. 2004, 2009)(-) Percentage Downslope Saturated Length, see XXX\n
    Arguments
    ----------
    - DEM [`input grid`] : Digital Elevation Model
    - RAINFALL [`optional input grid`] : Rainfall Pattern
    - SLOPE [`output grid`] : Slope
    - CAREA [`output grid`] : Catchment Area
    - WETNESS [`output grid`] : Connectivity
    - CRITAREA [`floating point number`] : Critical Area for Channels (m2). Minimum: 80000.000000 Default: 5.000000
    - PREPROCESS [`choice`] : DEM Pre-Processing. Available Choices: [0] Deepen Drainage Routes [1] Fill Sinks [2] Fill Sinks XXL (Wang & Liu) [3] Fill Sinks (Planchon/Darboux, 2001) [4] none Default: 2
    - FLOWDIRMETHOD [`choice`] : Flow Direction Method. Available Choices: [0] Deterministic 8 [1] Rho 8 [2] Braunschweiger Reliefmodell [3] Deterministic Infinity [4] Multiple Flow Direction [5] Multiple Triangular Flow Directon [6] Multiple Maximum Downslope Gradient Based Flow Directon Default: 4
    - CONVERGENCE [`floating point number`] : Convergence. Minimum: 0.000000 Default: 1.100000 Convergence factor for Multiple Flow Direction Algorithm (Freeman 1991)
    - WETNESSINDEXMETHOD [`choice`] : Wetness Index Method. Available Choices: [0] Classic TWI (Kirkby 1976) [1] SAGA Wetness Index Default: 0
    - CONNINDEX [`choice`] : Connectivity Index. Available Choices: [0] Network Index of Connectivity [1] Percentage Downslope Saturated Length Default: 0
    - RESCALE_WET [`boolean`] : Rescale wetness index?. Default: 1 Rescale wetness index?

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('ta_scimap', '1', 'Hydrological Connectivity Indices Collection (HCIC)')
    if Tool.is_Okay():
        Tool.Set_Input ('DEM', DEM)
        Tool.Set_Input ('RAINFALL', RAINFALL)
        Tool.Set_Output('SLOPE', SLOPE)
        Tool.Set_Output('CAREA', CAREA)
        Tool.Set_Output('WETNESS', WETNESS)
        Tool.Set_Option('CRITAREA', CRITAREA)
        Tool.Set_Option('PREPROCESS', PREPROCESS)
        Tool.Set_Option('FLOWDIRMETHOD', FLOWDIRMETHOD)
        Tool.Set_Option('CONVERGENCE', CONVERGENCE)
        Tool.Set_Option('WETNESSINDEXMETHOD', WETNESSINDEXMETHOD)
        Tool.Set_Option('CONNINDEX', CONNINDEX)
        Tool.Set_Option('RESCALE_WET', RESCALE_WET)
        return Tool.Execute(Verbose)
    return False

def run_tool_ta_scimap_1(
    DEM=None,
    RAINFALL=None,
    SLOPE=None,
    CAREA=None,
    WETNESS=None,
    CRITAREA=None,
    PREPROCESS=None,
    FLOWDIRMETHOD=None,
    CONVERGENCE=None,
    WETNESSINDEXMETHOD=None,
    CONNINDEX=None,
    RESCALE_WET=None, Verbose=2):
    '''
    Hydrological Connectivity Indices Collection (HCIC)
    ----------
    [ta_scimap.1]\n
    This is a collection of different hydrological conenctivity indicies which repersent how different parts of the landscape connect to the rivers or lakes.\n
    (-) Network Index (see Lane et al. 2004, 2009)(-) Percentage Downslope Saturated Length, see XXX\n
    Arguments
    ----------
    - DEM [`input grid`] : Digital Elevation Model
    - RAINFALL [`optional input grid`] : Rainfall Pattern
    - SLOPE [`output grid`] : Slope
    - CAREA [`output grid`] : Catchment Area
    - WETNESS [`output grid`] : Connectivity
    - CRITAREA [`floating point number`] : Critical Area for Channels (m2). Minimum: 80000.000000 Default: 5.000000
    - PREPROCESS [`choice`] : DEM Pre-Processing. Available Choices: [0] Deepen Drainage Routes [1] Fill Sinks [2] Fill Sinks XXL (Wang & Liu) [3] Fill Sinks (Planchon/Darboux, 2001) [4] none Default: 2
    - FLOWDIRMETHOD [`choice`] : Flow Direction Method. Available Choices: [0] Deterministic 8 [1] Rho 8 [2] Braunschweiger Reliefmodell [3] Deterministic Infinity [4] Multiple Flow Direction [5] Multiple Triangular Flow Directon [6] Multiple Maximum Downslope Gradient Based Flow Directon Default: 4
    - CONVERGENCE [`floating point number`] : Convergence. Minimum: 0.000000 Default: 1.100000 Convergence factor for Multiple Flow Direction Algorithm (Freeman 1991)
    - WETNESSINDEXMETHOD [`choice`] : Wetness Index Method. Available Choices: [0] Classic TWI (Kirkby 1976) [1] SAGA Wetness Index Default: 0
    - CONNINDEX [`choice`] : Connectivity Index. Available Choices: [0] Network Index of Connectivity [1] Percentage Downslope Saturated Length Default: 0
    - RESCALE_WET [`boolean`] : Rescale wetness index?. Default: 1 Rescale wetness index?

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('ta_scimap', '1', 'Hydrological Connectivity Indices Collection (HCIC)')
    if Tool.is_Okay():
        Tool.Set_Input ('DEM', DEM)
        Tool.Set_Input ('RAINFALL', RAINFALL)
        Tool.Set_Output('SLOPE', SLOPE)
        Tool.Set_Output('CAREA', CAREA)
        Tool.Set_Output('WETNESS', WETNESS)
        Tool.Set_Option('CRITAREA', CRITAREA)
        Tool.Set_Option('PREPROCESS', PREPROCESS)
        Tool.Set_Option('FLOWDIRMETHOD', FLOWDIRMETHOD)
        Tool.Set_Option('CONVERGENCE', CONVERGENCE)
        Tool.Set_Option('WETNESSINDEXMETHOD', WETNESSINDEXMETHOD)
        Tool.Set_Option('CONNINDEX', CONNINDEX)
        Tool.Set_Option('RESCALE_WET', RESCALE_WET)
        return Tool.Execute(Verbose)
    return False

