// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gskmm/transform.h>
#include <gskmm/private/transform_p.h>


/* Copyright (C) 2025 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

using Category = Gsk::Transform::Category;

namespace Gsk
{
// static
Glib::RefPtr<Transform> Transform::create(const Glib::ustring& string)
{
  GskTransform* out_transform = nullptr;
  (void)gsk_transform_parse(string.c_str(), &out_transform);
  return Glib::wrap(out_transform);
}

Glib::RefPtr<Transform> Transform::transform(const Glib::RefPtr<const Transform>& other) const
{
  reference(); // gsk_transform_transform() consumes a reference.
  return Glib::wrap(gsk_transform_transform(const_cast<GskTransform*>(gobj()), const_cast<GskTransform*>(Glib::unwrap(other))));
}
Glib::RefPtr<Transform> Transform::invert() const
{
  reference(); // gsk_transform_invert() consumes a reference.
  return Glib::wrap(gsk_transform_invert(const_cast<GskTransform*>(gobj())));
}

Glib::RefPtr<Transform> Transform::translate(const Gdk::Graphene::Point& point) const
{
  reference(); // gsk_transform_translate() consumes a reference.
  return Glib::wrap(gsk_transform_translate(const_cast<GskTransform*>(gobj()), (point).gobj()));
}

Glib::RefPtr<Transform> Transform::skew(float skew_x, float skew_y) const
{
  reference(); // gsk_transform_skew() consumes a reference.
  return Glib::wrap(gsk_transform_skew(const_cast<GskTransform*>(gobj()), skew_x, skew_y));
}

Glib::RefPtr<Transform> Transform::rotate(float angle) const
{
  reference(); // gsk_transform_rotate() consumes a reference.
  return Glib::wrap(gsk_transform_rotate(const_cast<GskTransform*>(gobj()), angle));
}

Glib::RefPtr<Transform> Transform::scale(float factor_x, float factor_y) const
{
  reference(); // gsk_transform_scale() consumes a reference.
  return Glib::wrap(gsk_transform_scale(const_cast<GskTransform*>(gobj()), factor_x, factor_y));
}

Glib::RefPtr<Transform> Transform::scale_3d(float factor_x, float factor_y, float factor_z) const
{
  reference(); // gsk_transform_scale_3d() consumes a reference.
  return Glib::wrap(gsk_transform_scale_3d(const_cast<GskTransform*>(gobj()), factor_x, factor_y, factor_z));
}

Glib::RefPtr<Transform> Transform::perspective(float depth) const
{
  reference(); // gsk_transform_perspective() consumes a reference.
  return Glib::wrap(gsk_transform_perspective(const_cast<GskTransform*>(gobj()), depth));
}

Gdk::Graphene::Rect Transform::transform_bounds(const Gdk::Graphene::Rect& rect) const
{
  graphene_rect_t* g_out_rect = graphene_rect_alloc();
  gsk_transform_transform_bounds(const_cast<GskTransform*>(gobj()), (rect).gobj(), g_out_rect);
  return Glib::wrap(g_out_rect);
}

Gdk::Graphene::Point Transform::transform_point(const Gdk::Graphene::Point& point) const
{
  graphene_point_t* g_out_point = graphene_point_alloc();
  gsk_transform_transform_point(const_cast<GskTransform*>(gobj()), (point).gobj(), g_out_point);
  return Glib::wrap(g_out_point);
}
} // namespace Gsk

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gsk::Transform::Category>::value_type()
{
  return gsk_transform_category_get_type();
}


/* Why reinterpret_cast<Transform*>(gobject) is needed:
 *
 * A Transform instance is in fact always a GskTransform instance.
 * Unfortunately, GskTransform cannot be a member of Transform,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Transform does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gsk::Transform> wrap(GskTransform* object, bool take_copy)
{
  if(take_copy && object)
    gsk_transform_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Gsk::Transform>(reinterpret_cast<Gsk::Transform*>(object));
}

} // namespace Glib


namespace Gsk
{

// static
GType Transform::get_type()
{
  return gsk_transform_get_type();
}

// static
Glib::RefPtr<Transform> Transform::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Transform>(reinterpret_cast<Transform*>(gsk_transform_new()));
}

void Transform::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gsk_transform_ref(reinterpret_cast<GskTransform*>(const_cast<Transform*>(this)));
}

void Transform::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gsk_transform_unref(reinterpret_cast<GskTransform*>(const_cast<Transform*>(this)));
}

GskTransform* Transform::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GskTransform*>(this);
}

const GskTransform* Transform::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GskTransform*>(this);
}

GskTransform* Transform::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GskTransform*>(const_cast<Transform*>(this));
  gsk_transform_ref(gobject);
  return gobject;
}


Glib::ustring Transform::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gsk_transform_to_string(const_cast<GskTransform*>(gobj())));
}

void Transform::to_2d(float& out_xx, float& out_yx, float& out_xy, float& out_yy, float& out_dx, float& out_dy) const
{
  gsk_transform_to_2d(const_cast<GskTransform*>(gobj()), &(out_xx), &(out_yx), &(out_xy), &(out_yy), &(out_dx), &(out_dy));
}

void Transform::to_2d_components(float& out_skew_x, float& out_skew_y, float& out_scale_x, float& out_scale_y, float& out_angle, float& out_dx, float& out_dy) const
{
  gsk_transform_to_2d_components(const_cast<GskTransform*>(gobj()), &(out_skew_x), &(out_skew_y), &(out_scale_x), &(out_scale_y), &(out_angle), &(out_dx), &(out_dy));
}

void Transform::to_affine(float& out_scale_x, float& out_scale_y, float& out_dx, float& out_dy) const
{
  gsk_transform_to_affine(const_cast<GskTransform*>(gobj()), &(out_scale_x), &(out_scale_y), &(out_dx), &(out_dy));
}

void Transform::to_translate(float& out_dx, float& out_dy) const
{
  gsk_transform_to_translate(const_cast<GskTransform*>(gobj()), &(out_dx), &(out_dy));
}

Category Transform::get_category() const
{
  return static_cast<Category>(gsk_transform_get_category(const_cast<GskTransform*>(gobj())));
}

bool Transform::equal(const Glib::RefPtr<const Transform>& second) const
{
  return gsk_transform_equal(const_cast<GskTransform*>(gobj()), const_cast<GskTransform*>(Glib::unwrap(second)));
}


} // namespace Gsk


