; APX testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro


bits 64

; aadd instruction
testcase	{0x0F, 0x38, 0xFC, 0x0A},		{aadd [rdx],ecx}		;m32 <- r32 regular
testcase	{0x48, 0x0F, 0x38, 0xFC, 0x0A},		{aadd [rdx],rcx}		;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7C, 0x08, 0xFC, 0x0A},	{aadd {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFC, 0x08, 0xFC, 0x0A},	{aadd {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFC, 0x08, 0xFC, 0x0A},	{aadd [rdx],r25}		;m64 <- er64

; aand instruction
testcase	{0x66, 0x0F, 0x38, 0xFC, 0x0A},		{aand [rdx],ecx}		;m32 <- r32 regular
testcase	{0x66, 0x48, 0x0F, 0x38, 0xFC, 0x0A},	{aand [rdx],rcx}		;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7D, 0x08, 0xFC, 0x0A},	{aand {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFD, 0x08, 0xFC, 0x0A},	{aand {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFD, 0x08, 0xFC, 0x0A},	{aand [rdx],r25}		;m64 <- er64

; aor instruction
testcase	{0xF2, 0x0F, 0x38, 0xFC, 0x0A},		{aor [rdx],ecx}			;m32 <- r32 regular
testcase	{0xF2, 0x48, 0x0F, 0x38, 0xFC, 0x0A},	{aor [rdx],rcx}			;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7F, 0x08, 0xFC, 0x0A},	{aor {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFF, 0x08, 0xFC, 0x0A},	{aor {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFF, 0x08, 0xFC, 0x0A},	{aor [rdx],r25}			;m64 <- er64

; axor instruction
testcase	{0xF3, 0x0F, 0x38, 0xFC, 0x0A},		{axor [rdx],ecx}		;m32 <- r32 regular
testcase	{0xF3, 0x48, 0x0F, 0x38, 0xFC, 0x0A},	{axor [rdx],rcx}		;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7E, 0x08, 0xFC, 0x0A},	{axor {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFE, 0x08, 0xFC, 0x0A},	{axor {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFE, 0x08, 0xFC, 0x0A},	{axor [rdx],r25}		;m64 <- er64

; adc instruction: reg = reg + r/m
; adc non-apx control group
testcase	{0x10, 0x0A},				{adc [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x11, 0x0A},			{adc [rdx],cx}		;r16 + r/m16
testcase	{0x11, 0x0A},				{adc [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x11, 0x0A},			{adc [rdx],rcx}		;r64 + r/m64

; adc explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x10, 0x0A},	{adc{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x11, 0x0A},	{adc{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x11, 0x0A},	{adc{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x11, 0x0A},	{adc{evex} [rdx],rcx}		;r64 + r/m64

; adc REX2
testcase	{0xD5, 0x44, 0x10, 0x0A},		{adc [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x11, 0x0A},		{adc [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x11, 0x0A},		{adc [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x11, 0x0A},		{adc [rdx],r25}			;er64 + r/m64

; adc implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x10, 0x0A},	{adc bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x11, 0x0A},	{adc bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x11, 0x0A},	{adc ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x11, 0x0A},	{adc rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x10, 0x0A},	{adc r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x11, 0x0A},	{adc r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x11, 0x0A},	{adc r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x11, 0x0A},	{adc r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; adc instruction: r/m = reg + r/m
; adc non-apx control group
testcase	{0x12, 0x0A},				{adc cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x13, 0x0A},			{adc cx,[rdx]}		;r16 + r/m16
testcase	{0x13, 0x0A},				{adc ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x13, 0x0A},			{adc rcx,[rdx]}		;r64 + r/m64

; adc explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x12, 0x0A},	{adc{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x13, 0x0A},	{adc{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x13, 0x0A},	{adc{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x13, 0x0A},	{adc{evex} rcx,[rdx]}		;r64 + r/m64

; adc REX2
testcase	{0xD5, 0x44, 0x12, 0x0A},		{adc r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x13, 0x0A},		{adc r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x13, 0x0A},		{adc r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x13, 0x0A},		{adc r25,[rdx]}			;er64 + r/m64

; adc implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x12, 0x0A},	{adc bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x13, 0x0A},	{adc bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x13, 0x0A},	{adc ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x13, 0x0A},	{adc rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x12, 0x0A},	{adc r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x13, 0x0A},	{adc r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x13, 0x0A},	{adc r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x13, 0x0A},	{adc r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; adc instruction: r/m = r/m + imm
; adc non-apx control group
testcase	{0x80, 0x12, 0xFF}, \
			{adc byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x12, 0xFF, 0xFF}, \
			{adc word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x12, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{adc dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x12, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{adc qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x12, 0x7F}, \
			{adc word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x12, 0x7F}, \
			{adc dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x12, 0x7F}, \
			{adc qword [rdx], byte 0x7F}			;r/m64 + imm8

; adc REX2
testcase	{0xD5, 0x11, 0x80, 0x11, 0xFF}, \
			{adc byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x11, 0xFF, 0xFF}, \
			{adc word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x11, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{adc dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x11, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{adc qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x11, 0x7F}, \
			{adc word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x11, 0x7F}, \
			{adc dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x11, 0x7F}, \
			{adc qword [r25], byte 0x7F}			;r/m64 + imm8

; adc implicit evex
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x12, 0xFF}, \
			{adc r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x12, 0xFF, 0xFF}, \
			{adc r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x12, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{adc r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x12, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{adc r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x11, 0x7F}, \
			{adc r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x11, 0x7F}, \
			{adc r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x11, 0x7F}, \
			{adc r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; adcx instruction: reg = reg + r/m
; adcx non-apx control group
testcase	{0x66, 0x0F, 0x38, 0xF6, 0x0A},		{adcx ecx, [rdx]}	;r32 + r/m32
testcase	{0x66 ,0x48, 0x0F, 0x38, 0xF6, 0x0A},	{adcx rcx, [rdx]}	;r64 + r/m64
testcase	{0x66 ,0x4C, 0x0F, 0x38, 0xF6, 0x0A},	{adcx r9, [rdx]}	;r64 + r/m64

; adcx implicit evex
; (legacy map 2 - no rex2 variant)
testcase	{0x62, 0x44, 0x7D, 0x08, 0x66, 0x09},	{adcx r25d, [r9]}	;r32 + r/m32
testcase	{0x62, 0x44, 0xFD, 0x08, 0x66, 0x09},	{adcx r25, [r9]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x7D, 0x08, 0x66, 0x09},	{adcx r9d, [r25]}	;r32 + r/m32
testcase	{0x62, 0x5C, 0xFD, 0x08, 0x66, 0x09},	{adcx r9, [r25]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x75, 0x18, 0x66, 0x09},	{adcx ecx, r9d, [r25]}	;r32 + r/m32 - ndd variant
testcase	{0x62, 0x5C, 0xF5, 0x18, 0x66, 0x09},	{adcx rcx, r9, [r25]}	;r64 + r/m64 - ndd variant

; add instruction
; add non-apx control group
testcase	{0x00, 0x0A},				{add [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x01, 0x0A},			{add [rdx],cx}		;r16 + r/m16
testcase	{0x01, 0x0A},				{add [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x01, 0x0A},			{add [rdx],rcx}		;r64 + r/m64

; add explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x00, 0x0A},	{add{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x01, 0x0A},	{add{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x01, 0x0A},	{add{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x01, 0x0A},	{add{evex} [rdx],rcx}		;r64 + r/m64

; add REX2
testcase	{0xD5, 0x44, 0x00, 0x0A},		{add [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x01, 0x0A},		{add [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x01, 0x0A},		{add [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x01, 0x0A},		{add [rdx],r25}			;er64 + r/m64

; add implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x00, 0x0A},	{add bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x01, 0x0A},	{add bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x01, 0x0A},	{add ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x01, 0x0A},	{add rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x00, 0x0A},	{add r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x01, 0x0A},	{add r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x01, 0x0A},	{add r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x01, 0x0A},	{add r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; add instruction: r/m = reg + r/m
; add non-apx control group
testcase	{0x02, 0x0A},				{add cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x03, 0x0A},			{add cx,[rdx]}		;r16 + r/m16
testcase	{0x03, 0x0A},				{add ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x03, 0x0A},			{add rcx,[rdx]}		;r64 + r/m64

; add explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x02, 0x0A},	{add{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x03, 0x0A},	{add{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x03, 0x0A},	{add{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x03, 0x0A},	{add{evex} rcx,[rdx]}		;r64 + r/m64

; add explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x02, 0x0A},	{add{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x03, 0x0A},	{add{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x03, 0x0A},	{add{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x03, 0x0A},	{add{nf} rcx,[rdx]}		;r64 + r/m64

; add REX2
testcase	{0xD5, 0x44, 0x02, 0x0A},		{add r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x03, 0x0A},		{add r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x03, 0x0A},		{add r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x03, 0x0A},		{add r25,[rdx]}			;er64 + r/m64

; add implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x02, 0x0A},	{add bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x03, 0x0A},	{add bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x03, 0x0A},	{add ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x03, 0x0A},	{add rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x02, 0x0A},	{add r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x03, 0x0A},	{add r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x03, 0x0A},	{add r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x03, 0x0A},	{add r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; add implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x02, 0x0A},	{add{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x03, 0x0A},	{add{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x03, 0x0A},	{add{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x03, 0x0A},	{add{nf} rcx,[rdx]}		;r64 + r/m64

; add instruction: r/m = r/m + imm
; add non-apx control group
testcase	{0x80, 0x02, 0xFF}, \
			{add byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x02, 0xFF, 0xFF}, \
			{add word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x02, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x02, 0x7F}, \
			{add word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x02, 0x7F}, \
			{add dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x02, 0x7F}, \
			{add qword [rdx], byte 0x7F}			;r/m64 + imm8

; add REX2
testcase	{0xD5, 0x11, 0x80, 0x01, 0xFF}, \
			{add byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x01, 0xFF, 0xFF}, \
			{add word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x01, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x01, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x01, 0x7F}, \
			{add word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x01, 0x7F}, \
			{add dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x01, 0x7F}, \
			{add qword [r25], byte 0x7F}			;r/m64 + imm8

; add implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x02, 0xFF}, \
			{add r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x02, 0xFF, 0xFF}, \
			{add r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x01, 0x7F}, \
			{add r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x01, 0x7F}, \
			{add r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x01, 0x7F}, \
			{add r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; add implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x02, 0xFF}, \
			{add{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x02, 0xFF, 0xFF}, \
			{add{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x01, 0x7F}, \
			{add{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x01, 0x7F}, \
			{add{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x01, 0x7F}, \
			{add{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; adox instruction: reg = reg + r/m
; adox non-apx control group
testcase	{0xF3, 0x0F, 0x38, 0xF6, 0x0A},		{adox ecx, [rdx]}	;r32 + r/m32
testcase	{0xF3 ,0x48, 0x0F, 0x38, 0xF6, 0x0A},	{adox rcx, [rdx]}	;r64 + r/m64
testcase	{0xF3 ,0x4C, 0x0F, 0x38, 0xF6, 0x0A},	{adox r9, [rdx]}	;r64 + r/m64

; adox implicit evex
; (legacy map 2 - no rex2 variant)
testcase	{0x62, 0x44, 0x7E, 0x08, 0x66, 0x09},	{adox r25d, [r9]}	;r32 + r/m32
testcase	{0x62, 0x44, 0xFE, 0x08, 0x66, 0x09},	{adox r25, [r9]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x7E, 0x08, 0x66, 0x09},	{adox r9d, [r25]}	;r32 + r/m32
testcase	{0x62, 0x5C, 0xFE, 0x08, 0x66, 0x09},	{adox r9, [r25]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x76, 0x18, 0x66, 0x09},	{adox ecx, r9d, [r25]}	;r32 + r/m32 - ndd variant
testcase	{0x62, 0x5C, 0xF6, 0x18, 0x66, 0x09},	{adox rcx, r9, [r25]}	;r64 + r/m64 - ndd variant

; and instruction
; and non-apx control group
testcase	{0x20, 0x0A},				{and [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x21, 0x0A},			{and [rdx],cx}		;r16 + r/m16
testcase	{0x21, 0x0A},				{and [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x21, 0x0A},			{and [rdx],rcx}		;r64 + r/m64

; and explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x20, 0x0A},	{and{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x21, 0x0A},	{and{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x21, 0x0A},	{and{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x21, 0x0A},	{and{evex} [rdx],rcx}		;r64 + r/m64

; and REX2
testcase	{0xD5, 0x44, 0x20, 0x0A},		{and [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x21, 0x0A},		{and [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x21, 0x0A},		{and [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x21, 0x0A},		{and [rdx],r25}			;er64 + r/m64

; and implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x20, 0x0A},	{and bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x21, 0x0A},	{and bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x21, 0x0A},	{and ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x21, 0x0A},	{and rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x20, 0x0A},	{and r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x21, 0x0A},	{and r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x21, 0x0A},	{and r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x21, 0x0A},	{and r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; and instruction: r/m = reg + r/m
; and non-apx control group
testcase	{0x22, 0x0A},				{and cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x23, 0x0A},			{and cx,[rdx]}		;r16 + r/m16
testcase	{0x23, 0x0A},				{and ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x23, 0x0A},			{and rcx,[rdx]}		;r64 + r/m64

; and explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x22, 0x0A},	{and{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x23, 0x0A},	{and{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x23, 0x0A},	{and{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x23, 0x0A},	{and{evex} rcx,[rdx]}		;r64 + r/m64

; and explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x22, 0x0A},	{and{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x23, 0x0A},	{and{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x23, 0x0A},	{and{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x23, 0x0A},	{and{nf} rcx,[rdx]}		;r64 + r/m64

; and REX2
testcase	{0xD5, 0x44, 0x22, 0x0A},		{and r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x23, 0x0A},		{and r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x23, 0x0A},		{and r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x23, 0x0A},		{and r25,[rdx]}			;er64 + r/m64

; and implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x22, 0x0A},	{and bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x23, 0x0A},	{and bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x23, 0x0A},	{and ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x23, 0x0A},	{and rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x22, 0x0A},	{and r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x23, 0x0A},	{and r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x23, 0x0A},	{and r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x23, 0x0A},	{and r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; and implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x22, 0x0A},	{and{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x23, 0x0A},	{and{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x23, 0x0A},	{and{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x23, 0x0A},	{and{nf} rcx,[rdx]}		;r64 + r/m64

; and instruction: r/m = r/m + imm
; and non-apx control group
testcase	{0x80, 0x22, 0xFF}, \
			{and byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x22, 0xFF, 0xFF}, \
			{and word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x22, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x22, 0x7F}, \
			{and word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x22, 0x7F}, \
			{and dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x22, 0x7F}, \
			{and qword [rdx], byte 0x7F}			;r/m64 + imm8

; and REX2
testcase	{0xD5, 0x11, 0x80, 0x21, 0xFF}, \
			{and byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x21, 0xFF, 0xFF}, \
			{and word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x21, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x21, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x21, 0x7F}, \
			{and word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x21, 0x7F}, \
			{and dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x21, 0x7F}, \
			{and qword [r25], byte 0x7F}			;r/m64 + imm8

; and implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x22, 0xFF}, \
			{and r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x22, 0xFF, 0xFF}, \
			{and r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x21, 0x7F}, \
			{and r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x21, 0x7F}, \
			{and r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x21, 0x7F}, \
			{and r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; and implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x22, 0xFF}, \
			{and{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x22, 0xFF, 0xFF}, \
			{and{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x21, 0x7F}, \
			{and{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x21, 0x7F}, \
			{and{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x21, 0x7F}, \
			{and{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; andn instruction
; andn non-apx control group (vex)
testcase	{0xC4, 0x62, 0x70, 0xF2, 0x0A},	{andn r9d, ecx, dword [rdx]}
testcase	{0xC4, 0x62, 0xF0, 0xF2, 0x0A},	{andn r9, rcx, qword [rdx]}

; andn explicit evex
testcase	{0x62, 0x72, 0x74, 0x08, 0xF2, 0x0A},	{andn{evex} r9d, ecx, dword [rdx]}
testcase	{0x62, 0x72, 0xF4, 0x08, 0xF2, 0x0A},	{andn{evex} r9, rcx, qword [rdx]}

; andn implicit evex through NF
testcase	{0x62, 0x72, 0x74, 0x0C, 0xF2, 0x0A},	{andn{nf} r9d, ecx, dword [rdx]}
testcase	{0x62, 0x72, 0xF4, 0x0C, 0xF2, 0x0A},	{andn{nf} r9, rcx, qword [rdx]}

; andn implicit evex through EGPR
testcase	{0x62, 0x62, 0x74, 0x08, 0xF2, 0x0A},	{andn r25d, ecx, dword [rdx]}
testcase	{0x62, 0x62, 0xF4, 0x08, 0xF2, 0x0A},	{andn r25, rcx, qword [rdx]}

; bextr instruction
; bextr non-apx control group (vex)
testcase	{0xC4, 0x62, 0x70, 0xF7, 0x0A},	{bextr r9d, dword [rdx], ecx}
testcase	{0xC4, 0x62, 0xF0, 0xF7, 0x0A},	{bextr r9, qword [rdx], rcx}

; bextr explicit evex
testcase	{0x62, 0x72, 0x74, 0x08, 0xF7, 0x0A},	{bextr{evex} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x08, 0xF7, 0x0A},	{bextr{evex} r9, qword [rdx], rcx}

; bextr implicit evex through NF
testcase	{0x62, 0x72, 0x74, 0x0C, 0xF7, 0x0A},	{bextr{nf} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x0C, 0xF7, 0x0A},	{bextr{nf} r9, qword [rdx], rcx}

; bextr implicit evex through EGPR
testcase	{0x62, 0x62, 0x74, 0x08, 0xF7, 0x0A},	{bextr r25d, dword [rdx], ecx}
testcase	{0x62, 0x62, 0xF4, 0x08, 0xF7, 0x0A},	{bextr r25, qword [rdx], rcx}

; blsi instruction
; blsi non-apx control group (vex)
testcase	{0xC4, 0xE2, 0x30, 0xF3, 0x1A},	{blsi r9d, dword [rdx]}
testcase	{0xC4, 0xE2, 0xB0, 0xF3, 0x1A},	{blsi r9, qword [rdx]}

; blsi explicit evex
testcase	{0x62, 0xF2, 0x34, 0x08, 0xF3, 0x1A},	{blsi{evex} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x08, 0xF3, 0x1A},	{blsi{evex} r9, qword [rdx]}

; blsi implicit evex through NF
testcase	{0x62, 0xF2, 0x34, 0x0C, 0xF3, 0x1A},	{blsi{nf} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x0C, 0xF3, 0x1A},	{blsi{nf} r9, qword [rdx]}

; blsi implicit evex through EGPR
testcase	{0x62, 0xF2, 0x34, 0x00, 0xF3, 0x1A},	{blsi r25d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x00, 0xF3, 0x1A},	{blsi r25, qword [rdx]}

; blsmsk instruction
; blsmsk non-apx control group (vex)
testcase	{0xC4, 0xE2, 0x30, 0xF3, 0x12},	{blsmsk r9d, dword [rdx]}
testcase	{0xC4, 0xE2, 0xB0, 0xF3, 0x12},	{blsmsk r9, qword [rdx]}

; blsmsk explicit evex
testcase	{0x62, 0xF2, 0x34, 0x08, 0xF3, 0x12},	{blsmsk{evex} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x08, 0xF3, 0x12},	{blsmsk{evex} r9, qword [rdx]}

; blsmsk implicit evex through NF
testcase	{0x62, 0xF2, 0x34, 0x0C, 0xF3, 0x12},	{blsmsk{nf} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x0C, 0xF3, 0x12},	{blsmsk{nf} r9, qword [rdx]}

; blsmsk implicit evex through EGPR
testcase	{0x62, 0xF2, 0x34, 0x00, 0xF3, 0x12},	{blsmsk r25d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x00, 0xF3, 0x12},	{blsmsk r25, qword [rdx]}

; blsr instruction
; blsr non-apx control group (vex)
testcase	{0xC4, 0xE2, 0x30, 0xF3, 0x0A},	{blsr r9d, dword [rdx]}
testcase	{0xC4, 0xE2, 0xB0, 0xF3, 0x0A},	{blsr r9, qword [rdx]}

; blsr explicit evex
testcase	{0x62, 0xF2, 0x34, 0x08, 0xF3, 0x0A},	{blsr{evex} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x08, 0xF3, 0x0A},	{blsr{evex} r9, qword [rdx]}

; blsr implicit evex through NF
testcase	{0x62, 0xF2, 0x34, 0x0C, 0xF3, 0x0A},	{blsr{nf} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x0C, 0xF3, 0x0A},	{blsr{nf} r9, qword [rdx]}

; blsr implicit evex through EGPR
testcase	{0x62, 0xF2, 0x34, 0x00, 0xF3, 0x0A},	{blsr r25d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x00, 0xF3, 0x0A},	{blsr r25, qword [rdx]}

; bzhi instruction
; bzhi non-apx control group (vex)
testcase	{0xC4, 0x62, 0x70, 0xF5, 0x0A},	{bzhi r9d, dword [rdx], ecx}
testcase	{0xC4, 0x62, 0xF0, 0xF5, 0x0A},	{bzhi r9, qword [rdx], rcx}

; bzhi explicit evex
testcase	{0x62, 0x72, 0x74, 0x08, 0xF5, 0x0A},	{bzhi{evex} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x08, 0xF5, 0x0A},	{bzhi{evex} r9, qword [rdx], rcx}

; bzhi implicit evex through NF
testcase	{0x62, 0x72, 0x74, 0x0C, 0xF5, 0x0A},	{bzhi{nf} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x0C, 0xF5, 0x0A},	{bzhi{nf} r9, qword [rdx], rcx}

; bzhi implicit evex through EGPR
testcase	{0x62, 0x62, 0x74, 0x08, 0xF5, 0x0A},	{bzhi r25d, dword [rdx], ecx}
testcase	{0x62, 0x62, 0xF4, 0x08, 0xF5, 0x0A},	{bzhi r25, qword [rdx], rcx}

; --- cmovcc - conditional move instruction ---
; - cmovb/cmovnae/cmovc - cmov if below -
testcase	{0x66, 0x0F, 0x42, 0x0A},		{cmovb cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x42, 0x0A},			{cmovb ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x42, 0x0A},		{cmovb r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x42, 0x0A},		{cmovnae cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x42, 0x0A},			{cmovnae ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x42, 0x0A},		{cmovnae r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x42, 0x0A},	{cmovb r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x42, 0x0A},	{cmovb r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x42, 0x0A},	{cmovb r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x42, 0x0A},	{cmovnae r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x42, 0x0A},	{cmovnae r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x42, 0x0A},	{cmovnae r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x42, 0x0A},		{cmovb r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x42, 0x0A},		{cmovb r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x42, 0x0A},		{cmovb r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x42, 0x0A},		{cmovnae r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x42, 0x0A},		{cmovnae r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x42, 0x0A},		{cmovnae r25, [rdx]}	; r/m64 -> ereg64

; - cmovbe/cmovna - cmov if below or equal -
testcase	{0x66, 0x0F, 0x46, 0x0A},		{cmovbe cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x46, 0x0A},			{cmovbe ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x46, 0x0A},		{cmovbe r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x46, 0x0A},		{cmovna cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x46, 0x0A},			{cmovna ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x46, 0x0A},		{cmovna r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x46, 0x0A},	{cmovbe r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x46, 0x0A},	{cmovbe r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x46, 0x0A},	{cmovbe r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x46, 0x0A},	{cmovna r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x46, 0x0A},	{cmovna r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x46, 0x0A},	{cmovna r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x46, 0x0A},		{cmovbe r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x46, 0x0A},		{cmovbe r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x46, 0x0A},		{cmovbe r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x46, 0x0A},		{cmovna r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x46, 0x0A},		{cmovna r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x46, 0x0A},		{cmovna r25, [rdx]}	; r/m64 -> ereg64

; - cmovl/cmovnge - cmov if less -
testcase	{0x66, 0x0F, 0x4C, 0x0A},		{cmovl cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4C, 0x0A},			{cmovl ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4C, 0x0A},		{cmovl r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4C, 0x0A},		{cmovnge cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4C, 0x0A},			{cmovnge ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4C, 0x0A},		{cmovnge r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4C, 0x0A},	{cmovl r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4C, 0x0A},	{cmovl r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4C, 0x0A},	{cmovl r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4C, 0x0A},	{cmovnge r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4C, 0x0A},	{cmovnge r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4C, 0x0A},	{cmovnge r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4C, 0x0A},		{cmovl r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4C, 0x0A},		{cmovl r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4C, 0x0A},		{cmovl r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4C, 0x0A},		{cmovnge r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4C, 0x0A},		{cmovnge r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4C, 0x0A},		{cmovnge r25, [rdx]}	; r/m64 -> ereg64

; - cmovle/cmovng - cmov if less or equal -
testcase	{0x66, 0x0F, 0x4E, 0x0A},		{cmovle cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4E, 0x0A},			{cmovle ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4E, 0x0A},		{cmovle r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4E, 0x0A},		{cmovng cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4E, 0x0A},			{cmovng ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4E, 0x0A},		{cmovng r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4E, 0x0A},	{cmovle r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4E, 0x0A},	{cmovle r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4E, 0x0A},	{cmovle r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4E, 0x0A},	{cmovng r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4E, 0x0A},	{cmovng r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4E, 0x0A},	{cmovng r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4E, 0x0A},		{cmovle r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4E, 0x0A},		{cmovle r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4E, 0x0A},		{cmovle r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4E, 0x0A},		{cmovng r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4E, 0x0A},		{cmovng r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4E, 0x0A},		{cmovng r25, [rdx]}	; r/m64 -> ereg64

; - cmovnb/cmovae/cmovnc - cmov if not below -
testcase	{0x66, 0x0F, 0x43, 0x0A},		{cmovnb cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x43, 0x0A},			{cmovnb ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x43, 0x0A},		{cmovnb r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x43, 0x0A},		{cmovae cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x43, 0x0A},			{cmovae ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x43, 0x0A},		{cmovae r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x43, 0x0A},	{cmovnb r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x43, 0x0A},	{cmovnb r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x43, 0x0A},	{cmovnb r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x43, 0x0A},	{cmovae r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x43, 0x0A},	{cmovae r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x43, 0x0A},	{cmovae r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x43, 0x0A},		{cmovnb r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x43, 0x0A},		{cmovnb r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x43, 0x0A},		{cmovnb r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x43, 0x0A},		{cmovae r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x43, 0x0A},		{cmovae r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x43, 0x0A},		{cmovae r25, [rdx]}	; r/m64 -> ereg64

; - cmovnbe/cmova - cmov if not below or equal -
testcase	{0x66, 0x0F, 0x47, 0x0A},		{cmovnbe cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x47, 0x0A},			{cmovnbe ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x47, 0x0A},		{cmovnbe r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x47, 0x0A},		{cmova cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x47, 0x0A},			{cmova ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x47, 0x0A},		{cmova r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x47, 0x0A},	{cmovnbe r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x47, 0x0A},	{cmovnbe r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x47, 0x0A},	{cmovnbe r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x47, 0x0A},	{cmova r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x47, 0x0A},	{cmova r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x47, 0x0A},	{cmova r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x47, 0x0A},		{cmovnbe r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x47, 0x0A},		{cmovnbe r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x47, 0x0A},		{cmovnbe r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x47, 0x0A},		{cmova r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x47, 0x0A},		{cmova r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x47, 0x0A},		{cmova r25, [rdx]}	; r/m64 -> ereg64

; - cmovnl/cmovge - cmov if not less -
testcase	{0x66, 0x0F, 0x4D, 0x0A},		{cmovnl cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4D, 0x0A},			{cmovnl ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4D, 0x0A},		{cmovnl r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4D, 0x0A},		{cmovge cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4D, 0x0A},			{cmovge ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4D, 0x0A},		{cmovge r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4D, 0x0A},	{cmovnl r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4D, 0x0A},	{cmovnl r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4D, 0x0A},	{cmovnl r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4D, 0x0A},	{cmovge r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4D, 0x0A},	{cmovge r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4D, 0x0A},	{cmovge r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4D, 0x0A},		{cmovnl r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4D, 0x0A},		{cmovnl r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4D, 0x0A},		{cmovnl r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4D, 0x0A},		{cmovge r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4D, 0x0A},		{cmovge r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4D, 0x0A},		{cmovge r25, [rdx]}	; r/m64 -> ereg64

; - cmovnle/cmovg - cmov if not less or equal -
testcase	{0x66, 0x0F, 0x4F, 0x0A},		{cmovnle cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4F, 0x0A},			{cmovnle ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4F, 0x0A},		{cmovnle r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4F, 0x0A},		{cmovg cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4F, 0x0A},			{cmovg ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4F, 0x0A},		{cmovg r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4F, 0x0A},	{cmovnle r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4F, 0x0A},	{cmovnle r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4F, 0x0A},	{cmovnle r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4F, 0x0A},	{cmovg r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4F, 0x0A},	{cmovg r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4F, 0x0A},	{cmovg r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4F, 0x0A},		{cmovnle r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4F, 0x0A},		{cmovnle r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4F, 0x0A},		{cmovnle r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4F, 0x0A},		{cmovg r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4F, 0x0A},		{cmovg r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4F, 0x0A},		{cmovg r25, [rdx]}	; r/m64 -> ereg64

; - cmovno - cmov if not overflow -
testcase	{0x66, 0x0F, 0x41, 0x0A},		{cmovno cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x41, 0x0A},			{cmovno ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x41, 0x0A},		{cmovno r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x41, 0x0A},	{cmovno r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x41, 0x0A},	{cmovno r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x41, 0x0A},	{cmovno r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x41, 0x0A},		{cmovno r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x41, 0x0A},		{cmovno r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x41, 0x0A},		{cmovno r25, [rdx]}	; r/m64 -> ereg64

; - cmovnp/cmovpo - cmov if not parity -
testcase	{0x66, 0x0F, 0x4B, 0x0A},		{cmovnp cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4B, 0x0A},			{cmovnp ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4B, 0x0A},		{cmovnp r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4B, 0x0A},		{cmovpo cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4B, 0x0A},			{cmovpo ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4B, 0x0A},		{cmovpo r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4B, 0x0A},	{cmovnp r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4B, 0x0A},	{cmovnp r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4B, 0x0A},	{cmovnp r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4B, 0x0A},	{cmovpo r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4B, 0x0A},	{cmovpo r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4B, 0x0A},	{cmovpo r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4B, 0x0A},		{cmovnp r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4B, 0x0A},		{cmovnp r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4B, 0x0A},		{cmovnp r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4B, 0x0A},		{cmovpo r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4B, 0x0A},		{cmovpo r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4B, 0x0A},		{cmovpo r25, [rdx]}	; r/m64 -> ereg64

; - cmovns - cmov if not signed -
testcase	{0x66, 0x0F, 0x49, 0x0A},		{cmovns cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x49, 0x0A},			{cmovns ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x49, 0x0A},		{cmovns r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x49, 0x0A},	{cmovns r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x49, 0x0A},	{cmovns r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x49, 0x0A},	{cmovns r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x49, 0x0A},		{cmovns r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x49, 0x0A},		{cmovns r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x49, 0x0A},		{cmovns r25, [rdx]}	; r/m64 -> ereg64

; - cmovnz/cmovne - cmov if not zero -
testcase	{0x66, 0x0F, 0x45, 0x0A},		{cmovnz cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x45, 0x0A},			{cmovnz ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x45, 0x0A},		{cmovnz r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x45, 0x0A},		{cmovne cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x45, 0x0A},			{cmovne ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x45, 0x0A},		{cmovne r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x45, 0x0A},	{cmovnz r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x45, 0x0A},	{cmovnz r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x45, 0x0A},	{cmovnz r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x45, 0x0A},	{cmovne r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x45, 0x0A},	{cmovne r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x45, 0x0A},	{cmovne r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x45, 0x0A},		{cmovnz r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x45, 0x0A},		{cmovnz r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x45, 0x0A},		{cmovnz r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x45, 0x0A},		{cmovne r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x45, 0x0A},		{cmovne r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x45, 0x0A},		{cmovne r25, [rdx]}	; r/m64 -> ereg64

; - cmovo - cmov if overflow -
testcase	{0x66, 0x0F, 0x40, 0x0A},		{cmovo cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x40, 0x0A},			{cmovo ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x40, 0x0A},		{cmovo r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x40, 0x0A},	{cmovo r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x40, 0x0A},	{cmovo r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x40, 0x0A},	{cmovo r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x40, 0x0A},		{cmovo r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x40, 0x0A},		{cmovo r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x40, 0x0A},		{cmovo r25, [rdx]}	; r/m64 -> ereg64

; - cmovp/cmovpe - cmov if parity -
testcase	{0x66, 0x0F, 0x4A, 0x0A},		{cmovp cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4A, 0x0A},			{cmovp ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4A, 0x0A},		{cmovp r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4A, 0x0A},		{cmovpe cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4A, 0x0A},			{cmovpe ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4A, 0x0A},		{cmovpe r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4A, 0x0A},	{cmovp r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4A, 0x0A},	{cmovp r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4A, 0x0A},	{cmovp r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4A, 0x0A},	{cmovpe r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4A, 0x0A},	{cmovpe r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4A, 0x0A},	{cmovpe r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4A, 0x0A},		{cmovp r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4A, 0x0A},		{cmovp r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4A, 0x0A},		{cmovp r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4A, 0x0A},		{cmovpe r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4A, 0x0A},		{cmovpe r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4A, 0x0A},		{cmovpe r25, [rdx]}	; r/m64 -> ereg64

; - cmovs - cmov if signed -
testcase	{0x66, 0x0F, 0x48, 0x0A},		{cmovs cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x48, 0x0A},			{cmovs ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x48, 0x0A},		{cmovs r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x48, 0x0A},	{cmovs r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x48, 0x0A},	{cmovs r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x48, 0x0A},	{cmovs r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x48, 0x0A},		{cmovs r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x48, 0x0A},		{cmovs r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x48, 0x0A},		{cmovs r25, [rdx]}	; r/m64 -> ereg64

; - cmovz/cmove - cmov if zero -
testcase	{0x66, 0x0F, 0x44, 0x0A},		{cmovz cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x44, 0x0A},			{cmovz ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x44, 0x0A},		{cmovz r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x44, 0x0A},		{cmove cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x44, 0x0A},			{cmove ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x44, 0x0A},		{cmove r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x44, 0x0A},	{cmovz r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x44, 0x0A},	{cmovz r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x44, 0x0A},	{cmovz r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x44, 0x0A},	{cmove r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x44, 0x0A},	{cmove r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x44, 0x0A},	{cmove r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x44, 0x0A},		{cmovz r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x44, 0x0A},		{cmovz r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x44, 0x0A},		{cmovz r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x44, 0x0A},		{cmove r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x44, 0x0A},		{cmove r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x44, 0x0A},		{cmove r25, [rdx]}	; r/m64 -> ereg64

; --- cmpccxadd - conditional add instruction ---
; - cmpbexadd - add if below or equal -
testcase	{0xC4, 0x62, 0x71, 0xE6, 0x0A},		{cmpbexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE6, 0x0A},		{cmpbexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE6, 0x0A},	{cmpbexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE6, 0x0A},	{cmpbexadd [r26], r25, rcx}	; r/m64 += r64

; - cmpbxadd - add if below -
testcase	{0xC4, 0x62, 0x71, 0xE2, 0x0A},		{cmpbxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE2, 0x0A},		{cmpbxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE2, 0x0A},	{cmpbxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE2, 0x0A},	{cmpbxadd [r26], r25, rcx}	; r/m64 += r64

; - cmplexadd - add if less or equal -
testcase	{0xC4, 0x62, 0x71, 0xEE, 0x0A},		{cmplexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEE, 0x0A},		{cmplexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEE, 0x0A},	{cmplexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEE, 0x0A},	{cmplexadd [r26], r25, rcx}	; r/m64 += r64

; - cmplxadd - add if less or equal -
testcase	{0xC4, 0x62, 0x71, 0xEC, 0x0A},		{cmplxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEC, 0x0A},		{cmplxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEC, 0x0A},	{cmplxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEC, 0x0A},	{cmplxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnbexadd - add if not below or equal -
testcase	{0xC4, 0x62, 0x71, 0xE7, 0x0A},		{cmpnbexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE7, 0x0A},		{cmpnbexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE7, 0x0A},	{cmpnbexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE7, 0x0A},	{cmpnbexadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnbxadd - add if not below -
testcase	{0xC4, 0x62, 0x71, 0xE3, 0x0A},		{cmpnbxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE3, 0x0A},		{cmpnbxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE3, 0x0A},	{cmpnbxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE3, 0x0A},	{cmpnbxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnlexadd - add if not less or equal -
testcase	{0xC4, 0x62, 0x71, 0xEF, 0x0A},		{cmpnlexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEF, 0x0A},		{cmpnlexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEF, 0x0A},	{cmpnlexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEF, 0x0A},	{cmpnlexadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnlxadd - add if not less -
testcase	{0xC4, 0x62, 0x71, 0xED, 0x0A},		{cmpnlxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xED, 0x0A},		{cmpnlxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xED, 0x0A},	{cmpnlxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xED, 0x0A},	{cmpnlxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnoxadd - add if not overflow -
testcase	{0xC4, 0x62, 0x71, 0xE1, 0x0A},		{cmpnoxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE1, 0x0A},		{cmpnoxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE1, 0x0A},	{cmpnoxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE1, 0x0A},	{cmpnoxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnpxadd - add if not parity -
testcase	{0xC4, 0x62, 0x71, 0xEB, 0x0A},		{cmpnpxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEB, 0x0A},		{cmpnpxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEB, 0x0A},	{cmpnpxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEB, 0x0A},	{cmpnpxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnsxadd - add if not sign -
testcase	{0xC4, 0x62, 0x71, 0xE9, 0x0A},		{cmpnsxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE9, 0x0A},		{cmpnsxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE9, 0x0A},	{cmpnsxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE9, 0x0A},	{cmpnsxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnzxadd - add if not zero -
testcase	{0xC4, 0x62, 0x71, 0xE5, 0x0A},		{cmpnzxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE5, 0x0A},		{cmpnzxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE5, 0x0A},	{cmpnzxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE5, 0x0A},	{cmpnzxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpoxadd - add if overflow -
testcase	{0xC4, 0x62, 0x71, 0xE0, 0x0A},		{cmpoxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE0, 0x0A},		{cmpoxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE0, 0x0A},	{cmpoxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE0, 0x0A},	{cmpoxadd [r26], r25, rcx}	; r/m64 += r64

; - cmppxadd - add if parity -
testcase	{0xC4, 0x62, 0x71, 0xEA, 0x0A},		{cmppxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEA, 0x0A},		{cmppxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEA, 0x0A},	{cmppxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEA, 0x0A},	{cmppxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpsxadd - add if sign -
testcase	{0xC4, 0x62, 0x71, 0xE8, 0x0A},		{cmpsxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE8, 0x0A},		{cmpsxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE8, 0x0A},	{cmpsxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE8, 0x0A},	{cmpsxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpzxadd - add if zero -
testcase	{0xC4, 0x62, 0x71, 0xE4, 0x0A},		{cmpzxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE4, 0x0A},		{cmpzxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE4, 0x0A},	{cmpzxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE4, 0x0A},	{cmpzxadd [r26], r25, rcx}	; r/m64 += r64

; --- crc32 instruction ---
; legacy crc32
testcase	{0xF2, 0x0F, 0x38, 0xF0, 0x0A},		{crc32 ecx, byte [rdx]}		; reg32 += crc32(r/m8)
testcase	{0x66, 0xF2, 0x0F, 0x38, 0xF1, 0x0A},	{crc32 ecx, word [rdx]}		; reg32 += crc32(r/m16)
testcase	{0xF2, 0x0F, 0x38, 0xF1, 0x0A},		{crc32 ecx, dword [rdx]}	; reg32 += crc32(r/m32)
testcase	{0xF2, 0x4C, 0x0F, 0x38, 0xF0, 0x0A},	{crc32 r9, byte [rdx]}		; reg64 += crc32(r/m8)
testcase	{0xF2, 0x4C, 0x0F, 0x38, 0xF1, 0x0A},	{crc32 r9, qword [rdx]}		; reg64 += crc32(r/m64)

; implicit evex through EGPRs
testcase	{0x62, 0x64, 0x7C, 0x08, 0xF0, 0x0A},	{crc32 r25d, byte [rdx]}	; ereg32 += crc32(r/m8)
testcase	{0x62, 0x64, 0x7D, 0x08, 0xF1, 0x0A},	{crc32 r25d, word [rdx]}	; ereg32 += crc32(r/m16)
testcase	{0x62, 0x64, 0x7C, 0x08, 0xF1, 0x0A},	{crc32 r25d, dword [rdx]}	; ereg32 += crc32(r/m32)
testcase	{0x62, 0x64, 0xFC, 0x08, 0xF0, 0x0A},	{crc32 r25, byte [rdx]}		; ereg64 += crc32(r/m8)
testcase	{0x62, 0x64, 0xFC, 0x08, 0xF1, 0x0A},	{crc32 r25, qword [rdx]}	; ereg64 += crc32(r/m64)

; --- dec instruction ---
; legacy dec
testcase	{0xFE, 0x0A},		{dec byte [rdx]}
testcase	{0x66, 0xFF, 0x0A},	{dec word [rdx]}
testcase	{0xFF, 0x0A},		{dec dword [rdx]}
testcase	{0x48, 0xFF, 0x0A},	{dec qword [rdx]}
; nolong only testcases
; testcase	{0x66, 0x4A},		{dec dx}
; testcase	{0x4A},			{dec edx}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFE, 0x0A},	{dec{nf} byte [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xFF, 0x0A},	{dec{nf} word [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFF, 0x0A},	{dec{nf} dword [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xFF, 0x0A},	{dec{nf} qword [rdx]}

; implicit evex through ND and EGPRs
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFE, 0x0A},	{dec r25b, byte [rdx]}
testcase	{0x62, 0xF4, 0x35, 0x10, 0xFF, 0x0A},	{dec r25w, word [rdx]}
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFF, 0x0A},	{dec r25d, dword [rdx]}
testcase	{0x62, 0xF4, 0xB4, 0x10, 0xFF, 0x0A},	{dec r25, qword [rdx]}

; --- div instruction ---
; legacy div
testcase	{0xF6, 0x31},				{div byte [rcx]}
testcase	{0x66, 0xF7, 0x31},			{div word [rcx]}
testcase	{0xF7, 0x31},				{div dword [rcx]}
testcase	{0x48, 0xF7, 0x31},			{div qword [rcx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x31},	{div{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x31},	{div{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x31},	{div{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x31},	{div{nf} qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x31},	{div byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x31},	{div word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x31},	{div dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x31},	{div qword [r25]}

; --- enqcmd instruction ---
testcase	{0x67, 0xF2, 0x0F, 0x38, 0xF8, 0x0A},	{enqcmd ecx, zword [edx]}
testcase	{0xF2, 0x0F, 0x38, 0xF8, 0x0A},		{enqcmd rcx, zword [rdx]}
testcase	{0x62, 0x64, 0xFF, 0x08, 0xF8, 0x0A},	{enqcmd r25, zword [rdx]}

; --- enqcmds instruction ---
testcase	{0x67, 0xF3, 0x0F, 0x38, 0xF8, 0x0A},	{enqcmds ecx, zword [edx]}
testcase	{0xF3, 0x0F, 0x38, 0xF8, 0x0A},		{enqcmds rcx, zword [rdx]}
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF8, 0x0A},	{enqcmds r25, zword [rdx]}

; --- idiv instruction ---
; legacy idiv
testcase	{0xF6, 0x39},				{idiv byte [rcx]}
testcase	{0x66, 0xF7, 0x39},			{idiv word [rcx]}
testcase	{0xF7, 0x39},				{idiv dword [rcx]}
testcase	{0x48, 0xF7, 0x39},			{idiv qword [rcx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x39},	{idiv{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x39},	{idiv{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x39},	{idiv{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x39},	{idiv{nf} qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x39},	{idiv byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x39},	{idiv word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x39},	{idiv dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x39},	{idiv qword [r25]}

; --- imul instruction ---
; - imul : D:A = reg * A
; legacy
testcase	{0xF6, 0x29},		{imul byte [rcx]}
testcase	{0x66, 0xF7, 0x29},	{imul word [rcx]}
testcase	{0xF7, 0x29},		{imul dword [rcx]}
testcase	{0x48, 0xF7, 0x29},	{imul qword [rcx]}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x29},		{imul{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x29},		{imul{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x29},		{imul{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x29},		{imul{nf} qword [rcx]}
; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x29},		{imul byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x29},		{imul word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x29},		{imul dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x29},		{imul qword [r25]}

; - imul : reg1 *= r/m2 -
; legacy
testcase	{0x66, 0x0F, 0xAF, 0x0A},	{imul cx, [rdx]}
testcase	{0x0F, 0xAF, 0x0A},		{imul ecx, [rdx]}
testcase	{0x48, 0x0F, 0xAF, 0x0A},	{imul rcx, [rdx]}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xAF, 0x0A},		{imul{nf} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xAF, 0x0A},		{imul{nf} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xAF, 0x0A},		{imul{nf} rcx, [rdx]}
; implicit evex through ND
testcase	{0x62, 0xF4, 0x7D, 0x18, 0xAF, 0x0A},		{imul ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x18, 0xAF, 0x0A},		{imul eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x18, 0xAF, 0x0A},		{imul rax, rcx, [rdx]}
; implicit rex2 through EGPRs
testcase	{0x66, 0xD5, 0xD5, 0xAF, 0x0A},		{imul r25w, [r26]}
testcase	{0xD5, 0xD5, 0xAF, 0x0A},		{imul r25d, [r26]}
testcase	{0xD5, 0xDD, 0xAF, 0x0A},		{imul r25, [r26]}

; - imul : reg1 = r/m2 * imm3
; legacy
testcase	{0x66, 0x6B, 0x0A, 0x02},			{imul cx, [rdx], byte 0x02}
testcase	{0x6B, 0x0A, 0x02},				{imul ecx, [rdx], byte 0x02}
testcase	{0x48, 0x6B, 0x0A, 0x02},			{imul rcx, [rdx], byte 0x02}
testcase	{0x66, 0x69, 0x0A, 0x02, 0x02},			{imul cx, [rdx], word 0x0202}
testcase	{0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},		{imul ecx, [rdx], dword 0x02020202}
testcase	{0x48, 0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},	{imul rcx, [rdx], dword 0x02020202}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x6B, 0x0A, 0x02},\
			{imul{nf} cx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x6B, 0x0A, 0x02},\
			{imul{nf} ecx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x6B, 0x0A, 0x02},\
			{imul{nf} rcx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x69, 0x0A, 0x02, 0x02},\
			{imul{nf} cx, [rdx], word 0x0202}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},\
			{imul{nf} ecx, [rdx], dword 0x02020202}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},\
			{imul{nf} rcx, [rdx], dword 0x02020202}
; implicit evex through ZU
testcase	{0x62, 0xF4, 0x7D, 0x18, 0x6B, 0x0A, 0x02},\
			{imul{zu} cx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7C, 0x18, 0x6B, 0x0A, 0x02},\
			{imul{zu} ecx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0xFC, 0x18, 0x6B, 0x0A, 0x02},\
			{imul{zu} rcx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7D, 0x18, 0x69, 0x0A, 0x02, 0x02},\
			{imul{zu} cx, [rdx], word 0x0202}

; --- inc instruction ---
; legacy inc
testcase	{0xFE, 0x02},		{inc byte [rdx]}
testcase	{0x66, 0xFF, 0x02},	{inc word [rdx]}
testcase	{0xFF, 0x02},		{inc dword [rdx]}
testcase	{0x48, 0xFF, 0x02},	{inc qword [rdx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFE, 0x02},	{inc{nf} byte [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xFF, 0x02},	{inc{nf} word [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFF, 0x02},	{inc{nf} dword [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xFF, 0x02},	{inc{nf} qword [rdx]}

; implicit evex through ND and EGPRs
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFE, 0x02},	{inc r25b, byte [rdx]}
testcase	{0x62, 0xF4, 0x35, 0x10, 0xFF, 0x02},	{inc r25w, word [rdx]}
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFF, 0x02},	{inc r25d, dword [rdx]}
testcase	{0x62, 0xF4, 0xB4, 0x10, 0xFF, 0x02},	{inc r25, qword [rdx]}

; --- invept instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0x80, 0x0A},		{invept rcx, oword [rdx]}
; apx through EGPR
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF0, 0x0A},	{invept r25, oword [rdx]}

; --- invpcid instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0x82, 0x0A},		{invpcid rcx, oword [rdx]}
; apx through EGPR
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF2, 0x0A},	{invpcid r25, oword [rdx]}

; --- invvpid instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0x81, 0x0A},		{invvpid rcx, oword [rdx]}
; apx through EGPR
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF1, 0x0A},	{invvpid r25, oword [rdx]}

; --- kmov instructions ---
; legacy - 0x90 variant
testcase	{0xC5, 0xF9, 0x90, 0xCA},	{kmovb k1, k2}
testcase	{0xC5, 0xF8, 0x90, 0xCA},	{kmovw k1, k2}
testcase	{0xC4, 0xE1, 0xF9, 0x90, 0xCA},	{kmovd k1, k2}
testcase	{0xC4, 0xE1, 0xF8, 0x90, 0xCA},	{kmovq k1, k2}
testcase	{0xC5, 0xF9, 0x90, 0x0A},	{kmovb k1, [rdx]}
testcase	{0xC5, 0xF8, 0x90, 0x0A},	{kmovw k1, [rdx]}
testcase	{0xC4, 0xE1, 0xF9, 0x90, 0x0A},	{kmovd k1, [rdx]}
testcase	{0xC4, 0xE1, 0xF8, 0x90, 0x0A},	{kmovq k1, [rdx]}
; legacy - 0x91 variant
testcase	{0xC5, 0xF9, 0x91, 0x0A},	{kmovb [rdx], k1}
testcase	{0xC5, 0xF8, 0x91, 0x0A},	{kmovw [rdx], k1}
testcase	{0xC4, 0xE1, 0xF9, 0x91, 0x0A},	{kmovd [rdx], k1}
testcase	{0xC4, 0xE1, 0xF8, 0x91, 0x0A},	{kmovq [rdx], k1}
; legacy - 0x92 variant
; TODO: these shouldn't be here I think? Only 32bit/64bit operands for 0x92?
; testcase	{0xC5, 0xF9, 0x92, 0xCA},	{kmovb k1, dl}
; testcase	{0xC5, 0xF8, 0x92, 0xCA},	{kmovw k1, dx}
testcase	{0xC5, 0xF9, 0x92, 0xCA},	{kmovb k1, edx}
testcase	{0xC5, 0xF8, 0x92, 0xCA},	{kmovw k1, edx}
testcase	{0xC5, 0xFB, 0x92, 0xCA},	{kmovd k1, edx}
testcase	{0xC4, 0xE1, 0xFB, 0x92, 0xCA},	{kmovq k1, rdx}
; legacy - 0x93 variant
testcase	{0xC5, 0xF9, 0x93, 0xCA},	{kmovb ecx, k2}
testcase	{0xC5, 0xF8, 0x93, 0xCA},	{kmovw ecx, k2}
testcase	{0xC5, 0xFB, 0x93, 0xCA},	{kmovd ecx, k2}
testcase	{0xC4, 0xE1, 0xFB, 0x93, 0xCA},	{kmovq rcx, k2}

; implicit evex through EGPRs
testcase	{0x62, 0xD9, 0x7D, 0x08, 0x90, 0x0A},	{kmovb k1, [r26]}
testcase	{0x62, 0xD9, 0x7D, 0x08, 0x91, 0x0A},	{kmovb [r26], k1}
testcase	{0x62, 0xD9, 0x7D, 0x08, 0x92, 0xCA},	{kmovb k1, r26d}
testcase	{0x62, 0x61, 0x7D, 0x08, 0x93, 0xC9},	{kmovb r25d, k1}
testcase	{0x62, 0xD9, 0x7C, 0x08, 0x90, 0x0A},	{kmovw k1, [r26]}
testcase	{0x62, 0xD9, 0x7C, 0x08, 0x91, 0x0A},	{kmovw [r26], k1}
testcase	{0x62, 0xD9, 0x7C, 0x08, 0x92, 0xCA},	{kmovw k1, r26d}
testcase	{0x62, 0x61, 0x7C, 0x08, 0x93, 0xC9},	{kmovw r25d, k1}
testcase	{0x62, 0xD9, 0xFD, 0x08, 0x90, 0x0A},	{kmovd k1, [r26]}
testcase	{0x62, 0xD9, 0xFD, 0x08, 0x91, 0x0A},	{kmovd [r26], k1}
testcase	{0x62, 0xD9, 0x7F, 0x08, 0x92, 0xCA},	{kmovd k1, r26d}
testcase	{0x62, 0x61, 0x7F, 0x08, 0x93, 0xC9},	{kmovd r25d, k1}
testcase	{0x62, 0xD9, 0xFC, 0x08, 0x90, 0x0A},	{kmovq k1, [r26]}
testcase	{0x62, 0xD9, 0xFC, 0x08, 0x91, 0x0A},	{kmovq [r26], k1}
testcase	{0x62, 0xD9, 0xFF, 0x08, 0x92, 0xCA},	{kmovq k1, r26}
testcase	{0x62, 0x61, 0xFF, 0x08, 0x93, 0xC9},	{kmovq r25, k1}

; --- ldtilecfg instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x78, 0x49, 0x02},		{ldtilecfg [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7C, 0x08, 0x49, 0x02},	{ldtilecfg [r26]}

; --- lzcnt instruction ---
; legacy
testcase	{0x66, 0xF3, 0x0F, 0xBD, 0x0A},	{lzcnt cx, [rdx]}
testcase	{0xF3, 0x0F, 0xBD, 0x0A},	{lzcnt ecx, [rdx]}
testcase	{0xF3, 0x48, 0x0F, 0xBD, 0x0A},	{lzcnt rcx, [rdx]}
; apx
; TODO: lzcnt doesn't want to use evex, defaults to the legacy encoding
; testcase	{0x62, 0x4C, 0x7D, 0x08, 0xF5, 0x0A},	{lzcnt r25w, [r26]}
; testcase	{0x62, 0x4C, 0x7C, 0x08, 0xF5, 0x0A},	{lzcnt r25d, [r26]}
; testcase	{0x62, 0x4C, 0xFC, 0x08, 0xF5, 0x0A},	{lzcnt r25, [r26]}

testcase	{0x62, 0x4C, 0x7D, 0x0C, 0xF5, 0x0A},	{lzcnt{nf} r25w, [r26]}
testcase	{0x62, 0x4C, 0x7C, 0x0C, 0xF5, 0x0A},	{lzcnt{nf} r25d, [r26]}
testcase	{0x62, 0x4C, 0xFC, 0x0C, 0xF5, 0x0A},	{lzcnt{nf} r25, [r26]}

; --- movbe instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0xF0, 0x0A},	{movbe cx, [rdx]}
testcase	{0x0F, 0x38, 0xF0, 0x0A},	{movbe ecx, [rdx]}
testcase	{0x48, 0x0F, 0x38, 0xF0, 0x0A},	{movbe rcx, [rdx]}
testcase	{0x66, 0x0F, 0x38, 0xF1, 0x0A},	{movbe [rdx], cx}
testcase	{0x0F, 0x38, 0xF1, 0x0A},	{movbe [rdx], ecx}
testcase	{0x48, 0x0F, 0x38, 0xF1, 0x0A},	{movbe [rdx], rcx}
; implicit evex through EGPRs
testcase	{0x62, 0x4C, 0x7D, 0x08, 0x60, 0x0A},	{movbe r25w, [r26]}
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x60, 0x0A},	{movbe r25d, [r26]}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0x60, 0x0A},	{movbe r25, [r26]}
testcase	{0x62, 0x4C, 0x7D, 0x08, 0x61, 0x0A},	{movbe [r26], r25w}
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x61, 0x0A},	{movbe [r26], r25d}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0x61, 0x0A},	{movbe [r26], r25}

; --- movdir64b instruction ---
; legacy
testcase	{0x67, 0x66, 0x0F, 0x38, 0xF8, 0x0A},	{movdir64b ecx, [edx]}
testcase	{0x66, 0x0F, 0x38, 0xF8, 0x0A},		{movdir64b rcx, [rdx]}
; apx
testcase	{0x62, 0x4C, 0xFD, 0x08, 0xF8, 0x0A},	{movdir64b r25, [r26]}

; --- movdiri instruction ---
; legacy
testcase	{0x0F, 0x38, 0xF9, 0x0A},		{movdiri [rdx], ecx}
testcase	{0x48, 0x0F, 0x38, 0xF9, 0x0A},		{movdiri [rdx], rcx}
; implicit evex through EGPRs
testcase	{0x62, 0x4C, 0x7C, 0x08, 0xF9, 0x0A},	{movdiri [r26], r25d}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0xF9, 0x0A},	{movdiri [r26], r25}

; --- movrs instruction ---
; legacy
testcase	{0x0F, 0x38, 0x8A, 0x0A},	{movrs cl, [rdx]}
testcase	{0x66, 0x0F, 0x38, 0x8B, 0x0A},	{movrs cx, [rdx]}
testcase	{0x0F, 0x38, 0x8B, 0x0A},	{movrs ecx, [rdx]}
testcase	{0x48, 0x0F, 0x38, 0x8B, 0x0A},	{movrs rcx, [rdx]}
; implicit evex through EGPRs
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x8A, 0x0A},	{movrs r25b, [r26]}
testcase	{0x62, 0x4C, 0x7D, 0x08, 0x8B, 0x0A},	{movrs r25w, [r26]}
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x8B, 0x0A},	{movrs r25d, [r26]}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0x8B, 0x0A},	{movrs r25, [r26]}

; --- mul instruction ---
; - mul : D:A = reg * A
; legacy
testcase	{0xF6, 0x21},		{mul byte [rcx]}
testcase	{0x66, 0xF7, 0x21},	{mul word [rcx]}
testcase	{0xF7, 0x21},		{mul dword [rcx]}
testcase	{0x48, 0xF7, 0x21},	{mul qword [rcx]}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x21},		{mul{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x21},		{mul{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x21},		{mul{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x21},		{mul{nf} qword [rcx]}
; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x21},		{mul byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x21},		{mul word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x21},		{mul dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x21},		{mul qword [r25]}

; --- mulx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x2B, 0xF6, 0x0B},		{mulx ecx, r10d, [rbx]}
testcase	{0xC4, 0xE2, 0xAB, 0xF6, 0x0B},		{mulx rcx, r10, [rbx]}
; implicit evex through EGPRs
testcase	{0x62, 0xF2, 0x2F, 0x00, 0xF6, 0x0B},	{mulx ecx, r26d, [rbx]}
testcase	{0x62, 0xF2, 0xAF, 0x00, 0xF6, 0x0B},	{mulx rcx, r26, [rbx]}

; --- neg instruction ---
; legacy neg
testcase	{0xF6, 0x19},				{neg byte [rcx]}
testcase	{0x66, 0xF7, 0x19},			{neg word [rcx]}
testcase	{0xF7, 0x19},				{neg dword [rcx]}
testcase	{0x48, 0xF7, 0x19},			{neg qword [rcx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x19},	{neg{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x19},	{neg{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x19},	{neg{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x19},	{neg{nf} qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x19},	{neg byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x19},	{neg word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x19},	{neg dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x19},	{neg qword [r25]}

; implicit evex through ND
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF6, 0x19},	{neg dl, byte [rcx]}
testcase	{0x62, 0xF4, 0x6D, 0x18, 0xF7, 0x19},	{neg dx, word [rcx]}
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF7, 0x19},	{neg edx, dword [rcx]}
testcase	{0x62, 0xF4, 0xEC, 0x18, 0xF7, 0x19},	{neg rdx, qword [rcx]}

; --- not instruction ---
; legacy not
testcase	{0xF6, 0x11},				{not byte [rcx]}
testcase	{0x66, 0xF7, 0x11},			{not word [rcx]}
testcase	{0xF7, 0x11},				{not dword [rcx]}
testcase	{0x48, 0xF7, 0x11},			{not qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x11},	{not byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x11},	{not word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x11},	{not dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x11},	{not qword [r25]}

; implicit evex through ND
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF6, 0x11},	{not dl, byte [rcx]}
testcase	{0x62, 0xF4, 0x6D, 0x18, 0xF7, 0x11},	{not dx, word [rcx]}
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF7, 0x11},	{not edx, dword [rcx]}
testcase	{0x62, 0xF4, 0xEC, 0x18, 0xF7, 0x11},	{not rdx, qword [rcx]}

; or instruction
; or non-apx control group
testcase	{0x08, 0x0A},				{or [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x09, 0x0A},			{or [rdx],cx}		;r16 + r/m16
testcase	{0x09, 0x0A},				{or [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x09, 0x0A},			{or [rdx],rcx}		;r64 + r/m64

; or explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x08, 0x0A},	{or{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x09, 0x0A},	{or{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x09, 0x0A},	{or{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x09, 0x0A},	{or{evex} [rdx],rcx}		;r64 + r/m64

; or REX2
testcase	{0xD5, 0x44, 0x08, 0x0A},		{or [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x09, 0x0A},		{or [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x09, 0x0A},		{or [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x09, 0x0A},		{or [rdx],r25}			;er64 + r/m64

; or implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x08, 0x0A},	{or bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x09, 0x0A},	{or bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x09, 0x0A},	{or ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x09, 0x0A},	{or rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x08, 0x0A},	{or r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x09, 0x0A},	{or r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x09, 0x0A},	{or r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x09, 0x0A},	{or r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; or instruction: r/m = reg + r/m
; or non-apx control group
testcase	{0x0A, 0x0A},				{or cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x0B, 0x0A},			{or cx,[rdx]}		;r16 + r/m16
testcase	{0x0B, 0x0A},				{or ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x0B, 0x0A},			{or rcx,[rdx]}		;r64 + r/m64

; or explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x0A, 0x0A},	{or{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x0B, 0x0A},	{or{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x0B, 0x0A},	{or{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x0B, 0x0A},	{or{evex} rcx,[rdx]}		;r64 + r/m64

; or explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0A, 0x0A},	{or{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x0B, 0x0A},	{or{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0B, 0x0A},	{or{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x0B, 0x0A},	{or{nf} rcx,[rdx]}		;r64 + r/m64

; or REX2
testcase	{0xD5, 0x44, 0x0A, 0x0A},		{or r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x0B, 0x0A},		{or r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x0B, 0x0A},		{or r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x0B, 0x0A},		{or r25,[rdx]}			;er64 + r/m64

; or implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x0A, 0x0A},	{or bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x0B, 0x0A},	{or bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x0B, 0x0A},	{or ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x0B, 0x0A},	{or rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x0A, 0x0A},	{or r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x0B, 0x0A},	{or r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x0B, 0x0A},	{or r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x0B, 0x0A},	{or r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; or implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0A, 0x0A},	{or{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x0B, 0x0A},	{or{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0B, 0x0A},	{or{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x0B, 0x0A},	{or{nf} rcx,[rdx]}		;r64 + r/m64

; or instruction: r/m = r/m + imm
; or non-apx control group
testcase	{0x80, 0x0A, 0xFF}, \
			{or byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x0A, 0xFF, 0xFF}, \
			{or word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x0A, 0x7F}, \
			{or word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x0A, 0x7F}, \
			{or dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x0A, 0x7F}, \
			{or qword [rdx], byte 0x7F}			;r/m64 + imm8

; or REX2
testcase	{0xD5, 0x11, 0x80, 0x09, 0xFF}, \
			{or byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x09, 0xFF, 0xFF}, \
			{or word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x09, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x09, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x09, 0x7F}, \
			{or word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x09, 0x7F}, \
			{or dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x09, 0x7F}, \
			{or qword [r25], byte 0x7F}			;r/m64 + imm8

; or implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x0A, 0xFF}, \
			{or r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x0A, 0xFF, 0xFF}, \
			{or r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x09, 0x7F}, \
			{or r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x09, 0x7F}, \
			{or r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x09, 0x7F}, \
			{or r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; or implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x0A, 0xFF}, \
			{or{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x0A, 0xFF, 0xFF}, \
			{or{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x09, 0x7F}, \
			{or{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x09, 0x7F}, \
			{or{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x09, 0x7F}, \
			{or{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; --- pdep instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x33, 0xF5, 0x0A},	{pdep ecx, r9d, [rdx]}
testcase	{0xC4, 0xE2, 0xB3, 0xF5, 0x0A},	{pdep rcx, r9, [rdx]}

; implicit evex through EGPRs
testcase	{0x62, 0xF2, 0x37, 0x00, 0xF5, 0x0A},	{pdep ecx, r25d, [rdx]}
testcase	{0x62, 0xF2, 0xB7, 0x00, 0xF5, 0x0A},	{pdep rcx, r25, [rdx]}

; --- pext instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x32, 0xF5, 0x0A},	{pext ecx, r9d, [rdx]}
testcase	{0xC4, 0xE2, 0xB2, 0xF5, 0x0A},	{pext rcx, r9, [rdx]}

; implicit evex through EGPRs
testcase	{0x62, 0xF2, 0x36, 0x00, 0xF5, 0x0A},	{pext ecx, r25d, [rdx]}
testcase	{0x62, 0xF2, 0xB6, 0x00, 0xF5, 0x0A},	{pext rcx, r25, [rdx]}

; --- popcnt instruction ---
; legacy
testcase	{0x66, 0xF3, 0x0F, 0xB8, 0x0A},	{popcnt cx, [rdx]}
testcase	{0xF3, 0x0F, 0xB8, 0x0A},	{popcnt ecx, [rdx]}
testcase	{0xF3, 0x48, 0x0F, 0xB8, 0x0A},	{popcnt rcx, [rdx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C ,0x88, 0x0A},	{popcnt{nf} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x88, 0x0A},	{popcnt{nf} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x88, 0x0A},	{popcnt{nf} rcx, [rdx]}

; implicit evex through EGPRs
; TODO: broken, is using the non-APX database entry
; testcase	{0x66, 0xD5, 0xC4, 0x88, 0x0A},	{popcnt r25w, [rdx]}
; testcase	{0xD5, 0xC4, 0x88, 0x0A},	{popcnt r25d, [rdx]}
; testcase	{0xD5, 0xCC, 0x88, 0x0A},	{popcnt r25, [rdx]}

; --- Rotate instructions : RCL/RCR/ROL/ROR ---
; legacy - rcl
testcase	{0xD0, 0x12},			{rcl byte [rdx], 1}
testcase	{0xD2, 0x12},			{rcl byte [rdx], cl}
testcase	{0xC0, 0x12, 0x03},		{rcl byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x12},		{rcl word [rdx], 1}
testcase	{0x66, 0xD3, 0x12},		{rcl word [rdx], cl}
testcase	{0x66, 0xC1, 0x12, 0x03},	{rcl word [rdx], 0x03}
testcase	{0xD1, 0x12},			{rcl dword [rdx], 1}
testcase	{0xD3, 0x12},			{rcl dword [rdx], cl}
testcase	{0xC1, 0x12, 0x03},		{rcl dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x12},		{rcl qword [rdx], 1}
testcase	{0x48, 0xD3, 0x12},		{rcl qword [rdx], cl}
testcase	{0x48, 0xC1, 0x12, 0x03},	{rcl qword [rdx], 0x03}
; legacy - rcr
testcase	{0xD0, 0x1A},			{rcr byte [rdx], 1}
testcase	{0xD2, 0x1A},			{rcr byte [rdx], cl}
testcase	{0xC0, 0x1A, 0x03},		{rcr byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x1A},		{rcr word [rdx], 1}
testcase	{0x66, 0xD3, 0x1A},		{rcr word [rdx], cl}
testcase	{0x66, 0xC1, 0x1A, 0x03},	{rcr word [rdx], 0x03}
testcase	{0xD1, 0x1A},			{rcr dword [rdx], 1}
testcase	{0xD3, 0x1A},			{rcr dword [rdx], cl}
testcase	{0xC1, 0x1A, 0x03},		{rcr dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x1A},		{rcr qword [rdx], 1}
testcase	{0x48, 0xD3, 0x1A},		{rcr qword [rdx], cl}
testcase	{0x48, 0xC1, 0x1A, 0x03},	{rcr qword [rdx], 0x03}
; legacy - rol
testcase	{0xD0, 0x02},			{rol byte [rdx], 1}
testcase	{0xD2, 0x02},			{rol byte [rdx], cl}
testcase	{0xC0, 0x02, 0x03},		{rol byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x02},		{rol word [rdx], 1}
testcase	{0x66, 0xD3, 0x02},		{rol word [rdx], cl}
testcase	{0x66, 0xC1, 0x02, 0x03},	{rol word [rdx], 0x03}
testcase	{0xD1, 0x02},			{rol dword [rdx], 1}
testcase	{0xD3, 0x02},			{rol dword [rdx], cl}
testcase	{0xC1, 0x02, 0x03},		{rol dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x02},		{rol qword [rdx], 1}
testcase	{0x48, 0xD3, 0x02},		{rol qword [rdx], cl}
testcase	{0x48, 0xC1, 0x02, 0x03},	{rol qword [rdx], 0x03}
; legacy - ror
testcase	{0xD0, 0x0A},			{ror byte [rdx], 1}
testcase	{0xD2, 0x0A},			{ror byte [rdx], cl}
testcase	{0xC0, 0x0A, 0x03},		{ror byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x0A},		{ror word [rdx], 1}
testcase	{0x66, 0xD3, 0x0A},		{ror word [rdx], cl}
testcase	{0x66, 0xC1, 0x0A, 0x03},	{ror word [rdx], 0x03}
testcase	{0xD1, 0x0A},			{ror dword [rdx], 1}
testcase	{0xD3, 0x0A},			{ror dword [rdx], cl}
testcase	{0xC1, 0x0A, 0x03},		{ror dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x0A},		{ror qword [rdx], 1}
testcase	{0x48, 0xD3, 0x0A},		{ror qword [rdx], cl}
testcase	{0x48, 0xC1, 0x0A, 0x03},	{ror qword [rdx], 0x03}

; implicit evex through EGPRs - rcl
testcase	{0xD5, 0x11, 0xD0, 0x12},		{rcl byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x12},		{rcl byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x12, 0x03},		{rcl byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x12},		{rcl word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x12},		{rcl word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x12, 0x03},	{rcl word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x12},		{rcl dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x12},		{rcl dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x12, 0x03},		{rcl dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x12},		{rcl qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x12},		{rcl qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x12, 0x03},		{rcl qword [r26], 0x03}
; implicit evex through ND - rcl
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x12},		{rcl r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x12},		{rcl r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x12, 0x03},	{rcl r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x12},		{rcl r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x12},		{rcl r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x12, 0x03},	{rcl r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x12},		{rcl r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x12},		{rcl r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x12, 0x03},	{rcl r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x12},		{rcl r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x12},		{rcl r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x12, 0x03},	{rcl r25, qword [r26], 0x03}
; implicit evex through EGPRs - rcr
testcase	{0xD5, 0x11, 0xD0, 0x1A},		{rcr byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x1A},		{rcr byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x1A, 0x03},		{rcr byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x1A},		{rcr word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x1A},		{rcr word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x1A, 0x03},	{rcr word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x1A},		{rcr dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x1A},		{rcr dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x1A, 0x03},		{rcr dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x1A},		{rcr qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x1A},		{rcr qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x1A, 0x03},		{rcr qword [r26], 0x03}
; implicit evex through ND - rcr
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x1A},		{rcr r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x1A},		{rcr r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x1A, 0x03},	{rcr r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x1A},		{rcr r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x1A},		{rcr r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x1A, 0x03},	{rcr r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x1A},		{rcr r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x1A},		{rcr r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x1A, 0x03},	{rcr r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x1A},		{rcr r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x1A},		{rcr r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x1A, 0x03},	{rcr r25, qword [r26], 0x03}
; implicit evex through EGPRs - rol
testcase	{0xD5, 0x11, 0xD0, 0x02},		{rol byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x02},		{rol byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x02, 0x03},		{rol byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x02},		{rol word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x02},		{rol word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x02, 0x03},	{rol word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x02},		{rol dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x02},		{rol dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x02, 0x03},		{rol dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x02},		{rol qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x02},		{rol qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x02, 0x03},		{rol qword [r26], 0x03}
; implicit evex through ND - rol
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x02},		{rol r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x02},		{rol r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x02, 0x03},	{rol r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x02},		{rol r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x02},		{rol r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x02, 0x03},	{rol r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x02},		{rol r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x02},		{rol r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x02, 0x03},	{rol r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x02},		{rol r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x02},		{rol r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x02, 0x03},	{rol r25, qword [r26], 0x03}
; implicit evex through EGPRs - ror
testcase	{0xD5, 0x11, 0xD0, 0x0A},		{ror byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x0A},		{ror byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x0A, 0x03},		{ror byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x0A},		{ror word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x0A},		{ror word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x0A, 0x03},	{ror word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x0A},		{ror dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x0A},		{ror dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x0A, 0x03},		{ror dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x0A},		{ror qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x0A},		{ror qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x0A, 0x03},		{ror qword [r26], 0x03}
; implicit evex through ND - ror
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x0A},		{ror r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x0A},		{ror r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x0A, 0x03},	{ror r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x0A},		{ror r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x0A},		{ror r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x0A, 0x03},	{ror r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x0A},		{ror r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x0A},		{ror r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x0A, 0x03},	{ror r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x0A},		{ror r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x0A},		{ror r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x0A, 0x03},	{ror r25, qword [r26], 0x03}

; --- rdmsr instruction ---
; legacy
testcase	{0x0F, 0x32},					{rdmsr}
; apx
testcase	{0x62, 0xDF, 0x7F, 0x08, 0xF6, 0xC1},		{rdmsr r25, 0xFFFF}

; --- rorx instruction ---
; legacy
testcase	{0xC4, 0xE3, 0x7B, 0xF0, 0x0A, 0x03},	{rorx ecx, [rdx], 0x03}
testcase	{0xC4, 0xE3, 0xFB, 0xF0, 0x0A, 0x03},	{rorx rcx, [rdx], 0x03}
; implicit evex through EGPRs
testcase	{0x62, 0x63, 0x7F, 0x08, 0xF0, 0x0A, 0x03},	{rorx r25d, [rdx], 0x03}
testcase	{0x62, 0x63, 0xFF, 0x08, 0xF0, 0x0A, 0x03},	{rorx r25, [rdx], 0x03}

; --- sar instruction ---
; legacy - sar
testcase	{0xD0, 0x3A},			{sar byte [rdx], 1}
testcase	{0xD2, 0x3A},			{sar byte [rdx], cl}
testcase	{0xC0, 0x3A, 0x03},		{sar byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x3A},		{sar word [rdx], 1}
testcase	{0x66, 0xD3, 0x3A},		{sar word [rdx], cl}
testcase	{0x66, 0xC1, 0x3A, 0x03},	{sar word [rdx], 0x03}
testcase	{0xD1, 0x3A},			{sar dword [rdx], 1}
testcase	{0xD3, 0x3A},			{sar dword [rdx], cl}
testcase	{0xC1, 0x3A, 0x03},		{sar dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x3A},		{sar qword [rdx], 1}
testcase	{0x48, 0xD3, 0x3A},		{sar qword [rdx], cl}
testcase	{0x48, 0xC1, 0x3A, 0x03},	{sar qword [rdx], 0x03}
; legacy - shl
testcase	{0xD0, 0x22},			{shl byte [rdx], 1}
testcase	{0xD2, 0x22},			{shl byte [rdx], cl}
testcase	{0xC0, 0x22, 0x03},		{shl byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x22},		{shl word [rdx], 1}
testcase	{0x66, 0xD3, 0x22},		{shl word [rdx], cl}
testcase	{0x66, 0xC1, 0x22, 0x03},	{shl word [rdx], 0x03}
testcase	{0xD1, 0x22},			{shl dword [rdx], 1}
testcase	{0xD3, 0x22},			{shl dword [rdx], cl}
testcase	{0xC1, 0x22, 0x03},		{shl dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x22},		{shl qword [rdx], 1}
testcase	{0x48, 0xD3, 0x22},		{shl qword [rdx], cl}
testcase	{0x48, 0xC1, 0x22, 0x03},	{shl qword [rdx], 0x03}
; legacy - shr
testcase	{0xD0, 0x2A},			{shr byte [rdx], 1}
testcase	{0xD2, 0x2A},			{shr byte [rdx], cl}
testcase	{0xC0, 0x2A, 0x03},		{shr byte [rdx], 0x03}
testcase	{0x66, 0xD1, 0x2A},		{shr word [rdx], 1}
testcase	{0x66, 0xD3, 0x2A},		{shr word [rdx], cl}
testcase	{0x66, 0xC1, 0x2A, 0x03},	{shr word [rdx], 0x03}
testcase	{0xD1, 0x2A},			{shr dword [rdx], 1}
testcase	{0xD3, 0x2A},			{shr dword [rdx], cl}
testcase	{0xC1, 0x2A, 0x03},		{shr dword [rdx], 0x03}
testcase	{0x48, 0xD1, 0x2A},		{shr qword [rdx], 1}
testcase	{0x48, 0xD3, 0x2A},		{shr qword [rdx], cl}
testcase	{0x48, 0xC1, 0x2A, 0x03},	{shr qword [rdx], 0x03}

; implicit evex through EGPRs - sar
testcase	{0xD5, 0x11, 0xD0, 0x3A},		{sar byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x3A},		{sar byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x3A, 0x03},		{sar byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x3A},		{sar word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x3A},		{sar word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x3A, 0x03},	{sar word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x3A},		{sar dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x3A},		{sar dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x3A, 0x03},		{sar dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x3A},		{sar qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x3A},		{sar qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x3A, 0x03},		{sar qword [r26], 0x03}
; implicit evex through ND - sar
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x3A},		{sar r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x3A},		{sar r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x3A, 0x03},	{sar r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x3A},		{sar r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x3A},		{sar r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x3A, 0x03},	{sar r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x3A},		{sar r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x3A},		{sar r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x3A, 0x03},	{sar r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x3A},		{sar r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x3A},		{sar r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x3A, 0x03},	{sar r25, qword [r26], 0x03}
; implicit evex through EGPRs - shl
testcase	{0xD5, 0x11, 0xD0, 0x22},		{shl byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x22},		{shl byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x22, 0x03},		{shl byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x22},		{shl word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x22},		{shl word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x22, 0x03},	{shl word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x22},		{shl dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x22},		{shl dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x22, 0x03},		{shl dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x22},		{shl qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x22},		{shl qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x22, 0x03},		{shl qword [r26], 0x03}
; implicit evex through ND - shl
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x22},		{shl r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x22},		{shl r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x22, 0x03},	{shl r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x22},		{shl r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x22},		{shl r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x22, 0x03},	{shl r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x22},		{shl r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x22},		{shl r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x22, 0x03},	{shl r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x22},		{shl r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x22},		{shl r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x22, 0x03},	{shl r25, qword [r26], 0x03}
; implicit evex through EGPRs - shr
testcase	{0xD5, 0x11, 0xD0, 0x2A},		{shr byte [r26], 1}
testcase	{0xD5, 0x11, 0xD2, 0x2A},		{shr byte [r26], cl}
testcase	{0xD5, 0x11, 0xC0, 0x2A, 0x03},		{shr byte [r26], 0x03}
testcase	{0x66, 0xD5, 0x11, 0xD1, 0x2A},		{shr word [r26], 1}
testcase	{0x66, 0xD5, 0x11, 0xD3, 0x2A},		{shr word [r26], cl}
testcase	{0x66, 0xD5, 0x11, 0xC1, 0x2A, 0x03},	{shr word [r26], 0x03}
testcase	{0xD5, 0x11, 0xD1, 0x2A},		{shr dword [r26], 1}
testcase	{0xD5, 0x11, 0xD3, 0x2A},		{shr dword [r26], cl}
testcase	{0xD5, 0x11, 0xC1, 0x2A, 0x03},		{shr dword [r26], 0x03}
testcase	{0xD5, 0x19, 0xD1, 0x2A},		{shr qword [r26], 1}
testcase	{0xD5, 0x19, 0xD3, 0x2A},		{shr qword [r26], cl}
testcase	{0xD5, 0x19, 0xC1, 0x2A, 0x03},		{shr qword [r26], 0x03}
; implicit evex through ND - shr
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD0, 0x2A},		{shr r25b, byte [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD2, 0x2A},		{shr r25b, byte [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC0, 0x2A, 0x03},	{shr r25b, byte [r26], 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD1, 0x2A},		{shr r25w, word [r26], 1}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xD3, 0x2A},		{shr r25w, word [r26], cl}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xC1, 0x2A, 0x03},	{shr r25w, word [r26], 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD1, 0x2A},		{shr r25d, dword [r26], 1}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xD3, 0x2A},		{shr r25d, dword [r26], cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xC1, 0x2A, 0x03},	{shr r25d, dword [r26], 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD1, 0x2A},		{shr r25, qword [r26], 1}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xD3, 0x2A},		{shr r25, qword [r26], cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xC1, 0x2A, 0x03},	{shr r25, qword [r26], 0x03}

; --- sarx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x2A, 0xF7, 0x0A},	{sarx ecx, [rdx], r10d}
testcase	{0xC4, 0xE2, 0xAA, 0xF7, 0x0A},	{sarx rcx, [rdx], r10}
; implicit evex through EGPRs
testcase	{0x62, 0x62, 0x2E, 0x08, 0xF7, 0x0A},	{sarx r25d, [rdx], r10d}
testcase	{0x62, 0x62, 0xAE, 0x08, 0xF7, 0x0A},	{sarx r25, [rdx], r10}
; --- shlx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x29, 0xF7, 0x0A},	{shlx ecx, [rdx], r10d}
testcase	{0xC4, 0xE2, 0xA9, 0xF7, 0x0A},	{shlx rcx, [rdx], r10}
; implicit evex through EGPRs
testcase	{0x62, 0x62, 0x2D, 0x08, 0xF7, 0x0A},	{shlx r25d, [rdx], r10d}
testcase	{0x62, 0x62, 0xAD, 0x08, 0xF7, 0x0A},	{shlx r25, [rdx], r10}
; --- shrx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x2B, 0xF7, 0x0A},	{shrx ecx, [rdx], r10d}
testcase	{0xC4, 0xE2, 0xAB, 0xF7, 0x0A},	{shrx rcx, [rdx], r10}
; implicit evex through EGPRs
testcase	{0x62, 0x62, 0x2F, 0x08, 0xF7, 0x0A},	{shrx r25d, [rdx], r10d}
testcase	{0x62, 0x62, 0xAF, 0x08, 0xF7, 0x0A},	{shrx r25, [rdx], r10}

; sbb instruction
; sbb non-apx control group
testcase	{0x18, 0x0A},				{sbb [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x19, 0x0A},			{sbb [rdx],cx}		;r16 + r/m16
testcase	{0x19, 0x0A},				{sbb [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x19, 0x0A},			{sbb [rdx],rcx}		;r64 + r/m64

; sbb explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x18, 0x0A},	{sbb{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x19, 0x0A},	{sbb{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x19, 0x0A},	{sbb{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x19, 0x0A},	{sbb{evex} [rdx],rcx}		;r64 + r/m64

; sbb REX2
testcase	{0xD5, 0x44, 0x18, 0x0A},		{sbb [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x19, 0x0A},		{sbb [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x19, 0x0A},		{sbb [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x19, 0x0A},		{sbb [rdx],r25}			;er64 + r/m64

; sbb implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x18, 0x0A},	{sbb bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x19, 0x0A},	{sbb bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x19, 0x0A},	{sbb ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x19, 0x0A},	{sbb rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x18, 0x0A},	{sbb r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x19, 0x0A},	{sbb r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x19, 0x0A},	{sbb r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x19, 0x0A},	{sbb r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; sbb instruction: r/m = reg + r/m
; sbb non-apx control group
testcase	{0x1A, 0x0A},				{sbb cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x1B, 0x0A},			{sbb cx,[rdx]}		;r16 + r/m16
testcase	{0x1B, 0x0A},				{sbb ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x1B, 0x0A},			{sbb rcx,[rdx]}		;r64 + r/m64

; sbb explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x1A, 0x0A},	{sbb{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x1B, 0x0A},	{sbb{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x1B, 0x0A},	{sbb{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x1B, 0x0A},	{sbb{evex} rcx,[rdx]}		;r64 + r/m64

; sbb explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x1A, 0x0A},	{sbb{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x1B, 0x0A},	{sbb{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x1B, 0x0A},	{sbb{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x1B, 0x0A},	{sbb{nf} rcx,[rdx]}		;r64 + r/m64

; sbb REX2
testcase	{0xD5, 0x44, 0x1A, 0x0A},		{sbb r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x1B, 0x0A},		{sbb r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x1B, 0x0A},		{sbb r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x1B, 0x0A},		{sbb r25,[rdx]}			;er64 + r/m64

; sbb implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x1A, 0x0A},	{sbb bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x1B, 0x0A},	{sbb bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x1B, 0x0A},	{sbb ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x1B, 0x0A},	{sbb rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x1A, 0x0A},	{sbb r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x1B, 0x0A},	{sbb r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x1B, 0x0A},	{sbb r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x1B, 0x0A},	{sbb r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; sbb implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x1A, 0x0A},	{sbb{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x1B, 0x0A},	{sbb{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x1B, 0x0A},	{sbb{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x1B, 0x0A},	{sbb{nf} rcx,[rdx]}		;r64 + r/m64

; sbb instruction: r/m = r/m + imm
; sbb non-apx control group
testcase	{0x80, 0x1A, 0xFF}, \
			{sbb byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x1A, 0xFF, 0xFF}, \
			{sbb word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x1A, 0x7F}, \
			{sbb word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x1A, 0x7F}, \
			{sbb dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x1A, 0x7F}, \
			{sbb qword [rdx], byte 0x7F}			;r/m64 + imm8

; sbb REX2
testcase	{0xD5, 0x11, 0x80, 0x19, 0xFF}, \
			{sbb byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x19, 0xFF, 0xFF}, \
			{sbb word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x19, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x19, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x19, 0x7F}, \
			{sbb word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x19, 0x7F}, \
			{sbb dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x19, 0x7F}, \
			{sbb qword [r25], byte 0x7F}			;r/m64 + imm8

; sbb implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x1A, 0xFF}, \
			{sbb r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x1A, 0xFF, 0xFF}, \
			{sbb r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x19, 0x7F}, \
			{sbb r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x19, 0x7F}, \
			{sbb r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x19, 0x7F}, \
			{sbb r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; sbb implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x1A, 0xFF}, \
			{sbb{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x1A, 0xFF, 0xFF}, \
			{sbb{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x19, 0x7F}, \
			{sbb{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x19, 0x7F}, \
			{sbb{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x19, 0x7F}, \
			{sbb{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; --- shld instruction ---
; legacy
testcase	{0x66, 0x0F, 0xA4, 0x02, 0x03},		{shld [rdx], ax, 0x03}
testcase	{0x0F, 0xA4, 0x02, 0x03},		{shld [rdx], eax, 0x03}
testcase	{0x48, 0x0F, 0xA4, 0x02, 0x03},		{shld [rdx], rax, 0x03}
testcase	{0x66, 0x0F, 0xA5, 0x02},		{shld [rdx], ax, cl}
testcase	{0x0F, 0xA5, 0x02},			{shld [rdx], eax, cl}
testcase	{0x48, 0x0F, 0xA5, 0x02},		{shld [rdx], rax, cl}

; implicit rex2 through EGPRs
testcase	{0x66, 0xD5, 0x91, 0xA4, 0x02, 0x03},	{shld [r26], ax, 0x03}
testcase	{0xD5, 0x91, 0xA4, 0x02, 0x03},		{shld [r26], eax, 0x03}
testcase	{0xD5, 0x99, 0xA4, 0x02, 0x03},		{shld [r26], rax, 0x03}
testcase	{0x66, 0xD5, 0x91, 0xA5, 0x02},		{shld [r26], ax, cl}
testcase	{0xD5, 0x91, 0xA5, 0x02},		{shld [r26], eax, cl}
testcase	{0xD5, 0x99, 0xA5, 0x02},		{shld [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x35, 0x10, 0x24, 0x02, 0x03},	{shld r25w, [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0x24, 0x02, 0x03},	{shld r25d, [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0x24, 0x02, 0x03},	{shld r25, [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xA5, 0x02},		{shld r25w, [r26], ax, cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xA5, 0x02},		{shld r25d, [r26], eax, cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xA5, 0x02},		{shld r25, [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x24, 0x02, 0x03},	{shld{nf} [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x24, 0x02, 0x03},	{shld{nf} [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x24, 0x02, 0x03},	{shld{nf} [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0xA5, 0x02},		{shld{nf} [r26], ax, cl}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0xA5, 0x02},		{shld{nf} [r26], eax, cl}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0xA5, 0x02},		{shld{nf} [r26], rax, cl}

; --- shrd instruction ---
; legacy
testcase	{0x66, 0x0F, 0xAC, 0x02, 0x03},		{shrd [rdx], ax, 0x03}
testcase	{0x0F, 0xAC, 0x02, 0x03},		{shrd [rdx], eax, 0x03}
testcase	{0x48, 0x0F, 0xAC, 0x02, 0x03},		{shrd [rdx], rax, 0x03}
testcase	{0x66, 0x0F, 0xAD, 0x02},		{shrd [rdx], ax, cl}
testcase	{0x0F, 0xAD, 0x02},			{shrd [rdx], eax, cl}
testcase	{0x48, 0x0F, 0xAD, 0x02},		{shrd [rdx], rax, cl}

; implicit rex2 through EGPRs
testcase	{0x66, 0xD5, 0x91, 0xAC, 0x02, 0x03},	{shrd [r26], ax, 0x03}
testcase	{0xD5, 0x91, 0xAC, 0x02, 0x03},		{shrd [r26], eax, 0x03}
testcase	{0xD5, 0x99, 0xAC, 0x02, 0x03},		{shrd [r26], rax, 0x03}
testcase	{0x66, 0xD5, 0x91, 0xAD, 0x02},		{shrd [r26], ax, cl}
testcase	{0xD5, 0x91, 0xAD, 0x02},		{shrd [r26], eax, cl}
testcase	{0xD5, 0x99, 0xAD, 0x02},		{shrd [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x35, 0x10, 0x2C, 0x02, 0x03},	{shrd r25w, [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x34, 0x10, 0x2C, 0x02, 0x03},	{shrd r25d, [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0x2C, 0x02, 0x03},	{shrd r25, [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x35, 0x10, 0xAD, 0x02},		{shrd r25w, [r26], ax, cl}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xAD, 0x02},		{shrd r25d, [r26], eax, cl}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xAD, 0x02},		{shrd r25, [r26], rax, cl}

; implicit evex through ND
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x2C, 0x02, 0x03},	{shrd{nf} [r26], ax, 0x03}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x2C, 0x02, 0x03},	{shrd{nf} [r26], eax, 0x03}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x2C, 0x02, 0x03},	{shrd{nf} [r26], rax, 0x03}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0xAD, 0x02},		{shrd{nf} [r26], ax, cl}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0xAD, 0x02},		{shrd{nf} [r26], eax, cl}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0xAD, 0x02},		{shrd{nf} [r26], rax, cl}

; --- sttilecfg instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x79, 0x49, 0x02},			{sttilecfg [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7D, 0x08, 0x49, 0x02},		{sttilecfg [r26]}

; sub instruction
; sub non-apx control group
testcase	{0x28, 0x0A},				{sub [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x29, 0x0A},			{sub [rdx],cx}		;r16 + r/m16
testcase	{0x29, 0x0A},				{sub [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x29, 0x0A},			{sub [rdx],rcx}		;r64 + r/m64

; sub explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x28, 0x0A},	{sub{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x29, 0x0A},	{sub{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x29, 0x0A},	{sub{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x29, 0x0A},	{sub{evex} [rdx],rcx}		;r64 + r/m64

; sub REX2
testcase	{0xD5, 0x44, 0x28, 0x0A},		{sub [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x29, 0x0A},		{sub [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x29, 0x0A},		{sub [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x29, 0x0A},		{sub [rdx],r25}			;er64 + r/m64

; sub implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x28, 0x0A},	{sub bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x29, 0x0A},	{sub bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x29, 0x0A},	{sub ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x29, 0x0A},	{sub rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x28, 0x0A},	{sub r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x29, 0x0A},	{sub r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x29, 0x0A},	{sub r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x29, 0x0A},	{sub r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; sub instruction: r/m = reg + r/m
; sub non-apx control group
testcase	{0x2A, 0x0A},				{sub cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x2B, 0x0A},			{sub cx,[rdx]}		;r16 + r/m16
testcase	{0x2B, 0x0A},				{sub ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x2B, 0x0A},			{sub rcx,[rdx]}		;r64 + r/m64

; sub explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x2A, 0x0A},	{sub{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x2B, 0x0A},	{sub{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x2B, 0x0A},	{sub{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x2B, 0x0A},	{sub{evex} rcx,[rdx]}		;r64 + r/m64

; sub explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2A, 0x0A},	{sub{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x2B, 0x0A},	{sub{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2B, 0x0A},	{sub{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x2B, 0x0A},	{sub{nf} rcx,[rdx]}		;r64 + r/m64

; sub REX2
testcase	{0xD5, 0x44, 0x2A, 0x0A},		{sub r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x2B, 0x0A},		{sub r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x2B, 0x0A},		{sub r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x2B, 0x0A},		{sub r25,[rdx]}			;er64 + r/m64

; sub implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x2A, 0x0A},	{sub bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x2B, 0x0A},	{sub bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x2B, 0x0A},	{sub ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x2B, 0x0A},	{sub rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x2A, 0x0A},	{sub r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x2B, 0x0A},	{sub r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x2B, 0x0A},	{sub r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x2B, 0x0A},	{sub r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; sub implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2A, 0x0A},	{sub{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x2B, 0x0A},	{sub{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2B, 0x0A},	{sub{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x2B, 0x0A},	{sub{nf} rcx,[rdx]}		;r64 + r/m64

; sub instruction: r/m = r/m + imm
; sub non-apx control group
testcase	{0x80, 0x2A, 0xFF}, \
			{sub byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x2A, 0xFF, 0xFF}, \
			{sub word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x2A, 0x7F}, \
			{sub word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x2A, 0x7F}, \
			{sub dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x2A, 0x7F}, \
			{sub qword [rdx], byte 0x7F}			;r/m64 + imm8

; sub REX2
testcase	{0xD5, 0x11, 0x80, 0x29, 0xFF}, \
			{sub byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x29, 0xFF, 0xFF}, \
			{sub word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x29, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x29, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x29, 0x7F}, \
			{sub word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x29, 0x7F}, \
			{sub dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x29, 0x7F}, \
			{sub qword [r25], byte 0x7F}			;r/m64 + imm8

; sub implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x2A, 0xFF}, \
			{sub r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x2A, 0xFF, 0xFF}, \
			{sub r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x29, 0x7F}, \
			{sub r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x29, 0x7F}, \
			{sub r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x29, 0x7F}, \
			{sub r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; sub implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x2A, 0xFF}, \
			{sub{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x2A, 0xFF, 0xFF}, \
			{sub{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x29, 0x7F}, \
			{sub{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x29, 0x7F}, \
			{sub{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x29, 0x7F}, \
			{sub{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; --- tileloadd[t1] instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x7B, 0x4B, 0x0C, 0x22},		{tileloadd tmm1, [rdx]}
testcase	{0xC4, 0xE2, 0x79, 0x4B, 0x0C, 0x22},		{tileloaddt1 tmm1, [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7F, 0x08, 0x4B, 0x0C, 0x22},		{tileloadd tmm1, [r26]}
testcase	{0x62, 0xDA, 0x7D, 0x08, 0x4B, 0x0C, 0x22},		{tileloaddt1 tmm1, [r26]}

; --- tileloaddrs[t1] instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x7B, 0x4A, 0x0C, 0x22},		{tileloaddrs tmm1, [rdx]}
testcase	{0xC4, 0xE2, 0x79, 0x4A, 0x0C, 0x22},		{tileloaddrst1 tmm1, [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7F, 0x08, 0x4A, 0x0C, 0x22},		{tileloaddrs tmm1, [r26]}
testcase	{0x62, 0xDA, 0x7D, 0x08, 0x4A, 0x0C, 0x22},		{tileloaddrst1 tmm1, [r26]}

; --- tilestored instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x7A, 0x4B, 0x0C, 0x22},		{tilestored [rdx], tmm1}
; apx
testcase	{0x62, 0xDA, 0x7E, 0x08, 0x4B, 0x0C, 0x22},		{tilestored [r26], tmm1}

; --- tzcnt instruction ---
; legacy
testcase	{0x66, 0xF3, 0x0F, 0xBC, 0x0A},			{tzcnt cx, [rdx]}
testcase	{0xF3, 0x0F, 0xBC, 0x0A},			{tzcnt ecx, [rdx]}
testcase	{0xF3, 0x48, 0x0F, 0xBC, 0x0A},			{tzcnt rcx, [rdx]}

; implicit rex2 through EGPRs
testcase	{0x66, 0xF3, 0xD5, 0x91, 0xBC, 0x0A},			{tzcnt cx, [r26]}
testcase	{0xF3, 0xD5, 0x91, 0xBC, 0x0A},				{tzcnt ecx, [r26]}
testcase	{0xF3, 0xD5, 0x99, 0xBC, 0x0A},				{tzcnt rcx, [r26]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF4, 0x0A},			{tzcnt{nf} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF4, 0x0A},			{tzcnt{nf} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF4, 0x0A},			{tzcnt{nf} rcx, [rdx]}
