# JKQTPlotter: Screenshots
## Scatter Plots and Boxplots

![Scatterplots](./screen_scatter.png)

## Different Types of Barcharts

![Barcharts](./screen_barcharts.png)

## Image Plots
You can plot C-arrays as images in different color-coding styles. Diferent Overlays/masks are also available. Finally you can use LaTeX markup to format any axis/plot/tick/... label. there is an internal LaTeX parser in this package.

![Scatterplots](./screen_images_latex.png)

![Scatterplots](./imageplot.png)


## Plotting a user-defined (parsed) function
Yes, a complete math expression parser is contained!

![Function Plot](./screen_functionplot.png)

## Axis-Label styles in LogLog-Plot

![LogLog Plot](./screen_loglog.png)


## Parametrized Scatter Plots and Data Viewer
Scatter Plots can have symbols where the shape/color/size is parametrized by a data column. Also the plotter is built around an internal datastore, which you can access (readonly!!!) by a data-viewer that is accessible from the contextmenu in any plot.

![LogLog Plot](./screen_parmetrizedplots_datatable.png)

## Barcharts

![JKQTPBarVerticalGraphStacked](../doc/images/JKQTPBarVerticalGraphStacked.png)
![JKQTPBarHorizontalGraphStacked](../doc/images/JKQTPBarHorizontalGraphStacked.png)
![barchart](./barchart.png)

## Screenshots of included LaTeX renderer

![LatexRender](./mscreen_schroedinger.png)
![LatexRender](./mscreen_rottaion.png)
![LatexRender](./mscreen_maxwell.png)
![LatexRender](./mscreen_cauchy.png)
![LatexRender](./mscreen_sd.png)


## QuickFit 3.0 Screenshots
The library JKQTPlotter was developed initially as a central part of the data evaluation software for biophysics [QuickFit 3.0](https://github.com/jkriege2/QuickFit3). The latter makes heavy use of `JKQTPlotter`, `JKQTMathText` and `JKQTFastPlotter`:

![QuickFit 3.0 Screenshot](./QF3_screen_dcalc.png)
![QuickFit 3.0 Screenshot](./QF3_screen_fccsfit.png)
![QuickFit 3.0 Screenshot](./QF3_screen_fcsfit.png)
![QuickFit 3.0 Screenshot](./QF3_screen_imfccsfit.png)
![QuickFit 3.0 Screenshot](./QF3_screen_imfcs.png)
![QuickFit 3.0 Screenshot](./QF3_screen_imfcs_paramcorrelation.png)
![QuickFit 3.0 Screenshot](./QF3_screen_imfcsfit.png)
![QuickFit 3.0 Screenshot](./QF3_screen_lightsheet.png)
![QuickFit 3.0 Screenshot](./QF3_screen_maxent.png)
![QuickFit 3.0 Screenshot](./QF3_screen_msd.png)
![QuickFit 3.0 Screenshot](./QF3_screen_spectra.png)
![QuickFit 3.0 Screenshot](./QF3_screen_tableplot.png)
![QuickFit 3.0 Screenshot](./QF3_linux_screen_fcsfit.png)


