#ifndef NASM_WARNINGS_H
#define NASM_WARNINGS_H

#ifndef WARN_SHR
# error "warnings.h should only be included from within error.h"
#endif

enum warn_index {
	WARN_IDX_NONE                    =   0, /* not suppressible */
	WARN_IDX_DB_EMPTY                =   1, /* no operand for data declaration */
	WARN_IDX_EA_ABSOLUTE             =   2, /* absolute address cannot be RIP-relative */
	WARN_IDX_EA_DISPSIZE             =   3, /* displacement size ignored on absolute address */
	WARN_IDX_FLOAT_DENORM            =   4, /* floating point denormal */
	WARN_IDX_FLOAT_OVERFLOW          =   5, /* floating point overflow */
	WARN_IDX_FLOAT_TOOLONG           =   6, /* too many digits in floating-point number */
	WARN_IDX_FLOAT_UNDERFLOW         =   7, /* floating point underflow */
	WARN_IDX_FORWARD                 =   8, /* forward reference may have unpredictable results */
	WARN_IDX_LABEL_ORPHAN            =   9, /* labels alone on lines without trailing \c{:} */
	WARN_IDX_LABEL_REDEF             =  10, /* label redefined to an identical value */
	WARN_IDX_LABEL_REDEF_LATE        =  11, /* label (re)defined during code generation */
	WARN_IDX_NUMBER_DEPRECATED_HEX   =  12, /* $ prefix for hexadecimal is deprecated */
	WARN_IDX_NUMBER_OVERFLOW         =  13, /* numeric constant does not fit */
	WARN_IDX_OBSOLETE_NOP            =  14, /* instruction obsolete and is a noop on the target CPU */
	WARN_IDX_OBSOLETE_REMOVED        =  15, /* instruction obsolete and removed on the target CPU */
	WARN_IDX_OBSOLETE_VALID          =  16, /* instruction obsolete but valid on the target CPU */
	WARN_IDX_PHASE                   =  17, /* phase error during stabilization */
	WARN_IDX_PP_ELSE_ELIF            =  18, /* \c{%elif} after \c{%else} */
	WARN_IDX_PP_ELSE_ELSE            =  19, /* \c{%else} after \c{%else} */
	WARN_IDX_PP_EMPTY_BRACES         =  20, /* empty \c{%\{\}} construct */
	WARN_IDX_PP_ENVIRONMENT          =  21, /* nonexistent environment variable */
	WARN_IDX_PP_MACRO_DEF_CASE_SINGLE =  22, /* single-line macro defined both case sensitive and insensitive */
	WARN_IDX_PP_MACRO_DEF_GREEDY_SINGLE =  23, /* single-line macro */
	WARN_IDX_PP_MACRO_DEF_PARAM_SINGLE =  24, /* single-line macro defined with and without parameters */
	WARN_IDX_PP_MACRO_DEFAULTS       =  25, /* macros with more default than optional parameters */
	WARN_IDX_PP_MACRO_PARAMS_LEGACY  =  26, /* improperly calling multi-line macro for legacy support */
	WARN_IDX_PP_MACRO_PARAMS_MULTI   =  27, /* multi-line macro calls with wrong parameter count */
	WARN_IDX_PP_MACRO_PARAMS_SINGLE  =  28, /* single-line macro calls with wrong parameter count */
	WARN_IDX_PP_MACRO_REDEF_MULTI    =  29, /* redefining multi-line macro */
	WARN_IDX_PP_OPEN_BRACES          =  30, /* unterminated \c{%\{...\}} */
	WARN_IDX_PP_OPEN_BRACKETS        =  31, /* unterminated \c{%[...]} */
	WARN_IDX_PP_OPEN_STRING          =  32, /* unterminated string */
	WARN_IDX_PP_REP_NEGATIVE         =  33, /* regative \c{%rep} count */
	WARN_IDX_PP_SEL_RANGE            =  34, /* \c{%sel()} argument out of range */
	WARN_IDX_PP_TRAILING             =  35, /* trailing garbage ignored */
	WARN_IDX_PRAGMA_BAD              =  36, /* malformed \c{%pragma} */
	WARN_IDX_PRAGMA_EMPTY            =  37, /* empty \c{%pragma} directive */
	WARN_IDX_PRAGMA_NA               =  38, /* \c{%pragma} not applicable to this compilation */
	WARN_IDX_PRAGMA_UNKNOWN          =  39, /* unknown \c{%pragma} facility or directive */
	WARN_IDX_PREFIX_BND              =  40, /* invalid \c{BND} prefix */
	WARN_IDX_PREFIX_HINT_DROPPED     =  41, /* invalid branch hint prefix dropped */
	WARN_IDX_PREFIX_HLE              =  42, /* invalid HLE prefix */
	WARN_IDX_PREFIX_INVALID          =  43, /* invalid prefix for instruction */
	WARN_IDX_PREFIX_LOCK_ERROR       =  44, /* \c{LOCK} prefix on unlockable instruction */
	WARN_IDX_PREFIX_LOCK_XCHG        =  45, /* superfluous \c{LOCK} prefix on \c{XCHG} instruction */
	WARN_IDX_PREFIX_OPSIZE           =  46, /* invalid operand size prefix */
	WARN_IDX_PREFIX_SEG              =  47, /* segment prefix ignored in 64-bit mode */
	WARN_IDX_PTR                     =  48, /* non-NASM keyword used in other assemblers */
	WARN_IDX_REGSIZE                 =  49, /* register size specification ignored */
	WARN_IDX_RELOC_ABS_BYTE          =  50, /* 8-bit absolute section-crossing relocation */
	WARN_IDX_RELOC_ABS_DWORD         =  51, /* 32-bit absolute section-crossing relocation */
	WARN_IDX_RELOC_ABS_QWORD         =  52, /* 64-bit absolute section-crossing relocation */
	WARN_IDX_RELOC_ABS_WORD          =  53, /* 16-bit absolute section-crossing relocation */
	WARN_IDX_RELOC_REL_BYTE          =  54, /* 8-bit relative section-crossing relocation */
	WARN_IDX_RELOC_REL_DWORD         =  55, /* 32-bit relative section-crossing relocation */
	WARN_IDX_RELOC_REL_QWORD         =  56, /* 64-bit relative section-crossing relocation */
	WARN_IDX_RELOC_REL_WORD          =  57, /* 16-bit relative section-crossing relocation */
	WARN_IDX_SECTION_ALIGNMENT_ROUNDED =  58, /* section alignment rounded up */
	WARN_IDX_UNKNOWN_WARNING         =  59, /* unknown warning in \c{-W}/\c{-w} or warning directive */
	WARN_IDX_USER                    =  60, /* \c{%warning} directives */
	WARN_IDX_WARN_STACK_EMPTY        =  61, /* warning stack empty */
	WARN_IDX_ZEROING                 =  62, /* \c{RES}\e{x} in initialized section becomes zero */
	WARN_IDX_ZEXT_RELOC              =  63, /* relocation zero-extended to match output format */
	WARN_IDX_OTHER                   =  64, /* any warning not specifically mentioned above */
	WARN_IDX_ALL                     =  65  /* all possible warnings */
};

enum warn_const {
	WARN_NONE                        =   0 << WARN_SHR,
	WARN_DB_EMPTY                    =   1 << WARN_SHR,
	WARN_EA_ABSOLUTE                 =   2 << WARN_SHR,
	WARN_EA_DISPSIZE                 =   3 << WARN_SHR,
	WARN_FLOAT_DENORM                =   4 << WARN_SHR,
	WARN_FLOAT_OVERFLOW              =   5 << WARN_SHR,
	WARN_FLOAT_TOOLONG               =   6 << WARN_SHR,
	WARN_FLOAT_UNDERFLOW             =   7 << WARN_SHR,
	WARN_FORWARD                     =   8 << WARN_SHR,
	WARN_LABEL_ORPHAN                =   9 << WARN_SHR,
	WARN_LABEL_REDEF                 =  10 << WARN_SHR,
	WARN_LABEL_REDEF_LATE            =  11 << WARN_SHR,
	WARN_NUMBER_DEPRECATED_HEX       =  12 << WARN_SHR,
	WARN_NUMBER_OVERFLOW             =  13 << WARN_SHR,
	WARN_OBSOLETE_NOP                =  14 << WARN_SHR,
	WARN_OBSOLETE_REMOVED            =  15 << WARN_SHR,
	WARN_OBSOLETE_VALID              =  16 << WARN_SHR,
	WARN_PHASE                       =  17 << WARN_SHR,
	WARN_PP_ELSE_ELIF                =  18 << WARN_SHR,
	WARN_PP_ELSE_ELSE                =  19 << WARN_SHR,
	WARN_PP_EMPTY_BRACES             =  20 << WARN_SHR,
	WARN_PP_ENVIRONMENT              =  21 << WARN_SHR,
	WARN_PP_MACRO_DEF_CASE_SINGLE    =  22 << WARN_SHR,
	WARN_PP_MACRO_DEF_GREEDY_SINGLE  =  23 << WARN_SHR,
	WARN_PP_MACRO_DEF_PARAM_SINGLE   =  24 << WARN_SHR,
	WARN_PP_MACRO_DEFAULTS           =  25 << WARN_SHR,
	WARN_PP_MACRO_PARAMS_LEGACY      =  26 << WARN_SHR,
	WARN_PP_MACRO_PARAMS_MULTI       =  27 << WARN_SHR,
	WARN_PP_MACRO_PARAMS_SINGLE      =  28 << WARN_SHR,
	WARN_PP_MACRO_REDEF_MULTI        =  29 << WARN_SHR,
	WARN_PP_OPEN_BRACES              =  30 << WARN_SHR,
	WARN_PP_OPEN_BRACKETS            =  31 << WARN_SHR,
	WARN_PP_OPEN_STRING              =  32 << WARN_SHR,
	WARN_PP_REP_NEGATIVE             =  33 << WARN_SHR,
	WARN_PP_SEL_RANGE                =  34 << WARN_SHR,
	WARN_PP_TRAILING                 =  35 << WARN_SHR,
	WARN_PRAGMA_BAD                  =  36 << WARN_SHR,
	WARN_PRAGMA_EMPTY                =  37 << WARN_SHR,
	WARN_PRAGMA_NA                   =  38 << WARN_SHR,
	WARN_PRAGMA_UNKNOWN              =  39 << WARN_SHR,
	WARN_PREFIX_BND                  =  40 << WARN_SHR,
	WARN_PREFIX_HINT_DROPPED         =  41 << WARN_SHR,
	WARN_PREFIX_HLE                  =  42 << WARN_SHR,
	WARN_PREFIX_INVALID              =  43 << WARN_SHR,
	WARN_PREFIX_LOCK_ERROR           =  44 << WARN_SHR,
	WARN_PREFIX_LOCK_XCHG            =  45 << WARN_SHR,
	WARN_PREFIX_OPSIZE               =  46 << WARN_SHR,
	WARN_PREFIX_SEG                  =  47 << WARN_SHR,
	WARN_PTR                         =  48 << WARN_SHR,
	WARN_REGSIZE                     =  49 << WARN_SHR,
	WARN_RELOC_ABS_BYTE              =  50 << WARN_SHR,
	WARN_RELOC_ABS_DWORD             =  51 << WARN_SHR,
	WARN_RELOC_ABS_QWORD             =  52 << WARN_SHR,
	WARN_RELOC_ABS_WORD              =  53 << WARN_SHR,
	WARN_RELOC_REL_BYTE              =  54 << WARN_SHR,
	WARN_RELOC_REL_DWORD             =  55 << WARN_SHR,
	WARN_RELOC_REL_QWORD             =  56 << WARN_SHR,
	WARN_RELOC_REL_WORD              =  57 << WARN_SHR,
	WARN_SECTION_ALIGNMENT_ROUNDED   =  58 << WARN_SHR,
	WARN_UNKNOWN_WARNING             =  59 << WARN_SHR,
	WARN_USER                        =  60 << WARN_SHR,
	WARN_WARN_STACK_EMPTY            =  61 << WARN_SHR,
	WARN_ZEROING                     =  62 << WARN_SHR,
	WARN_ZEXT_RELOC                  =  63 << WARN_SHR,
	WARN_OTHER                       =  64 << WARN_SHR
};

struct warning_alias {
	const char *name;
	enum warn_index warning;
};

#define NUM_WARNING_ALIAS 81
extern const char * const warning_name[66];
extern const char * const warning_help[66];
extern const struct warning_alias warning_alias[NUM_WARNING_ALIAS];
extern const uint8_t warning_default[65];
extern uint8_t warning_state[65];

#endif /* NASM_WARNINGS_H */
