/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <https://www.gnu.org/licenses/old-licenses/gpl-2.0>.
 */

/** @file mock_fontcache.h Mock font cache implementation definition. */

#ifndef MOCK_FONTCACHE_H
#define MOCK_FONTCACHE_H

#include "../fontcache.h"
#include "../string_func.h"

/** Font cache for mocking basic use of fonts. */
class MockFontCache : public FontCache {
public:
	MockFontCache(FontSize fs) : FontCache(fs)
	{
		this->height = FontCache::GetDefaultFontHeight(this->fs);
	}

	void ClearFontCache() override {}
	const Sprite *GetGlyph(GlyphID) override { return nullptr; }
	uint GetGlyphWidth(GlyphID) override { return this->height / 2; }
	bool GetDrawGlyphShadow() override { return false; }
	GlyphID MapCharToGlyph(char32_t key) override { return key; }
	std::string GetFontName() override { return "mock"; }
	bool IsBuiltInFont() override { return true; }

	static void InitializeFontCaches()
	{
		FontCache::caches.clear();
		for (FontSize fs = FS_BEGIN; fs != FS_END; fs++) {
			FontCache::Register(std::make_unique<MockFontCache>(fs), FontLoadReason::Default);
			FontCache::UpdateCharacterHeight(fs);
		}
	}
};

#endif /* MOCK_FONTCACHE_H */
