$NetBSD: patch-fixincludes_fixincl.x,v 1.2 2020/04/08 06:39:57 wiz Exp $

A workaround for Catalina SDK bug from
https://github.com/Homebrew/homebrew-core/pull/44762

--- fixincludes/fixincl.x.orig	2020-03-04 08:29:59.000000000 +0000
+++ fixincludes/fixincl.x
@@ -2,11 +2,11 @@
  *
  * DO NOT EDIT THIS FILE   (fixincl.x)
  *
- * It has been AutoGen-ed  January  1, 2020 at 12:04:04 PM by AutoGen 5.18.16
+ * It has been AutoGen-ed  April  8, 2020 at 05:08:04 AM by AutoGen 5.18.10
  * From the definitions    inclhack.def
  * and the template file   fixincl
  */
-/* DO NOT SVN-MERGE THIS FILE, EITHER Wed Jan  1 12:04:05 EST 2020
+/* DO NOT SVN-MERGE THIS FILE, EITHER Wed Apr  8 05:08:04 GMT 2020
  *
  * You must regenerate it.  Use the ./genfixes script.
  *
@@ -15,7 +15,7 @@
  * certain ANSI-incompatible system header files which are fixed to work
  * correctly with ANSI C and placed in a directory that GNU C will search.
  *
- * This file contains 255 fixup descriptions.
+ * This file contains 256 fixup descriptions.
  *
  * See README for more information.
  *
@@ -2589,6 +2589,48 @@ extern \"C\" {\n\
 
 /* * * * * * * * * * * * * * * * * * * * * * * * * *
  *
+ *  Description of Darwin_Availability fix
+ */
+tSCC zDarwin_AvailabilityName[] =
+     "darwin_availability";
+
+/*
+ *  File name selection pattern
+ */
+tSCC zDarwin_AvailabilityList[] =
+  "Availability.h\0";
+/*
+ *  Machine/OS name selection pattern
+ */
+tSCC* apzDarwin_AvailabilityMachs[] = {
+        "*-*-darwin*",
+        (const char*)NULL };
+
+/*
+ *  content selection pattern - do fix if pattern found
+ */
+tSCC zDarwin_AvailabilitySelect0[] =
+       "#endif /\\* __OSX_AVAILABLE_STARTING \\*/";
+
+#define    DARWIN_AVAILABILITY_TEST_CT  1
+static tTestDesc aDarwin_AvailabilityTests[] = {
+  { TT_EGREP,    zDarwin_AvailabilitySelect0, (regex_t*)NULL }, };
+
+/*
+ *  Fix Command Arguments for Darwin_Availability
+ */
+static const char* apzDarwin_AvailabilityPatch[] = {
+    "format",
+    "#endif /* __OSX_AVAILABLE_STARTING */\n\
+#ifndef __OSX_AVAILABLE_STARTING\n\
+  #define __OSX_AVAILABLE_STARTING(_osx, _ios)\n\
+  #define __OSX_AVAILABLE_BUT_DEPRECATED(_osxIntro, _osxDep, _iosIntro, _iosDep)\n\
+  #define __OSX_AVAILABLE_BUT_DEPRECATED_MSG(_osxIntro, _osxDep, _iosIntro, _iosDep, _msg)\n\
+#endif",
+    (char*)NULL };
+
+/* * * * * * * * * * * * * * * * * * * * * * * * * *
+ *
  *  Description of Darwin_Availabilityinternal fix
  */
 tSCC zDarwin_AvailabilityinternalName[] =
@@ -10356,9 +10398,9 @@ static const char* apzX11_SprintfPatch[]
  *
  *  List of all fixes
  */
-#define REGEX_COUNT          294
+#define REGEX_COUNT          295
 #define MACH_LIST_SIZE_LIMIT 187
-#define FIX_COUNT            255
+#define FIX_COUNT            256
 
 /*
  *  Enumerate the fixes
@@ -10425,6 +10467,7 @@ typedef enum {
     CTRL_QUOTES_DEF_FIXIDX,
     CTRL_QUOTES_USE_FIXIDX,
     CXX_UNREADY_FIXIDX,
+    DARWIN_AVAILABILITY_FIXIDX,
     DARWIN_AVAILABILITYINTERNAL_FIXIDX,
     DARWIN_9_LONG_DOUBLE_FUNCS_2_FIXIDX,
     DARWIN_EXTERNC_FIXIDX,
@@ -10927,6 +10970,11 @@ tFixDesc fixDescList[ FIX_COUNT ] = {
      CXX_UNREADY_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
      aCxx_UnreadyTests,   apzCxx_UnreadyPatch, 0 },
 
+  {  zDarwin_AvailabilityName,    zDarwin_AvailabilityList,
+     apzDarwin_AvailabilityMachs,
+     DARWIN_AVAILABILITY_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
+     aDarwin_AvailabilityTests,   apzDarwin_AvailabilityPatch, 0 },
+
   {  zDarwin_AvailabilityinternalName,    zDarwin_AvailabilityinternalList,
      apzDarwin_AvailabilityinternalMachs,
      DARWIN_AVAILABILITYINTERNAL_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
