$NetBSD$

- Introduce a RESOURCES_DIR similar to other *_DIR
- Add a resources_directory parameter to lookup_vendor() to avoid possible
  hardcoded directory and - if not provided - pick up the default
  RESOURCES_DIR.

Patch shared upstream via:

 <https://github.com/threat9/routersploit/pull/578>

--- routersploit/core/exploit/utils.py.orig	2018-10-17 17:30:53.000000000 +0000
+++ routersploit/core/exploit/utils.py
@@ -6,12 +6,14 @@ import random
 from functools import wraps
 
 import routersploit.modules as rsf_modules
+import routersploit.resources as resources
 import routersploit.resources.wordlists as wordlists
 
 from routersploit.core.exploit.printer import print_error, print_info
 from routersploit.core.exploit.exceptions import RoutersploitException
 
 MODULES_DIR = rsf_modules.__path__[0]
+RESOURCES_DIR = resources.__path__[0]
 WORDLISTS_DIR = wordlists.__path__[0]
 
 
@@ -211,16 +213,17 @@ def stop_after(space_number):
     return _outer_wrapper
 
 
-def lookup_vendor(addr: str) -> str:
+def lookup_vendor(addr: str, resources_directory: str = RESOURCES_DIR) -> str:
     """ Lookups vendor (manufacturer) based on MAC address
 
     :param str addr: MAC address to lookup
+    :param str resources_directory: path to resources directory
     :return str: vendor name from oui.dat database
     """
 
     addr = addr.upper().replace(":", "")
 
-    path = "./routersploit/resources/vendors/oui.dat"
+    path = os.path.join(resources_directory, "vendors/oui.dat")
     with open(path, "r") as f:
         for line in f.readlines():
             line = line.strip()
