#! /bin/bash

set -euxo pipefail

TARGETS=(core.bst flatpak-runtimes.bst flatpak-platform-extensions.bst flatpak-platform-extensions-extra.bst flatpak/platform-manifest.bst flatpak/sdk-manifest.bst vm/manifest-devel.bst vm-secure/manifest-devel.bst)

case "${ARCH}" in
    aarch64)
        TARGETS+=(vm/filesystem.bst vm/filesystem-devel.bst)
    ;;
    x86_64)
        TARGETS+=(vm/repo.bst vm/repo-devel.bst)
    ;;
    i686)
        TARGETS=(flatpak-runtimes.bst flatpak-platform-extensions.bst flatpak-platform-extensions-extra.bst)
    ;;
esac

: ${BST:=bst}
$BST -o arch "${ARCH}" build "${TARGETS[@]}"
