$NetBSD: patch-backend_epson.c,v 1.1 2024/11/01 19:27:58 triaxx Exp $

Rename send() function as it conflicts with system function on Darwin with
recent clang-16.
https://gitlab.com/sane-project/backends/-/commit/1b12daf3d521495c6fb325d82035a83f100e0cc1

--- backend/epson.c.orig	2024-11-01 18:21:24.509916894 +0000
+++ backend/epson.c
@@ -851,7 +851,7 @@ static EpsonHdrUnion command (Epson_Scan
                          SANE_Status * status);
 static SANE_Status get_identity_information (SANE_Handle handle);
 static SANE_Status get_identity2_information (SANE_Handle handle);
-static int send (Epson_Scanner * s, void *buf, size_t buf_size,
+static int scanner_send (Epson_Scanner * s, void *buf, size_t buf_size,
                  SANE_Status * status);
 static ssize_t receive (Epson_Scanner * s, void *buf, ssize_t buf_size,
                         SANE_Status * status);
@@ -880,7 +880,7 @@ static void scan_finish (Epson_Scanner *
  */
 
 static int
-send (Epson_Scanner * s, void *buf, size_t buf_size, SANE_Status * status)
+scanner_send (Epson_Scanner * s, void *buf, size_t buf_size, SANE_Status * status)
 {
   DBG (3, "send buf, size = %lu\n", (u_long) buf_size);
 
@@ -1072,12 +1072,12 @@ set_cmd (Epson_Scanner * s, u_char cmd,
   params[0] = ESC;
   params[1] = cmd;
 
-  send (s, params, 2, &status);
+  scanner_send (s, params, 2, &status);
   if (SANE_STATUS_GOOD != (status = expect_ack (s)))
     return status;
 
   params[0] = val;
-  send (s, params, 1, &status);
+  scanner_send (s, params, 1, &status);
   status = expect_ack (s);
 
   return status;
@@ -1151,7 +1151,7 @@ set_zoom (Epson_Scanner * s, int x_zoom,
   cmd[0] = ESC;
   cmd[1] = s->hw->cmd->set_zoom;
 
-  send (s, cmd, 2, &status);
+  scanner_send (s, cmd, 2, &status);
   status = expect_ack (s);
 
   if (status != SANE_STATUS_GOOD)
@@ -1160,7 +1160,7 @@ set_zoom (Epson_Scanner * s, int x_zoom,
   params[0] = x_zoom;
   params[1] = y_zoom;
 
-  send (s, params, 2, &status);
+  scanner_send (s, params, 2, &status);
   status = expect_ack (s);
 
   return status;
@@ -1179,7 +1179,7 @@ set_resolution (Epson_Scanner * s, int x
   params[0] = ESC;
   params[1] = s->hw->cmd->set_resolution;
 
-  send (s, params, 2, &status);
+  scanner_send (s, params, 2, &status);
   status = expect_ack (s);
 
   if (status != SANE_STATUS_GOOD)
@@ -1190,7 +1190,7 @@ set_resolution (Epson_Scanner * s, int x
   params[2] = yres;
   params[3] = yres >> 8;
 
-  send (s, params, 4, &status);
+  scanner_send (s, params, 4, &status);
   status = expect_ack (s);
 
   return status;
@@ -1224,7 +1224,7 @@ set_scan_area (Epson_Scanner * s, int x,
   params[0] = ESC;
   params[1] = s->hw->cmd->set_scan_area;
 
-  send (s, params, 2, &status);
+  scanner_send (s, params, 2, &status);
   status = expect_ack (s);
   if (status != SANE_STATUS_GOOD)
     return status;
@@ -1238,7 +1238,7 @@ set_scan_area (Epson_Scanner * s, int x,
   params[6] = height;
   params[7] = height >> 8;
 
-  send (s, params, 8, &status);
+  scanner_send (s, params, 8, &status);
   status = expect_ack (s);
 
   return status;
@@ -1267,7 +1267,7 @@ set_color_correction_coefficients (Epson
   params[0] = ESC;
   params[1] = cmd;
 
-  send (s, params, 2, &status);
+  scanner_send (s, params, 2, &status);
   if (SANE_STATUS_GOOD != (status = expect_ack (s)))
     return status;
 
@@ -1285,7 +1285,7 @@ set_color_correction_coefficients (Epson
        cct[0], cct[1], cct[2], cct[3],
        cct[4], cct[5], cct[6], cct[7], cct[8]);
 
-  send (s, cct, length, &status);
+  scanner_send (s, cct, length, &status);
   status = expect_ack (s);
   DBG (1, "set_color_correction_coefficients: ending=%d.\n", status);
 
@@ -1376,11 +1376,11 @@ set_gamma_table (Epson_Scanner * s)
       }
     }
 
-    send (s, params, 2, &status);
+    scanner_send (s, params, 2, &status);
     if (SANE_STATUS_GOOD != (status = expect_ack (s)))
       return status;
 
-    send (s, gamma, length, &status);
+    scanner_send (s, gamma, length, &status);
     if (SANE_STATUS_GOOD != (status = expect_ack (s)))
       return status;
 
@@ -1621,7 +1621,7 @@ reset (Epson_Scanner * s)
       return status;
   }
 
-  send (s, param, 2, &status);
+  scanner_send (s, param, 2, &status);
   status = expect_ack (s);
 
   if (needToClose)
@@ -1658,7 +1658,7 @@ close_scanner (Epson_Scanner * s)
     param[0] = ESC;
     param[1] = s->hw->cmd->request_status;
     param[2]='\0';
-    send(s,param,2,&status);
+    scanner_send(s,param,2,&status);
     receive(s,result,4,&status);
   }
 
@@ -1782,7 +1782,7 @@ feed (Epson_Scanner * s)
 
   params[0] = cmd;
 
-  send (s, params, 1, &status);
+  scanner_send (s, params, 1, &status);
 
   if (SANE_STATUS_GOOD != (status = expect_ack (s)))
   {
@@ -1824,7 +1824,7 @@ eject (Epson_Scanner * s)
 
   params[0] = cmd;
 
-  send (s, params, 1, &status);
+  scanner_send (s, params, 1, &status);
 
   if (SANE_STATUS_GOOD != (status = expect_ack (s)))
   {
@@ -1866,7 +1866,7 @@ command (Epson_Scanner * s, u_char * cmd
 
   head = &(hdrunion->hdr);
 
-  send (s, cmd, cmd_size, status);
+  scanner_send (s, cmd, cmd_size, status);
 
   if (SANE_STATUS_GOOD != *status)
   {
@@ -1874,7 +1874,7 @@ command (Epson_Scanner * s, u_char * cmd
        it seems to fix the problem. It should not have any
        ill effects on other scanners.  */
     *status = SANE_STATUS_GOOD;
-    send (s, cmd, cmd_size, status);
+    scanner_send (s, cmd, cmd_size, status);
     if (SANE_STATUS_GOOD != *status)
       return (EpsonHdrUnion) 0;
   }
@@ -4958,7 +4958,7 @@ sane_start (SANE_Handle handle)
     params[0] = ESC;
     params[1] = s->hw->cmd->request_extended_status;
 
-    send (s, params, 2, &status);       /* send ESC f (request extended status) */
+    scanner_send (s, params, 2, &status);       /* send ESC f (request extended status) */
 
     if (SANE_STATUS_GOOD == status)
     {
@@ -4999,7 +4999,7 @@ sane_start (SANE_Handle handle)
     params[0] = ESC;
     params[1] = s->hw->cmd->request_condition;
 
-    send (s, params, 2, &status);       /* send request condition */
+    scanner_send (s, params, 2, &status);       /* send request condition */
 
     if (SANE_STATUS_GOOD != status)
       return status;
@@ -5081,7 +5081,7 @@ sane_start (SANE_Handle handle)
   params[0] = ESC;
   params[1] = s->hw->cmd->start_scanning;
 
-  send (s, params, 2, &status);
+  scanner_send (s, params, 2, &status);
 
   if (SANE_STATUS_GOOD != status)
   {
@@ -5120,7 +5120,7 @@ sane_auto_eject (Epson_Scanner * s)
 
     params[0] = cmd;
 
-    send (s, params, 1, &status);
+    scanner_send (s, params, 1, &status);
 
     if (SANE_STATUS_GOOD != (status = expect_ack (s)))
     {
@@ -5207,7 +5207,7 @@ read_data_block (Epson_Scanner * s, Epso
       param[0] = ESC;
       param[1] = s->hw->cmd->start_scanning;
 
-      send (s, param, 2, &status);
+      scanner_send (s, param, 2, &status);
 
       if (SANE_STATUS_GOOD != status)
       {
@@ -5347,7 +5347,7 @@ START_READ:
        * send the ACK signal to the scanner in order to make
        * it ready for the next data block.
        */
-      send (s, S_ACK, 1, &status);
+      scanner_send (s, S_ACK, 1, &status);
 
       /*
        * ... and request the next data block
@@ -5388,7 +5388,7 @@ START_READ:
         return status;
       }
 
-      send (s, S_ACK, 1, &status);
+      scanner_send (s, S_ACK, 1, &status);
 
       /*
        * ... and the last data block
@@ -5460,7 +5460,7 @@ START_READ:
     {
       if (s->canceling)
       {
-        send (s, S_CAN, 1, &status);
+        scanner_send (s, S_CAN, 1, &status);
         expect_ack (s);
 
         *length = 0;
@@ -5470,7 +5470,7 @@ START_READ:
         return SANE_STATUS_CANCELLED;
       }
       else
-        send (s, S_ACK, 1, &status);
+        scanner_send (s, S_ACK, 1, &status);
     }
 
     s->end = s->buf + buf_len;
@@ -6132,7 +6132,7 @@ get_identity2_information (SANE_Handle h
   param[1] = s->hw->cmd->request_identity2;
   param[2] = '\0';
 
-  send (s, param, 2, &status);
+  scanner_send (s, param, 2, &status);
 
   if (SANE_STATUS_GOOD != status)
     return status;
@@ -6234,7 +6234,7 @@ request_focus_position (SANE_Handle hand
   param[1] = s->hw->cmd->request_focus_position;
   param[2] = '\0';
 
-  send (s, param, 2, &status);
+  scanner_send (s, param, 2, &status);
 
   if (SANE_STATUS_GOOD != status)
     return status;
@@ -6287,7 +6287,7 @@ request_push_button_status (SANE_Handle
   param[1] = s->hw->cmd->request_push_button_status;
   param[2] = '\0';
 
-  send (s, param, 2, &status);
+  scanner_send (s, param, 2, &status);
 
   if (SANE_STATUS_GOOD != status)
   {
